<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            <i class="fa fa-shield"></i> Insurance Management Dashboard
            <small>Comprehensive Insurance Pricing & Policy Management System</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Insurance Dashboard</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Alert Container -->
        <div id="alertContainer"></div>

        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { 
            echo $this->session->flashdata('msg'); 
        } ?>

        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('error')): ?>
            <div class="alert alert-danger alert-dismissible">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <i class="fa fa-exclamation-triangle"></i> <?php echo $this->session->flashdata('error'); ?>
            </div>
        <?php endif; ?>

        <?php if ($this->session->flashdata('success')): ?>
            <div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <i class="fa fa-check"></i> <?php echo $this->session->flashdata('success'); ?>
            </div>
        <?php endif; ?>

        <!-- Primary Statistics Row -->
        <div class="row">
            <!-- Total Pricing Items -->
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3 id="totalItemsCount"><?php echo number_format(isset($statistics['overall']['total_items']) ? intval($statistics['overall']['total_items']) : 0); ?></h3>
                        <p>Total Pricing Items</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-list"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/insurance/pricing" class="small-box-footer">
                        View Pricing <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <!-- Insurance Companies -->
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3 id="companiesCount"><?php echo intval(isset($statistics['overall']['total_companies']) ? $statistics['overall']['total_companies'] : 0); ?></h3>
                        <p>Insurance Companies</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-building"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/insurance/companies" class="small-box-footer">
                        Manage Companies <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <!-- Item Families -->
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3 id="familiesCount"><?php echo intval(isset($statistics['overall']['total_families']) ? $statistics['overall']['total_families'] : 0); ?></h3>
                        <p>Item Families</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-tags"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/insurance/pricing?item_family=all" class="small-box-footer">
                        View Categories <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <!-- Average Price -->
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3 id="avgPriceCount">KES <?php echo number_format(isset($statistics['overall']['average_price']) ? floatval($statistics['overall']['average_price']) : 0, 0); ?></h3>
                        <p>Average Price</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-money"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/insurance/pricing_comparison" class="small-box-footer">
                        Price Analysis <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Secondary Statistics Row -->
        <div class="row">
            <!-- Recent Imports -->
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-blue">
                        <i class="fa fa-upload"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Recent Imports</span>
                        <span class="info-box-number" id="importsToday"><?php echo count($recent_imports ?? []); ?></span>
                        <div class="progress">
                            <div class="progress-bar" style="width: <?php echo min(100, count($recent_imports ?? []) * 10); ?>%"></div>
                        </div>
                        <span class="progress-description">Files processed</span>
                    </div>
                </div>
            </div>

            <!-- Price Changes -->
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-orange">
                        <i class="fa fa-exchange"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Price Changes</span>
                        <span class="info-box-number" id="changesCount"><?php echo count($recent_changes ?? []); ?></span>
                        <div class="progress">
                            <div class="progress-bar" style="width: <?php echo min(100, count($recent_changes ?? []) * 15); ?>%"></div>
                        </div>
                        <span class="progress-description">Recent updates</span>
                    </div>
                </div>
            </div>

            <!-- Pending Approvals -->
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-yellow">
                        <i class="fa fa-clock-o"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Pending Items</span>
                        <span class="info-box-number" id="pendingCount">0</span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 25%"></div>
                        </div>
                        <span class="progress-description">Awaiting approval</span>
                    </div>
                </div>
            </div>

            <!-- System Status -->
            <div class="col-lg-3 col-md-6 col-sm-6 col-xs-12">
                <div class="info-box">
                    <span class="info-box-icon bg-green">
                        <i class="fa fa-check-circle"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">System Status</span>
                        <span class="info-box-number">Active</span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 100%"></div>
                        </div>
                        <span class="progress-description">All systems operational</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Main Content Row -->
        <div class="row">
            <!-- Insurance Company Search and Management -->
            <div class="col-md-8">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-search"></i> Company Search & Pricing Management
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-box-tool" onclick="refreshCompanySearch()">
                                <i class="fa fa-refresh"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <!-- Search Form -->
                        <div class="row">
                            <div class="col-md-8">
                                <div class="form-group">
                                    <label for="companySearch">Search Insurance Company</label>
                                    <div class="input-group">
                                        <input type="text" class="form-control" id="companySearch" 
                                               placeholder="Enter company name, code, or contact..." 
                                               onkeyup="debounceCompanySearch()" autocomplete="off">
                                        <span class="input-group-btn">
                                            <button class="btn btn-default" type="button" onclick="clearCompanySearch()">
                                                <i class="fa fa-times"></i>
                                            </button>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="searchCompanyType">Search Type</label>
                                    <select class="form-control" id="searchCompanyType" onchange="onCompanySearchTypeChange()">
                                        <option value="all">All Fields</option>
                                        <option value="name">Company Name</option>
                                        <option value="code">Company Code</option>
                                        <option value="contact">Contact Person</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <!-- Search Results -->
                        <div id="companySearchResultsContainer" style="display: none;">
                            <div class="row">
                                <div class="col-md-12">
                                    <h4><i class="fa fa-list"></i> Search Results <span id="companyResultCount" class="badge bg-blue"></span></h4>
                                    <div class="table-responsive" style="max-height: 400px; overflow-y: auto;">
                                        <table class="table table-striped table-hover table-condensed">
                                            <thead>
                                                <tr>
                                                    <th width="20%">Company</th>
                                                    <th width="15%">Code</th>
                                                    <th width="20%">Contact</th>
                                                    <th width="15%">Items</th>
                                                    <th width="15%">Status</th>
                                                    <th width="15%">Action</th>
                                                </tr>
                                            </thead>
                                            <tbody id="companySearchResultsBody">
                                                <!-- Search results will be populated here -->
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Selected Company Details -->
                        <div id="selectedCompanyContainer" style="display: none;">
                            <hr>
                            <div class="row">
                                <div class="col-md-12">
                                    <h4><i class="fa fa-building"></i> Selected Company 
                                        <button class="btn btn-sm btn-warning pull-right" onclick="clearSelectedCompany()">
                                            <i class="fa fa-times"></i> Clear Selection
                                        </button>
                                    </h4>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="company-info-card">
                                        <h5><i class="fa fa-info-circle"></i> Company Information</h5>
                                        <table class="table table-bordered table-condensed">
                                            <tr><td><strong>Name:</strong></td><td id="selectedCompanyName">-</td></tr>
                                            <tr><td><strong>Code:</strong></td><td id="selectedCompanyCode">-</td></tr>
                                            <tr><td><strong>Contact Person:</strong></td><td id="selectedCompanyContact">-</td></tr>
                                            <tr><td><strong>Phone:</strong></td><td id="selectedCompanyPhone">-</td></tr>
                                            <tr><td><strong>Email:</strong></td><td id="selectedCompanyEmail">-</td></tr>
                                            <tr><td><strong>Commission Rate:</strong></td><td id="selectedCompanyCommission">-</td></tr>
                                        </table>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="company-stats-card">
                                        <h5><i class="fa fa-bar-chart"></i> Pricing Statistics</h5>
                                        <table class="table table-bordered table-condensed">
                                            <tr><td><strong>Total Items:</strong></td><td id="selectedCompanyItems">-</td></tr>
                                            <tr><td><strong>Average Price:</strong></td><td id="selectedCompanyAvgPrice">-</td></tr>
                                            <tr><td><strong>Price Range:</strong></td><td id="selectedCompanyPriceRange">-</td></tr>
                                            <tr><td><strong>Last Updated:</strong></td><td id="selectedCompanyLastUpdate">-</td></tr>
                                            <tr><td><strong>Status:</strong></td><td id="selectedCompanyStatus">-</td></tr>
                                            <tr><td><strong>Payment Terms:</strong></td><td id="selectedCompanyTerms">-</td></tr>
                                        </table>
                                    </div>
                                </div>
                            </div>

                            <!-- Insurance Action Buttons -->
                            <div class="row" style="margin-top: 15px;">
                                <div class="col-md-12">
                                    <div class="btn-group-justified">
                                        <div class="btn-group">
                                            <button class="btn btn-info" onclick="viewCompanyPricing()">
                                                <i class="fa fa-list"></i> View Pricing
                                            </button>
                                        </div>
                                        <div class="btn-group">
                                            <button class="btn btn-warning" onclick="importCompanyData()">
                                                <i class="fa fa-upload"></i> Import Data
                                            </button>
                                        </div>
                                        <div class="btn-group">
                                            <button class="btn btn-success" onclick="exportCompanyData()">
                                                <i class="fa fa-download"></i> Export Data
                                            </button>
                                        </div>
                                        <div class="btn-group">
                                            <button class="btn btn-primary" onclick="editCompanyDetails()">
                                                <i class="fa fa-edit"></i> Edit Company
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <!-- Recent Company Activities -->
                            <div class="row" style="margin-top: 20px;">
                                <div class="col-md-12">
                                    <h5><i class="fa fa-clock-o"></i> Recent Company Activities</h5>
                                    <div id="recentCompanyActivitiesContainer" class="activities-container">
                                        <div class="text-center">
                                            <i class="fa fa-spinner fa-spin"></i> Loading recent activities...
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sidebar - Quick Actions and Information -->
            <div class="col-md-4">
                <!-- Quick Actions -->
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-bolt"></i> Quick Actions
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-xs-12">
                                <a href="<?php echo base_url(); ?>admin/insurance/import_pricing" class="btn btn-block btn-primary btn-sm">
                                    <i class="fa fa-upload"></i> Import Pricing Data
                                </a>
                            </div>
                        </div>
                        <div class="row" style="margin-top: 10px;">
                            <div class="col-xs-12">
                                <a href="<?php echo base_url(); ?>admin/insurance/download_template" class="btn btn-block btn-success btn-sm">
                                    <i class="fa fa-file-excel-o"></i> Download Template
                                </a>
                            </div>
                        </div>
                        <div class="row" style="margin-top: 10px;">
                            <div class="col-xs-12">
                                <a href="<?php echo base_url(); ?>admin/insurance/pricing" class="btn btn-block btn-warning btn-sm">
                                    <i class="fa fa-table"></i> Browse All Pricing
                                </a>
                            </div>
                        </div>
                        <div class="row" style="margin-top: 10px;">
                            <div class="col-xs-12">
                                <a href="<?php echo base_url(); ?>admin/insurance/import_history" class="btn btn-block btn-danger btn-sm">
                                    <i class="fa fa-history"></i> Import History
                                </a>
                            </div>
                        </div>
                        <div class="row" style="margin-top: 10px;">
                            <div class="col-xs-12">
                                <a href="<?php echo base_url(); ?>admin/insurance/pricing_comparison" class="btn btn-block btn-info btn-sm">
                                    <i class="fa fa-balance-scale"></i> Price Comparison
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Today's Summary -->
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-calendar"></i> Today's Summary
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" onclick="refreshTodaySummary()">
                                <i class="fa fa-refresh"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="summary-item">
                            <span class="summary-label">Files Imported:</span>
                            <span class="summary-value" id="summaryImports"><?php echo count($recent_imports ?? []); ?></span>
                        </div>
                        <div class="summary-item">
                            <span class="summary-label">Price Changes:</span>
                            <span class="summary-value" id="summaryChanges"><?php echo count($recent_changes ?? []); ?></span>
                        </div>
                        <div class="summary-item">
                            <span class="summary-label">Items Processed:</span>
                            <span class="summary-value" id="summaryProcessed">0</span>
                        </div>
                        <div class="summary-item">
                            <span class="summary-label">Data Validations:</span>
                            <span class="summary-value" id="summaryValidations">0</span>
                        </div>
                        <hr>
                        <div class="summary-item">
                            <span class="summary-label">Total Companies:</span>
                            <span class="summary-value" id="summaryCompanies"><?php echo intval($statistics['overall']['total_companies'] ?? 0); ?></span>
                        </div>
                        <div class="summary-item">
                            <span class="summary-label">Total Items:</span>
                            <span class="summary-value text-blue" id="summaryItems"><?php echo number_format($statistics['overall']['total_items'] ?? 0); ?></span>
                        </div>
                    </div>
                </div>

                <!-- System Tools -->
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-wrench"></i> System Tools
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-xs-12">
                                <button type="button" class="btn btn-primary btn-block btn-sm" onclick="validateAllPricing()">
                                    <i class="fa fa-check-circle"></i> Validate All Data
                                </button>
                            </div>
                        </div>
                        <div class="row" style="margin-top: 8px;">
                            <div class="col-xs-12">
                                <button type="button" class="btn btn-warning btn-block btn-sm" onclick="cleanupOldImports()">
                                    <i class="fa fa-trash"></i> Cleanup Old Files
                                </button>
                            </div>
                        </div>
                        <div class="row" style="margin-top: 8px;">
                            <div class="col-xs-12">
                                <button type="button" class="btn btn-success btn-block btn-sm" onclick="exportSystemReport()">
                                    <i class="fa fa-file-text"></i> Export Report
                                </button>
                            </div>
                        </div>
                        <div class="row" style="margin-top: 8px;">
                            <div class="col-xs-12">
                                <button type="button" class="btn btn-info btn-block btn-sm" onclick="optimizeDatabase()">
                                    <i class="fa fa-database"></i> Optimize Database
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- System Status -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-info-circle"></i> System Status
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="status-item">
                            <i class="fa fa-check-circle text-green"></i>
                            <span>Insurance Module: Active</span>
                        </div>
                        <div class="status-item">
                            <i class="fa fa-check-circle text-green"></i>
                            <span>Database: Connected</span>
                        </div>
                        <div class="status-item">
                            <i class="fa fa-check-circle text-green"></i>
                            <span>File Upload: Ready</span>
                        </div>
                        <div class="status-item">
                            <i class="fa fa-check-circle text-green"></i>
                            <span>Data Validation: Ready</span>
                        </div>
                        <div class="status-item">
                            <i class="fa fa-check-circle text-green"></i>
                            <span>Export Functions: Ready</span>
                        </div>
                        <div class="status-item">
                            <i class="fa fa-info-circle text-blue"></i>
                            <span>Last Updated: <span id="lastUpdated"><?php echo date('H:i:s'); ?></span></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Charts and Analytics Row -->
        <div class="row">
            <div class="col-md-6">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-bar-chart"></i> Items by Insurance Company</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" onclick="refreshCompanyChart()">
                                <i class="fa fa-refresh"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <canvas id="companyChart" height="200"></canvas>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-pie-chart"></i> Items by Type</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" onclick="refreshTypeChart()">
                                <i class="fa fa-refresh"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <canvas id="typeChart" height="200"></canvas>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Activity -->
        <div class="row">
            <div class="col-md-6">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-clock-o"></i> Recent Import Activity</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" onclick="refreshImportHistory()">
                                <i class="fa fa-refresh"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($recent_imports) && is_array($recent_imports)): ?>
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>File</th>
                                            <th>Records</th>
                                            <th>Status</th>
                                            <th>Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach (array_slice($recent_imports, 0, 5) as $import): ?>
                                            <tr>
                                                <td>
                                                    <strong><?php echo htmlspecialchars($import['file_name'] ?? 'Unknown File'); ?></strong>
                                                    <br><small class="text-muted">By: <?php echo htmlspecialchars($import['imported_by_name'] ?? 'System'); ?></small>
                                                </td>
                                                <td>
                                                    <span class="badge bg-blue"><?php echo number_format(intval($import['total_records'] ?? 0)); ?></span>
                                                    <?php if (isset($import['successful_records']) && intval($import['successful_records']) > 0): ?>
                                                        <br><small class="text-success">✓ <?php echo number_format(intval($import['successful_records'])); ?></small>
                                                    <?php endif; ?>
                                                    <?php if (isset($import['failed_records']) && intval($import['failed_records']) > 0): ?>
                                                        <br><small class="text-danger">✗ <?php echo number_format(intval($import['failed_records'])); ?></small>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php
                                                    $status = $import['import_status'] ?? 'unknown';
                                                    $status_class = $status === 'completed' ? 'success' : ($status === 'failed' ? 'danger' : 'warning');
                                                    ?>
                                                    <span class="label label-<?php echo $status_class; ?>">
                                                        <?php echo ucfirst($status); ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <?php if (isset($import['created_at']) && $import['created_at']): ?>
                                                        <small><?php echo date('M j, Y H:i', strtotime($import['created_at'])); ?></small>
                                                    <?php else: ?>
                                                        <small class="text-muted">N/A</small>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-info">
                                <i class="fa fa-info-circle"></i> No import activity yet.
                                <a href="<?php echo base_url(); ?>admin/insurance/import_pricing" class="btn btn-sm btn-primary pull-right">
                                    <i class="fa fa-upload"></i> Import Data
                                </a>
                                <div class="clearfix"></div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-exchange"></i> Recent Price Changes</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" onclick="refreshPriceChanges()">
                                <i class="fa fa-refresh"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($recent_changes) && is_array($recent_changes)): ?>
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Item</th>
                                            <th>Company</th>
                                            <th>Change</th>
                                            <th>Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach (array_slice($recent_changes, 0, 5) as $change): ?>
                                            <tr>
                                                <td>
                                                    <strong><?php echo htmlspecialchars(substr($change['item_name'] ?? 'Unknown', 0, 30)); ?></strong>
                                                </td>
                                                <td>
                                                    <small><?php echo htmlspecialchars($change['company_name'] ?? 'Unknown'); ?></small>
                                                </td>
                                                <td>
                                                    <?php
                                                    $old_price = floatval($change['old_price'] ?? 0);
                                                    $new_price = floatval($change['new_price'] ?? 0);
                                                    $price_diff = $new_price - $old_price;
                                                    $change_class = $price_diff > 0 ? 'text-red' : 'text-green';
                                                    $change_icon = $price_diff > 0 ? 'fa-arrow-up' : 'fa-arrow-down';
                                                    ?>
                                                    <span class="<?php echo $change_class; ?>">
                                                        <i class="fa <?php echo $change_icon; ?>"></i>
                                                        KES <?php echo number_format(abs($price_diff), 2); ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <?php if (isset($change['created_at']) && $change['created_at']): ?>
                                                        <small><?php echo date('M j', strtotime($change['created_at'])); ?></small>
                                                    <?php else: ?>
                                                        <small class="text-muted">N/A</small>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <div class="alert alert-info">
                                <i class="fa fa-info-circle"></i> No recent price changes.
                                <a href="<?php echo base_url(); ?>admin/insurance/pricing" class="btn btn-sm btn-warning pull-right">
                                    <i class="fa fa-eye"></i> View All
                                </a>
                                <div class="clearfix"></div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Hidden Form Fields -->
<input type="hidden" id="selectedCompanyId" value="">
<input type="hidden" id="selectedCompanyCode" value="">

<!-- Import Data Modal -->
<div class="modal fade" id="importDataModal" tabindex="-1" role="dialog" aria-labelledby="importDataModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title" id="importDataModalLabel">
                    <i class="fa fa-upload"></i> Import Pricing Data
                </h4>
            </div>
            <form id="importDataForm" onsubmit="return submitImportData(event)" enctype="multipart/form-data">
                <div class="modal-body">
                    <div class="alert alert-info">
                        <i class="fa fa-info-circle"></i> 
                        Importing data for: <strong id="importCompanyName">-</strong>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="import_file">Select Excel File <span class="text-red">*</span></label>
                                <input type="file" class="form-control" id="import_file" name="import_file" 
                                       accept=".xlsx,.xls" required>
                                <small class="text-muted">Accepted formats: .xlsx, .xls (Max: 10MB)</small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="import_option">Import Option</label>
                                <select class="form-control" id="import_option" name="import_option">
                                    <option value="add">Add New Items Only</option>
                                    <option value="update">Update Existing Items</option>
                                    <option value="replace">Replace All Data</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="validate_data">Data Validation</label>
                                <select class="form-control" id="validate_data" name="validate_data">
                                    <option value="strict">Strict Validation</option>
                                    <option value="moderate">Moderate Validation</option>
                                    <option value="lenient">Lenient Validation</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="import_notes">Import Notes</label>
                        <textarea class="form-control" id="import_notes" name="import_notes" rows="3" 
                                  placeholder="Optional notes about this import..."></textarea>
                    </div>
                    
                    <input type="hidden" id="import_company_id" name="company_id">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">
                        <i class="fa fa-times"></i> Cancel
                    </button>
                    <button type="submit" class="btn btn-primary" id="importDataSubmitBtn">
                        <i class="fa fa-upload"></i> Import Data
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Export Data Modal -->
<div class="modal fade" id="exportDataModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">
                    <i class="fa fa-download"></i> Export Company Data
                </h4>
            </div>
            <div class="modal-body">
                <div class="alert alert-info">
                    <i class="fa fa-info-circle"></i> 
                    Exporting data for: <strong id="exportCompanyName">-</strong>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Export Format</label>
                            <div class="radio">
                                <label>
                                    <input type="radio" name="export_format" value="excel" checked>
                                    Excel (.xlsx)
                                </label>
                            </div>
                            <div class="radio">
                                <label>
                                    <input type="radio" name="export_format" value="csv">
                                    CSV (.csv)
                                </label>
                            </div>
                            <div class="radio">
                                <label>
                                    <input type="radio" name="export_format" value="pdf">
                                    PDF Report
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Include Data</label>
                            <div class="checkbox">
                                <label>
                                    <input type="checkbox" name="include_stats" checked>
                                    Company Statistics
                                </label>
                            </div>
                            <div class="checkbox">
                                <label>
                                    <input type="checkbox" name="include_pricing" checked>
                                    Pricing Data
                                </label>
                            </div>
                            <div class="checkbox">
                                <label>
                                    <input type="checkbox" name="include_history">
                                    Price History
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" onclick="startExport()">
                    <i class="fa fa-download"></i> Export Data
                </button>
            </div>
        </div>
    </div>
</div>

<!-- Loading Overlay -->
<div id="loadingOverlay" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 9999;">
    <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); text-align: center; color: white;">
        <i class="fa fa-spinner fa-spin fa-3x"></i>
        <div style="margin-top: 15px; font-size: 18px;">Processing...</div>
    </div>
</div>

<!-- Custom CSS -->
<style>
    .company-info-card, .company-stats-card {
        background: #f9f9f9;
        padding: 15px;
        border-radius: 5px;
        margin-bottom: 15px;
        border: 1px solid #ddd;
    }
    
    .company-info-card h5, .company-stats-card h5 {
        margin-top: 0;
        color: #333;
        border-bottom: 2px solid #3c8dbc;
        padding-bottom: 5px;
    }
    
    .activities-container {
        max-height: 300px;
        overflow-y: auto;
        border: 1px solid #ddd;
        border-radius: 5px;
        padding: 10px;
        background: #fafafa;
    }
    
    .activity-item {
        padding: 8px 0;
        border-bottom: 1px solid #eee;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }
    
    .activity-item:last-child {
        border-bottom: none;
    }
    
    .activity-item i {
        margin-right: 8px;
        width: 16px;
        text-align: center;
    }
    
    .activity-time {
        font-size: 12px;
        color: #666;
    }
    
    .summary-item {
        display: flex;
        justify-content: space-between;
        padding: 5px 0;
        border-bottom: 1px solid #f0f0f0;
    }
    
    .summary-item:last-child {
        border-bottom: none;
    }
    
    .summary-label {
        font-weight: 500;
        color: #333;
    }
    
    .summary-value {
        font-weight: bold;
        color: #3c8dbc;
    }
    
    .status-item {
        padding: 5px 0;
        display: flex;
        align-items: center;
    }
    
    .status-item i {
        margin-right: 10px;
        width: 16px;
        text-align: center;
    }
    
    .table-condensed td {
        padding: 6px;
        vertical-align: middle;
    }
    
    .btn-group-justified {
        display: flex;
        width: 100%;
    }
    
    .btn-group-justified .btn-group {
        flex: 1;
        margin-right: 5px;
    }
    
    .btn-group-justified .btn-group:last-child {
        margin-right: 0;
    }
    
    .btn-group-justified .btn {
        width: 100%;
    }
    
    .search-loading {
        text-align: center;
        padding: 20px;
        color: #666;
    }
    
    .search-no-results {
        text-align: center;
        padding: 20px;
        color: #999;
    }
    
    .modal-header {
        background: #f5f5f5;
        border-bottom: 1px solid #ddd;
    }
    
    .modal-title {
        color: #333;
        font-weight: 600;
    }
    
    .form-group label {
        font-weight: 600;
        color: #333;
    }
    
    .text-red {
        color: #dd4b39 !important;
    }
    
    .alert {
        margin-bottom: 15px;
    }
    
    .table-hover tbody tr:hover {
        background-color: #f5f5f5;
    }
    
    .badge {
        font-size: 11px;
        padding: 3px 6px;
    }
    
    .input-group-btn .btn {
        height: 34px;
    }
    
    #companySearchResultsContainer {
        animation: fadeIn 0.3s ease-in-out;
    }
    
    #selectedCompanyContainer {
        animation: slideDown 0.3s ease-in-out;
    }
    
    @keyframes fadeIn {
        from { opacity: 0; }
        to { opacity: 1; }
    }
    
    @keyframes slideDown {
        from { 
            opacity: 0;
            transform: translateY(-10px);
        }
        to { 
            opacity: 1;
            transform: translateY(0);
        }
    }
    
    .small-box .inner h3 {
        font-size: 38px;
        font-weight: bold;
        margin: 0;
    }
    
    .info-box .info-box-number {
        font-size: 28px;
        font-weight: bold;
    }
    
    .progress {
        height: 10px;
        margin-bottom: 5px;
    }
    
    .progress-bar {
        transition: width 0.6s ease;
    }
    
    @media (max-width: 768px) {
        .btn-group-justified {
            flex-direction: column;
        }
        
        .btn-group-justified .btn-group {
            margin-right: 0;
            margin-bottom: 5px;
        }
        
        .btn-group-justified .btn-group:last-child {
            margin-bottom: 0;
        }
        
        .company-info-card, .company-stats-card {
            margin-bottom: 10px;
        }
        
        .table-responsive {
            font-size: 12px;
        }
    }

    /* Chart container styles */
    #companyChart, #typeChart {
        max-height: 250px;
    }

    /* Pulse animation for refreshing data */
    .pulse {
        animation: pulse 1s ease-in-out;
    }
    
    @keyframes pulse {
        0% { transform: scale(1); }
        50% { transform: scale(1.05); }
        100% { transform: scale(1); }
    }
</style>

<!-- JavaScript Libraries -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.4/Chart.min.js"></script>

<!-- JavaScript -->
<script>
$(document).ready(function() {
    initializeInsuranceDashboard();
    initializeCharts();
});

// Global variables
let companySearchTimeout = null;
let selectedCompanyData = null;
let isCompanySearching = false;

// Initialize dashboard
function initializeInsuranceDashboard() {
    console.log('Initializing Insurance Dashboard...');
    
    // Set up periodic refresh
    setInterval(refreshDashboardStats, 300000); // 5 minutes
    
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();
    
    // Set focus on search input
    $('#companySearch').focus();
    
    console.log('Insurance Dashboard initialized successfully');
}

// Initialize charts
function initializeCharts() {
    // Company Chart
    const companyData = <?php echo json_encode($statistics['by_company'] ?? []); ?>;
    if (companyData && companyData.length > 0) {
        const companyCtx = document.getElementById('companyChart');
        if (companyCtx) {
            new Chart(companyCtx.getContext('2d'), {
                type: 'bar',
                data: {
                    labels: companyData.map(item => item.company_name || 'Unknown'),
                    datasets: [{
                        label: 'Number of Items',
                        data: companyData.map(item => parseInt(item.total_items) || 0),
                        backgroundColor: 'rgba(60, 141, 188, 0.8)',
                        borderColor: 'rgba(60, 141, 188, 1)',
                        borderWidth: 1
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero: true
                            }
                        }]
                    }
                }
            });
        }
    }

    // Type Chart
    const typeData = <?php echo json_encode($statistics['by_type'] ?? []); ?>;
    if (typeData && typeData.length > 0) {
        const typeCtx = document.getElementById('typeChart');
        if (typeCtx) {
            new Chart(typeCtx.getContext('2d'), {
                type: 'doughnut',
                data: {
                    labels: typeData.map(item => item.item_type || 'Unknown'),
                    datasets: [{
                        data: typeData.map(item => parseInt(item.total_items) || 0),
                        backgroundColor: [
                            'rgba(255, 99, 132, 0.8)',
                            'rgba(54, 162, 235, 0.8)',
                            'rgba(255, 205, 86, 0.8)',
                            'rgba(75, 192, 192, 0.8)',
                            'rgba(153, 102, 255, 0.8)'
                        ]
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false
                }
            });
        }
    }
}

// Debounced company search function
function debounceCompanySearch() {
    clearTimeout(companySearchTimeout);
    const searchTerm = $('#companySearch').val().trim();
    
    if (searchTerm.length < 2) {
        hideCompanySearchResults();
        return;
    }
    
    companySearchTimeout = setTimeout(() => {
        performCompanySearch(searchTerm);
    }, 300);
}

// Perform company search
function performCompanySearch(searchTerm) {
    if (isCompanySearching) return;
    
    isCompanySearching = true;
    const searchType = $('#searchCompanyType').val();
    
    // Show loading state
    showCompanySearchLoading();
    
    $.ajax({
        url: '<?php echo base_url("admin/insurance/search_companies"); ?>',
        type: 'POST',
        data: {
            search: searchTerm,
            search_type: searchType
        },
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                displayCompanySearchResults(response.companies);
                $('#companyResultCount').text(response.count);
            } else {
                showCompanySearchError(response.message);
            }
        },
        error: function(xhr, status, error) {
            console.error('Company search error:', error);
            showCompanySearchError('Search failed. Please try again.');
        },
        complete: function() {
            isCompanySearching = false;
        }
    });
}

// Show company search loading state
function showCompanySearchLoading() {
    $('#companySearchResultsContainer').show();
    $('#companySearchResultsBody').html(`
        <tr>
            <td colspan="6" class="search-loading">
                <i class="fa fa-spinner fa-spin"></i> Searching companies...
            </td>
        </tr>
    `);
}

// Display company search results
function displayCompanySearchResults(companies) {
    if (!companies || companies.length === 0) {
        $('#companySearchResultsBody').html(`
            <tr>
                <td colspan="6" class="search-no-results">
                    <i class="fa fa-search"></i> No companies found matching your search criteria.
                </td>
            </tr>
        `);
        return;
    }
    
    let html = '';
    companies.forEach(company => {
        const companyName = company.company_name || 'N/A';
        const companyCode = company.company_code || 'N/A';
        const contactPerson = company.contact_person || 'N/A';
        const itemCount = company.total_items || 0;
        const status = company.status === 'active' ? 
            '<span class="label label-success">Active</span>' : 
            '<span class="label label-warning">Inactive</span>';
        
        html += `
            <tr class="company-row" data-company-id="${company.id}">
                <td><strong>${companyName}</strong></td>
                <td>${companyCode}</td>
                <td>${contactPerson}</td>
                <td><span class="badge bg-blue">${itemCount}</span></td>
                <td>${status}</td>
                <td>
                    <button class="btn btn-sm btn-primary" onclick="selectCompany(${company.id})">
                        <i class="fa fa-building"></i> Select
                    </button>
                </td>
            </tr>
        `;
    });
    
    $('#companySearchResultsBody').html(html);
    $('#companySearchResultsContainer').show();
}

// Show company search error
function showCompanySearchError(message) {
    $('#companySearchResultsBody').html(`
        <tr>
            <td colspan="6" class="text-center text-danger">
                <i class="fa fa-exclamation-triangle"></i> ${message}
            </td>
        </tr>
    `);
}

// Hide company search results
function hideCompanySearchResults() {
    $('#companySearchResultsContainer').hide();
    $('#companySearchResultsBody').empty();
}

// Select company
function selectCompany(companyId) {
    showLoading();
    
    $.ajax({
        url: '<?php echo base_url("admin/insurance/get_company_details"); ?>',
        type: 'POST',
        data: { company_id: companyId },
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                selectedCompanyData = response.company;
                displaySelectedCompany(response.company);
                loadRecentCompanyActivities(companyId);
                hideCompanySearchResults();
                showSuccessAlert('Company selected successfully');
            } else {
                showErrorAlert(response.message);
            }
        },
        error: function() {
            showErrorAlert('Failed to load company details');
        },
        complete: function() {
            hideLoading();
        }
    });
}

// Display selected company
function displaySelectedCompany(company) {
    // Store company data
    $('#selectedCompanyId').val(company.id);
    $('#selectedCompanyCode').val(company.company_code || '');
    
    // Update company information
    $('#selectedCompanyName').text(company.company_name || 'N/A');
    $('#selectedCompanyCode').text(company.company_code || 'N/A');
    $('#selectedCompanyContact').text(company.contact_person || 'N/A');
    $('#selectedCompanyPhone').text(company.phone || 'N/A');
    $('#selectedCompanyEmail').text(company.email || 'N/A');
    $('#selectedCompanyCommission').text((company.commission_rate || 0) + '%');
    
    // Update company statistics
    $('#selectedCompanyItems').text(company.total_items || 0);
    $('#selectedCompanyAvgPrice').text('KES ' + (company.average_price ? parseFloat(company.average_price).toLocaleString() : '0'));
    $('#selectedCompanyPriceRange').text('KES ' + (company.min_price || 0) + ' - ' + (company.max_price || 0));
    $('#selectedCompanyLastUpdate').text(company.last_updated || 'N/A');
    $('#selectedCompanyStatus').html(company.status === 'active' ? '<span class="label label-success">Active</span>' : '<span class="label label-warning">Inactive</span>');
    $('#selectedCompanyTerms').text(company.payment_terms || 'N/A');
    
    // Show selected company container
    $('#selectedCompanyContainer').show();
    
    // Clear search input
    $('#companySearch').val('');
}

// Load recent company activities
function loadRecentCompanyActivities(companyId) {
    $('#recentCompanyActivitiesContainer').html(`
        <div class="text-center">
            <i class="fa fa-spinner fa-spin"></i> Loading recent activities...
        </div>
    `);
    
    // Simulate loading recent activities
    setTimeout(() => {
        $('#recentCompanyActivitiesContainer').html(`
            <div class="activity-item">
                <div>
                    <i class="fa fa-info-circle text-blue"></i>
                    <span>Company selected for management</span>
                </div>
                <div class="activity-time">Just now</div>
            </div>
            <div class="activity-item">
                <div>
                    <i class="fa fa-building text-green"></i>
                    <span>Ready for pricing operations</span>
                </div>
                <div class="activity-time">Now</div>
            </div>
            <div class="activity-item">
                <div>
                    <i class="fa fa-upload text-orange"></i>
                    <span>Import/Export functions available</span>
                </div>
                <div class="activity-time">Now</div>
            </div>
        `);
    }, 1000);
}

// Clear selected company
function clearSelectedCompany() {
    selectedCompanyData = null;
    $('#selectedCompanyId').val('');
    $('#selectedCompanyCode').val('');
    $('#selectedCompanyContainer').hide();
    $('#companySearch').focus();
}

// Clear company search
function clearCompanySearch() {
    $('#companySearch').val('');
    hideCompanySearchResults();
    $('#companySearch').focus();
}

// Refresh company search
function refreshCompanySearch() {
    const searchTerm = $('#companySearch').val().trim();
    if (searchTerm.length >= 2) {
        performCompanySearch(searchTerm);
    }
}

// Company search type change handler
function onCompanySearchTypeChange() {
    const searchTerm = $('#companySearch').val().trim();
    if (searchTerm.length >= 2) {
        performCompanySearch(searchTerm);
    }
}

// Company action functions
function viewCompanyPricing() {
    if (!selectedCompanyData) {
        showWarningAlert('Please select a company first');
        return;
    }
    
    window.location.href = '<?php echo base_url("admin/insurance/pricing?company_id="); ?>' + selectedCompanyData.id;
}

function importCompanyData() {
    if (!selectedCompanyData) {
        showWarningAlert('Please select a company first');
        return;
    }
    
    // Populate modal
    $('#importCompanyName').text(selectedCompanyData.company_name);
    $('#import_company_id').val(selectedCompanyData.id);
    
    // Show modal
    $('#importDataModal').modal('show');
}

function exportCompanyData() {
    if (!selectedCompanyData) {
        showWarningAlert('Please select a company first');
        return;
    }
    
    // Populate modal
    $('#exportCompanyName').text(selectedCompanyData.company_name);
    
    // Show modal
    $('#exportDataModal').modal('show');
}

function editCompanyDetails() {
    if (!selectedCompanyData) {
        showWarningAlert('Please select a company first');
        return;
    }
    
    window.location.href = '<?php echo base_url("admin/insurance/edit_company/"); ?>' + selectedCompanyData.id;
}

// Submit import data
function submitImportData(event) {
    event.preventDefault();
    
    const submitBtn = $('#importDataSubmitBtn');
    const originalText = submitBtn.html();
    
    submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Importing...');
    
    // Create FormData for file upload
    const formData = new FormData($('#importDataForm')[0]);
    
    $.ajax({
        url: '<?php echo base_url("admin/insurance/process_excel_upload"); ?>',
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                showSuccessAlert('Data imported successfully');
                $('#importDataModal').modal('hide');
                $('#importDataForm')[0].reset();
                refreshDashboardStats();
                refreshTodaySummary();
                
                // Update recent activities
                if (selectedCompanyData) {
                    loadRecentCompanyActivities(selectedCompanyData.id);
                }
            } else {
                showErrorAlert(response.message);
            }
        },
        error: function() {
            showErrorAlert('Failed to import data');
        },
        complete: function() {
            submitBtn.prop('disabled', false).html(originalText);
        }
    });
    
    return false;
}

// Start export
function startExport() {
    if (!selectedCompanyData) {
        showWarningAlert('Please select a company first');
        return;
    }
    
    const format = $('input[name="export_format"]:checked').val();
    const includeStats = $('input[name="include_stats"]').is(':checked');
    const includePricing = $('input[name="include_pricing"]').is(':checked');
    const includeHistory = $('input[name="include_history"]').is(':checked');
    
    const exportUrl = '<?php echo base_url("admin/insurance/export_company_data"); ?>?' + 
                     'company_id=' + selectedCompanyData.id +
                     '&format=' + format +
                     '&include_stats=' + (includeStats ? '1' : '0') +
                     '&include_pricing=' + (includePricing ? '1' : '0') +
                     '&include_history=' + (includeHistory ? '1' : '0');
    
    // Create hidden form for download
    const form = document.createElement('form');
    form.method = 'GET';
    form.action = exportUrl;
    document.body.appendChild(form);
    form.submit();
    document.body.removeChild(form);
    
    $('#exportDataModal').modal('hide');
    showSuccessAlert('Export started. Download will begin shortly.');
}

// Tool Functions (from original standalone dashboard)
function validateAllPricing() {
    if (!confirm('This will validate all pricing data. Continue?')) return;
    
    showProgress('Validating pricing data...');
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/insurance/validate_all_data',
        type: 'POST',
        dataType: 'json',
        success: function(response) {
            hideProgress();
            if (response.status === 'success') {
                showSuccessAlert('Validation completed successfully!');
            } else {
                showErrorAlert('Validation failed: ' + response.message);
            }
        },
        error: function() {
            hideProgress();
            showErrorAlert('Error occurred during validation.');
        }
    });
}

function cleanupOldImports() {
    if (!confirm('This will remove import files older than 30 days. Continue?')) return;
    
    showProgress('Cleaning up old imports...');
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/insurance/cleanup',
        type: 'POST',
        dataType: 'json',
        data: { days: 30 },
        success: function(response) {
            hideProgress();
            if (response.status === 'success') {
                showSuccessAlert('Cleanup completed successfully!');
                setTimeout(() => location.reload(), 2000);
            } else {
                showErrorAlert('Cleanup failed: ' + response.message);
            }
        },
        error: function() {
            hideProgress();
            showErrorAlert('Error occurred during cleanup.');
        }
    });
}

function exportSystemReport() {
    showProgress('Generating system report...');
    
    const form = document.createElement('form');
    form.method = 'GET';
    form.action = '<?php echo base_url(); ?>admin/insurance/export_system_report';
    document.body.appendChild(form);
    form.submit();
    document.body.removeChild(form);
    
    hideProgress();
    showSuccessAlert('Report download started...');
}

function optimizeDatabase() {
    if (!confirm('This will optimize database tables. Continue?')) return;
    
    showProgress('Optimizing database...');
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/insurance/optimize_database',
        type: 'POST',
        dataType: 'json',
        success: function(response) {
            hideProgress();
            showSuccessAlert('Database optimization completed!');
        },
        error: function() {
            hideProgress();
            showErrorAlert('Error occurred during database optimization.');
        }
    });
}

// Refresh functions
function refreshDashboardStats() {
    console.log('Refreshing dashboard statistics...');
    
    // Update last updated time
    $('#lastUpdated').text(new Date().toLocaleTimeString());
    
    // In a real implementation, this would fetch fresh data
    // For now, we'll just show a brief indicator
    $('.small-box, .info-box').addClass('pulse');
    setTimeout(() => {
        $('.small-box, .info-box').removeClass('pulse');
    }, 1000);
}

function refreshTodaySummary() {
    console.log('Refreshing today\'s summary...');
    
    // In a real implementation, this would fetch fresh summary data
    // For now, we'll just update the last updated time
    $('#lastUpdated').text(new Date().toLocaleTimeString());
}

function refreshCompanyChart() {
    console.log('Refreshing company chart...');
    // In a real implementation, would reload chart data
    $('#companyChart').closest('.box').addClass('pulse');
    setTimeout(() => {
        $('#companyChart').closest('.box').removeClass('pulse');
    }, 1000);
}

function refreshTypeChart() {
    console.log('Refreshing type chart...');
    // In a real implementation, would reload chart data
    $('#typeChart').closest('.box').addClass('pulse');
    setTimeout(() => {
        $('#typeChart').closest('.box').removeClass('pulse');
    }, 1000);
}

function refreshImportHistory() {
    console.log('Refreshing import history...');
    location.reload();
}

function refreshPriceChanges() {
    console.log('Refreshing price changes...');
    location.reload();
}

// Loading functions
function showLoading() {
    $('#loadingOverlay').show();
}

function hideLoading() {
    $('#loadingOverlay').hide();
}

// Progress functions
function showProgress(message) {
    $('body').append(`
        <div id="progressOverlay" style="position: fixed; top: 0; left: 0; width: 100%; height: 100%; 
             background: rgba(0,0,0,0.5); z-index: 9999; display: flex; align-items: center; justify-content: center;">
            <div style="background: white; padding: 20px; border-radius: 5px; text-align: center; box-shadow: 0 4px 12px rgba(0,0,0,0.3);">
                <i class="fa fa-spinner fa-spin fa-2x text-primary"></i>
                <p style="margin-top: 10px; margin-bottom: 0; font-weight: bold;">${message}</p>
            </div>
        </div>
    `);
}

function hideProgress() {
    $('#progressOverlay').remove();
}

// Alert functions
function showSuccessAlert(message) {
    showAlert(message, 'success');
}

function showErrorAlert(message) {
    showAlert(message, 'danger');
}

function showWarningAlert(message) {
    showAlert(message, 'warning');
}

function showInfoAlert(message) {
    showAlert(message, 'info');
}

function showAlert(message, type) {
    const alertClass = `alert-${type}`;
    const iconClass = type === 'success' ? 'fa-check-circle' : 
                     type === 'danger' ? 'fa-exclamation-circle' : 
                     type === 'warning' ? 'fa-warning' : 'fa-info-circle';
    
    const alertHtml = `
        <div class="alert ${alertClass} alert-dismissible" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <i class="fa ${iconClass}"></i> ${message}
        </div>
    `;
    
    // Remove existing alerts
    $('#alertContainer .alert').remove();
    
    // Add new alert
    $('#alertContainer').html(alertHtml);
    
    // Auto-remove after 5 seconds for success and info
    if (type === 'success' || type === 'info') {
        setTimeout(() => {
            $('#alertContainer .alert').fadeOut();
        }, 5000);
    }
    
    // Scroll to top to show alert
    $('html, body').animate({ scrollTop: 0 }, 300);
}

console.log('Insurance Dashboard - Nursing Style Version Loaded');
</script>