<?php
// Import History View - Place this in: application/views/admin/import/history.php
?>
<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-history"></i> Import History
            <small>Track all import activities and their results</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url('admin/dashboard'); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo site_url('admin/import'); ?>">Import</a></li>
            <li class="active">History</li>
        </ol>
    </section>

    <section class="content">
        <!-- Statistics Cards -->
        <div class="row" id="statistics-cards">
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3 id="total-imports">
                            <i class="fa fa-spinner fa-spin"></i>
                        </h3>
                        <p>Total Imports</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-upload"></i>
                    </div>
                    <div class="small-box-footer">
                        <span id="total-imports-text">Loading...</span>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3 id="successful-imports">
                            <i class="fa fa-spinner fa-spin"></i>
                        </h3>
                        <p>Successful Imports</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-check-circle"></i>
                    </div>
                    <div class="small-box-footer">
                        <span id="success-rate-text">Loading...</span>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3 id="failed-imports">
                            <i class="fa fa-spinner fa-spin"></i>
                        </h3>
                        <p>Failed Imports</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-times-circle"></i>
                    </div>
                    <div class="small-box-footer">
                        <span id="failed-imports-text">Loading...</span>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3 id="total-records">
                            <i class="fa fa-spinner fa-spin"></i>
                        </h3>
                        <p>Total Records Processed</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-database"></i>
                    </div>
                    <div class="small-box-footer">
                        <span id="total-records-text">Loading...</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="row">
            <div class="col-md-12">
                <div class="alert alert-info">
                    <h4><i class="fa fa-info-circle"></i> Quick Actions:</h4>
                    <p>
                        <a href="<?php echo site_url('admin/import/'); ?>" class="btn btn-success btn-sm">
                            <i class="fa fa-plus"></i> New Import
                        </a>
                        <button type="button" class="btn btn-info btn-sm" onclick="refreshData()">
                            <i class="fa fa-refresh"></i> Refresh Data
                        </button>
                        <button type="button" class="btn btn-warning btn-sm" onclick="showDetailedStats()">
                            <i class="fa fa-bar-chart"></i> Detailed Statistics
                        </button>
                    </p>
                </div>
            </div>
        </div>

        <!-- Filters -->
        <div class="row">
            <div class="col-md-12">
                <div class="box collapsed-box">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-filter"></i> Filter Imports</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-plus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <form id="filter-form" class="form-horizontal">
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="filter_type">Import Type</label>
                                        <select class="form-control" id="filter_type" name="filter_type">
                                            <option value="">All Types</option>
                                            <option value="nursing_consumables">Nursing Consumables</option>
                                            <option value="pharmacy_stock">Pharmacy Stock</option>
                                            <option value="lab_supplies">Lab Supplies</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="filter_status">Status</label>
                                        <select class="form-control" id="filter_status" name="filter_status">
                                            <option value="">All Status</option>
                                            <option value="completed">Completed</option>
                                            <option value="failed">Failed</option>
                                            <option value="processing">Processing</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="filter_date_from">Date From</label>
                                        <input type="date" class="form-control" id="filter_date_from" name="filter_date_from">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <label for="filter_date_to">Date To</label>
                                        <input type="date" class="form-control" id="filter_date_to" name="filter_date_to">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fa fa-search"></i> Apply Filters
                                    </button>
                                    <button type="button" class="btn btn-default" id="clear-filters">
                                        <i class="fa fa-refresh"></i> Clear Filters
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- Import History Table -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-table"></i> Import History</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-sm btn-default" onclick="refreshData()">
                                <i class="fa fa-refresh"></i> Refresh
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped table-hover" id="imports-table">
                                <thead>
                                    <tr>
                                        <th width="5%">ID</th>
                                        <th width="15%">Date/Time</th>
                                        <th width="15%">Import Type</th>
                                        <th width="20%">Filename</th>
                                        <th width="15%">Records</th>
                                        <th width="10%">Success Rate</th>
                                        <th width="10%">Status</th>
                                        <th width="10%">Actions</th>
                                    </tr>
                                </thead>
                                <tbody id="imports-table-body">
                                    <tr>
                                        <td colspan="8" class="text-center">
                                            <i class="fa fa-spinner fa-spin"></i> Loading import history...
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        
                        <!-- Pagination -->
                        <div class="row">
                            <div class="col-sm-5">
                                <div class="dataTables_info">
                                    Showing <span id="entries-start">0</span> to <span id="entries-end">0</span> 
                                    of <span id="entries-total">0</span> entries
                                </div>
                            </div>
                            <div class="col-sm-7">
                                <div class="dataTables_paginate paging_simple_numbers">
                                    <ul class="pagination" id="pagination-controls">
                                        <!-- Pagination will be generated by JavaScript -->
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- No Data Message -->
        <div class="row" id="no-data-message" style="display: none;">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-body text-center">
                        <h3><i class="fa fa-info-circle text-info"></i></h3>
                        <h4>No Import History Found</h4>
                        <p>It looks like no imports have been performed yet.</p>
                        <a href="<?php echo site_url('admin/import/'); ?>" class="btn btn-primary">
                            <i class="fa fa-plus"></i> Start Your First Import
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Error Details Modal -->
<div class="modal fade" id="error-details-modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="fa fa-exclamation-triangle"></i> Import Error Details</h4>
            </div>
            <div class="modal-body">
                <div id="error-details-content">
                    <div class="text-center">
                        <i class="fa fa-spinner fa-spin"></i> Loading error details...
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Detailed Statistics Modal -->
<div class="modal fade" id="statistics-modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="fa fa-bar-chart"></i> Detailed Import Statistics</h4>
            </div>
            <div class="modal-body">
                <div id="statistics-content">
                    <div class="text-center">
                        <i class="fa fa-spinner fa-spin"></i> Loading statistics...
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<style>
.import-stats .badge {
    margin-right: 3px;
    margin-bottom: 2px;
}

.import-type-label {
    font-size: 11px;
    padding: 4px 8px;
}

.date-display {
    font-weight: 600;
    color: #333;
}

.progress {
    margin-bottom: 5px;
    height: 18px;
}

.progress-bar {
    line-height: 18px;
    font-size: 11px;
}

.btn-group-xs > .btn {
    padding: 2px 6px;
    font-size: 11px;
    border-radius: 3px;
}

.small-box .inner h3 {
    font-size: 36px;
    font-weight: bold;
    margin: 0 0 10px 0;
}

.small-box-footer {
    text-align: center;
    padding: 5px 0;
    color: rgba(255,255,255,0.8);
    font-size: 12px;
    border-top: 1px solid rgba(255,255,255,0.1);
}

.table-responsive {
    border: 1px solid #ddd;
    border-radius: 4px;
}

.table > thead > tr > th {
    background-color: #f5f5f5;
    font-weight: 600;
    border-bottom: 2px solid #ddd;
}

.pagination {
    margin: 0;
}

.dataTables_info {
    padding-top: 8px;
    font-size: 13px;
    color: #666;
}

.error-message {
    background-color: #f8d7da;
    color: #721c24;
    padding: 15px;
    border-radius: 4px;
    border: 1px solid #f5c6cb;
    white-space: pre-wrap;
    font-family: 'Courier New', monospace;
    font-size: 12px;
    max-height: 400px;
    overflow-y: auto;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 15px;
    margin-top: 20px;
}

.stat-card {
    background: #fff;
    border: 1px solid #ddd;
    border-radius: 6px;
    padding: 20px;
    text-align: center;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.stat-card h4 {
    margin: 0 0 8px 0;
    font-size: 28px;
    font-weight: bold;
    color: #333;
}

.stat-card p {
    margin: 0;
    color: #666;
    font-size: 13px;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.status-completed { color: #00a65a; }
.status-failed { color: #dd4b39; }
.status-processing { color: #f39c12; }

.alert-info {
    border-left: 4px solid #3c8dbc;
}

.collapsed-box .box-body {
    display: none;
}

/* Loading states */
.loading-row {
    animation: pulse 1.5s ease-in-out infinite;
}

@keyframes pulse {
    0% { opacity: 1; }
    50% { opacity: 0.5; }
    100% { opacity: 1; }
}

/* Responsive design */
@media (max-width: 768px) {
    .small-box .inner h3 {
        font-size: 24px;
    }
    
    .table-responsive {
        font-size: 12px;
    }
    
    .btn-group-xs > .btn {
        padding: 1px 4px;
        font-size: 10px;
    }
    
    .small-box-footer {
        font-size: 10px;
    }
}
</style>

<script>
$(document).ready(function() {
    var currentPage = 1;
    var itemsPerPage = 25;
    
    // Initialize
    loadStatistics();
    loadImportHistory();
    
    // Filter form submission
    $('#filter-form').submit(function(e) {
        e.preventDefault();
        currentPage = 1; // Reset to first page
        loadImportHistory();
    });
    
    // Clear filters
    $('#clear-filters').click(function() {
        $('#filter-form')[0].reset();
        currentPage = 1;
        loadImportHistory();
    });
    
    // Load statistics
    function loadStatistics() {
        $.ajax({
            url: '<?php echo site_url('admin/import/get_statistics'); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    updateStatistics(response.statistics);
                } else {
                    // Show default values if no data
                    updateStatistics({
                        total_imports: 0,
                        successful_imports: 0,
                        failed_imports: 0,
                        total_records_processed: 0,
                        success_rate: 0
                    });
                }
            },
            error: function() {
                console.error('Failed to load statistics');
                // Show default values on error
                updateStatistics({
                    total_imports: 0,
                    successful_imports: 0,
                    failed_imports: 0,
                    total_records_processed: 0,
                    success_rate: 0
                });
            }
        });
    }
    
    // Load import history with filters
    function loadImportHistory() {
        var filters = {
            type: $('#filter_type').val(),
            status: $('#filter_status').val(),
            date_from: $('#filter_date_from').val(),
            date_to: $('#filter_date_to').val(),
            page: currentPage,
            limit: itemsPerPage
        };
        
        // Show loading
        $('#imports-table-body').html('<tr class="loading-row"><td colspan="8" class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading import history...</td></tr>');
        
        $.ajax({
            url: '<?php echo site_url('admin/import/get_history_ajax'); ?>',
            type: 'GET',
            data: filters,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    updateHistoryTable(response.data);
                    updatePagination(response.pagination);
                    if (response.statistics) {
                        updateStatistics(response.statistics);
                    }
                } else {
                    showNoDataMessage();
                }
            },
            error: function(xhr, status, error) {
                console.error('Failed to load import history:', error);
                showErrorMessage('Failed to load import history. Please try again.');
            }
        });
    }
    
    // Update statistics
    function updateStatistics(stats) {
        $('#total-imports').html(stats.total_imports || 0);
        $('#successful-imports').html(stats.successful_imports || 0);
        $('#failed-imports').html(stats.failed_imports || 0);
        $('#total-records').html(formatNumber(stats.total_records_processed || 0));
        
        // Update footer text
        $('#total-imports-text').text('All time imports');
        $('#success-rate-text').text((stats.success_rate || 0) + '% success rate');
        $('#failed-imports-text').text('Failed imports');
        $('#total-records-text').text('Records processed');
    }
    
    // Update history table
    function updateHistoryTable(imports) {
        var tableBody = $('#imports-table-body');
        tableBody.empty();
        
        if (imports.length === 0) {
            showNoDataMessage();
            return;
        }
        
        $('#no-data-message').hide();
        
        imports.forEach(function(importItem) {
            var row = buildTableRow(importItem);
            tableBody.append(row);
        });
    }
    
    // Build table row HTML
    function buildTableRow(importItem) {
        var successRate = importItem.records_processed > 0 ? 
            Math.round((importItem.records_successful / importItem.records_processed) * 100) : 0;
        var rateClass = successRate >= 90 ? 'success' : (successRate >= 70 ? 'warning' : 'danger');
        
        var statusLabel = getStatusLabel(importItem.status);
        var actions = buildActionButtons(importItem);
        
        return '<tr>' +
            '<td><strong>' + importItem.id + '</strong></td>' +
            '<td>' +
                '<span class="date-display" title="' + importItem.created_at + '">' + formatDate(importItem.created_at) + '</span><br>' +
                '<small class="text-muted">' + formatTime(importItem.created_at) + '</small>' +
            '</td>' +
            '<td><span class="label label-info import-type-label">' + formatImportType(importItem.import_type) + '</span></td>' +
            '<td><span title="' + importItem.filename + '">' + truncateFilename(importItem.filename, 25) + '</span></td>' +
            '<td>' +
                '<div class="import-stats">' +
                    '<span class="badge bg-blue" title="Total Processed">' + importItem.records_processed + '</span>' +
                    (importItem.records_successful > 0 ? '<span class="badge bg-green" title="Successful">' + importItem.records_successful + '</span>' : '') +
                    (importItem.records_failed > 0 ? '<span class="badge bg-red" title="Failed">' + importItem.records_failed + '</span>' : '') +
                '</div>' +
            '</td>' +
            '<td>' +
                '<div class="progress">' +
                    '<div class="progress-bar progress-bar-' + rateClass + '" style="width: ' + successRate + '%"></div>' +
                '</div>' +
                '<small><strong>' + successRate + '%</strong></small>' +
            '</td>' +
            '<td>' + statusLabel + '</td>' +
            '<td>' + actions + '</td>' +
            '</tr>';
    }
    
    // Get status label HTML
    function getStatusLabel(status) {
        switch(status) {
            case 'completed':
                return '<span class="label label-success"><i class="fa fa-check"></i> Completed</span>';
            case 'failed':
                return '<span class="label label-danger"><i class="fa fa-times"></i> Failed</span>';
            case 'processing':
                return '<span class="label label-warning"><i class="fa fa-spinner fa-spin"></i> Processing</span>';
            default:
                return '<span class="label label-default">' + status + '</span>';
        }
    }
    
    // Build action buttons
    function buildActionButtons(importItem) {
        var actions = '<div class="btn-group btn-group-xs">';
        
        // View details button
        actions += '<a href="<?php echo site_url('admin/import/view_import/'); ?>' + importItem.id + '" class="btn btn-info" title="View Details">';
        actions += '<i class="fa fa-eye"></i></a>';
        
        // Error details button for failed imports
        if (importItem.status === 'failed') {
            actions += '<button class="btn btn-warning" title="View Error Details" onclick="showErrorDetails(' + importItem.id + ')">';
            actions += '<i class="fa fa-exclamation-triangle"></i></button>';
        }
        
        // Re-import button for completed imports
        if (importItem.status === 'completed') {
            actions += '<button class="btn btn-success" title="Re-import" onclick="reImport(\'' + importItem.import_type + '\', \'' + importItem.filename + '\')">';
            actions += '<i class="fa fa-repeat"></i></button>';
        }
        
        actions += '</div>';
        return actions;
    }
    
    // Update pagination
    function updatePagination(pagination) {
        if (!pagination || pagination.total_items === 0) {
            $('#pagination-controls').empty();
            $('#entries-start').text('0');
            $('#entries-end').text('0');
            $('#entries-total').text('0');
            return;
        }
        
        var paginationHtml = '';
        
        // Previous button
        if (pagination.current_page > 1) {
            paginationHtml += '<li><a href="#" onclick="changePage(' + (pagination.current_page - 1) + ')">&laquo; Previous</a></li>';
        }
        
        // Page numbers
        var startPage = Math.max(1, pagination.current_page - 2);
        var endPage = Math.min(pagination.total_pages, pagination.current_page + 2);
        
        for (var i = startPage; i <= endPage; i++) {
            var activeClass = i === pagination.current_page ? 'active' : '';
            paginationHtml += '<li class="' + activeClass + '"><a href="#" onclick="changePage(' + i + ')">' + i + '</a></li>';
        }
        
        // Next button
        if (pagination.current_page < pagination.total_pages) {
            paginationHtml += '<li><a href="#" onclick="changePage(' + (pagination.current_page + 1) + ')">Next &raquo;</a></li>';
        }
        
        $('#pagination-controls').html(paginationHtml);
        
        // Update info
        var start = ((pagination.current_page - 1) * pagination.per_page) + 1;
        var end = Math.min(pagination.current_page * pagination.per_page, pagination.total_items);
        
        $('#entries-start').text(start);
        $('#entries-end').text(end);
        $('#entries-total').text(pagination.total_items);
    }
    
    // Show no data message
    function showNoDataMessage() {
        $('#imports-table-body').html('<tr><td colspan="8" class="text-center"><em>No import history found</em></td></tr>');
        $('#pagination-controls').empty();
        $('#entries-start').text('0');
        $('#entries-end').text('0');
        $('#entries-total').text('0');
        $('#no-data-message').show();
    }
    
    // Show error message
    function showErrorMessage(message) {
        $('#imports-table-body').html('<tr><td colspan="8" class="text-center text-danger"><i class="fa fa-exclamation-triangle"></i> ' + message + '</td></tr>');
        $('#pagination-controls').empty();
    }
    
    // Helper functions
    function formatDate(dateString) {
        var date = new Date(dateString);
        return date.toLocaleDateString('en-US', { 
            year: 'numeric', 
            month: 'short', 
            day: 'numeric' 
        });
    }
    
    function formatTime(dateString) {
        var date = new Date(dateString);
        return date.toLocaleTimeString('en-US', { 
            hour: '2-digit', 
            minute: '2-digit'
        });
    }
    
    function formatImportType(type) {
        return type.replace(/_/g, ' ').replace(/\b\w/g, l => l.toUpperCase());
    }
    
    function truncateFilename(filename, maxLength) {
        if (filename.length <= maxLength) return filename;
        return filename.substring(0, maxLength - 3) + '...';
    }
    
    function formatNumber(num) {
        return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }
    
    // Global functions for onclick events
    window.changePage = function(page) {
        currentPage = page;
        loadImportHistory();
    };
    
    window.refreshData = function() {
        loadStatistics();
        loadImportHistory();
    };
    
    window.showErrorDetails = function(importId) {
        $('#error-details-content').html('<div class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading error details...</div>');
        $('#error-details-modal').modal('show');
        
        $.ajax({
            url: '<?php echo site_url('admin/import/get_error_details/'); ?>' + importId,
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    var errorHtml = '<div class="error-message">' + response.error_message + '</div>';
                    $('#error-details-content').html(errorHtml);
                } else {
                    $('#error-details-content').html('<div class="alert alert-danger">Failed to load error details: ' + response.message + '</div>');
                }
            },
            error: function() {
                $('#error-details-content').html('<div class="alert alert-danger">Failed to load error details. Please try again.</div>');
            }
        });
    };
    
    window.reImport = function(importType, filename) {
        if (confirm('This will start a new import process with the same type. Continue?')) {
            window.location.href = '<?php echo site_url('admin/import'); ?>?type=' + importType;
        }
    };
    
    window.showDetailedStats = function() {
        $('#statistics-content').html('<div class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading detailed statistics...</div>');
        $('#statistics-modal').modal('show');
        
        $.ajax({
            url: '<?php echo site_url('admin/import/get_statistics'); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    var statsHtml = buildDetailedStatsHTML(response.statistics);
                    $('#statistics-content').html(statsHtml);
                } else {
                    $('#statistics-content').html('<div class="alert alert-warning">No detailed statistics available yet.</div>');
                }
            },
            error: function() {
                $('#statistics-content').html('<div class="alert alert-danger">Failed to load detailed statistics.</div>');
            }
        });
    };
    
    function buildDetailedStatsHTML(stats) {
        var html = '<div class="stats-grid">';
        
        // Total Imports
        html += '<div class="stat-card">';
        html += '<h4>' + (stats.total_imports || 0) + '</h4>';
        html += '<p>Total Imports</p>';
        html += '</div>';
        
        // Successful Imports
        html += '<div class="stat-card">';
        html += '<h4 class="text-success">' + (stats.successful_imports || 0) + '</h4>';
        html += '<p>Successful Imports</p>';
        html += '</div>';
        
        // Failed Imports
        html += '<div class="stat-card">';
        html += '<h4 class="text-danger">' + (stats.failed_imports || 0) + '</h4>';
        html += '<p>Failed Imports</p>';
        html += '</div>';
        
        // Success Rate
        html += '<div class="stat-card">';
        html += '<h4 class="text-info">' + (stats.success_rate || 0) + '%</h4>';
        html += '<p>Success Rate</p>';
        html += '</div>';
        
        // Total Records
        html += '<div class="stat-card">';
        html += '<h4>' + formatNumber(stats.total_records_processed || 0) + '</h4>';
        html += '<p>Total Records Processed</p>';
        html += '</div>';
        
        // Average Records per Import
        var avgRecords = stats.total_imports > 0 ? 
            Math.round((stats.total_records_processed || 0) / stats.total_imports) : 0;
        html += '<div class="stat-card">';
        html += '<h4>' + avgRecords + '</h4>';
        html += '<p>Avg Records per Import</p>';
        html += '</div>';
        
        html += '</div>';
        
        // Add some recent activity info
        html += '<div style="margin-top: 30px;">';
        html += '<h4>Quick Insights</h4>';
        html += '<ul class="list-unstyled">';
        html += '<li><i class="fa fa-check-circle text-success"></i> ' + (stats.successful_imports || 0) + ' imports completed successfully</li>';
        if (stats.failed_imports > 0) {
            html += '<li><i class="fa fa-times-circle text-danger"></i> ' + stats.failed_imports + ' imports failed</li>';
        }
        html += '<li><i class="fa fa-database text-info"></i> ' + formatNumber(stats.total_records_processed || 0) + ' total records processed</li>';
        html += '</ul>';
        html += '</div>';
        
        return html;
    }
    
    // Auto-refresh every 30 seconds if there are processing imports
    setInterval(function() {
        if ($('.fa-spinner').length > 0) {
            loadImportHistory();
        }
    }, 30000);
    
    // Initialize tooltips
    $('[title]').tooltip();
});
</script>