<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-money"></i> <?php echo $this->lang->line('payroll_management'); ?>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/dashboard"><i class="fa fa-dashboard"></i> <?php echo $this->lang->line('dashboard'); ?></a></li>
            <li><a href="<?php echo base_url(); ?>admin/hr"><i class="fa fa-users"></i> <?php echo $this->lang->line('hr'); ?></a></li>
            <li class="active"><?php echo $this->lang->line('payroll'); ?></li>
        </ol>
    </section>

    <section class="content">
        <!-- Payroll Actions Box -->
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-cogs"></i> <?php echo $this->lang->line('payroll_actions'); ?></h3>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('month'); ?></label>
                            <select class="form-control" id="payroll_month">
                                <?php for($i = 1; $i <= 12; $i++): ?>
                                    <option value="<?php echo $i; ?>" <?php echo $i == date('n') ? 'selected' : ''; ?>>
                                        <?php echo date('F', mktime(0, 0, 0, $i, 1)); ?>
                                    </option>
                                <?php endfor; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('year'); ?></label>
                            <select class="form-control" id="payroll_year">
                                <?php for($i = date('Y') - 2; $i <= date('Y') + 1; $i++): ?>
                                    <option value="<?php echo $i; ?>" <?php echo $i == date('Y') ? 'selected' : ''; ?>>
                                        <?php echo $i; ?>
                                    </option>
                                <?php endfor; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?php echo $this->lang->line('department'); ?></label>
                            <select class="form-control" id="payroll_department">
                                <option value=""><?php echo $this->lang->line('all_departments'); ?></option>
                                <?php foreach ($departments as $department): ?>
                                    <option value="<?php echo $department->id; ?>"><?php echo $department->name; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label>&nbsp;</label>
                            <div>
                                <button type="button" class="btn btn-primary btn-block" onclick="loadPayrollData()">
                                    <i class="fa fa-search"></i> <?php echo $this->lang->line('load_payroll'); ?>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-12">
                        <div class="btn-group" role="group">
                            <button type="button" class="btn btn-success" onclick="generatePayroll()">
                                <i class="fa fa-plus"></i> <?php echo $this->lang->line('generate_payroll'); ?>
                            </button>
                            <button type="button" class="btn btn-info" onclick="bulkEmailPayslips()">
                                <i class="fa fa-envelope"></i> <?php echo $this->lang->line('bulk_email_payslips'); ?>
                            </button>
                            <button type="button" class="btn btn-warning" onclick="bulkGeneratePayslips()">
                                <i class="fa fa-download"></i> <?php echo $this->lang->line('bulk_download_payslips'); ?>
                            </button>
                            <button type="button" class="btn btn-default" onclick="exportPayrollReport()">
                                <i class="fa fa-file-excel-o"></i> <?php echo $this->lang->line('export_report'); ?>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Payroll List Box -->
        <div class="box box-default">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-list"></i> <?php echo $this->lang->line('payroll_list'); ?></h3>
                <div class="box-tools pull-right">
                    <div id="payroll-summary" class="text-info">
                        <small><strong>Total: KSh <span id="total-payroll">0</span></strong></small>
                    </div>
                </div>
            </div>
            <div class="box-body">
                <div class="table-responsive">
                    <table class="table table-striped table-bordered table-hover" id="payroll-table">
                        <thead>
                            <tr>
                                <th><?php echo $this->lang->line('employee_id'); ?></th>
                                <th><?php echo $this->lang->line('name'); ?></th>
                                <th><?php echo $this->lang->line('department'); ?></th>
                                <th><?php echo $this->lang->line('working_days'); ?></th>
                                <th><?php echo $this->lang->line('worked_days'); ?></th>
                                <th><?php echo $this->lang->line('gross_salary'); ?></th>
                                <th><?php echo $this->lang->line('deductions'); ?></th>
                                <th><?php echo $this->lang->line('net_salary'); ?></th>
                                <th><?php echo $this->lang->line('status'); ?></th>
                                <th><?php echo $this->lang->line('action'); ?></th>
                            </tr>
                        </thead>
                        <tbody id="payroll-table-body">
                            <tr>
                                <td colspan="10" class="text-center">
                                    <i class="fa fa-info-circle"></i> <?php echo $this->lang->line('select_month_year_to_load_payroll'); ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Payroll Summary Box -->
        <div class="row">
            <div class="col-md-6">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-pie-chart"></i> <?php echo $this->lang->line('payroll_summary'); ?></h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="description-block border-right">
                                    <span class="description-percentage text-green"><i class="fa fa-users"></i></span>
                                    <h5 class="description-header" id="summary-staff-count">0</h5>
                                    <span class="description-text"><?php echo $this->lang->line('staff_processed'); ?></span>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="description-block">
                                    <span class="description-percentage text-blue"><i class="fa fa-money"></i></span>
                                    <h5 class="description-header" id="summary-avg-salary">KSh 0</h5>
                                    <span class="description-text"><?php echo $this->lang->line('average_salary'); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="description-block border-right">
                                    <span class="description-percentage text-yellow"><i class="fa fa-minus"></i></span>
                                    <h5 class="description-header" id="summary-total-deductions">KSh 0</h5>
                                    <span class="description-text"><?php echo $this->lang->line('total_deductions'); ?></span>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="description-block">
                                    <span class="description-percentage text-red"><i class="fa fa-calculator"></i></span>
                                    <h5 class="description-header" id="summary-total-gross">KSh 0</h5>
                                    <span class="description-text"><?php echo $this->lang->line('total_gross'); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-line-chart"></i> <?php echo $this->lang->line('statutory_remittances'); ?></h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="description-block border-right">
                                    <span class="description-percentage text-green">PAYE</span>
                                    <h5 class="description-header" id="summary-paye">KSh 0</h5>
                                    <span class="description-text"><?php echo $this->lang->line('income_tax'); ?></span>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="description-block">
                                    <span class="description-percentage text-blue">NSSF</span>
                                    <h5 class="description-header" id="summary-nssf">KSh 0</h5>
                                    <span class="description-text"><?php echo $this->lang->line('pension_fund'); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="description-block border-right">
                                    <span class="description-percentage text-yellow">NHIF</span>
                                    <h5 class="description-header" id="summary-nhif">KSh 0</h5>
                                    <span class="description-text"><?php echo $this->lang->line('health_insurance'); ?></span>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="description-block">
                                    <span class="description-percentage text-red">AHL</span>
                                    <h5 class="description-header" id="summary-ahl">KSh 0</h5>
                                    <span class="description-text"><?php echo $this->lang->line('housing_levy'); ?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
var currentPayrollData = [];

$(document).ready(function() {
    // Load current month's payroll by default
    loadPayrollData();
});

function loadPayrollData() {
    var month = $('#payroll_month').val();
    var year = $('#payroll_year').val();
    var department = $('#payroll_department').val();
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/hr/getPayrollList',
        type: 'POST',
        data: {
            month: month,
            year: year,
            department_id: department
        },
        dataType: 'json',
        beforeSend: function() {
            $('#payroll-table-body').html('<tr><td colspan="10" class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading...</td></tr>');
        },
        success: function(response) {
            if (response.status === 'success') {
                populatePayrollTable(response.data);
                updatePayrollSummary(response.summary);
                currentPayrollData = response.data;
            } else {
                $('#payroll-table-body').html('<tr><td colspan="10" class="text-center text-danger">' + response.message + '</td></tr>');
            }
        },
        error: function() {
            $('#payroll-table-body').html('<tr><td colspan="10" class="text-center text-danger">Failed to load payroll data</td></tr>');
        }
    });
}

function populatePayrollTable(data) {
    var tbody = $('#payroll-table-body');
    tbody.empty();
    
    if (data && data.length > 0) {
        var totalPayroll = 0;
        
        data.forEach(function(payroll) {
            totalPayroll += parseFloat(payroll.net_salary);
            
            var statusBadge = getStatusBadge(payroll.status);
            var actions = generateActionButtons(payroll);
            
            var row = '<tr>' +
                '<td>' + payroll.employee_id + '</td>' +
                '<td>' + payroll.name + ' ' + payroll.surname + '</td>' +
                '<td>' + payroll.department_name + '</td>' +
                '<td>' + payroll.working_days + '</td>' +
                '<td>' + payroll.worked_days + '</td>' +
                '<td>KSh ' + numberFormat(payroll.gross_salary) + '</td>' +
                '<td>KSh ' + numberFormat(payroll.total_deductions) + '</td>' +
                '<td><strong>KSh ' + numberFormat(payroll.net_salary) + '</strong></td>' +
                '<td>' + statusBadge + '</td>' +
                '<td>' + actions + '</td>' +
                '</tr>';
            
            tbody.append(row);
        });
        
        $('#total-payroll').text(numberFormat(totalPayroll));
    } else {
        tbody.append('<tr><td colspan="10" class="text-center">No payroll records found</td></tr>');
        $('#total-payroll').text('0');
    }
}

function getStatusBadge(status) {
    var badges = {
        'draft': '<span class="label label-warning">Draft</span>',
        'approved': '<span class="label label-success">Approved</span>',
        'paid': '<span class="label label-primary">Paid</span>'
    };
    return badges[status] || '<span class="label label-default">Unknown</span>';
}

function generateActionButtons(payroll) {
    var buttons = '<div class="btn-group btn-group-xs">';
    
    // View Payslip
    buttons += '<button type="button" class="btn btn-info" onclick="viewPayslip(' + payroll.id + ')" title="View Payslip">';
    buttons += '<i class="fa fa-eye"></i></button>';
    
    // Download PDF
    buttons += '<a href="<?php echo base_url(); ?>admin/payslip/generate/' + payroll.id + '" class="btn btn-primary" title="Download PDF" target="_blank">';
    buttons += '<i class="fa fa-download"></i></a>';
    
    // Email Payslip
    buttons += '<button type="button" class="btn btn-success" onclick="emailPayslip(' + payroll.id + ')" title="Email Payslip">';
    buttons += '<i class="fa fa-envelope"></i></button>';
    
    // Edit (if draft)
    if (payroll.status === 'draft') {
        buttons += '<button type="button" class="btn btn-warning" onclick="editPayroll(' + payroll.id + ')" title="Edit">';
        buttons += '<i class="fa fa-edit"></i></button>';
    }
    
    buttons += '</div>';
    return buttons;
}

function updatePayrollSummary(summary) {
    if (summary) {
        $('#summary-staff-count').text(summary.staff_count || 0);
        $('#summary-avg-salary').text('KSh ' + numberFormat(summary.avg_salary || 0));
        $('#summary-total-deductions').text('KSh ' + numberFormat(summary.total_deductions || 0));
        $('#summary-total-gross').text('KSh ' + numberFormat(summary.total_gross || 0));
        $('#summary-paye').text('KSh ' + numberFormat(summary.total_paye || 0));
        $('#summary-nssf').text('KSh ' + numberFormat(summary.total_nssf || 0));
        $('#summary-nhif').text('KSh ' + numberFormat(summary.total_nhif || 0));
        $('#summary-ahl').text('KSh ' + numberFormat(summary.total_ahl || 0));
    }
}

function generatePayroll() {
    var month = $('#payroll_month').val();
    var year = $('#payroll_year').val();
    var department = $('#payroll_department').val();
    
    if (confirm('Generate payroll for ' + $('#payroll_month option:selected').text() + ' ' + year + '?')) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/hr/generatePayroll',
            type: 'POST',
            data: {
                month: month,
                year: year,
                department_id: department
            },
            dataType: 'json',
            beforeSend: function() {
                showNotification('info', 'Generating payroll... Please wait.');
            },
            success: function(response) {
                if (response.status === 'success') {
                    showNotification('success', response.message);
                    loadPayrollData(); // Reload the table
                } else {
                    showNotification('error', response.message);
                }
            },
            error: function() {
                showNotification('error', 'Failed to generate payroll');
            }
        });
    }
}

function viewPayslip(payrollId) {
    window.open('<?php echo base_url(); ?>admin/hr/viewPayslip/' + payrollId, '_blank');
}

function emailPayslip(payrollId) {
    if (confirm('Send payslip via email?')) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/payslip/email/' + payrollId,
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    showNotification('success', response.message);
                } else {
                    showNotification('error', response.message);
                }
            },
            error: function() {
                showNotification('error', 'Failed to send email');
            }
        });
    }
}

function bulkEmailPayslips() {
    var month = $('#payroll_month').val();
    var year = $('#payroll_year').val();
    var department = $('#payroll_department').val();
    
    if (currentPayrollData.length === 0) {
        showNotification('warning', 'No payroll data to email');
        return;
    }
    
    if (confirm('Send payslips via email to all staff for ' + $('#payroll_month option:selected').text() + ' ' + year + '?')) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/hr/bulkEmailPayslips',
            type: 'POST',
            data: {
                month: month,
                year: year,
                department_id: department
            },
            dataType: 'json',
            beforeSend: function() {
                showNotification('info', 'Sending emails... Please wait.');
            },
            success: function(response) {
                if (response.status === 'success') {
                    showNotification('success', response.message);
                } else {
                    showNotification('error', response.message);
                }
            },
            error: function() {
                showNotification('error', 'Failed to send bulk emails');
            }
        });
    }
}

function bulkGeneratePayslips() {
    var month = $('#payroll_month').val();
    var year = $('#payroll_year').val();
    var department = $('#payroll_department').val();
    
    if (currentPayrollData.length === 0) {
        showNotification('warning', 'No payroll data to download');
        return;
    }
    
    window.location.href = '<?php echo base_url(); ?>admin/payslip/bulkGenerate?' + 
                          'month=' + month + '&year=' + year + '&department_id=' + department;
}

function exportPayrollReport() {
    var month = $('#payroll_month').val();
    var year = $('#payroll_year').val();
    var department = $('#payroll_department').val();
    
    window.location.href = '<?php echo base_url(); ?>admin/hr/exportPayrollReport?' + 
                          'month=' + month + '&year=' + year + '&department_id=' + department;
}

function editPayroll(payrollId) {
    // Implementation for editing payroll
    showNotification('info', 'Edit functionality will be implemented');
}

function numberFormat(number) {
    return parseFloat(number).toLocaleString('en-US', {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
    });
}

function showNotification(type, message) {
    // Implementation depends on your notification system
    if (type === 'success') {
        alert('Success: ' + message);
    } else if (type === 'error') {
        alert('Error: ' + message);
    } else if (type === 'warning') {
        alert('Warning: ' + message);
    } else {
        alert(message);
    }
}
</script>