<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-users"></i> HR Dashboard
            <small>Human Resources Management Overview</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/dashboard"><i class="fa fa-dashboard"></i> Dashboard</a></li>
            <li class="active">HR Dashboard</li>
        </ol>
    </section>

    <section class="content">
        <!-- Stats Row -->
        <div class="row">
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3><?php echo $stats['total_staff']; ?></h3>
                        <p>Total Staff</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-users"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/hr/staff" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3><?php echo $stats['active_staff']; ?></h3>
                        <p>Active Staff</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-user-plus"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/hr/staff" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3><?php echo $stats['on_leave_today']; ?></h3>
                        <p>On Leave Today</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-calendar-minus-o"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/hr/leave" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3><?php echo $stats['pending_leave_requests']; ?></h3>
                        <p>Pending Leave Requests</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-exclamation-triangle"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/hr/leave" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Main Row -->
        <div class="row">
            <!-- Left col -->
            <div class="col-md-8">
                <!-- Recent Hires -->
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-user-plus"></i> Recent Hires</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($recent_hires)): ?>
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Employee ID</th>
                                            <th>Name</th>
                                            <th>Department</th>
                                            <th>Role</th>
                                            <th>Joining Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($recent_hires as $hire): ?>
                                            <tr>
                                                <td><?php echo $hire->employee_id; ?></td>
                                                <td><?php echo $hire->name . ' ' . $hire->surname; ?></td>
                                                <td><?php echo $hire->department_name; ?></td>
                                                <td><?php echo $hire->role_name; ?></td>
                                                <td><?php echo date('d/m/Y', strtotime($hire->date_of_joining)); ?></td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <p class="text-muted">No recent hires found.</p>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Recent Leave Requests -->
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-calendar"></i> Recent Leave Requests</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($recent_leave_requests)): ?>
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Staff</th>
                                            <th>Leave Type</th>
                                            <th>Period</th>
                                            <th>Days</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($recent_leave_requests as $leave): ?>
                                            <tr>
                                                <td><?php echo $leave->name . ' ' . $leave->surname; ?></td>
                                                <td><?php echo $leave->leave_type_name; ?></td>
                                                <td><?php echo date('d/m/Y', strtotime($leave->start_date)) . ' - ' . date('d/m/Y', strtotime($leave->end_date)); ?></td>
                                                <td><?php echo $leave->total_days; ?> days</td>
                                                <td>
                                                    <span class="label label-<?php echo $leave->status == 'pending' ? 'warning' : ($leave->status == 'approved' ? 'success' : 'danger'); ?>">
                                                        <?php echo ucfirst($leave->status); ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <?php if ($leave->status == 'pending'): ?>
                                                        <div class="btn-group btn-group-xs">
                                                            <button class="btn btn-success" onclick="approveLeave(<?php echo $leave->id; ?>)">
                                                                <i class="fa fa-check"></i>
                                                            </button>
                                                            <button class="btn btn-danger" onclick="rejectLeave(<?php echo $leave->id; ?>)">
                                                                <i class="fa fa-times"></i>
                                                            </button>
                                                        </div>
                                                    <?php endif; ?>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php else: ?>
                            <p class="text-muted">No recent leave requests found.</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Right col -->
            <div class="col-md-4">
                <!-- Quick Actions -->
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-bolt"></i> Quick Actions</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-xs-6">
                                <a href="<?php echo base_url(); ?>admin/hr/staff" class="btn btn-app">
                                    <i class="fa fa-user-plus"></i> Add Staff
                                </a>
                            </div>
                            <div class="col-xs-6">
                                <a href="<?php echo base_url(); ?>admin/hr/payroll" class="btn btn-app">
                                    <i class="fa fa-money"></i> Generate Payroll
                                </a>
                            </div>
                            <div class="col-xs-6">
                                <a href="<?php echo base_url(); ?>admin/hr/leave" class="btn btn-app">
                                    <i class="fa fa-calendar"></i> Manage Leave
                                </a>
                            </div>
                            <div class="col-xs-6">
                                <a href="<?php echo base_url(); ?>admin/hr/attendance" class="btn btn-app">
                                    <i class="fa fa-clock-o"></i> Attendance
                                </a>
                            </div>
                            <div class="col-xs-6">
                                <a href="<?php echo base_url(); ?>admin/p9" class="btn btn-app">
                                    <i class="fa fa-file-pdf-o"></i> P9 Forms
                                </a>
                            </div>
                            <div class="col-xs-6">
                                <a href="<?php echo base_url(); ?>admin/hr/training" class="btn btn-app">
                                    <i class="fa fa-graduation-cap"></i> Training
                                </a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Compliance Alerts -->
                <div class="box box-danger">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-warning"></i> Compliance Alerts</h3>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($compliance_alerts)): ?>
                            <ul class="list-unstyled">
                                <?php foreach ($compliance_alerts as $alert): ?>
                                    <li class="margin-bottom">
                                        <span class="label label-<?php echo $alert->priority == 'high' ? 'danger' : ($alert->priority == 'medium' ? 'warning' : 'info'); ?>">
                                            <?php echo ucfirst($alert->priority); ?>
                                        </span>
                                        <?php echo $alert->message; ?>
                                        <small class="text-muted">(<?php echo $alert->alert_date; ?>)</small>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        <?php else: ?>
                            <p class="text-success"><i class="fa fa-check"></i> All compliance requirements are up to date.</p>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Upcoming Training -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-graduation-cap"></i> Upcoming Training</h3>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($upcoming_training)): ?>
                            <ul class="list-unstyled">
                                <?php foreach ($upcoming_training as $training): ?>
                                    <li class="margin-bottom">
                                        <strong><?php echo $training->course_name; ?></strong><br>
                                        <small class="text-muted">
                                            <i class="fa fa-calendar"></i> <?php echo date('d/m/Y', strtotime($training->training_date)); ?>
                                            | <i class="fa fa-clock-o"></i> <?php echo $training->duration_hours; ?>hrs
                                        </small>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        <?php else: ?>
                            <p class="text-muted">No upcoming training scheduled.</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Additional Stats Row -->
        <div class="row">
            <div class="col-md-3">
                <div class="info-box bg-purple">
                    <span class="info-box-icon"><i class="fa fa-file-text"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Expiring Contracts</span>
                        <span class="info-box-number"><?php echo $stats['expiring_contracts']; ?></span>
                        <span class="progress-description">Next 30 days</span>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="info-box bg-navy">
                    <span class="info-box-icon"><i class="fa fa-graduation-cap"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Training Due</span>
                        <span class="info-box-number"><?php echo $stats['training_due']; ?></span>
                        <span class="progress-description">Staff requiring training</span>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="info-box bg-maroon">
                    <span class="info-box-icon"><i class="fa fa-money"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Monthly Payroll</span>
                        <span class="info-box-number">KSh <?php echo number_format($stats['monthly_payroll']); ?></span>
                        <span class="progress-description">Current month</span>
                    </div>
                </div>
            </div>

            <div class="col-md-3">
                <div class="info-box bg-olive">
                    <span class="info-box-icon"><i class="fa fa-clock-o"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Attendance Rate</span>
                        <span class="info-box-number"><?php echo number_format($stats['attendance_rate'], 1); ?>%</span>
                        <span class="progress-description">Current month</span>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<script>
$(document).ready(function() {
    // Initialize dashboard
    console.log('HR Dashboard loaded');
});

function approveLeave(leaveId) {
    if (confirm('Are you sure you want to approve this leave request?')) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/hr/approveLeave/' + leaveId,
            type: 'POST',
            data: { action: 'approve', remarks: 'Approved from dashboard' },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    location.reload();
                } else {
                    alert('Error: ' + response.message);
                }
            },
            error: function() {
                alert('An error occurred while processing the request');
            }
        });
    }
}

function rejectLeave(leaveId) {
    var remarks = prompt('Please provide reason for rejection:');
    if (remarks) {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/hr/approveLeave/' + leaveId,
            type: 'POST',
            data: { action: 'reject', remarks: remarks },
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    location.reload();
                } else {
                    alert('Error: ' + response.message);
                }
            },
            error: function() {
                alert('An error occurred while processing the request');
            }
        });
    }
}
</script>