<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Front Office Dashboard - Copay & Cash Management</title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    
    <!-- Bootstrap 3.3.7 -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/bootstrap/css/bootstrap.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/font-awesome.min.css">
    <!-- AdminLTE Theme -->
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/AdminLTE.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/skins/_all-skins.min.css">
    
    <style>
        .dashboard-header {
            background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
            color: white;
            padding: 20px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        
        .stat-box {
            background: white;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            transition: transform 0.2s ease;
        }
        
        .stat-box:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.15);
        }
        
        .stat-icon {
            font-size: 3em;
            margin-bottom: 10px;
        }
        
        .stat-number {
            font-size: 2.5em;
            font-weight: bold;
            margin: 10px 0;
        }
        
        .cash-tracker {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
        }
        
        .cash-input-group {
            display: flex;
            align-items: center;
            margin: 10px 0;
        }
        
        .cash-input-group label {
            min-width: 120px;
            margin-bottom: 0;
            margin-right: 15px;
        }
        
        .cash-variance {
            font-size: 1.2em;
            font-weight: bold;
            padding: 10px;
            border-radius: 5px;
            text-align: center;
        }
        
        .variance-positive {
            background: #d4edda;
            color: #155724;
        }
        
        .variance-negative {
            background: #f8d7da;
            color: #721c24;
        }
        
        .variance-zero {
            background: #d1ecf1;
            color: #0c5460;
        }
        
        .copay-list {
            max-height: 400px;
            overflow-y: auto;
        }
        
        .copay-item {
            background: white;
            border: 1px solid #dee2e6;
            border-radius: 5px;
            padding: 15px;
            margin-bottom: 10px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .copay-patient {
            flex: 1;
        }
        
        .copay-amount {
            font-size: 1.2em;
            font-weight: bold;
            color: #28a745;
        }
        
        .quick-action-btn {
            margin: 5px;
            min-width: 120px;
        }
        
        .shift-status {
            display: inline-block;
            padding: 5px 10px;
            border-radius: 15px;
            font-size: 12px;
            font-weight: bold;
        }
        
        .shift-active { background: #d4edda; color: #155724; }
        .shift-completed { background: #d1ecf1; color: #0c5460; }
        .shift-reconciled { background: #f8d7da; color: #721c24; }
        
        .payment-method-summary {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(150px, 1fr));
            gap: 15px;
            margin: 20px 0;
        }
        
        .payment-method-card {
            background: white;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            padding: 15px;
            text-align: center;
        }
        
        .time-display {
            font-size: 1.5em;
            font-weight: bold;
            color: #28a745;
        }
    </style>
</head>

<body class="hold-transition skin-green sidebar-mini">
<div class="wrapper">
    <div class="content-wrapper">
        <section class="content-header">
            <h1>
                Front Office Dashboard
                <small>Copay Collection & Cash Management</small>
            </h1>
            <ol class="breadcrumb">
                <li><a href="#"><i class="fa fa-dashboard"></i> Home</a></li>
                <li><a href="#">Front Office</a></li>
                <li class="active">Dashboard</li>
            </ol>
        </section>

        <section class="content">
            <!-- Dashboard Header -->
            <div class="dashboard-header">
                <div class="row">
                    <div class="col-md-8">
                        <h3><i class="fa fa-user-circle"></i> Welcome, <span id="staff-name">John Doe</span></h3>
                        <p class="margin-bottom-none">Front Office Staff ID: <span id="staff-id">FO001</span> | Shift: <span class="shift-status shift-active">Active</span></p>
                    </div>
                    <div class="col-md-4 text-right">
                        <div class="time-display" id="current-time"></div>
                        <small>Current Time</small>
                    </div>
                </div>
            </div>

            <!-- Quick Stats Row -->
            <div class="row">
                <div class="col-md-3">
                    <div class="stat-box text-center">
                        <div class="stat-icon text-primary">
                            <i class="fa fa-users"></i>
                        </div>
                        <div class="stat-number text-primary" id="patients-registered">
                            <i class="fa fa-spinner fa-spin"></i>
                        </div>
                        <div>Patients Registered Today</div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stat-box text-center">
                        <div class="stat-icon text-success">
                            <i class="fa fa-money"></i>
                        </div>
                        <div class="stat-number text-success">KES <span id="cash-collected">
                            <i class="fa fa-spinner fa-spin"></i>
                        </span></div>
                        <div>Cash Collected Today</div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stat-box text-center">
                        <div class="stat-icon text-warning">
                            <i class="fa fa-credit-card"></i>
                        </div>
                        <div class="stat-number text-warning" id="copay-collections">
                            <i class="fa fa-spinner fa-spin"></i>
                        </div>
                        <div>Copay Collections</div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stat-box text-center">
                        <div class="stat-icon text-info">
                            <i class="fa fa-clock-o"></i>
                        </div>
                        <div class="stat-number text-info" id="avg-processing-time">
                            <i class="fa fa-spinner fa-spin"></i>
                        </div>
                        <div>Avg Processing Time (min)</div>
                    </div>
                </div>
            </div>

            <!-- Cash Management Section -->
            <div class="row">
                <div class="col-md-6">
                    <div class="box box-success">
                        <div class="box-header with-border">
                            <h3 class="box-title"><i class="fa fa-calculator"></i> Cash Tracker</h3>
                            <div class="box-tools pull-right">
                                <button type="button" class="btn btn-sm btn-success" id="start-shift-btn">
                                    <i class="fa fa-play"></i> Start Shift
                                </button>
                            </div>
                        </div>
                        <div class="box-body">
                            <div class="cash-tracker">
                                <div class="cash-input-group">
                                    <label>Opening Cash:</label>
                                    <div class="input-group">
                                        <span class="input-group-addon">KES</span>
                                        <input type="number" class="form-control" id="opening-cash" placeholder="0.00" min="0" step="0.01">
                                    </div>
                                </div>
                                
                                <div class="cash-input-group">
                                    <label>Cash Received:</label>
                                    <div class="input-group">
                                        <span class="input-group-addon">KES</span>
                                        <input type="text" class="form-control" id="cash-received" readonly>
                                    </div>
                                </div>
                                
                                <div class="cash-input-group">
                                    <label>Cash Dispensed:</label>
                                    <div class="input-group">
                                        <span class="input-group-addon">KES</span>
                                        <input type="number" class="form-control" id="cash-dispensed" placeholder="0.00" min="0" step="0.01">
                                    </div>
                                </div>
                                
                                <div class="cash-input-group">
                                    <label>Closing Cash:</label>
                                    <div class="input-group">
                                        <span class="input-group-addon">KES</span>
                                        <input type="number" class="form-control" id="closing-cash" placeholder="0.00" min="0" step="0.01">
                                    </div>
                                </div>
                                
                                <hr>
                                
                                <div id="cash-variance" class="cash-variance variance-zero">
                                    Variance: KES 0.00
                                </div>
                                
                                <div class="text-center" style="margin-top: 15px;">
                                    <button type="button" class="btn btn-primary" id="calculate-variance">
                                        <i class="fa fa-calculator"></i> Calculate Variance
                                    </button>
                                    <button type="button" class="btn btn-warning" id="end-shift-btn">
                                        <i class="fa fa-stop"></i> End Shift
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="box box-info">
                        <div class="box-header with-border">
                            <h3 class="box-title"><i class="fa fa-pie-chart"></i> Payment Methods Summary</h3>
                        </div>
                        <div class="box-body">
                            <div class="payment-method-summary">
                                <div class="payment-method-card">
                                    <i class="fa fa-money fa-2x text-success"></i>
                                    <h4>Cash</h4>
                                    <div class="stat-number">KES <span id="cash-total">
                                        <i class="fa fa-spinner fa-spin fa-sm"></i>
                                    </span></div>
                                    <small><span id="cash-count">-</span> transactions</small>
                                </div>
                                
                                <div class="payment-method-card">
                                    <i class="fa fa-credit-card fa-2x text-info"></i>
                                    <h4>Card</h4>
                                    <div class="stat-number">KES <span id="card-total">
                                        <i class="fa fa-spinner fa-spin fa-sm"></i>
                                    </span></div>
                                    <small><span id="card-count">-</span> transactions</small>
                                </div>
                                
                                <div class="payment-method-card">
                                    <i class="fa fa-mobile fa-2x text-warning"></i>
                                    <h4>M-Pesa</h4>
                                    <div class="stat-number">KES <span id="mpesa-total">
                                        <i class="fa fa-spinner fa-spin fa-sm"></i>
                                    </span></div>
                                    <small><span id="mpesa-count">-</span> transactions</small>
                                </div>
                                
                                <div class="payment-method-card">
                                    <i class="fa fa-file-text fa-2x text-primary"></i>
                                    <h4>Cheque</h4>
                                    <div class="stat-number">KES <span id="cheque-total">
                                        <i class="fa fa-spinner fa-spin fa-sm"></i>
                                    </span></div>
                                    <small><span id="cheque-count">-</span> transactions</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Copay Collections & Quick Actions -->
            <div class="row">
                <div class="col-md-8">
                    <div class="box box-primary">
                        <div class="box-header with-border">
                            <h3 class="box-title"><i class="fa fa-list"></i> Recent Copay Collections</h3>
                            <div class="box-tools pull-right">
                                <button type="button" class="btn btn-sm btn-primary" id="refresh-copays">
                                    <i class="fa fa-refresh"></i> Refresh
                                </button>
                            </div>
                        </div>
                        <div class="box-body">
                            <div class="copay-list" id="copay-list">
                                <div class="text-center text-muted">
                                    <i class="fa fa-spinner fa-spin"></i> Loading copay collections...
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="box box-warning">
                        <div class="box-header with-border">
                            <h3 class="box-title"><i class="fa fa-flash"></i> Quick Actions</h3>
                        </div>
                        <div class="box-body">
                            <div class="text-center">
                                <button type="button" class="btn btn-success btn-lg quick-action-btn" id="register-patient-btn">
                                    <i class="fa fa-user-plus"></i><br>Register Patient
                                </button>
                                
                                <button type="button" class="btn btn-info btn-lg quick-action-btn" id="collect-copay-btn">
                                    <i class="fa fa-money"></i><br>Collect Copay
                                </button>
                                
                                <button type="button" class="btn btn-warning btn-lg quick-action-btn" id="queue-management-btn">
                                    <i class="fa fa-users"></i><br>Queue Management
                                </button>
                                
                                <button type="button" class="btn btn-primary btn-lg quick-action-btn" id="reports-btn">
                                    <i class="fa fa-chart-bar"></i><br>Daily Reports
                                </button>
                                
                                <button type="button" class="btn btn-default btn-lg quick-action-btn" id="insurance-verify-btn">
                                    <i class="fa fa-shield"></i><br>Verify Insurance
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Shift Information -->
                    <div class="box box-default">
                        <div class="box-header with-border">
                            <h3 class="box-title"><i class="fa fa-clock-o"></i> Shift Information</h3>
                        </div>
                        <div class="box-body">
                            <div class="info-item">
                                <strong>Shift Start:</strong> <span id="shift-start">Loading...</span>
                            </div>
                            <div class="info-item">
                                <strong>Duration:</strong> <span id="shift-duration">00:00:00</span>
                            </div>
                            <div class="info-item">
                                <strong>Last Transaction:</strong> <span id="last-transaction">Loading...</span>
                            </div>
                            <div class="info-item">
                                <strong>Status:</strong> <span class="shift-status" id="shift-status">Loading...</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Activity Log -->
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-default">
                        <div class="box-header with-border">
                            <h3 class="box-title"><i class="fa fa-history"></i> Recent Activity</h3>
                        </div>
                        <div class="box-body">
                            <div class="table-responsive">
                                <table class="table table-striped" id="activity-log">
                                    <thead>
                                        <tr>
                                            <th>Time</th>
                                            <th>Activity</th>
                                            <th>Patient</th>
                                            <th>Amount</th>
                                            <th>Payment Method</th>
                                            <th>Status</th>
                                        </tr>
                                    </thead>
                                    <tbody id="activity-log-body">
                                        <tr>
                                            <td colspan="6" class="text-center text-muted">
                                                <i class="fa fa-spinner fa-spin"></i> Loading activity data...
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</div>

<!-- Copay Collection Modal -->
<div class="modal fade" id="copayModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="fa fa-money"></i> Collect Copay Payment</h4>
            </div>
            <div class="modal-body">
                <form id="copay-form">
                    <div class="form-group">
                        <label>Patient Search</label>
                        <input type="text" class="form-control" id="patient-search" placeholder="Search by name, phone, or patient ID">
                        <div id="patient-results" class="list-group" style="display: none; margin-top: 10px;"></div>
                    </div>
                    
                    <div id="patient-info" style="display: none;">
                        <div class="alert alert-info">
                            <strong>Patient:</strong> <span id="selected-patient-name"></span><br>
                            <strong>Insurance:</strong> <span id="selected-patient-insurance"></span><br>
                            <strong>Total Amount:</strong> KES <span id="selected-total-amount">0.00</span><br>
                            <strong>Insurance Coverage:</strong> KES <span id="selected-insurance-amount">0.00</span><br>
                            <strong>Copay Amount:</strong> KES <span id="selected-copay-amount">0.00</span>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label>Payment Method</label>
                        <select class="form-control" id="copay-payment-method">
                            <option value="cash">Cash</option>
                            <option value="card">Credit/Debit Card</option>
                            <option value="mobile_money">Mobile Money (M-Pesa)</option>
                            <option value="cheque">Cheque</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label>Amount Received</label>
                        <div class="input-group">
                            <span class="input-group-addon">KES</span>
                            <input type="number" class="form-control" id="amount-received" placeholder="0.00" min="0" step="0.01">
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label>Notes (Optional)</label>
                        <textarea class="form-control" id="copay-notes" rows="3" placeholder="Additional notes"></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="button" class="btn btn-success" id="process-copay">
                    <i class="fa fa-check"></i> Process Payment
                </button>
            </div>
        </div>
    </div>
</div>

<!-- jQuery -->
<script src="<?php echo base_url(); ?>backend/plugins/jQuery/jquery.min.js"></script>
<!-- Bootstrap -->
<script src="<?php echo base_url(); ?>backend/bootstrap/js/bootstrap.min.js"></script>
<!-- AdminLTE App -->
<script src="<?php echo base_url(); ?>backend/dist/js/adminlte.min.js"></script>

<script>
$(document).ready(function() {
    // Initialize dashboard
    initializeDashboard();
    
    // Update time every second
    setInterval(updateTime, 1000);
    updateTime();
    
    // Load dashboard data
    loadDashboardData();
    
    // Refresh data every 30 seconds
    setInterval(loadDashboardData, 30000);
    
    function initializeDashboard() {
        // Set staff information from PHP session
        <?php if($this->session->userdata('username')): ?>
        $('#staff-name').text('<?php echo $this->session->userdata("username"); ?>');
        <?php else: ?>
        $('#staff-name').text('Front Office Staff');
        <?php endif; ?>
        
        <?php if($this->session->userdata('employee_id')): ?>
        $('#staff-id').text('<?php echo $this->session->userdata("employee_id"); ?>');
        <?php else: ?>
        $('#staff-id').text('Not Set');
        <?php endif; ?>
    }
    
    function updateTime() {
        const now = new Date();
        const timeString = now.toLocaleTimeString();
        $('#current-time').text(timeString);
        
        // Update shift duration if shift is active
        updateShiftDuration();
    }
    
    function updateShiftDuration() {
        const shiftStart = localStorage.getItem('shift_start_time');
        if (shiftStart) {
            const start = new Date(shiftStart);
            const now = new Date();
            const duration = now - start;
            
            const hours = Math.floor(duration / (1000 * 60 * 60));
            const minutes = Math.floor((duration % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((duration % (1000 * 60)) / 1000);
            
            $('#shift-duration').text(
                String(hours).padStart(2, '0') + ':' +
                String(minutes).padStart(2, '0') + ':' +
                String(seconds).padStart(2, '0')
            );
        }
    }
    
    function loadDashboardData() {
        // Load statistics with error handling
        $.ajax({
            url: '<?php echo base_url(); ?>admin/front_office/get_dashboard_stats',
            type: 'GET',
            timeout: 10000, // 10 second timeout
            success: function(response) {
                if (response.status === 'success') {
                    updateDashboardStats(response.data);
                } else {
                    console.error('Dashboard stats error:', response.message);
                    showLoadingError('statistics');
                }
            },
            error: function(xhr, status, error) {
                console.error('Failed to load dashboard stats:', error);
                showLoadingError('statistics');
            }
        });
        
        // Load recent copay collections
        loadRecentCopays();
        
        // Load activity log
        loadActivityLog();
    }
    
    function showLoadingError(section) {
        switch(section) {
            case 'statistics':
                $('#patients-registered').html('<i class="fa fa-exclamation-triangle text-danger"></i>');
                $('#cash-collected').html('<i class="fa fa-exclamation-triangle text-danger"></i>');
                $('#copay-collections').html('<i class="fa fa-exclamation-triangle text-danger"></i>');
                $('#avg-processing-time').html('<i class="fa fa-exclamation-triangle text-danger"></i>');
                break;
            case 'copays':
                $('#copay-list').html('<div class="text-center text-danger"><i class="fa fa-exclamation-triangle"></i> Failed to load copay data</div>');
                break;
        }
    }
    
    function updateDashboardStats(data) {
        // Update main statistics
        $('#patients-registered').text(data.patients_registered || 0);
        $('#cash-collected').text((data.cash_collected || 0).toFixed(2));
        $('#copay-collections').text(data.copay_collections || 0);
        $('#avg-processing-time').text(data.avg_processing_time || 0);
        
        // Update payment method totals
        $('#cash-total').text((data.cash_total || 0).toFixed(2));
        $('#cash-count').text(data.cash_count || 0);
        $('#card-total').text((data.card_total || 0).toFixed(2));
        $('#card-count').text(data.card_count || 0);
        $('#mpesa-total').text((data.mpesa_total || 0).toFixed(2));
        $('#mpesa-count').text(data.mpesa_count || 0);
        $('#cheque-total').text((data.cheque_total || 0).toFixed(2));
        $('#cheque-count').text(data.cheque_count || 0);
        
        // Update cash received (real-time)
        $('#cash-received').val((data.cash_collected || 0).toFixed(2));
        
        // Update shift information
        updateShiftInfo(data);
    }
    
    function updateShiftInfo(data) {
        if (data.shift_info) {
            $('#shift-start').text(data.shift_info.shift_start_time || 'Not Started');
            $('#last-transaction').text(data.shift_info.last_transaction || 'None');
            
            const shiftStatus = data.shift_info.shift_status || 'inactive';
            const statusElement = $('#shift-status');
            statusElement.removeClass('shift-active shift-completed shift-reconciled');
            
            switch(shiftStatus) {
                case 'active':
                    statusElement.addClass('shift-active').text('Active');
                    break;
                case 'completed':
                    statusElement.addClass('shift-completed').text('Completed');
                    break;
                case 'reconciled':
                    statusElement.addClass('shift-reconciled').text('Reconciled');
                    break;
                default:
                    statusElement.text('Not Started');
            }
        } else {
            $('#shift-start').text('Not Started');
            $('#last-transaction').text('None');
            $('#shift-status').text('Not Started');
        }
    }
    
    function loadRecentCopays() {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/front_office/get_recent_copays',
            type: 'GET',
            timeout: 10000,
            success: function(response) {
                if (response.status === 'success' && response.data && response.data.length > 0) {
                    let html = '';
                    response.data.forEach(function(copay) {
                        const insuranceCompany = copay.organisation_name || 'Self Pay';
                        const collectionDate = new Date(copay.collection_date).toLocaleString();
                        
                        html += `
                            <div class="copay-item">
                                <div class="copay-patient">
                                    <strong>${copay.patient_name || 'Unknown Patient'}</strong><br>
                                    <small>${insuranceCompany} - ${collectionDate}</small>
                                </div>
                                <div class="copay-amount">KES ${parseFloat(copay.collected_amount || 0).toFixed(2)}</div>
                                <div>
                                    <span class="label label-success">${copay.payment_method || 'cash'}</span>
                                </div>
                            </div>
                        `;
                    });
                    $('#copay-list').html(html);
                } else {
                    $('#copay-list').html('<div class="text-center text-muted"><i class="fa fa-info-circle"></i> No copay collections yet today</div>');
                }
            },
            error: function(xhr, status, error) {
                console.error('Failed to load copay collections:', error);
                showLoadingError('copays');
            }
        });
    }
    
    function loadActivityLog() {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/front_office/get_activity_log',
            type: 'GET',
            success: function(response) {
                if (response.status === 'success' && response.data.length > 0) {
                    let html = '';
                    response.data.forEach(function(activity) {
                        html += `
                            <tr>
                                <td>${activity.time}</td>
                                <td>${activity.activity}</td>
                                <td>${activity.patient_name}</td>
                                <td>KES ${parseFloat(activity.amount || 0).toFixed(2)}</td>
                                <td><span class="label label-info">${activity.payment_method}</span></td>
                                <td><span class="label label-success">${activity.status}</span></td>
                            </tr>
                        `;
                    });
                    $('#activity-log-body').html(html);
                } else {
                    $('#activity-log-body').html('<tr><td colspan="6" class="text-center text-muted"><i class="fa fa-info-circle"></i> No activity recorded yet today</td></tr>');
                }
            },
            error: function() {
                $('#activity-log-body').html('<tr><td colspan="6" class="text-center text-danger"><i class="fa fa-exclamation-triangle"></i> Failed to load activity data</td></tr>');
            }
    
    // Start Shift
    $('#start-shift-btn').on('click', function() {
        const openingCash = parseFloat($('#opening-cash').val()) || 0;
        
        if (openingCash <= 0) {
            alert('Please enter a valid opening cash amount');
            $('#opening-cash').focus();
            return;
        }
        
        $.ajax({
            url: '<?php echo base_url(); ?>admin/front_office/start_shift',
            type: 'POST',
            data: {
                opening_cash: openingCash
            },
            success: function(response) {
                if (response.status === 'success') {
                    localStorage.setItem('shift_start_time', new Date().toISOString());
                    $('#shift-start').text(new Date().toLocaleTimeString());
                    alert('Shift started successfully!');
                    $(this).prop('disabled', true);
                } else {
                    alert('Failed to start shift: ' + response.message);
                }
            }
        });
    });
    
    // End Shift
    $('#end-shift-btn').on('click', function() {
        const closingCash = parseFloat($('#closing-cash').val()) || 0;
        
        if (closingCash <= 0) {
            alert('Please enter the closing cash amount');
            $('#closing-cash').focus();
            return;
        }
        
        if (confirm('Are you sure you want to end your shift? This will generate a reconciliation report.')) {
            $.ajax({
                url: '<?php echo base_url(); ?>admin/front_office/end_shift',
                type: 'POST',
                data: {
                    closing_cash: closingCash
                },
                success: function(response) {
                    if (response.status === 'success') {
                        localStorage.removeItem('shift_start_time');
                        alert('Shift ended successfully! Reconciliation report generated.');
                        location.reload();
                    } else {
                        alert('Failed to end shift: ' + response.message);
                    }
                }
            });
        }
    });
    
    // Calculate Cash Variance
    $('#calculate-variance').on('click', function() {
        const openingCash = parseFloat($('#opening-cash').val()) || 0;
        const cashReceived = parseFloat($('#cash-received').val()) || 0;
        const cashDispensed = parseFloat($('#cash-dispensed').val()) || 0;
        const closingCash = parseFloat($('#closing-cash').val()) || 0;
        
        const expectedCash = openingCash + cashReceived - cashDispensed;
        const variance = closingCash - expectedCash;
        
        const varianceDiv = $('#cash-variance');
        varianceDiv.text('Variance: KES ' + variance.toFixed(2));
        
        varianceDiv.removeClass('variance-positive variance-negative variance-zero');
        
        if (variance > 0) {
            varianceDiv.addClass('variance-positive');
        } else if (variance < 0) {
            varianceDiv.addClass('variance-negative');
        } else {
            varianceDiv.addClass('variance-zero');
        }
    });
    
    // Quick Action Buttons
    $('#register-patient-btn').on('click', function() {
        window.location.href = '<?php echo base_url(); ?>admin/patient/general_registration';
    });
    
    $('#collect-copay-btn').on('click', function() {
        $('#copayModal').modal('show');
    });
    
    $('#queue-management-btn').on('click', function() {
        window.location.href = '<?php echo base_url(); ?>admin/queue';
    });
    
    $('#reports-btn').on('click', function() {
        window.location.href = '<?php echo base_url(); ?>admin/front_office/reports';
    });
    
    $('#insurance-verify-btn').on('click', function() {
        window.location.href = '<?php echo base_url(); ?>admin/front_office/insurance_verification';
    });
    
    // Patient Search for Copay Collection
    $('#patient-search').on('input', function() {
        const searchTerm = $(this).val();
        
        if (searchTerm.length >= 3) {
            $.ajax({
                url: '<?php echo base_url(); ?>admin/patient/search_patients',
                type: 'GET',
                data: { search: searchTerm },
                success: function(response) {
                    if (response.status === 'success' && response.patients.length > 0) {
                        let html = '';
                        response.patients.forEach(function(patient) {
                            html += `
                                <a href="#" class="list-group-item patient-result" 
                                   data-patient-id="${patient.id}"
                                   data-patient-name="${patient.patient_name}"
                                   data-insurance="${patient.organisation_name || 'No Insurance'}"
                                   data-total="${patient.total_amount || 0}"
                                   data-insurance-amount="${patient.insurance_amount || 0}"
                                   data-copay="${patient.copay_amount || 0}">
                                    <strong>${patient.patient_name}</strong><br>
                                    <small>${patient.mobileno} - ${patient.organisation_name || 'No Insurance'}</small>
                                </a>
                            `;
                        });
                        $('#patient-results').html(html).show();
                    } else {
                        $('#patient-results').hide();
                    }
                }
            });
        } else {
            $('#patient-results').hide();
        }
    });
    
    // Select Patient from Search Results
    $(document).on('click', '.patient-result', function(e) {
        e.preventDefault();
        
        const patientId = $(this).data('patient-id');
        const patientName = $(this).data('patient-name');
        const insurance = $(this).data('insurance');
        const totalAmount = $(this).data('total');
        const insuranceAmount = $(this).data('insurance-amount');
        const copayAmount = $(this).data('copay');
        
        $('#selected-patient-name').text(patientName);
        $('#selected-patient-insurance').text(insurance);
        $('#selected-total-amount').text(parseFloat(totalAmount).toFixed(2));
        $('#selected-insurance-amount').text(parseFloat(insuranceAmount).toFixed(2));
        $('#selected-copay-amount').text(parseFloat(copayAmount).toFixed(2));
        
        $('#amount-received').val(parseFloat(copayAmount).toFixed(2));
        
        $('#patient-info').show();
        $('#patient-results').hide();
        
        // Store patient ID for processing
        $('#copay-form').data('patient-id', patientId);
    });
    
    // Process Copay Payment
    $('#process-copay').on('click', function() {
        const patientId = $('#copay-form').data('patient-id');
        const paymentMethod = $('#copay-payment-method').val();
        const amountReceived = parseFloat($('#amount-received').val()) || 0;
        const notes = $('#copay-notes').val();
        
        if (!patientId) {
            alert('Please select a patient');
            return;
        }
        
        if (amountReceived <= 0) {
            alert('Please enter a valid amount');
            $('#amount-received').focus();
            return;
        }
        
        const btn = $(this);
        const originalText = btn.html();
        btn.html('<i class="fa fa-spinner fa-spin"></i> Processing...').prop('disabled', true);
        
        $.ajax({
            url: '<?php echo base_url(); ?>admin/front_office/process_copay',
            type: 'POST',
            data: {
                patient_id: patientId,
                payment_method: paymentMethod,
                amount_received: amountReceived,
                notes: notes
            },
            success: function(response) {
                if (response.status === 'success') {
                    alert('Copay payment processed successfully!\nReceipt Number: ' + response.receipt_number);
                    $('#copayModal').modal('hide');
                    
                    // Reset form
                    $('#copay-form')[0].reset();
                    $('#patient-info').hide();
                    $('#patient-results').hide();
                    
                    // Refresh dashboard data
                    loadDashboardData();
                } else {
                    alert('Failed to process payment: ' + response.message);
                }
            },
            error: function() {
                alert('An error occurred while processing the payment');
            },
            complete: function() {
                btn.html(originalText).prop('disabled', false);
            }
        });
    });
    
    // Refresh buttons
    $('#refresh-copays').on('click', function() {
        loadRecentCopays();
    });
    
    // Auto-update received cash when cash variance is calculated
    $('#cash-received').on('change', function() {
        const openingCash = parseFloat($('#opening-cash').val()) || 0;
        const cashReceived = parseFloat($(this).val()) || 0;
        const cashDispensed = parseFloat($('#cash-dispensed').val()) || 0;
        
        if (openingCash > 0 && cashReceived > 0) {
            $('#calculate-variance').trigger('click');
        }
    });
});
</script>

</body>
</html>