<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            <i class="fa fa-cogs"></i> Financial System Setup
            <small>Initialize the financial management system</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/financial">Financial</a></li>
            <li class="active">Setup</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        
        <!-- Flash Messages -->
        <?php if ($status == 'success') : ?>
            <div class="alert alert-success alert-dismissible">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <h4><i class="icon fa fa-check"></i> Success!</h4>
                <?php echo $message; ?>
            </div>
        <?php elseif ($status == 'error') : ?>
            <div class="alert alert-danger alert-dismissible">
                <button type="button" class="close" data-dismiss="alert">&times;</button>
                <h4><i class="icon fa fa-ban"></i> Error!</h4>
                <?php echo $message; ?>
            </div>
        <?php endif; ?>

        <!-- System Status -->
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-info-circle"></i> System Status</h3>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-default btn-sm" id="refreshStatus">
                        <i class="fa fa-refresh"></i> Refresh
                    </button>
                </div>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-md-6">
                        <h4>Database Tables</h4>
                        <ul class="list-group">
                            <li class="list-group-item">
                                <span class="badge <?php echo $system_status['chart_of_accounts'] ? 'bg-green' : 'bg-red'; ?>">
                                    <?php echo $system_status['chart_of_accounts'] ? 'EXISTS' : 'MISSING'; ?>
                                </span>
                                Chart of Accounts
                            </li>
                            <li class="list-group-item">
                                <span class="badge <?php echo $system_status['journal_entries'] ? 'bg-green' : 'bg-red'; ?>">
                                    <?php echo $system_status['journal_entries'] ? 'EXISTS' : 'MISSING'; ?>
                                </span>
                                Journal Entries
                            </li>
                            <li class="list-group-item">
                                <span class="badge <?php echo $system_status['journal_entry_lines'] ? 'bg-green' : 'bg-red'; ?>">
                                    <?php echo $system_status['journal_entry_lines'] ? 'EXISTS' : 'MISSING'; ?>
                                </span>
                                Journal Entry Lines
                            </li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <h4>Data Status</h4>
                        <ul class="list-group">
                            <li class="list-group-item">
                                <span class="badge bg-blue"><?php echo $system_status['accounts_count']; ?></span>
                                Chart of Accounts Records
                            </li>
                            <li class="list-group-item">
                                <span class="badge bg-blue"><?php echo $system_status['journal_entries_count']; ?></span>
                                Journal Entries
                            </li>
                            <li class="list-group-item">
                                <span class="badge <?php echo $system_status['opd_billing_synced'] ? 'bg-green' : 'bg-orange'; ?>">
                                    <?php echo $system_status['opd_billing_synced'] ? 'SYNCED' : 'PENDING'; ?>
                                </span>
                                OPD Billing Integration
                            </li>
                            <li class="list-group-item">
                                <span class="badge <?php echo $system_status['ipd_billing_synced'] ? 'bg-green' : 'bg-orange'; ?>">
                                    <?php echo $system_status['ipd_billing_synced'] ? 'SYNCED' : 'PENDING'; ?>
                                </span>
                                IPD Billing Integration
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Setup Actions -->
        <div class="row">
            <!-- Initialize Financial System -->
            <div class="col-md-6">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-play"></i> Initialize System</h3>
                    </div>
                    <div class="box-body">
                        <p>This will set up the financial management system by:</p>
                        <ul>
                            <li>Creating required database tables</li>
                            <li>Inserting default chart of accounts</li>
                            <li>Syncing existing billing data with financial records</li>
                            <li>Setting up journal entries for past transactions</li>
                        </ul>
                        
                        <?php if (!$system_status['chart_of_accounts'] || $system_status['accounts_count'] == 0) : ?>
                            <form method="post">
                                <div class="form-group">
                                    <label>
                                        <input type="checkbox" name="confirm_setup" required> 
                                        I understand this will modify the database structure
                                    </label>
                                </div>
                                <button type="submit" name="setup_financial" value="1" class="btn btn-success btn-lg">
                                    <i class="fa fa-cogs"></i> Initialize Financial System
                                </button>
                            </form>
                        <?php else : ?>
                            <div class="alert alert-info">
                                <i class="fa fa-info-circle"></i> Financial system is already initialized.
                            </div>
                            <a href="<?php echo base_url(); ?>admin/financial/dashboard" class="btn btn-primary">
                                <i class="fa fa-dashboard"></i> Go to Financial Dashboard
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Manual Actions -->
            <div class="col-md-6">
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-wrench"></i> Manual Actions</h3>
                    </div>
                    <div class="box-body">
                        <h4>Database Operations</h4>
                        <div class="btn-group-vertical btn-block">
                            <button type="button" class="btn btn-default" id="updateBillingTables">
                                <i class="fa fa-database"></i> Update Billing Tables
                            </button>
                            <button type="button" class="btn btn-default" id="testSystem">
                                <i class="fa fa-flask"></i> Test Financial System
                            </button>
                        </div>

                        <h4 style="margin-top: 20px;">Quick Links</h4>
                        <div class="btn-group-vertical btn-block">
                            <a href="<?php echo base_url(); ?>admin/financial/chartofaccounts" class="btn btn-info">
                                <i class="fa fa-list"></i> Chart of Accounts
                            </a>
                            <a href="<?php echo base_url(); ?>admin/financial/journalentries" class="btn btn-info">
                                <i class="fa fa-book"></i> Journal Entries
                            </a>
                            <a href="<?php echo base_url(); ?>admin/financial/generalledger" class="btn btn-info">
                                <i class="fa fa-calculator"></i> General Ledger
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- System Information -->
        <div class="box box-info">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-info"></i> About Financial Management System</h3>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-md-6">
                        <h4>Features Included:</h4>
                        <ul>
                            <li><strong>Double-Entry Bookkeeping:</strong> Automatic journal entries for all transactions</li>
                            <li><strong>Chart of Accounts:</strong> Standard medical practice account structure</li>
                            <li><strong>Financial Reports:</strong> Trial Balance, P&L, Balance Sheet</li>
                            <li><strong>Revenue Tracking:</strong> Integrated with OPD/IPD billing</li>
                            <li><strong>Dashboard Analytics:</strong> Real-time financial metrics</li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <h4>Default Account Structure:</h4>
                        <ul>
                            <li><strong>1000-1999:</strong> Assets (Cash, Bank, Receivables, Equipment)</li>
                            <li><strong>2000-2999:</strong> Liabilities (Payables, Loans)</li>
                            <li><strong>3000-3999:</strong> Equity (Owner Equity, Retained Earnings)</li>
                            <li><strong>4000-4999:</strong> Revenue (OPD, IPD, Services)</li>
                            <li><strong>5000-5999:</strong> Expenses (Salaries, Supplies, Utilities)</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Progress Section -->
        <div class="box box-default" id="progressBox" style="display: none;">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-spinner fa-spin"></i> Setup Progress</h3>
            </div>
            <div class="box-body">
                <div class="progress">
                    <div class="progress-bar progress-bar-striped active" id="progressBar" style="width: 0%"></div>
                </div>
                <div id="progressText">Initializing...</div>
            </div>
        </div>
    </section>
</div>

<script>
$(document).ready(function() {
    
    // Refresh status
    $('#refreshStatus').click(function() {
        location.reload();
    });

    // Update billing tables
    $('#updateBillingTables').click(function() {
        var btn = $(this);
        btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Updating...');
        
        $.ajax({
            url: '<?php echo base_url(); ?>admin/financial_setup/updateBillingTables',
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    showAlert('success', response.message);
                    setTimeout(function() { location.reload(); }, 2000);
                } else {
                    showAlert('danger', response.message);
                }
            },
            error: function() {
                showAlert('danger', 'Error updating billing tables');
            },
            complete: function() {
                btn.prop('disabled', false).html('<i class="fa fa-database"></i> Update Billing Tables');
            }
        });
    });

    // Test system
    $('#testSystem').click(function() {
        var btn = $(this);
        btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Testing...');
        
        $.ajax({
            url: '<?php echo base_url(); ?>admin/financial_setup/test',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    var results = response.results;
                    var resultHtml = '<div class="alert alert-info">';
                    resultHtml += '<h4>Test Results:</h4>';
                    resultHtml += '<ul>';
                    resultHtml += '<li>Database: ' + results.database + '</li>';
                    if (results.account_count !== undefined) {
                        resultHtml += '<li>Accounts: ' + results.account_count + '</li>';
                    }
                    if (results.monthly_transactions !== undefined) {
                        resultHtml += '<li>Monthly Transactions: ' + results.monthly_transactions + '</li>';
                    }
                    resultHtml += '</ul></div>';
                    
                    showAlert('info', 'System test completed successfully!' + resultHtml);
                } else {
                    showAlert('danger', response.message);
                }
            },
            error: function() {
                showAlert('danger', 'Error testing system');
            },
            complete: function() {
                btn.prop('disabled', false).html('<i class="fa fa-flask"></i> Test Financial System');
            }
        });
    });

    // Show progress when form is submitted
    $('form').submit(function() {
        $('#progressBox').show();
        simulateProgress();
    });

    function simulateProgress() {
        var progress = 0;
        var interval = setInterval(function() {
            progress += Math.random() * 15;
            if (progress > 90) progress = 90;
            
            $('#progressBar').css('width', progress + '%');
            
            if (progress < 30) {
                $('#progressText').text('Creating database tables...');
            } else if (progress < 60) {
                $('#progressText').text('Setting up chart of accounts...');
            } else if (progress < 90) {
                $('#progressText').text('Syncing billing data...');
            }
            
        }, 500);
        
        // Clear interval after form submission completes
        setTimeout(function() {
            clearInterval(interval);
        }, 10000);
    }

    function showAlert(type, message) {
        var alertHtml = '<div class="alert alert-' + type + ' alert-dismissible">';
        alertHtml += '<button type="button" class="close" data-dismiss="alert">&times;</button>';
        alertHtml += message;
        alertHtml += '</div>';
        
        $('.content').prepend(alertHtml);
        
        setTimeout(function() {
            $('.alert').fadeOut();
        }, 5000);
    }
});
</script>

<style>
.btn-group-vertical .btn {
    margin-bottom: 5px;
}

.list-group-item .badge {
    margin-right: 10px;
}

.progress {
    margin-bottom: 10px;
}

#progressText {
    text-align: center;
    font-weight: bold;
    color: #666;
}

.alert ul {
    margin-bottom: 0;
}

.box-body h4 {
    color: #444;
    margin-top: 20px;
    margin-bottom: 10px;
}

.box-body h4:first-child {
    margin-top: 0;
}
</style>