<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            <i class="fa fa-line-chart"></i> Profit & Loss Statement
            <small>Revenue and expenses analysis</small>
        </h1>
        <ol class="breadcrumb">
            <li>
                <a href="<?php echo base_url(); ?>admin/admin/dashboard">
                    <i class="fa fa-dashboard"></i> Home
                </a>
            </li>
            <li>
                <a href="<?php echo base_url(); ?>admin/financial">Financial</a>
            </li>
            <li class="active">Profit & Loss</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { 
            echo $this->session->flashdata('msg'); 
        } ?>

        <!-- Date Range Selection -->
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title">
                    <i class="fa fa-calendar"></i> Date Range
                </h3>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-box-tool" data-widget="collapse">
                        <i class="fa fa-minus"></i>
                    </button>
                </div>
            </div>
            <div class="box-body">
                <form method="get" id="profitLossForm">
                    <div class="row">
                        <!-- From Date -->
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="date_from">From Date</label>
                                <input type="date" 
                                       class="form-control" 
                                       name="date_from" 
                                       id="date_from" 
                                       value="<?php echo $date_from; ?>" 
                                       required>
                            </div>
                        </div>

                        <!-- To Date -->
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="date_to">To Date</label>
                                <input type="date" 
                                       class="form-control" 
                                       name="date_to" 
                                       id="date_to" 
                                       value="<?php echo $date_to; ?>" 
                                       required>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <div class="btn-group btn-block">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fa fa-refresh"></i> Generate
                                    </button>
                                    <button type="button" class="btn btn-success" id="exportPL">
                                        <i class="fa fa-download"></i> Export
                                    </button>
                                    <button type="button" class="btn btn-default" id="printPL">
                                        <i class="fa fa-print"></i> Print
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Quick Periods -->
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Quick Periods</label>
                                <div class="btn-group btn-block">
                                    <button type="button" class="btn btn-default btn-sm quick-period" data-period="thisMonth">
                                        This Month
                                    </button>
                                    <button type="button" class="btn btn-default btn-sm quick-period" data-period="lastMonth">
                                        Last Month
                                    </button>
                                    <button type="button" class="btn btn-default btn-sm quick-period" data-period="thisYear">
                                        This Year
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- P&L Header -->
        <div class="profit-loss-header text-center">
            <!--<h2>
                <?php 
                if (method_exists($this->customlib, 'getSchoolName')) {
                    echo $this->customlib->getSchoolName(); 
                } else {
                    echo 'Healthcare Management System';
                }
                ?>
            </h2> -->
            <h3>Profit & Loss Statement</h3>
            <h4>
                For the period from <?php echo date('F d, Y', strtotime($date_from)); ?> 
                to <?php echo date('F d, Y', strtotime($date_to)); ?>
            </h4>
        </div>

        <?php
        // Calculate totals from income statement data
        $revenue_data = isset($income_statement['revenue']) ? $income_statement['revenue'] : array();
        $expenses_data = isset($income_statement['expenses']) ? $income_statement['expenses'] : array();
        
        $total_revenue = 0;
        $total_expenses = 0;
        
        foreach ($revenue_data as $revenue_item) {
            $total_revenue += $revenue_item['amount'];
        }
        
        foreach ($expenses_data as $expense_item) {
            $total_expenses += $expense_item['amount'];
        }
        
        $net_income = $total_revenue - $total_expenses;
        $profit_margin = $total_revenue > 0 ? ($net_income / $total_revenue) * 100 : 0;
        
        // Get currency symbol
        $currency_symbol = '';
        if (method_exists($this->customlib, 'getSchoolCurrencyFormat')) {
            $currency_symbol = $this->customlib->getSchoolCurrencyFormat();
        } else {
            $currency_symbol = 'KES '; // Default for Kenya
        }
        ?>

        <!-- Key Metrics -->
        <div class="row">
            <!-- Total Revenue Card -->
            <div class="col-md-3">
                <div class="info-box bg-green">
                    <span class="info-box-icon">
                        <i class="fa fa-money"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Revenue</span>
                        <span class="info-box-number">
                            <?php echo $currency_symbol . number_format($total_revenue, 2); ?>
                        </span>
                    </div>
                </div>
            </div>

            <!-- Total Expenses Card -->
            <div class="col-md-3">
                <div class="info-box bg-red">
                    <span class="info-box-icon">
                        <i class="fa fa-shopping-cart"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Expenses</span>
                        <span class="info-box-number">
                            <?php echo $currency_symbol . number_format($total_expenses, 2); ?>
                        </span>
                    </div>
                </div>
            </div>

            <!-- Net Income Card -->
            <div class="col-md-3">
                <div class="info-box <?php echo ($net_income >= 0) ? 'bg-blue' : 'bg-orange'; ?>">
                    <span class="info-box-icon">
                        <i class="fa <?php echo ($net_income >= 0) ? 'fa-line-chart' : 'fa-warning'; ?>"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Net Income</span>
                        <span class="info-box-number">
                            <?php echo $currency_symbol . number_format($net_income, 2); ?>
                        </span>
                    </div>
                </div>
            </div>

            <!-- Profit Margin Card -->
            <div class="col-md-3">
                <div class="info-box bg-purple">
                    <span class="info-box-icon">
                        <i class="fa fa-percent"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Profit Margin</span>
                        <span class="info-box-number">
                            <?php echo number_format($profit_margin, 1) . '%'; ?>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Profit & Loss Statement -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-table"></i> Profit & Loss Statement
                        </h3>
                        <div class="box-tools pull-right">
                            <span class="label <?php echo ($net_income >= 0) ? 'label-success' : 'label-danger'; ?>">
                                <?php echo ($net_income >= 0) ? 'PROFIT' : 'LOSS'; ?>: 
                                <?php echo $currency_symbol . number_format(abs($net_income), 2); ?>
                            </span>
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr class="bg-gray">
                                        <th style="width: 60%;">Account</th>
                                        <th class="text-right" style="width: 20%;">Amount</th>
                                        <th class="text-right" style="width: 20%;">% of Revenue</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- REVENUE SECTION -->
                                    <tr class="section-header bg-green">
                                        <td colspan="3">
                                            <strong><i class="fa fa-money"></i> REVENUE</strong>
                                        </td>
                                    </tr>

                                    <?php if (!empty($revenue_data)) : ?>
                                        <?php foreach ($revenue_data as $rev_item) : ?>
                                            <tr class="revenue-row">
                                                <td class="account-name">
                                                    <a href="<?php echo base_url(); ?>admin/financial/generalledger?account_id=<?php echo isset($rev_item['id']) ? $rev_item['id'] : ''; ?>&date_from=<?php echo $date_from; ?>&date_to=<?php echo $date_to; ?>" 
                                                       target="_blank" 
                                                       class="text-blue account-link">
                                                        <?php echo htmlspecialchars($rev_item['account_name']); ?>
                                                    </a>
                                                    <br>
                                                    <small class="text-muted">
                                                        <?php echo htmlspecialchars($rev_item['account_code']); ?>
                                                    </small>
                                                </td>
                                                <td class="text-right">
                                                    <span class="currency-amount text-green">
                                                        <?php echo $currency_symbol . number_format($rev_item['amount'], 2); ?>
                                                    </span>
                                                </td>
                                                <td class="text-right">
                                                    <span class="percentage">
                                                        <?php echo $total_revenue > 0 
                                                            ? number_format(($rev_item['amount'] / $total_revenue) * 100, 1) . '%' 
                                                            : '0%'; ?>
                                                    </span>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else : ?>
                                        <tr>
                                            <td colspan="3" class="text-center text-muted">
                                                No revenue recorded for this period
                                            </td>
                                        </tr>
                                    <?php endif; ?>

                                    <tr class="subtotal-row bg-light-green">
                                        <td><strong>TOTAL REVENUE</strong></td>
                                        <td class="text-right">
                                            <strong>
                                                <?php echo $currency_symbol . number_format($total_revenue, 2); ?>
                                            </strong>
                                        </td>
                                        <td class="text-right"><strong>100.0%</strong></td>
                                    </tr>

                                    <!-- SPACING -->
                                    <tr><td colspan="3">&nbsp;</td></tr>

                                    <!-- EXPENSES SECTION -->
                                    <tr class="section-header bg-red">
                                        <td colspan="3">
                                            <strong><i class="fa fa-shopping-cart"></i> EXPENSES</strong>
                                        </td>
                                    </tr>

                                    <?php if (!empty($expenses_data)) : ?>
                                        <?php foreach ($expenses_data as $exp_item) : ?>
                                            <tr class="expense-row">
                                                <td class="account-name">
                                                    <a href="<?php echo base_url(); ?>admin/financial/generalledger?account_id=<?php echo isset($exp_item['id']) ? $exp_item['id'] : ''; ?>&date_from=<?php echo $date_from; ?>&date_to=<?php echo $date_to; ?>" 
                                                       target="_blank" 
                                                       class="text-blue account-link">
                                                        <?php echo htmlspecialchars($exp_item['account_name']); ?>
                                                    </a>
                                                    <br>
                                                    <small class="text-muted">
                                                        <?php echo htmlspecialchars($exp_item['account_code']); ?>
                                                    </small>
                                                </td>
                                                <td class="text-right">
                                                    <span class="currency-amount text-red">
                                                        <?php echo $currency_symbol . number_format($exp_item['amount'], 2); ?>
                                                    </span>
                                                </td>
                                                <td class="text-right">
                                                    <span class="percentage">
                                                        <?php echo $total_revenue > 0 
                                                            ? number_format(($exp_item['amount'] / $total_revenue) * 100, 1) . '%' 
                                                            : '0%'; ?>
                                                    </span>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else : ?>
                                        <tr>
                                            <td colspan="3" class="text-center text-muted">
                                                No expenses recorded for this period
                                            </td>
                                        </tr>
                                    <?php endif; ?>

                                    <tr class="subtotal-row bg-light-red">
                                        <td><strong>TOTAL EXPENSES</strong></td>
                                        <td class="text-right">
                                            <strong>
                                                <?php echo $currency_symbol . number_format($total_expenses, 2); ?>
                                            </strong>
                                        </td>
                                        <td class="text-right">
                                            <strong>
                                                <?php echo $total_revenue > 0 
                                                    ? number_format(($total_expenses / $total_revenue) * 100, 1) . '%' 
                                                    : '0%'; ?>
                                            </strong>
                                        </td>
                                    </tr>

                                    <!-- SPACING -->
                                    <tr><td colspan="3">&nbsp;</td></tr>

                                    <!-- NET INCOME -->
                                    <tr class="net-income-row <?php echo ($net_income >= 0) ? 'bg-blue' : 'bg-orange'; ?>">
                                        <td><strong>NET INCOME (LOSS)</strong></td>
                                        <td class="text-right">
                                            <strong>
                                                <?php echo $currency_symbol . number_format($net_income, 2); ?>
                                            </strong>
                                        </td>
                                        <td class="text-right">
                                            <strong>
                                                <?php echo number_format($profit_margin, 1) . '%'; ?>
                                            </strong>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Financial Analysis Summary -->
        <?php if ($total_revenue > 0 || $total_expenses > 0) : ?>
        <div class="row">
            <div class="col-md-12">
                <div class="callout <?php echo ($net_income >= 0) ? 'callout-success' : 'callout-warning'; ?>">
                    <h4>
                        <i class="fa <?php echo ($net_income >= 0) ? 'fa-thumbs-up' : 'fa-warning'; ?>"></i> 
                        Financial Performance Summary
                    </h4>
                    <div class="row">
                        <!-- Profit Margin Analysis -->
                        <div class="col-md-3">
                            <strong>Profit Margin:</strong><br>
                            <span class="<?php echo ($profit_margin >= 10) ? 'text-green' : (($profit_margin >= 5) ? 'text-orange' : 'text-red'); ?>">
                                <?php echo number_format($profit_margin, 1); ?>%
                                <?php 
                                if ($profit_margin >= 10) echo '(Excellent)';
                                elseif ($profit_margin >= 5) echo '(Good)';
                                elseif ($profit_margin >= 0) echo '(Fair)';
                                else echo '(Loss)';
                                ?>
                            </span>
                        </div>

                        <!-- Expense Ratio -->
                        <div class="col-md-3">
                            <strong>Expense Ratio:</strong><br>
                            <?php 
                            $expense_ratio = $total_revenue > 0 ? ($total_expenses / $total_revenue) * 100 : 0;
                            ?>
                            <span class="<?php echo ($expense_ratio <= 80) ? 'text-green' : (($expense_ratio <= 90) ? 'text-orange' : 'text-red'); ?>">
                                <?php echo number_format($expense_ratio, 1); ?>%
                                <?php 
                                if ($expense_ratio <= 80) echo '(Efficient)';
                                elseif ($expense_ratio <= 90) echo '(Moderate)';
                                else echo '(High)';
                                ?>
                            </span>
                        </div>

                        <!-- Revenue per Day -->
                        <div class="col-md-3">
                            <strong>Revenue per Day:</strong><br>
                            <?php 
                            $date_diff = (strtotime($date_to) - strtotime($date_from)) / (60 * 60 * 24) + 1;
                            $revenue_per_day = $date_diff > 0 ? $total_revenue / $date_diff : 0;
                            ?>
                            <span class="text-blue">
                                <?php echo $currency_symbol . number_format($revenue_per_day, 2); ?>
                            </span>
                        </div>

                        <!-- Break-even Status -->
                        <div class="col-md-3">
                            <strong>Break-even Status:</strong><br>
                            <span class="<?php echo ($net_income >= 0) ? 'text-green' : 'text-red'; ?>">
                                <?php echo ($net_income >= 0) ? 'Profitable' : 'Loss Making'; ?>
                                <?php if ($net_income < 0) : ?>
                                    <br><small>Need <?php echo $currency_symbol . number_format(abs($net_income), 2); ?> more revenue</small>
                                <?php endif; ?>
                            </span>
                        </div>
                    </div>

                    <!-- Performance Recommendations -->
                    <div class="row" style="margin-top: 15px;">
                        <div class="col-md-12">
                            <strong>Recommendations:</strong>
                            <ul class="list-unstyled">
                                <?php if ($profit_margin < 5) : ?>
                                    <li><i class="fa fa-exclamation-circle text-red"></i> Consider reducing expenses or increasing revenue to improve profitability</li>
                                <?php endif; ?>
                                
                                <?php if ($expense_ratio > 90) : ?>
                                    <li><i class="fa fa-warning text-orange"></i> Expense ratio is high - review and optimize operational costs</li>
                                <?php endif; ?>
                                
                                <?php if ($net_income >= 0 && $profit_margin >= 10) : ?>
                                    <li><i class="fa fa-thumbs-up text-green"></i> Excellent financial performance - maintain current strategies</li>
                                <?php endif; ?>
                                
                                <?php if ($total_revenue == 0) : ?>
                                    <li><i class="fa fa-warning text-red"></i> No revenue recorded - check data sources and revenue recognition</li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Setup Notice -->
        <?php if (empty($revenue_data) && empty($expenses_data)): ?>
        <div class="box box-warning">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-warning"></i> Financial Data Setup Required</h3>
            </div>
            <div class="box-body">
                <p>It appears no financial transactions are recorded for the selected period. To use the profit & loss statement:</p>
                <ol>
                    <li>Ensure your chart of accounts includes revenue and expense accounts</li>
                    <li>Create journal entries for your financial transactions</li>
                    <li>Make sure transactions are approved and within the selected date range</li>
                </ol>
                <div class="btn-group">
                    <a href="<?php echo base_url(); ?>admin/financial/chartofaccounts" class="btn btn-primary">
                        <i class="fa fa-plus"></i> Set Up Chart of Accounts
                    </a>
                    <a href="<?php echo base_url(); ?>admin/financial/journalentries" class="btn btn-success">
                        <i class="fa fa-plus"></i> Create Journal Entry
                    </a>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </section>
</div>

<script>
$(document).ready(function() {
    // Quick period selection
    $('.quick-period').click(function() {
        var period = $(this).data('period');
        var today = new Date();
        var fromDate, toDate;

        switch(period) {
            case 'thisMonth':
                fromDate = new Date(today.getFullYear(), today.getMonth(), 1);
                toDate = new Date(today.getFullYear(), today.getMonth() + 1, 0);
                break;
            case 'lastMonth':
                fromDate = new Date(today.getFullYear(), today.getMonth() - 1, 1);
                toDate = new Date(today.getFullYear(), today.getMonth(), 0);
                break;
            case 'thisYear':
                fromDate = new Date(today.getFullYear(), 0, 1);
                toDate = new Date(today.getFullYear(), 11, 31);
                break;
        }

        $('#date_from').val(formatDate(fromDate));
        $('#date_to').val(formatDate(toDate));
        
        // Highlight selected period
        $('.quick-period').removeClass('btn-primary').addClass('btn-default');
        $(this).removeClass('btn-default').addClass('btn-primary');
    });

    // Export P&L to Excel
    $('#exportPL').click(function() {
        var fromDate = $('#date_from').val();
        var toDate = $('#date_to').val();
        
        if (!fromDate || !toDate) {
            alert('Please select date range first');
            return;
        }
        
        var exportUrl = '<?php echo base_url(); ?>admin/financial/exportProfitLoss?' +
                       'date_from=' + fromDate + '&date_to=' + toDate + '&format=excel';
        
        window.open(exportUrl, '_blank');
    });

    // Print P&L Statement
    $('#printPL').click(function() {
        // Hide non-printable elements
        $('.box-tools, .btn, .breadcrumb, .callout').hide();
        
        // Print the page
        window.print();
        
        // Show elements back after print
        setTimeout(function() {
            $('.box-tools, .btn, .breadcrumb, .callout').show();
        }, 1000);
    });

    // Form validation
    $('#profitLossForm').on('submit', function(e) {
        var fromDate = new Date($('#date_from').val());
        var toDate = new Date($('#date_to').val());
        
        if (fromDate > toDate) {
            e.preventDefault();
            alert('From date cannot be later than To date');
            return false;
        }
        
        // Show loading indicator
        var submitBtn = $(this).find('button[type="submit"]');
        submitBtn.html('<i class="fa fa-spinner fa-spin"></i> Generating...')
                 .prop('disabled', true);
    });

    // Account drill-down
    $('.account-link').click(function(e) {
        e.preventDefault();
        var url = $(this).attr('href');
        window.open(url, '_blank');
    });

    // Row hover effects
    $('.revenue-row, .expense-row').hover(
        function() {
            $(this).addClass('row-hover');
        },
        function() {
            $(this).removeClass('row-hover');
        }
    );

    // Tooltip initialization
    $('[data-toggle="tooltip"]').tooltip();
});

// Utility function
function formatDate(date) {
    var month = '' + (date.getMonth() + 1);
    var day = '' + date.getDate();
    var year = date.getFullYear();

    if (month.length < 2) month = '0' + month;
    if (day.length < 2) day = '0' + day;

    return [year, month, day].join('-');
}
</script>

<style>
/* AdminLTE Theme Consistent Styling */
.profit-loss-header {
    background: linear-gradient(135deg, #f4f4f4 0%, #e8e8e8 100%);
    padding: 25px;
    margin-bottom: 20px;
    border-radius: 5px;
    border: 1px solid #d2d6de;
    box-shadow: 0 1px 3px rgba(0,0,0,.12), 0 1px 2px rgba(0,0,0,.24);
}

.profit-loss-header h2 {
    margin: 0;
    color: #333;
    font-weight: 300;
}

.profit-loss-header h3 {
    margin: 5px 0;
    color: #666;
    font-weight: 400;
}

.profit-loss-header h4 {
    margin: 5px 0 0 0;
    color: #999;
    font-weight: 300;
}

/* Info boxes enhancement */
.info-box {
    border-radius: 5px;
    box-shadow: 0 1px 3px rgba(0,0,0,.12), 0 1px 2px rgba(0,0,0,.24);
    transition: all 0.3s ease;
}

.info-box:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,.12), 0 2px 4px rgba(0,0,0,.24);
}

.info-box-number {
    font-size: 18px !important;
    font-weight: bold;
    font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
}

/* Table styling */
.section-header {
    font-weight: bold;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.section-header.bg-green {
    background-color: #00a65a !important;
    color: white;
}

.section-header.bg-red {
    background-color: #dd4b39 !important;
    color: white;
}

.subtotal-row {
    background-color: #f9f9f9;
    border-top: 2px solid #ddd;
    font-weight: bold;
}

.bg-light-green {
    background-color: rgba(0,166,90,0.1) !important;
}

.bg-light-red {
    background-color: rgba(221,75,57,0.1) !important;
}

.net-income-row {
    border: 2px solid #333;
    font-size: 16px;
    font-weight: bold;
}

.currency-amount {
    font-family: 'Courier New', 'Lucida Console', Monaco, monospace;
    font-weight: bold;
}

.percentage {
    font-size: 12px;
    color: #666;
    font-weight: 500;
}

.account-link {
    text-decoration: none;
    color: #3c8dbc !important;
    font-weight: 500;
}

.account-link:hover {
    text-decoration: underline;
    color: #2c689b !important;
}

.row-hover {
    background-color: #f5f5f5 !important;
    cursor: pointer;
    transition: background-color 0.15s ease-in-out;
}

/* Box enhancements */
.box {
    border-radius: 5px;
    box-shadow: 0 1px 3px rgba(0,0,0,.12), 0 1px 2px rgba(0,0,0,.24);
}

.box-header {
    border-bottom: 1px solid #f4f4f4;
}

.box-title {
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

/* Button enhancements */
.btn-group .btn {
    transition: all 0.3s ease;
}

.btn-group .btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0,0,0,.2);
}

.quick-period {
    transition: all 0.2s ease;
}

.quick-period:hover {
    background-color: #e6e6e6;
    border-color: #adadad;
}

/* Callout styling */
.callout {
    border-radius: 5px;
    box-shadow: 0 2px 4px rgba(0,0,0,.1);
}

.callout-success {
    border-left: 5px solid #00a65a;
    background-color: #000000;
}

.callout-warning {
    border-left: 5px solid #f39c12;
    background-color: #fdf8e7;
}

.callout h4 {
    margin-top: 0;
    font-weight: 600;
}

/* Alert styling */
.alert {
    border-radius: 5px;
    border: none;
    box-shadow: 0 2px 4px rgba(0,0,0,.1);
}

/* Table hover effects */
.table-hover tbody tr:hover {
    background-color: #f5f5f5;
    transition: background-color 0.15s ease-in-out;
}

/* Responsive design */
@media (max-width: 768px) {
    .profit-loss-header {
        padding: 15px;
        text-align: center;
    }
    
    .info-box {
        margin-bottom: 15px;
    }
    
    .info-box-number {
        font-size: 16px !important;
    }
    
    .btn-group {
        width: 100%;
    }
    
    .btn-group .btn {
        width: 33.33%;
        font-size: 12px;
    }
    
    .quick-period {
        font-size: 10px;
        padding: 4px 6px;
    }
    
    .table {
        font-size: 12px;
    }
    
    .table th,
    .table td {
        padding: 8px 4px;
    }
}

/* Print styles */
@media print {
    .content-wrapper {
        margin: 0 !important;
        padding: 0 !important;
    }
    
    .box {
        box-shadow: none !important;
        border: 1px solid #ddd !important;
        margin-bottom: 10px !important;
        page-break-inside: avoid;
    }
    
    .box-header {
        background: #f7f7f7 !important;
        print-color-adjust: exact;
        -webkit-print-color-adjust: exact;
    }
    
    .profit-loss-header {
        background: white !important;
        color: black !important;
        border: 2px solid #333 !important;
        box-shadow: none !important;
    }
    
    .btn, .btn-group, .box-tools, .breadcrumb, .callout {
        display: none !important;
    }
    
    .section-header {
        background: #f0f0f0 !important;
        color: black !important;
        border: 1px solid #333 !important;
        print-color-adjust: exact;
        -webkit-print-color-adjust: exact;
    }
    
    .subtotal-row,
    .net-income-row {
        background: #f5f5f5 !important;
        print-color-adjust: exact;
        -webkit-print-color-adjust: exact;
    }
    
    .info-box {
        display: none !important;
    }
    
    .table {
        font-size: 12px !important;
    }
}

/* Text colors */
.text-green {
    color: #00a65a !important;
}

.text-red {
    color: #dd4b39 !important;
}

.text-blue {
    color: #3c8dbc !important;
}

.text-orange {
    color: #f39c12 !important;
}

.text-muted {
    color: #777 !important;
}

/* Additional utility classes */
.font-weight-bold {
    font-weight: bold !important;
}

.border-top-thick {
    border-top: 3px solid #ddd !important;
}

.border-bottom-thick {
    border-bottom: 3px solid #ddd !important;
}
</style>