<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            <i class="fa fa-calculator"></i> Financial Dashboard
            <small>Comprehensive Financial Management</small>
        </h1>
        <ol class="breadcrumb">
            <li>
                <a href="<?php echo base_url(); ?>admin/admin/dashboard">
                    <i class="fa fa-dashboard"></i> Home
                </a>
            </li>
            <li class="active">Financial Dashboard</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { 
            echo $this->session->flashdata('msg'); 
        } ?>

        <!-- Financial Metrics Row -->
        <div class="row">
            <!-- Total Revenue -->
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3>
                            <?php 
                            // Currency symbol detection
                            $currency_symbol = '';
                            if (method_exists($this->customlib, 'getHospitalCurrencyFormat')) {
                                $currency_symbol = $this->customlib->getHospitalCurrencyFormat();
                            } elseif (method_exists($this->customlib, 'getCurrencyFormat')) {
                                $currency_symbol = $this->customlib->getCurrencyFormat();
                            } else {
                                $currency_symbol = 'Ksh '; // Default for Kenya
                            }
                            echo $currency_symbol;
                            
                            // Enhanced revenue calculation including all modules
                            $total_revenue = 0;
                            
                            // Get base revenue from existing metrics
                            $base_revenue = $metrics['total_revenue'] ?? 0;
                            $total_revenue += $base_revenue;
                            
                            // Add laboratory revenue (using created_at instead of date)
                            $lab_revenue = 0;
                            if ($this->db->table_exists('laboratory')) {
                                try {
                                    $this->db->select_sum('total_cost');
                                    $this->db->from('laboratory');
                                    $this->db->where('YEAR(created_at) = ', date('Y'));
                                    $this->db->where('total_cost > 0');
                                    $lab_query = $this->db->get();
                                    if ($lab_query && $lab_query->row()) {
                                        $lab_revenue = $lab_query->row()->total_cost ?: 0;
                                        $total_revenue += $lab_revenue;
                                    }
                                } catch (Exception $e) {
                                    log_message('error', 'Laboratory revenue calculation failed: ' . $e->getMessage());
                                }
                            }
                            
                            // Add consultation financials revenue
                            $consult_revenue = 0;
                            if ($this->db->table_exists('consultation_financials')) {
                                try {
                                    $this->db->select_sum('total_amount');
                                    $this->db->from('consultation_financials');
                                    $this->db->where('YEAR(created_at) = ', date('Y'));
                                    $this->db->where('total_amount > 0');
                                    $consult_query = $this->db->get();
                                    if ($consult_query && $consult_query->row()) {
                                        $consult_revenue = $consult_query->row()->total_amount ?: 0;
                                        $total_revenue += $consult_revenue;
                                    }
                                } catch (Exception $e) {
                                    log_message('error', 'Consultation revenue calculation failed: ' . $e->getMessage());
                                }
                            }
                            
                            // FIXED: Add radiology revenue from radiology_orders table
                            $radiology_revenue = 0;
                            if ($this->db->table_exists('radiology_orders')) {
                                try {
                                    $this->db->select_sum('total_amount');
                                    $this->db->from('radiology_orders');
                                    $this->db->where('YEAR(created_at) = ', date('Y'));
                                    $this->db->where('total_amount > 0');
                                    $this->db->where_in('status', array('in_progress','completed', 'reported')); // Only count completed orders
                                    $radiology_query = $this->db->get();
                                    if ($radiology_query && $radiology_query->row()) {
                                        $radiology_revenue = $radiology_query->row()->total_amount ?: 0;
                                        $total_revenue += $radiology_revenue;
                                    }
                                } catch (Exception $e) {
                                    log_message('error', 'Radiology revenue calculation failed: ' . $e->getMessage());
                                }
                            }
                            
                            echo number_format($total_revenue, 2);
                            ?>
                        </h3>
                        <p>Total Revenue (YTD)</p>
                        <div class="progress-description">
                            <?php 
                            $revenue_growth = $metrics['revenue_growth'] ?? 0;
                            if ($revenue_growth > 0) {
                                echo '<i class="fa fa-arrow-up"></i> +' . number_format($revenue_growth, 1) . '% from last year';
                            } elseif ($revenue_growth < 0) {
                                echo '<i class="fa fa-arrow-down"></i> ' . number_format($revenue_growth, 1) . '% from last year';
                            } else {
                                echo '<i class="fa fa-minus"></i> No change from last year';
                            }
                            ?>
                        </div>
                    </div>
                    <div class="icon">
                        <i class="fa fa-money"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/financial/profitloss" class="small-box-footer">
                        View P&L <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <!-- Net Income -->
            <div class="col-lg-3 col-xs-6">
                <div class="small-box <?php echo (($metrics['net_income'] ?? 0) >= 0) ? 'bg-blue' : 'bg-red'; ?>">
                    <div class="inner">
                        <h3>
                            <?php echo $currency_symbol; ?>
                            <?php echo number_format($metrics['net_income'] ?? 0, 2); ?>
                        </h3>
                        <p>Net Income (YTD)</p>
                        <div class="progress-description">
                            <?php 
                            // Recalculate with enhanced total revenue
                            $net_income = $metrics['net_income'] ?? 0;
                            $profit_margin = $total_revenue > 0 ? ($net_income / $total_revenue) * 100 : 0;
                            echo 'Profit Margin: ' . number_format($profit_margin, 1) . '%';
                            ?>
                        </div>
                    </div>
                    <div class="icon">
                        <i class="fa fa-line-chart"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/financial/profitloss" class="small-box-footer">
                        View Details <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <!-- Accounts Receivable -->
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3>
                            <?php echo $currency_symbol; ?>
                            <?php echo number_format($metrics['accounts_receivable'] ?? 0, 2); ?>
                        </h3>
                        <p>Accounts Receivable</p>
                        <div class="progress-description">
                            <?php 
                            $overdue_amount = $metrics['overdue_receivables'] ?? 0;
                            if ($overdue_amount > 0) {
                                echo '<i class="fa fa-warning text-red"></i> ' . $currency_symbol . number_format($overdue_amount, 0) . ' overdue';
                            } else {
                                echo '<i class="fa fa-check text-green"></i> All current';
                            }
                            ?>
                        </div>
                    </div>
                    <div class="icon">
                        <i class="fa fa-users"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/financial/accountsreceivable" class="small-box-footer">
                        Manage A/R <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <!-- Cash Balance -->
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3>
                            <?php echo $currency_symbol; ?>
                            <?php echo number_format($metrics['cash_balance'] ?? 0, 2); ?>
                        </h3>
                        <p>Cash Balance</p>
                        <div class="progress-description">
                            <?php 
                            $cash_flow = $metrics['monthly_cash_flow'] ?? 0;
                            if ($cash_flow > 0) {
                                echo '<i class="fa fa-arrow-up text-green"></i> +' . $currency_symbol . number_format($cash_flow, 0) . ' this month';
                            } elseif ($cash_flow < 0) {
                                echo '<i class="fa fa-arrow-down text-red"></i> ' . $currency_symbol . number_format(abs($cash_flow), 0) . ' this month';
                            } else {
                                echo '<i class="fa fa-minus"></i> No change this month';
                            }
                            ?>
                        </div>
                    </div>
                    <div class="icon">
                        <i class="fa fa-bank"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/financial/generalledger?account_id=1" class="small-box-footer">
                        View Cash Ledger <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Secondary Metrics Row -->
        <div class="row">
            <!-- Monthly Revenue -->
            <div class="col-lg-3 col-xs-6">
                <div class="info-box">
                    <span class="info-box-icon bg-green">
                        <i class="fa fa-calendar"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Monthly Revenue</span>
                        <span class="info-box-number">
                            <?php 
                            echo $currency_symbol;
                            
                            // Enhanced monthly revenue calculation
                            $monthly_revenue = $metrics['monthly_revenue'] ?? 0;
                            
                            // Add laboratory monthly revenue
                            if ($this->db->table_exists('laboratory')) {
                                try {
                                    $this->db->select_sum('total_cost');
                                    $this->db->from('laboratory');
                                    $this->db->where('DATE_FORMAT(created_at, "%Y-%m") = ', date('Y-m'));
                                    $this->db->where('total_cost > 0');
                                    $lab_monthly_query = $this->db->get();
                                    if ($lab_monthly_query && $lab_monthly_query->row()) {
                                        $lab_monthly = $lab_monthly_query->row()->total_cost ?: 0;
                                        $monthly_revenue += $lab_monthly;
                                    }
                                } catch (Exception $e) {
                                    // Skip if column doesn't exist
                                }
                            }
                            
                            // Add consultation financials monthly revenue
                            if ($this->db->table_exists('consultation_financials')) {
                                try {
                                    $this->db->select_sum('total_amount');
                                    $this->db->from('consultation_financials');
                                    $this->db->where('DATE_FORMAT(created_at, "%Y-%m") = ', date('Y-m'));
                                    $this->db->where('total_amount > 0');
                                    $consult_monthly_query = $this->db->get();
                                    if ($consult_monthly_query && $consult_monthly_query->row()) {
                                        $consult_monthly = $consult_monthly_query->row()->total_amount ?: 0;
                                        $monthly_revenue += $consult_monthly;
                                    }
                                } catch (Exception $e) {
                                    // Skip if column doesn't exist
                                }
                            }
                            
                            // FIXED: Add radiology monthly revenue from radiology_orders
                            if ($this->db->table_exists('radiology_orders')) {
                                try {
                                    $this->db->select_sum('total_amount');
                                    $this->db->from('radiology_orders');
                                    $this->db->where('DATE_FORMAT(created_at, "%Y-%m") = ', date('Y-m'));
                                    $this->db->where('total_amount > 0');
                                    $this->db->where_in('status', array('completed', 'reported')); // Only count completed orders
                                    $radiology_monthly_query = $this->db->get();
                                    if ($radiology_monthly_query && $radiology_monthly_query->row()) {
                                        $radiology_monthly = $radiology_monthly_query->row()->total_amount ?: 0;
                                        $monthly_revenue += $radiology_monthly;
                                    }
                                } catch (Exception $e) {
                                    // Skip if column doesn't exist
                                }
                            }
                            
                            echo number_format($monthly_revenue, 2);
                            ?>
                        </span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 85%"></div>
                        </div>
                        <span class="progress-description">
                            Target: <?php echo $currency_symbol . number_format($metrics['monthly_target'] ?? 100000, 0); ?>
                        </span>
                    </div>
                </div>
            </div>

            <!-- Collection Rate -->
            <div class="col-lg-3 col-xs-6">
                <div class="info-box">
                    <span class="info-box-icon bg-blue">
                        <i class="fa fa-percent"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Collection Rate</span>
                        <span class="info-box-number">
                            <?php echo number_format($metrics['collection_rate'] ?? 0, 1); ?>%
                        </span>
                        <div class="progress">
                            <div class="progress-bar" style="width: <?php echo $metrics['collection_rate'] ?? 0; ?>%"></div>
                        </div>
                        <span class="progress-description">
                            <?php 
                            $collection_rate = $metrics['collection_rate'] ?? 0;
                            if ($collection_rate >= 95) echo 'Excellent';
                            elseif ($collection_rate >= 85) echo 'Good';
                            elseif ($collection_rate >= 75) echo 'Fair';
                            else echo 'Needs Improvement';
                            ?>
                        </span>
                    </div>
                </div>
            </div>

            <!-- Pending Invoices -->
            <div class="col-lg-3 col-xs-6">
                <div class="info-box">
                    <span class="info-box-icon bg-yellow">
                        <i class="fa fa-file-text"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Pending Invoices</span>
                        <span class="info-box-number">
                            <?php echo $metrics['pending_invoices'] ?? 0; ?>
                        </span>
                        <div class="progress">
                            <div class="progress-bar" style="width: 60%"></div>
                        </div>
                        <span class="progress-description">
                            Worth <?php echo $currency_symbol . number_format($metrics['pending_invoice_amount'] ?? 0, 0); ?>
                        </span>
                    </div>
                </div>
            </div>

            <!-- Service Revenue Split -->
            <div class="col-lg-3 col-xs-6">
                <div class="info-box">
                    <span class="info-box-icon bg-purple">
                        <i class="fa fa-pie-chart"></i>
                    </span>
                    <div class="info-box-content">
                        <span class="info-box-text">Service Revenue</span>
                        <span class="info-box-number">
                            <?php 
                            // Calculate service revenue breakdown
                            $lab_revenue_ytd = $lab_revenue ?? 0;
                            $consultation_revenue_ytd = $consult_revenue ?? 0;
                            $radiology_revenue_ytd = $radiology_revenue ?? 0;
                            $other_revenue_ytd = ($metrics['opd_revenue'] ?? 0) + ($metrics['ipd_revenue'] ?? 0);
                            
                            $total_service_revenue = $lab_revenue_ytd + $consultation_revenue_ytd + $radiology_revenue_ytd + $other_revenue_ytd;
                            
                            if ($total_service_revenue > 0) {
                                echo number_format(($lab_revenue_ytd / $total_service_revenue) * 100, 0) . '% Lab';
                            } else {
                                echo 'No Data';
                            }
                            ?>
                        </span>
                        <div class="progress">
                            <div class="progress-bar bg-purple" style="width: <?php echo $total_service_revenue > 0 ? ($lab_revenue_ytd / $total_service_revenue) * 100 : 0; ?>%"></div>
                        </div>
                        <span class="progress-description">
                            Radiology: <?php echo $currency_symbol . number_format($radiology_revenue_ytd, 0); ?>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Charts and Quick Actions Row -->
        <div class="row">
            <!-- Quick Actions -->
            <div class="col-md-6">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-flash"></i> Quick Actions
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-4">
                                <a href="<?php echo base_url(); ?>admin/financial/journalentries" 
                                   class="btn btn-primary btn-block btn-lg">
                                    <i class="fa fa-plus"></i><br>
                                    <small>Journal Entry</small>
                                </a>
                            </div>
                            <div class="col-md-4">
                                <a href="<?php echo base_url(); ?>admin/financial/chartofaccounts" 
                                   class="btn btn-warning btn-block btn-lg">
                                    <i class="fa fa-list"></i><br>
                                    <small>Chart of Accounts</small>
                                </a>
                            </div>
                            <div class="col-md-4">
                                <a href="<?php echo base_url(); ?>admin/financial/trialbalance" 
                                   class="btn btn-info btn-block btn-lg">
                                    <i class="fa fa-balance-scale"></i><br>
                                    <small>Trial Balance</small>
                                </a>
                            </div>
                        </div>
                        <div class="row" style="margin-top: 15px;">
                            <div class="col-md-4">
                                <a href="<?php echo base_url(); ?>admin/financial/generalledger" 
                                   class="btn btn-success btn-block btn-lg">
                                    <i class="fa fa-book"></i><br>
                                    <small>General Ledger</small>
                                </a>
                            </div>
                            <div class="col-md-4">
                                <a href="<?php echo base_url(); ?>admin/financial/balancesheet" 
                                   class="btn btn-default btn-block btn-lg">
                                    <i class="fa fa-pie-chart"></i><br>
                                    <small>Balance Sheet</small>
                                </a>
                            </div>
                            <div class="col-md-4">
                                <a href="<?php echo base_url(); ?>admin/financial/profitloss" 
                                   class="btn btn-danger btn-block btn-lg">
                                    <i class="fa fa-line-chart"></i><br>
                                    <small>P&L Statement</small>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Enhanced Revenue Breakdown -->
            <div class="col-md-6">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-pie-chart"></i> Revenue Breakdown
                        </h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-sm-6">
                                <div class="description-block border-right">
                                    <h5 class="description-header text-green">
                                        <?php echo $currency_symbol . number_format($metrics['opd_revenue'] ?? 0, 0); ?>
                                    </h5>
                                    <span class="description-text">OPD Revenue</span>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="description-block">
                                    <h5 class="description-header text-blue">
                                        <?php echo $currency_symbol . number_format($metrics['ipd_revenue'] ?? 0, 0); ?>
                                    </h5>
                                    <span class="description-text">IPD Revenue</span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-3">
                                <div class="description-block">
                                    <h5 class="description-header text-yellow">
                                        <?php echo $currency_symbol . number_format($metrics['pathology_revenue'] ?? 0, 0); ?>
                                    </h5>
                                    <span class="description-text">Pathology</span>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="description-block">
                                    <h5 class="description-header text-red">
                                        <?php 
                                        // FIXED: Now showing actual radiology revenue from radiology_orders
                                        echo $currency_symbol . number_format($radiology_revenue, 0); 
                                        ?>
                                    </h5>
                                    <span class="description-text">Radiology</span>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="description-block">
                                    <h5 class="description-header text-purple">
                                        <?php echo $currency_symbol . number_format($metrics['pharmacy_revenue'] ?? 0, 0); ?>
                                    </h5>
                                    <span class="description-text">Pharmacy</span>
                                </div>
                            </div>
                            <div class="col-sm-3">
                                <div class="description-block">
                                    <h5 class="description-header text-orange">
                                        <?php echo $currency_symbol . number_format($lab_revenue_ytd, 0); ?>
                                    </h5>
                                    <span class="description-text">Laboratory</span>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="description-block">
                                    <h5 class="description-header text-aqua">
                                        <?php echo $currency_symbol . number_format($consultation_revenue_ytd, 0); ?>
                                    </h5>
                                    <span class="description-text">Consultation Fees</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- System Status -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-cogs"></i> System Status & Revenue Summary
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <!-- Revenue Source Summary -->
                        <div class="row">
                            <div class="col-md-12">
                                <h4 style="margin-bottom: 15px; color: #444;">
                                    <i class="fa fa-money"></i> Revenue Sources Summary (YTD)
                                </h4>
                            </div>
                        </div>
                        <div class="row">
                            <!-- FIXED: Radiology Revenue Status -->
                            <div class="col-md-3 text-center">
                                <div class="revenue-status-block">
                                    <i class="fa fa-camera fa-3x text-red"></i>
                                    <h5 class="text-red" style="margin: 10px 0 5px 0;">Radiology Revenue</h5>
                                    <h4 style="margin: 0; font-weight: bold;">
                                        <?php 
                                        $radiology_revenue_total = $radiology_revenue ?? 0;
                                        $radiology_count = 0;
                                        if ($this->db->table_exists('radiology_orders')) {
                                            try {
                                                // Get radiology orders count
                                                $this->db->where('YEAR(created_at) = ', date('Y'));
                                                $this->db->where_in('status', array('completed', 'reported'));
                                                $radiology_count = $this->db->count_all_results('radiology_orders');
                                            } catch (Exception $e) {
                                                // Skip if error
                                            }
                                        }
                                        echo $currency_symbol . number_format($radiology_revenue_total, 0);
                                        ?>
                                    </h4>
                                    <small class="text-muted">
                                        <?php echo $radiology_count . ' completed orders this year'; ?>
                                    </small>
                                </div>
                            </div>
                            
                            <!-- Laboratory Revenue Status -->
                            <div class="col-md-3 text-center">
                                <div class="revenue-status-block">
                                    <i class="fa fa-flask fa-3x text-purple"></i>
                                    <h5 class="text-purple" style="margin: 10px 0 5px 0;">Laboratory Revenue</h5>
                                    <h4 style="margin: 0; font-weight: bold;">
                                        <?php echo $currency_symbol . number_format($lab_revenue, 0); ?>
                                    </h4>
                                    <small class="text-muted">Lab tests this year</small>
                                </div>
                            </div>
                            
                            <!-- Consultation Revenue Status -->
                            <div class="col-md-3 text-center">
                                <div class="revenue-status-block">
                                    <i class="fa fa-stethoscope fa-3x text-orange"></i>
                                    <h5 class="text-orange" style="margin: 10px 0 5px 0;">Consultation Revenue</h5>
                                    <h4 style="margin: 0; font-weight: bold;">
                                        <?php echo $currency_symbol . number_format($consult_revenue, 0); ?>
                                    </h4>
                                    <small class="text-muted">Consultations this year</small>
                                </div>
                            </div>
                            
                            <div class="col-md-3 text-center">
                                <div class="revenue-status-block">
                                    <i class="fa fa-plus-circle fa-3x text-navy"></i>
                                    <h5 class="text-navy" style="margin: 10px 0 5px 0;">Other Revenue</h5>
                                    <h4 style="margin: 0; font-weight: bold;">
                                        <?php 
                                        // Calculate other revenue sources
                                        $other_revenue = 0;
                                        $known_revenue = ($metrics['opd_revenue'] ?? 0) + 
                                                        ($metrics['ipd_revenue'] ?? 0) + 
                                                        ($metrics['pharmacy_revenue'] ?? 0) + 
                                                        ($metrics['pathology_revenue'] ?? 0) + 
                                                        $lab_revenue + 
                                                        $consult_revenue +
                                                        $radiology_revenue;
                                        $total_system_revenue = $total_revenue;
                                        $other_revenue = max(0, $total_system_revenue - $known_revenue);
                                        echo $currency_symbol . number_format($other_revenue, 0);
                                        ?>
                                    </h4>
                                    <small class="text-muted">Miscellaneous income</small>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Revenue Totals Summary -->
                        <hr style="margin: 20px 0; border-top: 2px solid #f4f4f4;">
                        <div class="row">
                            <div class="col-md-4 text-center">
                                <div class="summary-block bg-light-green" style="padding: 15px; border-radius: 5px; background: #f0f8ff;">
                                    <h4 style="margin: 0; color: #3c8dbc;">
                                        <i class="fa fa-calendar"></i> This Month
                                    </h4>
                                    <h3 style="margin: 10px 0; font-weight: bold; color: #3c8dbc;">
                                       <?php echo $currency_symbol . number_format($monthly_revenue, 0); ?>
                                   </h3>
                                   <small class="text-muted">Monthly total revenue</small>
                               </div>
                           </div>
                           
                           <div class="col-md-4 text-center">
                               <div class="summary-block bg-light-green" style="padding: 15px; border-radius: 5px; background: #f0fff0;">
                                   <h4 style="margin: 0; color: #00a65a;">
                                       <i class="fa fa-line-chart"></i> This Year
                                   </h4>
                                   <h3 style="margin: 10px 0; font-weight: bold; color: #00a65a;">
                                       <?php echo $currency_symbol . number_format($total_revenue, 0); ?>
                                   </h3>
                                   <small class="text-muted">Year-to-date revenue</small>
                               </div>
                           </div>
                           
                           <div class="col-md-4 text-center">
                               <div class="summary-block bg-light-yellow" style="padding: 15px; border-radius: 5px; background: #fffbf0;">
                                   <h4 style="margin: 0; color: #f39c12;">
                                       <i class="fa fa-target"></i> Progress
                                   </h4>
                                   <h3 style="margin: 10px 0; font-weight: bold; color: #f39c12;">
                                       <?php 
                                       $annual_target = ($metrics['monthly_target'] ?? 100000) * 12;
                                       $progress_percentage = $annual_target > 0 ? ($total_revenue / $annual_target) * 100 : 0;
                                       echo number_format($progress_percentage, 1) . '%';
                                       ?>
                                   </h3>
                                   <small class="text-muted">
                                       Target: <?php echo $currency_symbol . number_format($annual_target, 0); ?>
                                   </small>
                               </div>
                           </div>
                       </div>
                       
                       <!-- Fixed Radiology Revenue Info -->
                       <div class="row" style="margin-top: 20px;">
                           <div class="col-md-12">
                               <div class="alert alert-success" style="margin: 0;">
                                   <i class="fa fa-check-circle"></i> 
                                   <strong>Radiology Revenue Fix Applied:</strong> 
                                   Dashboard now correctly calculates radiology revenue from the <code>radiology_orders</code> table using the <code>total_amount</code> column for completed orders.
                                   <br>
                                   <small class="text-muted">
                                       Last updated: <?php echo date('F j, Y g:i A'); ?> | 
                                       Radiology Orders Table: <?php echo $this->db->table_exists('radiology_orders') ? 'Connected ✓' : 'Not Found ✗'; ?> | 
                                       Current YTD Radiology Revenue: <?php echo $currency_symbol . number_format($radiology_revenue, 2); ?>
                                   </small>
                               </div>
                           </div>
                       </div>
                       
                       <!-- Debug Information (only show in development) -->
                       <?php if (ENVIRONMENT === 'development') : ?>
                       <div class="row" style="margin-top: 15px;">
                           <div class="col-md-12">
                               <div class="alert alert-info" style="margin: 0;">
                                   <h5><i class="fa fa-bug"></i> Development Debug Info - Radiology Revenue</h5>
                                   <small>
                                       <strong>Radiology Orders Query:</strong>
                                       SELECT SUM(total_amount) FROM radiology_orders WHERE YEAR(created_at) = <?php echo date('Y'); ?> AND status IN ('completed', 'reported')
                                       <br>
                                       <strong>Total Revenue Calculation:</strong> 
                                       Base: <?php echo $currency_symbol . number_format($base_revenue, 2); ?> + 
                                       Lab: <?php echo $currency_symbol . number_format($lab_revenue, 2); ?> + 
                                       Consultation: <?php echo $currency_symbol . number_format($consult_revenue, 2); ?> + 
                                       Radiology: <?php echo $currency_symbol . number_format($radiology_revenue, 2); ?> = 
                                       <?php echo $currency_symbol . number_format($total_revenue, 2); ?>
                                       <br>
                                       <strong>Table Status:</strong>
                                       <?php 
                                       if ($this->db->table_exists('radiology_orders')) {
                                           echo 'radiology_orders table exists';
                                           if ($this->db->field_exists('total_amount', 'radiology_orders')) {
                                               echo ' and total_amount column exists ✓';
                                           } else {
                                               echo ' but total_amount column missing ✗';
                                           }
                                           if ($this->db->field_exists('status', 'radiology_orders')) {
                                               echo ' and status column exists ✓';
                                           } else {
                                               echo ' but status column missing ✗';
                                           }
                                       } else {
                                           echo 'radiology_orders table not found ✗';
                                       }
                                       ?>
                                   </small>
                               </div>
                           </div>
                       </div>
                       <?php endif; ?>
                   </div>
               </div>
           </div>
       </div>

       <!-- Recent Transactions and Reports -->
       <div class="row">
           <!-- Recent Transactions -->
           <div class="col-md-6">
               <div class="box box-info">
                   <div class="box-header with-border">
                       <h3 class="box-title">
                           <i class="fa fa-history"></i> Recent Transactions
                       </h3>
                       <div class="box-tools pull-right">
                           <a href="<?php echo base_url(); ?>admin/financial/journalentries" 
                              class="btn btn-box-tool">
                               <i class="fa fa-external-link"></i>
                           </a>
                       </div>
                   </div>
                   <div class="box-body">
                       <?php if (!empty($recent_transactions)) : ?>
                           <div class="table-responsive">
                               <table class="table table-condensed">
                                   <thead>
                                       <tr>
                                           <th>Date</th>
                                           <th>Reference</th>
                                           <th>Description</th>
                                           <th class="text-right">Amount</th>
                                       </tr>
                                   </thead>
                                   <tbody>
                                       <?php foreach (array_slice($recent_transactions, 0, 5) as $transaction) : ?>
                                           <tr>
                                               <td>
                                                   <small><?php echo date('M d', strtotime($transaction['date'])); ?></small>
                                               </td>
                                               <td>
                                                   <small class="label label-default">
                                                       <?php echo $transaction['reference_no']; ?>
                                                   </small>
                                               </td>
                                               <td>
                                                   <small><?php echo substr($transaction['description'], 0, 25) . (strlen($transaction['description']) > 25 ? '...' : ''); ?></small>
                                                   <?php if (isset($transaction['source_module']) && $transaction['source_module']) : ?>
                                                       <br>
                                                       <small class="text-muted">
                                                           <i class="fa fa-tag"></i> 
                                                           <?php echo ucfirst($transaction['source_module']); ?>
                                                       </small>
                                                   <?php endif; ?>
                                               </td>
                                               <td class="text-right">
                                                   <small>
                                                       <?php echo $currency_symbol; ?>
                                                       <?php echo number_format($transaction['total_amount'], 2); ?>
                                                   </small>
                                               </td>
                                           </tr>
                                       <?php endforeach; ?>
                                   </tbody>
                               </table>
                           </div>
                       <?php else : ?>
                           <div class="text-center">
                               <i class="fa fa-info-circle fa-2x text-muted"></i>
                               <p class="text-muted">No recent transactions found</p>
                               <a href="<?php echo base_url(); ?>admin/financial/journalentries" class="btn btn-primary btn-sm">
                                   <i class="fa fa-plus"></i> Add Transaction
                               </a>
                           </div>
                       <?php endif; ?>
                   </div>
               </div>
           </div>

           <!-- Financial Reports -->
           <div class="col-md-6">
               <div class="box box-warning">
                   <div class="box-header with-border">
                       <h3 class="box-title">
                           <i class="fa fa-file-text-o"></i> Financial Reports
                       </h3>
                   </div>
                   <div class="box-body">
                       <div class="list-group">
                           <a href="<?php echo base_url(); ?>admin/financial/balancesheet" 
                              class="list-group-item">
                               <i class="fa fa-pie-chart text-aqua"></i> Balance Sheet
                               <span class="pull-right text-muted small">
                                   <em>Assets & Liabilities</em>
                               </span>
                           </a>
                           <a href="<?php echo base_url(); ?>admin/financial/profitloss" 
                              class="list-group-item">
                               <i class="fa fa-line-chart text-green"></i> Profit & Loss
                               <span class="pull-right text-muted small">
                                   <em>Revenue & Expenses</em>
                               </span>
                           </a>
                           <a href="<?php echo base_url(); ?>admin/financial/generalledger" 
                              class="list-group-item">
                               <i class="fa fa-book text-yellow"></i> General Ledger
                               <span class="pull-right text-muted small">
                                   <em>Account Transactions</em>
                               </span>
                           </a>
                           <a href="<?php echo base_url(); ?>admin/financial/accountsreceivable" 
                              class="list-group-item">
                               <i class="fa fa-clock-o text-orange"></i> A/R Aging
                               <span class="pull-right text-muted small">
                                   <em>Outstanding Balances</em>
                               </span>
                           </a>
                           <a href="<?php echo base_url(); ?>admin/financial/cashflow" 
                              class="list-group-item">
                               <i class="fa fa-exchange text-purple"></i> Cash Flow
                               <span class="pull-right text-muted small">
                                   <em>Cash In/Out Analysis</em>
                               </span>
                           </a>
                       </div>
                   </div>
               </div>
           </div>
       </div>

   </section>
</div>

<style>
/* Revenue Status Block Styling */
.revenue-status-block {
   padding: 15px;
   border-radius: 8px;
   background: #ffffff;
   box-shadow: 0 2px 4px rgba(0,0,0,0.1);
   margin-bottom: 15px;
   border: 1px solid #f0f0f0;
   transition: all 0.3s ease;
}

.revenue-status-block:hover {
   transform: translateY(-2px);
   box-shadow: 0 4px 8px rgba(0,0,0,0.15);
}

/* Summary Block Styling */
.summary-block {
   border: 2px solid transparent;
   transition: all 0.3s ease;
}

.summary-block:hover {
   transform: translateY(-3px);
   box-shadow: 0 5px 15px rgba(0,0,0,0.1);
}

/* Text Colors */
.text-green { color: #00a65a; }
.text-blue { color: #3c8dbc; }
.text-yellow { color: #f39c12; }
.text-red { color: #dd4b39; }
.text-purple { color: #605ca8; }
.text-aqua { color: #00c0ef; }
.text-orange { color: #ff851b; }
.text-navy { color: #001f3f; }
.text-muted { color: #777; }

/* Alert Styles */
.alert-success {
   background-color: #dff0d8;
   border-color: #d6e9c6;
   color: #3c763d;
   border-radius: 4px;
   padding: 15px;
   border: 1px solid transparent;
}

.alert-info {
   background-color: #d9edf7;
   border-color: #bce8f1;
   color: #31708f;
   border-radius: 4px;
   padding: 15px;
   border: 1px solid transparent;
}

/* Icon Styling */
.fa-3x {
   font-size: 3em !important;
}
</style>

<script>
$(document).ready(function() {
   // Add hover effects
   $('.small-box').hover(
       function() {
           $(this).addClass('hover-effect');
       },
       function() {
           $(this).removeClass('hover-effect');
       }
   );
   
   // Collapsible boxes
   $('[data-widget="collapse"]').click(function() {
       var box = $(this).closest('.box');
       var boxBody = box.find('.box-body');
       var icon = $(this).find('i');
       
       if (boxBody.is(':visible')) {
           boxBody.slideUp();
           icon.removeClass('fa-minus').addClass('fa-plus');
       } else {
           boxBody.slideDown();
           icon.removeClass('fa-plus').addClass('fa-minus');
       }
   });
});

// Debug function
function debugDashboard() {
   console.log('Fixed Financial Dashboard Debug:');
   console.log('Currency Symbol: <?php echo $currency_symbol; ?>');
   console.log('Total Revenue: <?php echo $total_revenue ?? 0; ?>');
   console.log('Laboratory Revenue: <?php echo $lab_revenue ?? 0; ?>');
   console.log('Consultation Revenue: <?php echo $consult_revenue ?? 0; ?>');
   console.log('Radiology Revenue: <?php echo $radiology_revenue ?? 0; ?>');
   console.log('Using radiology_orders table for radiology revenue calculation');
}

debugDashboard();
</script>