<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            <i class="fa fa-pie-chart"></i> Balance Sheet
            <small>Assets, Liabilities and Equity</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/financial">Financial</a></li>
            <li class="active">Balance Sheet</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { echo $this->session->flashdata('msg'); } ?>
        
        <!-- Error Message Display -->
        <?php if (isset($error_message)): ?>
            <div class="alert alert-danger alert-dismissible">
                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                <h4><i class="icon fa fa-ban"></i> Error!</h4>
                <?php echo $error_message; ?>
            </div>
        <?php endif; ?>

        <!-- Date Selection -->
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-calendar"></i> As of Date</h3>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-box-tool" data-widget="collapse">
                        <i class="fa fa-minus"></i>
                    </button>
                </div>
            </div>
            <div class="box-body">
                <form method="get" id="balanceSheetForm">
                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="as_of_date">As of Date</label>
                                <div class="input-group date">
                                    <div class="input-group-addon">
                                        <i class="fa fa-calendar"></i>
                                    </div>
                                    <input type="date" class="form-control" name="as_of_date" id="as_of_date" 
                                           value="<?php echo isset($as_of_date) ? $as_of_date : date('Y-m-d'); ?>" required>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>&nbsp;</label>
                                <div class="btn-group btn-block">
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fa fa-refresh"></i> Generate
                                    </button>
                                    <button type="button" class="btn btn-success" id="exportBS">
                                        <i class="fa fa-download"></i> Export
                                    </button>
                                    <button type="button" class="btn btn-default" id="printBS">
                                        <i class="fa fa-print"></i> Print
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>Quick Dates</label>
                                <div class="btn-group btn-block">
                                    <button type="button" class="btn btn-default btn-sm quick-date" data-date="<?php echo date('Y-m-d'); ?>">Today</button>
                                    <button type="button" class="btn btn-default btn-sm quick-date" data-date="<?php echo date('Y-m-t'); ?>">Month End</button>
                                    <button type="button" class="btn btn-default btn-sm quick-date" data-date="<?php echo date('Y-12-31'); ?>">Year End</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Balance Sheet Header -->
        <div class="balance-sheet-header text-center">
            <h2>
                <?php 
                if (method_exists($this->customlib, 'getSchoolName')) {
                    echo $this->customlib->getSchoolName(); 
                } else {
                    echo 'Healthcare Management System';
                }
                ?>
            </h2>
           <h3>Balance Sheet</h3>
           <h4>As of <?php echo date('F d, Y', strtotime(isset($as_of_date) ? $as_of_date : date('Y-m-d'))); ?></h4>
       </div>

       <!-- Balance Check Summary -->
       <div class="row">
           <div class="col-md-4">
               <div class="info-box bg-aqua">
                   <span class="info-box-icon"><i class="fa fa-building"></i></span>
                   <div class="info-box-content">
                       <span class="info-box-text">Total Assets</span>
                       <span class="info-box-number">
                           <?php 
                           $currency_symbol = '';
                           if (method_exists($this->customlib, 'getSchoolCurrencyFormat')) {
                               $currency_symbol = $this->customlib->getSchoolCurrencyFormat();
                           } else {
                               $currency_symbol = 'KES '; // Default for Kenya
                           }
                           echo $currency_symbol;
                           echo number_format(isset($total_assets) ? $total_assets : 0, 2); 
                           ?>
                       </span>
                   </div>
               </div>
           </div>
           <div class="col-md-4">
               <div class="info-box bg-yellow">
                   <span class="info-box-icon"><i class="fa fa-credit-card"></i></span>
                   <div class="info-box-content">
                       <span class="info-box-text">Total Liabilities</span>
                       <span class="info-box-number">
                           <?php 
                           echo $currency_symbol;
                           echo number_format(isset($total_liabilities) ? $total_liabilities : 0, 2); 
                           ?>
                       </span>
                   </div>
               </div>
           </div>
           <div class="col-md-4">
               <div class="info-box bg-green">
                   <span class="info-box-icon"><i class="fa fa-bank"></i></span>
                   <div class="info-box-content">
                       <span class="info-box-text">Total Equity</span>
                       <span class="info-box-number">
                           <?php 
                           echo $currency_symbol;
                           echo number_format(isset($total_equity) ? $total_equity : 0, 2); 
                           ?>
                       </span>
                   </div>
               </div>
           </div>
       </div>

       <!-- Balance Equation Check -->
       <div class="row">
           <div class="col-md-12">
               <?php 
               $total_assets = isset($total_assets) ? $total_assets : 0;
               $total_liabilities = isset($total_liabilities) ? $total_liabilities : 0;
               $total_equity = isset($total_equity) ? $total_equity : 0;
               $total_liab_equity = $total_liabilities + $total_equity;
               $is_balanced = abs($total_assets - $total_liab_equity) < 0.01;
               ?>
               <div class="callout <?php echo $is_balanced ? 'callout-success' : 'callout-danger'; ?>">
                   <h4>
                       <i class="fa <?php echo $is_balanced ? 'fa-check' : 'fa-exclamation-triangle'; ?>"></i>
                       Balance Sheet Equation: Assets = Liabilities + Equity
                   </h4>
                   <p>
                       <strong>Assets:</strong> <?php echo $currency_symbol . number_format($total_assets, 2); ?> = 
                       <strong>Liabilities:</strong> <?php echo $currency_symbol . number_format($total_liabilities, 2); ?> + 
                       <strong>Equity:</strong> <?php echo $currency_symbol . number_format($total_equity, 2); ?>
                       (<?php echo $currency_symbol . number_format($total_liab_equity, 2); ?>)
                       
                       <?php if (!$is_balanced) : ?>
                           <br><span class="text-red">
                               <strong>Difference:</strong> <?php echo $currency_symbol . number_format(abs($total_assets - $total_liab_equity), 2); ?>
                           </span>
                       <?php endif; ?>
                   </p>
               </div>
           </div>
       </div>

       <!-- Balance Sheet Content -->
       <div class="row">
           <!-- Assets -->
           <div class="col-md-6">
               <div class="box box-success">
                   <div class="box-header with-border">
                       <h3 class="box-title"><i class="fa fa-building"></i> ASSETS</h3>
                       <div class="box-tools pull-right">
                           <button type="button" class="btn btn-box-tool" data-widget="collapse">
                               <i class="fa fa-minus"></i>
                           </button>
                       </div>
                   </div>
                   <div class="box-body">
                       <?php if (isset($assets) && !empty($assets)): ?>
                           <table class="table table-bordered table-hover">
                               <thead>
                                   <tr class="bg-light-blue">
                                       <th>Account</th>
                                       <th class="text-right">Amount</th>
                                   </tr>
                               </thead>
                               <tbody>
                                   <?php 
                                   $current_assets = 0;
                                   $fixed_assets = 0;
                                   
                                   foreach ($assets as $asset) : 
                                       // Categorize assets (you can customize this logic)
                                       if (strpos($asset['account_code'], '10') === 0 || strpos($asset['account_code'], '11') === 0 || strpos($asset['account_code'], '12') === 0 || strpos($asset['account_code'], '13') === 0) {
                                           $current_assets += $asset['balance'];
                                           $asset_type = 'current';
                                       } else {
                                           $fixed_assets += $asset['balance'];
                                           $asset_type = 'fixed';
                                       }
                                   ?>
                                       <tr class="asset-row" data-type="<?php echo $asset_type; ?>">
                                           <td>
                                               <?php if (isset($asset['id'])): ?>
                                                   <a href="<?php echo base_url(); ?>admin/financial/generalledger?account_id=<?php echo $asset['id']; ?>" 
                                                      target="_blank" class="text-blue account-link">
                                                       <?php echo htmlspecialchars($asset['account_name']); ?>
                                                   </a>
                                               <?php else: ?>
                                                   <?php echo htmlspecialchars($asset['account_name']); ?>
                                               <?php endif; ?>
                                               <br><small class="text-muted"><?php echo htmlspecialchars($asset['account_code']); ?></small>
                                           </td>
                                           <td class="text-right">
                                               <span class="currency-amount">
                                                   <?php echo $currency_symbol; ?>
                                                   <?php echo number_format($asset['balance'], 2); ?>
                                               </span>
                                           </td>
                                       </tr>
                                   <?php endforeach; ?>
                                   
                                   <!-- Current Assets Subtotal -->
                                   <?php if ($current_assets > 0) : ?>
                                       <tr class="subtotal-row">
                                           <td><strong>Current Assets</strong></td>
                                           <td class="text-right">
                                               <strong>
                                                   <?php echo $currency_symbol; ?>
                                                   <?php echo number_format($current_assets, 2); ?>
                                               </strong>
                                           </td>
                                       </tr>
                                   <?php endif; ?>
                                   
                                   <!-- Fixed Assets Subtotal -->
                                   <?php if ($fixed_assets > 0) : ?>
                                       <tr class="subtotal-row">
                                           <td><strong>Fixed Assets</strong></td>
                                           <td class="text-right">
                                               <strong>
                                                   <?php echo $currency_symbol; ?>
                                                   <?php echo number_format($fixed_assets, 2); ?>
                                               </strong>
                                           </td>
                                       </tr>
                                   <?php endif; ?>
                               </tbody>
                               <tfoot>
                                   <tr class="total-row bg-success">
                                       <th>TOTAL ASSETS</th>
                                       <th class="text-right">
                                           <?php echo $currency_symbol; ?>
                                           <?php echo number_format($total_assets, 2); ?>
                                       </th>
                                   </tr>
                               </tfoot>
                           </table>
                       <?php else: ?>
                           <div class="alert alert-info">
                               <h4><i class="icon fa fa-info"></i> No Asset Accounts</h4>
                               No asset accounts found. Please set up your chart of accounts first.
                           </div>
                       <?php endif; ?>
                   </div>
               </div>
           </div>

           <!-- Liabilities and Equity -->
           <div class="col-md-6">
               <!-- Liabilities -->
               <div class="box box-warning">
                   <div class="box-header with-border">
                       <h3 class="box-title"><i class="fa fa-credit-card"></i> LIABILITIES</h3>
                       <div class="box-tools pull-right">
                           <button type="button" class="btn btn-box-tool" data-widget="collapse">
                               <i class="fa fa-minus"></i>
                           </button>
                       </div>
                   </div>
                   <div class="box-body">
                       <?php if (isset($liabilities) && !empty($liabilities)): ?>
                           <table class="table table-bordered table-hover">
                               <thead>
                                   <tr class="bg-yellow">
                                       <th>Account</th>
                                       <th class="text-right">Amount</th>
                                   </tr>
                               </thead>
                               <tbody>
                                   <?php 
                                   $current_liabilities = 0;
                                   $long_term_liabilities = 0;
                                   
                                   foreach ($liabilities as $liability) : 
                                       // Categorize liabilities
                                       if (strpos($liability['account_code'], '20') === 0 || strpos($liability['account_code'], '21') === 0 || strpos($liability['account_code'], '22') === 0 || strpos($liability['account_code'], '23') === 0 || strpos($liability['account_code'], '24') === 0) {
                                           $current_liabilities += $liability['balance'];
                                           $liability_type = 'current';
                                       } else {
                                           $long_term_liabilities += $liability['balance'];
                                           $liability_type = 'long_term';
                                       }
                                   ?>
                                       <tr class="liability-row" data-type="<?php echo $liability_type; ?>">
                                           <td>
                                               <?php if (isset($liability['id'])): ?>
                                                   <a href="<?php echo base_url(); ?>admin/financial/generalledger?account_id=<?php echo $liability['id']; ?>" 
                                                      target="_blank" class="text-blue account-link">
                                                       <?php echo htmlspecialchars($liability['account_name']); ?>
                                                   </a>
                                               <?php else: ?>
                                                   <?php echo htmlspecialchars($liability['account_name']); ?>
                                               <?php endif; ?>
                                               <br><small class="text-muted"><?php echo htmlspecialchars($liability['account_code']); ?></small>
                                           </td>
                                           <td class="text-right">
                                               <span class="currency-amount">
                                                   <?php echo $currency_symbol; ?>
                                                   <?php echo number_format($liability['balance'], 2); ?>
                                               </span>
                                           </td>
                                       </tr>
                                   <?php endforeach; ?>
                                   
                                   <!-- Current Liabilities Subtotal -->
                                   <?php if ($current_liabilities > 0) : ?>
                                       <tr class="subtotal-row">
                                           <td><strong>Current Liabilities</strong></td>
                                           <td class="text-right">
                                               <strong>
                                                   <?php echo $currency_symbol; ?>
                                                   <?php echo number_format($current_liabilities, 2); ?>
                                               </strong>
                                           </td>
                                       </tr>
                                   <?php endif; ?>
                                   
                                   <!-- Long-term Liabilities Subtotal -->
                                   <?php if ($long_term_liabilities > 0) : ?>
                                       <tr class="subtotal-row">
                                           <td><strong>Long-term Liabilities</strong></td>
                                           <td class="text-right">
                                               <strong>
                                                   <?php echo $currency_symbol; ?>
                                                   <?php echo number_format($long_term_liabilities, 2); ?>
                                               </strong>
                                           </td>
                                       </tr>
                                   <?php endif; ?>
                               </tbody>
                               <tfoot>
                                   <tr class="total-row bg-yellow">
                                       <th>TOTAL LIABILITIES</th>
                                       <th class="text-right">
                                           <?php echo $currency_symbol; ?>
                                           <?php echo number_format($total_liabilities, 2); ?>
                                       </th>
                                   </tr>
                               </tfoot>
                           </table>
                       <?php else: ?>
                           <div class="alert alert-info">
                               <h4><i class="icon fa fa-info"></i> No Liability Accounts</h4>
                               No liability accounts found.
                           </div>
                       <?php endif; ?>
                   </div>
               </div>

               <!-- Equity -->
               <div class="box box-info">
                   <div class="box-header with-border">
                       <h3 class="box-title"><i class="fa fa-bank"></i> EQUITY</h3>
                       <div class="box-tools pull-right">
                           <button type="button" class="btn btn-box-tool" data-widget="collapse">
                               <i class="fa fa-minus"></i>
                           </button>
                       </div>
                   </div>
                   <div class="box-body">
                       <?php if (isset($equity) && !empty($equity)): ?>
                           <table class="table table-bordered table-hover">
                               <thead>
                                   <tr class="bg-aqua">
                                       <th>Account</th>
                                       <th class="text-right">Amount</th>
                                   </tr>
                               </thead>
                               <tbody>
                                   <?php foreach ($equity as $equity_item) : ?>
                                       <tr class="equity-row">
                                           <td>
                                               <?php if (isset($equity_item['account_code']) && isset($equity_item['id'])): ?>
                                                   <a href="<?php echo base_url(); ?>admin/financial/generalledger?account_id=<?php echo $equity_item['id']; ?>" 
                                                      target="_blank" class="text-blue account-link">
                                                       <?php echo htmlspecialchars($equity_item['account_name']); ?>
                                                   </a>
                                                   <br><small class="text-muted"><?php echo htmlspecialchars($equity_item['account_code']); ?></small>
                                               <?php else : ?>
                                                   <?php echo htmlspecialchars($equity_item['account_name']); ?>
                                               <?php endif; ?>
                                           </td>
                                           <td class="text-right">
                                               <span class="currency-amount">
                                                   <?php echo $currency_symbol; ?>
                                                   <?php echo number_format($equity_item['balance'], 2); ?>
                                               </span>
                                           </td>
                                       </tr>
                                   <?php endforeach; ?>
                               </tbody>
                               <tfoot>
                                   <tr class="total-row bg-aqua">
                                       <th>TOTAL EQUITY</th>
                                       <th class="text-right">
                                           <?php echo $currency_symbol; ?>
                                           <?php echo number_format($total_equity, 2); ?>
                                       </th>
                                   </tr>
                               </tfoot>
                           </table>
                       <?php else: ?>
                           <div class="alert alert-info">
                               <h4><i class="icon fa fa-info"></i> No Equity Accounts</h4>
                               No equity accounts found.
                           </div>
                       <?php endif; ?>
                   </div>
               </div>

               <!-- Total Liabilities + Equity -->
               <div class="box box-primary">
                   <div class="box-body">
                       <table class="table table-bordered">
                           <tbody>
                               <tr class="grand-total-row bg-blue">
                                   <th>TOTAL LIABILITIES + EQUITY</th>
                                   <th class="text-right">
                                       <?php echo $currency_symbol; ?>
                                       <?php echo number_format($total_liab_equity, 2); ?>
                                   </th>
                               </tr>
                           </tbody>
                       </table>
                   </div>
               </div>
           </div>
       </div>

       <!-- Financial Ratios -->
       <?php if ($total_assets > 0 || $total_liabilities > 0 || $total_equity > 0): ?>
       <div class="box box-default collapsed-box">
           <div class="box-header with-border">
               <h3 class="box-title"><i class="fa fa-calculator"></i> Key Financial Ratios</h3>
               <div class="box-tools pull-right">
                   <button type="button" class="btn btn-box-tool" data-widget="collapse">
                       <i class="fa fa-plus"></i>
                   </button>
               </div>
           </div>
           <div class="box-body">
               <div class="row">
                   <div class="col-md-3">
                       <div class="ratio-box">
                           <h4>Current Ratio</h4>
                           <span class="ratio-value">
                               <?php 
                               $current_ratio = (isset($current_liabilities) && $current_liabilities > 0) ? $current_assets / $current_liabilities : 'N/A';
                               echo is_numeric($current_ratio) ? number_format($current_ratio, 2) : $current_ratio;
                               ?>
                           </span>
                           <small>Current Assets ÷ Current Liabilities</small>
                       </div>
                   </div>
                   <div class="col-md-3">
                       <div class="ratio-box">
                           <h4>Debt-to-Equity</h4>
                           <span class="ratio-value">
                               <?php 
                               $debt_to_equity = ($total_equity > 0) ? $total_liabilities / $total_equity : 'N/A';
                               echo is_numeric($debt_to_equity) ? number_format($debt_to_equity, 2) : $debt_to_equity;
                               ?>
                           </span>
                           <small>Total Liabilities ÷ Total Equity</small>
                       </div>
                   </div>
                   <div class="col-md-3">
                       <div class="ratio-box">
                           <h4>Equity Ratio</h4>
                           <span class="ratio-value">
                               <?php 
                               $equity_ratio = ($total_assets > 0) ? ($total_equity / $total_assets) * 100 : 0;
                               echo number_format($equity_ratio, 1) . '%';
                               ?>
                           </span>
                           <small>Total Equity ÷ Total Assets</small>
                       </div>
                   </div>
                   <div class="col-md-3">
                       <div class="ratio-box">
                           <h4>Asset Coverage</h4>
                           <span class="ratio-value">
                               <?php 
                               $asset_coverage = ($total_liabilities > 0) ? ($total_assets / $total_liabilities) * 100 : 'N/A';
                               echo is_numeric($asset_coverage) ? number_format($asset_coverage, 1) . '%' : $asset_coverage;
                               ?>
                           </span>
                           <small>Total Assets ÷ Total Liabilities</small>
                       </div>
                   </div>
               </div>
           </div>
       </div>
       <?php endif; ?>

       <!-- Setup Notice -->
       <?php if ((!isset($assets) || empty($assets)) && (!isset($liabilities) || empty($liabilities)) && (!isset($equity) || empty($equity))): ?>
       <div class="box box-warning">
           <div class="box-header with-border">
               <h3 class="box-title"><i class="fa fa-warning"></i> Chart of Accounts Setup Required</h3>
           </div>
           <div class="box-body">
               <p>It appears your chart of accounts is not set up yet. To use the balance sheet:</p>
               <ol>
                   <li>Set up your chart of accounts with assets, liabilities, and equity accounts</li>
                   <li>Create journal entries for your financial transactions</li>
                   <li>Return to this page to view your balance sheet</li>
               </ol>
               <a href="<?php echo base_url(); ?>admin/financial/chartofaccounts" class="btn btn-primary">
                   <i class="fa fa-plus"></i> Set Up Chart of Accounts
               </a>
           </div>
       </div>
       <?php endif; ?>
   </section>
</div>

<!-- Loading Overlay -->
<div class="overlay" id="loadingOverlay" style="display: none;">
    <i class="fa fa-refresh fa-spin"></i>
</div>

<script>
$(document).ready(function() {
    // Quick date selection
    $('.quick-date').click(function() {
        var date = $(this).data('date');
        $('#as_of_date').val(date);
        showLoading();
        $('#balanceSheetForm').submit();
    });

    // Export balance sheet
    $('#exportBS').click(function() {
        var asOfDate = $('#as_of_date').val();
        if (asOfDate) {
            showLoading();
            window.open('<?php echo base_url(); ?>admin/financial/exportBalanceSheet?as_of_date=' + asOfDate, '_blank');
            hideLoading();
        } else {
            alert('Please select a date first.');
        }
    });

    // Print balance sheet
    $('#printBS').click(function() {
        var asOfDate = $('#as_of_date').val();
        if (asOfDate) {
            window.open('<?php echo base_url(); ?>admin/financial/printBalanceSheet?as_of_date=' + asOfDate, '_blank');
        } else {
            alert('Please select a date first.');
        }
    });

    // Auto-submit on date change
    $('#as_of_date').change(function() {
        showLoading();
        $('#balanceSheetForm').submit();
    });

    // Balance check animation
    <?php if ($is_balanced) : ?>
        $('.fa-check').addClass('animated pulse');
    <?php else : ?>
        $('.fa-exclamation-triangle').addClass('animated shake');
    <?php endif; ?>

    // Row hover effects
    $('.asset-row, .liability-row, .equity-row').hover(
        function() {
            $(this).addClass('row-hover');
        },
        function() {
            $(this).removeClass('row-hover');
        }
    );

    // Account drill-down
    $('a[href*="generalledger"]').click(function(e) {
        e.preventDefault();
        var url = $(this).attr('href') + '&date_to=' + $('#as_of_date').val();
        window.open(url, '_blank');
    });

    // Form submission with loading
    $('#balanceSheetForm').submit(function() {
        showLoading();
    });

    // Loading functions
    function showLoading() {
        $('#loadingOverlay').show();
    }

    function hideLoading() {
        $('#loadingOverlay').hide();
    }

    // Hide loading on page load complete
    $(window).on('load', function() {
        hideLoading();
    });

    // Tooltip initialization
    $('[data-toggle="tooltip"]').tooltip();
});
</script>

<style>
/* Enhanced AdminLTE Theme Alignment */
.balance-sheet-header {
    background: linear-gradient(135deg, #f4f4f4 0%, #e8e8e8 100%);
    padding: 25px;
    margin-bottom: 20px;
    border-radius: 5px;
    border: 1px solid #d2d6de;
    box-shadow: 0 1px 3px rgba(0,0,0,.12), 0 1px 2px rgba(0,0,0,.24);
}

.balance-sheet-header h2 {
    margin: 0;
    color: #333;
    font-weight: 300;
}

.balance-sheet-header h3 {
    margin: 5px 0;
    color: #666;
    font-weight: 400;
}

.balance-sheet-header h4 {
    margin: 5px 0 0 0;
    color: #999;
    font-weight: 300;
}

/* Info boxes enhancement */
.info-box {
    border-radius: 5px;
    box-shadow: 0 1px 3px rgba(0,0,0,.12), 0 1px 2px rgba(0,0,0,.24);
    transition: all 0.3s ease;
}

.info-box:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 8px rgba(0,0,0,.12), 0 2px 4px rgba(0,0,0,.24);
}

.info-box-number {
    font-size: 18px !important;
    font-weight: bold;
    font-family: 'Source Sans Pro', 'Helvetica Neue', Helvetica, Arial, sans-serif;
}

/* Table enhancements */
.table-hover tbody tr:hover {
    background-color: #f5f5f5;
    transition: background-color 0.15s ease-in-out;
}

.currency-amount {
    font-family: 'Courier New', 'Lucida Console', Monaco, monospace;
    font-weight: bold;
    color: #444;
}

.subtotal-row td {
    font-weight: bold;
    background-color: #f9f9f9;
    border-top: 2px solid #ddd;
    border-bottom: 1px solid #ddd;
}

.total-row th {
    font-size: 16px;
    font-weight: bold;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.grand-total-row th {
    font-size: 18px;
    font-weight: bold;
    text-transform: uppercase;
    letter-spacing: 1px;
}

/* Box enhancements */
.box {
    border-radius: 5px;
    box-shadow: 0 1px 3px rgba(0,0,0,.12), 0 1px 2px rgba(0,0,0,.24);
    transition: all 0.3s ease;
}

.box-header {
    border-bottom: 1px solid #f4f4f4;
}

.box-title {
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

/* Account links */
.account-link {
    text-decoration: none;
    color: #3c8dbc !important;
    font-weight: 500;
}

.account-link:hover {
    text-decoration: underline;
    color: #2c689b !important;
}

/* Row hover effects */
.row-hover {
    background-color: #f5f5f5 !important;
    cursor: pointer;
    transition: background-color 0.15s ease-in-out;
}

/* Financial ratios */
.ratio-box {
    text-align: center;
    padding: 20px 15px;
    background: linear-gradient(135deg, #f9f9f9 0%, #f0f0f0 100%);
    border-radius: 8px;
    margin-bottom: 15px;
    border: 1px solid #e0e0e0;
    transition: all 0.3s ease;
    position: relative;
}

.ratio-box:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,.1);
    border-color: #d0d0d0;
}

.ratio-box h4 {
    margin-top: 0;
    margin-bottom: 10px;
    color: #333;
    font-size: 14px;
    font-weight: 600;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.ratio-value {
    display: block;
    font-size: 28px;
    font-weight: bold;
    color: #3c8dbc;
    margin: 15px 0;
    line-height: 1;
    font-family: 'Source Sans Pro', sans-serif;
}

.ratio-box small {
    color: #666;
    font-size: 11px;
    line-height: 1.4;
    display: block;
    margin-top: 8px;
}

/* Callout enhancements */
.callout {
    border-radius: 5px;
    box-shadow: 0 2px 4px rgba(0,0,0,.1);
}

.callout-success {
    border-left: 5px solid #00a65a;
    background-color: #f0f9f0;
}

.callout-danger {
    border-left: 5px solid #dd4b39;
    background-color: #fdf2f2;
}

/* Loading overlay */
.overlay {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(255, 255, 255, 0.8);
    z-index: 9999;
    display: flex;
    justify-content: center;
    align-items: center;
}

.overlay i {
    font-size: 3em;
    color: #3c8dbc;
}

/* Button enhancements */
.btn-group .btn {
    transition: all 0.3s ease;
}

.btn-group .btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 2px 4px rgba(0,0,0,.2);
}

/* Quick date buttons */
.quick-date {
    transition: all 0.2s ease;
}

.quick-date:hover {
    background-color: #e6e6e6;
    border-color: #adadad;
}

.quick-date:active {
    transform: scale(0.98);
}

/* Alert enhancements */
.alert {
    border-radius: 5px;
    border: none;
    box-shadow: 0 2px 4px rgba(0,0,0,.1);
}

.alert-info {
    background-color: #d9edf7;
    border-left: 4px solid #31708f;
}

.alert-danger {
    background-color: #f2dede;
    border-left: 4px solid #a94442;
}

/* Responsive enhancements */
@media (max-width: 768px) {
    .balance-sheet-header {
        padding: 15px;
        text-align: center;
    }
    
    .info-box {
        margin-bottom: 15px;
    }
    
    .ratio-box {
        margin-bottom: 10px;
        padding: 15px 10px;
    }
    
    .ratio-value {
        font-size: 24px;
    }
    
    .btn-group {
        width: 100%;
    }
    
    .btn-group .btn {
        width: 33.33%;
        font-size: 12px;
    }
    
    .table-responsive {
        border: none;
    }
}

/* Print styles */
@media print {
    .box-tools,
    .btn,
    .btn-group,
    .breadcrumb,
    .callout,
    .ratio-box,
    .overlay,
    .alert {
        display: none !important;
    }
    
    .content-wrapper {
        margin: 0 !important;
        padding: 0 !important;
    }
    
    .box {
        box-shadow: none !important;
        border: 1px solid #ddd !important;
        margin-bottom: 10px !important;
        page-break-inside: avoid;
    }
    
    .balance-sheet-header {
        border: none !important;
        background: white !important;
        box-shadow: none !important;
        padding: 10px !important;
    }
    
    .table {
        font-size: 12px;
    }
    
    .currency-amount {
        font-size: 11px;
    }
    
    .info-box {
        display: none !important;
    }
    
    .row {
        margin: 0 !important;
    }
    
    .col-md-6 {
        width: 50% !important;
        float: left !important;
    }
    
    .box-header {
        background: #f7f7f7 !important;
        print-color-adjust: exact;
        -webkit-print-color-adjust: exact;
    }
    
    .total-row,
    .grand-total-row {
        background: #f0f0f0 !important;
        print-color-adjust: exact;
        -webkit-print-color-adjust: exact;
    }
}

/* Animations */
.animated {
    animation-duration: 1s;
    animation-fill-mode: both;
}

.pulse {
    animation-name: pulse;
    animation-iteration-count: 3;
}

.shake {
    animation-name: shake;
    animation-duration: 0.82s;
    animation-iteration-count: 3;
}

@keyframes pulse {
    from {
        transform: scale3d(1, 1, 1);
    }
    50% {
        transform: scale3d(1.05, 1.05, 1.05);
    }
    to {
        transform: scale3d(1, 1, 1);
    }
}

@keyframes shake {
    from, to {
        transform: translate3d(0, 0, 0);
    }
    10%, 30%, 50%, 70%, 90% {
        transform: translate3d(-10px, 0, 0);
    }
    20%, 40%, 60%, 80% {
        transform: translate3d(10px, 0, 0);
    }
}

/* Dark mode support (if needed) */
@media (prefers-color-scheme: dark) {
    .balance-sheet-header {
        background: linear-gradient(135deg, #2c2c2c 0%, #1a1a1a 100%);
        color: #f0f0f0;
        border-color: #444;
    }
    
    .balance-sheet-header h2,
    .balance-sheet-header h3,
    .balance-sheet-header h4 {
        color: #f0f0f0;
    }
}

/* Additional utility classes */
.text-muted {
    color: #777 !important;
}

.font-weight-bold {
    font-weight: bold !important;
}

.border-top-thick {
    border-top: 3px solid #ddd !important;
}

.border-bottom-thick {
    border-bottom: 3px solid #ddd !important;
}

/* Box specific color themes */
.box-success .box-header {
    background-color: #00a65a;
    color: white;
}

.box-warning .box-header {
    background-color: #f39c12;
    color: white;
}

.box-info .box-header {
    background-color: #3c8dbc;
    color: white;
}

.box-primary .box-header {
    background-color: #3c8dbc;
    color: white;
}

.box-default .box-header {
    background-color: #d2d6de;
    color: #444;
}
</style>