<div class="content-wrapper">
    <!-- Content Header -->
    <section class="content-header">
        <h1>
            <i class="fa fa-users"></i> Accounts Receivable
            <small>Outstanding customer balances</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/financial">Financial</a></li>
            <li class="active">Accounts Receivable</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { echo $this->session->flashdata('msg'); } ?>

        <!-- Summary Cards -->
        <div class="row">
            <div class="col-md-3">
                <div class="info-box bg-yellow">
                    <span class="info-box-icon"><i class="fa fa-money"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Outstanding</span>
                        <span class="info-box-number">
                            <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                            <?php 
                            $total_outstanding = 0;
                            if (!empty($receivables)) {
                                $total_outstanding = array_sum(array_column($receivables, 'balance'));
                            }
                            echo number_format($total_outstanding, 2);
                            ?>
                        </span>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="info-box bg-blue">
                    <span class="info-box-icon"><i class="fa fa-users"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Customers</span>
                        <span class="info-box-number">
                            <?php echo !empty($receivables) ? count($receivables) : 0; ?>
                        </span>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="info-box bg-green">
                    <span class="info-box-icon"><i class="fa fa-clock-o"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Average Days Outstanding</span>
                        <span class="info-box-number">
                            <?php 
                            // Calculate average days outstanding
                            $avg_days = 0;
                            if (!empty($receivables)) {
                                $total_days = 0;
                                foreach ($receivables as $rec) {
                                    if ($rec['last_transaction_date']) {
                                        $days = (strtotime(date('Y-m-d')) - strtotime($rec['last_transaction_date'])) / (60 * 60 * 24);
                                        $total_days += $days;
                                    }
                                }
                                $avg_days = count($receivables) > 0 ? $total_days / count($receivables) : 0;
                            }
                            echo round($avg_days);
                            ?> days
                        </span>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="info-box bg-red">
                    <span class="info-box-icon"><i class="fa fa-warning"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Overdue Amount</span>
                        <span class="info-box-number">
                            <?php 
                            $overdue_amount = 0;
                            if (isset($aging['over_90'])) {
                                $overdue_amount = $aging['over_90'];
                            }
                            echo $this->customlib->getHospitalCurrencyFormat() . number_format($overdue_amount, 2);
                            ?>
                        </span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Aging Analysis -->
        <div class="box box-info">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-pie-chart"></i> Aging Analysis</h3>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-success btn-sm" id="exportAging">
                        <i class="fa fa-download"></i> Export
                    </button>
                </div>
            </div>
            <div class="box-body">
                <?php if (isset($aging) && !empty($aging)) : ?>
                    <div class="row">
                        <div class="col-md-3">
                            <div class="aging-box current">
                                <h4>Current (0-30 days)</h4>
                                <div class="aging-amount">
                                    <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                    <?php echo number_format($aging['current_30'] ?? 0, 2); ?>
                                </div>
                                <div class="aging-percentage">
                                    <?php 
                                    $current_pct = $total_outstanding > 0 ? (($aging['current_30'] ?? 0) / $total_outstanding) * 100 : 0;
                                    echo number_format($current_pct, 1) . '%';
                                    ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="aging-box days-31-60">
                                <h4>31-60 days</h4>
                                <div class="aging-amount">
                                    <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                    <?php echo number_format($aging['days_31_60'] ?? 0, 2); ?>
                                </div>
                                <div class="aging-percentage">
                                    <?php 
                                    $days_31_60_pct = $total_outstanding > 0 ? (($aging['days_31_60'] ?? 0) / $total_outstanding) * 100 : 0;
                                    echo number_format($days_31_60_pct, 1) . '%';
                                    ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="aging-box days-61-90">
                                <h4>61-90 days</h4>
                                <div class="aging-amount">
                                    <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                    <?php echo number_format($aging['days_61_90'] ?? 0, 2); ?>
                                </div>
                                <div class="aging-percentage">
                                    <?php 
                                    $days_61_90_pct = $total_outstanding > 0 ? (($aging['days_61_90'] ?? 0) / $total_outstanding) * 100 : 0;
                                    echo number_format($days_61_90_pct, 1) . '%';
                                    ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="aging-box over-90">
                                <h4>Over 90 days</h4>
                                <div class="aging-amount">
                                    <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                    <?php echo number_format($aging['over_90'] ?? 0, 2); ?>
                                </div>
                                <div class="aging-percentage">
                                    <?php 
                                    $over_90_pct = $total_outstanding > 0 ? (($aging['over_90'] ?? 0) / $total_outstanding) * 100 : 0;
                                    echo number_format($over_90_pct, 1) . '%';
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Aging Chart -->
                    <div class="row" style="margin-top: 20px;">
                        <div class="col-md-6">
                            <canvas id="agingChart" height="200"></canvas>
                        </div>
                        <div class="col-md-6">
                            <div class="aging-summary">
                                <h5>Collection Performance</h5>
                                <div class="performance-metrics">
                                    <div class="metric">
                                        <span class="metric-label">Current Ratio:</span>
                                        <span class="metric-value <?php echo ($current_pct >= 70) ? 'text-green' : (($current_pct >= 50) ? 'text-orange' : 'text-red'); ?>">
                                            <?php echo number_format($current_pct, 1); ?>%
                                        </span>
                                    </div>
                                    <div class="metric">
                                        <span class="metric-label">Overdue Ratio:</span>
                                        <span class="metric-value <?php echo ($over_90_pct <= 10) ? 'text-green' : (($over_90_pct <= 20) ? 'text-orange' : 'text-red'); ?>">
                                            <?php echo number_format($over_90_pct, 1); ?>%
                                        </span>
                                    </div>
                                    <div class="metric">
                                        <span class="metric-label">Collection Risk:</span>
                                        <span class="metric-value">
                                            <?php 
                                            if ($over_90_pct <= 10) echo '<span class="text-green">Low</span>';
                                            elseif ($over_90_pct <= 20) echo '<span class="text-orange">Medium</span>';
                                            else echo '<span class="text-red">High</span>';
                                            ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php else : ?>
                    <div class="alert alert-info text-center">
                        <h4><i class="icon fa fa-info"></i> No Aging Data</h4>
                        <p>No outstanding receivables found.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Outstanding Balances -->
        <div class="box box-warning">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-list"></i> Outstanding Balances</h3>
                <div class="box-tools pull-right">
                    <div class="btn-group">
                        <button type="button" class="btn btn-success btn-sm" id="sendReminders">
                            <i class="fa fa-envelope"></i> Send Reminders
                        </button>
                        <button type="button" class="btn btn-primary btn-sm" id="exportReceivables">
                            <i class="fa fa-download"></i> Export
                        </button>
                        <button type="button" class="btn btn-default btn-sm" id="printReceivables">
                            <i class="fa fa-print"></i> Print
                        </button>
                    </div>
                </div>
            </div>
            <div class="box-body">
                <?php if (!empty($receivables)) : ?>
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped" id="receivablesTable">
                            <thead>
                                <tr>
                                    <th>
                                        <input type="checkbox" id="selectAll">
                                    </th>
                                    <th>Patient ID</th>
                                    <th>Patient Name</th>
                                    <th>Contact</th>
                                    <th class="text-right">Outstanding Balance</th>
                                    <th>Last Transaction</th>
                                    <th>Days Outstanding</th>
                                    <th>Risk Level</th>
                                    <th class="text-center">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($receivables as $receivable) : 
                                    $days_outstanding = 0;
                                    if ($receivable['last_transaction_date']) {
                                        $days_outstanding = (strtotime(date('Y-m-d')) - strtotime($receivable['last_transaction_date'])) / (60 * 60 * 24);
                                    }
                                    
                                    // Determine risk level
                                    $risk_level = 'Low';
                                    $risk_class = 'label-success';
                                    if ($days_outstanding > 90) {
                                        $risk_level = 'High';
                                        $risk_class = 'label-danger';
                                    } elseif ($days_outstanding > 60) {
                                        $risk_level = 'Medium';
                                        $risk_class = 'label-warning';
                                    }
                                ?>
                                    <tr class="receivable-row" data-patient-id="<?php echo $receivable['patient_id']; ?>">
                                        <td>
                                            <input type="checkbox" class="patient-checkbox" value="<?php echo $receivable['patient_id']; ?>">
                                        </td>
                                        <td>
                                            <a href="<?php echo base_url(); ?>admin/patient/patient_profile/<?php echo $receivable['patient_id']; ?>" 
                                               target="_blank" class="text-blue">
                                                <?php echo str_pad($receivable['patient_id'], 6, '0', STR_PAD_LEFT); ?>
                                            </a>
                                        </td>
                                        <td>
                                            <strong><?php echo $receivable['patient_name']; ?></strong>
                                        </td>
                                        <td>
                                            <?php echo $receivable['mobileno'] ?: 'N/A'; ?>
                                        </td>
                                        <td class="text-right">
                                            <span class="currency-amount text-red">
                                                <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                                <?php echo number_format($receivable['balance'], 2); ?>
                                            </span>
                                        </td>
                                        <td>
                                            <?php echo $receivable['last_transaction_date'] ? date('d-M-Y', strtotime($receivable['last_transaction_date'])) : 'N/A'; ?>
                                        </td>
                                        <td>
                                            <span class="days-outstanding <?php 
                                                if ($days_outstanding <= 30) echo 'text-green';
                                                elseif ($days_outstanding <= 60) echo 'text-orange';
                                                else echo 'text-red';
                                            ?>">
                                                <?php echo round($days_outstanding); ?> days
                                            </span>
                                        </td>
                                        <td>
                                            <span class="label <?php echo $risk_class; ?>">
                                                <?php echo $risk_level; ?>
                                            </span>
                                        </td>
                                        <td class="text-center">
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-xs btn-info view-details" 
                                                        data-patient-id="<?php echo $receivable['patient_id']; ?>" title="View Details">
                                                    <i class="fa fa-eye"></i>
                                                </button>
                                                <button type="button" class="btn btn-xs btn-primary send-reminder" 
                                                        data-patient-id="<?php echo $receivable['patient_id']; ?>" title="Send Reminder">
                                                    <i class="fa fa-envelope"></i>
                                                </button>
                                                <button type="button" class="btn btn-xs btn-success record-payment" 
                                                        data-patient-id="<?php echo $receivable['patient_id']; ?>" title="Record Payment">
                                                    <i class="fa fa-money"></i>
                                                </button>
                                                <button type="button" class="btn btn-xs btn-warning write-off" 
                                                        data-patient-id="<?php echo $receivable['patient_id']; ?>" title="Write Off">
                                                    <i class="fa fa-times"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                            <tfoot>
                                <tr class="bg-gray">
                                    <th colspan="4">TOTAL</th>
                                    <th class="text-right">
                                        <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>
                                        <?php echo number_format($total_outstanding, 2); ?>
                                    </th>
                                    <th colspan="4"></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                <?php else : ?>
                    <div class="alert alert-success text-center">
                        <h4><i class="icon fa fa-check"></i> All Clear!</h4>
                        <p>No outstanding receivables found. All payments are up to date.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="box box-default">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-cogs"></i> Actions</h3>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-md-3">
                        <button type="button" class="btn btn-primary btn-block" id="generateStatements">
                            <i class="fa fa-file-text"></i> Generate Statements
                        </button>
                    </div>
                    <div class="col-md-3">
                        <button type="button" class="btn btn-warning btn-block" id="agingReport">
                            <i class="fa fa-clock-o"></i> Aging Report
                        </button>
                    </div>
                    <div class="col-md-3">
                        <button type="button" class="btn btn-info btn-block" id="collectionReport">
                            <i class="fa fa-bar-chart"></i> Collection Report
                        </button>
                    </div>
                    <div class="col-md-3">
                        <button type="button" class="btn btn-success btn-block" id="reconcileAccounts">
                            <i class="fa fa-check-square"></i> Reconcile Accounts
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Payment Recording Modal -->
<div class="modal fade" id="paymentModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Record Payment</h4>
            </div>
            <form id="paymentForm">
                <div class="modal-body">
                    <input type="hidden" id="payment_patient_id" name="patient_id">
                    
                    <div class="form-group">
                        <label>Patient</label>
                        <input type="text" class="form-control" id="payment_patient_name" readonly>
                    </div>
                    
                    <div class="form-group">
                        <label>Outstanding Balance</label>
                        <input type="text" class="form-control" id="outstanding_balance" readonly>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="payment_amount">Payment Amount <span class="text-red">*</span></label>
                                <input type="number" class="form-control" name="amount" id="payment_amount" 
                                       step="0.01" min="0" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="payment_mode">Payment Mode <span class="text-red">*</span></label>
                                <select class="form-control" name="payment_mode" id="payment_mode" required>
                                    <option value="">Select Mode</option>
                                    <option value="cash">Cash</option>
                                    <option value="cheque">Cheque</option>
                                    <option value="bank">Bank Transfer</option>
                                    <option value="card">Card</option>
                                    <option value="online">Online Payment</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="payment_date">Payment Date <span class="text-red">*</span></label>
                        <input type="date" class="form-control" name="payment_date" id="payment_date" 
                               value="<?php echo date('Y-m-d'); ?>" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="payment_reference">Reference/Cheque No</label>
                        <input type="text" class="form-control" name="reference" id="payment_reference">
                    </div>
                    
                    <div class="form-group">
                        <label for="payment_notes">Notes</label>
                        <textarea class="form-control" name="notes" id="payment_notes" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">Record Payment</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Write-off Modal -->
<div class="modal fade" id="writeOffModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">Write Off Account</h4>
            </div>
            <form id="writeOffForm">
                <div class="modal-body">
                    <input type="hidden" id="writeoff_patient_id" name="patient_id">
                    
                    <div class="alert alert-warning">
                        <i class="fa fa-warning"></i> 
                        <strong>Warning:</strong> This action will write off the outstanding balance and cannot be undone.
                    </div>
                    
                    <div class="form-group">
                        <label>Patient</label>
                        <input type="text" class="form-control" id="writeoff_patient_name" readonly>
                    </div>
                    
                    <div class="form-group">
                        <label>Write-off Amount</label>
                        <input type="text" class="form-control" id="writeoff_amount" readonly>
                    </div>
                    
                    <div class="form-group">
                        <label for="writeoff_reason">Reason for Write-off <span class="text-red">*</span></label>
                        <select class="form-control" name="reason" id="writeoff_reason" required>
                            <option value="">Select Reason</option>
                            <option value="bad_debt">Bad Debt</option>
                            <option value="uncollectible">Uncollectible</option>
                            <option value="patient_deceased">Patient Deceased</option>
                            <option value="administrative_error">Administrative Error</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="writeoff_notes">Additional Notes <span class="text-red">*</span></label>
                        <textarea class="form-control" name="notes" id="writeoff_notes" rows="3" 
                                  placeholder="Please provide detailed explanation..." required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">Write Off</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
$(document).ready(function() {
    // Initialize DataTable
    $('#receivablesTable').DataTable({
        "order": [[ 6, "desc" ]], // Sort by days outstanding
        "pageLength": 25,
        "responsive": true,
        "columnDefs": [
            { "orderable": false, "targets": [0, 8] }
        ]
    });

    // Initialize aging chart
    initializeAgingChart();

    // Select all checkbox
    $('#selectAll').change(function() {
        $('.patient-checkbox').prop('checked', this.checked);
    });

    // Individual checkbox change
    $('.patient-checkbox').change(function() {
        if (!this.checked) {
            $('#selectAll').prop('checked', false);
        }
    });

    // View details
    $('.view-details').click(function() {
        var patientId = $(this).data('patient-id');
        window.open('<?php echo base_url(); ?>admin/patient/profile/' + patientId, '_blank');
    });

    // Record payment
    $('.record-payment').click(function() {
        var patientId = $(this).data('patient-id');
        var row = $(this).closest('tr');
        var patientName = row.find('td:nth-child(3)').text().trim();
        var balance = row.find('.currency-amount').text().replace(/[^0-9.-]/g, '');
        
        $('#payment_patient_id').val(patientId);
        $('#payment_patient_name').val(patientName);
        $('#outstanding_balance').val('<?php echo $this->customlib->getHospitalCurrencyFormat(); ?>' + balance);
        $('#payment_amount').attr('max', balance);
        
        $('#paymentModal').modal('show');
    });

    // Write off
    $('.write-off').click(function() {
        var patientId = $(this).data('patient-id');
        var row = $(this).closest('tr');
        var patientName = row.find('td:nth-child(3)').text().trim();
        var balance = row.find('.currency-amount').text().replace(/[^0-9.-]/g, '');
        
        $('#writeoff_patient_id').val(patientId);
        $('#writeoff_patient_name').val(patientName);
        $('#writeoff_amount').val('<?php echo $this->customlib->getHospitalCurrencyFormat(); ?>' + balance);
        
        $('#writeOffModal').modal('show');
    });

    // Payment form submission
    $('#paymentForm').on('submit', function(e) {
        e.preventDefault();
        var formData = $(this).serialize();
        
        $.ajax({
            url: '<?php echo base_url(); ?>admin/financial/recordPayment',
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#paymentModal').modal('hide');
                    showAlert('success', 'Payment recorded successfully!');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    showAlert('danger', response.message || 'Error recording payment');
                }
            },
            error: function() {
                showAlert('danger', 'An error occurred while recording payment');
            }
        });
    });

    // Write-off form submission
    $('#writeOffForm').on('submit', function(e) {
        e.preventDefault();
        
        if (!confirm('Are you sure you want to write off this amount? This action cannot be undone.')) {
            return;
        }
        
        var formData = $(this).serialize();
        
        $.ajax({
            url: '<?php echo base_url(); ?>admin/financial/writeOffAccount',
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#writeOffModal').modal('hide');
                    showAlert('success', 'Account written off successfully!');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    showAlert('danger', response.message || 'Error writing off account');
                }
            },
            error: function() {
                showAlert('danger', 'An error occurred while writing off account');
            }
        });
    });

    // Export functions
    $('#exportReceivables').click(function() {
        window.open('<?php echo base_url(); ?>admin/financial/exportAccountsReceivable', '_blank');
    });

    $('#exportAging').click(function() {
        window.open('<?php echo base_url(); ?>admin/financial/exportReceivableAging', '_blank');
    });

    // Print function
    $('#printReceivables').click(function() {
        window.open('<?php echo base_url(); ?>admin/financial/printAccountsReceivable', '_blank');
    });

    // Send reminders
    $('#sendReminders').click(function() {
        var selectedPatients = [];
        $('.patient-checkbox:checked').each(function() {
            selectedPatients.push($(this).val());
        });
        
        if (selectedPatients.length === 0) {
            alert('Please select at least one patient to send reminders.');
            return;
        }
        
        if (confirm('Send payment reminders to ' + selectedPatients.length + ' patient(s)?')) {
            $.ajax({
                url: '<?php echo base_url(); ?>admin/financial/sendPaymentReminders',
                type: 'POST',
                data: { patient_ids: selectedPatients },
                dataType: 'json',
                success: function(response) {
                    if (response.status === 'success') {
                        showAlert('success', 'Reminders sent successfully to ' + response.sent_count + ' patient(s)');
                    } else {
                        showAlert('danger', response.message || 'Error sending reminders');
                    }
                },
                error: function() {
                    showAlert('danger', 'An error occurred while sending reminders');
                }
            });
        }
    });

    // Action buttons
    $('#generateStatements').click(function() {
        window.open('<?php echo base_url(); ?>admin/financial/generateStatements', '_blank');
    });

    $('#agingReport').click(function() {
        window.open('<?php echo base_url(); ?>admin/financial/agingReport', '_blank');
    });

    $('#collectionReport').click(function() {
        window.open('<?php echo base_url(); ?>admin/financial/collectionReport', '_blank');
    });

    $('#reconcileAccounts').click(function() {
        window.location.href = '<?php echo base_url(); ?>admin/financial/reconcileReceivables';
    });
});

function initializeAgingChart() {
    var ctx = document.getElementById('agingChart').getContext('2d');
    
    var data = {
        labels: ['Current (0-30)', '31-60 days', '61-90 days', 'Over 90 days'],
        datasets: [{
            data: [
                <?php echo $aging['current_30'] ?? 0; ?>,
                <?php echo $aging['days_31_60'] ?? 0; ?>,
                <?php echo $aging['days_61_90'] ?? 0; ?>,
                <?php echo $aging['over_90'] ?? 0; ?>
            ],
            backgroundColor: ['#00a65a', '#f39c12', '#dd4b39', '#605ca8']
        }]
    };
    
    new Chart(ctx, {
        type: 'doughnut',
        data: data,
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom'
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            var value = context.parsed || 0;
                            var total = context.dataset.data.reduce((a, b) => a + b, 0);
                            var percentage = total > 0 ? ((value / total) * 100).toFixed(1) : 0;
                            return context.label + ': <?php echo $this->customlib->getHospitalCurrencyFormat(); ?>' + 
                                   value.toLocaleString() + ' (' + percentage + '%)';
                        }
                    }
                }
            }
        }
    });
}

function showAlert(type, message) {
    var alertHtml = '<div class="alert alert-' + type + ' alert-dismissible">' +
                   '<button type="button" class="close" data-dismiss="alert">&times;</button>' +
                   message +
                   '</div>';
    
    $('.content').prepend(alertHtml);
    
    setTimeout(function() {
        $('.alert').fadeOut();
    }, 5000);
}
</script>

<style>
.aging-box {
    text-align: center;
    padding: 20px;
    border-radius: 5px;
    margin-bottom: 15px;
    border: 1px solid #ddd;
}

.aging-box.current {
    background-color: #d4edda;
    border-color: #c3e6cb;
}

.aging-box.days-31-60 {
    background-color: #fff3cd;
    border-color: #ffeaa7;
}

.aging-box.days-61-90 {
    background-color: #f8d7da;
    border-color: #f5c6cb;
}

.aging-box.over-90 {
    background-color: #e2e3e5;
    border-color: #d6d8db;
}

.aging-box h4 {
    margin-top: 0;
    font-size: 14px;
    color: #333;
}

.aging-amount {
    font-size: 24px;
    font-weight: bold;
    color: #333;
    margin: 10px 0;
}

.aging-percentage {
    font-size: 16px;
    color: #666;
}

.currency-amount {
    font-family: 'Courier New', monospace;
    font-weight: bold;
}

.days-outstanding {
    font-weight: bold;
}

.performance-metrics {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 5px;
}

.metric {
    display: flex;
    justify-content: space-between;
    margin-bottom: 10px;
    padding: 5px 0;
    border-bottom: 1px solid #dee2e6;
}

.metric:last-child {
    border-bottom: none;
    margin-bottom: 0;
}

.metric-label {
    font-weight: bold;
}

.metric-value {
    font-weight: bold;
}

.receivable-row:hover {
    background-color: #f5f5f5;
}

.info-box-number {
    font-size: 18px !important;
    font-weight: bold;
}

@media print {
    .box-tools,
    .btn,
    .breadcrumb,
    .modal {
        display: none !important;
    }
    
    .content-wrapper {
        margin: 0 !important;
        padding: 0 !important;
    }
    
    .box {
        box-shadow: none !important;
        border: 1px solid #ddd !important;
    }
    
    .table {
        font-size: 12px;
    }
}

.risk-indicator {
    font-size: 12px;
    padding: 2px 6px;
    border-radius: 3px;
}

.aging-summary {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 5px;
    height: 200px;
}

.collection-actions {
    margin-top: 20px;
}

.overdue-highlight {
    background-color: #fff5f5 !important;
}

.patient-link {
    text-decoration: none;
}

.patient-link:hover {
    text-decoration: underline;
}

.ar-export-buttons {
    margin-bottom: 15px;
}

.payment-modal .form-group {
    margin-bottom: 15px;
}

.writeoff-warning {
    background: #fff3cd;
    border: 1px solid #ffeaa7;
    padding: 10px;
    border-radius: 3px;
    margin-bottom: 15px;
}
</style>