<?php
/**
 * Control Center Dashboard View
 * Hospital Management System - Unified Admin Dashboard
 */
?>

<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-dashboard"></i> Hospital Control Center
            <small>Unified System Management Dashboard</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> <?php echo $this->lang->line('dashboard'); ?></a></li>
            <li class="active">Control Center</li>
        </ol>
    </section>

    <section class="content">
        
        <!-- Real-time Status Bar -->
        <div class="row">
            <div class="col-md-12">
                <div class="alert alert-info" id="realTimeStatus">
                    <i class="fa fa-clock-o"></i> 
                    <strong>System Status:</strong> 
                    <span id="systemTime"><?php echo date('Y-m-d H:i:s'); ?></span> | 
                    <span id="activeUsers">Loading...</span> | 
                    <span id="systemLoad">Loading...</span>
                    <button class="btn btn-xs btn-default pull-right" onclick="refreshDashboard()">
                        <i class="fa fa-refresh"></i> Refresh
                    </button>
                </div>
            </div>
        </div>

        <!-- Key Performance Indicators -->
        <div class="row">
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3 id="totalPatients"><?php echo $system_stats['total_patients'] ?? 0; ?></h3>
                        <p>Total Patients</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-users"></i>
                    </div>
                    <a href="<?php echo base_url('admin/patient'); ?>" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3 id="todayRegistrations"><?php echo $system_stats['today_registrations'] ?? 0; ?></h3>
                        <p>Today's Registrations</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-user-plus"></i>
                    </div>
                    <a href="<?php echo base_url('admin/patient/search'); ?>" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3 id="activeQueues"><?php echo array_sum(array_column($queue_overview ?? [], 'waiting')); ?></h3>
                        <p>Active Queues</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-clock-o"></i>
                    </div>
                    <a href="<?php echo base_url('admin/queue'); ?>" class="small-box-footer">
                        More info <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3 id="systemAlerts"><?php echo count($system_alerts ?? []); ?></h3>
                        <p>System Alerts</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-warning"></i>
                    </div>
                    <a href="#alertsModal" data-toggle="modal" class="small-box-footer">
                        View alerts <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Department Overview -->
        <div class="row">
            <div class="col-md-8">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-hospital-o"></i> Department Queue Overview</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-box-tool" onclick="refreshQueues()">
                                <i class="fa fa-refresh"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>Department</th>
                                        <th>Waiting</th>
                                        <th>In Service</th>
                                        <th>Today Total</th>
                                        <th>Avg Wait Time</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody id="queueOverviewTable">
                                    <?php if (!empty($queue_overview)): ?>
                                        <?php foreach ($queue_overview as $dept => $queue): ?>
                                            <tr>
                                                <td>
                                                    <strong><?php echo $queue['department']; ?></strong>
                                                </td>
                                                <td>
                                                    <span class="badge bg-yellow"><?php echo $queue['waiting']; ?></span>
                                                </td>
                                                <td>
                                                    <span class="badge bg-blue"><?php echo $queue['in_service']; ?></span>
                                                </td>
                                                <td>
                                                    <span class="badge bg-green"><?php echo $queue['total_today']; ?></span>
                                                </td>
                                                <td>
                                                    <?php echo $queue['avg_wait_time']; ?> min
                                                </td>
                                                <td>
                                                    <?php 
                                                    $status_class = $queue['waiting'] > 10 ? 'danger' : ($queue['waiting'] > 5 ? 'warning' : 'success');
                                                    $status_text = $queue['waiting'] > 10 ? 'High Load' : ($queue['waiting'] > 5 ? 'Busy' : 'Normal');
                                                    ?>
                                                    <span class="label label-<?php echo $status_class; ?>"><?php echo $status_text; ?></span>
                                                </td>
                                                <td>
                                                    <a href="<?php echo base_url('admin/queue/department/' . $dept); ?>" class="btn btn-xs btn-primary">
                                                        <i class="fa fa-eye"></i> View
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <tr>
                                            <td colspan="7" class="text-center text-muted">No queue data available</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <!-- Quick Actions Panel -->
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-bolt"></i> Quick Actions</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-xs-6">
                                <a href="<?php echo base_url('admin/patient/create'); ?>" class="btn btn-block btn-primary">
                                    <i class="fa fa-user-plus"></i><br>
                                    Register Patient
                                </a>
                            </div>
                            <div class="col-xs-6">
                                <a href="<?php echo base_url('admin/triage'); ?>" class="btn btn-block btn-warning">
                                    <i class="fa fa-stethoscope"></i><br>
                                    Triage
                                </a>
                            </div>
                        </div>
                        <div class="row" style="margin-top: 10px;">
                            <div class="col-xs-6">
                                <a href="<?php echo base_url('admin/pharmacy'); ?>" class="btn btn-block btn-info">
                                    <i class="fa fa-pills"></i><br>
                                    Pharmacy
                                </a>
                            </div>
                            <div class="col-xs-6">
                                <a href="<?php echo base_url('admin/laboratory'); ?>" class="btn btn-block btn-success">
                                    <i class="fa fa-flask"></i><br>
                                    Laboratory
                                </a>
                            </div>
                        </div>
                        <div class="row" style="margin-top: 10px;">
                            <div class="col-xs-6">
                                <button onclick="clearCache()" class="btn btn-block btn-default">
                                    <i class="fa fa-refresh"></i><br>
                                    Clear Cache
                                </button>
                            </div>
                            <div class="col-xs-6">
                                <button onclick="optimizeDatabase()" class="btn btn-block btn-default">
                                    <i class="fa fa-database"></i><br>
                                    Optimize DB
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- System Health Panel -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-heartbeat"></i> System Health</h3>
                    </div>
                    <div class="box-body">
                        <div id="systemHealthPanel">
                            <?php if (!empty($system_stats['system_health'])): ?>
                                <p><strong>PHP Version:</strong> <?php echo $system_stats['system_health']['php_version'] ?? 'Unknown'; ?></p>
                                <p><strong>Memory Usage:</strong> <?php echo $system_stats['system_health']['memory_usage'] ?? 'Unknown'; ?></p>
                                <p><strong>Database:</strong> <?php echo $system_stats['system_health']['database_version'] ?? 'Unknown'; ?></p>
                                <p><strong>Server Time:</strong> <?php echo $system_stats['system_health']['server_time'] ?? date('Y-m-d H:i:s'); ?></p>
                            <?php else: ?>
                                <p class="text-muted">Loading system health...</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Department Statistics -->
        <div class="row">
            <?php if (!empty($department_stats)): ?>
                <!-- OPD Stats -->
                <?php if (!empty($department_stats['opd'])): ?>
                <div class="col-md-3">
                    <div class="info-box">
                        <span class="info-box-icon bg-aqua"><i class="fa fa-user-md"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">OPD Appointments</span>
                            <span class="info-box-number"><?php echo $department_stats['opd']['total_appointments'] ?? 0; ?></span>
                            <div class="progress">
                                <div class="progress-bar" style="width: 70%"></div>
                            </div>
                            <span class="progress-description">
                                <?php echo $department_stats['opd']['today_appointments'] ?? 0; ?> today
                            </span>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <!-- IPD Stats -->
                <?php if (!empty($department_stats['ipd'])): ?>
                <div class="col-md-3">
                    <div class="info-box">
                        <span class="info-box-icon bg-red"><i class="fa fa-bed"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">IPD Patients</span>
                            <span class="info-box-number"><?php echo $department_stats['ipd']['current_patients'] ?? 0; ?></span>
                            <div class="progress">
                                <div class="progress-bar" style="width: 50%"></div>
                            </div>
                            <span class="progress-description">
                                <?php echo $department_stats['ipd']['today_admissions'] ?? 0; ?> admitted today
                            </span>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Pharmacy Stats -->
                <?php if (!empty($department_stats['pharmacy'])): ?>
                <div class="col-md-3">
                    <div class="info-box">
                        <span class="info-box-icon bg-green"><i class="fa fa-pills"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">Pharmacy Bills</span>
                            <span class="info-box-number"><?php echo $department_stats['pharmacy']['total_bills'] ?? 0; ?></span>
                            <div class="progress">
                                <div class="progress-bar" style="width: 80%"></div>
                            </div>
                            <span class="progress-description">
                                $<?php echo number_format($department_stats['pharmacy']['today_revenue'] ?? 0, 2); ?> today
                            </span>
                        </div>
                    </div>
                </div>
                <?php endif; ?>

                <!-- Laboratory Stats -->
                <?php if (!empty($department_stats['laboratory'])): ?>
                <div class="col-md-3">
                    <div class="info-box">
                        <span class="info-box-icon bg-yellow"><i class="fa fa-flask"></i></span>
                        <div class="info-box-content">
                            <span class="info-box-text">Lab Tests</span>
                            <span class="info-box-number"><?php echo $department_stats['laboratory']['total_tests'] ?? 0; ?></span>
                            <div class="progress">
                                <div class="progress-bar" style="width: 60%"></div>
                            </div>
                            <span class="progress-description">
                                <?php echo $department_stats['laboratory']['today_tests'] ?? 0; ?> today
                            </span>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>

        <!-- Recent Activities and System Alerts -->
        <div class="row">
            <div class="col-md-6">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-clock-o"></i> Recent Activities</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="timeline" id="recentActivitiesTimeline">
                            <?php if (!empty($recent_activities)): ?>
                                <?php foreach (array_slice($recent_activities, 0, 10) as $activity): ?>
                                    <div class="timeline-item">
                                        <span class="time">
                                            <i class="fa fa-clock-o"></i> 
                                            <?php echo date('H:i', strtotime($activity['created_at'])); ?>
                                        </span>
                                        <div class="timeline-body">
                                            <?php
                                            $icon = '';
                                            $color = 'info';
                                            switch($activity['type']) {
                                                case 'patient_registration':
                                                    $icon = 'fa-user-plus';
                                                    $color = 'success';
                                                    $text = "New patient registered: " . $activity['name'];
                                                    break;
                                                case 'pharmacy_bill':
                                                    $icon = 'fa-pills';
                                                    $color = 'primary';
                                                    $text = "Pharmacy bill generated: " . $activity['name'];
                                                    break;
                                                case 'lab_test':
                                                    $icon = 'fa-flask';
                                                    $color = 'warning';
                                                    $text = "Lab test ordered: " . $activity['name'];
                                                    break;
                                                default:
                                                    $icon = 'fa-info';
                                                    $text = $activity['name'];
                                            }
                                            ?>
                                            <i class="fa <?php echo $icon; ?> text-<?php echo $color; ?>"></i>
                                            <?php echo $text; ?>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <p class="text-muted">No recent activities</p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-warning"></i> System Alerts</h3>
                        <div class="box-tools pull-right">
                            <span class="badge bg-yellow" id="alertCount"><?php echo count($system_alerts ?? []); ?></span>
                        </div>
                    </div>
                    <div class="box-body">
                        <div id="systemAlertsPanel" style="max-height: 300px; overflow-y: auto;">
                            <?php if (!empty($system_alerts)): ?>
                                <?php foreach ($system_alerts as $alert): ?>
                                    <div class="alert alert-<?php echo $alert['type']; ?> alert-dismissible">
                                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                        <h5><i class="icon fa fa-<?php echo $alert['type'] == 'danger' ? 'ban' : ($alert['type'] == 'warning' ? 'warning' : 'info'); ?>"></i> <?php echo $alert['title']; ?></h5>
                                        <?php echo $alert['message']; ?>
                                        <small class="text-muted">
                                            <br><?php echo $alert['category']; ?> | <?php echo date('H:i', strtotime($alert['timestamp'])); ?>
                                        </small>
                                    </div>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <div class="alert alert-success">
                                    <i class="fa fa-check"></i> All systems running normally
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Performance Metrics -->
        <?php if (!empty($performance_metrics)): ?>
        <div class="row">
            <div class="col-md-12">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-line-chart"></i> Performance Metrics</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-4">
                                <h4>Patient Flow</h4>
                                <canvas id="patientFlowChart" width="200" height="100"></canvas>
                            </div>
                            <div class="col-md-4">
                                <h4>Revenue Breakdown</h4>
                                <canvas id="revenueChart" width="200" height="100"></canvas>
                            </div>
                            <div class="col-md-4">
                                <h4>Department Utilization</h4>
                                <canvas id="utilizationChart" width="200" height="100"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>

    </section>
</div>

<!-- System Alerts Modal -->
<div class="modal fade" id="alertsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title"><i class="fa fa-warning"></i> System Alerts</h4>
            </div>
            <div class="modal-body">
                <div id="alertsModalContent">
                    <!-- Alerts content will be loaded here -->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" onclick="markAllAlertsRead()">Mark All Read</button>
            </div>
        </div>
    </div>
</div>

<!-- JavaScript for real-time updates and interactions -->
<script>
$(document).ready(function() {
    // Initialize dashboard
    initializeControlCenter();
    
    // Set up real-time updates every 30 seconds
    setInterval(updateDashboard, 30000);
    
    // Update system time every second
    setInterval(updateSystemTime, 1000);
});

function initializeControlCenter() {
    console.log('Control Center Dashboard initialized');
    updateDashboard();
    loadSystemHealth();
}

function updateSystemTime() {
    $('#systemTime').text(new Date().toLocaleString());
}

function updateDashboard() {
    $.ajax({
        url: '<?php echo base_url("admin/control_center/get_dashboard_data"); ?>',
        type: 'POST',
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                updateQueueOverview(response.data.queue_status);
                updateRecentActivities(response.data.recent_activities);
                updateSystemAlerts(response.data.system_alerts);
                updatePerformanceSummary(response.data.performance_summary);
            }
        },
        error: function() {
            console.error('Failed to update dashboard data');
        }
    });
}

function refreshDashboard() {
    updateDashboard();
    showMessage('Dashboard refreshed', 'success');
}

function refreshQueues() {
    updateDashboard();
    showMessage('Queue data refreshed', 'info');
}

function updateQueueOverview(queueData) {
    // Update queue overview table
    let tbody = $('#queueOverviewTable');
    tbody.empty();
    
    if (queueData && Object.keys(queueData).length > 0) {
        $.each(queueData, function(dept, queue) {
            let statusClass = queue.waiting > 10 ? 'danger' : (queue.waiting > 5 ? 'warning' : 'success');
            let statusText = queue.waiting > 10 ? 'High Load' : (queue.waiting > 5 ? 'Busy' : 'Normal');
            
            let row = `
                <tr>
                    <td><strong>${queue.department}</strong></td>
                    <td><span class="badge bg-yellow">${queue.waiting}</span></td>
                    <td><span class="badge bg-blue">${queue.in_service}</span></td>
                    <td><span class="badge bg-green">${queue.total_today}</span></td>
                    <td>${queue.avg_wait_time} min</td>
                    <td><span class="label label-${statusClass}">${statusText}</span></td>
                    <td>
                        <a href="<?php echo base_url('admin/queue/department/'); ?>${dept}" class="btn btn-xs btn-primary">
                            <i class="fa fa-eye"></i> View
                        </a>
                    </td>
                </tr>
            `;
            tbody.append(row);
        });
    } else {
        tbody.append('<tr><td colspan="7" class="text-center text-muted">No queue data available</td></tr>');
    }
}

function updateRecentActivities(activities) {
    let timeline = $('#recentActivitiesTimeline');
    timeline.empty();
    
    if (activities && activities.length > 0) {
        $.each(activities.slice(0, 10), function(index, activity) {
            let icon = 'fa-info';
            let color = 'info';
            let text = activity.name;
            
            switch(activity.type) {
                case 'patient_registration':
                    icon = 'fa-user-plus';
                    color = 'success';
                    text = `New patient registered: ${activity.name}`;
                    break;
                case 'pharmacy_bill':
                    icon = 'fa-pills';
                    color = 'primary';
                    text = `Pharmacy bill generated: ${activity.name}`;
                    break;
                case 'lab_test':
                    icon = 'fa-flask';
                    color = 'warning';
                    text = `Lab test ordered: ${activity.name}`;
                    break;
            }
            
            let time = new Date(activity.created_at).toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'});
            
            let item = `
                <div class="timeline-item">
                    <span class="time">
                        <i class="fa fa-clock-o"></i> ${time}
                    </span>
                    <div class="timeline-body">
                        <i class="fa ${icon} text-${color}"></i>
                        ${text}
                    </div>
                </div>
            `;
            timeline.append(item);
        });
    } else {
        timeline.append('<p class="text-muted">No recent activities</p>');
    }
}

function updateSystemAlerts(alerts) {
    let panel = $('#systemAlertsPanel');
    let count = $('#alertCount');
    
    count.text(alerts.length);
    panel.empty();
    
    if (alerts && alerts.length > 0) {
        $.each(alerts, function(index, alert) {
            let alertHtml = `
                <div class="alert alert-${alert.type} alert-dismissible">
                    <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                    <h5><i class="icon fa fa-${alert.type === 'danger' ? 'ban' : (alert.type === 'warning' ? 'warning' : 'info')}"></i> ${alert.title}</h5>
                    ${alert.message}
                    <small class="text-muted">
                        <br>${alert.category} | ${new Date(alert.timestamp).toLocaleTimeString([], {hour: '2-digit', minute:'2-digit'})}
                    </small>
                </div>
            `;
            panel.append(alertHtml);
        });
    } else {
        panel.append(`
            <div class="alert alert-success">
                <i class="fa fa-check"></i> All systems running normally
            </div>
        `);
    }
}

function updatePerformanceSummary(summary) {
    if (summary) {
        $('#totalPatients').text(summary.patients_today || 0);
        $('#todayRegistrations').text(summary.patients_today || 0);
        $('#activeQueues').text(summary.active_queues || 0);
        $('#systemAlerts').text(summary.alerts_count || 0);
    }
}

function loadSystemHealth() {
    $.ajax({
        url: '<?php echo base_url("admin/control_center/get_system_health"); ?>',
        type: 'POST',
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                updateSystemHealthPanel(response.data);
            }
        },
        error: function() {
            console.error('Failed to load system health data');
        }
    });
}

function updateSystemHealthPanel(health) {
    let panel = $('#systemHealthPanel');
    let html = `
        <p><strong>PHP Version:</strong> ${health.php_version || 'Unknown'}</p>
        <p><strong>Memory Usage:</strong> ${health.memory_usage || 'Unknown'}</p>
        <p><strong>Database:</strong> ${health.database_version || 'Unknown'}</p>
        <p><strong>Server Time:</strong> ${health.server_time || new Date().toLocaleString()}</p>
    `;
    panel.html(html);
}

function clearCache() {
    if (confirm('Are you sure you want to clear the system cache?')) {
        $.ajax({
            url: '<?php echo base_url("admin/control_center/clear_cache"); ?>',
            type: 'POST',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    showMessage('Cache cleared successfully', 'success');
                } else {
                    showMessage('Failed to clear cache: ' + response.message, 'error');
                }
            },
            error: function() {
                showMessage('Error clearing cache', 'error');
            }
        });
    }
}

function optimizeDatabase() {
    if (confirm('Are you sure you want to optimize the database? This may take a few minutes.')) {
        $.ajax({
            url: '<?php echo base_url("admin/control_center/optimize_database"); ?>',
            type: 'POST',
            dataType: 'json',
            beforeSend: function() {
                showMessage('Optimizing database...', 'info');
            },
            success: function(response) {
                if (response.status === 'success') {
                    showMessage('Database optimized successfully', 'success');
                } else {
                    showMessage('Failed to optimize database: ' + response.message, 'error');
                }
            },
            error: function() {
                showMessage('Error optimizing database', 'error');
            }
        });
    }
}

function showMessage(message, type) {
    // Create and show a bootstrap alert
    let alertClass = type === 'success' ? 'alert-success' : 
                     type === 'error' ? 'alert-danger' : 
                     type === 'warning' ? 'alert-warning' : 'alert-info';
    
    let alert = `
        <div class="alert ${alertClass} alert-dismissible" style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 300px;">
            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
            ${message}
        </div>
    `;
    
    $('body').append(alert);
    
    // Auto-dismiss after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut();
    }, 5000);
}

function markAllAlertsRead() {
    // Implementation for marking alerts as read
    showMessage('All alerts marked as read', 'success');
    $('#alertsModal').modal('hide');
}

// Initialize tooltips and popovers
$(function () {
    $('[data-toggle="tooltip"]').tooltip();
    $('[data-toggle="popover"]').popover();
});
</script>