<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-eye"></i> Requisition Details
            <small><?php echo $requisition->requisition_number; ?></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/consumable">Consumable Store</a></li>
            <li><a href="<?php echo base_url(); ?>admin/consumable/requisitions">Requisitions</a></li>
            <li class="active"><?php echo $requisition->requisition_number; ?></li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { ?>
            <div class="row">
                <div class="col-md-12">
                    <?php echo $this->session->flashdata('msg'); ?>
                </div>
            </div>
        <?php } ?>

        <!-- Requisition Header -->
        <div class="row">
            <div class="col-md-8">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-info-circle"></i> Requisition Information
                        </h3>
                        <div class="box-tools pull-right">
                            <?php
                            $status_class = 'label-default';
                            switch ($requisition->status) {
                                case 'draft': $status_class = 'label-default'; break;
                                case 'pending_approval': $status_class = 'label-warning'; break;
                                case 'approved': $status_class = 'label-success'; break;
                                case 'partially_fulfilled': $status_class = 'label-info'; break;
                                case 'fulfilled': $status_class = 'label-primary'; break;
                                case 'rejected': $status_class = 'label-danger'; break;
                                case 'cancelled': $status_class = 'label-default'; break;
                            }
                            
                            $priority_class = 'label-info';
                            switch ($requisition->priority) {
                                case 'low': $priority_class = 'label-default'; break;
                                case 'medium': $priority_class = 'label-info'; break;
                                case 'high': $priority_class = 'label-warning'; break;
                                case 'urgent': $priority_class = 'label-danger'; break;
                            }
                            ?>
                            <span class="label <?php echo $status_class; ?> label-lg">
                                <?php echo ucwords(str_replace('_', ' ', $requisition->status)); ?>
                            </span>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-condensed">
                                    <tr>
                                        <th width="35%">Requisition #:</th>
                                        <td><strong><?php echo $requisition->requisition_number; ?></strong></td>
                                    </tr>
                                    <tr>
                                        <th>Department:</th>
                                        <td>
                                            <span class="label label-primary">
                                                <?php echo $requisition->department_name; ?>
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Requested By:</th>
                                        <td><?php echo $requisition->requested_by_name . ' ' . $requisition->requested_by_surname; ?></td>
                                    </tr>
                                    <tr>
                                        <th>Request Date:</th>
                                        <td><?php echo date('M j, Y', strtotime($requisition->request_date)); ?></td>
                                    </tr>
                                    <tr>
                                        <th>Required Date:</th>
                                        <td>
                                            <?php if ($requisition->required_date) { ?>
                                                <?php echo date('M j, Y', strtotime($requisition->required_date)); ?>
                                                <?php 
                                                $is_overdue = strtotime($requisition->required_date) < time() && 
                                                            !in_array($requisition->status, ['fulfilled', 'rejected', 'cancelled']);
                                                if ($is_overdue) { ?>
                                                    <span class="label label-danger">Overdue</span>
                                                <?php } ?>
                                            <?php } else { ?>
                                                <small class="text-muted">Not specified</small>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-condensed">
                                    <tr>
                                        <th width="35%">Priority:</th>
                                        <td>
                                            <span class="label <?php echo $priority_class; ?>">
                                                <?php echo ucfirst($requisition->priority); ?>
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Status:</th>
                                        <td>
                                            <span class="label <?php echo $status_class; ?>">
                                                <?php echo ucwords(str_replace('_', ' ', $requisition->status)); ?>
                                            </span>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Total Est. Cost:</th>
                                        <td><strong>KES <?php echo number_format($requisition->total_estimated_cost, 2); ?></strong></td>
                                    </tr>
                                    <?php if ($requisition->approved_by_name) { ?>
                                        <tr>
                                            <th>Approved By:</th>
                                            <td><?php echo $requisition->approved_by_name . ' ' . $requisition->approved_by_surname; ?></td>
                                        </tr>
                                        <tr>
                                            <th>Approved Date:</th>
                                            <td><?php echo date('M j, Y H:i', strtotime($requisition->approved_date)); ?></td>
                                        </tr>
                                    <?php } ?>
                                </table>
                            </div>
                        </div>

                        <!-- Purpose and Justification -->
                        <div class="row">
                            <div class="col-md-12">
                                <h5><strong>Purpose:</strong></h5>
                                <p class="text-info"><?php echo $requisition->purpose; ?></p>
                                
                                <?php if ($requisition->justification) { ?>
                                    <h5><strong>Justification:</strong></h5>
                                    <p class="text-muted"><?php echo nl2br($requisition->justification); ?></p>
                                <?php } ?>
                                
                                <?php if ($requisition->approval_comments) { ?>
                                    <h5><strong>Approval Comments:</strong></h5>
                                    <div class="alert alert-success">
                                        <i class="fa fa-check-circle"></i> <?php echo nl2br($requisition->approval_comments); ?>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Actions Panel -->
            <div class="col-md-4">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-cogs"></i> Actions</h3>
                    </div>
                    <div class="box-body">
                        <?php if ($requisition->status == 'pending_approval' && $this->rbac->hasPrivilege('consumable_store', 'can_approve')) { ?>
                            <button class="btn btn-success btn-block" onclick="approveRequisition()">
                                <i class="fa fa-check"></i> Approve Requisition
                            </button>
                            <button class="btn btn-danger btn-block" onclick="rejectRequisition()">
                                <i class="fa fa-times"></i> Reject Requisition
                            </button>
                            <hr>
                        <?php } ?>
                        
                        <?php if ($requisition->status == 'approved' && $this->rbac->hasPrivilege('consumable_store', 'can_edit')) { ?>
                            <button class="btn btn-primary btn-block" onclick="fulfillRequisition()">
                                <i class="fa fa-truck"></i> Mark as Fulfilled
                            </button>
                            <hr>
                        <?php } ?>
                        
                        <button class="btn btn-info btn-block" onclick="printRequisition()">
                            <i class="fa fa-print"></i> Print Requisition
                        </button>
                        
                        <button class="btn btn-default btn-block" onclick="exportToPDF()">
                            <i class="fa fa-file-pdf-o"></i> Export as PDF
                        </button>
                        
                        <?php if (in_array($requisition->status, ['draft', 'pending_approval']) && $this->rbac->hasPrivilege('consumable_store', 'can_edit')) { ?>
                            <hr>
                            <button class="btn btn-warning btn-block" onclick="editRequisition()">
                                <i class="fa fa-edit"></i> Edit Requisition
                            </button>
                        <?php } ?>
                        
                        <?php if (in_array($requisition->status, ['draft', 'pending_approval']) && $this->rbac->hasPrivilege('consumable_store', 'can_delete')) { ?>
                            <button class="btn btn-danger btn-block" onclick="cancelRequisition()">
                                <i class="fa fa-ban"></i> Cancel Requisition
                            </button>
                        <?php } ?>
                    </div>
                </div>

                <!-- Timeline -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-clock-o"></i> Timeline</h3>
                    </div>
                    <div class="box-body">
                        <ul class="timeline timeline-inverse">
                            <li class="time-label">
                                <span class="bg-blue"><?php echo date('M j, Y', strtotime($requisition->created_at)); ?></span>
                            </li>
                            <li>
                                <i class="fa fa-file-text bg-blue"></i>
                                <div class="timeline-item">
                                    <span class="time"><i class="fa fa-clock-o"></i> <?php echo date('H:i', strtotime($requisition->created_at)); ?></span>
                                    <h3 class="timeline-header">Requisition Created</h3>
                                    <div class="timeline-body">
                                        Requisition created by <?php echo $requisition->requested_by_name . ' ' . $requisition->requested_by_surname; ?>
                                    </div>
                                </div>
                            </li>
                            
                            <?php if ($requisition->approved_date) { ?>
                                <li>
                                    <i class="fa fa-check bg-green"></i>
                                    <div class="timeline-item">
                                        <span class="time"><i class="fa fa-clock-o"></i> <?php echo date('H:i', strtotime($requisition->approved_date)); ?></span>
                                        <h3 class="timeline-header">Approved</h3>
                                        <div class="timeline-body">
                                            Approved by <?php echo $requisition->approved_by_name . ' ' . $requisition->approved_by_surname; ?>
                                        </div>
                                    </div>
                                </li>
                            <?php } ?>
                            
                            <?php if ($requisition->fulfilled_date) { ?>
                                <li>
                                    <i class="fa fa-truck bg-purple"></i>
                                    <div class="timeline-item">
                                        <span class="time"><i class="fa fa-clock-o"></i> <?php echo date('H:i', strtotime($requisition->fulfilled_date)); ?></span>
                                        <h3 class="timeline-header">Fulfilled</h3>
                                        <div class="timeline-body">
                                            Items released to department
                                        </div>
                                    </div>
                                </li>
                            <?php } ?>
                            
                            <li>
                                <i class="fa fa-clock-o bg-gray"></i>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Requisition Items -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-list"></i> Requested Items 
                            <span class="label label-info"><?php echo count($requisition->items); ?> items</span>
                        </h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($requisition->items)) { ?>
                            <div class="table-responsive">
                                <table class="table table-striped table-bordered">
                                    <thead>
                                        <tr>
                                            <th>Item</th>
                                            <th>Available Stock</th>
                                            <th>Requested Qty</th>
                                            <th>Approved Qty</th>
                                            <th>Fulfilled Qty</th>
                                            <th>Unit Cost</th>
                                            <th>Total Cost</th>
                                            <th>Status</th>
                                            <th>Justification</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $total_requested = 0;
                                        $total_approved = 0;
                                        $total_fulfilled = 0;
                                        
                                        foreach ($requisition->items as $item) { 
                                            $total_requested += $item->total_cost_estimated;
                                            $total_approved += ($item->quantity_approved * $item->unit_cost_estimated);
                                            $total_fulfilled += ($item->quantity_fulfilled * $item->unit_cost_estimated);
                                            
                                            // Determine fulfillment status
                                            $fulfillment_status = 'Pending';
                                            $status_class = 'label-warning';
                                            
                                            if ($item->quantity_fulfilled >= $item->quantity_requested) {
                                                $fulfillment_status = 'Complete';
                                                $status_class = 'label-success';
                                            } elseif ($item->quantity_fulfilled > 0) {
                                                $fulfillment_status = 'Partial';
                                                $status_class = 'label-info';
                                            } elseif ($item->quantity_approved == 0) {
                                                $fulfillment_status = 'Not Approved';
                                                $status_class = 'label-danger';
                                            }
                                        ?>
                                            <tr>
                                                <td>
                                                    <strong><?php echo $item->consumable_name; ?></strong>
                                                    <br><small class="text-muted"><?php echo $item->consumable_code; ?></small>
                                                </td>
                                                <td class="text-center">
                                                    <?php echo number_format($item->current_stock); ?> <?php echo $item->unit_of_measure; ?>
                                                    <?php if ($item->quantity_requested > $item->current_stock) { ?>
                                                        <br><small class="text-danger">Insufficient Stock</small>
                                                    <?php } ?>
                                                </td>
                                                <td class="text-center">
                                                    <strong><?php echo number_format($item->quantity_requested); ?></strong>
                                                </td>
                                                <td class="text-center">
                                                    <?php if ($item->quantity_approved > 0) { ?>
                                                        <span class="text-success">
                                                            <strong><?php echo number_format($item->quantity_approved); ?></strong>
                                                        </span>
                                                    <?php } else { ?>
                                                        <span class="text-muted">-</span>
                                                    <?php } ?>
                                                </td>
                                                <td class="text-center">
                                                    <?php if ($item->quantity_fulfilled > 0) { ?>
                                                        <span class="text-primary">
                                                            <strong><?php echo number_format($item->quantity_fulfilled); ?></strong>
                                                        </span>
                                                    <?php } else { ?>
                                                        <span class="text-muted">-</span>
                                                    <?php } ?>
                                                </td>
                                                <td class="text-right">
                                                    KES <?php echo number_format($item->unit_cost_estimated, 2); ?>
                                                </td>
                                                <td class="text-right">
                                                    <strong>KES <?php echo number_format($item->total_cost_estimated, 2); ?></strong>
                                                </td>
                                                <td class="text-center">
                                                    <span class="label <?php echo $status_class; ?>">
                                                        <?php echo $fulfillment_status; ?>
                                                    </span>
                                                </td>
                                                <td>
                                                    <?php if ($item->justification) { ?>
                                                        <small><?php echo $item->justification; ?></small>
                                                    <?php } else { ?>
                                                        <small class="text-muted">No justification provided</small>
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot>
                                        <tr class="bg-gray">
                                            <th colspan="6" class="text-right">Totals:</th>
                                            <th class="text-right">
                                                <div>Requested: KES <?php echo number_format($total_requested, 2); ?></div>
                                                <?php if ($total_approved > 0) { ?>
                                                    <div>Approved: KES <?php echo number_format($total_approved, 2); ?></div>
                                                <?php } ?>
                                                <?php if ($total_fulfilled > 0) { ?>
                                                    <div>Fulfilled: KES <?php echo number_format($total_fulfilled, 2); ?></div>
                                                <?php } ?>
                                            </th>
                                            <th colspan="2"></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        <?php } else { ?>
                            <div class="text-center text-muted" style="padding: 50px;">
                                <i class="fa fa-info-circle fa-3x"></i>
                                <h4>No Items</h4>
                                <p>No items have been added to this requisition.</p>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Back Button -->
        <div class="row">
            <div class="col-md-12">
                <a href="<?php echo base_url(); ?>admin/consumable/requisitions" class="btn btn-default">
                    <i class="fa fa-arrow-left"></i> Back to Requisitions List
                </a>
            </div>
        </div>

    </section>
</div>

<!-- Approval Modal -->
<div class="modal fade" id="approvalModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-check"></i> Approve Requisition
                </h4>
            </div>
            <form action="<?php echo base_url(); ?>admin/consumable/approve_requisition/<?php echo $requisition->id; ?>" method="post">
                <div class="modal-body">
                    <div class="alert alert-info">
                        <i class="fa fa-info-circle"></i>
                        <strong>Requisition:</strong> <?php echo $requisition->requisition_number; ?><br>
                        <strong>Department:</strong> <?php echo $requisition->department_name; ?><br>
                        <strong>Total Cost:</strong> KES <?php echo number_format($requisition->total_estimated_cost, 2); ?>
                    </div>
                    <div class="form-group">
                        <label for="approval_comments">Approval Comments:</label>
                        <textarea name="approval_comments" id="approval_comments" class="form-control" rows="4" 
                                  placeholder="Enter any comments about this approval..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">
                        <i class="fa fa-check"></i> Approve Requisition
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Rejection Modal -->
<div class="modal fade" id="rejectionModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-times"></i> Reject Requisition
                </h4>
            </div>
            <form id="rejectionForm">
                <div class="modal-body">
                    <div class="alert alert-warning">
                        <i class="fa fa-exclamation-triangle"></i>
                        <strong>Warning:</strong> This action will reject the requisition and cannot be undone.
                    </div>
                    <div class="alert alert-info">
                        <strong>Requisition:</strong> <?php echo $requisition->requisition_number; ?><br>
                        <strong>Department:</strong> <?php echo $requisition->department_name; ?>
                    </div>
                    <div class="form-group">
                        <label for="rejection_reason">Reason for Rejection: <span class="text-danger">*</span></label>
                        <textarea id="rejection_reason" class="form-control" rows="4" 
                                  placeholder="Please explain why this requisition is being rejected..." required></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">
                        <i class="fa fa-times"></i> Reject Requisition
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Custom CSS -->
<style>
    .table > thead > tr > th,
    .table > tbody > tr > td {
        vertical-align: middle;
    }
    
    .label-lg {
        font-size: 100%;
        padding: 5px 8px;
    }
    
    .timeline {
        margin: 0;
        position: relative;
    }
    
    .timeline:before {
        content: '';
        position: absolute;
        top: 0;
        left: 25px;
        height: 100%;
        width: 2px;
        background: #3c8dbc;
    }
    
    .timeline > li {
        position: relative;
        margin-right: 10px;
        margin-bottom: 15px;
        list-style: none;
    }
    
    .timeline > li > .timeline-item {
        box-shadow: 0 1px 1px rgba(0,0,0,0.1);
        border-radius: 3px;
        margin-top: 0;
        background: #fff;
        color: #444;
        margin-left: 55px;
        margin-right: 15px;
        padding: 0;
        position: relative;
    }
    
    .timeline > li > .timeline-item > .time {
        color: #999;
        float: right;
        padding: 10px;
        font-size: 12px;
    }
    
    .timeline > li > .timeline-item > .timeline-header {
        margin: 0;
        color: #555;
        border-bottom: 1px solid #f4f4f4;
        padding: 10px;
        font-size: 16px;
        line-height: 1.1;
    }
    
    .timeline > li > .timeline-item > .timeline-body {
        padding: 10px;
    }
    
    .timeline > li > .fa {
        width: 30px;
        height: 30px;
        font-size: 15px;
        line-height: 30px;
        position: absolute;
        color: #666;
        background: #d2d6de;
        border-radius: 50%;
        text-align: center;
        left: 10px;
        top: 0;
    }
    
    .timeline > li.time-label > span {
        font-weight: 600;
        color: #fff;
        border-radius: 4px;
        display: inline-block;
        padding: 5px;
    }
    
    .bg-blue { background-color: #3c8dbc !important; }
    .bg-green { background-color: #00a65a !important; }
    .bg-purple { background-color: #605ca8 !important; }
    .bg-gray { background-color: #d2d6de !important; }
    
    .text-success { color: #00a65a !important; }
    .text-warning { color: #f39c12 !important; }
    .text-danger { color: #dd4b39 !important; }
    .text-info { color: #3c8dbc !important; }
    .text-primary { color: #337ab7 !important; }
    
    .modal-body .form-group {
        margin-bottom: 15px;
    }
    
    .btn-block {
        margin-bottom: 10px;
    }
</style>

<!-- JavaScript -->
<script>
$(document).ready(function() {
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();
    
    // Rejection form handler
    $('#rejectionForm').on('submit', function(e) {
        e.preventDefault();
        processRejection();
    });
});

/**
 * Approve requisition
 */
function approveRequisition() {
    $('#approvalModal').modal('show');
}

/**
 * Reject requisition
 */
function rejectRequisition() {
    $('#rejectionModal').modal('show');
}

/**
 * Process rejection
 */
function processRejection() {
    var reason = $('#rejection_reason').val();
    
    if (!reason.trim()) {
        alert('Please provide a reason for rejection.');
        return;
    }
    
    if (confirm('Are you sure you want to reject this requisition? This action cannot be undone.')) {
        // Show loading state
        $('#rejectionForm button[type="submit"]').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Processing...');
        
        // In a real implementation, this would be an AJAX call to the server
        setTimeout(function() {
            alert('Requisition has been rejected successfully.');
            location.reload();
        }, 1000);
    }
}

/**
 * Fulfill requisition
 */
function fulfillRequisition() {
    if (confirm('Mark this requisition as fulfilled? This indicates that all approved items have been released to the department.')) {
        // In a real implementation, this would be an AJAX call
        alert('Requisition marked as fulfilled successfully.');
        location.reload();
    }
}

/**
 * Edit requisition
 */
function editRequisition() {
    window.location.href = '<?php echo base_url(); ?>admin/consumable/edit_requisition/<?php echo $requisition->id; ?>';
}

/**
 * Cancel requisition
 */
function cancelRequisition() {
    var reason = prompt('Please provide a reason for cancelling this requisition:');
    if (reason && reason.trim()) {
        if (confirm('Are you sure you want to cancel this requisition?')) {
            // In a real implementation, this would be an AJAX call
            alert('Requisition has been cancelled successfully.');
            location.reload();
        }
    }
}

/**
 * Print requisition
 */
function printRequisition() {
    window.print();
}

/**
 * Export to PDF
 */
function exportToPDF() {
    window.open('<?php echo base_url(); ?>admin/consumable/export_requisition_pdf/<?php echo $requisition->id; ?>', '_blank');
}

// Print styles
$(document).ready(function() {
    // Add print-specific styles
    $('<style type="text/css" media="print">')
        .text(`
            @media print {
                .content-wrapper { margin: 0 !important; }
                .box { border: 1px solid #ddd !important; page-break-inside: avoid; }
                .btn, .box-tools, .breadcrumb, .modal { display: none !important; }
                .timeline:before { background: #000 !important; }
                .timeline > li > .fa { background: #000 !important; color: #fff !important; }
                .label { border: 1px solid #000 !important; }
                .table { font-size: 12px; }
                .table th, .table td { padding: 5px !important; }
            }
        `)
        .appendTo('head');
});
</script>