<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-exchange"></i> Consumable Transactions
            <small>Complete transaction history and audit trail</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/consumable">Consumable Store</a></li>
            <li class="active">Transactions</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { ?>
            <div class="row">
                <div class="col-md-12">
                    <?php echo $this->session->flashdata('msg'); ?>
                </div>
            </div>
        <?php } ?>

        <!-- Filters -->
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-filter"></i> Transaction Filters</h3>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-box-tool" data-widget="collapse">
                        <i class="fa fa-minus"></i>
                    </button>
                </div>
            </div>
            <div class="box-body">
                <form method="get" action="<?php echo current_url(); ?>" class="form-inline">
                    <div class="row">
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Transaction Type:</label>
                                <select name="transaction_type" class="form-control">
                                    <option value="">All Types</option>
                                    <option value="received" <?php echo (isset($current_filters['transaction_type']) && $current_filters['transaction_type'] == 'received') ? 'selected' : ''; ?>>Received</option>
                                    <option value="issued" <?php echo (isset($current_filters['transaction_type']) && $current_filters['transaction_type'] == 'issued') ? 'selected' : ''; ?>>Issued</option>
                                    <option value="returned" <?php echo (isset($current_filters['transaction_type']) && $current_filters['transaction_type'] == 'returned') ? 'selected' : ''; ?>>Returned</option>
                                    <option value="transferred" <?php echo (isset($current_filters['transaction_type']) && $current_filters['transaction_type'] == 'transferred') ? 'selected' : ''; ?>>Transferred</option>
                                    <option value="adjusted" <?php echo (isset($current_filters['transaction_type']) && $current_filters['transaction_type'] == 'adjusted') ? 'selected' : ''; ?>>Adjusted</option>
                                    <option value="expired" <?php echo (isset($current_filters['transaction_type']) && $current_filters['transaction_type'] == 'expired') ? 'selected' : ''; ?>>Expired</option>
                                    <option value="damaged" <?php echo (isset($current_filters['transaction_type']) && $current_filters['transaction_type'] == 'damaged') ? 'selected' : ''; ?>>Damaged</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Department:</label>
                                <select name="department_id" class="form-control">
                                    <option value="">All Departments</option>
                                    <?php foreach ($departments as $department) { ?>
                                        <option value="<?php echo $department->id; ?>" 
                                                <?php echo (isset($current_filters['department_id']) && $current_filters['department_id'] == $department->id) ? 'selected' : ''; ?>>
                                            <?php echo $department->department_name; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>From Date:</label>
                                <input type="date" name="date_from" class="form-control" 
                                       value="<?php echo isset($current_filters['date_from']) ? $current_filters['date_from'] : ''; ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>To Date:</label>
                                <input type="date" name="date_to" class="form-control" 
                                       value="<?php echo isset($current_filters['date_to']) ? $current_filters['date_to'] : ''; ?>">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>&nbsp;</label><br>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-search"></i> Filter
                                </button>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>&nbsp;</label><br>
                                <a href="<?php echo current_url(); ?>" class="btn btn-default">
                                    <i class="fa fa-refresh"></i> Clear
                                </a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Transaction Summary -->
        <div class="row">
            <div class="col-lg-2 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3>
                            <?php 
                            $received = array_filter($transactions, function($t) { return $t->transaction_type == 'received'; });
                            echo count($received);
                            ?>
                        </h3>
                        <p>Received</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-arrow-down"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-xs-6">
                <div class="small-box bg-blue">
                    <div class="inner">
                        <h3>
                            <?php 
                            $issued = array_filter($transactions, function($t) { return $t->transaction_type == 'issued'; });
                            echo count($issued);
                            ?>
                        </h3>
                        <p>Issued</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-arrow-up"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3>
                            <?php 
                            $returned = array_filter($transactions, function($t) { return $t->transaction_type == 'returned'; });
                            echo count($returned);
                            ?>
                        </h3>
                        <p>Returned</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-undo"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3>
                            <?php 
                            $expired_damaged = array_filter($transactions, function($t) { 
                                return in_array($t->transaction_type, ['expired', 'damaged']); 
                            });
                            echo count($expired_damaged);
                            ?>
                        </h3>
                        <p>Expired/Damaged</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-times"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3>
                            <?php 
                            $adjusted = array_filter($transactions, function($t) { return $t->transaction_type == 'adjusted'; });
                            echo count($adjusted);
                            ?>
                        </h3>
                        <p>Adjustments</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-edit"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-xs-6">
                <div class="small-box bg-purple">
                    <div class="inner">
                        <h3>
                            KES <?php 
                            $total_value = 0;
                            foreach ($transactions as $t) {
                                $total_value += $t->total_value;
                            }
                            echo number_format($total_value, 0);
                            ?>
                        </h3>
                        <p>Total Value</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-money"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Transactions List -->
        <div class="box box-default">
            <div class="box-header with-border">
                <h3 class="box-title">
                    <i class="fa fa-list"></i> Transaction History 
                    <span class="label label-info"><?php echo count($transactions); ?> transactions</span>
                </h3>
                <div class="box-tools pull-right">
                    <div class="btn-group">
                        <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                            <i class="fa fa-download"></i> Export <span class="caret"></span>
                        </button>
                        <ul class="dropdown-menu">
                            <li><a href="#" onclick="exportTransactions('excel')"><i class="fa fa-file-excel-o"></i> Excel</a></li>
                            <li><a href="#" onclick="exportTransactions('pdf')"><i class="fa fa-file-pdf-o"></i> PDF</a></li>
                            <li><a href="#" onclick="exportTransactions('csv')"><i class="fa fa-file-text-o"></i> CSV</a></li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="box-body">
                <?php if (!empty($transactions)) { ?>
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered" id="transactionsTable">
                            <thead>
                                <tr>
                                    <th>Transaction #</th>
                                    <th>Date & Time</th>
                                    <th>Type</th>
                                    <th>Item</th>
                                    <th>Quantity</th>
                                    <th>From</th>
                                    <th>To</th>
                                    <th>Unit Cost</th>
                                    <th>Total Value</th>
                                    <th>Staff</th>
                                    <th>Notes</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($transactions as $transaction) { 
                                    // Determine transaction styling
                                    $type_class = 'label-default';
                                    $icon = 'fa-exchange';
                                    
                                    switch ($transaction->transaction_type) {
                                        case 'received':
                                            $type_class = 'label-success';
                                            $icon = 'fa-arrow-down';
                                            break;
                                        case 'issued':
                                            $type_class = 'label-primary';
                                            $icon = 'fa-arrow-up';
                                            break;
                                        case 'returned':
                                            $type_class = 'label-info';
                                            $icon = 'fa-undo';
                                            break;
                                        case 'transferred':
                                            $type_class = 'label-warning';
                                            $icon = 'fa-arrows-h';
                                            break;
                                        case 'adjusted':
                                            $type_class = 'label-default';
                                            $icon = 'fa-edit';
                                            break;
                                        case 'expired':
                                        case 'damaged':
                                            $type_class = 'label-danger';
                                            $icon = 'fa-times';
                                            break;
                                    }
                                ?>
                                    <tr>
                                        <td>
                                            <strong><?php echo $transaction->transaction_number; ?></strong>
                                        </td>
                                        <td>
                                            <?php echo date('M j, Y', strtotime($transaction->transaction_date)); ?>
                                            <br><small class="text-muted"><?php echo date('H:i:s', strtotime($transaction->transaction_date)); ?></small>
                                        </td>
                                        <td class="text-center">
                                            <span class="label <?php echo $type_class; ?>">
                                                <i class="fa <?php echo $icon; ?>"></i>
                                                <?php echo ucfirst($transaction->transaction_type); ?>
                                            </span>
                                        </td>
                                        <td>
                                            <strong><?php echo $transaction->consumable_name; ?></strong>
                                            <br><small class="text-muted"><?php echo $transaction->consumable_code; ?></small>
                                        </td>
                                        <td class="text-center">
                                            <strong><?php echo number_format($transaction->quantity); ?></strong>
                                        </td>
                                        <td>
                                            <?php if ($transaction->from_department) { ?>
                                                <span class="label label-default">
                                                    <?php echo $transaction->from_department; ?>
                                                </span>
                                            <?php } else { ?>
                                                <small class="text-muted">Main Store</small>
                                            <?php } ?>
                                        </td>
                                        <td>
                                            <?php if ($transaction->to_department) { ?>
                                                <span class="label label-primary">
                                                    <?php echo $transaction->to_department; ?>
                                                </span>
                                            <?php } else { ?>
                                                <small class="text-muted">Main Store</small>
                                            <?php } ?>
                                        </td>
                                        <td class="text-right">
                                            KES <?php echo number_format($transaction->unit_cost, 2); ?>
                                        </td>
                                        <td class="text-right">
                                            <strong>KES <?php echo number_format($transaction->total_value, 2); ?></strong>
                                        </td>
                                        <td>
                                            <?php if ($transaction->staff_name) { ?>
                                                <?php echo $transaction->staff_name . ' ' . $transaction->staff_surname; ?>
                                            <?php } else { ?>
                                                <small class="text-muted">System</small>
                                            <?php } ?>
                                        </td>
                                        <td>
                                            <?php if ($transaction->notes) { ?>
                                                <small><?php echo substr($transaction->notes, 0, 50); ?><?php echo strlen($transaction->notes) > 50 ? '...' : ''; ?></small>
                                                <?php if (strlen($transaction->notes) > 50) { ?>
                                                    <br><a href="#" onclick="showFullNotes('<?php echo addslashes($transaction->notes); ?>')" class="btn btn-xs btn-link">
                                                        <i class="fa fa-eye"></i> View Full
                                                    </a>
                                                <?php } ?>
                                            <?php } else { ?>
                                                <small class="text-muted">No notes</small>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                <?php } else { ?>
                    <div class="text-center" style="padding: 50px;">
                        <i class="fa fa-exchange fa-3x text-muted"></i>
                        <h4>No Transactions Found</h4>
                        <p class="text-muted">
                            <?php if (!empty($current_filters)) { ?>
                                No transactions match your current filters. 
                                <a href="<?php echo base_url(); ?>admin/consumable/transactions">Clear filters</a> to see all transactions.
                            <?php } else { ?>
                                No transactions have been recorded yet.
                            <?php } ?>
                        </p>
                    </div>
                <?php } ?>
            </div>
        </div>

    </section>
</div>

<!-- Transaction Notes Modal -->
<div class="modal fade" id="notesModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-file-text"></i> Transaction Notes
                </h4>
            </div>
            <div class="modal-body">
                <div id="fullNotesContent" class="well">
                    <!-- Notes content will be loaded here -->
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Custom CSS -->
<style>
    .small-box h3 {
        font-size: 2.2em;
        font-weight: bold;
        margin: 0 0 10px 0;
        white-space: nowrap;
        padding: 0;
    }
    
    .btn-purple {
        background-color: #605ca8;
        border-color: #555299;
        color: #fff;
    }
    
    .table > thead > tr > th,
    .table > tbody > tr > td {
        vertical-align: middle;
    }
    
    .label {
        font-size: 85%;
        padding: 3px 6px;
    }
    
    .text-success { color: #00a65a !important; }
    .text-warning { color: #f39c12 !important; }
    .text-danger { color: #dd4b39 !important; }
    .text-info { color: #3c8dbc !important; }
    .text-primary { color: #337ab7 !important; }
    
    #transactionsTable th {
        background-color: #f4f4f4;
        font-weight: 600;
    }
    
    .well {
        background-color: #f5f5f5;
        border: 1px solid #e3e3e3;
        border-radius: 4px;
        padding: 19px;
        margin-bottom: 20px;
    }
</style>

<!-- JavaScript -->
<script>
$(document).ready(function() {
    // Initialize DataTable
    $('#transactionsTable').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "pageLength": 25,
        "order": [[1, "desc"]], // Sort by date (newest first)
        "columnDefs": [
            { "orderable": false, "targets": [10] }, // Notes column
            { "className": "text-center", "targets": [2, 4] },
            { "className": "text-right", "targets": [7, 8] }
        ],
        "dom": 'lBfrtip',
        "buttons": [
            {
                extend: 'excel',
                text: '<i class="fa fa-file-excel-o"></i> Export Excel',
                className: 'btn btn-success btn-sm',
                exportOptions: {
                    columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9] // Exclude notes column
                }
            },
            {
                extend: 'pdf',
                text: '<i class="fa fa-file-pdf-o"></i> Export PDF',
                className: 'btn btn-danger btn-sm',
                orientation: 'landscape',
                exportOptions: {
                    columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
                }
            },
            {
                extend: 'print',
                text: '<i class="fa fa-print"></i> Print',
                className: 'btn btn-info btn-sm',
                exportOptions: {
                    columns: [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
                }
            }
        ]
    });
});

/**
 * Show full transaction notes
 */
function showFullNotes(notes) {
    $('#fullNotesContent').html('<p>' + notes.replace(/\n/g, '<br>') + '</p>');
    $('#notesModal').modal('show');
}

/**
 * Export transactions
 */
function exportTransactions(format) {
    var params = new URLSearchParams(window.location.search);
    params.set('export', format);
    window.location.href = '<?php echo current_url(); ?>?' + params.toString();
}

// Initialize tooltips
$(document).ready(function() {
    $('[data-toggle="tooltip"]').tooltip();
});
</script>

<!-- Include DataTables and export buttons -->
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/dataTables.bootstrap.min.css">
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.7.1/css/buttons.bootstrap.min.css">

<script type="text/javascript" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.24/js/dataTables.bootstrap.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.7.1/js/dataTables.buttons.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.7.1/js/buttons.bootstrap.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.7.1/js/buttons.html5.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/buttons/1.7.1/js/buttons.print.min.js"></script>