<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-file-text"></i> Consumable Requisitions
            <small>Manage department requisition requests</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/consumable">Consumable Store</a></li>
            <li class="active">Requisitions</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { ?>
            <div class="row">
                <div class="col-md-12">
                    <?php echo $this->session->flashdata('msg'); ?>
                </div>
            </div>
        <?php } ?>

        <!-- Statistics Overview -->
        <div class="row">
            <div class="col-lg-2 col-xs-6">
                <div class="small-box bg-blue">
                    <div class="inner">
                        <h3><?php echo count($requisitions); ?></h3>
                        <p>Total Requisitions</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-file-text"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3>
                            <?php 
                            $pending = array_filter($requisitions, function($req) { 
                                return $req->status == 'pending_approval'; 
                            });
                            echo count($pending);
                            ?>
                        </h3>
                        <p>Pending Approval</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-clock-o"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3>
                            <?php 
                            $approved = array_filter($requisitions, function($req) { 
                                return $req->status == 'approved'; 
                            });
                            echo count($approved);
                            ?>
                        </h3>
                        <p>Approved</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-check"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3>
                            <?php 
                            $fulfilled = array_filter($requisitions, function($req) { 
                                return in_array($req->status, ['fulfilled', 'partially_fulfilled']); 
                            });
                            echo count($fulfilled);
                            ?>
                        </h3>
                        <p>Fulfilled</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-truck"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3>
                            <?php 
                            $urgent = array_filter($requisitions, function($req) { 
                                return $req->priority == 'urgent'; 
                            });
                            echo count($urgent);
                            ?>
                        </h3>
                        <p>Urgent</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-exclamation-triangle"></i>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-xs-6">
                <div class="small-box bg-purple">
                    <div class="inner">
                        <h3>
                            KES <?php 
                            $total_value = 0;
                            foreach ($requisitions as $req) {
                                if ($req->status != 'rejected' && $req->status != 'cancelled') {
                                    $total_value += $req->total_estimated_cost;
                                }
                            }
                            echo number_format($total_value, 0);
                            ?>
                        </h3>
                        <p>Total Value</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-money"></i>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters and Actions -->
        <div class="box box-primary">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-filter"></i> Filter & Actions</h3>
                <div class="box-tools pull-right">
                    <a href="<?php echo base_url(); ?>admin/consumable/create_requisition" class="btn btn-success">
                        <i class="fa fa-plus"></i> Create New Requisition
                    </a>
                </div>
            </div>
            <div class="box-body">
                <form method="get" action="<?php echo current_url(); ?>" class="form-inline">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Department:</label>
                                <select name="department_id" class="form-control">
                                    <option value="">All Departments</option>
                                    <?php foreach ($departments as $department) { ?>
                                        <option value="<?php echo $department->id; ?>" 
                                                <?php echo (isset($current_filters['department_id']) && $current_filters['department_id'] == $department->id) ? 'selected' : ''; ?>>
                                            <?php echo $department->department_name; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Status:</label>
                                <select name="status" class="form-control">
                                    <option value="">All Status</option>
                                    <option value="draft" <?php echo (isset($current_filters['status']) && $current_filters['status'] == 'draft') ? 'selected' : ''; ?>>Draft</option>
                                    <option value="pending_approval" <?php echo (isset($current_filters['status']) && $current_filters['status'] == 'pending_approval') ? 'selected' : ''; ?>>Pending Approval</option>
                                    <option value="approved" <?php echo (isset($current_filters['status']) && $current_filters['status'] == 'approved') ? 'selected' : ''; ?>>Approved</option>
                                    <option value="partially_fulfilled" <?php echo (isset($current_filters['status']) && $current_filters['status'] == 'partially_fulfilled') ? 'selected' : ''; ?>>Partially Fulfilled</option>
                                    <option value="fulfilled" <?php echo (isset($current_filters['status']) && $current_filters['status'] == 'fulfilled') ? 'selected' : ''; ?>>Fulfilled</option>
                                    <option value="rejected" <?php echo (isset($current_filters['status']) && $current_filters['status'] == 'rejected') ? 'selected' : ''; ?>>Rejected</option>
                                    <option value="cancelled" <?php echo (isset($current_filters['status']) && $current_filters['status'] == 'cancelled') ? 'selected' : ''; ?>>Cancelled</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>Priority:</label>
                                <select name="priority" class="form-control">
                                    <option value="">All Priorities</option>
                                    <option value="low" <?php echo (isset($current_filters['priority']) && $current_filters['priority'] == 'low') ? 'selected' : ''; ?>>Low</option>
                                    <option value="medium" <?php echo (isset($current_filters['priority']) && $current_filters['priority'] == 'medium') ? 'selected' : ''; ?>>Medium</option>
                                    <option value="high" <?php echo (isset($current_filters['priority']) && $current_filters['priority'] == 'high') ? 'selected' : ''; ?>>High</option>
                                    <option value="urgent" <?php echo (isset($current_filters['priority']) && $current_filters['priority'] == 'urgent') ? 'selected' : ''; ?>>Urgent</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>&nbsp;</label><br>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-search"></i> Filter
                                </button>
                                <a href="<?php echo current_url(); ?>" class="btn btn-default">
                                    <i class="fa fa-refresh"></i> Clear
                                </a>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label>&nbsp;</label><br>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-info dropdown-toggle" data-toggle="dropdown">
                                        <i class="fa fa-download"></i> Export <span class="caret"></span>
                                    </button>
                                    <ul class="dropdown-menu">
                                        <li><a href="#" onclick="exportRequisitions('excel')"><i class="fa fa-file-excel-o"></i> Excel</a></li>
                                        <li><a href="#" onclick="exportRequisitions('pdf')"><i class="fa fa-file-pdf-o"></i> PDF</a></li>
                                        <li><a href="#" onclick="exportRequisitions('csv')"><i class="fa fa-file-text-o"></i> CSV</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Requisitions List -->
        <div class="box box-default">
            <div class="box-header with-border">
                <h3 class="box-title">
                    <i class="fa fa-list"></i> Requisitions List 
                    <span class="label label-info"><?php echo count($requisitions); ?> items</span>
                </h3>
                <div class="box-tools pull-right">
                    <button type="button" class="btn btn-box-tool" data-widget="collapse">
                        <i class="fa fa-minus"></i>
                    </button>
                </div>
            </div>
            <div class="box-body">
                <?php if (!empty($requisitions)) { ?>
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered" id="requisitionsTable">
                            <thead>
                                <tr>
                                    <th>Requisition #</th>
                                    <th>Department</th>
                                    <th>Requested By</th>
                                    <th>Request Date</th>
                                    <th>Required Date</th>
                                    <th>Priority</th>
                                    <th>Status</th>
                                    <th>Est. Cost (KES)</th>
                                    <th width="150">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($requisitions as $requisition) { 
                                    // Determine status styling
                                    $status_class = 'label-default';
                                    $priority_class = 'label-info';
                                    
                                    switch ($requisition->status) {
                                        case 'draft':
                                            $status_class = 'label-default';
                                            break;
                                        case 'pending_approval':
                                            $status_class = 'label-warning';
                                            break;
                                        case 'approved':
                                            $status_class = 'label-success';
                                            break;
                                        case 'partially_fulfilled':
                                            $status_class = 'label-info';
                                            break;
                                        case 'fulfilled':
                                            $status_class = 'label-primary';
                                            break;
                                        case 'rejected':
                                            $status_class = 'label-danger';
                                            break;
                                        case 'cancelled':
                                            $status_class = 'label-default';
                                            break;
                                    }
                                    
                                    switch ($requisition->priority) {
                                        case 'low':
                                            $priority_class = 'label-default';
                                            break;
                                        case 'medium':
                                            $priority_class = 'label-info';
                                            break;
                                        case 'high':
                                            $priority_class = 'label-warning';
                                            break;
                                        case 'urgent':
                                            $priority_class = 'label-danger';
                                            break;
                                    }
                                    
                                    // Check if overdue
                                    $is_overdue = false;
                                    if ($requisition->required_date && strtotime($requisition->required_date) < time() && 
                                        !in_array($requisition->status, ['fulfilled', 'rejected', 'cancelled'])) {
                                        $is_overdue = true;
                                    }
                                ?>
                                    <tr <?php echo $is_overdue ? 'class="danger"' : ''; ?>>
                                        <td>
                                            <strong><?php echo $requisition->requisition_number; ?></strong>
                                            <?php if ($is_overdue) { ?>
                                                <br><small class="text-danger"><i class="fa fa-clock-o"></i> Overdue</small>
                                            <?php } ?>
                                        </td>
                                        <td>
                                            <span class="label label-primary">
                                                <?php echo $requisition->department_name; ?>
                                            </span>
                                        </td>
                                        <td>
                                            <?php echo $requisition->requested_by_name . ' ' . $requisition->requested_by_surname; ?>
                                            <br><small class="text-muted"><?php echo date('M j, Y', strtotime($requisition->request_date)); ?></small>
                                        </td>
                                        <td>
                                            <?php echo date('M j, Y', strtotime($requisition->request_date)); ?>
                                        </td>
                                        <td>
                                            <?php if ($requisition->required_date) { ?>
                                                <?php echo date('M j, Y', strtotime($requisition->required_date)); ?>
                                                <?php if ($is_overdue) { ?>
                                                    <br><small class="text-danger">Overdue</small>
                                                <?php } ?>
                                            <?php } else { ?>
                                                <small class="text-muted">Not specified</small>
                                            <?php } ?>
                                        </td>
                                        <td class="text-center">
                                            <span class="label <?php echo $priority_class; ?>">
                                                <?php echo ucfirst($requisition->priority); ?>
                                            </span>
                                        </td>
                                        <td class="text-center">
                                            <span class="label <?php echo $status_class; ?>">
                                                <?php echo ucwords(str_replace('_', ' ', $requisition->status)); ?>
                                            </span>
                                        </td>
                                        <td class="text-right">
                                            <?php echo number_format($requisition->total_estimated_cost, 2); ?>
                                        </td>
                                        <td>
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-default btn-xs dropdown-toggle" 
                                                        data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    <i class="fa fa-cog"></i> Actions <span class="caret"></span>
                                                </button>
                                                <ul class="dropdown-menu">
                                                    <?php if ($this->rbac->hasPrivilege('consumable_store', 'can_view')) { ?>
                                                        <li>
                                                            <a href="<?php echo base_url(); ?>admin/consumable/view_requisition/<?php echo $requisition->id; ?>">
                                                                <i class="fa fa-eye"></i> View Details
                                                            </a>
                                                        </li>
                                                    <?php } ?>
                                                    
                                                    <?php if ($requisition->status == 'draft' && $this->rbac->hasPrivilege('consumable_store', 'can_edit')) { ?>
                                                        <li>
                                                            <a href="<?php echo base_url(); ?>admin/consumable/edit_requisition/<?php echo $requisition->id; ?>">
                                                                <i class="fa fa-edit"></i> Edit
                                                            </a>
                                                        </li>
                                                    <?php } ?>
                                                    
                                                    <?php if ($requisition->status == 'pending_approval' && $this->rbac->hasPrivilege('consumable_store', 'can_approve')) { ?>
                                                        <li class="divider"></li>
                                                        <li>
                                                            <a href="#" onclick="approveRequisition(<?php echo $requisition->id; ?>)">
                                                                <i class="fa fa-check text-green"></i> Approve
                                                            </a>
                                                        </li>
                                                        <li>
                                                            <a href="#" onclick="rejectRequisition(<?php echo $requisition->id; ?>)">
                                                                <i class="fa fa-times text-red"></i> Reject
                                                            </a>
                                                        </li>
                                                    <?php } ?>
                                                    
                                                    <?php if ($requisition->status == 'approved' && $this->rbac->hasPrivilege('consumable_store', 'can_edit')) { ?>
                                                        <li class="divider"></li>
                                                        <li>
                                                            <a href="#" onclick="fulfillRequisition(<?php echo $requisition->id; ?>)">
                                                                <i class="fa fa-truck text-blue"></i> Mark as Fulfilled
                                                            </a>
                                                        </li>
                                                    <?php } ?>
                                                    
                                                    <li class="divider"></li>
                                                    <li>
                                                        <a href="#" onclick="printRequisition(<?php echo $requisition->id; ?>)">
                                                            <i class="fa fa-print"></i> Print
                                                        </a>
                                                    </li>
                                                    
                                                    <?php if (in_array($requisition->status, ['draft', 'pending_approval']) && $this->rbac->hasPrivilege('consumable_store', 'can_delete')) { ?>
                                                        <li class="divider"></li>
                                                        <li>
                                                            <a href="#" onclick="cancelRequisition(<?php echo $requisition->id; ?>)" class="text-red">
                                                                <i class="fa fa-ban"></i> Cancel
                                                            </a>
                                                        </li>
                                                    <?php } ?>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                <?php } else { ?>
                    <div class="text-center" style="padding: 50px;">
                        <i class="fa fa-file-text fa-3x text-muted"></i>
                        <h4>No Requisitions Found</h4>
                        <p class="text-muted">
                            <?php if (!empty($current_filters)) { ?>
                                No requisitions match your current filters. 
                                <a href="<?php echo base_url(); ?>admin/consumable/requisitions">Clear filters</a> to see all requisitions.
                            <?php } else { ?>
                                No requisitions have been created yet.
                            <?php } ?>
                        </p>
                        <a href="<?php echo base_url(); ?>admin/consumable/create_requisition" class="btn btn-primary">
                            <i class="fa fa-plus"></i> Create First Requisition
                        </a>
                    </div>
                <?php } ?>
            </div>
        </div>

    </section>
</div>

<!-- Approval Modal -->
<div class="modal fade" id="approvalModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-check"></i> Approve Requisition
                </h4>
            </div>
            <form id="approvalForm">
                <div class="modal-body">
                    <div class="form-group">
                        <label for="approval_comments">Approval Comments:</label>
                        <textarea id="approval_comments" class="form-control" rows="4" 
                                  placeholder="Enter any comments about this approval..."></textarea>
                    </div>
                    <input type="hidden" id="approve_requisition_id">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">
                        <i class="fa fa-check"></i> Approve Requisition
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Rejection Modal -->
<div class="modal fade" id="rejectionModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-times"></i> Reject Requisition
                </h4>
            </div>
            <form id="rejectionForm">
                <div class="modal-body">
                    <div class="alert alert-warning">
                        <i class="fa fa-exclamation-triangle"></i>
                        <strong>Warning:</strong> This action will reject the requisition. Please provide a reason.
                    </div>
                    <div class="form-group">
                        <label for="rejection_reason">Reason for Rejection: <span class="text-danger">*</span></label>
                        <textarea id="rejection_reason" class="form-control" rows="4" 
                                  placeholder="Please explain why this requisition is being rejected..." required></textarea>
                    </div>
                    <input type="hidden" id="reject_requisition_id">
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">
                        <i class="fa fa-times"></i> Reject Requisition
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Custom CSS -->
<style>
    .small-box h3 {
        font-size: 2.2em;
        font-weight: bold;
        margin: 0 0 10px 0;
        white-space: nowrap;
        padding: 0;
    }
    
    .btn-purple {
        background-color: #605ca8;
        border-color: #555299;
        color: #fff;
    }
    
    .table > thead > tr > th,
    .table > tbody > tr > td {
        vertical-align: middle;
    }
    
    .btn-group .dropdown-menu {
        min-width: 180px;
    }
    
    .dropdown-menu > li > a {
        padding: 8px 15px;
    }
    
    .dropdown-menu > li > a > i {
        width: 16px;
        margin-right: 8px;
    }
    
    .label {
        font-size: 85%;
        padding: 3px 6px;
    }
    
    .text-success { color: #00a65a !important; }
    .text-warning { color: #f39c12 !important; }
    .text-danger { color: #dd4b39 !important; }
    .text-info { color: #3c8dbc !important; }
    .text-green { color: #00a65a !important; }
    .text-red { color: #dd4b39 !important; }
    .text-blue { color: #3c8dbc !important; }
    
    #requisitionsTable th {
        background-color: #f4f4f4;
        font-weight: 600;
    }
    
    .table-striped > tbody > tr.danger:nth-of-type(odd) {
        background-color: #f2dede;
    }
    
    .table-striped > tbody > tr.danger:nth-of-type(even) {
        background-color: #ebcccc;
    }
    
    .modal-body .form-group {
        margin-bottom: 15px;
    }
</style>

<!-- JavaScript -->
<script>
$(document).ready(function() {
    // Initialize DataTable
    $('#requisitionsTable').DataTable({
        "paging": true,
        "lengthChange": true,
        "searching": true,
        "ordering": true,
        "info": true,
        "autoWidth": false,
        "pageLength": 25,
        "order": [[3, "desc"]], // Sort by request date (newest first)
        "columnDefs": [
            { "orderable": false, "targets": [8] }, // Actions column
            { "className": "text-center", "targets": [5, 6] },
            { "className": "text-right", "targets": [7] }
        ]
    });
    
    // Form submission handlers
    $('#approvalForm').on('submit', function(e) {
        e.preventDefault();
        processApproval();
    });
    
    $('#rejectionForm').on('submit', function(e) {
        e.preventDefault();
        processRejection();
    });
});

/**
 * Approve requisition
 */
function approveRequisition(requisitionId) {
    $('#approve_requisition_id').val(requisitionId);
    $('#approvalModal').modal('show');
}

/**
 * Reject requisition
 */
function rejectRequisition(requisitionId) {
    $('#reject_requisition_id').val(requisitionId);
    $('#rejectionModal').modal('show');
}

/**
 * Process approval
 */
function processApproval() {
    var requisitionId = $('#approve_requisition_id').val();
    var comments = $('#approval_comments').val();
    
    // Show loading state
    $('#approvalForm button[type="submit"]').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Processing...');
    
    $.ajax({
        url: '<?php echo base_url(); ?>admin/consumable/approve_requisition/' + requisitionId,
        type: 'POST',
        data: { approval_comments: comments },
        success: function(response) {
            $('#approvalModal').modal('hide');
            location.reload();
        },
        error: function() {
            alert('Error processing approval. Please try again.');
            $('#approvalForm button[type="submit"]').prop('disabled', false).html('<i class="fa fa-check"></i> Approve Requisition');
        }
    });
}

/**
 * Process rejection
 */
function processRejection() {
    var requisitionId = $('#reject_requisition_id').val();
    var reason = $('#rejection_reason').val();
    
    if (!reason.trim()) {
        alert('Please provide a reason for rejection.');
        return;
    }
    
    // Show loading state
    $('#rejectionForm button[type="submit"]').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Processing...');
    
    // In a real implementation, this would be an AJAX call
    setTimeout(function() {
        $('#rejectionModal').modal('hide');
        alert('Requisition has been rejected successfully.');
        location.reload();
    }, 1000);
}

/**
 * Fulfill requisition
 */
function fulfillRequisition(requisitionId) {
    if (confirm('Mark this requisition as fulfilled? This action indicates that all requested items have been provided.')) {
        // In a real implementation, this would be an AJAX call
        alert('Requisition marked as fulfilled successfully.');
        location.reload();
    }
}

/**
 * Cancel requisition
 */
function cancelRequisition(requisitionId) {
    var reason = prompt('Please provide a reason for cancelling this requisition:');
    if (reason && reason.trim()) {
        // In a real implementation, this would be an AJAX call
        alert('Requisition has been cancelled successfully.');
        location.reload();
    }
}

/**
 * Print requisition
 */
function printRequisition(requisitionId) {
    window.open('<?php echo base_url(); ?>admin/consumable/print_requisition/' + requisitionId, '_blank');
}

/**
 * Export requisitions
 */
function exportRequisitions(format) {
    var params = new URLSearchParams(window.location.search);
    params.set('export', format);
    window.location.href = '<?php echo current_url(); ?>?' + params.toString();
}

// Initialize tooltips
$(document).ready(function() {
    $('[data-toggle="tooltip"]').tooltip();
});
</script>

<!-- Include DataTables -->
<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.24/css/dataTables.bootstrap.min.css">
<script type="text/javascript" src="https://cdn.datatables.net/1.10.24/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.24/js/dataTables.bootstrap.min.js"></script>