<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-bar-chart"></i> Consumable Reports & Analytics
            <small>Comprehensive insights and analysis</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/consumable">Consumable Store</a></li>
            <li class="active">Reports</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { ?>
            <div class="row">
                <div class="col-md-12">
                    <?php echo $this->session->flashdata('msg'); ?>
                </div>
            </div>
        <?php } ?>

        <!-- Report Selection -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-dashboard"></i> Quick Reports</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-3">
                                <a href="#stock-summary" class="btn btn-app btn-block">
                                    <i class="fa fa-cubes"></i> Stock Summary
                                </a>
                            </div>
                            <div class="col-md-3">
                                <a href="#expiring-items" class="btn btn-app btn-block">
                                    <i class="fa fa-clock-o"></i> Expiring Items
                                </a>
                            </div>
                            <div class="col-md-3">
                                <a href="#low-stock" class="btn btn-app btn-block">
                                    <i class="fa fa-exclamation-triangle"></i> Low Stock
                                </a>
                            </div>
                            <div class="col-md-3">
                                <a href="#usage-analysis" class="btn btn-app btn-block">
                                    <i class="fa fa-line-chart"></i> Usage Analysis
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Stock Summary Report -->
        <div class="row" id="stock-summary">
            <div class="col-md-12">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-pie-chart"></i> Stock Summary by Category</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-success btn-sm" onclick="exportReport('stock_summary')">
                                <i class="fa fa-download"></i> Export
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($stock_summary)) { ?>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped" id="stockSummaryTable">
                                    <thead>
                                        <tr class="bg-green">
                                            <th>Category</th>
                                            <th class="text-center">Total Items</th>
                                            <th class="text-center">Total Stock</th>
                                            <th class="text-right">Total Value (KES)</th>
                                            <th class="text-center">Low Stock Items</th>
                                            <th class="text-center">Out of Stock</th>
                                            <th class="text-center">Health Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $grand_total_items = 0;
                                        $grand_total_value = 0;
                                        $grand_low_stock = 0;
                                        $grand_out_stock = 0;
                                        
                                        foreach ($stock_summary as $summary) { 
                                            $grand_total_items += $summary->total_items;
                                            $grand_total_value += $summary->total_value;
                                            $grand_low_stock += $summary->low_stock_items;
                                            $grand_out_stock += $summary->out_of_stock_items;
                                            
                                            // Calculate health percentage
                                            $healthy_items = $summary->total_items - $summary->low_stock_items - $summary->out_of_stock_items;
                                            $health_percentage = $summary->total_items > 0 ? ($healthy_items / $summary->total_items) * 100 : 0;
                                            
                                            $health_class = 'success';
                                            $health_text = 'Excellent';
                                            if ($health_percentage < 50) {
                                                $health_class = 'danger';
                                                $health_text = 'Critical';
                                            } elseif ($health_percentage < 75) {
                                                $health_class = 'warning';
                                                $health_text = 'Needs Attention';
                                            } elseif ($health_percentage < 90) {
                                                $health_class = 'info';
                                                $health_text = 'Good';
                                            }
                                        ?>
                                            <tr>
                                                <td><strong><?php echo $summary->category_name; ?></strong></td>
                                                <td class="text-center"><?php echo number_format($summary->total_items); ?></td>
                                                <td class="text-center"><?php echo number_format($summary->total_stock); ?></td>
                                                <td class="text-right"><strong><?php echo number_format($summary->total_value, 2); ?></strong></td>
                                                <td class="text-center">
                                                    <?php if ($summary->low_stock_items > 0) { ?>
                                                        <span class="label label-warning"><?php echo $summary->low_stock_items; ?></span>
                                                    <?php } else { ?>
                                                        <span class="text-success">0</span>
                                                    <?php } ?>
                                                </td>
                                                <td class="text-center">
                                                    <?php if ($summary->out_of_stock_items > 0) { ?>
                                                        <span class="label label-danger"><?php echo $summary->out_of_stock_items; ?></span>
                                                    <?php } else { ?>
                                                        <span class="text-success">0</span>
                                                    <?php } ?>
                                                </td>
                                                <td class="text-center">
                                                    <div class="progress progress-sm" style="margin: 0;">
                                                        <div class="progress-bar progress-bar-<?php echo $health_class; ?>" 
                                                             style="width: <?php echo $health_percentage; ?>%"></div>
                                                    </div>
                                                    <small><?php echo $health_text; ?> (<?php echo round($health_percentage, 1); ?>%)</small>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot>
                                        <tr class="bg-gray">
                                            <th><strong>TOTAL</strong></th>
                                            <th class="text-center"><strong><?php echo number_format($grand_total_items); ?></strong></th>
                                            <th class="text-center">-</th>
                                            <th class="text-right"><strong><?php echo number_format($grand_total_value, 2); ?></strong></th>
                                            <th class="text-center"><strong><?php echo $grand_low_stock; ?></strong></th>
                                            <th class="text-center"><strong><?php echo $grand_out_stock; ?></strong></th>
                                            <th class="text-center">
                                                <?php 
                                                $overall_health = $grand_total_items > 0 ? (($grand_total_items - $grand_low_stock - $grand_out_stock) / $grand_total_items) * 100 : 0;
                                                ?>
                                                <strong><?php echo round($overall_health, 1); ?>%</strong>
                                            </th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        <?php } else { ?>
                            <div class="text-center text-muted">
                                <i class="fa fa-info-circle fa-2x"></i>
                                <p>No stock data available for reporting</p>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Expiring Items Report -->
        <div class="row" id="expiring-items">
            <div class="col-md-12">
                <div class="box box-warning">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-clock-o"></i> Items Expiring Soon</h3>
                        <div class="box-tools pull-right">
                            <span class="label label-warning"><?php echo count($expiring_items); ?> items</span>
                            <button type="button" class="btn btn-warning btn-sm" onclick="exportReport('expiring_items')">
                                <i class="fa fa-download"></i> Export
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($expiring_items)) { ?>
                            <div class="table-responsive">
                                <table class="table table-striped table-bordered" id="expiringItemsTable">
                                    <thead>
                                        <tr class="bg-yellow">
                                            <th>Item</th>
                                            <th>Batch Number</th>
                                            <th>Current Stock</th>
                                            <th>Expiry Date</th>
                                            <th>Days to Expiry</th>
                                            <th>Status</th>
                                            <th>Value at Risk (KES)</th>
                                            <th>Action Required</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $total_value_at_risk = 0;
                                        foreach ($expiring_items as $item) { 
                                            $total_value_at_risk += $item->value_at_risk;
                                            
                                            // Determine urgency
                                            $urgency_class = 'label-info';
                                            $action_required = 'Monitor';
                                            
                                            if ($item->expiry_status == 'Expired') {
                                                $urgency_class = 'label-danger';
                                                $action_required = 'Remove Immediately';
                                            } elseif ($item->expiry_status == 'Critical') {
                                                $urgency_class = 'label-danger';
                                                $action_required = 'Use/Dispose ASAP';
                                            } elseif ($item->expiry_status == 'Warning') {
                                                $urgency_class = 'label-warning';
                                                $action_required = 'Use Soon';
                                            }
                                        ?>
                                            <tr>
                                                <td><strong><?php echo $item->consumable_name; ?></strong></td>
                                                <td><?php echo $item->batch_number; ?></td>
                                                <td class="text-center"><?php echo number_format($item->quantity_remaining); ?></td>
                                                <td><?php echo date('M j, Y', strtotime($item->expiry_date)); ?></td>
                                                <td class="text-center">
                                                    <?php if ($item->days_to_expiry < 0) { ?>
                                                        <span class="text-danger"><strong><?php echo abs($item->days_to_expiry); ?> days ago</strong></span>
                                                    <?php } else { ?>
                                                        <strong><?php echo $item->days_to_expiry; ?> days</strong>
                                                    <?php } ?>
                                                </td>
                                                <td class="text-center">
                                                    <span class="label <?php echo $urgency_class; ?>">
                                                        <?php echo $item->expiry_status; ?>
                                                    </span>
                                                </td>
                                                <td class="text-right">
                                                    <strong><?php echo number_format($item->value_at_risk, 2); ?></strong>
                                                </td>
                                                <td>
                                                    <small><?php echo $action_required; ?></small>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot>
                                        <tr class="bg-gray">
                                            <th colspan="6" class="text-right">Total Value at Risk:</th>
                                            <th class="text-right"><strong><?php echo number_format($total_value_at_risk, 2); ?></strong></th>
                                            <th></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        <?php } else { ?>
                            <div class="text-center text-success" style="padding: 50px;">
                                <i class="fa fa-check-circle fa-3x"></i>
                                <h4>No Items Expiring Soon</h4>
                                <p>All items are within safe expiry periods.</p>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Low Stock Items Report -->
        <div class="row" id="low-stock">
            <div class="col-md-12">
                <div class="box box-danger">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-exclamation-triangle"></i> Low Stock Items</h3>
                        <div class="box-tools pull-right">
                            <span class="label label-danger"><?php echo count($low_stock_items); ?> items</span>
                            <button type="button" class="btn btn-danger btn-sm" onclick="exportReport('low_stock')">
                                <i class="fa fa-download"></i> Export
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($low_stock_items)) { ?>
                            <div class="table-responsive">
                                <table class="table table-striped table-bordered" id="lowStockTable">
                                    <thead>
                                        <tr class="bg-red">
                                            <th>Item</th>
                                            <th>Category</th>
                                            <th>Current Stock</th>
                                            <th>Reorder Level</th>
                                            <th>Stock Deficit</th>
                                            <th>Unit Cost</th>
                                            <th>Reorder Value</th>
                                            <th>Last Updated</th>
                                            <th>Quick Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $total_reorder_value = 0;
                                        foreach ($low_stock_items as $item) { 
                                            $deficit = max(0, $item->reorder_level - $item->current_stock);
                                            $reorder_value = $deficit * $item->unit_cost;
                                            $total_reorder_value += $reorder_value;
                                        ?>
                                            <tr>
                                                <td>
                                                    <strong><?php echo $item->consumable_name; ?></strong>
                                                    <br><small class="text-muted"><?php echo $item->consumable_code; ?></small>
                                                </td>
                                                <td>
                                                    <span class="label label-default"><?php echo $item->category_name; ?></span>
                                                </td>
                                                <td class="text-center">
                                                    <span class="text-danger">
                                                        <strong><?php echo number_format($item->current_stock); ?></strong>
                                                    </span>
                                                    <br><small><?php echo $item->unit_of_measure; ?></small>
                                                </td>
                                                <td class="text-center">
                                                    <?php echo number_format($item->reorder_level); ?>
                                                </td>
                                                <td class="text-center">
                                                    <span class="text-danger">
                                                        <strong><?php echo number_format($deficit); ?></strong>
                                                    </span>
                                                </td>
                                                <td class="text-right">
                                                    KES <?php echo number_format($item->unit_cost, 2); ?>
                                                </td>
                                                <td class="text-right">
                                                    <strong>KES <?php echo number_format($reorder_value, 2); ?></strong>
                                                </td>
                                                <td>
                                                    <small><?php echo date('M j, Y', strtotime($item->updated_at)); ?></small>
                                                </td>
                                                <td>
                                                    <a href="<?php echo base_url(); ?>admin/consumable/create_requisition?consumable_id=<?php echo $item->id; ?>" 
                                                       class="btn btn-primary btn-xs">
                                                        <i class="fa fa-plus"></i> Request
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot>
                                        <tr class="bg-gray">
                                            <th colspan="6" class="text-right">Total Reorder Value Needed:</th>
                                            <th class="text-right"><strong>KES <?php echo number_format($total_reorder_value, 2); ?></strong></th>
                                            <th colspan="2"></th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        <?php } else { ?>
                            <div class="text-center text-success" style="padding: 50px;">
                                <i class="fa fa-check-circle fa-3x"></i>
                                <h4>No Low Stock Items</h4>
                                <p>All items are above their reorder levels.</p>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Usage Analysis Charts -->
        <div class="row" id="usage-analysis">
            <div class="col-md-6">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-pie-chart"></i> Stock Distribution</h3>
                    </div>
                    <div class="box-body">
                        <canvas id="stockDistributionChart" height="300"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-line-chart"></i> Value by Category</h3>
                    </div>
                    <div class="box-body">
                        <canvas id="valueByCategory" height="300"></canvas>
                    </div>
                </div>
            </div>
        </div>

    </section>
</div>

<!-- Custom CSS -->
<style>
    .btn-app {
        border-radius: 3px;
        position: relative;
        padding: 15px 5px;
        margin: 0 0 10px 10px;
        min-width: 80px;
        height: 60px;
        text-align: center;
        color: #666;
        border: 1px solid #ddd;
        background-color: #f4f4f4;
        font-size: 12px;
    }
    
    .btn-app:hover {
        background-color: #f4f4f4;
        color: #444;
        border-color: #aaa;
        text-decoration: none;
    }
    
    .btn-app > .fa {
        font-size: 20px;
        display: block;
    }
    
    .progress-sm {
        height: 10px;
    }
    
    .table > thead > tr.bg-green > th,
    .table > thead > tr.bg-yellow > th,
    .table > thead > tr.bg-red > th {
        color: white;
    }
    
    .bg-green { background-color: #00a65a !important; }
    .bg-yellow { background-color: #f39c12 !important; }
    .bg-red { background-color: #dd4b39 !important; }
    .bg-gray { background-color: #d2d6de !important; }
    
    .text-success { color: #00a65a !important; }
    .text-warning { color: #f39c12 !important; }
    .text-danger { color: #dd4b39 !important; }
    .text-info { color: #3c8dbc !important; }
    
    .table th {
        font-weight: 600;
    }
    
    .label {
        font-size: 85%;
        padding: 3px 6px;
    }
</style>

<!-- JavaScript -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.4/Chart.min.js"></script>

<script>
$(document).ready(function() {
    // Initialize DataTables
    $('#stockSummaryTable, #expiringItemsTable, #lowStockTable').DataTable({
        "paging": false,
        "searching": false,
        "info": false,
        "ordering": true,
        "autoWidth": false
    });
    
    // Initialize Charts
    initializeCharts();
    
    // Smooth scrolling for anchor links
    $('a[href^="#"]').on('click', function(event) {
        var target = $(this.getAttribute('href'));
        if( target.length ) {
            event.preventDefault();
            $('html, body').stop().animate({
                scrollTop: target.offset().top - 70
            }, 1000);
        }
    });
});

/**
 * Initialize charts
 */
function initializeCharts() {
    // Stock Distribution Pie Chart
    var stockCtx = document.getElementById('stockDistributionChart').getContext('2d');
    var stockData = {
        labels: [
            <?php foreach ($stock_summary as $summary) { 
                echo "'" . $summary->category_name . "',";
            } ?>
        ],
        datasets: [{
            data: [
                <?php foreach ($stock_summary as $summary) { 
                    echo $summary->total_stock . ",";
                } ?>
            ],
            backgroundColor: [
                '#3c8dbc', '#00a65a', '#f39c12', '#dd4b39', '#605ca8', 
                '#00c0ef', '#39cccc', '#d2d6de', '#ff851b', '#01ff70'
            ]
        }]
    };
    
    new Chart(stockCtx, {
        type: 'pie',
        data: stockData,
        options: {
            responsive: true,
            maintainAspectRatio: false,
            legend: {
                position: 'bottom'
            }
        }
    });
    
    // Value by Category Bar Chart
    var valueCtx = document.getElementById('valueByCategory').getContext('2d');
    var valueData = {
        labels: [
            <?php foreach ($stock_summary as $summary) { 
                echo "'" . $summary->category_name . "',";
            } ?>
        ],
        datasets: [{
            label: 'Value (KES)',
            data: [
                <?php foreach ($stock_summary as $summary) { 
                    echo $summary->total_value . ",";
                } ?>
            ],
            backgroundColor: '#3c8dbc',
            borderColor: '#2c6aa0',
            borderWidth: 1
        }]
    };
    
    new Chart(valueCtx, {
        type: 'bar',
        data: valueData,
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                yAxes: [{
                    ticks: {
                        beginAtZero: true,
                        callback: function(value) {
                            return 'KES ' + value.toLocaleString();
                        }
                    }
                }]
            },
            tooltips: {
                callbacks: {
                    label: function(tooltipItem, data) {
                        return 'KES ' + tooltipItem.yLabel.toLocaleString();
                    }
                }
            }
        }
    });
}

/**
 * Export report
 */
function exportReport(reportType) {
    var url = '<?php echo base_url(); ?>admin/consumable/export_report/' + reportType;
    window.open(url, '_blank');
}

/**
 * Print report
 */
function printReport() {
    window.print();
}

// Initialize tooltips
$(document).ready(function() {
    $('[data-toggle="tooltip"]').tooltip();
});
</script>