<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-edit"></i> Edit Consumable
            <small>Update consumable item information</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url(); ?>admin/consumable">Consumable Store</a></li>
            <li><a href="<?php echo base_url(); ?>admin/consumable/consumables">Manage Consumables</a></li>
            <li class="active">Edit: <?php echo $consumable->consumable_name; ?></li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { ?>
            <div class="row">
                <div class="col-md-12">
                    <?php echo $this->session->flashdata('msg'); ?>
                </div>
            </div>
        <?php } ?>

        <!-- Form validation errors -->
        <?php if (validation_errors()) { ?>
            <div class="row">
                <div class="col-md-12">
                    <div class="alert alert-danger">
                        <i class="fa fa-exclamation-triangle"></i>
                        <strong>Please correct the following errors:</strong>
                        <?php echo validation_errors(); ?>
                    </div>
                </div>
            </div>
        <?php } ?>

        <!-- Current Item Info -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-info-circle"></i> Current Item Information</h3>
                        <div class="box-tools pull-right">
                            <span class="label label-info">Last Updated: <?php echo date('M j, Y H:i', strtotime($consumable->updated_at)); ?></span>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-3">
                                <strong>Code:</strong> <?php echo $consumable->consumable_code; ?><br>
                                <strong>Category:</strong> <?php echo $consumable->category_name; ?><br>
                                <strong>Status:</strong> 
                                <span class="label <?php echo ($consumable->is_active == 'yes') ? 'label-success' : 'label-danger'; ?>">
                                    <?php echo ucfirst($consumable->is_active); ?>
                                </span>
                            </div>
                            <div class="col-md-3">
                                <strong>Current Stock:</strong> <?php echo number_format($consumable->current_stock); ?> <?php echo $consumable->unit_of_measure; ?><br>
                                <strong>Unit Cost:</strong> KES <?php echo number_format($consumable->unit_cost, 2); ?><br>
                                <strong>Selling Price:</strong> KES <?php echo number_format($consumable->selling_price, 2); ?>
                            </div>
                            <div class="col-md-3">
                                <strong>Minimum Stock:</strong> <?php echo number_format($consumable->minimum_stock); ?><br>
                                <strong>Reorder Level:</strong> <?php echo number_format($consumable->reorder_level); ?><br>
                                <strong>Maximum Stock:</strong> <?php echo number_format($consumable->maximum_stock); ?>
                            </div>
                            <div class="col-md-3">
                                <strong>Total Value:</strong> KES <?php echo number_format($consumable->current_stock * $consumable->unit_cost, 2); ?><br>
                                <strong>Prescription Required:</strong> <?php echo ucfirst($consumable->requires_prescription); ?><br>
                                <strong>Controlled:</strong> <?php echo ucfirst($consumable->is_controlled_substance); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Edit Form -->
        <form action="<?php echo current_url(); ?>" method="post" id="editConsumableForm">
            
            <!-- Basic Information -->
            <div class="box box-primary">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-info-circle"></i> Basic Information</h3>
                    <div class="box-tools pull-right">
                        <span class="label label-primary">Required Fields</span>
                    </div>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="consumable_name">Consumable Name <span class="text-danger">*</span></label>
                                <input type="text" name="consumable_name" id="consumable_name" 
                                       class="form-control" placeholder="e.g., Paracetamol Tablets" 
                                       value="<?php echo set_value('consumable_name', $consumable->consumable_name); ?>" required>
                                <small class="text-muted">Enter the common/brand name of the consumable</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="generic_name">Generic Name</label>
                                <input type="text" name="generic_name" id="generic_name" 
                                       class="form-control" placeholder="e.g., Acetaminophen" 
                                       value="<?php echo set_value('generic_name', $consumable->generic_name); ?>">
                                <small class="text-muted">Scientific/generic name (if applicable)</small>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="category_id">Category <span class="text-danger">*</span></label>
                                <select name="category_id" id="category_id" class="form-control" required>
                                    <option value="">Select Category</option>
                                    <?php foreach ($categories as $category) { ?>
                                        <option value="<?php echo $category->id; ?>" 
                                                <?php echo (set_value('category_id', $consumable->category_id) == $category->id) ? 'selected' : ''; ?>>
                                            <?php echo $category->category_name; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="consumable_code">Item Code</label>
                                <input type="text" name="consumable_code" id="consumable_code" 
                                       class="form-control" readonly style="background-color: #f4f4f4;" 
                                       value="<?php echo $consumable->consumable_code; ?>">
                                <small class="text-muted">Item code cannot be changed</small>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label for="barcode">Barcode</label>
                                <input type="text" name="barcode" id="barcode" 
                                       class="form-control" placeholder="Scan or enter barcode" 
                                       value="<?php echo set_value('barcode', $consumable->barcode); ?>">
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-10">
                            <div class="form-group">
                                <label for="description">Description</label>
                                <textarea name="description" id="description" class="form-control" rows="3" 
                                          placeholder="Detailed description of the consumable item"><?php echo set_value('description', $consumable->description); ?></textarea>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <label for="is_active">Status</label>
                                <select name="is_active" id="is_active" class="form-control">
                                    <option value="yes" <?php echo (set_value('is_active', $consumable->is_active) == 'yes') ? 'selected' : ''; ?>>Active</option>
                                    <option value="no" <?php echo (set_value('is_active', $consumable->is_active) == 'no') ? 'selected' : ''; ?>>Inactive</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Pricing and Stock Information -->
            <div class="box box-success">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-money"></i> Pricing & Stock Information</h3>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="unit_of_measure">Unit of Measure <span class="text-danger">*</span></label>
                                <select name="unit_of_measure" id="unit_of_measure" class="form-control" required>
                                    <option value="">Select Unit</option>
                                    <option value="pieces" <?php echo (set_value('unit_of_measure', $consumable->unit_of_measure) == 'pieces') ? 'selected' : ''; ?>>Pieces</option>
                                    <option value="tablets" <?php echo (set_value('unit_of_measure', $consumable->unit_of_measure) == 'tablets') ? 'selected' : ''; ?>>Tablets</option>
                                    <option value="capsules" <?php echo (set_value('unit_of_measure', $consumable->unit_of_measure) == 'capsules') ? 'selected' : ''; ?>>Capsules</option>
                                    <option value="vials" <?php echo (set_value('unit_of_measure', $consumable->unit_of_measure) == 'vials') ? 'selected' : ''; ?>>Vials</option>
                                    <option value="ampoules" <?php echo (set_value('unit_of_measure', $consumable->unit_of_measure) == 'ampoules') ? 'selected' : ''; ?>>Ampoules</option>
                                    <option value="bottles" <?php echo (set_value('unit_of_measure', $consumable->unit_of_measure) == 'bottles') ? 'selected' : ''; ?>>Bottles</option>
                                    <option value="boxes" <?php echo (set_value('unit_of_measure', $consumable->unit_of_measure) == 'boxes') ? 'selected' : ''; ?>>Boxes</option>
                                    <option value="ml" <?php echo (set_value('unit_of_measure', $consumable->unit_of_measure) == 'ml') ? 'selected' : ''; ?>>Milliliters</option>
                                    <option value="liters" <?php echo (set_value('unit_of_measure', $consumable->unit_of_measure) == 'liters') ? 'selected' : ''; ?>>Liters</option>
                                    <option value="grams" <?php echo (set_value('unit_of_measure', $consumable->unit_of_measure) == 'grams') ? 'selected' : ''; ?>>Grams</option>
                                    <option value="kg" <?php echo (set_value('unit_of_measure', $consumable->unit_of_measure) == 'kg') ? 'selected' : ''; ?>>Kilograms</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="unit_cost">Unit Cost (KES) <span class="text-danger">*</span></label>
                                <input type="number" name="unit_cost" id="unit_cost" 
                                       class="form-control" step="0.01" min="0" 
                                       placeholder="0.00" value="<?php echo set_value('unit_cost', $consumable->unit_cost); ?>" required>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="markup_percentage">Markup % <small class="text-muted">(Trade)</small></label>
                                <input type="number" name="markup_percentage" id="markup_percentage" 
                                       class="form-control" step="0.01" min="0" max="1000" 
                                       placeholder="0.00" value="<?php echo set_value('markup_percentage', $consumable->markup_percentage); ?>">
                                <small class="text-muted">Percentage markup on cost price</small>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="selling_price">Selling Price (KES) <small class="text-muted">(Auto-calculated)</small></label>
                                <input type="text" id="selling_price" class="form-control" 
                                       readonly placeholder="0.00" style="background-color: #f4f4f4;">
                                <small class="text-success">Automatically calculated from cost + markup</small>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="current_stock">Current Stock <small class="text-warning">(Read Only)</small></label>
                                <input type="text" class="form-control" readonly style="background-color: #f4f4f4;" 
                                       value="<?php echo number_format($consumable->current_stock); ?> <?php echo $consumable->unit_of_measure; ?>">
                                <small class="text-muted">Use transactions to adjust stock</small>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="minimum_stock">Minimum Stock</label>
                                <input type="number" name="minimum_stock" id="minimum_stock" 
                                       class="form-control" min="0" placeholder="0" 
                                       value="<?php echo set_value('minimum_stock', $consumable->minimum_stock); ?>">
                                <small class="text-muted">Alert threshold</small>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="reorder_level">Reorder Level</label>
                                <input type="number" name="reorder_level" id="reorder_level" 
                                       class="form-control" min="0" placeholder="0" 
                                       value="<?php echo set_value('reorder_level', $consumable->reorder_level); ?>">
                                <small class="text-muted">Auto-requisition trigger</small>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="maximum_stock">Maximum Stock</label>
                                <input type="number" name="maximum_stock" id="maximum_stock" 
                                       class="form-control" min="0" placeholder="0" 
                                       value="<?php echo set_value('maximum_stock', $consumable->maximum_stock); ?>">
                                <small class="text-muted">Storage capacity limit</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Product Details -->
            <div class="box box-info">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-flask"></i> Product Details</h3>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="manufacturer">Manufacturer</label>
                                <input type="text" name="manufacturer" id="manufacturer" 
                                       class="form-control" placeholder="e.g., GSK, Pfizer" 
                                       value="<?php echo set_value('manufacturer', $consumable->manufacturer); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="brand">Brand</label>
                                <input type="text" name="brand" id="brand" 
                                       class="form-control" placeholder="e.g., Panadol, Amoxil" 
                                       value="<?php echo set_value('brand', $consumable->brand); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="strength">Strength</label>
                                <input type="text" name="strength" id="strength" 
                                       class="form-control" placeholder="e.g., 500mg, 10ml" 
                                       value="<?php echo set_value('strength', $consumable->strength); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="formulation">Formulation</label>
                                <select name="formulation" id="formulation" class="form-control">
                                    <option value="">Select Formulation</option>
                                    <option value="tablet" <?php echo (set_value('formulation', $consumable->formulation) == 'tablet') ? 'selected' : ''; ?>>Tablet</option>
                                    <option value="capsule" <?php echo (set_value('formulation', $consumable->formulation) == 'capsule') ? 'selected' : ''; ?>>Capsule</option>
                                    <option value="injection" <?php echo (set_value('formulation', $consumable->formulation) == 'injection') ? 'selected' : ''; ?>>Injection</option>
                                    <option value="syrup" <?php echo (set_value('formulation', $consumable->formulation) == 'syrup') ? 'selected' : ''; ?>>Syrup</option>
                                    <option value="cream" <?php echo (set_value('formulation', $consumable->formulation) == 'cream') ? 'selected' : ''; ?>>Cream</option>
                                    <option value="ointment" <?php echo (set_value('formulation', $consumable->formulation) == 'ointment') ? 'selected' : ''; ?>>Ointment</option>
                                    <option value="drops" <?php echo (set_value('formulation', $consumable->formulation) == 'drops') ? 'selected' : ''; ?>>Drops</option>
                                    <option value="powder" <?php echo (set_value('formulation', $consumable->formulation) == 'powder') ? 'selected' : ''; ?>>Powder</option>
                                    <option value="solution" <?php echo (set_value('formulation', $consumable->formulation) == 'solution') ? 'selected' : ''; ?>>Solution</option>
                                    <option value="other" <?php echo (set_value('formulation', $consumable->formulation) == 'other') ? 'selected' : ''; ?>>Other</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="therapeutic_class">Therapeutic Class</label>
                                <input type="text" name="therapeutic_class" id="therapeutic_class" 
                                       class="form-control" placeholder="e.g., Analgesic, Antibiotic" 
                                       value="<?php echo set_value('therapeutic_class', $consumable->therapeutic_class); ?>">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label for="storage_temperature">Storage Temperature</label>
                                <select name="storage_temperature" id="storage_temperature" class="form-control">
                                    <option value="">Select Storage Temp</option>
                                    <option value="Room Temperature" <?php echo (set_value('storage_temperature', $consumable->storage_temperature) == 'Room Temperature') ? 'selected' : ''; ?>>Room Temperature (15-30°C)</option>
                                    <option value="2-8°C" <?php echo (set_value('storage_temperature', $consumable->storage_temperature) == '2-8°C') ? 'selected' : ''; ?>>Refrigerated (2-8°C)</option>
                                    <option value="Below -18°C" <?php echo (set_value('storage_temperature', $consumable->storage_temperature) == 'Below -18°C') ? 'selected' : ''; ?>>Frozen (Below -18°C)</option>
                                    <option value="Cool & Dry" <?php echo (set_value('storage_temperature', $consumable->storage_temperature) == 'Cool & Dry') ? 'selected' : ''; ?>>Cool & Dry Place</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>&nbsp;</label><br>
                                <div class="checkbox">
                                    <label>
                                        <input type="checkbox" name="batch_tracking" value="yes" 
                                               <?php echo (set_value('batch_tracking', $consumable->batch_tracking) == 'yes') ? 'checked' : ''; ?>>
                                        Enable Batch Tracking
                                    </label>
                                </div>
                                <div class="checkbox">
                                    <label>
                                        <input type="checkbox" name="expiry_tracking" value="yes" 
                                               <?php echo (set_value('expiry_tracking', $consumable->expiry_tracking) == 'yes') ? 'checked' : ''; ?>>
                                        Enable Expiry Tracking
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="storage_conditions">Storage Conditions</label>
                                <textarea name="storage_conditions" id="storage_conditions" class="form-control" rows="2" 
                                          placeholder="Special storage requirements (e.g., protect from light, keep away from moisture)"><?php echo set_value('storage_conditions', $consumable->storage_conditions); ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Medical Information -->
            <div class="box box-warning">
                <div class="box-header with-border">
                    <h3 class="box-title"><i class="fa fa-medkit"></i> Medical Information</h3>
                    <div class="box-tools pull-right">
                        <span class="label label-warning">For Medical Items Only</span>
                    </div>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Prescription & Control Status</label><br>
                                <div class="checkbox">
                                    <label>
                                        <input type="checkbox" name="requires_prescription" value="yes" 
                                               <?php echo (set_value('requires_prescription', $consumable->requires_prescription) == 'yes') ? 'checked' : ''; ?>>
                                        <strong>Requires Prescription</strong>
                                        <small class="text-muted">- Patient needs doctor's prescription</small>
                                    </label>
                                </div>
                                <div class="checkbox">
                                    <label>
                                        <input type="checkbox" name="is_controlled_substance" value="yes" 
                                               <?php echo (set_value('is_controlled_substance', $consumable->is_controlled_substance) == 'yes') ? 'checked' : ''; ?>>
                                        <strong>Controlled Substance</strong>
                                        <small class="text-danger">- Requires special handling and tracking</small>
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="controlled_schedule">Drug Schedule <small>(if controlled)</small></label>
                                <select name="controlled_schedule" id="controlled_schedule" class="form-control">
                                    <option value="">Not Applicable</option>
                                    <option value="Schedule I" <?php echo (set_value('controlled_schedule', $consumable->controlled_schedule) == 'Schedule I') ? 'selected' : ''; ?>>Schedule I - High abuse potential</option>
                                    <option value="Schedule II" <?php echo (set_value('controlled_schedule', $consumable->controlled_schedule) == 'Schedule II') ? 'selected' : ''; ?>>Schedule II - Moderate to high abuse potential</option>
                                    <option value="Schedule III" <?php echo (set_value('controlled_schedule', $consumable->controlled_schedule) == 'Schedule III') ? 'selected' : ''; ?>>Schedule III - Moderate abuse potential</option>
                                    <option value="Schedule IV" <?php echo (set_value('controlled_schedule', $consumable->controlled_schedule) == 'Schedule IV') ? 'selected' : ''; ?>>Schedule IV - Low abuse potential</option>
                                    <option value="Schedule V" <?php echo (set_value('controlled_schedule', $consumable->controlled_schedule) == 'Schedule V') ? 'selected' : ''; ?>>Schedule V - Lowest abuse potential</option>
                                </select>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="dosage_instructions">Dosage Instructions</label>
                                <textarea name="dosage_instructions" id="dosage_instructions" class="form-control" rows="3" 
                                          placeholder="Standard dosage instructions for this medication (e.g., Take 1 tablet twice daily with food)"><?php echo set_value('dosage_instructions', $consumable->dosage_instructions); ?></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="contraindications">Contraindications</label>
                                <textarea name="contraindications" id="contraindications" class="form-control" rows="4" 
                                          placeholder="Conditions or situations where this medication should not be used"><?php echo set_value('contraindications', $consumable->contraindications); ?></textarea>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="side_effects">Side Effects</label>
                                <textarea name="side_effects" id="side_effects" class="form-control" rows="4" 
                                          placeholder="Common or serious side effects that may occur"><?php echo set_value('side_effects', $consumable->side_effects); ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Form Actions -->
            <div class="box box-default">
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-4">
                            <a href="<?php echo base_url(); ?>admin/consumable/consumables" class="btn btn-default btn-lg">
                                <i class="fa fa-arrow-left"></i> Back to List
                            </a>
                        </div>
                        <div class="col-md-4 text-center">
                            <button type="button" class="btn btn-info btn-lg" onclick="viewTransactionHistory()">
                                <i class="fa fa-history"></i> View Transaction History
                            </button>
                        </div>
                        <div class="col-md-4 text-right">
                            <button type="button" class="btn btn-warning btn-lg" onclick="resetChanges()">
                                <i class="fa fa-refresh"></i> Reset Changes
                            </button>
                            <button type="submit" class="btn btn-success btn-lg">
                                <i class="fa fa-save"></i> Update Consumable
                            </button>
                        </div>
                    </div>
                </div>
            </div>

        </form>

    </section>
</div>

<!-- Custom CSS -->
<style>
    .box-body .form-group {
        margin-bottom: 20px;
    }
    
    .form-control:focus {
        border-color: #28a745;
        box-shadow: inset 0 1px 1px rgba(0,0,0,.075), 0 0 0 3px rgba(40,167,69,.1);
    }
    
    .text-danger {
        color: #dc3545 !important;
    }
    
    .checkbox label {
        font-weight: normal;
        padding-left: 5px;
    }
    
    .checkbox input[type="checkbox"] {
        margin-top: 2px;
    }
    
    .box-header .box-title {
        font-size: 16px;
        font-weight: 600;
    }
    
    .btn-lg {
        padding: 10px 20px;
        font-size: 16px;
    }
    
    .alert {
        border-radius: 4px;
    }
    
    textarea.form-control {
        resize: vertical;
    }
    
    .text-success { color: #28a745 !important; }
    .text-muted { color: #6c757d !important; }
    .text-warning { color: #ffc107 !important; }
    .text-danger { color: #dc3545 !important; }
    .text-info { color: #17a2b8 !important; }
</style>

<!-- JavaScript -->
<script>
$(document).ready(function() {
    // Auto-calculate selling price when unit cost or markup changes
    $('#unit_cost, #markup_percentage').on('input', function() {
        calculateSellingPrice();
    });
    
    // Calculate initial selling price
    calculateSellingPrice();
    
    // Show/hide controlled substance fields
    $('input[name="is_controlled_substance"]').change(function() {
        if ($(this).is(':checked')) {
            $('#controlled_schedule').prop('disabled', false);
            $(this).closest('.checkbox').addClass('text-danger');
        } else {
            $('#controlled_schedule').prop('disabled', true).val('');
            $(this).closest('.checkbox').removeClass('text-danger');
        }
    });
    
    // Initialize controlled substance state
    $('input[name="is_controlled_substance"]').trigger('change');
    
    // Form validation
    $('#editConsumableForm').on('submit', function(e) {
        var isValid = true;
        var errors = [];
        
        // Check required fields
        if (!$('#consumable_name').val().trim()) {
            errors.push('Consumable name is required');
            isValid = false;
        }
        
        if (!$('#category_id').val()) {
            errors.push('Category is required');
            isValid = false;
        }
        
        if (!$('#unit_of_measure').val()) {
            errors.push('Unit of measure is required');
            isValid = false;
        }
        
        var unitCost = parseFloat($('#unit_cost').val());
        if (!unitCost || unitCost <= 0) {
            errors.push('Unit cost must be greater than 0');
            isValid = false;
        }
        
        // Validate stock levels
        var minStock = parseInt($('#minimum_stock').val()) || 0;
        var maxStock = parseInt($('#maximum_stock').val()) || 0;
        var reorderLevel = parseInt($('#reorder_level').val()) || 0;
        
        if (maxStock > 0 && minStock > maxStock) {
            errors.push('Minimum stock cannot be greater than maximum stock');
            isValid = false;
        }
        
        if (reorderLevel > 0 && minStock > 0 && reorderLevel < minStock) {
            errors.push('Reorder level should be greater than or equal to minimum stock');
            isValid = false;
        }
        
        if (!isValid) {
            e.preventDefault();
            showErrors(errors);
            return false;
        }
        
        // Show loading state
        $(this).find('button[type="submit"]').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Updating...');
    });
});

/**
 * Calculate selling price based on unit cost and markup
 */
function calculateSellingPrice() {
    var unitCost = parseFloat($('#unit_cost').val()) || 0;
    var markup = parseFloat($('#markup_percentage').val()) || 0;
    
    if (unitCost > 0) {
        var sellingPrice = unitCost * (1 + (markup / 100));
        $('#selling_price').val(sellingPrice.toFixed(2));
    } else {
        $('#selling_price').val('');
    }
}

/**
 * Reset form to original values
 */
function resetChanges() {
    if (confirm('Are you sure you want to reset all changes? This will restore the original values.')) {
        location.reload();
    }
}

/**
 * View transaction history for this consumable
 */
function viewTransactionHistory() {
    var consumableId = <?php echo $consumable->id; ?>;
    window.open('<?php echo base_url(); ?>admin/consumable/transactions?consumable_id=' + consumableId, '_blank');
}

/**
 * Show validation errors
 */
function showErrors(errors) {
    var errorHtml = '<div class="alert alert-danger alert-dismissible">' +
                   '<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>' +
                   '<h4><i class="icon fa fa-ban"></i> Please correct the following errors:</h4><ul>';
    
    errors.forEach(function(error) {
        errorHtml += '<li>' + error + '</li>';
    });
    
    errorHtml += '</ul></div>';
    
    // Insert error message at the top of the form
    $('.content-header').after(errorHtml);
    
    // Scroll to top
    $('html, body').animate({ scrollTop: 0 }, 'fast');
    
    // Auto-hide after 10 seconds
    setTimeout(function() {
        $('.alert-danger').fadeOut();
    }, 10000);
}

// Initialize tooltips
$(document).ready(function() {
    $('[data-toggle="tooltip"]').tooltip();
});
</script>