<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <i class="fa fa-cubes"></i> Consumable Store Dashboard
            <small>Manage hospital consumables and inventory</small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
            <li class="active">Consumable Store</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content">
        
        <!-- Flash Messages -->
        <?php if ($this->session->flashdata('msg')) { ?>
            <div class="row">
                <div class="col-md-12">
                    <?php echo $this->session->flashdata('msg'); ?>
                </div>
            </div>
        <?php } ?>

        <!-- Overview Statistics -->
        <div class="row">
            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3><?php echo count($total_consumables); ?></h3>
                        <p>Total Consumables</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-cubes"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/consumable/consumables" class="small-box-footer">
                        View All <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-yellow">
                    <div class="inner">
                        <h3><?php echo count($low_stock_items); ?></h3>
                        <p>Low Stock Items</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-exclamation-triangle"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/consumable/consumables?low_stock=1" class="small-box-footer">
                        View Details <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-red">
                    <div class="inner">
                        <h3><?php echo count($active_alerts); ?></h3>
                        <p>Active Alerts</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-bell"></i>
                    </div>
                    <a href="#alertsModal" data-toggle="modal" class="small-box-footer">
                        View Alerts <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>

            <div class="col-lg-3 col-xs-6">
                <div class="small-box bg-aqua">
                    <div class="inner">
                        <h3><?php echo count($expiring_items); ?></h3>
                        <p>Expiring Soon</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-clock-o"></i>
                    </div>
                    <a href="<?php echo base_url(); ?>admin/consumable/reports#expiring" class="small-box-footer">
                        View Report <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
        </div>

        <!-- Quick Actions -->
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-flash"></i> Quick Actions</h3>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-2">
                                <a href="<?php echo base_url(); ?>admin/consumable/add_consumable" class="btn btn-success btn-block btn-lg">
                                    <i class="fa fa-plus"></i><br>Add Consumable<br>
                                    <small>New Item</small>
                                </a>
                            </div>
                            <div class="col-md-2">
                                <a href="<?php echo base_url(); ?>admin/consumable/release_to_department" class="btn btn-primary btn-block btn-lg">
                                    <i class="fa fa-share"></i><br>Release to Dept<br>
                                    <small>Issue Items</small>
                                </a>
                            </div>
                            <div class="col-md-2">
                                <a href="<?php echo base_url(); ?>admin/consumable/create_requisition" class="btn btn-warning btn-block btn-lg">
                                    <i class="fa fa-file-text"></i><br>New Requisition<br>
                                    <small>Request Items</small>
                                </a>
                            </div>
                            <div class="col-md-2">
                                <a href="<?php echo base_url(); ?>admin/consumable/department_stock" class="btn btn-info btn-block btn-lg">
                                    <i class="fa fa-building"></i><br>Dept Stock<br>
                                    <small>View by Department</small>
                                </a>
                            </div>
                            <div class="col-md-2">
                                <a href="<?php echo base_url(); ?>admin/consumable/transactions" class="btn btn-default btn-block btn-lg">
                                    <i class="fa fa-exchange"></i><br>Transactions<br>
                                    <small>View History</small>
                                </a>
                            </div>
                            <div class="col-md-2">
                                <a href="<?php echo base_url(); ?>admin/consumable/reports" class="btn btn-purple btn-block btn-lg">
                                    <i class="fa fa-bar-chart"></i><br>Reports<br>
                                    <small>Analytics</small>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Stock Summary by Category -->
        <div class="row">
            <div class="col-md-8">
                <div class="box box-default">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-pie-chart"></i> Stock Summary by Category</h3>
                        <div class="box-tools pull-right">
                            <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                <i class="fa fa-minus"></i>
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($stock_summary)) { ?>
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>Category</th>
                                            <th class="text-center">Total Items</th>
                                            <th class="text-center">Total Stock</th>
                                            <th class="text-right">Total Value (KES)</th>
                                            <th class="text-center">Low Stock</th>
                                            <th class="text-center">Out of Stock</th>
                                            <th class="text-center">Status</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php 
                                        $grand_total_value = 0;
                                        $grand_total_items = 0;
                                        foreach ($stock_summary as $summary) { 
                                            $grand_total_value += $summary->total_value;
                                            $grand_total_items += $summary->total_items;
                                            
                                            // Determine status
                                            $status_class = 'label-success';
                                            $status_text = 'Good';
                                            if ($summary->out_of_stock_items > 0) {
                                                $status_class = 'label-danger';
                                                $status_text = 'Critical';
                                            } elseif ($summary->low_stock_items > 0) {
                                                $status_class = 'label-warning';
                                                $status_text = 'Warning';
                                            }
                                        ?>
                                            <tr>
                                                <td><strong><?php echo $summary->category_name; ?></strong></td>
                                                <td class="text-center"><?php echo number_format($summary->total_items); ?></td>
                                                <td class="text-center"><?php echo number_format($summary->total_stock); ?></td>
                                                <td class="text-right"><?php echo number_format($summary->total_value, 2); ?></td>
                                                <td class="text-center">
                                                    <?php if ($summary->low_stock_items > 0) { ?>
                                                        <span class="label label-warning"><?php echo $summary->low_stock_items; ?></span>
                                                    <?php } else { ?>
                                                        <span class="text-muted">0</span>
                                                    <?php } ?>
                                                </td>
                                                <td class="text-center">
                                                    <?php if ($summary->out_of_stock_items > 0) { ?>
                                                        <span class="label label-danger"><?php echo $summary->out_of_stock_items; ?></span>
                                                    <?php } else { ?>
                                                        <span class="text-muted">0</span>
                                                    <?php } ?>
                                                </td>
                                                <td class="text-center">
                                                    <span class="label <?php echo $status_class; ?>"><?php echo $status_text; ?></span>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                    <tfoot>
                                        <tr class="bg-gray">
                                            <th><strong>TOTAL</strong></th>
                                            <th class="text-center"><strong><?php echo number_format($grand_total_items); ?></strong></th>
                                            <th class="text-center">-</th>
                                            <th class="text-right"><strong><?php echo number_format($grand_total_value, 2); ?></strong></th>
                                            <th class="text-center">-</th>
                                            <th class="text-center">-</th>
                                            <th class="text-center">-</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        <?php } else { ?>
                            <div class="text-center text-muted">
                                <i class="fa fa-info-circle fa-2x"></i>
                                <p>No stock data available</p>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>

            <!-- Recent Transactions -->
            <div class="col-md-4">
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-exchange"></i> Recent Transactions</h3>
                        <div class="box-tools pull-right">
                            <span class="label label-info"><?php echo count($recent_transactions); ?> recent</span>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($recent_transactions)) { ?>
                            <div class="table-responsive" style="max-height: 400px; overflow-y: auto;">
                                <table class="table table-condensed">
                                    <tbody>
                                        <?php foreach ($recent_transactions as $transaction) { 
                                            $icon_class = 'fa-plus text-green';
                                            $badge_class = 'label-success';
                                            
                                            switch ($transaction->transaction_type) {
                                                case 'issued':
                                                    $icon_class = 'fa-minus text-red';
                                                    $badge_class = 'label-primary';
                                                    break;
                                                case 'returned':
                                                    $icon_class = 'fa-undo text-blue';
                                                    $badge_class = 'label-info';
                                                    break;
                                                case 'expired':
                                                case 'damaged':
                                                    $icon_class = 'fa-times text-red';
                                                    $badge_class = 'label-danger';
                                                    break;
                                            }
                                        ?>
                                            <tr>
                                                <td style="width: 10px;">
                                                    <i class="fa <?php echo $icon_class; ?>"></i>
                                                </td>
                                                <td>
                                                    <small>
                                                        <strong><?php echo $transaction->consumable_name; ?></strong><br>
                                                        <span class="text-muted">
                                                            <?php echo ucfirst($transaction->transaction_type); ?> • 
                                                            <?php echo $transaction->quantity; ?> units
                                                            <?php if ($transaction->to_department) { ?>
                                                                → <?php echo $transaction->to_department; ?>
                                                            <?php } ?>
                                                        </span>
                                                    </small>
                                                </td>
                                                <td style="width: 80px;">
                                                    <small class="text-muted">
                                                        <?php echo date('M j, H:i', strtotime($transaction->transaction_date)); ?>
                                                    </small>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                            <div class="text-center">
                                <a href="<?php echo base_url(); ?>admin/consumable/transactions" class="btn btn-sm btn-info">
                                    <i class="fa fa-list"></i> View All Transactions
                                </a>
                            </div>
                        <?php } else { ?>
                            <div class="text-center text-muted">
                                <i class="fa fa-info-circle"></i>
                                <p>No recent transactions</p>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Low Stock Items Alert -->
        <?php if (!empty($low_stock_items)) { ?>
            <div class="row">
                <div class="col-md-12">
                    <div class="box box-warning">
                        <div class="box-header with-border">
                            <h3 class="box-title">
                                <i class="fa fa-exclamation-triangle"></i> Low Stock Alert
                            </h3>
                            <div class="box-tools pull-right">
                                <button type="button" class="btn btn-box-tool" data-widget="collapse">
                                    <i class="fa fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="box-body">
                            <div class="row">
                                <?php foreach (array_slice($low_stock_items, 0, 6) as $item) { ?>
                                    <div class="col-md-2">
                                        <div class="info-box bg-yellow">
                                            <span class="info-box-icon"><i class="fa fa-cube"></i></span>
                                            <div class="info-box-content">
                                                <span class="info-box-text" style="font-size: 11px;">
                                                    <?php echo substr($item->consumable_name, 0, 20) . (strlen($item->consumable_name) > 20 ? '...' : ''); ?>
                                                </span>
                                                <span class="info-box-number"><?php echo $item->current_stock; ?></span>
                                                <div class="progress">
                                                    <div class="progress-bar" style="width: <?php echo ($item->current_stock / max($item->reorder_level, 1)) * 100; ?>%"></div>
                                                </div>
                                                <span class="progress-description" style="font-size: 10px;">
                                                    Reorder: <?php echo $item->reorder_level; ?>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                            <?php if (count($low_stock_items) > 6) { ?>
                                <div class="text-center">
                                    <a href="<?php echo base_url(); ?>admin/consumable/consumables?low_stock=1" class="btn btn-warning">
                                        <i class="fa fa-list"></i> View All <?php echo count($low_stock_items); ?> Low Stock Items
                                    </a>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>

    </section>
</div>

<!-- Alerts Modal -->
<div class="modal fade" id="alertsModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">
                    <i class="fa fa-bell text-red"></i> Active System Alerts
                </h4>
            </div>
            <div class="modal-body">
                <?php if (!empty($active_alerts)) { ?>
                    <div class="table-responsive">
                        <table class="table table-condensed">
                            <thead>
                                <tr>
                                    <th>Alert Type</th>
                                    <th>Item</th>
                                    <th>Message</th>
                                    <th>Level</th>
                                    <th>Date</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($active_alerts as $alert) { 
                                    $level_class = 'label-info';
                                    switch ($alert->alert_level) {
                                        case 'critical':
                                            $level_class = 'label-danger';
                                            break;
                                        case 'warning':
                                            $level_class = 'label-warning';
                                            break;
                                    }
                                ?>
                                    <tr>
                                        <td>
                                            <span class="label label-default">
                                                <?php echo ucwords(str_replace('_', ' ', $alert->alert_type)); ?>
                                            </span>
                                        </td>
                                        <td><?php echo $alert->consumable_name ?: 'N/A'; ?></td>
                                        <td>
                                            <small><?php echo $alert->message; ?></small>
                                        </td>
                                        <td>
                                            <span class="label <?php echo $level_class; ?>">
                                                <?php echo ucfirst($alert->alert_level); ?>
                                            </span>
                                        </td>
                                        <td>
                                            <small><?php echo date('M j, Y', strtotime($alert->created_at)); ?></small>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                <?php } else { ?>
                    <div class="text-center text-muted">
                        <i class="fa fa-check-circle fa-3x text-green"></i>
                        <h4>No Active Alerts</h4>
                        <p>All systems are running normally.</p>
                    </div>
                <?php } ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<!-- Custom CSS for enhanced styling -->
<style>
    .small-box h3 {
        font-size: 2.2em;
        font-weight: bold;
        margin: 0 0 10px 0;
        white-space: nowrap;
        padding: 0;
    }
    
    .btn-purple {
        background-color: #605ca8;
        border-color: #555299;
        color: #fff;
    }
    
    .btn-purple:hover,
    .btn-purple:focus,
    .btn-purple:active {
        background-color: #555299;
        border-color: #4e4a89;
        color: #fff;
    }
    
    .info-box-content {
        padding: 5px 10px;
    }
    
    .info-box-text {
        text-transform: none;
        font-weight: 500;
    }
    
    .box-body .table > tbody > tr > td {
        border-top: 1px solid #f4f4f4;
    }
    
    .table-condensed > tbody > tr > td {
        padding: 8px;
    }
    
    .progress {
        height: 2px;
        margin-bottom: 2px;
        background-color: rgba(255,255,255,0.2);
    }
    
    .progress-bar {
        background-color: rgba(255,255,255,0.7);
    }
    
    .modal-lg {
        width: 900px;
    }
    
    .text-green { color: #00a65a !important; }
    .text-red { color: #dd4b39 !important; }
    .text-blue { color: #3c8dbc !important; }
</style>

<!-- JavaScript for enhanced functionality -->
<script>
$(document).ready(function() {
    // Auto-refresh dashboard every 5 minutes
    setTimeout(function() {
        location.reload();
    }, 300000);
    
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();
    
    // Add click tracking for quick actions
    $('.small-box-footer, .btn-lg').click(function() {
        var action = $(this).find('i').attr('class') + ' ' + $(this).text().trim();
        console.log('Dashboard action clicked:', action);
    });
});
</script>