<body>
   <div class="content-wrapper">
       <div class="container-fluid">
           <!-- Enhanced Page Header -->
           <div class="page-header fade-in">
               <h1 class="page-title">
                   <i class="fa fa-user-md"></i> 
                   Enhanced Consultation System
               </h1>
               <p class="page-subtitle">Advanced patient consultation with biometric verification & comprehensive lab tests integration</p>
           </div>

           <!-- Step Indicator -->
           <div class="consultation-panel fade-in">
               <div class="panel-body">
                   <div class="step-indicator">
                       <div class="step active" id="step-search">
                           <div class="step-circle">1</div>
                           <div class="step-label">Search</div>
                       </div>
                       <div class="step" id="step-verify">
                           <div class="step-circle">2</div>
                           <div class="step-label">Verify</div>
                       </div>
                       <div class="step" id="step-consult">
                           <div class="step-circle">3</div>
                           <div class="step-label">Action</div>
                       </div>
                       <div class="step" id="step-save">
                           <div class="step-circle">4</div>
                           <div class="step-label">Save</div>
                       </div>
                   </div>
               </div>
           </div>

           <!-- Enhanced Patient Search Section -->
           <div class="consultation-panel fade-in" id="patient-search-panel">
               <div class="panel-header">
                   <h3 class="panel-title">
                       <i class="fa fa-search"></i> Patient Search & Selection
                   </h3>
               </div>
               <div class="panel-body">
                   <div class="patient-search-container">
                       <div class="row">
                           <div class="col-md-12">
                               <div class="form-group-modern">
                                   <label class="form-label-modern">Search Patient for Consultation</label>
                                   <select class="form-control form-control-modern" id="consultation_patient_search" style="width: 100%;">
                                       <option value="">Loading patients...</option>
                                   </select>
                               </div>
                           </div>
                       </div>
                   </div>
               </div>
           </div>

           <!-- Enhanced Patient Details Section -->
           <div class="consultation-panel fade-in" id="patientDetailsSection" style="display:none;">
               <div class="panel-header">
                   <h3 class="panel-title">
                       <i class="fa fa-user"></i> Patient Information & Actions 
                       <span class="pull-right" id="verificationStatus"></span>
                   </h3>
               </div>
               <div class="panel-body">
                   <!-- Patient Details Card -->
                   <div class="patient-details-card" id="patientDetailsCard">
                       <div class="patient-info-grid">
                           <div class="patient-basic-info">
                               <div>
                                   <div class="info-item">
                                       <div class="info-label">Name</div>
                                       <div class="info-value" id="patientName">-</div>
                                   </div>
                                   <div class="info-item">
                                       <div class="info-label">Age</div>
                                       <div class="info-value" id="patientAge">-</div>
                                   </div>
                                   <div class="info-item">
                                       <div class="info-label">Gender</div>
                                       <div class="info-value" id="patientGender">-</div>
                                   </div>
                               </div>
                               <div>
                                   <div class="info-item">
                                       <div class="info-label">Phone</div>
                                       <div class="info-value" id="patientPhone">-</div>
                                   </div>
                                   <div class="info-item">
                                       <div class="info-label">Blood Group</div>
                                      <div class="info-value" id="patientBloodGroup">-</div>
                                  </div>
                                  <div class="info-item">
                                      <div class="info-label">Allergies</div>
                                      <div class="info-value" id="patientAllergies">-</div>
                                  </div>
                              </div>
                          </div>
                          <div class="patient-photo-container">
                              <img id="patientPhoto" src="../uploads/patient_images/no_image.png" alt="Patient Photo" class="patient-photo">
                          </div>
                          
                          <!-- Patient Barcode -->
                          <div class="patient-barcode-container" style="text-align: center; margin-top: 15px; padding: 15px; background: #f8f9fa; border-radius: 6px;">
                              <h6 style="margin-bottom: 8px; font-weight: 600; font-size: 12px; color: #495057;">Patient Barcode</h6>
                              <svg id="patientBarcode" style="margin-bottom: 10px;"></svg>
                              <div id="barcodeData" style="font-size: 11px; color: #6c757d; word-break: break-all;"></div>
                              <button type="button" id="printBarcodeBtn" class="btn btn-modern btn-sm" style="margin-top: 10px;">
                                  <i class="fa fa-print"></i> Print Barcode
                              </button>
                          </div>
                      </div>
                      
                      <!-- Workflow Status Panel -->
                      <div class="workflow-status-panel">
                          <div class="workflow-badge" id="workflowBadge">General Patient</div>
                          <div id="currentPatientStatus">
                              <p style="margin: 0; font-size: 12px;">Select patient to view status</p>
                          </div>
                      </div>
                  </div>

                  <!-- SecuGen Service Status Display -->
                  <div id="secugen_service_status" class="verification-status-display">
                      <div class="text-center">
                          <div class="spinner-modern"></div> Initializing SecuGen WebAPI...
                      </div>
                  </div>

                  <!-- Enhanced Biometric Verification Section -->
                  <div class="verification-container" id="biometricVerificationSection">
                      <h5 style="margin-bottom: 15px; color: #495057; font-weight: 600; font-size: 15px;">
                          <i class="fa fa-fingerprint"></i> SecuGen Biometric Verification
                      </h5>
                      
                      <div class="verification-grid">
                          <div>
                              <!-- Stored Fingerprint Display -->
                              <div class="fingerprint-display-container" id="storedFingerprintContainer">
                                  <h6 style="margin-bottom: 8px; font-weight: 600; font-size: 12px;">Stored Template</h6>
                                  <img id="storedFingerprintImage" src="./Images/PlaceFinger.bmp" alt="Stored Fingerprint" class="fingerprint-image">
                                  <div id="storedTemplateInfo" style="margin-top: 8px; font-size: 11px;">
                                      <div id="storedTemplateDetails" class="text-muted">No template loaded</div>
                                      <div id="storedTemplateMetrics" class="text-info"></div>
                                  </div>
                              </div>
                          </div>
                          
                          <div>
                              <!-- Live Fingerprint Display -->
                              <div class="fingerprint-display-container" id="liveFingerprintContainer">
                                  <h6 style="margin-bottom: 8px; font-weight: 600; font-size: 12px;">Live Capture</h6>
                                  <img id="liveFingerprintImage" src="./Images/PlaceFinger.bmp" alt="Live Fingerprint" class="fingerprint-image">
                                  <div id="liveTemplateInfo" style="margin-top: 8px; font-size: 11px;">
                                      <div id="liveTemplateDetails" class="text-muted">Ready for capture</div>
                                  </div>
                              </div>
                          </div>
                      </div>
                      
                      <!-- Verification Status -->
                      <div id="fingerprintStatus" class="text-center mb-3">
                          <div class="status-info">
                              <i class="fa fa-info-circle"></i> Ready for biometric verification - Consultation Module
                          </div>
                      </div>
                      
                      <!-- Verification Controls -->
                      <div class="text-center">
                          <div class="btn-group" style="margin-bottom: 10px;">
                              <button type="button" id="manualVerifyBtn" class="btn btn-modern">
                                  <i class="fa fa-fingerprint"></i> Manual Print Capture
                              </button>
                              <button type="button" id="verifyIdentity" class="btn btn-verification" disabled>
                                  <i class="fa fa-shield"></i> Verify Print
                              </button>
                          </div>
                          <br>
                          <div class="btn-group">
                              <button type="button" id="clearCaptureData" class="btn btn-manual btn-sm">
                                  <i class="fa fa-refresh"></i> Clear
                              </button>
                          </div>
                      </div>
                      
                      <!-- Hidden Template Storage -->
                      <input type="hidden" id="patientStoredTemplate" value="">
                      <input type="hidden" id="liveScannedTemplate" value="">
                      <input type="hidden" id="lastMatchScore" value="0">
                      <input type="hidden" id="verificationQuality" value="">
                  </div>

                  <!-- Patient Actions Panel -->
                  <div class="patient-actions-panel" style="margin-top: 20px;">
                      <div class="workflow-badge">Patient Actions</div>
                      <p style="margin: 8px 0; font-size: 12px;">Choose an action for this patient</p>
                      
                      <div class="action-buttons">
                          <button type="button" id="startConsultationBtn" class="btn btn-modern btn-lg" disabled>
                              <i class="fa fa-user-md"></i> New Consultation
                          </button>
                          <button type="button" id="reviewPatientBtn" class="btn btn-info-modern btn-lg">
                              <i class="fa fa-eye"></i> Review Patient History
                          </button>
                      </div>
                      
                      <div id="verificationMessage" style="margin-top: 12px;"></div>
                  </div>

                  <!-- Hidden fields -->
                  <input type="hidden" id="selectedPatientId" value="">
                  <input type="hidden" id="verificationPassed" value="0">

                  <!-- Recent Activity Summary -->
<div class="row" style="margin-top: 20px;">
    <div class="col-md-6">
        <div class="consultation-panel">
            <div class="panel-header">
                <h5 class="panel-title">
                    <i class="fa fa-history"></i> Recent Consultations
                </h5>
            </div>
            <div class="panel-body">
                <div id="reviewConsultationsList">  <!-- ✅ This is the correct ID -->
                    <p class="text-muted">Select a patient to view consultation history</p>
                </div>
            </div>
        </div>
    </div>
                      
                      <div class="col-md-6">
                          <div class="consultation-panel">
                              <div class="panel-header">
                                  <h5 class="panel-title">
                                      <i class="fa fa-shield"></i> Verification History
                                  </h5>
                              </div>
                              <div class="panel-body">
                                  <div id="verificationHistory" style="max-height: 200px; overflow-y: auto;">
                                      <p class="text-muted">No verification attempts yet</p>
                                  </div>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
          </div>
      </div>
  </div>

  <!-- Enhanced Consultation Modal with Lab Tests -->
  <div class="modal fade modal-modern" id="consultationModal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-lg" role="document">
          <div class="modal-content">
              <div class="modal-header">
                  <button type="button" class="close" data-dismiss="modal">&times;</button>
                  <h4 class="modal-title">
                      <i class="fa fa-user-md"></i> <span id="modalTitle">Enhanced Consultation Assessment</span>
                  </h4>
              </div>
              <form id="consultationForm">
                  <div class="modal-body">
                      <!-- Patient Info Display -->
                      <div class="alert-info-modern">
                          <div class="row">
                              <div class="col-md-8">
                                  <strong>Patient:</strong> <span id="modalPatientName"></span><br>
                                  <small>ID: <span id="modalPatientId"></span></small>
                              </div>
                              <div class="col-md-4 text-right">
                                  <span id="modalVerificationBadge"></span>
                                  <div id="modalVerificationDetails" style="font-size: 10px; margin-top: 5px;"></div>
                              </div>
                          </div>
                      </div>

                      <!-- Consultation Details Section -->
                      <div class="consultation-panel" style="margin: 15px 0;">
                          <div class="panel-header">
                              <h5 class="panel-title"><i class="fa fa-stethoscope"></i> Consultation Details</h5>
                          </div>
                          <div class="panel-body">
                              <div class="row">
                                  <div class="col-md-6">
                                      <div class="form-group-modern">
                                          <label class="form-label-modern">Consultation Date <span class="text-danger">*</span></label>
                                          <input type="date" name="consultation_date" id="consultationDate" class="form-control form-control-modern" required>
                                      </div>
                                  </div>
                                  <div class="col-md-6">
                                      <div class="form-group-modern">
                                          <label class="form-label-modern">Doctor <span class="text-danger">*</span></label>
                                          <select name="doctor" id="consultationDoctor" class="form-control form-control-modern" required>
                                              <option value="">Select Doctor</option>
                                          </select>
                                      </div>
                                  </div>
                              </div>
                              
                              <div class="form-group-modern">
                                  <label class="form-label-modern">Chief Complaint / Symptoms <span class="text-danger">*</span></label>
                                  <textarea name="symptoms" id="consultationSymptoms" class="form-control form-control-modern" rows="4" placeholder="Describe patient symptoms and chief complaint..." required></textarea>
                              </div>

                              <!-- ICD-10 Diagnosis Section (Hidden for GCC patients) -->
                              <div class="form-group-modern" id="diagnosisSection">
                                  <label class="form-label-modern">Primary Diagnosis (ICD-10)</label>
                                  <div class="row">
                                      <div class="col-md-8">
                                          <select name="diagnosis_code_id" id="consultationDiagnosis" class="form-control form-control-modern" style="width: 100%;">
                                              <option value="">Search and select ICD-10 diagnosis...</option>
                                          </select>
                                      </div>
                                      <div class="col-md-4">
                                          <button type="button" id="addCustomDiagnosis" class="btn btn-modern btn-sm">
                                              <i class="fa fa-plus"></i> Add Custom
                                          </button>
                                          <button type="button" id="clearDiagnosis" class="btn btn-manual btn-sm">
                                              <i class="fa fa-times"></i> Clear
                                          </button>
                                      </div>
                                  </div>
                                  <div id="selectedDiagnosisInfo" style="margin-top: 8px; display: none;">
                                      <div class="alert-success-modern" style="padding: 8px; margin-bottom: 8px;">
                                          <strong>Selected:</strong> <span id="selectedDiagnosisCode"></span> - <span id="selectedDiagnosisTitle"></span><br>
                                          <small class="text-muted" id="selectedDiagnosisCategory"></small>
                                      </div>
                                  </div>
                              </div>

                              <!-- Custom Diagnosis Input -->
                              <div class="form-group-modern" id="customDiagnosisGroup" style="display: none;">
                                  <label class="form-label-modern">Custom Diagnosis Description</label>
                                  <textarea name="diagnosis_custom" id="consultationDiagnosisCustom" class="form-control form-control-modern" rows="2" placeholder="Enter custom diagnosis if not found in ICD-10 codes..."></textarea>
                                  <small class="text-info">Use this field for diagnoses not covered by standard ICD-10 codes</small>
                              </div>

                              <div class="form-group-modern">
                                  <label class="form-label-modern">Consultation Notes</label>
                                  <textarea name="notes" id="consultationNotes" class="form-control form-control-modern" rows="3" placeholder="Additional consultation notes, assessment findings, and recommendations..."></textarea>
                              </div>
                          </div>
                      </div>

                      <!-- Laboratory Tests Section (OPTIONAL) -->
                      <div class="lab-tests-panel lab-tests-optional" style="margin: 15px 0;">
                          <div style="background: rgba(255,255,255,0.2); border-radius: 6px; padding: 15px; margin-bottom: 15px;">
                              <h5 style="margin: 0 0 10px 0; color: white; font-weight: 600;">
                                  <i class="fa fa-flask"></i> Laboratory Tests Selection (Optional)
                              </h5>
                              <p style="margin: 0; font-size: 12px; color: rgba(255,255,255,0.9);">
                                  Select tests if needed for this consultation - not mandatory
                              </p>
                          </div>
                          
                          <!-- Test Categories Tabs -->
                          <div class="nav nav-pills" style="margin-bottom: 15px;">
                              <li class="active">
                                  <a href="#hematologyTests" data-toggle="tab" class="test-category-tab">
                                      <i class="fa fa-tint"></i> Hematology
                                  </a>
                              </li>
                              <li>
                                  <a href="#chemistryTests" data-toggle="tab" class="test-category-tab">
                                      <i class="fa fa-flask"></i> Chemistry
                                  </a>
                              </li>
                              <li>
                                  <a href="#microbiologyTests" data-toggle="tab" class="test-category-tab">
                                      <i class="fa fa-bug"></i> Microbiology
                                  </a>
                              </li>
                              <li>
                                  <a href="#serologyTests" data-toggle="tab" class="test-category-tab">
                                      <i class="fa fa-shield"></i> Serology
                                  </a>
                              </li>
                              <li>
                                  <a href="#otherTests" data-toggle="tab" class="test-category-tab">
                                      <i class="fa fa-plus"></i> Others
                                  </a>
                              </li>
                          </div>
                          
                          <!-- Test Categories Content -->
                          <div class="tab-content" style="background: rgba(255,255,255,0.1); border-radius: 6px; padding: 15px;">
                              <div class="tab-pane active" id="hematologyTests">
                                  <div class="row" id="hematologyTestsList">
                                      <div class="col-md-12 text-center text-muted">
                                          <i class="fa fa-spinner fa-spin"></i> Loading hematology tests...
                                      </div>
                                  </div>
                              </div>
                              <div class="tab-pane" id="chemistryTests">
                                  <div class="row" id="chemistryTestsList">
                                      <div class="col-md-12 text-center text-muted">
                                          <i class="fa fa-spinner fa-spin"></i> Loading chemistry tests...
                                      </div>
                                  </div>
                              </div>
                              <div class="tab-pane" id="microbiologyTests">
                                  <div class="row" id="microbiologyTestsList">
                                      <div class="col-md-12 text-center text-muted">
                                          <i class="fa fa-spinner fa-spin"></i> Loading microbiology tests...
                                      </div>
                                  </div>
                              </div>
                              <div class="tab-pane" id="serologyTests">
                                  <div class="row" id="serologyTestsList">
                                      <div class="col-md-12 text-center text-muted">
                                          <i class="fa fa-spinner fa-spin"></i> Loading serology tests...
                                      </div>
                                  </div>
                              </div>
                              <div class="tab-pane" id="otherTests">
                                  <div class="row" id="otherTestsList">
                                      <div class="col-md-12 text-center text-muted">
                                          <i class="fa fa-spinner fa-spin"></i> Loading other tests...
                                      </div>
                                  </div>
                              </div>
                          </div>
                          
                          <!-- Test Selection Summary -->
                          <div style="background: rgba(255,255,255,0.2); border-radius: 6px; padding: 15px; margin-top: 15px;">
                              <div class="row">
                                  <div class="col-md-4">
                                      <strong>Selected Tests:</strong> <span id="selectedTestsCount">0</span>
                                  </div>
                                  <div class="col-md-4">
                                      <strong>Estimated Cost:</strong> Ksh.<span id="estimatedTestsCost">0.00</span>
                                  </div>
                                  <div class="col-md-4 text-right">
                                      <button type="button" id="selectAllTests" class="btn btn-modern btn-sm">
                                          <i class="fa fa-check-square"></i> Select All
                                      </button>
                                      <button type="button" id="clearAllTests" class="btn btn-manual btn-sm">
                                          <i class="fa fa-square-o"></i> Clear All
                                      </button>
                                  </div>
                              </div>
                              <div style="margin-top: 10px;">
                                  <div id="selectedTestsList">
                                      <em class="text-muted">No tests selected</em>
                                  </div>
                              </div>
                          </div>
                          
                          <!-- Test Instructions -->
                          <div class="row" style="margin-top: 15px;">
                              <div class="col-md-6">
                                  <div class="form-group-modern">
                                      <label class="form-label-modern" style="color: white;">Test Priority</label>
                                      <select name="test_priority" id="testPriority" class="form-control form-control-modern">
                                          <option value="normal">Normal</option>
                                          <option value="urgent">Urgent</option>
                                          <option value="stat">STAT</option>
                                      </select>
                                  </div>
                              </div>
                              <div class="col-md-6">
                                  <div class="form-group-modern">
                                      <label class="form-label-modern" style="color: white;">Special Instructions</label>
                                      <input type="text" name="test_instructions" id="testInstructions" class="form-control form-control-modern" placeholder="Special instructions for lab...">
                                  </div>
                              </div>
                          </div>
                      </div>

                      <!-- Hidden fields for verification data -->
                      <input type="hidden" name="patient_id" id="modalPatientIdHidden">
                      <input type="hidden" name="consultation_id" id="modalConsultationId">
                      <input type="hidden" name="verification_status" id="modalVerificationStatus" value="0">
                      <input type="hidden" name="verification_score" id="modalVerificationScore" value="0">
                      <input type="hidden" name="verification_quality" id="modalVerificationQuality" value="">
                      <input type="hidden" name="verification_method" id="modalVerificationMethod" value="">
                      <input type="hidden" name="device_info" id="modalDeviceInfo" value="">
                      <input type="hidden" name="selected_tests" id="selectedTestsInput" value="">
                      <input type="hidden" name="workflow_type" id="modalWorkflowType" value="">
                      <input type="hidden" name="is_gcc_patient" id="modalIsGCCPatient" value="0">
                  </div>
                  
                  <!-- Prescription Drugs Section - Add after Lab Tests Section -->
<div class="box box-primary">
    <div class="box-header with-border">
        <h3 class="box-title">
            <i class="fa fa-pills"></i> Prescription Drugs Selection
        </h3>
        <div class="box-tools pull-right">
            <button type="button" class="btn btn-success btn-sm" onclick="clearAllPrescriptions()">
                <i class="fa fa-refresh"></i> Clear All
            </button>
        </div>
    </div>
    
    <div class="box-body">
        <!-- Drug Search Controls -->
        <div class="row">
            <div class="col-md-12">
                <div class="form-group">
                    <label for="drugSearch">Search and Add Medications</label>
                    <div class="input-group">
                        <input type="text" 
                               id="drugSearch" 
                               name="search_drugs" 
                               class="form-control" 
                               placeholder="Search drugs by name, category, or composition..." 
                               autocomplete="off">
                        <div class="input-group-btn">
                            <button type="button" id="searchDrugsBtn" class="btn btn-primary search-btn">
                                <i class="fa fa-search"></i> Search
                            </button>
                            <button type="button" id="browseAllBtn" class="btn btn-info browse-btn">
                                <i class="fa fa-list"></i> Browse All
                            </button>
                        </div>
                    </div>
                    <small class="text-muted">
                        Start typing to search medicines. Automatic pharmacy integration with stock checking.
                    </small>
                </div>
            </div>
        </div>

        <!-- Filter by Category -->
        <div class="row">
            <div class="col-md-6">
                <div class="form-group">
                    <label for="medicineCategory">Filter by Category</label>
                    <select id="medicineCategory" name="category" class="form-control">
                        <option value="">All Categories</option>
                        <!-- Categories will be loaded dynamically -->
                    </select>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group">
                    <label>Selected Medications Count</label>
                    <div class="form-control-static">
                        <span class="badge badge-primary" id="selectedCount">0</span> medications selected
                    </div>
                </div>
            </div>
        </div>

        <!-- Search Results Section -->
        <div class="row">
            <div class="col-md-12">
                <div id="medicineSearchResults" class="medicine-results">
                    <div class="alert alert-info text-center">
                        <i class="fa fa-search"></i> 
                        <p>Enter medicine name, composition, or company to search</p>
                        <small class="text-muted">Or click "Browse All" to see all available medicines</small>
                    </div>
                </div>
                
                <!-- Pagination Container -->
                <div id="medicinePagination" class="medicine-pagination text-center" style="margin-top: 15px;">
                    <!-- Pagination will be inserted here -->
                </div>
            </div>
        </div>

        <!-- Selected Medicines Section -->
        <div class="row" style="margin-top: 20px;">
            <div class="col-md-12">
                <div class="panel panel-default">
                    <div class="panel-header" style="background: #f5f5f5; padding: 10px 15px; border-bottom: 1px solid #ddd;">
                        <h4 style="margin: 0;">
                            <i class="fa fa-check-square-o"></i> Selected Prescriptions
                        </h4>
                    </div>
                    <div class="panel-body">
                        <div id="selectedMedicines" class="selected-medicines">
                            <p class="text-muted">No medications selected yet</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Action Buttons -->
        <div class="row" style="margin-top: 15px;">
            <div class="col-md-12 text-center">
                <button type="button" class="btn btn-success btn-lg" onclick="generatePrescriptionNote()">
                    <i class="fa fa-file-text-o"></i> Generate Prescription
                </button>
                <button type="button" class="btn btn-warning btn-lg" onclick="clearAllPrescriptions()">
                    <i class="fa fa-times"></i> Clear All
                </button>
                <button type="button" class="btn btn-info btn-lg" onclick="savePrescriptionDraft()">
                    <i class="fa fa-save"></i> Save as Draft
                </button>
            </div>
        </div>

        <!-- Summary Information -->
        <div class="row" style="margin-top: 20px;">
            <div class="col-md-4">
                <div class="info-box">
                    <span class="info-box-icon bg-aqua"><i class="fa fa-pills"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Total Medications</span>
                        <span class="info-box-number" id="totalMedicationsCount">0</span>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box">
                    <span class="info-box-icon bg-green"><i class="fa fa-check"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">In Stock</span>
                        <span class="info-box-number" id="inStockCount">0</span>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="info-box">
                    <span class="info-box-icon bg-yellow"><i class="fa fa-exclamation-triangle"></i></span>
                    <div class="info-box-content">
                        <span class="info-box-text">Low Stock</span>
                        <span class="info-box-number" id="lowStockCount">0</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

                  <div class="modal-footer">
                      <button type="button" class="btn btn-manual" data-dismiss="modal">Cancel</button>
                      <button type="submit" class="btn btn-modern">
                         <i class="fa fa-save"></i> Save Consultation
                     </button>
                 </div>
             </form>
         </div>
     </div>
  </div>
  
  <!-- Drug Selection Modal -->
<div class="modal fade" id="drugSelectionModal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">
                    <i class="fa fa-pills"></i> Add Prescription - <span id="modalDrugName"></span>
                </h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <!-- Drug Information Display -->
                        <div class="drug-info-panel" style="background: #f8f9fa; padding: 15px; border-radius: 6px; margin-bottom: 15px;">
                            <h6 style="margin-bottom: 10px; color: #495057;">Drug Information</h6>
                            <div id="modalDrugInfo">
                                <p><strong>Name:</strong> <span id="modalDrugNameDisplay"></span></p>
                                <p><strong>Category:</strong> <span id="modalDrugCategory"></span></p>
                                <p><strong>Composition:</strong> <span id="modalDrugComposition"></span></p>
                                <p><strong>Unit:</strong> <span id="modalDrugUnit"></span></p>
                                <p><strong>Available Stock:</strong> <span id="modalDrugStock"></span> units</p>
                                <p><strong>Unit Price:</strong> KES <span id="modalDrugPrice"></span></p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <!-- Prescription Details Form -->
                        <div class="prescription-form">
                            <div class="form-group">
                                <label>Quantity to Prescribe <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="number" id="prescriptionQuantity" class="form-control" 
                                           min="1" max="100" value="1" required>
                                    <div class="input-group-addon">
                                        <span id="prescriptionUnit">tablets</span>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label>Dosage Instructions <span class="text-danger">*</span></label>
                                <select id="dosageInstructions" class="form-control" required>
                                    <option value="">Select dosage...</option>
                                    <option value="1 tablet once daily">1 tablet once daily</option>
                                    <option value="1 tablet twice daily">1 tablet twice daily</option>
                                    <option value="1 tablet three times daily">1 tablet three times daily</option>
                                    <option value="2 tablets once daily">2 tablets once daily</option>
                                    <option value="2 tablets twice daily">2 tablets twice daily</option>
                                    <option value="1 tablet every 4 hours">1 tablet every 4 hours</option>
                                    <option value="1 tablet every 6 hours">1 tablet every 6 hours</option>
                                    <option value="1 tablet every 8 hours">1 tablet every 8 hours</option>
                                    <option value="1 tablet as needed">1 tablet as needed</option>
                                    <option value="custom">Custom dosage...</option>
                                </select>
                            </div>
                            
                            <div class="form-group" id="customDosageGroup" style="display: none;">
                                <label>Custom Dosage Instructions</label>
                                <input type="text" id="customDosage" class="form-control" 
                                       placeholder="Enter custom dosage instructions...">
                            </div>
                            
                            <div class="form-group">
                                <label>Duration</label>
                                <div class="row">
                                    <div class="col-xs-8">
                                        <input type="number" id="prescriptionDuration" class="form-control" 
                                               min="1" max="90" value="7" placeholder="Duration">
                                    </div>
                                    <div class="col-xs-4">
                                        <select id="durationUnit" class="form-control">
                                            <option value="days">Days</option>
                                            <option value="weeks">Weeks</option>
                                            <option value="months">Months</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label>Administration Time</label>
                                <select id="administrationTime" class="form-control">
                                    <option value="">Select timing...</option>
                                    <option value="before_meals">Before meals</option>
                                    <option value="after_meals">After meals</option>
                                    <option value="with_meals">With meals</option>
                                    <option value="on_empty_stomach">On empty stomach</option>
                                    <option value="bedtime">At bedtime</option>
                                    <option value="morning">In the morning</option>
                                    <option value="evening">In the evening</option>
                                    <option value="as_needed">As needed</option>
                                </select>
                            </div>
                            
                            <div class="form-group">
                                <label>Special Instructions</label>
                                <textarea id="specialInstructions" class="form-control" rows="3" 
                                         placeholder="Any special instructions for this medication..."></textarea>
                            </div>
                            
                            <!-- Cost Calculation -->
                            <div class="prescription-cost-panel" style="background: #e8f5e8; padding: 10px; border-radius: 4px;">
                                <h6 style="margin-bottom: 8px; color: #2e7d32;">Cost Calculation</h6>
                                <div class="row">
                                    <div class="col-xs-6">
                                        <small><strong>Unit Price:</strong> KES <span id="costUnitPrice">0.00</span></small>
                                    </div>
                                    <div class="col-xs-6">
                                        <small><strong>Quantity:</strong> <span id="costQuantity">1</span></small>
                                    </div>
                                </div>
                                <div style="margin-top: 5px; padding-top: 5px; border-top: 1px solid #c8e6c9;">
                                    <strong>Total Cost: KES <span id="totalMedicationCost">0.00</span></strong>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Hidden fields for drug data -->
                <input type="hidden" id="modalDrugId">
                <input type="hidden" id="modalDrugSaleRate">
                <input type="hidden" id="modalDrugAvailableStock">
                
                <input type="hidden" name="selected_prescriptions" id="selectedPrescriptionsData" value="">
        <input type="hidden" name="total_prescriptions" id="totalPrescriptions" value="0">
        <input type="hidden" name="prescription_notes" id="prescriptionNotes" value="">
        <input type="hidden" name="pharmacy_notes" id="pharmacyNotes" value="">
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <button type="button" id="addPrescriptionBtn" class="btn btn-success">
                    <i class="fa fa-plus"></i> Add to Prescription
                </button>
            </div>
        </div>
    </div>
</div>


  <!-- Patient Review Modal -->
  <div class="modal fade modal-modern" id="patientReviewModal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-lg" role="document">
          <div class="modal-content">
              <div class="modal-header">
                  <button type="button" class="close" data-dismiss="modal">&times;</button>
                  <h4 class="modal-title">
                      <i class="fa fa-eye"></i> Patient Complete History Review
                  </h4>
              </div>
              <div class="modal-body">
                  <!-- Patient Summary Header -->
                  <div class="alert-info-modern">
                      <div class="row">
                          <div class="col-md-8">
                              <strong>Patient:</strong> <span id="reviewPatientName"></span><br>
                              <small>ID: <span id="reviewPatientId"></span> | Age: <span id="reviewPatientAge"></span> | Gender: <span id="reviewPatientGender"></span></small>
                          </div>
                          <div class="col-md-4 text-right">
                              <span id="reviewWorkflowBadge"></span>
                          </div>
                      </div>
                  </div>

                  <!-- Review Content Tabs -->
                  <ul class="nav nav-tabs nav-tabs-modern" style="margin-bottom: 20px;">
                      <li class="active">
                          <a href="#reviewConsultations" data-toggle="tab">
                              <i class="fa fa-user-md"></i> Consultations
                          </a>
                      </li>
                      <li>
                          <a href="#reviewLabTests" data-toggle="tab">
                              <i class="fa fa-flask"></i> Lab Tests
                          </a>
                      </li>
                      <li>
                          <a href="#reviewTriage" data-toggle="tab">
                              <i class="fa fa-stethoscope"></i> Triage History
                          </a>
                      </li>
                      <li>
                          <a href="#reviewVerifications" data-toggle="tab">
                              <i class="fa fa-shield"></i> Verifications
                          </a>
                      </li>
                      <li>
                          <a href="#reviewSummary" data-toggle="tab">
                              <i class="fa fa-chart-line"></i> Summary
                          </a>
                      </li>
                  </ul>

                  <div class="tab-content">
                      <!-- Consultations History -->
                      <!-- In the Patient Review Modal -->
<div class="tab-pane active" id="reviewConsultations">
    <div class="patient-review-panel">
        <div class="review-section">
            <h6><i class="fa fa-user-md"></i> Recent Consultations</h6>
            <!-- ✅ Use a different ID for the modal -->
            <div id="modalConsultationsList">
                <div class="text-center">
                    <div class="spinner-modern"></div> Loading consultation history...
                </div>
            </div>
        </div>
    </div>
</div>

                      <!-- Lab Tests History -->
                      <div class="tab-pane" id="reviewLabTests">
                          <div class="patient-review-panel">
                              <div class="review-section">
                                  <h6><i class="fa fa-flask"></i> Laboratory Test Results</h6>
                                  <div id="reviewLabTestsList">
                                      <div class="text-center">
                                          <div class="spinner-modern"></div> Loading lab test history...
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>

                      <!-- Triage History -->
                      <div class="tab-pane" id="reviewTriage">
                          <div class="patient-review-panel">
                              <div class="review-section">
                                  <h6><i class="fa fa-stethoscope"></i> Triage Assessment History</h6>
                                  <div id="reviewTriageList">
                                      <div class="text-center">
                                          <div class="spinner-modern"></div> Loading triage history...
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>

                      <!-- Verification History -->
                      <div class="tab-pane" id="reviewVerifications">
                          <div class="patient-review-panel">
                              <div class="review-section">
                                  <h6><i class="fa fa-shield"></i> Biometric Verification History</h6>
                                  <div id="reviewVerificationsList">
                                      <div class="text-center">
                                          <div class="spinner-modern"></div> Loading verification history...
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>

                      <!-- Patient Summary -->
                      <div class="tab-pane" id="reviewSummary">
                          <div class="patient-review-panel">
                              <div class="review-section">
                                  <h6><i class="fa fa-chart-line"></i> Patient Summary Statistics</h6>
                                  <div class="row">
                                      <div class="col-md-3">
                                          <div class="summary-card">
                                              <div class="summary-card-icon">
                                                  <i class="fa fa-user-md"></i>
                                              </div>
                                              <div class="summary-card-value" id="totalConsultations">0</div>
                                              <div class="summary-card-label">Total Consultations</div>
                                          </div>
                                      </div>
                                      <div class="col-md-3">
                                          <div class="summary-card">
                                              <div class="summary-card-icon">
                                                  <i class="fa fa-flask"></i>
                                              </div>
                                              <div class="summary-card-value" id="totalLabTests">0</div>
                                              <div class="summary-card-label">Lab Tests Done</div>
                                          </div>
                                      </div>
                                      <div class="col-md-3">
                                          <div class="summary-card">
                                              <div class="summary-card-icon">
                                                  <i class="fa fa-stethoscope"></i>
                                              </div>
                                              <div class="summary-card-value" id="totalTriageVisits">0</div>
                                              <div class="summary-card-label">Triage Visits</div>
                                          </div>
                                      </div>
                                      <div class="col-md-3">
                                          <div class="summary-card">
                                              <div class="summary-card-icon">
                                                  <i class="fa fa-shield"></i>
                                              </div>
                                              <div class="summary-card-value" id="totalVerifications">0</div>
                                              <div class="summary-card-label">Verifications</div>
                                          </div>
                                      </div>
                                  </div>
                                  
                                  <!-- Additional Summary Info -->
                                  <div class="review-section">
                                      <h6><i class="fa fa-info-circle"></i> Additional Information</h6>
                                      <div id="patientAdditionalInfo">
                                          <div class="review-item">
                                              <strong>First Visit:</strong> <span id="firstVisitDate">N/A</span>
                                          </div>
                                          <div class="review-item">
                                              <strong>Last Visit:</strong> <span id="lastVisitDate">N/A</span>
                                          </div>
                                          <div class="review-item">
                                              <strong>Most Common Diagnoses:</strong> <span id="commonDiagnoses">N/A</span>
                                          </div>
                                          <div class="review-item">
                                              <strong>Workflow Type:</strong> <span id="patientWorkflowType">N/A</span>
                                          </div>
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
              <div class="modal-footer">
                  <button type="button" class="btn btn-info-modern" id="printPatientSummary">
                      <i class="fa fa-print"></i> Print Summary
                  </button>
                  <button type="button" class="btn btn-modern" id="startNewConsultationFromReview">
                      <i class="fa fa-user-md"></i> Start New Consultation
                  </button>
                  <button type="button" class="btn btn-manual" data-dismiss="modal">Close</button>
              </div>
          </div>
      </div>
  </div>
  
  <!-- Prescription Modal - Add this to your consultation view -->
  <div class="modal fade" id="prescriptionModal" tabindex="-1" role="dialog" aria-labelledby="prescriptionModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title" id="prescriptionModalLabel">
                    <i class="fa fa-pills"></i> Add Medicine to Prescription
                </h4>
            </div>
            
            <div class="modal-body">
                <!-- Medicine Information -->
                <div class="row">
                    <div class="col-md-12">
                        <div class="panel panel-info">
                            <div class="panel-heading">
                                <h4 class="panel-title">Medicine Information</h4>
                            </div>
                            <div class="panel-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <strong>Medicine Name:</strong> <span id="modalMedicineName">-</span><br>
                                        <strong>Category:</strong> <span id="modalMedicineCategory">-</span><br>
                                        <strong>Unit:</strong> <span id="modalMedicineUnit">-</span>
                                    </div>
                                    <div class="col-md-6">
                                        <strong>Unit Price:</strong> <span id="modalMedicineUnitPrice">-</span><br>
                                        <strong>Composition:</strong> <span id="modalMedicineComposition">-</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Prescription Form -->
                <form id="prescriptionForm">
                    <input type="hidden" id="modalMedicineId" name="medicine_id" value="">
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="prescriptionQuantity">Quantity <span class="text-danger">*</span></label>
                                <input type="number" 
                                       id="prescriptionQuantity" 
                                       name="quantity" 
                                       class="form-control" 
                                       min="1" 
                                       max="1000" 
                                       value="1" 
                                       required>
                                <small class="text-muted">Number of units to prescribe</small>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="totalCost">Total Cost</label>
                                <div class="form-control-static" style="background: #f9f9f9; padding: 6px 12px; border: 1px solid #ddd; border-radius: 4px;">
                                    <strong id="totalCost">KES 0.00</strong>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="dosageInstructions">Dosage Instructions <span class="text-danger">*</span></label>
                                <input type="text" 
                                       id="dosageInstructions" 
                                       name="dosage_instructions" 
                                       class="form-control" 
                                       placeholder="e.g., Take 1 tablet twice daily after meals"
                                       value="Take as directed by doctor"
                                       required>
                                <small class="text-muted">How the patient should take the medicine</small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="prescriptionDuration">Duration <span class="text-danger">*</span></label>
                                <input type="number" 
                                       id="prescriptionDuration" 
                                       name="duration" 
                                       class="form-control" 
                                       min="1" 
                                       max="365" 
                                       value="7"
                                       required>
                                <small class="text-muted">Treatment duration</small>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="durationUnit">Duration Unit</label>
                                <select id="durationUnit" name="duration_unit" class="form-control">
                                    <option value="days">Days</option>
                                    <option value="weeks">Weeks</option>
                                    <option value="months">Months</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="administrationTime">Administration Time</label>
                                <select id="administrationTime" name="administration_time" class="form-control">
                                    <option value="">Select timing...</option>
                                    <option value="Before meals">Before meals</option>
                                    <option value="After meals">After meals</option>
                                    <option value="With meals">With meals</option>
                                    <option value="On empty stomach">On empty stomach</option>
                                    <option value="At bedtime">At bedtime</option>
                                    <option value="Morning">Morning</option>
                                    <option value="Evening">Evening</option>
                                    <option value="As needed">As needed</option>
                                </select>
                                <small class="text-muted">When to take the medicine</small>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="specialInstructions">Special Instructions</label>
                                <textarea id="specialInstructions" 
                                          name="special_instructions" 
                                          class="form-control" 
                                          rows="3" 
                                          placeholder="Any special instructions or warnings for the patient..."></textarea>
                                <small class="text-muted">Additional notes or warnings</small>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
            
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">
                    <i class="fa fa-times"></i> Cancel
                </button>
                <button type="button" class="btn btn-primary" id="addToPrescriptionBtn">
                    <i class="fa fa-plus"></i> Add to Prescription
                </button>
            </div>
        </div>
    </div>
</div>

  <!-- Lab Test Results Modal -->
  <div class="modal fade modal-modern" id="testResultsModal" tabindex="-1" role="dialog">
      <div class="modal-dialog" role="document">
          <div class="modal-content">
              <div class="modal-header">
                  <button type="button" class="close" data-dismiss="modal">&times;</button>
                  <h4 class="modal-title">
                      <i class="fa fa-flask"></i> Test Results Entry
                 </h4>
             </div>
             <form id="testResultsForm">
                 <div class="modal-body">
                     <div class="alert-info-modern">
                         <strong>Patient:</strong> <span id="resultPatientName"></span><br>
                         <strong>Test:</strong> <span id="resultTestName"></span>
                     </div>
                     
                     <div class="form-group-modern">
                         <label class="form-label-modern">Test Result <span class="text-danger">*</span></label>
                         <textarea name="test_result" id="testResult" class="form-control form-control-modern" rows="4" placeholder="Enter test results..." required></textarea>
                     </div>
                     
                     <div class="row">
                         <div class="col-md-6">
                             <div class="form-group-modern">
                                 <label class="form-label-modern">Result Status</label>
                                 <select name="result_status" id="resultStatus" class="form-control form-control-modern">
                                     <option value="normal">Normal</option>
                                     <option value="abnormal">Abnormal</option>
                                     <option value="critical">Critical</option>
                                     <option value="pending">Pending</option>
                                 </select>
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group-modern">
                                 <label class="form-label-modern">Reference Range</label>
                                 <input type="text" name="reference_range" id="referenceRange" class="form-control form-control-modern" placeholder="Normal range...">
                             </div>
                         </div>
                     </div>
                     
                     <div class="form-group-modern">
                         <label class="form-label-modern">Lab Notes</label>
                         <textarea name="lab_notes" id="labNotes" class="form-control form-control-modern" rows="2" placeholder="Laboratory notes..."></textarea>
                     </div>
                     
                     <input type="hidden" name="test_id" id="resultTestId">
                 </div>
                 
                 <div class="modal-footer">
                     <button type="button" class="btn btn-manual" data-dismiss="modal">Cancel</button>
                     <button type="submit" class="btn btn-modern">
                         <i class="fa fa-save"></i> Save Results
                     </button>
                 </div>
             </form>
         </div>
     </div>
  </div>

  <!-- Include necessary JavaScript libraries -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/3.4.1/js/bootstrap.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
  <!-- Replace the existing JsBarcode script tag with this -->
<script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.5/dist/JsBarcode.all.min.js"></script>
  <!-- Include SecuGen WebAPI scripts -->
  <script src="./WebAPI-JavaScript/secugen.js"></script>
<script>
   // Enhanced Consultation System - JavaScript Logic
// Enhanced with optional lab tests, GCC diagnosis hiding, and patient review functionality
'use strict';

$(document).ready(function() {
    console.log('🔬 ENHANCED Consultation System Starting...');
    
    // Initialize with modern visual feedback
    initializeEnhancedConsultationSystem();
    
    // Set current date for forms
    const today = new Date().toISOString().split('T')[0];
    $('#consultationDate, #reportDateFrom, #reportDateTo').val(today);
    
    // Initialize prescription management
    window.prescriptionState = {
        selectedDrugs: [],
        totalCost: 0,
        searchResults: [] // This is critical!
    };
    
    // Drug search functionality
    $('#drugSearchInput').on('keyup', function(e) {
        if (e.keyCode === 13) { // Enter key
            searchDrugs();
        }
    });
    
    $('#searchDrugsBtn').on('click', searchDrugs);
    $('#showAllDrugsBtn').on('click', loadAllDrugs);
    $('#drugCategoryFilter').on('change', filterByCategory);
    
    // Prescription modal handlers
    $('#dosageInstructions').on('change', function() {
        if ($(this).val() === 'custom') {
            $('#customDosageGroup').show();
        } else {
            $('#customDosageGroup').hide();
        }
    });
    
    $('#prescriptionQuantity').on('input', updateCostCalculation);
    $('#addPrescriptionBtn').on('click', addPrescriptionToDrugList);
    
    // Prescription management
    $('#clearAllPrescriptions').on('click', clearAllPrescriptions);
    $('#generatePrescriptionNote').on('click', generatePrescriptionNote);
    
    // Load initial drug data
    loadAllDrugs();
});

// =============================================
// ENHANCED SYSTEM INITIALIZATION
// =============================================

function initializeEnhancedConsultationSystem() {
    logDiagnostic('🚀 Initializing ENHANCED Consultation System...', 'info');
    
    // Initialize modern visual elements
    updateStepIndicator('search');
    initializeModernAnimations();
    
    // SecuGen configuration
    window.secugenConfig = {
        baseUrl: 'https://localhost:8443',
        httpUrl: 'http://localhost:8443',
        endpoints: {
            https: {
                capture: 'https://localhost:8443/SGIFPCapture',
                matchScore: 'https://localhost:8443/SGIMatchScore',
                getInfo: 'https://localhost:8443/SGIFPGetInfo'
            },
            http: {
                capture: 'http://localhost:8443/SGIFPCapture',
                matchScore: 'http://localhost:8443/SGIMatchScore',
                getInfo: 'http://localhost:8443/SGIFPGetInfo'
            }
        },
        currentProtocol: 'https',
        serviceActive: false,
        deviceConnected: false,
        quality: 50,
        timeout: 20000,
        lastError: null
    };

    // Enhanced consultation configuration
window.consultationConfig = {
    baseURL: base_url, // Use your existing base_url variable
    endpoints: {
        getAllPatients: 'admin/consultation/getAllPatients',
        getPatientDetails: 'admin/consultation/getPatientDetails',
        getStoredTemplate: 'admin/consultation/getStoredFingerprintTemplate',
        saveConsultation: 'admin/consultation/saveWithLabTests',
        getLabTests: 'admin/consultation/getLabTestsForConsultation',
        getIcdDiagnoses: 'admin/consultation/getIcdDiagnoses',
        saveTestResults: 'admin/consultation/saveTestResults',
        getAllDoctors: 'admin/consultation/getAllDoctors',
        getPatientHistory: 'admin/consultation/getPatientCompleteHistory',
        getPatientConsultations: 'admin/consultation/getPatientConsultations',
        getPatientLabTests: 'admin/consultation/getPatientLabTests',
        // FIXED: Correct endpoint for triage history
        getPatientTriageHistory: 'admin/triage/getPatientTriageHistory',
        getPatientVerifications: 'admin/consultation/getPatientVerifications'
    }
};

    // ENHANCED consultation state management
    window.consultationState = {
        verificationPassed: false,
        selectedPatientId: null,
        selectedPatientData: null,
        patientWorkflow: null,
        requiresVerification: false,
        storedTemplate: null,
        liveTemplate: null,
        lastVerificationResult: null,
        verificationHistory: [],
        currentMatchScore: 0,
        verificationQuality: 'Unknown',
        currentConsultationId: null,
        isGCCPatient: false,
        verificationRequired: false,
        patientWorkflowType: 'General',
        secugenActive: false,
        
        // Lab tests state - MADE OPTIONAL
        labTests: {
            available: {},
            selected: [],
            categories: {},
            estimatedCost: 0,
            isRequired: false  // NEW: Lab tests are optional
        },
        
        // Diagnosis state
        selectedDiagnosis: null,
        
        // NEW: Patient review state
        patientReview: {
            consultations: [],
            labTests: [],
            triageHistory: [],
            verifications: [],
            summary: {}
        }
    };
    
    // Initialize all functionality
    setTimeout(function() {
        initializeSecuGenService();
        loadPatients();
        initializeEvents();
        
        showModernMessage('🔬 ENHANCED Consultation system ready!', 'success');
    }, 1500);
}

function generatePrescription() {
    console.log('📋 Generating prescription...');
    
    if (window.selectedPrescriptions.length === 0) {
        showModernMessage('No medications selected for prescription', 'warning');
        return;
    }
    
    // Generate prescription note
    generatePrescriptionNote();
    
    // Show success message
    showModernMessage(`Prescription generated with ${window.selectedPrescriptions.length} medications`, 'success');
}

function addToPrescription() {
    console.log('📋 Adding prescription from modal...');
    
    // Get form values
    const drugId = $('#modalDrugId').val();
    const drugName = $('#modalDrugNameDisplay').text();
    const quantity = parseInt($('#prescriptionQuantity').val());
    const unitPrice = parseFloat($('#modalDrugSaleRate').val()) || 0;
    
    // Validate required fields
    if (!drugId) {
        showModernMessage('Drug ID not found', 'error');
        return;
    }
    
    if (!quantity || quantity <= 0) {
        showModernMessage('Please enter a valid quantity', 'warning');
        $('#prescriptionQuantity').focus();
        return;
    }
    
    // Get dosage instructions
    let dosageInstructions;
    if ($('#dosageInstructions').val() === 'custom') {
        dosageInstructions = $('#customDosage').val();
        if (!dosageInstructions.trim()) {
            showModernMessage('Please enter custom dosage instructions', 'warning');
            $('#customDosage').focus();
            return;
        }
    } else {
        dosageInstructions = $('#dosageInstructions').val();
        if (!dosageInstructions) {
            showModernMessage('Please select dosage instructions', 'warning');
            $('#dosageInstructions').focus();
            return;
        }
    }
    
    // Create prescription object
    const prescription = {
        drug_id: drugId,
        drug_name: drugName,
        category: $('#modalDrugCategory').text(),
        composition: $('#modalDrugComposition').text(),
        unit: $('#modalDrugUnit').text(),
        quantity: quantity,
        unit_price: unitPrice,
        total_cost: quantity * unitPrice,
        dosage_instructions: dosageInstructions,
        duration: $('#prescriptionDuration').val(),
        duration_unit: $('#durationUnit').val(),
        administration_time: $('#administrationTime').val(),
        special_instructions: $('#specialInstructions').val()
    };
    
    console.log('📋 Created prescription object:', prescription);
    
    // Initialize selectedPrescriptions if it doesn't exist
    if (!window.selectedPrescriptions) {
        window.selectedPrescriptions = [];
    }
    
    // Check if drug already exists
    const existingIndex = window.selectedPrescriptions.findIndex(p => p.drug_id === drugId);
    
    if (existingIndex !== -1) {
        if (confirm('This medication is already in the prescription. Do you want to update it?')) {
            window.selectedPrescriptions[existingIndex] = prescription;
            showModernMessage(`Updated prescription for ${drugName}`, 'info');
        } else {
            return;
        }
    } else {
        window.selectedPrescriptions.push(prescription);
        showModernMessage(`Added ${drugName} to prescription`, 'success');
    }
    
    // Update display
    updateSelectedPrescriptionsDisplay();
    
    // Close modal
    $('#drugSelectionModal').modal('hide');
    
    console.log('✅ Prescription added successfully. Total prescriptions:', window.selectedPrescriptions.length);
}

function saveEnhancedConsultationWithPrescriptions() {
    const submitBtn = $('#consultationForm').find('button[type="submit"]');
    submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving Consultation...');
    
    const patientId = $('#modalPatientIdHidden').val();
    
    // Check verification requirement
    if (window.consultationState.requiresVerification && !window.consultationState.verificationPassed) {
        showModernMessage('GCC patients must be verified before consultation can be saved', 'error');
        submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Save Consultation');
        return;
    }
    
    // Enhanced form validation
    if (!$('#consultationSymptoms').val().trim()) {
        showModernMessage('Please enter patient symptoms/chief complaint', 'warning');
        $('#consultationSymptoms').focus();
        submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Save Consultation');
        return;
    }
    
    if (!$('#consultationDoctor').val()) {
        showModernMessage('Please select a doctor', 'warning');
        $('#consultationDoctor').focus();
        submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Save Consultation');
        return;
    }
    
    // Prepare form data
    let formData = $('#consultationForm').serialize();
    
    // Add diagnosis information (only for non-GCC patients)
    if (!window.consultationState.isGCCPatient) {
        if (window.consultationState.selectedDiagnosis) {
            formData += `&diagnosis_code=${window.consultationState.selectedDiagnosis.code}`;
            formData += `&diagnosis_title=${encodeURIComponent(window.consultationState.selectedDiagnosis.title)}`;
            formData += `&diagnosis_type=icd10`;
        } else if ($('#consultationDiagnosisCustom').val().trim()) {
            formData += `&diagnosis_custom=${encodeURIComponent($('#consultationDiagnosisCustom').val())}`;
            formData += `&diagnosis_type=custom`;
        }
    } else {
        formData += `&diagnosis_type=gcc_workflow`;
        formData += `&diagnosis_custom=GCC Patient - No ICD diagnosis required`;
    }
    
    // Add lab tests data (OPTIONAL)
    const selectedTests = window.consultationState.labTests.selected || [];
    formData += `&selected_tests=${encodeURIComponent(JSON.stringify(selectedTests))}`;
    
    // Add prescription data (NEW)
    formData += `&selected_prescriptions=${encodeURIComponent(JSON.stringify(window.selectedPrescriptions))}`;
    formData += `&total_prescriptions=${window.selectedPrescriptions.length}`;
    
    // Add verification details
    formData += `&verification_score=${window.consultationState.currentMatchScore}`;
    formData += `&verification_quality=${window.consultationState.verificationQuality}`;
    formData += `&verification_method=${window.consultationState.verificationPassed ? 'fingerprint' : 'workflow_exempted'}`;
    
    console.log('📤 Sending consultation data with prescriptions:', formData);
    
    // Call the enhanced save method with prescription support
    $.ajax({
        url: window.consultationConfig.baseURL + 'admin/consultation/saveWithPrescription',
        type: 'POST',
        data: formData,
        dataType: 'json',
        timeout: 30000,
        success: function(response) {
            console.log('💾 Save response:', response);
            
            if (response.status === 'success') {
                const workflowType = window.consultationState.patientWorkflowType || 'GENERAL';
                const testsMessage = selectedTests.length > 0 ? ` with ${selectedTests.length} lab tests` : '';
                const prescriptionMessage = window.selectedPrescriptions.length > 0 ? ` and ${window.selectedPrescriptions.length} prescribed medicines` : '';
                
                showModernMessage(`✓ ${workflowType} consultation saved successfully${testsMessage}${prescriptionMessage}!`, 'success');
                
                $('#consultationModal').modal('hide');
                updateStepIndicator('save');
                
                // Reset form
                resetConsultationFormWithPrescriptions();
                
                // Update consultation count
                if (typeof loadPatientConsultations === 'function') {
                    loadPatientConsultations(patientId);
                }
                
            } else {
                showModernMessage(response.message || 'Failed to save consultation', 'error');
            }
        },
        error: function(xhr, status, error) {
            console.error('❌ Save consultation error:', xhr.responseText);
            
            let errorMessage = 'Failed to save consultation';
            if (xhr.responseText) {
                try {
                    const errorResponse = JSON.parse(xhr.responseText);
                    errorMessage = errorResponse.message || errorMessage;
                } catch (e) {
                    errorMessage += ': ' + error;
                }
            }
            
            showModernMessage(errorMessage, 'error');
        },
        complete: function() {
            submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Save Consultation');
        }
    });
}

/**
 * Reset consultation form including prescriptions
 */
function resetConsultationFormWithPrescriptions() {
    $('#consultationForm')[0].reset();
    $('#selectedDiagnosisInfo').hide();
    $('#customDiagnosisGroup').hide();
    $('#consultationDiagnosis').val('').trigger('change');
    window.consultationState.selectedDiagnosis = null;
    
    // Reset lab tests selection
    $('.lab-test-checkbox').prop('checked', false);
    updateSelectedTestsSummary();
    window.consultationState.labTests.selected = [];
    window.consultationState.labTests.estimatedCost = 0;
    
    // Reset prescriptions (NEW)
    window.selectedPrescriptions = [];
    updateSelectedPrescriptionsDisplay();
    clearAllPrescriptions();
}

/**
 * Add selected drug to prescriptions list
 */
function addDrugToPrescriptionList(prescription) {
    console.log('📝 Adding drug to prescription list:', prescription);
    
    // Initialize if not exists
    if (!window.selectedPrescriptions) {
        window.selectedPrescriptions = [];
    }
    
    // Check if drug already exists
    const existingIndex = window.selectedPrescriptions.findIndex(p => p.drug_id === prescription.drug_id);
    
    if (existingIndex !== -1) {
        // Update existing prescription
        if (confirm('This medication is already in the prescription. Do you want to update it?')) {
            window.selectedPrescriptions[existingIndex] = prescription;
            showModernMessage(`Updated prescription for ${prescription.drug_name}`, 'info');
        } else {
            return;
        }
    } else {
        // Add new prescription
        window.selectedPrescriptions.push(prescription);
        showModernMessage(`Added ${prescription.drug_name} to prescription`, 'success');
    }
    
    // Update the display
    updateSelectedPrescriptionsDisplay();
    
    // Update form hidden input
    updatePrescriptionFormData();
}

function updatePrescriptionFormData() {
    const prescriptions = window.selectedPrescriptions || [];
    
    // Update hidden form fields
    $('#selectedPrescriptionsData, #selectedPrescriptionsInput').val(JSON.stringify(prescriptions));
    $('#totalPrescriptions').val(prescriptions.length);
    
    const totalCost = prescriptions.reduce((sum, p) => sum + parseFloat(p.total_cost || 0), 0);
    $('#totalPrescriptionCost').val(totalCost.toFixed(2));
    
    console.log('📋 Updated prescription form data:', {
        count: prescriptions.length,
        totalCost: totalCost,
        data: prescriptions
    });
}

/**
 * Save prescription draft
 */
function savePrescriptionDraft() {
    const prescriptions = window.selectedPrescriptions || [];
    
    if (prescriptions.length === 0) {
        showModernMessage('No prescriptions to save as draft', 'warning');
        return;
    }
    
    // Save to localStorage as draft
    try {
        const draftData = {
            prescriptions: prescriptions,
            timestamp: new Date().toISOString(),
            patient_id: window.consultationState.selectedPatientId
        };
        
        localStorage.setItem('prescription_draft', JSON.stringify(draftData));
        showModernMessage('Prescription saved as draft', 'success');
    } catch (error) {
        console.error('Error saving draft:', error);
        showModernMessage('Error saving draft', 'error');
    }
}

/**
 * Load prescription draft
 */
function loadPrescriptionDraft() {
    try {
        const draftData = localStorage.getItem('prescription_draft');
        if (draftData) {
            const draft = JSON.parse(draftData);
            if (draft.prescriptions && draft.prescriptions.length > 0) {
                window.selectedPrescriptions = draft.prescriptions;
                updateSelectedPrescriptionsDisplay();
                updatePrescriptionFormData();
                showModernMessage(`Loaded draft with ${draft.prescriptions.length} medications`, 'success');
                return true;
            }
        }
    } catch (error) {
        console.error('Error loading draft:', error);
    }
    return false;
}

// Override the existing saveEnhancedConsultation function
const originalSaveEnhancedConsultation = window.saveEnhancedConsultation;
window.saveEnhancedConsultation = function() {
    console.log('💾 Saving consultation with prescriptions...');
    
    // Update prescription form data before saving
    updatePrescriptionFormData();
    
    // Add prescription data to form
    const prescriptions = window.selectedPrescriptions || [];
    
    // Create prescription summary for the main form
    let prescriptionSummary = '';
    if (prescriptions.length > 0) {
        prescriptionSummary = '\n\nPRESCRIPTION:\n';
        prescriptions.forEach((p, i) => {
            prescriptionSummary += `${i + 1}. ${p.drug_name} - ${p.dosage_instructions} for ${p.duration} ${p.duration_unit}\n`;
        });
    }
    
    // Append to consultation notes if prescriptions exist
    if (prescriptions.length > 0) {
        const currentNotes = $('#consultationNotes').val();
        if (!currentNotes.includes('PRESCRIPTION:')) {
            $('#consultationNotes').val(currentNotes + prescriptionSummary);
        }
    }
    
    console.log('📋 Including', prescriptions.length, 'prescriptions in consultation');
    
    // Call original function
    if (originalSaveEnhancedConsultation) {
        originalSaveEnhancedConsultation();
    } else {
        // Fallback to the function defined in your main code
        saveEnhancedConsultationWithPrescriptions();
    }
};

/**
 * Update selected prescriptions display
 */
function updateSelectedPrescriptionsDisplay() {
    console.log('🔄 Updating prescription display...');
    
    const prescriptions = window.selectedPrescriptions || [];
    const count = prescriptions.length;
    
    // Calculate total cost
    let totalCost = prescriptions.reduce((sum, item) => {
        return sum + parseFloat(item.total_cost || 0);
    }, 0);
    
    console.log('Display data:', { count, totalCost, prescriptions });
    
    // Update count displays - multiple selectors for compatibility
    $('#selectedCount, #totalMedicationsCount, #prescribedMedicationsCount').text(count);
    
    // Update cost displays
    $('#estimatedPrescriptionCost, #totalPrescriptionCost').text(totalCost.toFixed(2));
    
    // Build prescription list HTML
    let prescriptionHtml = '';
    if (count > 0) {
        prescriptionHtml = '<div class="prescription-items-list">';
        prescriptions.forEach((prescription, index) => {
            prescriptionHtml += `
                <div class="prescription-item-display" style="border: 1px solid #ddd; margin: 8px 0; padding: 12px; border-radius: 6px; background: #f9f9f9;">
                    <div class="row">
                        <div class="col-md-6">
                            <strong style="color: #2c3e50;">${prescription.drug_name}</strong>
                            <br><small class="text-muted">${prescription.composition || ''}</small>
                        </div>
                        <div class="col-md-3">
                            <strong>Qty:</strong> ${prescription.quantity} ${prescription.unit || 'units'}<br>
                            <strong>Dosage:</strong> ${prescription.dosage_instructions || 'As directed'}<br>
                            <strong>Duration:</strong> ${prescription.duration || 'N/A'} ${prescription.duration_unit || ''}
                        </div>
                        <div class="col-md-2">
                            <strong>Unit:</strong> KES ${parseFloat(prescription.unit_price || 0).toFixed(2)}<br>
                            <strong>Total:</strong> <span style="color: #28a745; font-weight: 600;">KES ${parseFloat(prescription.total_cost || 0).toFixed(2)}</span>
                        </div>
                        <div class="col-md-1">
                            <button type="button" class="btn btn-xs btn-danger" onclick="removePrescriptionItem(${index})" title="Remove">
                                <i class="fa fa-trash"></i>
                            </button>
                        </div>
                    </div>
                    ${prescription.administration_time ? 
                        `<div style="margin-top: 8px;"><small><strong>Timing:</strong> ${prescription.administration_time}</small></div>` 
                        : ''}
                    ${prescription.special_instructions ? 
                        `<div style="margin-top: 4px;"><small><strong>Instructions:</strong> ${prescription.special_instructions}</small></div>` 
                        : ''}
                </div>
            `;
        });
        prescriptionHtml += '</div>';
    } else {
        prescriptionHtml = '<div class="no-prescriptions" style="text-align: center; color: #999; padding: 20px;">No medications prescribed yet</div>';
    }
    
    // Update all possible prescription list containers
    const listContainers = [
        '#selectedMedicines',
        '#selectedPrescriptionsList', 
        '.prescribed-medications-list',
        '.prescription-items'
    ];
    
    listContainers.forEach(selector => {
        const container = $(selector);
        if (container.length > 0) {
            container.html(prescriptionHtml);
            console.log('Updated prescription list in:', selector);
        }
    });
    
    // Update hidden form field for form submission
    $('#selectedPrescriptionsData, #selectedPrescriptionsInput').val(JSON.stringify(prescriptions));
}

/**
 * Create HTML for prescription item
 */
function createPrescriptionItemHTML(prescription, index) {
    return `
        <div class="prescription-item-display" style="border: 1px solid #ddd; margin: 5px 0; padding: 12px; border-radius: 6px; background: #f9f9f9;">
            <div class="row">
                <div class="col-md-6">
                    <strong style="color: #2c3e50;">${prescription.drug_name}</strong>
                    <br><small class="text-muted">${prescription.category || 'Medicine'}</small>
                    <br><small style="color: #6c757d;">${prescription.composition || ''}</small>
                </div>
                <div class="col-md-3">
                    <strong>Qty:</strong> ${prescription.quantity} ${prescription.unit || 'units'}<br>
                    <strong>Dosage:</strong> ${prescription.dosage_instructions || 'As directed'}<br>
                    <strong>Duration:</strong> ${prescription.duration || 'N/A'} ${prescription.duration_unit || ''}
                </div>
                <div class="col-md-2">
                    <strong>Unit:</strong> KES ${parseFloat(prescription.unit_price || 0).toFixed(2)}<br>
                    <strong>Total:</strong> <span style="color: #28a745; font-weight: 600;">KES ${parseFloat(prescription.total_cost || 0).toFixed(2)}</span>
                </div>
                <div class="col-md-1">
                    <button type="button" class="btn btn-xs btn-warning" onclick="editPrescription(${index})" title="Edit" style="margin-bottom: 3px;">
                        <i class="fa fa-edit"></i>
                    </button>
                    <button type="button" class="btn btn-xs btn-danger" onclick="removePrescription(${index})" title="Remove">
                        <i class="fa fa-trash"></i>
                    </button>
                </div>
            </div>
            ${prescription.administration_time ? 
                `<div style="margin-top: 8px;"><small><strong>Timing:</strong> ${prescription.administration_time}</small></div>` 
                : ''}
            ${prescription.special_instructions ? 
                `<div style="margin-top: 4px;"><small><strong>Instructions:</strong> ${prescription.special_instructions}</small></div>` 
                : ''}
        </div>
    `;
}
/**
 * Remove prescription item
 */
function removePrescriptionItem(index) {
    if (index >= 0 && index < window.selectedPrescriptions.length) {
        const removedItem = window.selectedPrescriptions.splice(index, 1)[0];
        updateSelectedPrescriptionsDisplay();
        showModernMessage(`${removedItem.drug_name} removed from prescription`, 'info');
    }
}

/**
 * Edit prescription item
 */
function editPrescriptionItem(index) {
    if (index >= 0 && index < window.selectedPrescriptions.length) {
        const prescription = window.selectedPrescriptions[index];
        
        // Re-open the drug selection modal with pre-filled data
        openPrescriptionModal(prescription.drug_id, prescription.drug_name);
        
        // Pre-populate form with existing values
        setTimeout(function() {
            $('#prescriptionQuantity').val(prescription.quantity);
            $('#dosageInstructions').val(prescription.dosage_instructions);
            $('#prescriptionDuration').val(prescription.duration);
            $('#durationUnit').val(prescription.duration_unit);
            $('#administrationTime').val(prescription.administration_time);
            $('#specialInstructions').val(prescription.special_instructions);
            updateCostCalculation();
        }, 500);
    }
}

/**
 * Clear all prescriptions
 */
function clearAllPrescriptions() {
    if (window.selectedPrescriptions.length === 0) {
        showModernMessage('No prescriptions to clear', 'info');
        return;
    }
    
    if (confirm('Are you sure you want to clear all prescribed medications?')) {
        window.selectedPrescriptions = [];
        updateSelectedPrescriptionsDisplay();
        showModernMessage('All prescriptions cleared', 'info');
    }
}



// =============================================
// SECUGEN INTEGRATION
// =============================================

function initializeSecuGenService() {
    logDiagnostic('Initializing SecuGen WebAPI service...', 'info');
    
    $('#secugen_service_status').html('<div class="status-info"><i class="fa fa-spinner fa-spin"></i> Initializing SecuGen service detection...</div>');
    
    setTimeout(function() {
        logDiagnostic("Starting SecuGen service detection...");
        testHttpsConnection();
        setTimeout(function() {
            if (!window.consultationState.secugenActive) {
                testHttpConnection();
            }
        }, 3000);
    }, 1000);
}

function testHttpsConnection() {
    logDiagnostic("Testing HTTPS connection to localhost:8443...");
    
    const xhr = new XMLHttpRequest();
    xhr.open('GET', 'https://localhost:8443/SGIFPGetInfo', true);
    xhr.timeout = 5000;
    
    xhr.onreadystatechange = function() {
        if (xhr.readyState === 4) {
            if (xhr.status === 200) {
                logDiagnostic("✓ HTTPS connection successful!", 'success');
                window.consultationState.secugenActive = true;
                $('#manualVerifyBtn').prop('disabled', false);
                $('#secugen_service_status').html('<div class="status-success"><i class="fa fa-check"></i> SecuGen HTTPS service active</div>');
            } else if (xhr.status === 0) {
                logDiagnostic("✗ HTTPS blocked - possibly CORS or SSL certificate issue", 'error');
                suggestHttpsFix();
            } else {
                logDiagnostic(`✗ HTTPS failed with status: ${xhr.status}`, 'error');
            }
        }
    };
    
    xhr.onerror = function() {
        logDiagnostic("✗ HTTPS connection error - network or SSL issue", 'error');
        suggestHttpsFix();
    };
    
    xhr.ontimeout = function() {
        logDiagnostic("✗ HTTPS connection timeout", 'error');
    };
    
    xhr.send();
}

function testHttpConnection() {
    logDiagnostic("Testing HTTP connection to localhost:8443...");
    
    $.ajax({
        url: 'http://localhost:8443/SGIFPGetInfo',
        type: 'GET',
        timeout: 5000,
        success: function(data) {
            logDiagnostic("✓ HTTP connection successful!", 'success');
            window.consultationState.secugenActive = true;
            $('#manualVerifyBtn').prop('disabled', false);
            $('#secugen_service_status').html('<div class="status-success"><i class="fa fa-check"></i> SecuGen HTTP service active</div>');
        },
        error: function(xhr) {
            if (xhr.status === 0) {
                logDiagnostic("✗ HTTP blocked - possibly CORS issue", 'error');
            } else {
                logDiagnostic(`✗ HTTP failed with status: ${xhr.status}`, 'error');
            }
        }
    });
}

function suggestHttpsFix() {
    const suggestions = `
        <div class="status-warning" style="font-size: 11px; margin-top: 10px;">
            <strong>HTTPS Connection Issues - Try these fixes:</strong><br>
            1. <strong>Accept SSL Certificate:</strong> Visit <a href="https://localhost:8443/SGIFPGetInfo" target="_blank">https://localhost:8443/SGIFPGetInfo</a> and accept the security warning<br>
            2. <strong>Run browser as Administrator</strong><br>
            3. <strong>Check Windows Firewall</strong> - ensure port 8443 is allowed<br>
            4. <strong>Try the Manual Capture button</strong> below
        </div>
    `;
    $('#secugen_service_status').html(suggestions);
}

// =============================================
// PATIENT LOADING AND MANAGEMENT
// =============================================

function loadPatients() {
    console.log('🔄 Loading patients with enhanced UI feedback...');
    
    $('#consultation_patient_search').html('<option value="">Loading patients...</option>');
    showModernMessage('Loading patient database...', 'info', 2000);
    
    const endpoint = window.consultationConfig.baseURL + window.consultationConfig.endpoints.getAllPatients;
    
    console.log('🌐 Enhanced endpoint call:', endpoint);
    
    $.ajax({
        url: endpoint,
        type: 'GET',
        dataType: 'json',
        timeout: 15000,
        success: function(response) {
            console.log('📥 Enhanced response received:', response);
            handleEnhancedPatientLoadSuccess(response);
        },
        error: function(xhr, status, error) {
            console.error('❌ Enhanced AJAX Error:', status, error);
            handleEnhancedPatientLoadError(xhr, status, error);
        }
    });
}

function handleEnhancedPatientLoadSuccess(response) {
    console.log('✅ Processing enhanced patient response...');
    
    try {
        let patients = [];
        
        if (response && typeof response === 'object') {
            if (response.status === 'error') {
                showModernMessage('Server Error: ' + response.message, 'error');
                return;
            }
            
            if (response.status === 'success' && response.patients && Array.isArray(response.patients)) {
                patients = response.patients;
            } else if (response.patients && Array.isArray(response.patients)) {
                patients = response.patients;
            } else if (Array.isArray(response)) {
                patients = response;
            } else {
                showModernMessage('Unexpected response format from server', 'warning');
                return;
            }
        } else {
            showModernMessage('Invalid response format', 'error');
            return;
        }
        
        if (patients.length > 0) {
            populateEnhancedPatientDropdown(patients);
            
            let message = `✅ Successfully loaded ${patients.length} patients`;
            if (response.workflow_stats) {
                const stats = response.workflow_stats;
                message += ` (GCC: ${stats.gcc || 0}, General: ${stats.general || 0})`;
            }
            
            showModernMessage(message, 'success');
        } else {
            showModernMessage('No patients found in database', 'warning');
        }
        
    } catch (error) {
        console.error('❌ Error processing enhanced response:', error);
        showModernMessage('Failed to process response: ' + error.message, 'error');
    }
}

function populateEnhancedPatientDropdown(patients) {
    console.log('👥 Populating enhanced patient dropdown with', patients.length, 'patients');
    
    const select = $('#consultation_patient_search');
    select.empty();
    select.append(`<option value="">Select Patient for Consultation (${patients.length} total)</option>`);
    
    let processedCount = 0;
    let gccCount = 0;
    let generalCount = 0;
    
    $.each(patients, function(index, patient) {
        try {
            let patientName = patient.patient_name || `Patient #${patient.id}`;
            let text = `${patientName} (ID: ${patient.id})`;
            
            if (patient.mobileno) {
                text += ` - ${patient.mobileno}`;
            }
            
            if (patient.age && patient.age !== 'Unknown') {
                text += ` - ${patient.age}y`;
            }
            
            if (patient.gender) {
                text += ` - ${patient.gender}`;
            }
            
            let workflow = patient.patient_workflow || 
                          patient.workflow || 
                          patient.patient_type || 
                          patient.type ||
                          'general';
            
            let isGCCPatient = workflow.toLowerCase() === 'gcc';
            let requiresVerification = isGCCPatient;
            let hasFingerprint = patient.has_fingerprint == 1;
            
            if (isGCCPatient) {
                text += ' [GCC - Verification Required]';
                gccCount++;
            } else {
                text += ' [General]';
                generalCount++;
            }
            
            if (hasFingerprint) {
                text += ' 🔐';
            }
            
            const option = $('<option>', {
                value: patient.id,
                text: text,
                'data-workflow': workflow.toLowerCase(),
                'data-has-fingerprint': hasFingerprint ? 1 : 0,
                'data-requires-verification': requiresVerification ? 1 : 0,
                'data-phone': patient.mobileno || '',
                'data-age': patient.age || '',
                'data-gender': patient.gender || '',
                'data-stored-template': patient.fingerprint_template || ''
            });
            
            select.append(option);
            processedCount++;
            
        } catch (error) {
            console.error('❌ Error processing enhanced patient', patient.id, ':', error);
        }
    });
    
    console.log(`✅ Enhanced processing completed ${processedCount}/${patients.length} patients`);
    console.log(`📊 Workflow distribution: GCC: ${gccCount}, General: ${generalCount}`);
    
    // Initialize enhanced Select2
    if (typeof $.fn.select2 !== 'undefined') {
        select.select2({
            placeholder: 'Search patients for enhanced consultation...',
            allowClear: true,
            width: '100%'
        });
    }
}

function handleEnhancedPatientLoadError(xhr, status, error) {
    console.error('❌ Handling enhanced patient load error...');
    
    $('#consultation_patient_search').html('<option value="">Error loading patients</option>');
    
    let errorMessage = 'Failed to load patients for enhanced consultation';
    
    if (xhr.status === 404) {
        errorMessage = 'Patient loading endpoint not found (404)';
    } else if (xhr.status === 500) {
        errorMessage = 'Server error loading patients (500)';
    } else if (xhr.status === 0) {
        errorMessage = 'Network error - cannot connect to server';
    } else if (status === 'timeout') {
        errorMessage = 'Request timeout - server response too slow';
    } else if (status === 'parsererror') {
        errorMessage = 'Invalid response format from server';
    }
    
    showModernMessage(errorMessage, 'error');
}

// =============================================
// ENHANCED PATIENT DETAILS WITH PROPER WORKFLOW SUPPORT
// =============================================

function loadEnhancedPatientDetails(patientId) {
    if (!patientId) {
        $('#patientDetailsSection').hide();
        resetEnhancedVerificationState();
        return;
    }
    
    console.log('🔍 ENHANCED: Loading patient details for ID:', patientId);
    
    window.consultationState.selectedPatientId = patientId;
    $('#selectedPatientId').val(patientId);
    $('#patientDetailsSection').show().addClass('fade-in');
    
    // Get workflow information from option
    const selectedOption = $('#consultation_patient_search').find(':selected');
    const patientWorkflow = selectedOption.data('workflow') || 'general';
    const hasFingerprint = selectedOption.data('has-fingerprint') == 1;
    
    // Determine verification requirement based on workflow
    const isGCCPatient = patientWorkflow.toLowerCase() === 'gcc';
    const requiresVerification = isGCCPatient;
    
    console.log('🔧 ENHANCED Workflow Detection:');
    console.log('  - Workflow:', patientWorkflow);
    console.log('  - Is GCC Patient:', isGCCPatient);
    console.log('  - Has Fingerprint:', hasFingerprint);
    console.log('  - Requires Verification:', requiresVerification);
    
    // Store workflow information
    window.consultationState.patientWorkflow = patientWorkflow;
    window.consultationState.requiresVerification = requiresVerification;
    window.consultationState.verificationRequired = requiresVerification;
    window.consultationState.isGCCPatient = isGCCPatient;
    window.consultationState.patientWorkflowType = isGCCPatient ? 'GCC Workflow' : 'General Workflow';
    
    window.consultationState.selectedPatientData = {
        id: patientId,
        workflow: patientWorkflow,
        has_fingerprint: hasFingerprint,
        requires_verification: requiresVerification,
        stored_template: ''
    };
    
    resetEnhancedVerificationState();
    
    // Proper workflow handling
    if (requiresVerification) {
        console.log('🔒 ENHANCED: GCC PATIENT - VERIFICATION REQUIRED');
        setupGCCPatientWorkflow();
    } else {
        console.log('🔓 ENHANCED: GENERAL PATIENT - VERIFICATION OPTIONAL');
        setupGeneralPatientWorkflow();
    }
    
    updateStepIndicator('verify');
    
    // Load patient details via AJAX
    loadPatientDetailsFromServer(patientId, selectedOption);
}

// Separate workflow setup functions
function setupGCCPatientWorkflow() {
    console.log('🔒 Setting up GCC patient workflow - VERIFICATION MANDATORY');
    
    // Show verification section
    $('#biometricVerificationSection').show().addClass('gcc-required');
    
    // Update UI to reflect GCC status
    $('#workflowStatusPanel').removeClass('gcc-workflow').addClass('gcc-unverified');
    $('#workflowBadge').text('GCC Patient - Verification Required').removeClass().addClass('workflow-badge status-required');
    
    $('#currentPatientStatus').html(`
        <p style="margin: 0; font-size: 12px; color: white;">
            <i class="fa fa-shield"></i> <strong>GCC Patient Protocol Active</strong><br>
            Biometric verification is MANDATORY before consultation
        </p>
    `);
    
    // Patient card styling
    $('#patientDetailsCard').removeClass('verified gcc-patient').addClass('gcc-unverified');
    
    // Status message
    $('#fingerprintStatus').html(`
        <div class="status-warning">
            <i class="fa fa-shield"></i> <strong>GCC Patient - Biometric verification required</strong><br>
            <small>This patient requires mandatory fingerprint verification before consultation</small>
        </div>
    `);
    
    // Disable consultation button until verified
    $('#startConsultationBtn').prop('disabled', true);
    $('#reviewPatientBtn').prop('disabled', false); // Review is always available
    $('#verificationMessage').html(`
        <div class="alert-warning-modern">
            <i class="fa fa-exclamation-triangle"></i> <strong>Verification Required:</strong> Complete biometric verification to enable consultation
        </div>
    `);
    
    console.log('✅ GCC workflow setup complete - consultation button disabled, review enabled');
}

function setupGeneralPatientWorkflow() {
    console.log('🔓 Setting up General patient workflow - VERIFICATION OPTIONAL');
    
    // Hide verification section for general patients
    $('#biometricVerificationSection').hide();
    
    // Update UI to reflect general status
    $('#workflowStatusPanel').removeClass('gcc-unverified gcc-workflow');
    $('#workflowBadge').text('General Patient').removeClass().addClass('workflow-badge status-general');
    $('#currentPatientStatus').html(`
       <p style="margin: 0; font-size: 12px; color: white;">
           <i class="fa fa-user"></i> <strong>General Patient Workflow</strong><br>
           Biometric verification is optional for this patient type
       </p>
   `);
   
   // Patient card styling
   $('#patientDetailsCard').removeClass('gcc-unverified gcc-patient verified');
   
   // Enable consultation directly
   enableEnhancedConsultationDirectly();
   
   console.log('✅ General workflow setup complete - consultation button enabled');
}

function loadPatientDetailsFromServer(patientId, selectedOption) {
   $.ajax({
       url: window.consultationConfig.baseURL + window.consultationConfig.endpoints.getPatientDetails,
       type: 'POST',
       data: { id: patientId },
       dataType: 'json',
       success: function(response) {
           console.log('Patient details response:', response);
           
           if (response && response.patient_name) {
               populatePatientDetails(response);
               loadStoredFingerprintTemplate(patientId, response.has_fingerprint);
               loadPatientConsultationsHistory(patientId); // ✅ Use this instead
           } else {
               // Fallback to option data
               populatePatientDetailsFromOption(selectedOption);
               if (selectedOption.data('has-fingerprint')) {
                   loadStoredFingerprintTemplate(patientId, true);
               }
               loadPatientConsultationsHistory(patientId); // ✅ Use this instead
           }
       },
       error: function(xhr, status, error) {
           console.error('Error loading patient details:', error);
           populatePatientDetailsFromOption(selectedOption);
           if (selectedOption.data('has-fingerprint')) {
               loadStoredFingerprintTemplate(patientId, true);
           }
           loadPatientConsultationsHistory(patientId); // ✅ Use this instead
       }
   });
}

function populatePatientDetails(patient) {
    $('#patientName').text(patient.patient_name || 'Unknown');
    $('#patientAge').text((patient.age || 'Unknown') + ' years');
    $('#patientGender').text(patient.gender || 'Unknown');
    $('#patientPhone').text(patient.mobileno || 'N/A');
    $('#patientBloodGroup').text(patient.blood_group_name || 'Unknown');
    $('#patientAllergies').text(patient.known_allergies || 'None');
    
    // Enhanced image setting
    if (patient.image) {
        let imagePath = patient.image;
        if (!imagePath.startsWith('../') && !imagePath.startsWith('http')) {
            imagePath = '../' + imagePath;
        }
        $('#patientPhoto').attr('src', imagePath);
    } else {
        $('#patientPhoto').attr('src', '../uploads/patient_images/no_image.png');
    }
    
    // Generate patient barcode
    generatePatientBarcode(patient);
}

function populatePatientDetailsFromOption(selectedOption) {
   const patientName = selectedOption.text().split(' (')[0];
   $('#patientName').text(patientName);
   $('#patientAge').text(selectedOption.data('age') || 'Unknown');
   $('#patientGender').text(selectedOption.data('gender') || 'Unknown');
   $('#patientPhone').text(selectedOption.data('phone') || 'N/A');
   $('#patientBloodGroup').text('Unknown');
   $('#patientAllergies').text('None');
}

// Only enable consultation for general patients
function enableEnhancedConsultationDirectly() {
   console.log('🔓 ENHANCED: Enabling consultation directly (no verification required)');
   
   // Only enable if this is actually a general patient
   if (!window.consultationState.requiresVerification) {
       window.consultationState.verificationPassed = true;
       $('#verificationPassed').val('1');
       $('#startConsultationBtn').prop('disabled', false);
       $('#reviewPatientBtn').prop('disabled', false);
       
       $('#verificationStatus').html('<span class="status-indicator status-general"><i class="fa fa-check-circle"></i> General Patient</span>');
       
       $('#verificationMessage').html(`
           <div class="alert-success-modern">
               <i class="fa fa-check-circle"></i> General patient - consultation enabled without verification requirement
           </div>
       `);
       
       updateStepIndicator('consult');
       console.log('✅ ENHANCED: Consultation enabled for general patient');
   } else {
       console.log('🔒 ENHANCED: Cannot enable consultation - this is a GCC patient requiring verification');
   }
}

// =============================================
// NEW: PATIENT REVIEW FUNCTIONALITY
// =============================================

function reviewPatientHistory() {
    const patientId = window.consultationState.selectedPatientId;
    if (!patientId) {
        showModernMessage('Please select a patient first', 'warning');
        return;
    }
    
    console.log('📋 Opening patient review for ID:', patientId);
    
    // Populate review modal header
    $('#reviewPatientName').text($('#patientName').text());
    $('#reviewPatientId').text(patientId);
    $('#reviewPatientAge').text($('#patientAge').text());
    $('#reviewPatientGender').text($('#patientGender').text());
    
    // Set workflow badge
    if (window.consultationState.isGCCPatient) {
        $('#reviewWorkflowBadge').html('<span class="status-indicator status-gcc"><i class="fa fa-shield"></i> GCC Patient</span>');
    } else {
        $('#reviewWorkflowBadge').html('<span class="status-indicator status-general"><i class="fa fa-user"></i> General Patient</span>');
    }
    
    // Load all patient data
    loadPatientCompleteHistory(patientId);
    
    // Show the review modal
    $('#patientReviewModal').modal('show');
}

// Add this right before your AJAX call
console.log('displayConsultationsHistory function exists:', typeof displayConsultationsHistory === 'function');
console.log('displayConsultationsHistory function:', displayConsultationsHistory);

function loadPatientCompleteHistory(patientId) {
    console.log('📊 Loading complete patient history for ID:', patientId);
    
    // Load consultations
    loadPatientConsultationsHistory(patientId);
    
    // Load lab tests
    loadPatientLabTestsHistory(patientId);
    
    // Load triage history
    loadPatientTriageHistory(patientId);
    
    // Load verification history
    loadPatientVerificationHistory(patientId);
    
    // Load summary statistics
    loadPatientSummaryStatistics(patientId);
}

function loadPatientConsultationsHistory(patientId) {
    $('#reviewConsultationsList').html('<div class="text-center"><div class="spinner-modern"></div> Loading consultation history...</div>');
    
    $.ajax({
        url: window.consultationConfig.baseURL + window.consultationConfig.endpoints.getPatientConsultations,
        type: 'POST',
        data: { patient_id: patientId },
        dataType: 'json',
        success: function(response) {
            console.log('Consultations response:', response);
            console.log('Response status:', response.status);
            console.log('Consultations array:', response.consultations);
            console.log('Consultations length:', response.consultations ? response.consultations.length : 'undefined');
            
            if (response && response.status === 'success' && response.consultations) {
                if (response.consultations.length > 0) {
                    console.log('=== ABOUT TO CALL displayConsultationsHistory ===');
                    console.log('Function exists:', typeof displayConsultationsHistory === 'function');
                    
                    // Try calling the function
                    try {
                        displayConsultationsHistory(response.consultations);
                        console.log('=== displayConsultationsHistory called successfully ===');
                    } catch (error) {
                        console.error('Error calling displayConsultationsHistory:', error);
                        console.error('Error stack:', error.stack);
                    }
                    
                    window.consultationState.patientReview.consultations = response.consultations;
                } else {
                    $('#reviewConsultationsList').html('<div class="review-item">No consultations found for this patient</div>');
                }
            } else {
                $('#reviewConsultationsList').html('<div class="review-item">No consultation history found</div>');
            }
        },
        error: function(xhr, status, error) {
            console.error('Error loading consultations:', error);
            console.error('XHR response:', xhr.responseText);
            $('#reviewConsultationsList').html('<div class="review-item text-danger">Error loading consultation history</div>');
        }
    });
}

function displayConsultationsHistory(consultations) {
    console.log('=== ROBUST DISPLAY METHOD ===');
    
    // Update both the main page and modal if they exist
    const mainPageElement = document.getElementById('reviewConsultationsList');
    const modalElement = document.getElementById('modalConsultationsList');
    
    if (!consultations || consultations.length === 0) {
        if (mainPageElement) {
            mainPageElement.innerHTML = '<div class="review-item">No consultations to display</div>';
        }
        if (modalElement) {
            modalElement.innerHTML = '<div class="review-item">No consultations to display</div>';
        }
        return;
    }
    
    // Generate HTML for consultations
    let html = '';
    consultations.forEach(function(consultation, index) {
        html += `
            <div class="review-item" style="border: 1px solid #ddd; margin: 10px 0; padding: 10px; background: #f9f9f9; border-radius: 4px;">
                <div style="margin-bottom: 8px;">
                    <strong>Date:</strong> ${consultation.consultation_date || consultation.date || 'Unknown date'}<br>
                    <strong>Doctor:</strong> ${consultation.doctor_name || 'Unknown Doctor'}
                </div>
                ${consultation.symptoms ? `<div><strong>Symptoms:</strong> ${consultation.symptoms}</div>` : ''}
                ${consultation.diagnosis ? `<div><strong>Diagnosis:</strong> ${consultation.diagnosis}</div>` : ''}
                ${consultation.notes ? `<div><strong>Notes:</strong> ${consultation.notes}</div>` : ''}
            </div>
        `;
    });
    
    // Update both elements
    if (mainPageElement) {
        mainPageElement.innerHTML = html;
        console.log('✅ Updated main page consultations');
    }
    
    if (modalElement) {
        modalElement.innerHTML = html;
        console.log('✅ Updated modal consultations');
    }
    
    console.log('✅ Consultations displayed in both locations');
}

function loadPatientLabTestsHistory(patientId) {
    $('#reviewLabTestsList').html('<div class="text-center"><div class="spinner-modern"></div> Loading lab test history...</div>');
    
    $.ajax({
        url: window.consultationConfig.baseURL + window.consultationConfig.endpoints.getPatientLabTests,
        type: 'POST',
        data: { patient_id: patientId },
        dataType: 'json',
        success: function(response) {
            console.log('Lab tests response:', response);
            
            if (response && response.status === 'success' && response.lab_tests) {
                displayLabTestsHistory(response.lab_tests);
                window.consultationState.patientReview.labTests = response.lab_tests;
            } else {
                $('#reviewLabTestsList').html('<div class="review-item">No lab test history found</div>');
            }
        },
        error: function(xhr, status, error) {
            console.error('Error loading lab tests:', error);
            $('#reviewLabTestsList').html('<div class="review-item text-danger">Error loading lab test history</div>');
        }
    });
}

function displayLabTestsHistory(labTests) {
    if (labTests.length === 0) {
        $('#reviewLabTestsList').html('<div class="review-item">No lab tests found</div>');
        return;
    }
    
    let html = '';
    labTests.forEach(test => {
        const testDate = new Date(test.test_date).toLocaleDateString();
        const statusClass = test.result_status === 'normal' ? 'text-success' : 
                          test.result_status === 'critical' ? 'text-danger' : 'text-warning';
        
        html += `
            <div class="review-item">
                <div class="row">
                    <div class="col-md-8">
                        <strong>Test:</strong> ${test.test_name}<br>
                        <strong>Date:</strong> ${testDate}<br>
                        ${test.test_result ? `<strong>Result:</strong> ${test.test_result}<br>` : ''}
                        ${test.reference_range ? `<strong>Reference:</strong> ${test.reference_range}` : ''}
                    </div>
                    <div class="col-md-4 text-right">
                        <span class="label ${statusClass === 'text-success' ? 'label-success' : 
                                          statusClass === 'text-danger' ? 'label-danger' : 'label-warning'}">
                           ${test.result_status || 'Pending'}
                       </span><br>
                       ${test.lab_notes ? `<small>${test.lab_notes}</small>` : ''}
                   </div>
               </div>
           </div>
       `;
   });
   
   $('#reviewLabTestsList').html(html);
}

function loadPatientTriageHistory(patientId) {
    console.log('🏥 Loading triage history for patient:', patientId);
    
    $('#reviewTriageList').html(`
        <div class="text-center" style="padding: 20px;">
            <div class="spinner-modern"></div> 
            <p style="margin-top: 10px;">Loading triage history...</p>
        </div>
    `);
    
    // Debug the endpoint URL
    const endpoint = window.consultationConfig.baseURL + window.consultationConfig.endpoints.getPatientTriageHistory;
    console.log('🌐 Triage endpoint URL:', endpoint);
    
    $.ajax({
        url: endpoint,
        type: 'POST',
        data: { patient_id: patientId },
        dataType: 'json',
        timeout: 15000,
        beforeSend: function(xhr) {
            console.log('📤 Sending triage history request...');
            console.log('📤 Data:', { patient_id: patientId });
        },
        success: function(response) {
            console.log('📥 Triage history response:', response);
            
            // Handle different response formats
            if (response && response.status === 'success') {
                // Check for different possible data structures
                let triageData = response.triage_history || response.records || response.data || [];
                
                if (Array.isArray(triageData) && triageData.length > 0) {
                    displayTriageHistory(triageData);
                    window.consultationState.patientReview.triageHistory = triageData;
                    console.log('✅ Triage history loaded successfully:', triageData.length, 'records');
                } else {
                    showNoTriageHistory();
                }
            } else if (response && response.status === 1) {
                // Alternative success format
                let triageData = response.records || response.data || [];
                if (Array.isArray(triageData) && triageData.length > 0) {
                    displayTriageHistory(triageData);
                    window.consultationState.patientReview.triageHistory = triageData;
                } else {
                    showNoTriageHistory();
                }
            } else {
                console.warn('⚠️ Unexpected response format:', response);
                showTriageHistoryError('Unexpected response format');
            }
        },
        error: function(xhr, status, error) {
            console.error('❌ Triage history AJAX error:', {
                status: xhr.status,
                statusText: xhr.statusText,
                responseText: xhr.responseText,
                error: error,
                endpoint: endpoint
            });
            
            // Try to parse error response
            let errorMessage = 'Failed to load triage history';
            try {
                const errorResponse = JSON.parse(xhr.responseText);
                if (errorResponse && errorResponse.message) {
                    errorMessage = errorResponse.message;
                }
            } catch (parseError) {
                console.log('Could not parse error response');
            }
            
            // Show specific error based on status
            if (xhr.status === 404) {
                showTriageHistoryError('Triage endpoint not found. Please check your routes.');
            } else if (xhr.status === 500) {
                showTriageHistoryError('Server error occurred. Check your backend logs.');
            } else if (xhr.status === 0) {
                showTriageHistoryError('Network error. Please check your connection.');
            } else {
                showTriageHistoryError(errorMessage);
            }
        }
    });
}

function displayTriageHistory(triageHistory) {
    console.log('🎨 Displaying triage history:', triageHistory);
    
    if (!triageHistory || triageHistory.length === 0) {
        showNoTriageHistory();
        return;
    }
    
    let html = '';
    triageHistory.forEach((triage, index) => {
        console.log('Processing triage record:', triage);
        
        // Handle different date field names
        const triageDate = triage.created_at || triage.triage_date || triage.date_created || 'Unknown Date';
        const formattedDate = triageDate !== 'Unknown Date' ? 
            new Date(triageDate).toLocaleDateString('en-US', {
                year: 'numeric',
                month: 'short',
                day: 'numeric',
                hour: '2-digit',
                minute: '2-digit'
            }) : 'Unknown Date';
        
        // Handle different priority formats
        const priority = triage.priority || triage.triage_priority || 'standard';
        const priorityClass = getPriorityClass(priority);
        const priorityIcon = getPriorityIcon(priority);
        
        // Handle different staff name formats
        const staffName = triage.staff_name || triage.triage_by_name || triage.created_by_name || 'Unknown Staff';
        
        // Parse vitals - handle both JSON string and object formats
        let vitals = {};
        if (triage.vitals) {
            if (typeof triage.vitals === 'string') {
                try {
                    vitals = JSON.parse(triage.vitals);
                } catch (e) {
                    console.warn('Could not parse vitals JSON:', triage.vitals);
                }
            } else if (typeof triage.vitals === 'object') {
                vitals = triage.vitals;
            }
        } else if (triage.vitals_parsed) {
            vitals = triage.vitals_parsed;
        }
        
        html += `
            <div class="triage-record-card fade-in" data-triage-id="${triage.id}" style="animation-delay: ${index * 0.1}s">
                <div class="triage-header">
                    <div class="triage-date">
                        <i class="fa fa-calendar"></i> ${formattedDate}
                        <span class="triage-priority ${priorityClass}">
                            ${priorityIcon} ${priority.toUpperCase()}
                        </span>
                    </div>
                    <div class="triage-staff">
                        <small><i class="fa fa-user-md"></i> ${staffName}</small>
                    </div>
                </div>
                
                <div class="triage-vitals">
                    <div class="vital-row">
                        <div class="vital-item">
                            <strong>BP</strong>
                            <span>${vitals.blood_pressure || vitals.bp || triage.blood_pressure || 'N/A'}</span>
                        </div>
                        <div class="vital-item">
                            <strong>Pulse</strong>
                            <span>${vitals.pulse || vitals.heart_rate || triage.pulse || 'N/A'}</span>
                        </div>
                        <div class="vital-item">
                            <strong>Temp</strong>
                            <span>${vitals.temperature || vitals.temp || triage.temperature || 'N/A'}°C</span>
                        </div>
                        <div class="vital-item">
                            <strong>Weight</strong>
                            <span>${vitals.weight || triage.weight || 'N/A'} kg</span>
                        </div>
                    </div>
                </div>
                
                <div class="triage-complaints">
                    <strong><i class="fa fa-stethoscope"></i> Chief Complaint:</strong> 
                    <p>${triage.chief_complaint || triage.complaint || 'Not recorded'}</p>
                </div>
                
                <div class="triage-assessment">
                    <strong><i class="fa fa-notes-medical"></i> Assessment:</strong>
                    <p>${triage.notes || triage.triage_notes || triage.assessment || 'No assessment notes'}</p>
                </div>
                
                <div class="triage-routing">
                    <strong><i class="fa fa-arrow-right"></i> Status:</strong> 
                    <span class="routing-department">${triage.status || 'Pending'}</span>
                    ${triage.routing_reason ? `<small> - ${triage.routing_reason}</small>` : ''}
                </div>
                
                <div class="triage-actions">
                    <button type="button" class="btn btn-sm btn-info" 
                            onclick="viewTriageDetails('${triage.id}')">
                        <i class="fa fa-eye"></i> View Details
                    </button>
                    <button type="button" class="btn btn-sm btn-success" 
                            onclick="useTriageForConsultation('${triage.id}')">
                        <i class="fa fa-arrow-right"></i> Use for Consultation
                    </button>
                </div>
            </div>
        `;
    });
    
    $('#reviewTriageList').html(html);
    
    // Generate consultation recommendations based on latest triage
    if (triageHistory.length > 0) {
        generateConsultationRecommendations(triageHistory);
    }
}

function showNoTriageHistory() {
    $('#reviewTriageList').html(`
        <div class="review-item text-center" style="padding: 40px;">
            <i class="fa fa-stethoscope fa-3x text-muted" style="opacity: 0.3; margin-bottom: 15px;"></i>
            <h5 class="text-muted">No Triage History Found</h5>
            <p class="text-muted">This patient has not been through triage yet.</p>
            <button type="button" class="btn btn-primary btn-sm" onclick="redirectToTriage()">
                <i class="fa fa-plus"></i> Create Triage Record
            </button>
        </div>
    `);
}

function showTriageHistoryError(message) {
    $('#reviewTriageList').html(`
        <div class="review-item" style="background: #f8d7da; border: 1px solid #f5c6cb; padding: 15px;">
            <div class="text-danger">
                <i class="fa fa-exclamation-triangle"></i> <strong>Error Loading Triage History</strong><br>
                <small>${message}</small>
            </div>
            <div style="margin-top: 10px;">
                <button type="button" class="btn btn-sm btn-outline-danger" onclick="retryLoadTriageHistory()">
                    <i class="fa fa-refresh"></i> Retry
                </button>
                <button type="button" class="btn btn-sm btn-outline-secondary" onclick="debugTriageEndpoint()">
                    <i class="fa fa-wrench"></i> Debug
                </button>
            </div>
        </div>
    `);
}

function retryLoadTriageHistory() {
    if (window.consultationState.selectedPatientId) {
        loadPatientTriageHistory(window.consultationState.selectedPatientId);
    }
}

function debugTriageEndpoint() {
    const endpoint = window.consultationConfig.baseURL + window.consultationConfig.endpoints.getPatientTriageHistory;
    const patientId = window.consultationState.selectedPatientId;
    
    console.group('🔧 Triage Endpoint Debug');
    console.log('Base URL:', window.consultationConfig.baseURL);
    console.log('Endpoint:', window.consultationConfig.endpoints.getPatientTriageHistory);
    console.log('Full URL:', endpoint);
    console.log('Patient ID:', patientId);
    console.log('Current State:', window.consultationState);
    console.groupEnd();
    
    // Test the endpoint directly
    fetch(endpoint, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
        },
        body: `patient_id=${patientId}`
    })
    .then(response => {
        console.log('🌐 Direct fetch response status:', response.status);
        return response.text();
    })
    .then(text => {
        console.log('🌐 Direct fetch response text:', text);
        try {
            const json = JSON.parse(text);
            console.log('🌐 Direct fetch response JSON:', json);
        } catch (e) {
            console.log('🌐 Response is not valid JSON');
        }
    })
    .catch(error => {
        console.error('🌐 Direct fetch error:', error);
    });
}

function redirectToTriage() {
    const patientId = window.consultationState.selectedPatientId;
    if (patientId) {
        window.open(`${base_url}admin/triage?patient_id=${patientId}`, '_blank');
    }
}

function getPriorityClass(priority) {
    const p = priority?.toString().toLowerCase();
    switch(p) {
        case 'high':
        case 'urgent':
        case '1':
        case 'red':
            return 'priority-high';
        case 'medium':
        case '2':
        case '3':
        case 'yellow':
        case 'orange':
            return 'priority-medium';
        case 'low':
        case '4':
        case '5':
        case 'green':
            return 'priority-low';
        default:
            return 'priority-standard';
    }
}

function getPriorityIcon(priority) {
    const p = priority?.toString().toLowerCase();
    switch(p) {
        case 'high':
        case 'urgent':
        case '1':
        case 'red':
            return '<i class="fa fa-exclamation-triangle"></i>';
        case 'medium':
        case '2':
        case '3':
        case 'yellow':
        case 'orange':
            return '<i class="fa fa-clock-o"></i>';
        case 'low':
        case '4':
        case '5':
        case 'green':
            return '<i class="fa fa-info-circle"></i>';
        default:
            return '<i class="fa fa-stethoscope"></i>';
    }
}

function loadPatientVerificationHistory(patientId) {
   $('#reviewVerificationsList').html('<div class="text-center"><div class="spinner-modern"></div> Loading verification history...</div>');
   
   $.ajax({
       url: window.consultationConfig.baseURL + window.consultationConfig.endpoints.getPatientVerifications,
       type: 'POST',
       data: { patient_id: patientId },
       dataType: 'json',
       timeout: 10000,
       success: function(response) {
           console.log('Verifications response:', response);
           
           if (response && response.status === 'success') {
               if (response.verifications && response.verifications.length > 0) {
                   displayVerificationHistory(response.verifications);
                   window.consultationState.patientReview.verifications = response.verifications;
               } else {
                   $('#reviewVerificationsList').html(`
                       <div class="review-item">
                           <div class="text-muted">
                               <i class="fa fa-info-circle"></i> ${response.message || 'No verification history found for this patient'}
                           </div>
                       </div>
                   `);
               }
           } else {
               $('#reviewVerificationsList').html(`
                   <div class="review-item">
                       <div class="text-muted">
                           <i class="fa fa-info-circle"></i> ${response.message || 'No verification history found'}
                       </div>
                   </div>
               `);
           }
       },
       error: function(xhr, status, error) {
           console.error('Error loading verifications:', error);
           
           let errorMessage = 'Unable to load verification history';
           if (xhr.status === 404) {
               errorMessage = 'Verification history endpoint not found';
           } else if (xhr.status === 403) {
               errorMessage = 'Access denied - insufficient privileges for verification history';
           } else if (xhr.status === 500) {
               errorMessage = 'Server error loading verification history';
           }
           
           // Show helpful message about creating the table
           $('#reviewVerificationsList').html(`
               <div class="review-item">
                   <div class="text-info">
                       <i class="fa fa-info-circle"></i> <strong>Verification History Setup Required</strong><br>
                       <small>The verification history feature requires the 'fingerprint_verification_log' database table.</small><br>
                       <small>Status: ${xhr.status} - ${error}</small><br><br>
                       <small><strong>Note:</strong> Verification records will appear here once biometric verifications are performed.</small>
                   </div>
               </div>
           `);
       }
   });
}

function displayVerificationHistory(verifications) {
   if (verifications.length === 0) {
       $('#reviewVerificationsList').html('<div class="review-item">No verification attempts found</div>');
       return;
   }
   
   let html = '';
   verifications.forEach(verification => {
       const verificationDate = new Date(verification.verification_date).toLocaleDateString();
       const verificationTime = new Date(verification.verification_date).toLocaleTimeString();
       
       // Use the actual field names from fingerprint_verification_log table
       const resultClass = verification.verification_status === 'success' ? 'text-success' : 
                         verification.verification_status === 'failed' ? 'text-danger' : 'text-warning';
       const resultIcon = verification.verification_status === 'success' ? 'fa-check' : 
                         verification.verification_status === 'failed' ? 'fa-times' : 'fa-exclamation';
       
       // Calculate match percentage if available
       const matchScore = verification.match_score || 0;
       const matchPercentage = verification.match_percentage || Math.round((matchScore / 199) * 100);
       
       // Use the formatted staff name from database
       const staffName = verification.staff_name_full || 
                        verification.staff_name || 
                        'Unknown Staff';
       
       html += `
           <div class="review-item">
               <div class="row">
                   <div class="col-md-8">
                       <strong>Date/Time:</strong> ${verificationDate} ${verificationTime}<br>
                       <strong>Method:</strong> ${verification.verification_type || 'Biometric'} Matching<br>
                       <strong>Match Score:</strong> ${matchScore}/199 (${matchPercentage}%)<br>
                       <strong>Threshold:</strong> ${verification.threshold_used || 75}<br>
                       ${verification.has_stored_template == 1 ? 
                         '<strong>Template:</strong> Available<br>' : 
                         '<strong>Template:</strong> <span class="text-warning">Not Available</span><br>'}
                       ${verification.notes ? `<strong>Notes:</strong> ${verification.notes}<br>` : ''}
                   </div>
                   <div class="col-md-4 text-right">
                       <span class="label ${resultClass === 'text-success' ? 'label-success' : 
                                          resultClass === 'text-danger' ? 'label-danger' : 'label-warning'}">
                           ${(verification.verification_status || 'Unknown').toUpperCase()}
                       </span><br>
                       ${staffName ? `<small>By: ${staffName}</small><br>` : ''}
                       ${verification.ip_address ? `<small>IP: ${verification.ip_address}</small>` : ''}
                   </div>
               </div>
           </div>
       `;
   });
   
   $('#reviewVerificationsList').html(html);
}

function loadPatientSummaryStatistics(patientId) {
   // Calculate summary from loaded data
   setTimeout(() => {
       const consultations = window.consultationState.patientReview.consultations || [];
       const labTests = window.consultationState.patientReview.labTests || [];
       const triageHistory = window.consultationState.patientReview.triageHistory || [];
       const verifications = window.consultationState.patientReview.verifications || [];
       
       $('#totalConsultations').text(consultations.length);
       $('#totalLabTests').text(labTests.length);
       $('#totalTriageVisits').text(triageHistory.length);
       $('#totalVerifications').text(verifications.length);
       
       // Calculate additional info
       if (consultations.length > 0) {
           const firstVisit = new Date(Math.min(...consultations.map(c => new Date(c.consultation_date))));
           const lastVisit = new Date(Math.max(...consultations.map(c => new Date(c.consultation_date))));
           
           $('#firstVisitDate').text(firstVisit.toLocaleDateString());
           $('#lastVisitDate').text(lastVisit.toLocaleDateString());
           
           // Get most common diagnoses
           const diagnoses = consultations.map(c => c.diagnosis).filter(d => d);
           const diagnosisCount = {};
           diagnoses.forEach(d => diagnosisCount[d] = (diagnosisCount[d] || 0) + 1);
           const commonDiagnoses = Object.keys(diagnosisCount)
               .sort((a, b) => diagnosisCount[b] - diagnosisCount[a])
               .slice(0, 3)
               .join(', ');
           
           $('#commonDiagnoses').text(commonDiagnoses || 'None recorded');
       } else {
           $('#firstVisitDate').text('N/A');
           $('#lastVisitDate').text('N/A');
           $('#commonDiagnoses').text('N/A');
       }
       
       $('#patientWorkflowType').text(window.consultationState.patientWorkflowType);
   }, 1000);
}

// Function to log verification attempts to database
function logVerificationAttempt(verificationData) {
   if (!window.consultationState.selectedPatientId) {
       console.log('No patient selected - skipping verification log');
       return;
   }
   
   const logData = {
       patient_id: window.consultationState.selectedPatientId,
       verification_type: '1:1', // 1:1 matching
       match_score: verificationData.match_score || 0,
       is_match: verificationData.is_match ? 1 : 0,
       threshold_used: verificationData.threshold_used || 75,
       service_url: 'https://localhost:8443',
       staff_id: 1, // Default staff ID - should be replaced with actual staff ID
       ip_address: 'localhost',
       user_agent: navigator.userAgent,
       has_stored_template: window.consultationState.storedTemplate ? 1 : 0,
       verification_status: verificationData.verification_status || 'failed',
       notes: verificationData.notes || 'Consultation module verification'
   };
   
   // Send to server to log in database
   $.ajax({
       url: window.consultationConfig.baseURL + 'admin/consultation/logVerificationAttempt',
       type: 'POST',
       data: logData,
       dataType: 'json',
       success: function(response) {
           if (response.status === 'success') {
               console.log('Verification attempt logged successfully');
           }
       },
       error: function(xhr, status, error) {
           console.log('Failed to log verification attempt:', error);
           // Don't show error to user as this is background logging
       }
   });
}

function printPatientSummary() {
   const patientName = $('#reviewPatientName').text();
   const patientId = $('#reviewPatientId').text();
   
   const printContent = `
       <!DOCTYPE html>
       <html>
       <head>
           <title>Patient Summary - ${patientName}</title>
           <style>
               body { font-family: Arial, sans-serif; margin: 20px; }
               .header { text-align: center; border-bottom: 2px solid #000; padding-bottom: 10px; }
               .section { margin: 20px 0; }
               .section h3 { background: #f0f0f0; padding: 8px; margin: 0; }
               .item { margin: 10px 0; padding: 8px; border: 1px solid #ddd; }
               @media print {
                   body { margin: 0; }
                   .no-print { display: none; }
               }
           </style>
       </head>
       <body>
           <div class="header">
               <h2>Patient Medical Summary</h2>
               <p><strong>Patient:</strong> ${patientName} | <strong>ID:</strong> ${patientId}</p>
               <p><strong>Generated:</strong> ${new Date().toLocaleString()}</p>
           </div>
           
           <div class="section">
               <h3>Summary Statistics</h3>
               <p><strong>Total Consultations:</strong> ${$('#totalConsultations').text()}</p>
               <p><strong>Lab Tests Done:</strong> ${$('#totalLabTests').text()}</p>
               <p><strong>Triage Visits:</strong> ${$('#totalTriageVisits').text()}</p>
               <p><strong>Verifications:</strong> ${$('#totalVerifications').text()}</p>
               <p><strong>Workflow Type:</strong> ${$('#patientWorkflowType').text()}</p>
           </div>
           
           <div class="section">
               <h3>Recent Consultations</h3>
               ${$('#reviewConsultationsList').html()}
           </div>
           
           <div class="section">
               <h3>Recent Lab Tests</h3>
               ${$('#reviewLabTestsList').html()}
           </div>
           
           <div class="footer" style="margin-top: 40px; text-align: center; font-size: 12px; color: #666;">
               <p>Enhanced Medical System - Patient Summary Report</p>
           </div>
       </body>
       </html>
   `;
   
   const printWindow = window.open('', '_blank');
   printWindow.document.write(printContent);
   printWindow.document.close();
   
   printWindow.onload = function() {
       setTimeout(() => {
           printWindow.print();
           printWindow.close();
       }, 500);
   };
}

function startNewConsultationFromReview() {
   $('#patientReviewModal').modal('hide');
   setTimeout(() => {
       startEnhancedConsultation();
   }, 300);
}

// =============================================
// ENHANCED CONSULTATION MANAGEMENT
// =============================================

function startEnhancedConsultation() {
  const patientId = $('#selectedPatientId').val();
  if (!patientId) {
      showModernMessage('Please select a patient first', 'warning');
      return;
  }
  
  // Check verification requirement properly
  if (window.consultationState.requiresVerification && !window.consultationState.verificationPassed) {
      const workflowType = window.consultationState.patientWorkflowType || 'GCC';
      showModernMessage(`${workflowType} patients must be verified before consultation`, 'warning');
      
      const verificationSection = $('#biometricVerificationSection');
      verificationSection.addClass('pulse-highlight');
      setTimeout(() => {
          verificationSection.removeClass('pulse-highlight');
      }, 2000);
      
      return;
  }
  
  // Enhanced modal preparation
  setupConsultationModal();
}

function setupConsultationModal() {
  const patientId = $('#selectedPatientId').val();
  
  // Populate modal fields
  $('#modalPatientIdHidden').val(patientId);
  $('#modalPatientId').text(patientId);
  $('#modalPatientName').text($('#patientName').text());
  $('#consultationDate').val(new Date().toISOString().split('T')[0]);
  $('#modalVerificationStatus').val(window.consultationState.verificationPassed ? '1' : '0');
  $('#modalWorkflowType').val(window.consultationState.patientWorkflowType || 'General');
  $('#modalIsGCCPatient').val(window.consultationState.isGCCPatient ? '1' : '0');
  
  // Enhanced verification badge
  let verificationBadge;
  if (window.consultationState.requiresVerification && window.consultationState.verificationPassed) {
      verificationBadge = '<span class="status-indicator status-verified"><i class="fa fa-shield"></i> GCC Biometric Verified</span>';
  } else if (!window.consultationState.requiresVerification) {
      verificationBadge = '<span class="status-indicator status-general"><i class="fa fa-check-circle"></i> General Patient - No Verification Required</span>';
  } else {
      verificationBadge = '<span class="status-indicator status-pending"><i class="fa fa-exclamation-triangle"></i> Unverified GCC Patient</span>';
  }
  
  $('#modalVerificationBadge').html(verificationBadge);
  
  if (window.consultationState.verificationPassed && window.consultationState.requiresVerification) {
      $('#modalVerificationDetails').html(`
          <small>SGIMatchScore: ${window.consultationState.currentMatchScore}/199</small><br>
          <small>Quality: ${window.consultationState.verificationQuality}</small>
      `);
  } else if (!window.consultationState.requiresVerification) {
      $('#modalVerificationDetails').html(`
          <small>Workflow: ${window.consultationState.patientWorkflowType}</small><br>
          <small>Verification exempted by workflow policy</small>
      `);
  }
  
  // NEW: Hide diagnosis section for GCC patients
  if (window.consultationState.isGCCPatient) {
      console.log('🔒 Hiding ICD diagnosis section for GCC patient');
      $('#diagnosisSection').hide();
      $('#customDiagnosisGroup').hide();
  } else {
      console.log('🔓 Showing ICD diagnosis section for General patient');
      $('#diagnosisSection').show();
  }
  
  // Load doctors, lab tests (optional), and ICD diagnoses
  loadDoctors();
  loadLabTestsData(); // Now optional
  if (!window.consultationState.isGCCPatient) {
      loadIcdDiagnoses(); // Only for non-GCC patients
  }
  
  updateStepIndicator('consult');
  $('#consultationModal').modal('show');
}

// =============================================
// DOCTORS MANAGEMENT
// =============================================

function loadDoctors() {
   console.log('👩‍⚕️ Loading doctors from database...');
   
   $('#consultationDoctor').html('<option value="">Loading doctors...</option>');
   
   const endpoint = window.consultationConfig.baseURL + window.consultationConfig.endpoints.getAllDoctors;
   
   $.ajax({
       url: endpoint,
       type: 'GET',
       dataType: 'json',
       timeout: 10000,
       success: function(response) {
           console.log('📥 Doctors response received:', response);
           handleDoctorsLoadSuccess(response);
       },
       error: function(xhr, status, error) {
           console.error('❌ Error loading doctors:', status, error);
           handleDoctorsLoadError(xhr, status, error);
       }
   });
}

function handleDoctorsLoadSuccess(response) {
   console.log('✅ Processing doctors response...');
   
   try {
       let doctors = [];
       
       if (response && response.status === 'success' && Array.isArray(response.doctors)) {
           doctors = response.doctors;
       } else if (response && Array.isArray(response)) {
           doctors = response;
       } else {
           console.error('Invalid doctors response format:', response);
           handleDoctorsLoadError(null, 'Invalid response format');
           return;
       }
       
       populateDoctorsDropdown(doctors);
       console.log(`✅ Successfully loaded ${doctors.length} doctors`);
       
   } catch (error) {
       console.error('❌ Error processing doctors response:', error);
       handleDoctorsLoadError(null, 'Processing error: ' + error.message);
   }
}

function populateDoctorsDropdown(doctors) {
   console.log('👩‍⚕️ Populating doctors dropdown with', doctors.length, 'doctors');
   
   const select = $('#consultationDoctor');
   select.empty();
   select.append(`<option value="">Select Doctor (${doctors.length} available)</option>`);
   
   if (doctors.length === 0) {
       select.append('<option value="" disabled>No doctors found</option>');
       showModernMessage('No doctors found in system', 'warning');
       return;
   }
   
   $.each(doctors, function(index, doctor) {
       try {
           let displayText = doctor.display_name || `Dr. ${doctor.full_name}`;
           
           const option = $('<option>', {
               value: doctor.id,
               text: displayText,
               'data-name': doctor.full_name,
               'data-employee-id': doctor.employee_id,
               'data-specialist': doctor.specialist,
               'data-specialization': doctor.specialization,
               'data-designation': doctor.designation
           });
           
           select.append(option);
           
       } catch (error) {
           console.error('❌ Error processing doctor', doctor.id, ':', error);
       }
   });
   
   console.log(`✅ Successfully populated ${doctors.length} doctors`);
   
   // Initialize Select2 for better search
   if (typeof $.fn.select2 !== 'undefined') {
       select.select2({
           placeholder: 'Search and select doctor...',
           allowClear: true,
           width: '100%',
           dropdownParent: $('#consultationModal')
       });
   }
}

function handleDoctorsLoadError(xhr, status, error) {
   console.error('❌ Handling doctors load error...');
   
   $('#consultationDoctor').html('<option value="">Error loading doctors</option>');
   
   let errorMessage = 'Failed to load doctors';
   
   if (xhr && xhr.status === 404) {
       errorMessage = 'Doctors endpoint not found (404)';
   } else if (xhr && xhr.status === 500) {
       errorMessage = 'Server error loading doctors (500)';
   } else if (status === 'timeout') {
       errorMessage = 'Request timeout loading doctors';
   }
   
   showModernMessage(errorMessage, 'warning');
   
   // Add fallback option
   $('#consultationDoctor').append('<option value="manual">Enter doctor manually</option>');
}

// =============================================
// LAB TESTS MANAGEMENT (NOW OPTIONAL)
// =============================================

function loadLabTestsData() {
  console.log('🧪 Loading lab tests data (optional)...');
  
  // Mark as optional in the UI
  $('.lab-tests-panel').addClass('lab-tests-optional');
  
  // Simulate loading lab tests by category (replace with real AJAX)
  const mockLabTests = {
      '1': [ // Hematology
          {id: 1, test_name: 'Complete Blood Count (CBC)', short_name: 'CBC', cost: 500, sample_type: 'Blood', method: 'Automated'},
          {id: 2, test_name: 'Hemoglobin', short_name: 'Hb', cost: 200, sample_type: 'Blood', method: 'Automated'},
          {id: 3, test_name: 'Hematocrit', short_name: 'HCT', cost: 150, sample_type: 'Blood', method: 'Automated'},
          {id: 4, test_name: 'ESR', short_name: 'ESR', cost: 300, sample_type: 'Blood', method: 'Westergren'}
      ],
      '2': [ // Clinical Chemistry
          {id: 5, test_name: 'Random Blood Sugar', short_name: 'RBS', cost: 200, sample_type: 'Blood', method: 'Glucose Oxidase'},
          {id: 6, test_name: 'Fasting Blood Sugar', short_name: 'FBS', cost: 250, sample_type: 'Blood', method: 'Glucose Oxidase'},
          {id: 7, test_name: 'Liver Function Tests', short_name: 'LFTs', cost: 800, sample_type: 'Blood', method: 'Automated'},
          {id: 8, test_name: 'Kidney Function Tests', short_name: 'KFTs', cost: 600, sample_type: 'Blood', method: 'Automated'}
      ],
      '3': [ // Microbiology
          {id: 9, test_name: 'Blood Culture', short_name: 'BC', cost: 1000, sample_type: 'Blood', method: 'Culture'},
          {id: 10, test_name: 'Urine Culture', short_name: 'UC', cost: 800, sample_type: 'Urine', method: 'Culture'},
          {id: 11, test_name: 'Stool Culture', short_name: 'SC', cost: 900, sample_type: 'Stool', method: 'Culture'}
      ],
      '6': [ // Serology
          {id: 12, test_name: 'HIV Test', short_name: 'HIV', cost: 500, sample_type: 'Blood', method: 'ELISA'},
          {id: 13, test_name: 'Hepatitis B Surface Antigen', short_name: 'HBsAg', cost: 600, sample_type: 'Blood', method: 'ELISA'},
          {id: 14, test_name: 'VDRL Test', short_name: 'VDRL', cost: 400, sample_type: 'Blood', method: 'RPR'}
      ],
      'other': [ // Other Tests
          {id: 15, test_name: 'Urinalysis', short_name: 'U/A', cost: 300, sample_type: 'Urine', method: 'Microscopy'},
          {id: 16, test_name: 'Pregnancy Test', short_name: 'βHCG', cost: 400, sample_type: 'Urine', method: 'Immunoassay'},
          {id: 17, test_name: 'Thyroid Function Tests', short_name: 'TFTs', cost: 1200, sample_type: 'Blood', method: 'ELISA'}
      ]
  };
  
  window.consultationState.labTests.available = mockLabTests;
  window.consultationState.labTests.isRequired = false; // Mark as optional
  
  populateTestCategories();
  showModernMessage('Lab tests loaded (optional selection)', 'success');
}

function populateTestCategories() {
  const categories = {
      1: { id: 'hematology', name: 'Hematology', container: '#hematologyTestsList' },
      2: { id: 'chemistry', name: 'Clinical Chemistry', container: '#chemistryTestsList' },
      3: { id: 'microbiology', name: 'Microbiology', container: '#microbiologyTestsList' },
      6: { id: 'serology', name: 'Serology', container: '#serologyTestsList' },
      'other': { id: 'other', name: 'Other Tests', container: '#otherTestsList' }
  };
  
  Object.keys(categories).forEach(categoryId => {
      const category = categories[categoryId];
      const tests = window.consultationState.labTests.available[categoryId] || [];
      const container = $(category.container);
      
      if (tests.length > 0) {
          populateTestCheckboxes(container, tests, categoryId);
      } else {
          container.html(`
              <div class="col-md-12 text-center text-muted">
                  <i class="fa fa-info-circle"></i> No ${category.name.toLowerCase()} tests available
              </div>
          `);
      }
  });
}

function populateTestCheckboxes(container, tests, categoryId) {
  container.empty();
  
  tests.forEach(test => {
      const costDisplay = test.cost > 0 ? `(Ksh.${parseFloat(test.cost).toFixed(2)})` : '';
      const checkboxHtml = `
          <div class="col-md-6 col-sm-12">
              <div class="test-checkbox">
                  <label style="font-weight: normal; width: 100%; cursor: pointer; color: black;">
                      <input type="checkbox" 
                             value="${test.id}" 
                             data-test-name="${test.test_name}"
                             data-short-name="${test.short_name || ''}"
                             data-cost="${test.cost || 0}"
                             data-category="${categoryId}"
                             data-sample-type="${test.sample_type || ''}"
                             data-method="${test.method || ''}"
                             class="lab-test-checkbox">
                      <strong>${test.test_name}</strong>
                      ${test.short_name ? `<small>(${test.short_name})</small>` : ''}
                      <br>
                      <small>
                          ${test.sample_type ? `Sample: ${test.sample_type}` : ''}
                          ${test.method ? ` | Method: ${test.method}` : ''}
                          ${costDisplay ? ` | ${costDisplay}` : ''}
                      </small>
                  </label>
              </div>
          </div>
      `;
      container.append(checkboxHtml);
  });
}

function updateSelectedTestsSummary() {
  const selectedTests = $('.lab-test-checkbox:checked');
  const selectedCount = selectedTests.length;
  let totalCost = 0;
  let testsList = [];
  
  selectedTests.each(function() {
      const $this = $(this);
      const cost = parseFloat($this.data('cost')) || 0;
      totalCost += cost;
      testsList.push($this.data('test-name'));
  });
  
  $('#selectedTestsCount').text(selectedCount);
  $('#estimatedTestsCost').text(totalCost.toFixed(2));
  
  if (selectedCount > 0) {
      $('#selectedTestsList').html(testsList.map(test => `<span class="label label-info" style="margin: 2px; color: white;">${test}</span>`).join(' '));
  } else {
      $('#selectedTestsList').html('<em style="color: rgba(255,255,255,0.7);">No tests selected (optional)</em>');
  }
  
  // Update global state
  window.consultationState.labTests.selected = [];
  selectedTests.each(function() {
      const $this = $(this);
      window.consultationState.labTests.selected.push({
          id: $this.val(),
          test_name: $this.data('test-name'),
          short_name: $this.data('short-name'),
          cost: $this.data('cost'),
          category: $this.data('category'),
          sample_type: $this.data('sample-type'),
          method: $this.data('method')
      });
  });
  
  window.consultationState.labTests.estimatedCost = totalCost;
  $('#selectedTestsInput').val(JSON.stringify(window.consultationState.labTests.selected));
}

// =============================================
// ICD-10 DIAGNOSIS MANAGEMENT (HIDDEN FOR GCC)
// =============================================

function loadIcdDiagnoses() {
  console.log('📋 Loading ICD-10 diagnoses (non-GCC patients only)...');
  
  $('#consultationDiagnosis').html('<option value="">Loading ICD-10 codes...</option>');
  
  // Simulate loading ICD diagnoses (replace with real AJAX)
  const mockDiagnoses = [
      {id: 1, code: 'A00.0', title: 'Cholera due to Vibrio cholerae 01, biovar cholerae', category: 'Infectious diseases'},
      {id: 2, code: 'B15.9', title: 'Hepatitis A without hepatic coma', category: 'Infectious diseases'},
      {id: 3, code: 'E11.9', title: 'Type 2 diabetes mellitus without complications', category: 'Endocrine diseases'},
      {id: 4, code: 'I10', title: 'Essential (primary) hypertension', category: 'Circulatory diseases'},
      {id: 5, code: 'J44.1', title: 'Chronic obstructive pulmonary disease with acute exacerbation', category: 'Respiratory diseases'},
      {id: 6, code: 'K59.0', title: 'Constipation', category: 'Digestive diseases'},
      {id: 7, code: 'M79.2', title: 'Neuralgia and neuritis, unspecified', category: 'Musculoskeletal diseases'},
      {id: 8, code: 'R50.9', title: 'Fever, unspecified', category: 'Symptoms and signs'},
      {id: 9, code: 'Z00.0', title: 'General adult medical examination', category: 'Health services'}
  ];
  
  setTimeout(() => {
      populateIcdSelect(mockDiagnoses);
      initializeDiagnosisSelect2();
      showModernMessage('ICD-10 diagnoses loaded (non-GCC patients)', 'success');
  }, 1000);
}

function populateIcdSelect(diagnoses) {
  const select = $('#consultationDiagnosis');
  select.empty();
  select.append('<option value="">Search and select ICD-10 diagnosis...</option>');
  
  diagnoses.forEach(diagnosis => {
      const optionText = `${diagnosis.code} - ${diagnosis.title}`;
      const option = $(`<option value="${diagnosis.id}" 
          data-code="${diagnosis.code}" 
          data-title="${diagnosis.title}" 
          data-category="${diagnosis.category || ''}">${optionText}</option>`);
      select.append(option);
  });
  
  console.log(`Populated ${diagnoses.length} ICD-10 diagnoses in dropdown`);
}
function initializeDiagnosisSelect2() {
  if ($('#consultationDiagnosis').hasClass('select2-hidden-accessible')) {
      $('#consultationDiagnosis').select2('destroy');
  }
  
  $('#consultationDiagnosis').select2({
      placeholder: 'Search ICD-10 codes by code, title, or category...',
      allowClear: true,
      width: '100%',
      dropdownParent: $('#consultationModal'),
      minimumInputLength: 0
  });
  
  console.log('Select2 initialized for diagnosis dropdown');
}

function selectDiagnosis(diagnosisId) {
  const selectedOption = $(`#consultationDiagnosis option[value="${diagnosisId}"]`);
  
  if (selectedOption.length) {
      const diagnosisData = {
          id: diagnosisId,
          code: selectedOption.data('code'),
          title: selectedOption.data('title'),
          category: selectedOption.data('category')
      };
      
      window.consultationState.selectedDiagnosis = diagnosisData;
      
      $('#selectedDiagnosisCode').text(diagnosisData.code);
      $('#selectedDiagnosisTitle').text(diagnosisData.title);
      $('#selectedDiagnosisCategory').text(diagnosisData.category);
      $('#selectedDiagnosisInfo').show();
      
      $('#customDiagnosisGroup').hide();
      $('#consultationDiagnosisCustom').val('');
      
      console.log('Selected diagnosis:', diagnosisData);
  }
}

function clearDiagnosis() {
  $('#consultationDiagnosis').val('').trigger('change');
  $('#selectedDiagnosisInfo').hide();
  $('#customDiagnosisGroup').hide();
  $('#consultationDiagnosisCustom').val('');
  window.consultationState.selectedDiagnosis = null;
  
  console.log('Diagnosis selection cleared');
}

function showCustomDiagnosis() {
  $('#customDiagnosisGroup').show();
  $('#consultationDiagnosisCustom').focus();
  $('#selectedDiagnosisInfo').hide();
  $('#consultationDiagnosis').val('').trigger('change');
  window.consultationState.selectedDiagnosis = null;
  
  showModernMessage('Custom diagnosis mode enabled', 'info');
}

// =============================================
// ENHANCED CONSULTATION SAVING (NO LAB TEST ENFORCEMENT)
// =============================================

function saveEnhancedConsultation() {
   const submitBtn = $('#consultationForm').find('button[type="submit"]');
   submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving Enhanced Consultation...');
   
   const patientId = $('#modalPatientIdHidden').val();
   
   // Check verification requirement properly
   if (window.consultationState.requiresVerification && !window.consultationState.verificationPassed) {
       showModernMessage('GCC patients must be verified before consultation can be saved', 'error');
       submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Save Consultation');
       return;
   }
   
   // Enhanced form validation (NO lab test requirement)
   if (!$('#consultationSymptoms').val().trim()) {
       showModernMessage('Please enter patient symptoms/chief complaint', 'warning');
       $('#consultationSymptoms').focus();
       submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Save Consultation');
       return;
   }
   
   if (!$('#consultationDoctor').val()) {
       showModernMessage('Please select a doctor', 'warning');
       $('#consultationDoctor').focus();
       submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Save Consultation');
       return;
   }
   
   console.log('🔬 Lab tests are OPTIONAL - proceeding without enforcement');
   
   // Prepare form data
   let formData = $('#consultationForm').serialize();
   
   // Add diagnosis information (only for non-GCC patients)
   if (!window.consultationState.isGCCPatient) {
       if (window.consultationState.selectedDiagnosis) {
           formData += `&diagnosis_code=${window.consultationState.selectedDiagnosis.code}`;
           formData += `&diagnosis_title=${encodeURIComponent(window.consultationState.selectedDiagnosis.title)}`;
           formData += `&diagnosis_type=icd10`;
       } else if ($('#consultationDiagnosisCustom').val().trim()) {
           formData += `&diagnosis_custom=${encodeURIComponent($('#consultationDiagnosisCustom').val())}`;
           formData += `&diagnosis_type=custom`;
       }
   } else {
       console.log('🔒 GCC Patient - Skipping ICD diagnosis (hidden for GCC workflow)');
       formData += `&diagnosis_type=gcc_workflow`;
       formData += `&diagnosis_custom=GCC Patient - No ICD diagnosis required`;
   }
   
   // Add lab tests data (OPTIONAL - can be empty)
   const selectedTests = window.consultationState.labTests.selected || [];
   formData += `&selected_tests=${encodeURIComponent(JSON.stringify(selectedTests))}`;
   formData += `&total_tests=${selectedTests.length}`;
   formData += `&estimated_tests_cost=${window.consultationState.labTests.estimatedCost || 0}`;
   formData += `&lab_tests_optional=1`; // Flag indicating tests are optional
   
   // Add verification details
   formData += `&verification_score=${window.consultationState.currentMatchScore}`;
   formData += `&verification_quality=${window.consultationState.verificationQuality}`;
   formData += `&verification_method=${window.consultationState.verificationPassed ? 'fingerprint' : 'workflow_exempted'}`;
   
   console.log('📤 Sending consultation data (lab tests optional):', formData);
   
   // Real AJAX call to your controller
   $.ajax({
       url: window.consultationConfig.baseURL + window.consultationConfig.endpoints.saveConsultation,
       type: 'POST',
       data: formData,
       dataType: 'json',
       timeout: 30000,
       success: function(response) {
           console.log('💾 Save response:', response);
           
           if (response.status === 'success') {
               const workflowType = window.consultationState.patientWorkflowType || 'GENERAL';
               const testsMessage = selectedTests.length > 0 ? ` with ${selectedTests.length} lab tests` : ' (no lab tests)';
               showModernMessage(`✓ ENHANCED ${workflowType} patient consultation saved successfully${testsMessage}!`, 'success');
               
               $('#consultationModal').modal('hide');
               updateStepIndicator('save');
               
               // Reset form
               resetConsultationForm();
               
               // Update consultation count or reload lists if needed
               if (typeof loadPatientConsultations === 'function') {
                   loadPatientConsultations(patientId);
               }
               
           } else {
               showModernMessage(response.message || 'Failed to save consultation', 'error');
           }
       },
       error: function(xhr, status, error) {
           console.error('❌ Save consultation error:', xhr.responseText);
           
           let errorMessage = 'Failed to save consultation';
           if (xhr.responseText) {
               try {
                   const errorResponse = JSON.parse(xhr.responseText);
                   errorMessage = errorResponse.message || errorMessage;
               } catch (e) {
                   errorMessage += ': ' + error;
               }
           }
           
           showModernMessage(errorMessage, 'error');
       },
       complete: function() {
           submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Save Consultation');
       }
   });
}

function resetConsultationForm() {
  $('#consultationForm')[0].reset();
  $('#selectedDiagnosisInfo').hide();
  $('#customDiagnosisGroup').hide();
  $('#consultationDiagnosis').val('').trigger('change');
  window.consultationState.selectedDiagnosis = null;
  
  // Reset lab tests selection
  $('.lab-test-checkbox').prop('checked', false);
  updateSelectedTestsSummary();
  window.consultationState.labTests.selected = [];
  window.consultationState.labTests.estimatedCost = 0;
}

// =============================================
// FINGERPRINT CAPTURE AND VERIFICATION
// =============================================

function captureFingerprint() {
   logDiagnostic('Starting SGIFPCapture for consultation', 'info');
   
   window.consultationState.liveTemplate = null;
   $('#liveScannedTemplate').val('');
   $('#liveFingerprintContainer').addClass('active');
   
   $('#fingerprintStatus').html(`
       <div class="status-info">
           <i class="fa fa-spinner fa-spin"></i> <strong>Place finger on scanner...</strong><br>
           <small>SGIFPCapture in progress - Consultation Module</small>
       </div>
   `);
   
   $('#manualVerifyBtn').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Scanning...');
   
   const captureUrl = 'https://localhost:8443/SGIFPCapture';
   
   const xhr = new XMLHttpRequest();
   xhr.open('POST', captureUrl, true);
   xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
   xhr.timeout = 25000;
   
   xhr.onreadystatechange = function() {
       if (xhr.readyState === 4) {
           $('#manualVerifyBtn').prop('disabled', false).html('<i class="fa fa-fingerprint"></i> Manual Print Capture');
           
           if (xhr.status === 200) {
               try {
                   const result = JSON.parse(xhr.responseText);
                   handleCaptureResponse(result);
               } catch (e) {
                   handleCaptureError('Invalid response from SGIFPCapture: ' + e.message);
               }
           } else {
               handleCaptureError(`SGIFPCapture failed: HTTP ${xhr.status}`);
           }
       }
   };
   
   xhr.onerror = function() {
       $('#manualVerifyBtn').prop('disabled', false).html('<i class="fa fa-fingerprint"></i> Manual Print Capture');
       handleCaptureError('Network error during SGIFPCapture');
   };
   
   xhr.ontimeout = function() {
       $('#manualVerifyBtn').prop('disabled', false).html('<i class="fa fa-fingerprint"></i> Manual Print Capture');
       handleCaptureError('SGIFPCapture timeout - no finger detected');
   };
   
   const postData = 'Quality=50&Timeout=20000&WSQCompression=2.25';
   xhr.send(postData);
   
   logDiagnostic('Fingerprint capture initiated', 'info');
}

function handleCaptureResponse(result) {
   if (result.ErrorCode === 0) {
       if (result.BMPBase64) {
           $('#liveFingerprintImage').attr('src', 'data:image/bmp;base64,' + result.BMPBase64);
       }
       
       if (result.TemplateBase64) {
           window.consultationState.liveTemplate = result.TemplateBase64;
           $('#liveScannedTemplate').val(result.TemplateBase64);
       }
       
       const quality = result.Quality || 50;
       let deviceInfo = '';
       if (result.SerialNumber) {
           deviceInfo = ` (${result.Manufacturer || 'SecuGen'} ${result.Model || 'Device'} - SN: ${result.SerialNumber})`;
       }
       
       $('#liveTemplateDetails').html(`<span class="text-success">Template captured (Quality: ${quality}%)</span>`);
       
       $('#fingerprintStatus').html(`
           <div class="status-success">
               <i class="fa fa-check-circle"></i> <strong>Fingerprint Captured Successfully!</strong><br>
               <small>Quality: <strong>${quality}%</strong> | Template: ${result.TemplateBase64 ? result.TemplateBase64.length : 0} chars${deviceInfo}</small><br>
               <small class="text-success">Ready for biometric verification</small>
           </div>
       `);
       
       $('#verifyIdentity').prop('disabled', false);
       showModernMessage(`Fingerprint captured! Quality: ${quality}%`, 'success');
       
       logDiagnostic(`Fingerprint capture successful - Quality: ${quality}%`, 'success');
   } else {
       const errorMsg = getSecuGenErrorMessage(result.ErrorCode);
       logDiagnostic(`SecuGen capture error ${result.ErrorCode}: ${errorMsg}`, 'error');
       handleCaptureError(`Capture failed: ${errorMsg}`);
   }
}

function handleCaptureError(message) {
   $('#fingerprintStatus').html(`
       <div class="status-error">
           <i class="fa fa-times-circle"></i> <strong>Fingerprint Capture Failed</strong><br>
           <small>${message}</small><br>
           <div style="margin-top: 10px;">
               <button type="button" class="btn btn-modern btn-sm" onclick="captureFingerprint()">
                   <i class="fa fa-refresh"></i> Try Again
               </button>
               <button type="button" class="btn btn-warning-modern btn-sm" onclick="skipEnhancedVerification()">
                   <i class="fa fa-user-shield"></i> Override
               </button>
           </div>
       </div>
   `);
   
   logDiagnostic(`Capture error: ${message}`, 'error');
}

function performBiometricVerification() {
   logDiagnostic('Starting SGIMatchScore verification', 'info');
   
   if (!window.consultationState.liveTemplate) {
       showModernMessage('Please capture fingerprint first', 'warning');
       return;
   }
   
   if (!window.consultationState.storedTemplate) {
       showModernMessage('No stored template available for comparison', 'warning');
       return;
   }
   
   const matchUrl = 'https://localhost:8443/SGIMatchScore';
   
   $('#fingerprintStatus').html(`
       <div class="status-info">
           <div class="text-center">
               <div class="spinner-modern"></div> <strong>Verifying biometric match...</strong><br>
               <small>Processing fingerprint comparison with SGIMatchScore</small>
           </div>
       </div>
   `);
   
   $('#verifyIdentity').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Verifying...');

   const xhr = new XMLHttpRequest();
   xhr.open('POST', matchUrl, true);
   xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
   xhr.timeout = 10000;
   
   xhr.onreadystatechange = function() {
       if (xhr.readyState === 4) {
           $('#verifyIdentity').prop('disabled', false).html('<i class="fa fa-shield"></i> Verify Print');
           
           if (xhr.status === 200) {
               try {
                   const result = JSON.parse(xhr.responseText);
                   handleVerificationResponse(result);
               } catch (e) {
                   handleVerificationError('Invalid response from SGIMatchScore: ' + e.message);
               }
           } else {
               handleVerificationError(`SGIMatchScore failed: HTTP ${xhr.status}`);
           }
       }
   };

   xhr.onerror = function() {
       $('#verifyIdentity').prop('disabled', false).html('<i class="fa fa-shield"></i> Verify Print');
       handleVerificationError('Network error during SGIMatchScore');
   };

   xhr.ontimeout = function() {
       $('#verifyIdentity').prop('disabled', false).html('<i class="fa fa-shield"></i> Verify Print');
       handleVerificationError('SGIMatchScore timeout');
   };

   const postData = `template1=${encodeURIComponent(window.consultationState.storedTemplate)}&template2=${encodeURIComponent(window.consultationState.liveTemplate)}`;
   xhr.send(postData);
}

function handleVerificationResponse(result) {
   if (result.ErrorCode === 0) {
       const matchScore = parseInt(result.MatchingScore || 0);
       const threshold = 75; // SecuGen threshold
       const isMatch = matchScore >= threshold;
       
       window.consultationState.currentMatchScore = matchScore;
       window.consultationState.verificationPassed = isMatch;
       
       let quality = matchScore >= 120 ? 'Very Good' : matchScore >= threshold ? 'Good' : 'Poor';
       window.consultationState.verificationQuality = quality;
       
       if (isMatch) {
           window.consultationState.verificationStatus = 'success';
           window.consultationState.verificationMethod = 'real_secugen_biometric';
           
           $('#fingerprintStatus').html(`
               <div class="status-success">
                   <h6><i class="fa fa-check-circle"></i> Biometric Verification Successful!</h6>
                   <p><strong>SGIMatchScore: ${matchScore}/199 (${quality})</strong></p>
                   <p>Patient identity confirmed through real SecuGen biometric verification.</p>
                   <small class="text-success">Real verification completed - ready for consultation</small>
               </div>
           `);
           
           $('#verificationStatus').html('<span class="status-indicator status-verified"><i class="fa fa-shield"></i> SecuGen Verified</span>');
           $('#startConsultationBtn').prop('disabled', false);
           $('#reviewPatientBtn').prop('disabled', false);
           
           enhancePatientCard(window.consultationState.selectedPatientData);
           updateStepIndicator('consult');
           
           addToVerificationHistory('Success', matchScore, quality);
           showModernMessage(`Identity verified! SGIMatchScore: ${matchScore}/199 (${quality})`, 'success');
           
       } else {
           $('#fingerprintStatus').html(`
               <div class="status-error">
                   <h6><i class="fa fa-times-circle"></i> Verification Failed</h6>
                   <p><strong>SGIMatchScore: ${matchScore}/199 (${quality})</strong></p>
                   <p>Fingerprint does not match stored template.</p>
                   <div style="margin-top: 15px;">
                       <button type="button" class="btn btn-modern btn-sm" onclick="captureFingerprint()">
                           <i class="fa fa-refresh"></i> Try Again
                       </button>
                       <button type="button" class="btn btn-warning-modern btn-sm" onclick="skipEnhancedVerification()">
                           <i class="fa fa-user-shield"></i> Override
                       </button>
                   </div>
               </div>
           `);
           
           addToVerificationHistory('Failed', matchScore, quality);
           showModernMessage(`Verification failed. SGIMatchScore ${matchScore}/199 below threshold.`, 'warning');
       }
   } else {
       const errorMsg = getSecuGenErrorMessage(result.ErrorCode);
       logDiagnostic(`SecuGen matching error ${result.ErrorCode}: ${errorMsg}`, 'error');
       handleVerificationError(`Matching failed: ${errorMsg}`);
   }
}

function handleVerificationError(message) {
   $('#fingerprintStatus').html(`
       <div class="status-error">
           <i class="fa fa-times-circle"></i> <strong>Verification Error</strong><br>
           <small>${message}</small><br>
           <div style="margin-top: 10px;">
               <button type="button" class="btn btn-modern btn-sm" onclick="performBiometricVerification()">
                   <i class="fa fa-refresh"></i> Try Again
               </button>
               <button type="button" class="btn btn-warning-modern btn-sm" onclick="skipEnhancedVerification()">
                   <i class="fa fa-user-shield"></i> Override
               </button>
           </div>
       </div>
   `);
   
   logDiagnostic(`Verification error: ${message}`, 'error');
}

function getSecuGenErrorMessage(errorCode) {
   const errorMessages = {
       0: 'Success',
       1: 'Device not found',
       2: 'Invalid device',
       3: 'Device busy',
       4: 'Capture timeout',
       5: 'Poor image quality',
       6: 'Device error',
       7: 'Invalid parameter',
       8: 'Memory error',
       9: 'File error',
       10: 'Invalid template',
       11: 'Function not supported',
       12: 'License error',
       13: 'SDK not initialized'
   };
   return errorMessages[errorCode] || `Unknown error (${errorCode})`;
}

// =============================================
// ENHANCED EVENT HANDLERS
// =============================================

function initializeEvents() {
  // Patient selection
  $('#consultation_patient_search').on('change', function() {
      const patientId = $(this).val();
      if (patientId) {
          loadEnhancedPatientDetails(patientId);
      } else {
          $('#patientDetailsSection').hide();
          resetEnhancedVerificationState();
      }
  });
  
// Prescription events - ADD THESE
    $(document).on('click', '#addPrescriptionBtn', function(e) {
        e.preventDefault();
        addToPrescription();
    });
    
    $(document).on('click', '#addToPrescriptionBtn', function(e) {
        e.preventDefault();
        addToPrescription();
    });
    
    // Prescription modal form events
    $('#prescriptionQuantity').on('input change', updateCostCalculation);
    
    $('#dosageInstructions').on('change', function() {
        if ($(this).val() === 'custom') {
            $('#customDosageGroup').show();
            $('#customDosage').focus();
        } else {
            $('#customDosageGroup').hide();
        }
    });
  
   // Barcode print handler
   $(document).on('click', '#printBarcodeBtn', function() {
       printPatientBarcode();
   });
  
  // SecuGen fingerprint operations
  $('#manualVerifyBtn').on('click', function(e) {
      e.preventDefault();
      captureFingerprint();
  });

  $('#verifyIdentity').on('click', function(e) {
      e.preventDefault();
      performBiometricVerification();
  });
  
  // Verification controls
  $('#skipVerificationBtn').on('click', function() {
      skipEnhancedVerification();
  });
  
  $('#clearCaptureData').on('click', function() {
      clearEnhancedCaptureData();
  });
  
  // Patient action buttons
  $('#startConsultationBtn').on('click', function() {
      startEnhancedConsultation();
  });
  
  $('#reviewPatientBtn').on('click', function() {
      reviewPatientHistory();
  });
  
  // Patient review modal actions
  $('#printPatientSummary').on('click', function() {
      printPatientSummary();
  });
  
  $('#startNewConsultationFromReview').on('click', function() {
      startNewConsultationFromReview();
  });
  
  // Lab tests selection (OPTIONAL)
  $(document).on('change', '.lab-test-checkbox', function() {
      updateSelectedTestsSummary();
  });
  
  $('#selectAllTests').on('click', function() {
      const activeTab = $('.tab-pane.active');
      activeTab.find('.lab-test-checkbox').prop('checked', true);
      updateSelectedTestsSummary();
      showModernMessage('All tests in current category selected (optional)', 'info');
  });
  
  $('#clearAllTests').on('click', function() {
      $('.lab-test-checkbox').prop('checked', false);
      updateSelectedTestsSummary();
      showModernMessage('All test selections cleared', 'info');
  });
  
  // Diagnosis selection events (NON-GCC ONLY)
  $('#consultationDiagnosis').on('change', function() {
      const selectedValue = $(this).val();
      if (selectedValue) {
          selectDiagnosis(selectedValue);
      } else {
          $('#selectedDiagnosisInfo').hide();
          window.consultationState.selectedDiagnosis = null;
      }
  });
  
  $('#addCustomDiagnosis').on('click', function() {
      showCustomDiagnosis();
  });
  
  $('#clearDiagnosis').on('click', function() {
      clearDiagnosis();
  });
  
  // Form submissions
  $('#consultationForm').on('submit', function(e) {
      e.preventDefault();
      saveEnhancedConsultation();
  });
  
  $(document).on('click', '.btn[onclick*="openPrescriptionModal"]', function(e) {
    e.preventDefault();
    // Extract drugId and drugName from onclick attribute if needed
    const onclick = $(this).attr('onclick');
    if (onclick) {
        // This will execute the onclick function
        eval(onclick);
    }
});
  
  logDiagnostic('Enhanced event handlers configured', 'success');
}

// =============================================
// UTILITY FUNCTIONS
// =============================================

function loadStoredFingerprintTemplate(patientId, hasFingerprint) {
  if (!hasFingerprint) {
      $('#storedTemplateDetails').html('<span class="text-muted">No fingerprint template stored</span>');
      return;
  }
  
  logDiagnostic(`🔐 Patient has fingerprint - fetching stored template for patient ID: ${patientId}`, 'info');
  
  $('#storedTemplateDetails').html(`
      <div class="text-center">
          <div class="spinner-modern"></div> Loading template...
      </div>
  `);
  
  $.ajax({
      url: window.consultationConfig.baseURL + window.consultationConfig.endpoints.getStoredTemplate,
      type: 'POST',
      data: { patient_id: patientId },
      dataType: 'json',
      timeout: 10000,
      success: function(response) {
          logDiagnostic('📥 Stored template response received', 'info');
          console.log('Full template response:', response);
          handleStoredTemplateResponse(response);
      },
      error: function(xhr, status, error) {
          logDiagnostic(`❌ Failed to fetch stored template: ${error}`, 'error');
          handleStoredTemplateError(xhr, status, error);
      }
  });
}

function handleStoredTemplateResponse(response) {
  try {
      if (response && response.status === 'success') {
          if (response.fingerprint_template && response.fingerprint_template.length > 0) {
              window.consultationState.storedTemplate = response.fingerprint_template;
              window.consultationState.selectedPatientData.stored_template = response.fingerprint_template;
              $('#patientStoredTemplate').val(response.fingerprint_template);
              
              if (response.fingerprint_image && response.fingerprint_image.length > 0) {
                  $('#storedFingerprintImage').attr('src', 'data:image/bmp;base64,' + response.fingerprint_image);
              }
              
              $('#storedTemplateDetails').html(`
                  <span class="text-success">✅ Template loaded (${response.fingerprint_template.length} chars)</span>
              `);
              
              logDiagnostic(`✅ Stored template loaded successfully: ${response.fingerprint_template.length} characters`, 'success');
          } else {
              $('#storedTemplateDetails').html('<span class="text-warning">⚠️ No template found in database</span>');
              logDiagnostic('⚠️ No stored template found for this patient', 'warning');
          }
      } else {
          const errorMsg = response.message || 'Unknown error occurred';
          $('#storedTemplateDetails').html(`<span class="text-danger">❌ Error: ${errorMsg}</span>`);
          logDiagnostic(`❌ Template fetch error: ${errorMsg}`, 'error');
      }
  } catch (error) {
      logDiagnostic(`❌ Error processing template response: ${error.message}`, 'error');
      $('#storedTemplateDetails').html('<span class="text-danger">❌ Failed to process response</span>');
  }
}

function handleStoredTemplateError(xhr, status, error) {
  let errorMessage = 'Failed to load stored fingerprint template';
  
  if (xhr.status === 404) {
      errorMessage = 'Template endpoint not found (404)';
  } else if (xhr.status === 500) {
      errorMessage = 'Server error loading template (500)';
  } else if (xhr.status === 0) {
      errorMessage = 'Network error - cannot connect to server';
  } else if (status === 'timeout') {
      errorMessage = 'Request timeout - server response too slow';
  }
  
  $('#storedTemplateDetails').html(`<span class="text-danger">❌ ${errorMessage}</span>`);
  logDiagnostic(`❌ Template fetch error: ${errorMessage}`, 'error');
  
  showModernMessage('⚠️ Could not load stored template - Manual mode still available', 'warning');
}

function loadPatientConsultations(patientId) {
  // Load recent consultations for this patient
  $('#recentConsultations').html('<p class="text-muted"><i class="fa fa-spinner fa-spin"></i> Loading consultations...</p>');
  
  // Simulate loading (replace with real AJAX call)
  setTimeout(() => {
      $('#recentConsultations').html('<p class="text-muted">No previous consultations found</p>');
  }, 1000);
}

function enhancePatientCard(patientData) {
  const card = $('#patientDetailsCard');
  
  card.removeClass('verified gcc-patient gcc-unverified');
  
  if (window.consultationState.isGCCPatient) {
      if (window.consultationState.verificationPassed) {
          card.addClass('verified gcc-patient');
          $('#workflowStatusPanel').removeClass('gcc-unverified').addClass('gcc-workflow');
          $('#workflowBadge').text('GCC Patient - Verified').removeClass().addClass('workflow-badge status-gcc');
      } else {
          card.addClass('gcc-unverified');
          $('#workflowStatusPanel').removeClass('gcc-workflow').addClass('gcc-unverified');
          $('#workflowBadge').text('GCC Patient - Verification Required').removeClass().addClass('workflow-badge status-required');
      }
  } else {
      $('#workflowBadge').text('General Patient').removeClass().addClass('workflow-badge status-general');
  }
}

function resetEnhancedVerificationState() {
  window.consultationState.verificationPassed = false;
  window.consultationState.storedTemplate = null;
  window.consultationState.liveTemplate = null;
  window.consultationState.currentMatchScore = 0;
  window.consultationState.verificationQuality = 'Unknown';
  
  $('#verificationPassed').val('0');
  $('#verificationStatus').html('');
  
  $("#fingerprintStatus").html(`
      <div class="status-info">
          <i class="fa fa-info-circle"></i> Ready for SecuGen biometric verification - Consultation Module
      </div>
  `);
  
  $('#storedFingerprintImage, #liveFingerprintImage').attr('src', './Images/PlaceFinger.bmp');
  $('#storedTemplateDetails').text('No template loaded');
  $('#liveTemplateDetails').text('Ready for capture');
  
  $('#manualVerifyBtn').prop('disabled', false);
  $('#verifyIdentity').prop('disabled', true);
  
  $('#patientStoredTemplate, #liveScannedTemplate').val('');
  window.consultationState.verificationHistory = [];
  updateVerificationHistoryDisplay();
}

function skipEnhancedVerification() {
  if (window.consultationState.requiresVerification) {
      const confirmMessage = `This is a GCC patient requiring biometric verification.\n\nAre you sure you want to proceed with admin override?`;
      if (!confirm(confirmMessage)) {
          return;
      }
      
      window.consultationState.verificationPassed = true;
      $('#verificationPassed').val('1');
      
      $('#verificationStatus').html('<span class="status-indicator status-warning"><i class="fa fa-user-shield"></i> GCC Admin Override</span>');
      
      $("#fingerprintStatus").html(`
          <div class="status-warning">
              <i class="fa fa-shield"></i> <strong>ENHANCED GCC verification bypassed - Admin override active</strong><br>
              <small>Biometric verification skipped by administrator for GCC patient</small>
          </div>
      `);
      
      $('#startConsultationBtn').prop('disabled', false);
      $('#reviewPatientBtn').prop('disabled', false);
      updateStepIndicator('consult');
      
      // Update workflow status
      $('#workflowStatusPanel').removeClass('gcc-unverified').addClass('gcc-workflow');
      $('#workflowBadge').text('GCC Patient - Admin Override').removeClass().addClass('workflow-badge status-warning');
      $('#currentPatientStatus').html(`
          <p style="margin: 0; font-size: 12px; color: white;">
              <i class="fa fa-user-shield"></i> <strong>Admin Override Active</strong><br>
              GCC verification bypassed by administrator
          </p>
      `);
      
      addToVerificationHistory('Admin Override', 0, 'Bypassed');
      showModernMessage('ENHANCED GCC verification bypassed - Admin override active', 'warning');
      
  } else {
      showModernMessage('Verification not required for this patient type', 'info');
  }
}

function clearEnhancedCaptureData() {
  window.consultationState.liveTemplate = null;
  $('#liveScannedTemplate').val('');
  $('#liveFingerprintImage').attr('src', './Images/PlaceFinger.bmp');
  $('#liveTemplateDetails').text('Ready for capture');
  $('#liveFingerprintContainer').removeClass('active');
  
  $("#fingerprintStatus").html(`
      <div class="status-info">
          <i class="fa fa-info-circle"></i> Enhanced capture data cleared - Ready for new verification
      </div>
  `);
  
  $('#verifyIdentity').prop('disabled', true);
  
  if (window.consultationState.storedTemplate) {
      showModernMessage('Live capture cleared. Use Manual Print Capture to scan fingerprint again.', 'info');
  }
}

// Add this debug function to test modal opening
window.testModalOpening = function() {
    console.log('🧪 Testing modal opening...');
    
    // Check if modal exists
    const modalExists = $('#drugSelectionModal').length > 0;
    console.log('Modal exists:', modalExists);
    
    if (!modalExists) {
        console.error('❌ drugSelectionModal not found in DOM!');
        return;
    }
    
    // Test opening with sample data
    const testDrug = {
        id: 'TEST001',
        medicine_name: 'Test Drug',
        category: 'Test Category',
        composition: 'Test Composition',
        unit: 'Tablet',
        sale_rate: 10.00,
        available_quantity: 50
    };
    
    // Add to search results
    window.prescriptionState = window.prescriptionState || {};
    window.prescriptionState.searchResults = [testDrug];
    
    // Try to open modal
    openPrescriptionModal('TEST001', 'Test Drug');
};

function updateModalCost() {
    const quantity = parseInt($('#prescriptionQuantity').val()) || 0;
    const unitPriceText = $('#modalMedicineUnitPrice').text().replace('KES ', '');
    const unitPrice = parseFloat(unitPriceText) || 0;
    const totalCost = quantity * unitPrice;
    $('#totalCost').text('KES ' + totalCost.toFixed(2));
}

// =============================================
// VERIFICATION HISTORY MANAGEMENT
// =============================================

function addToVerificationHistory(result, score, quality) {
  const timestamp = new Date().toLocaleTimeString();
  const patientName = $('#patientName').text() || 'Unknown';
  
  const historyItem = {
      timestamp: timestamp,
      patient: patientName,
      result: result,
      score: score,
      quality: quality,
      method: result === 'Admin Override' ? 'Admin Override' : 'SecuGen SGIMatchScore',
      workflowType: window.consultationState.patientWorkflowType || 'General',
      isGCCPatient: window.consultationState.isGCCPatient
  };
  
  window.consultationState.verificationHistory.unshift(historyItem);
  
  if (window.consultationState.verificationHistory.length > 10) {
      window.consultationState.verificationHistory.pop();
  }
  
  updateVerificationHistoryDisplay();
}

function updateVerificationHistoryDisplay() {
  let html = '';
  
  if (window.consultationState.verificationHistory.length === 0) {
      html = '<p class="text-muted">No verification attempts yet</p>';
  } else {
      window.consultationState.verificationHistory.forEach(item => {
          const resultClass = item.result === 'Success' ? 'text-success' : 
                            item.result === 'Admin Override' ? 'text-warning' : 'text-danger';
          const resultIcon = item.result === 'Success' ? 'fa-check' : 
                           item.result === 'Admin Override' ? 'fa-user-shield' : 'fa-times';
          
          const workflowBadge = item.isGCCPatient ? 
              '<span class="label label-warning" style="font-size: 9px;">GCC</span>' : 
              '<span class="label label-info" style="font-size: 9px;">GEN</span>';
          
          html += `
              <div style="border-left: 3px solid ${item.result === 'Success' ? '#5cb85c' : 
                                                 item.result === 'Admin Override' ? '#f0ad4e' : '#d9534f'}; 
                     padding: 8px; margin-bottom: 8px; background-color: #f9f9f9; border-radius: 3px;">
                  <div class="${resultClass}">
                      <i class="fa ${resultIcon}"></i> <strong>${item.result}</strong> ${workflowBadge}
                      <small class="pull-right">${item.timestamp}</small>
                  </div>
                  <small>Score: ${item.score}/199 | Quality: ${item.quality}</small><br>
                  <small class="text-muted">${item.method}</small>
              </div>
          `;
      });
  }
  
  $('#verificationHistory').html(html);
}

// =============================================
// BARCODE GENERATION FUNCTIONS
// =============================================

function generatePatientBarcode(patient) {
   console.log('🏷️ Generating enhanced barcode for patient:', patient);
   
   try {
       // Create comprehensive barcode data
       let barcodeData = createBarcodeData(patient);
       
       if (barcodeData) {
           // Generate the barcode with optimized settings
           JsBarcode("#patientBarcode", barcodeData, {
               format: "CODE128",
               width: 1,              
               height: 40,            
               displayValue: true,
               fontSize: 9,           
               margin: 5,             
               background: "#ffffff",
               lineColor: "#000000",
               textAlign: "center",
               textPosition: "bottom",
               fontOptions: "bold"
           });
           
           // Parse the data for display
           const parsedData = parseBarcodeData(barcodeData);
           
           // Display comprehensive barcode information
           $('#barcodeData').html(`
               <div style="text-align: left; font-size: 9px; line-height: 1.3;">
                   <strong style="font-size: 10px;">Barcode Information:</strong><br>
                   <strong>Patient:</strong> ${parsedData.patientName}<br>
                   <strong>ID:</strong> ${parsedData.patientId}<br>
                   <strong>Generated:</strong> ${parsedData.timestamp}<br>
                   <strong>Raw Data:</strong> <code style="font-size: 8px; word-break: break-all;">${barcodeData}</code>
               </div>
           `);
           
           console.log('✅ Enhanced barcode generated successfully');
           console.log('Barcode contains:', parsedData);
       } else {
           // Show error message
           $('#patientBarcode').parent().html(`
               <div class="text-center text-muted">
                   <i class="fa fa-exclamation-triangle"></i><br>
                   <small>Cannot generate barcode - missing patient data</small>
               </div>
           `);
       }
       
   } catch (error) {
       console.error('❌ Enhanced barcode generation error:', error);
       $('#patientBarcode').parent().html(`
           <div class="text-center text-danger">
               <i class="fa fa-times-circle"></i><br>
               <small>Barcode generation failed: ${error.message}</small>
           </div>
       `);
   }
}

function createBarcodeData(patient) {
   // Get current date and time
   const now = new Date();
   const dateStr = now.toISOString().split('T')[0]; // YYYY-MM-DD format
   const timeStr = now.toTimeString().split(' ')[0].substring(0, 5); // HH:MM format
   const timestamp = dateStr + ' ' + timeStr;
   
   // Get patient identification (priority order)
   let patientId = patient.identification_number || 
                  patient.patient_unique_id || 
                  patient.id || 
                  'UNK';
   
   // Get patient name (clean and truncate if needed)
   let patientName = (patient.patient_name || 'UNKNOWN').toUpperCase();
   
   // Remove special characters and limit length for barcode compatibility
   patientName = patientName.replace(/[^A-Z0-9\s]/g, '').substring(0, 20);
   patientId = String(patientId).replace(/[^A-Z0-9]/g, '').substring(0, 15);
   
   // Create structured barcode data
   // Format: NAME|ID|DATETIME
   let barcodeData = `${patientName}|${patientId}|${timestamp}`;
   
   // Ensure barcode data is not too long (CODE128 practical limit ~80 chars)
   if (barcodeData.length > 80) {
       // Truncate name further if needed
       const maxNameLength = 80 - patientId.length - timestamp.length - 2; // -2 for separators
       if (maxNameLength > 5) { // Minimum 5 chars for name
           patientName = patientName.substring(0, maxNameLength);
           barcodeData = `${patientName}|${patientId}|${timestamp}`;
       } else {
           // If still too long, use minimal format
           barcodeData = `${patientId}|${timestamp}`;
       }
   }
   
   console.log('Generated barcode data:', barcodeData);
   return barcodeData;
}

function parseBarcodeData(barcodeData) {
   try {
       const parts = barcodeData.split('|');
       
       if (parts.length === 3) {
           return {
               patientName: parts[0],
               patientId: parts[1],
               timestamp: parts[2],
               format: 'full'
           };
       } else if (parts.length === 2) {
           return {
               patientName: 'Not encoded',
               patientId: parts[0],
               timestamp: parts[1],
               format: 'minimal'
           };
       } else {
           return {
               patientName: 'Unknown',
               patientId: 'Unknown',
               timestamp: 'Unknown',
               format: 'invalid'
           };
       }
   } catch (error) {
       console.error('Error parsing barcode data:', error);
       return null;
   }
}

function printPatientBarcode() {
   console.log('🖨️ Printing optimized patient barcode...');
   
   const barcodeContainer = document.getElementById('patientBarcode').parentElement;
   const patientName = $('#patientName').text();
   
   // Create optimized print content for standard paper sizes
   const printContent = `
       <!DOCTYPE html>
       <html>
       <head>
           <title>Patient Barcode - ${patientName}</title>
           <style>
               body { 
                   font-family: Arial, sans-serif; 
                   text-align: center; 
                   margin: 10px;
                   background: white;
                   font-size: 12px;
               }
               .barcode-print-container {
                   border: 1px solid #000;
                   padding: 10px;
                   margin: 10px auto;
                   max-width: 300px;
                   background: white;
                   page-break-inside: avoid;
               }
               .patient-info {
                   margin-bottom: 8px;
                   font-size: 11px;
                   font-weight: bold;
                   line-height: 1.2;
               }
               .barcode-info {
                   margin-top: 8px;
                   font-size: 8px;
                   color: #666;
                   line-height: 1.1;
               }
               svg {
                   margin: 5px 0;
                   max-width: 100%;
                   height: auto;
               }
               
               @media print {
                   body { 
                       margin: 0; 
                       padding: 5px;
                       font-size: 10px;
                   }
                   .barcode-print-container { 
                       border: 1px solid #000; 
                       margin: 0; 
                       padding: 8px;
                       max-width: 280px;
                       box-shadow: none;
                   }
                   .patient-info {
                       font-size: 10px;
                       margin-bottom: 6px;
                   }
                   .barcode-info {
                       font-size: 7px;
                       margin-top: 6px;
                   }
                   svg {
                       margin: 3px 0;
                   }
                   
                   @page {
                       margin: 0.5in;
                       size: auto;
                   }
               }
           </style>
       </head>
       <body>
           <div class="barcode-print-container">
               <div class="patient-info">
                   Patient: ${patientName}<br>
                   ID: ${window.consultationState.selectedPatientId}<br>
                   Type: ${window.consultationState.patientWorkflowType}
               </div>
               ${barcodeContainer.outerHTML}
               <div class="barcode-info">
                   Generated: ${new Date().toLocaleDateString()}<br>
                   Enhanced Consultation System
               </div>
           </div>
       </body>
       </html>
   `;
   
   // Open print window with optimized settings
   const printWindow = window.open('', '_blank');
   printWindow.document.write(printContent);
   printWindow.document.close();
   
   // Wait for content to load then print
   printWindow.onload = function() {
       setTimeout(() => {
           printWindow.print();
           printWindow.close();
       }, 500);
   };
}

// =============================================
// MODERN UI ENHANCEMENTS
// =============================================

function initializeModernAnimations() {
  // Add fade-in animation to panels
  $('.consultation-panel').each(function(index) {
      $(this).delay(index * 200).queue(function() {
          $(this).addClass('fade-in').dequeue();
      });
  });
}

function updateStepIndicator(currentStep) {
  const steps = ['search', 'verify', 'consult', 'save'];
  const currentIndex = steps.indexOf(currentStep);
  
  $('.step').removeClass('active completed');
  
  for (let i = 0; i <= currentIndex; i++) {
      const stepElement = $(`#step-${steps[i]}`);
      if (i < currentIndex) {
          stepElement.addClass('completed');
      } else {
          stepElement.addClass('active');
      }
  }
  
  // Add animation effect
  $(`#step-${currentStep}`).addClass('pulse-highlight');
  setTimeout(() => {
      $(`#step-${currentStep}`).removeClass('pulse-highlight');
  }, 2000);
}

function showModernMessage(message, type = 'info', duration = 5000) {
  const iconMap = {
      'success': 'check-circle',
      'warning': 'exclamation-triangle', 
      'error': 'times-circle',
      'info': 'info-circle'
  };
  
  const alertClass = `alert-${type === 'error' ? 'danger' : type}-modern`;
  const icon = iconMap[type] || 'info-circle';
  
  const html = `
      <div class="${alertClass} fade-in" style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 320px; max-width: 400px; box-shadow: 0 8px 25px rgba(0,0,0,0.15);">
          <button type="button" class="close" onclick="$(this).parent().fadeOut()">&times;</button>
          <i class="fa fa-${icon}"></i> ${message}
      </div>
  `;
  
  $('body').append(html);
  
  setTimeout(() => {
      $('.alert-success-modern, .alert-info-modern, .alert-warning-modern, .alert-danger-modern').fadeOut(function() {
          $(this).remove();
      });
  }, duration);
}

function logDiagnostic(message, type = 'info') {
  const timestamp = new Date().toLocaleTimeString();
  const colorClass = type === 'error' ? 'text-danger' : 
                    type === 'success' ? 'text-success' : 
                    type === 'warning' ? 'text-warning' : 'text-info';
  
  console.log(`[ENHANCED-Consultation] ${message}`);
}

function searchDrugs() {
    const searchTerm = $('#drugSearchInput').val().trim();
    const category = $('#drugCategoryFilter').val();
    
    if (searchTerm.length < 2 && !category) {
        showMessage('Please enter at least 2 characters or select a category', 'warning');
        return;
    }
    
    showLoadingState('#drugSearchResults', 'Searching medications...');
    $('#drugSearchResults').show();
    
    $.ajax({
        url: base_url + 'admin/consultation/searchDrugsForPrescription',
        type: 'POST',
        data: {
            search_term: searchTerm,
            category: category
        },
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                window.prescriptionState.searchResults = response.drugs;
                displayDrugSearchResults(response.drugs);
            } else {
                $('#drugSearchResults').html('<div class="alert alert-warning">No drugs found matching your search</div>');
            }
        },
        error: function() {
            $('#drugSearchResults').html('<div class="alert alert-danger">Error searching drugs. Please try again.</div>');
        }
    });
}

function loadAllDrugs() {
    showLoadingState('#drugSearchResults', 'Loading all medications...');
    $('#drugSearchResults').show();
    
    $.ajax({
        url: base_url + 'admin/consultation/getAllDrugsForPrescription',
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                window.prescriptionState.searchResults = response.drugs;
                displayDrugSearchResults(response.drugs);
            } else {
                $('#drugSearchResults').html('<div class="alert alert-warning">No drugs available</div>');
            }
        },
        error: function() {
            $('#drugSearchResults').html('<div class="alert alert-danger">Error loading drugs. Please try again.</div>');
        }
    });
}

function filterByCategory() {
    const category = $('#drugCategoryFilter').val();
    const searchTerm = $('#drugSearchInput').val().trim();
    
    if (category || searchTerm.length >= 2) {
        searchDrugs();
    }
}

function displayDrugSearchResults(drugs) {
    let html = '<div class="drug-results-list" style="max-height: 300px; overflow-y: auto; border: 1px solid #dee2e6; border-radius: 4px;">';
    
    if (drugs.length === 0) {
        html += '<div class="text-center text-muted" style="padding: 20px;">No medications found</div>';
    } else {
        drugs.forEach(function(drug) {
            const stockStatus = drug.available_quantity > 0 ? 
                `<span class="text-success">${drug.available_quantity} available</span>` :
                '<span class="text-danger">Out of stock</span>';
            
            const isDisabled = drug.available_quantity <= 0 ? 'disabled' : '';
            
            html += `
                <div class="drug-result-item" style="padding: 10px; border-bottom: 1px solid #f0f0f0; display: flex; justify-content: between; align-items: center;">
                    <div style="flex: 1;">
                        <div><strong>${drug.medicine_name}</strong></div>
                        <div style="font-size: 12px; color: #6c757d;">
                            ${drug.medicine_category} | ${drug.medicine_composition || 'N/A'} | 
                            KES ${parseFloat(drug.sale_rate || 0).toFixed(2)} per ${drug.unit_name || 'unit'}
                        </div>
                        <div style="font-size: 12px;">${stockStatus}</div>
                    </div>
                    <div>
                        <button type="button" class="btn btn-sm btn-primary" 
                                onclick="openPrescriptionModal('${drug.id}', '${drug.medicine_name.replace(/'/g, "\\'")}')">
                            <i class="fa fa-plus"></i> Prescribe
                        </button>
                    </div>
                </div>
            `;
        });
    }
    
    html += '</div>';
    $('#drugSearchResults').html(html);
}

function openPrescriptionModal(drugId, drugName) {
    console.log('🎯 Opening prescription modal for drug:', drugId, drugName);
    
    // FIX: Better error checking and logging
    console.log('Available search results:', window.prescriptionState?.searchResults?.length || 0);
    console.log('Search results:', window.prescriptionState?.searchResults);
    
    if (!window.prescriptionState || !window.prescriptionState.searchResults) {
        console.error('❌ prescriptionState.searchResults not initialized');
        showModernMessage('Search results not available. Please search for drugs first.', 'error');
        return;
    }
    
    // Find drug in search results with better matching
    let drug = window.prescriptionState.searchResults.find(d => 
        d.id == drugId || d.medicine_id == drugId || d.drug_id == drugId
    );
    
    if (!drug) {
        console.error('❌ Drug not found in search results. DrugId:', drugId);
        console.log('Available drugs:', window.prescriptionState.searchResults.map(d => ({id: d.id, name: d.medicine_name})));
        
        // FIX: Create a basic drug object if not found in search results
        drug = {
            id: drugId,
            medicine_name: drugName,
            category: 'Unknown',
            composition: 'N/A',
            unit: 'unit',
            sale_rate: 0,
            available_quantity: 0
        };
        
        showModernMessage('Drug details not found in search results. Using basic information.', 'warning');
    }
    
    console.log('✅ Found drug data:', drug);
    
    // Populate modal with drug information
    $('#modalDrugName').text(drugName);
    $('#modalDrugId').val(drug.id || drug.medicine_id || drug.drug_id);
    $('#modalDrugNameDisplay').text(drug.medicine_name || drug.name || drugName);
    $('#modalDrugCategory').text(drug.category || drug.medicine_category || 'N/A');
    $('#modalDrugComposition').text(drug.composition || drug.medicine_composition || 'N/A');
    $('#modalDrugUnit').text(drug.unit_name || drug.unit || 'unit');
    $('#modalDrugStock').text(drug.available_quantity || drug.available_qty || drug.stock || 0);
    $('#modalDrugPrice').text(parseFloat(drug.sale_rate || drug.price || 0).toFixed(2));
    $('#modalDrugSaleRate').val(drug.sale_rate || drug.price || 0);
    $('#modalDrugAvailableStock').val(drug.available_quantity || drug.available_qty || drug.stock || 0);
    
    // Update unit display in form
    $('#prescriptionUnit').text(drug.unit_name || drug.unit || 'units');
    
    // Reset form to defaults
    resetPrescriptionModalForm();
    
    // Update cost calculation
    updateCostCalculation();
    
    // Show the modal
    $('#drugSelectionModal').modal('show');
    
    console.log('✅ Prescription modal opened successfully');
}

window.debugDrugSelection = function(drugId, drugName) {
    console.log('🔍 Debugging drug selection...');
    console.log('DrugId:', drugId);
    console.log('DrugName:', drugName);
    console.log('prescriptionState exists:', !!window.prescriptionState);
    console.log('searchResults exists:', !!window.prescriptionState?.searchResults);
    console.log('searchResults length:', window.prescriptionState?.searchResults?.length || 0);
    
    if (window.prescriptionState?.searchResults?.length > 0) {
        console.log('First drug in results:', window.prescriptionState.searchResults[0]);
        console.log('All drug IDs:', window.prescriptionState.searchResults.map(d => d.id || d.medicine_id || d.drug_id));
    }
    
    // Try to find the drug
    const drug = window.prescriptionState?.searchResults?.find(d => 
        d.id == drugId || d.medicine_id == drugId || d.drug_id == drugId
    );
    
    console.log('Found drug:', drug);
    
    if (drug) {
        console.log('✅ Drug found - can proceed with modal');
        openPrescriptionModal(drugId, drugName);
    } else {
        console.log('❌ Drug not found - need to check data structure');
    }
};

// Add this debug version of the search function
window.debugSearchDrugs = function() {
    console.log('🧪 Debug search drugs...');
    
    $.ajax({
        url: getBaseUrl() + 'admin/pharmacy/searchDrugsForPrescription',
        type: 'POST',
        data: { search_term: 'para' }, // Search for paracetamol or similar
        dataType: 'json',
        success: function(response) {
            console.log('🔍 Full server response:', response);
            console.log('Response status:', response.status);
            console.log('Drugs array:', response.drugs);
            
            if (response.drugs && response.drugs.length > 0) {
                console.log('First drug structure:', response.drugs[0]);
                console.log('Available fields:', Object.keys(response.drugs[0]));
            }
        },
        error: function(xhr, status, error) {
            console.error('❌ Search failed:', error);
            console.log('Response text:', xhr.responseText);
        }
    });
};

function resetPrescriptionModalForm() {
    $('#prescriptionQuantity').val(1);
    $('#dosageInstructions').val('').prop('selectedIndex', 0);
    $('#customDosageGroup').hide();
    $('#customDosage').val('');
    $('#prescriptionDuration').val(7);
    $('#durationUnit').val('days');
    $('#administrationTime').val('').prop('selectedIndex', 0);
    $('#specialInstructions').val('');
}

function updateCostCalculation() {
    const quantity = parseInt($('#prescriptionQuantity').val()) || 1;
    const unitPrice = parseFloat($('#modalDrugSaleRate').val()) || 0;
    const totalCost = quantity * unitPrice;
    
    $('#costUnitPrice').text(unitPrice.toFixed(2));
    $('#costQuantity').text(quantity);
    $('#totalMedicationCost').text(totalCost.toFixed(2));
}

function addPrescriptionToDrugList() {
    // Validate form
    const quantity = parseInt($('#prescriptionQuantity').val());
    const dosage = $('#dosageInstructions').val() === 'custom' ? 
        $('#customDosage').val() : $('#dosageInstructions').val();
    const availableStock = parseInt($('#modalDrugAvailableStock').val());
    
    if (!quantity || quantity <= 0) {
        showMessage('Please enter a valid quantity', 'warning');
        return;
    }
    
    if (quantity > availableStock) {
        showMessage('Quantity cannot exceed available stock (' + availableStock + ')', 'warning');
        return;
    }
    
    if (!dosage) {
        showMessage('Please specify dosage instructions', 'warning');
        return;
    }
    
    // Create prescription object
    const prescription = {
        drug_id: $('#modalDrugId').val(),
        drug_name: $('#modalDrugNameDisplay').text(),
        category: $('#modalDrugCategory').text(),
        composition: $('#modalDrugComposition').text(),
        unit: $('#modalDrugUnit').text(),
        quantity: quantity,
        unit_price: parseFloat($('#modalDrugSaleRate').val()),
        total_cost: quantity * parseFloat($('#modalDrugSaleRate').val()),
        dosage_instructions: dosage,
        duration: $('#prescriptionDuration').val(),
        duration_unit: $('#durationUnit').val(),
        administration_time: $('#administrationTime').val(),
        special_instructions: $('#specialInstructions').val()
    };
    
    // Check if drug already prescribed
    const existingIndex = window.prescriptionState.selectedDrugs.findIndex(
        d => d.drug_id === prescription.drug_id
    );
    
    if (existingIndex !== -1) {
        if (confirm('This medication is already prescribed. Do you want to update the prescription?')) {
            window.prescriptionState.selectedDrugs[existingIndex] = prescription;
        } else {
            return;
        }
    } else {
        window.prescriptionState.selectedDrugs.push(prescription);
    }
    
    updatePrescriptionDisplay();
    $('#drugSelectionModal').modal('hide');
    showMessage('Medication added to prescription successfully', 'success');
}

function updatePrescriptionDisplay() {
    if (!window.selectedPrescriptions) {
        window.selectedPrescriptions = [];
    }

    const selectedMedicines = window.selectedPrescriptions;
    const totalCount = selectedMedicines.length;
    let totalCost = 0;
    
    selectedMedicines.forEach(medicine => {
        totalCost += parseFloat(medicine.totalCost || 0);
    });

    // Update count displays
    $('#selectedCount').text(totalCount);
    $('#totalMedicationsCount').text(totalCount);

    // Update the selected medicines display
    if (totalCount === 0) {
        $('#selectedMedicines').html('<p class="text-muted">No medications selected yet</p>');
    } else {
        let html = '';
        selectedMedicines.forEach((medicine, index) => {
            html += `
                <div class="prescription-item" style="border: 1px solid #ddd; padding: 10px; margin-bottom: 10px; border-radius: 4px;">
                    <div class="row">
                        <div class="col-md-8">
                            <strong>${medicine.name}</strong><br>
                            <small class="text-muted">${medicine.composition || ''}</small><br>
                            <small>
                                <strong>Dosage:</strong> ${medicine.dosage}<br>
                                <strong>Duration:</strong> ${medicine.duration} ${medicine.durationUnit}<br>
                                <strong>Quantity:</strong> ${medicine.quantity}
                            </small>
                        </div>
                        <div class="col-md-2 text-right">
                            <strong>KES ${parseFloat(medicine.totalCost || 0).toFixed(2)}</strong>
                        </div>
                        <div class="col-md-2 text-right">
                            <button class="btn btn-danger btn-xs" onclick="removePrescription(${index})">
                                <i class="fa fa-times"></i>
                            </button>
                        </div>
                    </div>
                </div>
            `;
        });
        $('#selectedMedicines').html(html);
    }

    // Update hidden form field
    $('#selectedPrescriptionsData').val(JSON.stringify(selectedMedicines));
}

function editPrescription(index) {
    const prescription = window.prescriptionState.selectedDrugs[index];
    
    // Find drug in search results or reload drug info
    openPrescriptionModal(prescription.drug_id, prescription.drug_name);
    
    // Pre-populate form with existing values
    setTimeout(function() {
        $('#prescriptionQuantity').val(prescription.quantity);
        $('#dosageInstructions').val(prescription.dosage_instructions);
        $('#prescriptionDuration').val(prescription.duration);
        $('#durationUnit').val(prescription.duration_unit);
        $('#administrationTime').val(prescription.administration_time);
        $('#specialInstructions').val(prescription.special_instructions);
        updateCostCalculation();
    }, 500);
}

function removePrescription(index) {
    if (confirm('Are you sure you want to remove this medication from the prescription?')) {
        window.prescriptionState.selectedDrugs.splice(index, 1);
        updatePrescriptionDisplay();
        showMessage('Medication removed from prescription', 'info');
    }
}

function clearAllPrescriptions() {
    if (window.prescriptionState.selectedDrugs.length === 0) {
        showMessage('No prescriptions to clear', 'info');
        return;
    }
    
    if (confirm('Are you sure you want to clear all selected medications?')) {
        window.prescriptionState.selectedDrugs = [];
        updatePrescriptionDisplay();
        showMessage('All prescriptions cleared', 'info');
    }
}

function generatePrescriptionNote() {
    const prescriptions = window.selectedPrescriptions || [];
    
    if (prescriptions.length === 0) {
        showModernMessage('No medications prescribed to generate note', 'warning');
        return;
    }
    
    let note = 'PRESCRIPTION:\n\n';
    
    prescriptions.forEach(function(prescription, index) {
        note += `${index + 1}. ${prescription.drug_name}\n`;
        note += `   Dosage: ${prescription.dosage_instructions}\n`;
        note += `   Duration: ${prescription.duration} ${prescription.duration_unit}\n`;
        note += `   Quantity: ${prescription.quantity} ${prescription.unit}\n`;
        if (prescription.administration_time) {
            note += `   Timing: ${prescription.administration_time}\n`;
        }
        if (prescription.special_instructions) {
            note += `   Special Instructions: ${prescription.special_instructions}\n`;
        }
        note += '\n';
    });
    
    const totalCost = prescriptions.reduce((sum, p) => sum + parseFloat(p.total_cost || 0), 0);
    note += `Total Estimated Cost: KES ${totalCost.toFixed(2)}\n\n`;
    note += 'General Instructions:\n';
    note += 'Take medications as prescribed by the doctor. Complete the full course even if you feel better.';
    
    // Insert into consultation notes
    const existingNotes = $('#consultationNotes').val();
    const separator = existingNotes ? '\n\n--- PRESCRIPTION ---\n\n' : '';
    $('#consultationNotes').val(existingNotes + separator + note);
    
    showModernMessage('Prescription note generated and added to consultation notes', 'success');
}

/**
 * Enhanced drug selection modal integration
 */
function addPrescriptionFromModal() {
    console.log('➕ Adding prescription from modal...');
    
    // Validate form inputs
    const quantity = parseInt($('#prescriptionQuantity').val());
    const dosageInstructions = $('#dosageInstructions').val() === 'custom' ? 
        $('#customDosage').val() : $('#dosageInstructions').val();
    const availableStock = parseInt($('#modalDrugAvailableStock').val()) || 0;
    
    // Validation
    if (!quantity || quantity <= 0) {
        showModernMessage('Please enter a valid quantity', 'warning');
        $('#prescriptionQuantity').focus();
        return;
    }
    
    if (quantity > availableStock && availableStock > 0) {
        showModernMessage(`Quantity cannot exceed available stock (${availableStock})`, 'warning');
        $('#prescriptionQuantity').focus();
        return;
    }
    
    if (!dosageInstructions) {
        showModernMessage('Please specify dosage instructions', 'warning');
        if ($('#dosageInstructions').val() === 'custom') {
            $('#customDosage').focus();
        } else {
            $('#dosageInstructions').focus();
        }
        return;
    }
    
    // Create prescription object
    const prescription = {
        drug_id: $('#modalDrugId').val(),
        drug_name: $('#modalDrugNameDisplay').text(),
        category: $('#modalDrugCategory').text(),
        composition: $('#modalDrugComposition').text(),
        unit: $('#modalDrugUnit').text(),
        quantity: quantity,
        unit_price: parseFloat($('#modalDrugSaleRate').val()) || 0,
        total_cost: quantity * (parseFloat($('#modalDrugSaleRate').val()) || 0),
        dosage_instructions: dosageInstructions,
        duration: $('#prescriptionDuration').val(),
        duration_unit: $('#durationUnit').val(),
        administration_time: $('#administrationTime').val(),
        special_instructions: $('#specialInstructions').val()
    };
    
    console.log('📋 Prescription object:', prescription);
    
    // Add to global prescriptions array
    addDrugToPrescriptionList(prescription);
    
    // Close modal
    $('#drugSelectionModal').modal('hide');
    
    // Show success message
    showModernMessage(`${prescription.drug_name} added to prescription`, 'success');
}

/**
 * Initialize prescription functionality
 */
function initializePrescriptionFunctionality() {
    console.log('🔬 Initializing prescription functionality...');
    
    // Initialize global prescriptions array
    window.selectedPrescriptions = window.selectedPrescriptions || [];
    
    // Hook into existing drug search functionality
    if (typeof searchDrugsForPrescription === 'function') {
        console.log('✅ Drug search functionality found');
    } else {
        console.warn('⚠️ Drug search functionality not found - prescription features may be limited');
    }
    
    // Hook into the drug selection modal
    $(document).on('click', '#addPrescriptionBtn', function() {
        addPrescriptionFromModal();
    });
    
    // Hook into form submission
    $(document).on('submit', '#consultationForm', function(e) {
        e.preventDefault();
        saveEnhancedConsultationWithPrescriptions();
    });
    
    console.log('✅ Prescription functionality initialized');
}

/**
 * Add prescription summary to modal setup
 */
function setupConsultationModalWithPrescriptions() {
    // Call existing modal setup
    if (typeof setupConsultationModal === 'function') {
        setupConsultationModal();
    }
    
    // Add prescription summary section if it doesn't exist
    if ($('#prescriptionSummarySection').length === 0) {
        const prescriptionSection = `
            <div class="consultation-panel" id="prescriptionSummarySection" style="margin: 15px 0;">
                <div class="panel-header">
                    <h5 class="panel-title">
                        <i class="fa fa-pills"></i> Prescribed Medications
                        <span class="pull-right">
                            <span class="label label-primary" id="totalPrescriptionsCount">0</span> medicines
                        </span>
                    </h5>
                </div>
                <div class="panel-body">
                    <div id="selectedPrescriptionsList">
                        <p class="text-muted">No medications prescribed yet</p>
                    </div>
                    <div class="row" style="margin-top: 15px;">
                        <div class="col-md-6">
                            <button type="button" class="btn btn-success btn-sm" onclick="generatePrescriptionNote()">
                                <i class="fa fa-file-text"></i> Add to Notes
                            </button>
                        </div>
                        <div class="col-md-6 text-right">
                            <strong>Total Cost: KES <span id="estimatedPrescriptionCost">0.00</span></strong>
                        </div>
                    </div>
                </div>
            </div>
        `;
        
        // Insert after lab tests section or before modal footer
        if ($('.lab-tests-panel').length > 0) {
            $('.lab-tests-panel').after(prescriptionSection);
        } else {
            $('.modal-body').append(prescriptionSection);
        }
    }
}

/**
 * Enhanced consultation modal setup
 */
function startEnhancedConsultationWithPrescriptions() {
    const patientId = $('#selectedPatientId').val();
    if (!patientId) {
        showModernMessage('Please select a patient first', 'warning');
        return;
    }
    
    // Check verification requirement
    if (window.consultationState.requiresVerification && !window.consultationState.verificationPassed) {
        const workflowType = window.consultationState.patientWorkflowType || 'GCC';
        showModernMessage(`${workflowType} patients must be verified before consultation`, 'warning');
        return;
    }
    
    // Setup modal with prescription support
    setupConsultationModalWithPrescriptions();
    
    // Initialize prescription display
    updateSelectedPrescriptionsDisplay();
}

function showLoadingState(selector, message) {
    $(selector).html(`
        <div class="text-center" style="padding: 20px;">
            <div class="spinner-modern"></div> ${message}
        </div>
    `);
}

function showMessage(message, type) {
    const alertClass = `alert-${type === 'error' ? 'danger' : type}`;
    const icon = type === 'success' ? 'check-circle' : 
                type === 'warning' ? 'exclamation-triangle' : 
                type === 'error' ? 'times-circle' : 'info-circle';
    
    const alert = $(`
        <div class="alert ${alertClass} alert-dismissible" style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 300px;">
            <button type="button" class="close" data-dismiss="alert">&times;</button>
            <i class="fa fa-${icon}"></i> ${message}
        </div>
    `);
    
    $('body').append(alert);
    
    setTimeout(function() {
        alert.fadeOut(function() {
            $(this).remove();
        });
    }, 5000);
}

// CSS for prescription styling
$('<style>')
    .prop('type', 'text/css')
    .html(`
        .prescription-drugs-panel {
            background: linear-gradient(135deg, #fff5f5 0%, #ffffff 100%);
            border: 1px solid #ffc0c0;
            border-radius: 8px;
            padding: 15px;
            margin: 15px 0;
        }
        
        .drug-search-results {
            margin-top: 10px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
            border-radius: 6px;
            background: white;
        }
        
        .drug-result-item:hover {
            background-color: #f8f9fa;
        }
        
        .prescription-item {
            transition: all 0.3s ease;
        }
        
        .prescription-item:hover {
            box-shadow: 0 2px 8px rgba(0,0,0,0.1);
        }
        
        .prescription-cost-panel {
            border-left: 4px solid #4caf50;
        }
        
        .modal-lg {
            max-width: 800px;
        }
        
        .drug-info-panel {
            border-left: 4px solid #2196f3;
        }
        
        @media (max-width: 768px) {
            .prescription-item .row {
                flex-direction: column;
            }
            
            .prescription-item .col-md-4 {
                margin-top: 10px;
                text-align: left !important;
            }
        }
    `)
    .appendTo('head');

// =============================================
// ENHANCED MODAL HANDLERS
// =============================================

$('#consultationModal').on('hidden.bs.modal', function() {
  resetConsultationForm();
  $('#modalTitle').text('Enhanced Consultation Assessment');
  $('#modalConsultationId').val('');
  $('#modalVerificationDetails').html('');
});

$('#patientReviewModal').on('hidden.bs.modal', function() {
  // Clear review data
  window.consultationState.patientReview = {
      consultations: [],
      labTests: [],
      triageHistory: [],
      verifications: [],
      summary: {}
  };
});

// =============================================
// ENHANCED DEBUG FUNCTIONS
// =============================================

window.ENHANCED_CONSULTATION_DEBUG = {
  checkSystemStatus: function() {
      const state = window.consultationState;
      
      console.log('📋 ENHANCED CONSULTATION SYSTEM STATUS:');
      console.log('👤 Selected Patient:', state.selectedPatientId);
      console.log('🔄 Patient Workflow:', state.patientWorkflow);
      console.log('🔒 Requires Verification:', state.requiresVerification);
      console.log('✅ Is Verified:', state.verificationPassed);
      console.log('🩺 Can Start Consultation:', !state.requiresVerification || state.verificationPassed);
      console.log('🔐 SecuGen Active:', state.secugenActive);
      console.log('📊 Match Score:', state.currentMatchScore);
      console.log('🧪 Lab Tests Required:', state.labTests.isRequired);
      console.log('📋 ICD Diagnosis Hidden for GCC:', state.isGCCPatient);
      console.log('🔬 ENHANCED Version: Optional Lab Tests + GCC Diagnosis Hiding + Patient Review');
      
      return {
          workflow: state.patientWorkflow,
          requiresVerification: state.requiresVerification,
          isVerified: state.verificationPassed,
          canStartConsultation: !state.requiresVerification || state.verificationPassed,
          secugenActive: state.secugenActive,
          labTestsOptional: !state.labTests.isRequired,
          diagnosisHiddenForGCC: state.isGCCPatient,
          uiMode: 'enhanced_modern_mode_with_review',
          enhancedVersion: true
      };
  },
  
  simulateGCCPatient: function() {
      console.log('🧪 Simulating ENHANCED GCC patient selection...');
      
      window.consultationState.patientWorkflow = 'gcc';
      window.consultationState.requiresVerification = true;
      window.consultationState.verificationRequired = true;
      window.consultationState.verificationPassed = false;
      window.consultationState.isGCCPatient = true;
      window.consultationState.patientWorkflowType = 'GCC Workflow';
      
      setupGCCPatientWorkflow();
      
      console.log('✅ ENHANCED GCC patient simulation complete - verification REQUIRED, diagnosis HIDDEN');
  },
  
  simulateGeneralPatient: function() {
      console.log('🧪 Simulating ENHANCED General patient selection...');
      
      window.consultationState.patientWorkflow = 'general';
      window.consultationState.requiresVerification = false;
      window.consultationState.verificationRequired = false;
      window.consultationState.verificationPassed = true;
      window.consultationState.isGCCPatient = false;
      window.consultationState.patientWorkflowType = 'General Workflow';
      
      setupGeneralPatientWorkflow();
      
      console.log('✅ ENHANCED General patient simulation complete - verification OPTIONAL, diagnosis VISIBLE');
  },
  
  getEnhancedState: function() {
      console.group('ENHANCED Consultation System State');
      console.log('Main State:', window.consultationState);
      console.log('SecuGen Config:', window.secugenConfig);
      console.log('Consultation Config:', window.consultationConfig);
      console.log('UI Mode:', 'ENHANCED Modern with Optional Lab Tests + GCC Diagnosis Hiding + Patient Review');
      console.log('Lab Tests Available:', Object.keys(window.consultationState.labTests.available).length);
      console.log('Selected Tests:', window.consultationState.labTests.selected.length);
      console.log('Lab Tests Required:', window.consultationState.labTests.isRequired);
      console.log('ICD Diagnosis Hidden for GCC:', window.consultationState.isGCCPatient);
      console.log('ENHANCED Version:', 'Optional Lab Tests + GCC Diagnosis Control + Patient History Review');
      console.groupEnd();
      return window.consultationState;
  }
};

// =============================================
// GLOBAL TEST FUNCTIONS
// =============================================

window.testRealCapture = function() {
  console.log('🔧 Global shortcut: Real capturing...');
  captureFingerprint();
};

window.testRealVerification = function() {
  console.log('🔧 Global shortcut: Real verifying...');
  performBiometricVerification();
};

window.testSecuGenConnection = function() {
  console.log('🔧 Global shortcut: Testing SecuGen connection...');
  testHttpsConnection();
};

window.showSecuGenState = function() {
  console.log('🔧 Global shortcut: Showing SecuGen state...');
  console.group('SecuGen State');
  console.log('Service Active:', window.secugenConfig.serviceActive);
  console.log('Device Connected:', window.secugenConfig.deviceConnected);
  console.log('Current Protocol:', window.secugenConfig.currentProtocol);
  console.log('Service URL:', window.secugenConfig.serviceURL);
  console.log('Stored Template:', window.consultationState.storedTemplate ? 'Present' : 'Not loaded');
  console.log('Live Template:', window.consultationState.liveTemplate ? 'Present' : 'Not captured');
  console.groupEnd();
};

// =============================================
// SYSTEM READY
// =============================================

console.log(`
╔══════════════════════════════════════════════════════════════════════════════╗
║            🔬 ENHANCED CONSULTATION SYSTEM - COMPLETE VERSION 🔬           ║
║         WITH OPTIONAL LAB TESTS + GCC DIAGNOSIS HIDING + PATIENT REVIEW    ║
╠══════════════════════════════════════════════════════════════════════════════╣
║                                                                              ║
║ ✅ NEW ENHANCEMENTS IMPLEMENTED:                                            ║
║ ✓ Laboratory tests are now OPTIONAL (not enforced)                          ║
║ ✓ ICD-10 diagnosis section HIDDEN for GCC patients                          ║
║ ✓ ICD-10 diagnosis section VISIBLE for General patients only                ║
║ ✓ Patient review functionality with complete history                        ║
║ ✓ Review includes: Consultations, Lab Tests, Triage, Verifications          ║
║ ✓ Patient summary statistics and timeline                                   ║
║ ✓ Print patient summary functionality                                       ║
║ ✓ Start consultation directly from review modal                             ║
║                                                                              ║
║ 🔒 GCC WORKFLOW ENHANCEMENTS:                                              ║
║ • GCC patients: ICD diagnosis section is HIDDEN                             ║
║ • GCC patients: Lab tests are optional (not mandatory)                      ║
║ • GCC patients: Biometric verification still required                       ║
║ • GCC patients: Can review complete history without verification            ║
║                                                                              ║
║ 🔓 GENERAL WORKFLOW ENHANCEMENTS:                                          ║
║ • General patients: ICD diagnosis section is VISIBLE                        ║
║ • General patients: Lab tests are optional (not mandatory)                  ║
║ • General patients: No verification required                                ║
║ • General patients: Full access to review and consultation                  ║
║                                                                              ║
║ 🔬 LAB TESTS - NOW OPTIONAL:                                               ║
║ • Consultation can be saved WITHOUT selecting any lab tests                 ║
║ • Lab test section styled as "OPTIONAL" with gray header                    ║
║ • Form validation does NOT check for lab test selection                     ║
║ • Success message indicates if tests were included or not                   ║
║                                                                              ║
║ 📋 PATIENT REVIEW FUNCTIONALITY:                                           ║
║ • Complete patient history accessible via "Review Patient History" button   ║
║ • Includes consultation history, lab results, triage visits, verifications  ║
║ • Summary statistics with totals and timeline information                   ║
║ • Print-friendly patient summary report                                     ║
║ • Direct consultation start from review modal                               ║
║                                                                              ║
║ 🚀 QUICK TEST COMMANDS:                                                    ║
║ ENHANCED_CONSULTATION_DEBUG.checkSystemStatus() - Check system status       ║
║ ENHANCED_CONSULTATION_DEBUG.simulateGCCPatient() - Test GCC workflow        ║
║ ENHANCED_CONSULTATION_DEBUG.simulateGeneralPatient() - Test General workflow║
║                                                                              ║
║ 💡 ENHANCED USAGE FLOW:                                                    ║
║ 1. Select patient → See workflow-specific UI                                ║
║ 2. Use "Review Patient History" to see complete medical history             ║
║ 3. Use "New Consultation" for new visit                                     ║
║ 4. GCC patients: No ICD diagnosis, verification required                    ║
║ 5. General patients: Full ICD diagnosis, no verification                    ║
║ 6. Lab tests are optional for ALL patient types                             ║
║ 7. Save consultation with or without lab tests                              ║
║                                                                              ║
╚══════════════════════════════════════════════════════════════════════════════╝

🔬 ENHANCED Consultation System Ready with ALL requested features! 🚀

New Features:
✅ Lab tests are now OPTIONAL (not enforced)
✅ ICD diagnosis HIDDEN for GCC patients, VISIBLE for General patients  
✅ Patient review with complete history (consultations, labs, triage, etc.)
✅ Print patient summary functionality
✅ Enhanced workflow-specific UI behavior

Test Commands:
- ENHANCED_CONSULTATION_DEBUG.simulateGCCPatient() - Test GCC workflow
- ENHANCED_CONSULTATION_DEBUG.simulateGeneralPatient() - Test General workflow
- ENHANCED_CONSULTATION_DEBUG.checkSystemStatus() - Check system state
`);
</script>
<script>
// JavaScript for Prescription Drug Search using NEW methods
// This uses the new methods without affecting your existing searchMedicines()

$(document).ready(function() {
    console.log('🔬 Initializing Prescription Drug Search (New Methods)...');
    
    // Initialize prescription drug search
    initializePrescriptionDrugSearch();
    
    // Load drug categories
    loadDrugCategories();
    
    // Initialize prescription functionality when document is ready
    initializePrescriptionFunctionality();
    
    // Override existing startEnhancedConsultation function if it exists
    if (typeof window.startEnhancedConsultation === 'function') {
        window.originalStartEnhancedConsultation = window.startEnhancedConsultation;
        window.startEnhancedConsultation = startEnhancedConsultationWithPrescriptions;
    }
    
    // Initialize prescription arrays - ADD THIS
    window.selectedPrescriptions = [];
    
    // Initialize prescription functionality - ADD THIS
    //initializePrescriptionFunctionality();
    
    console.log('🔬 Enhanced consultation with prescriptions ready!');
});

// Global variables for prescription
var prescriptionSearchTimeout;
var selectedDrugs = [];
var drugCategories = [];

function initializePrescriptionDrugSearch() {
    console.log('📋 Setting up prescription drug search events...');
    
    // Search input event with debouncing
    $(document).on('input', 'input[name="search_drugs"], #drugSearch, .prescription-drug-search', function() {
        var searchTerm = $(this).val().trim();
        
        clearTimeout(prescriptionSearchTimeout);
        
        if (searchTerm.length >= 2) {
            showPrescriptionSearchLoading();
            
            prescriptionSearchTimeout = setTimeout(function() {
                searchDrugsForPrescription(searchTerm);
            }, 300);
        } else if (searchTerm.length === 0) {
            clearPrescriptionResults();
        }
    });
    
    // Search button click
    $(document).on('click', '#searchDrugsBtn, .search-drugs-btn, button[onclick*="searchDrugs"]', function(e) {
        e.preventDefault();
        var searchTerm = $('input[name="search_drugs"], #drugSearch, .prescription-drug-search').val().trim();
        
        if (searchTerm.length >= 2) {
            searchDrugsForPrescription(searchTerm);
        } else {
            alert('Please enter at least 2 characters to search');
        }
    });
    
    // Browse all drugs button
    $(document).on('click', '#browseAllDrugsBtn, .browse-drugs-btn, button[onclick*="browseAll"]', function(e) {
        e.preventDefault();
        browseDrugsForPrescription();
    });
    
    // Category filter change
    $(document).on('change', '#drugCategory, select[name="drug_category"]', function() {
        var categoryId = $(this).val();
        var searchTerm = $('input[name="search_drugs"], #drugSearch').val().trim();
        
        if (searchTerm.length >= 2) {
            searchDrugsForPrescription(searchTerm, categoryId);
        } else {
            browseDrugsForPrescription(1, categoryId);
        }
    });
    
    // Enter key search
    $(document).on('keypress', 'input[name="search_drugs"], #drugSearch, .prescription-drug-search', function(e) {
        if (e.which === 13) {
            e.preventDefault();
            var searchTerm = $(this).val().trim();
            if (searchTerm.length >= 2) {
                searchDrugsForPrescription(searchTerm);
            }
        }
    });
    
    console.log('✅ Prescription drug search events initialized');
}

/**
 * Search drugs for prescription using NEW method
 */
function searchDrugsForPrescription(searchTerm, categoryId = null) {
    console.log('🔍 Searching prescription drugs:', { searchTerm, categoryId });
    
    showPrescriptionSearchLoading();
    
    var requestData = {
        search_term: searchTerm
    };
    
    if (categoryId) {
        requestData.category_id = categoryId;
    }
    
    var endpoint = getBaseUrl() + 'admin/pharmacy/searchDrugsForPrescription';
    
    $.ajax({
        url: endpoint,
        type: 'POST',
        data: requestData,
        dataType: 'json',
        timeout: 15000,
        success: function(response) {
            console.log('📥 Prescription search response:', response);
            hidePrescriptionSearchLoading();
            
            if (response.status === 1 || response.status === '1') {
                // FIX: Store the results properly
                window.prescriptionState.searchResults = response.drugs || [];
                console.log('✅ Stored search results:', window.prescriptionState.searchResults.length, 'drugs');
                
                displayPrescriptionDrugResults(response.drugs || []);
                showPrescriptionMessage(response.message || 'Search completed', 'success');
            } else {
                // FIX: Clear results on error
                window.prescriptionState.searchResults = [];
                showPrescriptionSearchError(response.message || 'No drugs found');
            }
        },
        error: function(xhr, status, error) {
            console.error('❌ Prescription search error:', { xhr, status, error });
            hidePrescriptionSearchLoading();
            
            // FIX: Clear results on error
            window.prescriptionState.searchResults = [];
            
            let errorMessage = 'Error searching drugs. ';
            if (xhr.status === 404) {
                errorMessage += 'Search endpoint not found. Please check if the new method is added to your controller.';
            } else if (xhr.status === 500) {
                errorMessage += 'Server error occurred. Check the server logs.';
            } else if (status === 'timeout') {
                errorMessage += 'Request timed out. Please try again.';
            } else {
                errorMessage += 'Please try again or contact support.';
            }
            
            showPrescriptionSearchError(errorMessage);
        }
    });
}

/**
 * Browse drugs for prescription using NEW method
 */
function browseDrugsForPrescription(page = 1, categoryId = null) {
    console.log('📋 Browsing prescription drugs:', { page, categoryId });
    
    showPrescriptionSearchLoading();
    
    var requestData = { page: page };
    if (categoryId) {
        requestData.category_id = categoryId;
    }
    
    var endpoint = getBaseUrl() + 'admin/pharmacy/browseDrugsForPrescription';
    
    $.ajax({
        url: endpoint,
        type: 'POST',
        data: requestData,
        dataType: 'json',
        timeout: 15000,
        success: function(response) {
            console.log('📥 Browse prescription drugs response:', response);
            hidePrescriptionSearchLoading();
            
            if (response.status === 1) {
                displayPrescriptionDrugResults(response.drugs || []);
                displayPrescriptionPagination(response.pagination);
                showPrescriptionMessage('Drugs loaded successfully', 'success');
            } else {
                showPrescriptionSearchError(response.message || 'Error loading drugs');
            }
        },
        error: function(xhr, status, error) {
            console.error('❌ Browse prescription drugs error:', { xhr, status, error });
            hidePrescriptionSearchLoading();
            showPrescriptionSearchError('Error loading drugs. Please try again.');
        }
    });
}

// Add this debug function to test
window.testPrescriptionSystem = function() {
    console.log('🧪 Testing prescription system...');
    
    // Test data
    const testDrug = {
        id: 'TEST001',
        medicine_name: 'Test Paracetamol 500mg',
        category: 'Analgesic',
        composition: 'Paracetamol 500mg',
        unit: 'Tablet',
        sale_rate: 5.00,
        available_quantity: 100
    };
    
    // Simulate opening modal
    $('#modalDrugId').val(testDrug.id);
    $('#modalDrugNameDisplay').text(testDrug.medicine_name);
    $('#modalDrugCategory').text(testDrug.category);
    $('#modalDrugComposition').text(testDrug.composition);
    $('#modalDrugUnit').text(testDrug.unit);
    $('#modalDrugSaleRate').val(testDrug.sale_rate);
    $('#modalDrugAvailableStock').val(testDrug.available_quantity);
    
    // Set form values
    $('#prescriptionQuantity').val(2);
    $('#dosageInstructions').val('1 tablet twice daily');
    $('#prescriptionDuration').val(7);
    $('#durationUnit').val('days');
    
    console.log('Test drug data set. Now call addToPrescription()');
    
    // Test the function
    try {
        addToPrescription();
        console.log('✅ addToPrescription() executed successfully');
        console.log('Current prescriptions:', window.selectedPrescriptions);
    } catch (error) {
        console.error('❌ Error in addToPrescription():', error);
    }
};

/**
 * Display prescription drug search results
 */
function displayPrescriptionDrugResults(drugs) {
    console.log('📊 Displaying', drugs.length, 'prescription drugs');
    
    var container = findPrescriptionResultsContainer();
    
    if (drugs.length === 0) {
        container.html(`
            <div class="alert alert-info text-center">
                <i class="fa fa-info-circle"></i> No drugs found matching your search criteria.
                <br><small>Try different keywords or browse all drugs.</small>
            </div>
        `);
        return;
    }
    
    var html = '<div class="prescription-drugs-list">';
    
    drugs.forEach(function(drug, index) {
        var stockBadge = getPrescriptionStockBadge(drug);
        
        // FIX: Define isOutOfStock and isDisabled properly
        var isOutOfStock = (drug.available_quantity || drug.available_qty || drug.stock || 0) <= 0;
        var isDisabled = isOutOfStock ? 'disabled' : '';
        
        html += `
            <div class="prescription-drug-item" data-drug-id="${drug.id}" style="margin-bottom: 10px;">
                <div class="drug-card ${isOutOfStock ? 'out-of-stock' : ''}" 
                     style="border: 2px solid #e9ecef; border-radius: 8px; padding: 15px; cursor: pointer; transition: all 0.3s ease;"
                     onclick="openPrescriptionModal('${drug.id}', '${drug.medicine_name.replace(/'/g, "\\'")}')">
                    
                    <div class="drug-header" style="display: flex; justify-content: space-between; align-items: flex-start; margin-bottom: 10px;">
                        <h6 style="margin: 0; font-weight: 600; color: #495057; flex: 1;">${drug.medicine_name}</h6>
                        ${stockBadge}
                    </div>
                    
                    <div class="drug-details" style="margin-bottom: 15px;">
                        ${drug.company_name ? `<div style="font-size: 12px; margin-bottom: 3px;">
                            <span style="font-weight: 600; color: #6c757d;">Company:</span> ${drug.company_name}
                        </div>` : ''}
                        
                        ${drug.composition || drug.medicine_composition ? `<div style="font-size: 12px; margin-bottom: 3px;">
                            <span style="font-weight: 600; color: #6c757d;">Composition:</span> ${drug.composition || drug.medicine_composition}
                        </div>` : ''}
                        
                        ${drug.category || drug.medicine_category ? `<div style="font-size: 12px; margin-bottom: 3px;">
                            <span style="font-weight: 600; color: #6c757d;">Category:</span> ${drug.category || drug.medicine_category}
                        </div>` : ''}
                        
                        <div style="font-size: 12px;">
                            <span style="font-weight: 600; color: #6c757d;">Available:</span> 
                            <strong class="${isOutOfStock ? 'text-danger' : 'text-success'}">${drug.available_quantity || drug.available_qty || drug.stock || 0} ${drug.unit_name || drug.unit || 'units'}</strong>
                        </div>
                        
                        <div style="font-size: 12px; margin-top: 3px;">
                            <span style="font-weight: 600; color: #6c757d;">Price:</span> 
                            <strong class="text-primary">KES ${parseFloat(drug.sale_rate || drug.price || 0).toFixed(2)} per ${drug.unit_name || drug.unit || 'unit'}</strong>
                        </div>
                    </div>
                    
                    <div class="drug-actions" style="text-align: center;">
                        <button type="button" class="btn btn-primary btn-sm" 
                                onclick="openPrescriptionModal('${drug.id}', '${drug.medicine_name.replace(/'/g, "\\'")}'); event.stopPropagation();"
                                ${isDisabled}
                                style="padding: 6px 12px; font-size: 11px;">
                            <i class="fa fa-plus"></i> ${isOutOfStock ? 'Out of Stock' : 'Add to Prescription'}
                        </button>
                    </div>
                </div>
            </div>
        `;
    });
    
    html += '</div>';
    container.html(html);
    
    // Add hover effects
    $('.drug-card').hover(
        function() { 
            if (!$(this).hasClass('out-of-stock')) {
                $(this).css('border-color', '#007bff');
                $(this).css('box-shadow', '0 4px 8px rgba(0,123,255,0.2)');
            }
        },
        function() { 
            $(this).css('border-color', '#e9ecef');
            $(this).css('box-shadow', 'none');
        }
    );
}

/**
 * Get stock status badge for prescription drugs
 */
function getPrescriptionStockBadge(drug) {
    var badgeClass = '';
    var badgeText = '';
    
    switch (drug.stock_status) {
        case 'out_of_stock':
            badgeClass = 'label-danger';
            badgeText = 'Out of Stock';
            break;
        case 'low_stock':
            badgeClass = 'label-warning';
            badgeText = 'Low Stock';
            break;
        default:
            badgeClass = 'label-success';
            badgeText = 'In Stock';
            break;
    }
    
    return `<span class="label ${badgeClass}" style="font-size: 10px;">${badgeText}</span>`;
}

/**
 * Select drug for prescription
 */
function selectDrugForPrescription(drugId, drugName) {
    console.log('🎯 Selecting drug for prescription:', { drugId, drugName });
    
    // Check if drug is already selected
    if (selectedDrugs.find(d => d.id === drugId)) {
        showPrescriptionMessage('Drug already added to prescription', 'warning');
        return;
    }
    
    // Add to selected drugs
    selectedDrugs.push({
        id: drugId,
        name: drugName
    });
    
    // Update UI
    updateSelectedDrugsDisplay();
    
    // Show success message
    showPrescriptionMessage(`${drugName} added to prescription`, 'success');
    
    // Trigger custom event for integration
    $(document).trigger('drugSelectedForPrescription', { drugId, drugName });
    
    // If you have existing functions, call them here
    if (typeof addDrugToPrescription === 'function') {
        addDrugToPrescription(drugId, drugName);
    }
}

/**
 * Load drug categories for filter
 */
function loadDrugCategories() {
    var endpoint = getBaseUrl() + 'admin/pharmacy/getDrugCategories';
    
    $.ajax({
        url: endpoint,
        type: 'GET',
        dataType: 'json',
        success: function(response) {
            if (response.status === 1) {
                drugCategories = response.categories;
                populateDrugCategoryDropdown(response.categories);
            }
        },
        error: function(xhr, status, error) {
            console.warn('⚠️ Failed to load drug categories:', error);
        }
    });
}

/**
 * Populate drug category dropdown
 */
function populateDrugCategoryDropdown(categories) {
    var dropdown = $('#drugCategory, select[name="drug_category"]');
    if (dropdown.length === 0) return;
    
    dropdown.empty();
    dropdown.append('<option value="">All Categories</option>');
    
    categories.forEach(function(category) {
        dropdown.append(`<option value="${category.id}">${category.medicine_category}</option>`);
    });
}

/**
 * Update selected drugs display
 */
function updateSelectedDrugsDisplay() {
    var container = $('#selectedDrugs, .selected-drugs-list');
    if (container.length === 0) return;
    
    if (selectedDrugs.length === 0) {
        container.html('<p class="text-muted">No drugs selected yet</p>');
        return;
    }
    
    var html = '<div class="selected-drugs-container">';
    selectedDrugs.forEach(function(drug, index) {
        html += `
            <div class="selected-drug-item" style="display: flex; justify-content: space-between; align-items: center; padding: 8px 12px; margin-bottom: 5px; background: #f8f9fa; border: 1px solid #dee2e6; border-radius: 4px;">
                <span style="font-size: 13px; font-weight: 500;">${drug.name}</span>
                <button type="button" class="btn btn-danger btn-xs" onclick="removeDrugFromPrescription(${index})">
                    <i class="fa fa-times"></i>
                </button>
            </div>
        `;
    });
    html += '</div>';
    
    container.html(html);
    
    // Update count
    $('#selectedDrugsCount, .selected-drugs-count').text(selectedDrugs.length);
}

/**
 * Remove drug from prescription
 */
function removeDrugFromPrescription(index) {
    if (index >= 0 && index < selectedDrugs.length) {
        var removedDrug = selectedDrugs.splice(index, 1)[0];
        updateSelectedDrugsDisplay();
        showPrescriptionMessage(`${removedDrug.name} removed from prescription`, 'info');
    }
}

/**
 * Display pagination for prescription drugs
 */
function displayPrescriptionPagination(pagination) {
    if (!pagination || pagination.total_pages <= 1) return;
    
    var container = $('#prescriptionDrugsPagination, .prescription-pagination');
    if (container.length === 0) return;
    
    var html = '<nav><ul class="pagination pagination-sm">';
    
    // Previous button
    if (pagination.current_page > 1) {
        html += `<li><a href="#" onclick="browseDrugsForPrescription(${pagination.current_page - 1}); return false;">&laquo;</a></li>`;
    }
    
    // Page numbers
    var startPage = Math.max(1, pagination.current_page - 2);
    var endPage = Math.min(pagination.total_pages, pagination.current_page + 2);
    
    for (var i = startPage; i <= endPage; i++) {
        var activeClass = i === pagination.current_page ? 'active' : '';
        html += `<li class="${activeClass}"><a href="#" onclick="browseDrugsForPrescription(${i}); return false;">${i}</a></li>`;
    }
    
    // Next button
    if (pagination.current_page < pagination.total_pages) {
        html += `<li><a href="#" onclick="browseDrugsForPrescription(${pagination.current_page + 1}); return false;">&raquo;</a></li>`;
    }
    
    html += '</ul></nav>';
    container.html(html);
}

/**
 * Find prescription results container
 */
function findPrescriptionResultsContainer() {
    // Try to find specific prescription containers first
    var container = $('#prescriptionDrugResults, #drugSearchResults, .prescription-drug-results');
    
    if (container.length === 0) {
        // Fallback to generic containers
        container = $('#medicineSearchResults, .medicine-results, .search-results');
    }
    
    if (container.length === 0) {
        // Create a temporary container if none found
        console.warn('⚠️ No prescription results container found. Creating temporary one.');
        $('body').append(`
            <div id="tempPrescriptionResults" style="position: fixed; top: 50px; right: 20px; width: 450px; max-height: 500px; overflow-y: auto; background: white; border: 2px solid #007bff; border-radius: 8px; padding: 15px; z-index: 9999; box-shadow: 0 4px 12px rgba(0,0,0,0.3);">
                <div style="background: #007bff; color: white; margin: -15px -15px 15px -15px; padding: 10px; display: flex; justify-content: between; align-items: center;">
                    <h5 style="margin: 0; flex: 1;">Prescription Drug Search Results</h5>
                    <button onclick="$('#tempPrescriptionResults').remove()" style="background: none; border: none; color: white; font-size: 18px; cursor: pointer;">&times;</button>
                </div>
                <div id="tempPrescriptionContent"></div>
            </div>
        `);
        container = $('#tempPrescriptionContent');
    }
    
    return container;
}

/**
 * Show prescription search loading
 */
function showPrescriptionSearchLoading() {
    var container = findPrescriptionResultsContainer();
    container.html(`
        <div class="text-center" style="padding: 40px;">
            <i class="fa fa-spinner fa-spin fa-2x text-primary"></i>
            <br><br>
            <p class="text-muted">Searching prescription drugs...</p>
        </div>
    `);
}

/**
 * Hide prescription search loading
 */
function hidePrescriptionSearchLoading() {
    // Loading state will be replaced by results or error message
}

/**
 * Show prescription search error
 */
function showPrescriptionSearchError(message) {
    var container = findPrescriptionResultsContainer();
    container.html(`
        <div class="alert alert-danger text-center">
            <i class="fa fa-exclamation-triangle"></i> 
            <strong>Search Error</strong><br>
            ${message}
            <br><br>
            <button type="button" class="btn btn-primary btn-sm" onclick="location.reload()">
                <i class="fa fa-refresh"></i> Reload Page
            </button>
            <button type="button" class="btn btn-info btn-sm" onclick="testPrescriptionEndpoints()">
                <i class="fa fa-wrench"></i> Test Endpoints
            </button>
        </div>
    `);
}

/**
 * Clear prescription search results
 */
function clearPrescriptionResults() {
    var container = findPrescriptionResultsContainer();
    container.html(`
        <div class="alert alert-info text-center">
            <i class="fa fa-search"></i> 
            <p>Enter drug name, composition, or company to search</p>
            <small class="text-muted">Or click "Browse All" to see all available drugs</small>
        </div>
    `);
}

/**
 * Show prescription message
 */
function showPrescriptionMessage(message, type = 'info', duration = 5000) {
    // Remove existing messages
    $('.prescription-alert').remove();
    
    var alertClass = 'alert-' + (type === 'error' ? 'danger' : type);
    var iconClass = type === 'success' ? 'fa-check-circle' : 
                   type === 'error' ? 'fa-times-circle' :
                   type === 'warning' ? 'fa-exclamation-triangle' : 
                   'fa-info-circle';
    
    var alertHtml = `
        <div class="alert ${alertClass} prescription-alert" style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 300px; box-shadow: 0 4px 8px rgba(0,0,0,0.2);">
            <button type="button" class="close" onclick="$(this).parent().fadeOut()">&times;</button>
            <i class="fa ${iconClass}"></i> ${message}
        </div>
    `;
    
    $('body').append(alertHtml);
    
    // Auto-hide after duration
    if (duration > 0) {
        setTimeout(function() {
            $('.prescription-alert').fadeOut(function() {
                $(this).remove();
            });
        }, duration);
    }
}

/**
 * Get base URL with fallback
 */
function getBaseUrl() {
    if (typeof base_url !== 'undefined') {
        return base_url;
    }
    
    // Fallback base URL detection
    var path = window.location.pathname;
    var pathArray = path.split('/');
    
    // Try to detect if we're in a subdirectory
    var baseUrl = window.location.origin + '/';
    
    // If we're in admin section, adjust base URL
    if (pathArray.includes('admin')) {
        var adminIndex = pathArray.indexOf('admin');
        if (adminIndex > 1) {
            baseUrl = window.location.origin + pathArray.slice(0, adminIndex).join('/') + '/';
        }
    }
    
    console.log('Using fallback base URL:', baseUrl);
    return baseUrl;
}

/**
 * Test prescription endpoints for debugging
 */
function testPrescriptionEndpoints() {
    console.log('🔧 Testing prescription endpoints...');
    
    var baseUrl = getBaseUrl();
    var endpoints = [
        'admin/pharmacy/searchDrugsForPrescription',
        'admin/pharmacy/browseDrugsForPrescription',
        'admin/pharmacy/getDrugCategories'
    ];
    
    endpoints.forEach(function(endpoint) {
        var fullUrl = baseUrl + endpoint;
        
        $.ajax({
            url: fullUrl,
            type: 'POST',
            data: { search_term: 'test' },
            timeout: 5000,
            success: function(response) {
                console.log('✅', endpoint, 'working:', response);
            },
            error: function(xhr) {
                console.error('❌', endpoint, 'failed:', xhr.status, xhr.responseText);
            }
        });
    });
}

/**
 * Initialize autocomplete for quick search
 */
function initializePrescriptionAutocomplete() {
    var searchInput = $('input[name="search_drugs"], #drugSearch, .prescription-drug-search');
    
    if (searchInput.length > 0 && typeof $.fn.autocomplete !== 'undefined') {
        searchInput.autocomplete({
            source: function(request, response) {
                $.ajax({
                    url: getBaseUrl() + 'admin/pharmacy/quickDrugSearch',
                    type: 'GET',
                    data: { q: request.term },
                    dataType: 'json',
                    success: function(data) {
                        response(data.suggestions || []);
                    },
                    error: function() {
                        response([]);
                    }
                });
            },
            minLength: 2,
            select: function(event, ui) {
                searchDrugsForPrescription(ui.item.value);
            }
        });
    }
}

/**
 * Debug functions for prescription search
 */
window.PRESCRIPTION_DEBUG = {
    testSearch: function(searchTerm = 'paracetamol') {
        console.log('🧪 Testing prescription search for:', searchTerm);
        searchDrugsForPrescription(searchTerm);
    },
    
    testBrowse: function() {
        console.log('🧪 Testing prescription browse...');
        browseDrugsForPrescription();
    },
    
    testEndpoints: function() {
        testPrescriptionEndpoints();
    },
    
    getState: function() {
        return {
            selectedDrugs: selectedDrugs,
            drugCategories: drugCategories,
            baseUrl: getBaseUrl()
        };
    },
    
    clearState: function() {
        selectedDrugs = [];
        drugCategories = [];
        updateSelectedDrugsDisplay();
        clearPrescriptionResults();
        console.log('🗑️ Prescription state cleared');
    }
};

// Export functions for global access
window.searchDrugsForPrescription = searchDrugsForPrescription;
window.browseDrugsForPrescription = browseDrugsForPrescription;
window.selectDrugForPrescription = selectDrugForPrescription;
window.removeDrugFromPrescription = removeDrugFromPrescription;

// Initialize autocomplete after page loads
setTimeout(function() {
    initializePrescriptionAutocomplete();
}, 1000);

console.log(`
╔══════════════════════════════════════════════════════════════════════════════╗
║                🔬 PRESCRIPTION DRUG SEARCH SYSTEM (NEW METHODS) 🔬          ║
╠══════════════════════════════════════════════════════════════════════════════╣
║                                                                              ║
║ ✅ FEATURES IMPLEMENTED:                                                     ║
║ • Separate methods from existing searchMedicines()                          ║
║ • Real-time prescription drug search with debouncing                        ║
║ • Category-based filtering for prescriptions                                ║
║ • Pagination for browse functionality                                       ║
║ • Stock status indicators                                                   ║
║ • Drug selection and management for prescriptions                           ║
║ • Error handling and loading states                                        ║
║ • Autocomplete support                                                      ║
║ • Responsive design with temporary containers                               ║
║                                                                              ║
║ 🔧 NEW CONTROLLER METHODS USED:                                            ║
║ • searchDrugsForPrescription()                                              ║
║ • browseDrugsForPrescription()                                              ║
║ • getDrugCategories()                                                       ║
║ • getDrugDetails()                                                          ║
║ • quickDrugSearch()                                                         ║
║                                                                              ║
║ 🔧 DEBUG COMMANDS:                                                         ║
║ PRESCRIPTION_DEBUG.testSearch() - Test search function                      ║
║ PRESCRIPTION_DEBUG.testBrowse() - Test browse function                      ║
║ PRESCRIPTION_DEBUG.testEndpoints() - Test all endpoints                     ║
║ PRESCRIPTION_DEBUG.getState() - Get current system state                    ║
║ PRESCRIPTION_DEBUG.clearState() - Clear all data                            ║
║                                                                              ║
║ 📋 USAGE:                                                                   ║
║ 1. Add the new PHP methods to your Pharmacy controller                      ║
║ 2. Include this JavaScript in your prescription view                        ║
║ 3. Use input with class 'prescription-drug-search' or name 'search_drugs'   ║
║ 4. Results will appear automatically in available containers                ║
║                                                                              ║
╚══════════════════════════════════════════════════════════════════════════════╝
`);

console.log('🔬 Prescription Drug Search System Ready!');
console.log('📍 Base URL detected as:', getBaseUrl());
console.log('🧪 Test with: PRESCRIPTION_DEBUG.testSearch()');
</script>

</body>
</html>
<style>
/* Custom styles for the prescription drug selection */
.medicine-results {
    min-height: 200px;
    border: 1px solid #ddd;
    border-radius: 4px;
    padding: 15px;
    background: #fafafa;
}

.selected-medicines {
    min-height: 100px;
    max-height: 300px;
    overflow-y: auto;
}

.info-box {
    display: block;
    min-height: 90px;
    background: #fff;
    width: 100%;
    box-shadow: 0 1px 1px rgba(0,0,0,0.1);
    border-radius: 2px;
    margin-bottom: 15px;
}

.info-box-icon {
    border-top-left-radius: 2px;
    border-top-right-radius: 0;
    border-bottom-right-radius: 0;
    border-bottom-left-radius: 2px;
    display: block;
    float: left;
    height: 90px;
    width: 90px;
    text-align: center;
    font-size: 45px;
    line-height: 90px;
    background: rgba(0,0,0,0.2);
}

.info-box-icon > i {
    color: #fff;
}

.info-box-content {
    padding: 5px 10px;
    margin-left: 90px;
}

.info-box-text {
    display: block;
    font-size: 14px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
}

.info-box-number {
    display: block;
    font-weight: bold;
    font-size: 18px;
}

.bg-aqua { background-color: #00c0ef !important; }
.bg-green { background-color: #00a65a !important; }
.bg-yellow { background-color: #f39c12 !important; }

.panel {
    margin-bottom: 20px;
    background-color: #fff;
    border: 1px solid transparent;
    border-radius: 4px;
    box-shadow: 0 1px 1px rgba(0,0,0,.05);
}

.panel-default {
    border-color: #ddd;
}

.panel-body {
    padding: 15px;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .info-box-icon {
        width: 70px;
        height: 70px;
        font-size: 35px;
        line-height: 70px;
    }
    
    .info-box-content {
        margin-left: 70px;
    }
    
    .btn-lg {
        padding: 8px 16px;
        font-size: 14px;
        margin-bottom: 10px;
        width: 100%;
    }
}
</style>
   <style>
       /* Base Layout - Adopted from Triage System */
       body {
           background: #f8f9fa;
           font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
           margin: 0;
           padding: 0;
       }
       
       .content-wrapper {
           background: #f8f9fa;
           min-height: 100vh;
           padding: 15px;
           max-width: 100%;
           overflow-x: hidden;
       }
       
       .container-fluid {
           max-width: 1400px;
           margin: 0 auto;
           padding: 0 15px;
       }
       
       /* Page Header - Enhanced from Triage */
       .page-header {
           background: white;
           border-bottom: 3px solid #28a745;
           padding: 20px 25px;
           margin-bottom: 20px;
           border-radius: 8px;
           box-shadow: 0 2px 8px rgba(0,0,0,0.1);
           border: 1px solid #e9ecef;
       }
       
       .page-title {
           color: #2c3e50;
           margin: 0 0 8px 0;
           font-size: 24px;
           font-weight: 600;
           display: flex;
           align-items: center;
           gap: 10px;
       }
       
       .page-subtitle {
           color: #6c757d;
           margin: 0 0 15px 0;
           font-size: 14px;
           font-weight: 400;
       }
       
       .page-actions {
           display: flex;
           gap: 8px;
           flex-wrap: wrap;
       }
       
       .page-actions .btn {
           font-size: 13px;
           padding: 8px 16px;
       }
       
       /* Enhanced Panels - From Triage Design */
       .consultation-panel {
           background: white;
           border-radius: 8px;
           box-shadow: 0 2px 8px rgba(0,0,0,0.1);
           margin-bottom: 20px;
           overflow: hidden;
           border: 1px solid #e9ecef;
           transition: all 0.3s ease;
       }
       
       .consultation-panel:hover {
           box-shadow: 0 4px 12px rgba(0,0,0,0.15);
       }
       
       .panel-header {
           background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
           border-bottom: 2px solid #dee2e6;
           padding: 15px 20px;
       }
       
       .panel-title {
           color: #495057;
           margin: 0;
           font-size: 16px;
           font-weight: 600;
           display: flex;
           align-items: center;
           gap: 8px;
       }
       
       .panel-body {
           padding: 20px;
       }
       
       /* Status Indicators - From Triage */
       .status-indicator {
           padding: 6px 12px;
           border-radius: 16px;
           font-size: 11px;
           font-weight: 600;
           text-transform: uppercase;
           letter-spacing: 0.3px;
           display: inline-block;
       }
       
       .status-verified {
           background: #d4edda;
           color: #155724;
           border: 1px solid #c3e6cb;
       }
       
       .status-gcc {
           background: #e3f2fd;
           color: #1976d2;
           border: 1px solid #bbdefb;
       }
       
       .status-general {
           background: #f3e5f5;
           color: #7b1fa2;
           border: 1px solid #e1bee7;
       }
       
       .status-pending {
           background: #fff3cd;
           color: #856404;
           border: 1px solid #ffeaa7;
       }
       
       /* SecuGen Status Indicators */
       .status-success {
           background: #d4edda;
           color: #155724;
           border: 1px solid #c3e6cb;
           padding: 10px;
           border-radius: 6px;
           margin-bottom: 15px;
       }
       
       .status-warning {
           background: #fff3cd;
           color: #856404;
           border: 1px solid #ffeaa7;
           padding: 10px;
           border-radius: 6px;
           margin-bottom: 15px;
       }
       
       .status-error {
           background: #f8d7da;
           color: #721c24;
           border: 1px solid #f5c6cb;
           padding: 10px;
           border-radius: 6px;
           margin-bottom: 15px;
       }
       
       .status-info {
           background: #e3f2fd;
           color: #1976d2;
           border: 1px solid #bbdefb;
           padding: 10px;
           border-radius: 6px;
           margin-bottom: 15px;
       }
       
       /* Enhanced Patient Cards */
       .patient-search-container {
           background: white;
           border: 2px solid #e9ecef;
           border-radius: 8px;
           padding: 15px;
           margin-bottom: 15px;
       }
       
       .patient-details-card {
           background: white;
           border: 2px solid #e9ecef;
           border-radius: 8px;
           padding: 20px;
           margin-bottom: 15px;
           transition: all 0.3s ease;
       }
       
       .patient-details-card.verified {
           border-color: #28a745;
           background: linear-gradient(135deg, #f8fff9 0%, #ffffff 100%);
       }
       
       .patient-details-card.gcc-patient {
           border-color: #007bff;
           background: linear-gradient(135deg, #f0f8ff 0%, #ffffff 100%);
       }
       
       .patient-info-grid {
           display: grid;
           grid-template-columns: 1fr;
           gap: 20px;
           align-items: start;
       }
       
       .patient-basic-info {
           display: grid;
           grid-template-columns: 1fr 1fr;
           gap: 15px;
       }
       
       .info-item {
           margin-bottom: 10px;
       }
       
       .info-label {
           font-weight: 600;
           color: #495057;
           font-size: 13px;
       }
       
       .info-value {
           color: #6c757d;
           font-size: 13px;
           margin-top: 2px;
       }
       
       .patient-photo-container {
           text-align: center;
           padding: 15px;
           background: #f8f9fa;
           border-radius: 6px;
           border: 2px dashed #dee2e6;
       }
       
       .patient-photo {
           max-width: 100px;
           max-height: 100px;
           border-radius: 6px;
           box-shadow: 0 2px 4px rgba(0,0,0,0.1);
           border: 2px solid #e9ecef;
       }
       
       /* Patient Actions Section */
       .patient-actions-panel {
           background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
           border-radius: 8px;
           padding: 15px;
           color: white;
           text-align: center;
           margin-top: 15px;
       }
       
       .action-buttons {
           display: flex;
           gap: 10px;
           justify-content: center;
           margin-top: 10px;
       }
       
       /* Workflow Status Panel */
       .workflow-status-panel {
           background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
           border-radius: 8px;
           padding: 15px;
           color: white;
           text-align: center;
           margin-top: 15px;
       }
       
       .workflow-badge {
           background: rgba(255,255,255,0.2);
           border: 1px solid rgba(255,255,255,0.3);
           border-radius: 12px;
           padding: 6px 12px;
           font-size: 11px;
           font-weight: 600;
           text-transform: uppercase;
           letter-spacing: 0.5px;
           display: inline-block;
           margin-bottom: 8px;
       }
       
       /* Enhanced Verification Section */
       .verification-container {
           background: #f8f9fa;
           border-radius: 8px;
           padding: 20px;
           border: 2px solid #e9ecef;
           margin: 15px 0;
       }
       
       .verification-grid {
           display: grid;
           grid-template-columns: 1fr 1fr;
           gap: 20px;
       }
       
       .fingerprint-display-container {
           text-align: center;
           padding: 15px;
           background: white;
           border-radius: 6px;
           border: 2px dashed #dee2e6;
           transition: all 0.3s ease;
       }
       
       .fingerprint-display-container.active {
           border-color: #007bff;
           background: #f0f8ff;
       }
       
       .fingerprint-image {
           max-width: 120px;
           max-height: 100px;
           border-radius: 6px;
           box-shadow: 0 2px 4px rgba(0,0,0,0.1);
           border: 1px solid #dee2e6;
       }
       
       .verification-status-display {
           margin: 15px 0;
           padding: 15px;
           border-radius: 6px;
           border: 1px solid #dee2e6;
       }
       
       /* Enhanced Buttons */
       .btn-modern {
           background: #28a745;
           border: none;
           color: white;
           padding: 10px 20px;
           border-radius: 6px;
           font-weight: 600;
           font-size: 13px;
           transition: all 0.3s ease;
           box-shadow: 0 2px 4px rgba(40,167,69,0.2);
       }
       
       .btn-modern:hover {
           background: #218838;
           transform: translateY(-1px);
           box-shadow: 0 4px 8px rgba(40,167,69,0.3);
           color: white;
       }
       
       .btn-modern:disabled {
           background: #6c757d;
           transform: none;
           box-shadow: none;
       }
       
       .btn-verification {
           background: #007bff;
           color: white;
       }
       
       .btn-verification:hover {
           background: #0056b3;
           color: white;
       }
       
       .btn-manual {
           background: #6c757d;
           color: white;
       }
       
       .btn-manual:hover {
           background: #545b62;
           color: white;
       }
       
       .btn-warning-modern {
           background: #ffc107;
           color: #212529;
       }
       
       .btn-warning-modern:hover {
           background: #e0a800;
           color: #212529;
       }
       
       .btn-info-modern {
           background: #17a2b8;
           color: white;
       }
       
       .btn-info-modern:hover {
           background: #138496;
           color: white;
       }
       
       .btn-lg {
           padding: 12px 24px;
           font-size: 14px;
       }
       
       .btn-sm {
           padding: 6px 12px;
           font-size: 12px;
       }
       
       .btn-block {
           width: 100%;
           display: block;
       }
       
       /* Enhanced Form Elements */
       .form-control-modern {
           border: 2px solid #e9ecef;
           border-radius: 6px;
           padding: 10px 12px;
           font-size: 13px;
           transition: all 0.3s ease;
           background: white;
           width: 100%;
           box-sizing: border-box;
       }
       
       .form-control-modern:focus {
           border-color: #28a745;
           box-shadow: 0 0 0 0.2rem rgba(40,167,69,0.25);
           outline: none;
       }
       
       .form-group-modern {
           margin-bottom: 15px;
       }
       
       .form-label-modern {
           font-weight: 600;
           color: #495057;
           margin-bottom: 6px;
           display: block;
           font-size: 13px;
       }
       
       .form-control {
           font-size: 13px;
       }
       
       select.form-control-modern {
           height: auto;
           min-height: 38px;
       }
       
       textarea.form-control-modern {
           resize: vertical;
       }
       
       /* Enhanced Alerts */
       .alert-modern {
           border: none;
           border-radius: 6px;
           padding: 12px 16px;
           margin: 12px 0;
           box-shadow: 0 2px 4px rgba(0,0,0,0.1);
           font-size: 13px;
       }
       
       .alert-info-modern {
           background: #e3f2fd;
           color: #1976d2;
           border-left: 4px solid #2196f3;
       }
       
       .alert-success-modern {
           background: #e8f5e8;
           color: #2e7d32;
           border-left: 4px solid #4caf50;
       }
       
       .alert-warning-modern {
           background: #fff8e1;
           color: #ef6c00;
           border-left: 4px solid #ff9800;
       }
       
       .alert-danger-modern {
           background: #ffebee;
           color: #c62828;
           border-left: 4px solid #f44336;
       }
       
       /* Step Indicator */
       .step-indicator {
           display: flex;
           justify-content: space-between;
           margin: 20px 0;
           padding: 0 15px;
       }
       
       .step {
           flex: 1;
           text-align: center;
           position: relative;
       }
       
       .step:not(:last-child)::after {
           content: '';
           position: absolute;
           top: 12px;
           right: -50%;
           width: 100%;
           height: 2px;
           background: #dee2e6;
           z-index: 1;
       }
       
       .step.active::after {
           background: #28a745;
       }
       
       .step.completed::after {
           background: #007bff;
       }
       
       .step-circle {
           width: 24px;
           height: 24px;
           border-radius: 50%;
           background: #dee2e6;
           color: white;
           display: flex;
           align-items: center;
           justify-content: center;
           margin: 0 auto 6px;
           font-weight: 600;
           font-size: 12px;
           position: relative;
           z-index: 2;
           transition: all 0.3s ease;
       }
       
       .step.active .step-circle {
           background: #28a745;
           box-shadow: 0 0 8px rgba(40,167,69,0.5);
       }
       
       .step.completed .step-circle {
           background: #007bff;
       }
       
       .step-label {
           font-size: 11px;
           font-weight: 600;
           color: #6c757d;
       }
       
       .step.active .step-label {
           color: #28a745;
       }
       
       .step.completed .step-label {
           color: #007bff;
       }
       
       /* Loading Spinner */
       .spinner-modern {
           display: inline-block;
           width: 16px;
           height: 16px;
           border: 2px solid #f3f3f3;
           border-top: 2px solid #28a745;
           border-radius: 50%;
           animation: spin 1s linear infinite;
       }
       
       @keyframes spin {
           0% { transform: rotate(0deg); }
           100% { transform: rotate(360deg); }
       }
       
       /* Fade In Animation */
       .fade-in {
           animation: fadeIn 0.5s ease-in;
       }
       
       @keyframes fadeIn {
           from { opacity: 0; transform: translateY(10px); }
           to { opacity: 1; transform: translateY(0); }
       }
       
       /* Pulse Highlight */
       .pulse-highlight {
           animation: pulse-border-modern 2s;
       }
       
       @keyframes pulse-border-modern {
           0% { 
               border-color: #e9ecef; 
               box-shadow: 0 0 5px rgba(233, 236, 239, 0.3); 
           }
           50% { 
               border-color: #28a745; 
               box-shadow: 0 0 15px rgba(40, 167, 69, 0.6); 
           }
           100% { 
               border-color: #e9ecef; 
               box-shadow: 0 0 5px rgba(233, 236, 239, 0.3); 
           }
       }
       
       /* Navigation Tabs - Enhanced */
       .nav-tabs-modern {
           border-bottom: 2px solid #dee2e6;
           margin-bottom: 20px;
           display: flex;
           flex-wrap: wrap;
       }
       
       .nav-tabs-modern > li {
           flex: 1;
           min-width: 0;
       }
       
       .nav-tabs-modern > li > a {
           border: none;
           border-radius: 6px 6px 0 0;
           padding: 10px 12px;
           font-weight: 600;
           font-size: 12px;
           color: #6c757d;
           transition: all 0.3s ease;
           text-align: center;
           white-space: nowrap;
           overflow: hidden;
           text-overflow: ellipsis;
       }
       
       .nav-tabs-modern > li.active > a {
           background: #28a745;
           color: white;
           border-bottom: 2px solid #28a745;
       }
       
       .nav-tabs-modern > li > a:hover {
           background: #f8f9fa;
           color: #28a745;
       }
       
       /* Table Enhanced */
       .table-modern {
           font-size: 12px;
           background: white;
           border-radius: 6px;
           overflow: hidden;
           box-shadow: 0 2px 8px rgba(0,0,0,0.1);
       }
       
       .table-modern th,
       .table-modern td {
           padding: 8px 6px;
           vertical-align: middle;
       }
       
       .table-modern thead th {
           background: #f8f9fa;
           border-bottom: 2px solid #dee2e6;
           font-weight: 600;
           color: #495057;
       }
       
       .table-modern tbody tr:hover {
           background: #f8f9fa;
       }
       
       .table-responsive {
           border: 1px solid #dee2e6;
           border-radius: 6px;
       }
       
       /* Lab Tests Specific Styles - OPTIONAL STYLING */
       .lab-tests-panel {
           background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
           border-radius: 8px;
           padding: 15px;
           color: white;
           margin-top: 15px;
       }
       
       .lab-tests-optional {
           background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
       }
       
       .test-category-tab {
           background: rgba(255,255,255,0.1);
           border: 1px solid rgba(255,255,255,0.2);
           border-radius: 6px;
           margin: 5px;
           padding: 8px 12px;
           color: white;
           font-size: 12px;
           font-weight: 600;
           transition: all 0.3s ease;
       }
       
       .test-category-tab.active,
       .test-category-tab:hover {
           background: rgba(255,255,255,0.2);
           border-color: rgba(255,255,255,0.4);
       }
       
       .test-checkbox {
           border: 1px solid #e9ecef;
           border-radius: 6px;
           padding: 8px;
           margin: 5px 0;
           background: white;
           transition: all 0.3s ease;
       }
       
       .test-checkbox:hover {
           border-color: #28a745;
           background: #f8fff9;
       }
       
       .test-checkbox input[type="checkbox"]:checked + label {
           color: #28a745;
           font-weight: 600;
       }
       
       /* Summary Cards */
       .summary-card {
           background: white;
           border-radius: 8px;
           padding: 20px;
           border: 1px solid #e9ecef;
           box-shadow: 0 2px 8px rgba(0,0,0,0.1);
           margin-bottom: 15px;
           transition: all 0.3s ease;
       }
       
       .summary-card:hover {
           box-shadow: 0 4px 12px rgba(0,0,0,0.15);
       }
       
       .summary-card-icon {
           font-size: 24px;
           color: #28a745;
           margin-bottom: 10px;
       }
       
       .summary-card-value {
           font-size: 28px;
           font-weight: 700;
           color: #2c3e50;
           margin-bottom: 5px;
       }
       
       .summary-card-label {
           font-size: 14px;
           color: #6c757d;
           font-weight: 500;
       }
       
       /* Patient Review Panel */
       .patient-review-panel {
           background: white;
           border-radius: 8px;
           box-shadow: 0 2px 8px rgba(0,0,0,0.1);
           margin-bottom: 20px;
           overflow: hidden;
           border: 1px solid #e9ecef;
       }
       
       .review-section {
           padding: 15px;
           border-bottom: 1px solid #e9ecef;
       }
       
       .review-section:last-child {
           border-bottom: none;
       }
       
       .review-section h6 {
           color: #495057;
           font-weight: 600;
           margin-bottom: 10px;
           font-size: 14px;
       }
       
       .review-item {
           background: #f8f9fa;
           border: 1px solid #e9ecef;
           border-radius: 4px;
           padding: 10px;
           margin-bottom: 8px;
       }
       
       .review-item:last-child {
           margin-bottom: 0;
       }
       
       /* Responsive Design */
       @media (max-width: 1200px) {
           .container-fluid {
               max-width: 100%;
               padding: 0 10px;
           }
           
           .patient-info-grid {
               grid-template-columns: 1fr;
               gap: 15px;
           }
           
           .verification-grid {
               grid-template-columns: 1fr;
               gap: 15px;
           }
       }
       
       @media (max-width: 768px) {
           .content-wrapper {
               padding: 10px;
           }
           
           .page-header {
               padding: 15px;
               margin-bottom: 15px;
           }
           
           .page-title {
               font-size: 20px;
           }
           
           .page-subtitle {
               font-size: 13px;
           }
           
           .page-actions {
               flex-direction: column;
               gap: 8px;
           }
           
           .panel-body {
               padding: 15px;
           }
           
           .patient-basic-info {
               grid-template-columns: 1fr;
               gap: 10px;
           }
           
           .verification-grid {
               grid-template-columns: 1fr;
               gap: 15px;
           }
           
           .verification-container {
               padding: 15px;
           }
           
           .step-indicator {
               flex-wrap: wrap;
               gap: 10px;
               padding: 0 10px;
           }
           
           .step::after {
               display: none;
           }
           
           .step {
               flex: 1 1 calc(50% - 5px);
               margin-bottom: 10px;
           }
           
           .btn-group {
               display: flex;
               flex-direction: column;
               gap: 8px;
           }
           
           .btn-group .btn {
               width: 100%;
           }
           
           .modal-lg {
               max-width: 95%;
           }
           
           .modal-body {
               padding: 15px;
           }
           
           .nav-tabs-modern > li {
               flex: 1 1 50%;
           }
           
           .nav-tabs-modern > li > a {
               padding: 8px 6px;
               font-size: 11px;
           }
           
           .action-buttons {
               flex-direction: column;
               gap: 8px;
           }
       }
       
       @media (max-width: 480px) {
           .content-wrapper {
               padding: 8px;
           }
           
           .page-header {
               padding: 12px;
           }
           
           .page-title {
               font-size: 18px;
           }
           
           .step {
               flex: 1 1 100%;
           }
           
           .panel-body {
               padding: 12px;
           }
           
           .verification-container {
               padding: 12px;
           }
           
           .btn-modern {
               padding: 8px 12px;
               font-size: 12px;
           }
           
           .form-control-modern {
               padding: 8px 10px;
               font-size: 12px;
           }
           
           .modal-dialog {
               margin: 10px;
           }
           
           .nav-tabs-modern > li {
               flex: 1 1 100%;
           }
           
           .nav-tabs-modern {
               flex-direction: column;
           }
           
           .nav-tabs-modern > li > a {
               border-radius: 0;
               border-bottom: 1px solid #dee2e6;
           }
       }
       
       /* Container Constraints */
       .container-fluid {
           max-width: 100vw;
           overflow-x: hidden;
       }
       
       .row {
           margin-left: -10px;
           margin-right: -10px;
       }
       
       .col-md-1, .col-md-2, .col-md-3, .col-md-4, .col-md-5, .col-md-6,
       .col-md-7, .col-md-8, .col-md-9, .col-md-10, .col-md-11, .col-md-12 {
           padding-left: 10px;
           padding-right: 10px;
       }
       
       /* Prevent horizontal scroll */
       html, body {
           overflow-x: hidden;
           max-width: 100%;
       }
       
       * {
           box-sizing: border-box;
       }
       
       /* Custom Scrollbar */
       ::-webkit-scrollbar {
           width: 6px;
       }
       
       ::-webkit-scrollbar-track {
           background: #f1f1f1;
           border-radius: 3px;
       }
       
       ::-webkit-scrollbar-thumb {
           background: #c1c1c1;
           border-radius: 3px;
       }
       
       ::-webkit-scrollbar-thumb:hover {
           background: #a1a1a1;
       }
       
/* ✅ Enhanced CSS for comprehensive barcode display */
.patient-barcode-container {
    background: linear-gradient(145deg, #f8f9fa 0%, #e9ecef 100%);
    border: 2px solid #dee2e6;
    border-radius: 8px;
    padding: 12px;
    margin-top: 15px;
    text-align: center;
    transition: all 0.3s ease;
    max-width: 300px;
    margin-left: auto;
    margin-right: auto;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.patient-barcode-container:hover {
    border-color: #28a745;
    background: linear-gradient(145deg, #f8fff9 0%, #e8f5e9 100%);
    box-shadow: 0 4px 8px rgba(0,0,0,0.15);
}

.patient-barcode-container h6 {
    margin-bottom: 8px;
    font-weight: 600; 
    font-size: 12px;
    color: #495057;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

#patientBarcode {
    max-width: 100%;
    height: auto;
    margin: 8px 0;
    background: white;
    padding: 4px;
    border-radius: 4px;
    border: 1px solid #dee2e6;
}

#barcodeData {
    background: white;
    border: 1px solid #dee2e6;
    border-radius: 4px;
    padding: 8px;
    margin-top: 8px;
    font-size: 9px;
    color: #495057;
    text-align: left;
    line-height: 1.3;
}

#barcodeData strong {
    color: #212529;
    font-size: 10px;
}

#barcodeData code {
    background: #f8f9fa;
    border: 1px solid #e9ecef;
    border-radius: 2px;
    padding: 2px 4px;
    font-size: 8px;
    font-family: 'Courier New', monospace;
    color: #6f42c1;
}

/* Enhanced print button group */
.barcode-actions {
    margin-top: 12px;
    display: flex;
    justify-content: center;
    gap: 8px;
    flex-wrap: wrap;
}

#printBarcodeBtn {
    padding: 6px 12px;
    font-size: 11px;
    border-radius: 4px;
    transition: all 0.3s ease;
}

.btn-group .dropdown-menu {
    min-width: 180px;
    font-size: 11px;
}

.btn-group .dropdown-menu li a {
    padding: 6px 12px;
    white-space: nowrap;
}

.btn-group .dropdown-menu li a i {
    width: 16px;
    margin-right: 6px;
}

/* Barcode validation indicators */
.barcode-status {
    margin-top: 6px;
    padding: 4px 8px;
    border-radius: 3px;
    font-size: 9px;
    font-weight: 600;
    text-align: center;
}

.barcode-status.valid {
    background: #d4edda;
    color: #155724;
    border: 1px solid #c3e6cb;
}

.barcode-status.warning {
    background: #fff3cd;
    color: #856404;
    border: 1px solid #ffeaa7;
}

.barcode-status.error {
    background: #f8d7da;
    color: #721c24;
    border: 1px solid #f5c6cb;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .patient-barcode-container {
        max-width: 280px;
        padding: 10px;
    }
    
    .patient-barcode-container h6 {
        font-size: 11px;
    }
    
    #barcodeData {
        font-size: 8px;
        padding: 6px;
    }
    
    .barcode-actions {
        flex-direction: column;
        align-items: center;
    }
    
    #printBarcodeBtn {
        font-size: 10px;
        padding: 5px 10px;
    }
}

/* Very compact version for small screens */
@media (max-width: 480px) {
    .patient-barcode-container {
        max-width: 260px;
        padding: 8px;
    }
    
    .patient-barcode-container h6 {
        font-size: 10px;
        margin-bottom: 6px;
    }
    
    #barcodeData {
        font-size: 7px;
        padding: 4px;
    }
    
    #barcodeData code {
        font-size: 7px;
    }
}

/* Print preview styles */
.print-preview {
    border: 2px dashed #007bff;
    background: #f0f8ff;
    margin-top: 10px;
    padding: 10px;
    border-radius: 4px;
}

.print-preview h6 {
    color: #007bff;
    margin-bottom: 8px;
}

/* Animation for barcode generation */
.barcode-generating {
    opacity: 0.6;
    transform: scale(0.95);
    transition: all 0.5s ease;
}

.barcode-generated {
    opacity: 1;
    transform: scale(1);
    animation: barcodeGenerated 0.5s ease;
}

@keyframes barcodeGenerated {
    0% { 
        opacity: 0.6; 
        transform: scale(0.95); 
    }
    50% { 
        opacity: 0.8; 
        transform: scale(1.02); 
    }
    100% { 
        opacity: 1; 
        transform: scale(1); 
    }
}
</style>
<style>
.spinner-modern {
    display: inline-block;
    width: 20px;
    height: 20px;
    border: 2px solid #f3f3f3;
    border-top: 2px solid #007bff;
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

.fade-in {
    animation: fadeIn 0.5s ease-in-out;
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

.triage-record-card {
    border: 1px solid #e9ecef;
    border-radius: 8px;
    margin-bottom: 15px;
    padding: 15px;
    background: white;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
}

.triage-record-card:hover {
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
    transform: translateY(-2px);
}

.triage-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 1px solid #eee;
    padding-bottom: 10px;
    margin-bottom: 10px;
}

.triage-priority {
    padding: 4px 8px;
    border-radius: 12px;
    font-size: 11px;
    font-weight: bold;
    display: inline-flex;
    align-items: center;
    gap: 4px;
}

.priority-high { background: #f8d7da; color: #721c24; }
.priority-medium { background: #fff3cd; color: #856404; }
.priority-low { background: #d4edda; color: #155724; }
.priority-standard { background: #e2e3e5; color: #383d41; }

.vital-row {
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
    margin: 10px 0;
}

.vital-item {
    flex: 1;
    min-width: 80px;
    padding: 8px;
    background: #f8f9fa;
    border-radius: 4px;
    text-align: center;
    font-size: 12px;
    border: 1px solid #dee2e6;
}

.vital-item strong {
    display: block;
    color: #6c757d;
    font-size: 10px;
    margin-bottom: 2px;
}

.triage-complaints p,
.triage-assessment p {
    background: #f8f9fa;
    padding: 8px 12px;
    border-radius: 4px;
    margin: 5px 0 0 0;
    font-size: 13px;
    border-left: 3px solid #007bff;
}

.triage-actions {
    margin-top: 15px;
    text-align: right;
    border-top: 1px solid #eee;
    padding-top: 10px;
}
</style>