<body>
   <div class="content-wrapper">
       <div class="container-fluid">
           <!-- Enhanced Page Header -->
           <div class="page-header fade-in">
               <h1 class="page-title">
                   <i class="fa fa-user-md"></i> 
                   Enhanced Consultation System
               </h1>
               <p class="page-subtitle">Advanced patient consultation with biometric verification & comprehensive lab tests integration</p>
           </div>

           <!-- Step Indicator -->
           <div class="consultation-panel fade-in">
               <div class="panel-body">
                   <div class="step-indicator">
                       <div class="step active" id="step-search">
                           <div class="step-circle">1</div>
                           <div class="step-label">Search</div>
                       </div>
                       <div class="step" id="step-verify">
                           <div class="step-circle">2</div>
                           <div class="step-label">Verify</div>
                       </div>
                       <div class="step" id="step-consult">
                           <div class="step-circle">3</div>
                           <div class="step-label">Action</div>
                       </div>
                       <div class="step" id="step-save">
                           <div class="step-circle">4</div>
                           <div class="step-label">Save</div>
                       </div>
                   </div>
               </div>
           </div>

           <!-- Enhanced Patient Search Section -->
           <div class="consultation-panel fade-in" id="patient-search-panel">
               <div class="panel-header">
                   <h3 class="panel-title">
                       <i class="fa fa-search"></i> Patient Search & Selection
                   </h3>
               </div>
               <div class="panel-body">
                   <div class="patient-search-container">
                       <div class="row">
                           <div class="col-md-12">
                               <div class="form-group-modern">
                                   <label class="form-label-modern">Search Patient for Consultation</label>
                                   <select class="form-control form-control-modern" id="consultation_patient_search" style="width: 100%;">
                                       <option value="">Loading patients...</option>
                                   </select>
                               </div>
                           </div>
                       </div>
                   </div>
               </div>
           </div>

           <!-- Enhanced Patient Details Section -->
           <div class="consultation-panel fade-in" id="patientDetailsSection" style="display:none;">
               <div class="panel-header">
                   <h3 class="panel-title">
                       <i class="fa fa-user"></i> Patient Information & Actions 
                       <span class="pull-right" id="verificationStatus"></span>
                   </h3>
               </div>
               <div class="panel-body">
                   <!-- Patient Details Card -->
                   <div class="patient-details-card" id="patientDetailsCard">
                       <div class="patient-info-grid">
                           <div class="patient-basic-info">
                               <div>
                                   <div class="info-item">
                                       <div class="info-label">Name</div>
                                       <div class="info-value" id="patientName">-</div>
                                   </div>
                                   <div class="info-item">
                                       <div class="info-label">Age</div>
                                       <div class="info-value" id="patientAge">-</div>
                                   </div>
                                   <div class="info-item">
                                       <div class="info-label">Gender</div>
                                       <div class="info-value" id="patientGender">-</div>
                                   </div>
                               </div>
                               <div>
                                   <div class="info-item">
                                       <div class="info-label">Phone</div>
                                       <div class="info-value" id="patientPhone">-</div>
                                   </div>
                                   <div class="info-item">
                                       <div class="info-label">Blood Group</div>
                                      <div class="info-value" id="patientBloodGroup">-</div>
                                  </div>
                                  <div class="info-item">
                                      <div class="info-label">Allergies</div>
                                      <div class="info-value" id="patientAllergies">-</div>
                                  </div>
                              </div>
                          </div>
                          <div class="patient-photo-container">
                              <img id="patientPhoto" src="../uploads/patient_images/no_image.png" alt="Patient Photo" class="patient-photo">
                          </div>
                          
                          <!-- Patient Barcode -->
                          <div class="patient-barcode-container" style="text-align: center; margin-top: 15px; padding: 15px; background: #f8f9fa; border-radius: 6px;">
                              <h6 style="margin-bottom: 8px; font-weight: 600; font-size: 12px; color: #495057;">Patient Barcode</h6>
                              <svg id="patientBarcode" style="margin-bottom: 10px;"></svg>
                              <div id="barcodeData" style="font-size: 11px; color: #6c757d; word-break: break-all;"></div>
                              <button type="button" id="printBarcodeBtn" class="btn btn-modern btn-sm" style="margin-top: 10px;">
                                  <i class="fa fa-print"></i> Print Barcode
                              </button>
                          </div>
                      </div>
                      
                      <!-- Workflow Status Panel -->
                      <div class="workflow-status-panel">
                          <div class="workflow-badge" id="workflowBadge">General Patient</div>
                          <div id="currentPatientStatus">
                              <p style="margin: 0; font-size: 12px;">Select patient to view status</p>
                          </div>
                      </div>
                  </div>

                  <!-- SecuGen Service Status Display -->
                  <div id="secugen_service_status" class="verification-status-display">
                      <div class="text-center">
                          <div class="spinner-modern"></div> Initializing SecuGen WebAPI...
                      </div>
                  </div>

                  <!-- Enhanced Biometric Verification Section -->
                  <div class="verification-container" id="biometricVerificationSection">
                      <h5 style="margin-bottom: 15px; color: #495057; font-weight: 600; font-size: 15px;">
                          <i class="fa fa-fingerprint"></i> SecuGen Biometric Verification
                      </h5>
                      
                      <div class="verification-grid">
                          <div>
                              <!-- Stored Fingerprint Display -->
                              <div class="fingerprint-display-container" id="storedFingerprintContainer">
                                  <h6 style="margin-bottom: 8px; font-weight: 600; font-size: 12px;">Stored Template</h6>
                                  <img id="storedFingerprintImage" src="./Images/PlaceFinger.bmp" alt="Stored Fingerprint" class="fingerprint-image">
                                  <div id="storedTemplateInfo" style="margin-top: 8px; font-size: 11px;">
                                      <div id="storedTemplateDetails" class="text-muted">No template loaded</div>
                                      <div id="storedTemplateMetrics" class="text-info"></div>
                                  </div>
                              </div>
                          </div>
                          
                          <div>
                              <!-- Live Fingerprint Display -->
                              <div class="fingerprint-display-container" id="liveFingerprintContainer">
                                  <h6 style="margin-bottom: 8px; font-weight: 600; font-size: 12px;">Live Capture</h6>
                                  <img id="liveFingerprintImage" src="./Images/PlaceFinger.bmp" alt="Live Fingerprint" class="fingerprint-image">
                                  <div id="liveTemplateInfo" style="margin-top: 8px; font-size: 11px;">
                                      <div id="liveTemplateDetails" class="text-muted">Ready for capture</div>
                                  </div>
                              </div>
                          </div>
                      </div>
                      
                      <!-- Verification Status -->
                      <div id="fingerprintStatus" class="text-center mb-3">
                          <div class="status-info">
                              <i class="fa fa-info-circle"></i> Ready for biometric verification - Consultation Module
                          </div>
                      </div>
                      
                      <!-- Verification Controls -->
                      <div class="text-center">
                          <div class="btn-group" style="margin-bottom: 10px;">
                              <button type="button" id="manualVerifyBtn" class="btn btn-modern">
                                  <i class="fa fa-fingerprint"></i> Manual Print Capture
                              </button>
                              <button type="button" id="verifyIdentity" class="btn btn-verification" disabled>
                                  <i class="fa fa-shield"></i> Verify Print
                              </button>
                          </div>
                          <br>
                          <div class="btn-group">
                              <button type="button" id="clearCaptureData" class="btn btn-manual btn-sm">
                                  <i class="fa fa-refresh"></i> Clear
                              </button>
                          </div>
                      </div>
                      
                      <!-- Hidden Template Storage -->
                      <input type="hidden" id="patientStoredTemplate" value="">
                      <input type="hidden" id="liveScannedTemplate" value="">
                      <input type="hidden" id="lastMatchScore" value="0">
                      <input type="hidden" id="verificationQuality" value="">
                  </div>

                  <!-- Patient Actions Panel -->
                  <div class="patient-actions-panel" style="margin-top: 20px;">
                      <div class="workflow-badge">Patient Actions</div>
                      <p style="margin: 8px 0; font-size: 12px;">Choose an action for this patient</p>
                      
                      <div class="action-buttons">
                          <button type="button" id="startConsultationBtn" class="btn btn-modern btn-lg" disabled>
                              <i class="fa fa-user-md"></i> New Consultation
                          </button>
                          <button type="button" id="reviewPatientBtn" class="btn btn-info-modern btn-lg">
                              <i class="fa fa-eye"></i> Review Patient History
                          </button>
                      </div>
                      
                      <div id="verificationMessage" style="margin-top: 12px;"></div>
                  </div>

                  <!-- Hidden fields -->
                  <input type="hidden" id="selectedPatientId" value="">
                  <input type="hidden" id="verificationPassed" value="0">

                  <!-- Recent Activity Summary -->
<div class="row" style="margin-top: 20px;">
    <div class="col-md-6">
        <div class="consultation-panel">
            <div class="panel-header">
                <h5 class="panel-title">
                    <i class="fa fa-history"></i> Recent Consultations
                </h5>
            </div>
            <div class="panel-body">
                <div id="reviewConsultationsList">  <!-- ✅ This is the correct ID -->
                    <p class="text-muted">Select a patient to view consultation history</p>
                </div>
            </div>
        </div>
    </div>
                      
                      <div class="col-md-6">
                          <div class="consultation-panel">
                              <div class="panel-header">
                                  <h5 class="panel-title">
                                      <i class="fa fa-shield"></i> Verification History
                                  </h5>
                              </div>
                              <div class="panel-body">
                                  <div id="verificationHistory" style="max-height: 200px; overflow-y: auto;">
                                      <p class="text-muted">No verification attempts yet</p>
                                  </div>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
          </div>
      </div>
  </div>

  <!-- Enhanced Consultation Modal with Lab Tests -->
  <div class="modal fade modal-modern" id="consultationModal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-lg" role="document">
          <div class="modal-content">
              <div class="modal-header">
                  <button type="button" class="close" data-dismiss="modal">&times;</button>
                  <h4 class="modal-title">
                      <i class="fa fa-user-md"></i> <span id="modalTitle">Enhanced Consultation Assessment</span>
                  </h4>
              </div>
              <form id="consultationForm">
                  <div class="modal-body">
                      <!-- Patient Info Display -->
                      <div class="alert-info-modern">
                          <div class="row">
                              <div class="col-md-8">
                                  <strong>Patient:</strong> <span id="modalPatientName"></span><br>
                                  <small>ID: <span id="modalPatientId"></span></small>
                              </div>
                              <div class="col-md-4 text-right">
                                  <span id="modalVerificationBadge"></span>
                                  <div id="modalVerificationDetails" style="font-size: 10px; margin-top: 5px;"></div>
                              </div>
                          </div>
                      </div>

                      <!-- Consultation Details Section -->
                      <div class="consultation-panel" style="margin: 15px 0;">
                          <div class="panel-header">
                              <h5 class="panel-title"><i class="fa fa-stethoscope"></i> Consultation Details</h5>
                          </div>
                          <div class="panel-body">
                              <div class="row">
                                  <div class="col-md-6">
                                      <div class="form-group-modern">
                                          <label class="form-label-modern">Consultation Date <span class="text-danger">*</span></label>
                                          <input type="date" name="consultation_date" id="consultationDate" class="form-control form-control-modern" required>
                                      </div>
                                  </div>
                                  <div class="col-md-6">
                                      <div class="form-group-modern">
                                          <label class="form-label-modern">Doctor <span class="text-danger">*</span></label>
                                          <select name="doctor" id="consultationDoctor" class="form-control form-control-modern" required>
                                              <option value="">Select Doctor</option>
                                          </select>
                                      </div>
                                  </div>
                              </div>
                              
                              <div class="form-group-modern">
                                  <label class="form-label-modern">Chief Complaint / Symptoms <span class="text-danger">*</span></label>
                                  <textarea name="symptoms" id="consultationSymptoms" class="form-control form-control-modern" rows="4" placeholder="Describe patient symptoms and chief complaint..." required></textarea>
                              </div>

                              <!-- ICD-10 Diagnosis Section (Hidden for GCC patients) -->
                              <div class="form-group-modern" id="diagnosisSection">
                                  <label class="form-label-modern">Primary Diagnosis (ICD-10)</label>
                                  <div class="row">
                                      <div class="col-md-8">
                                          <select name="diagnosis_code_id" id="consultationDiagnosis" class="form-control form-control-modern" style="width: 100%;">
                                              <option value="">Search and select ICD-10 diagnosis...</option>
                                          </select>
                                      </div>
                                      <div class="col-md-4">
                                          <button type="button" id="addCustomDiagnosis" class="btn btn-modern btn-sm">
                                              <i class="fa fa-plus"></i> Add Custom
                                          </button>
                                          <button type="button" id="clearDiagnosis" class="btn btn-manual btn-sm">
                                              <i class="fa fa-times"></i> Clear
                                          </button>
                                      </div>
                                  </div>
                                  <div id="selectedDiagnosisInfo" style="margin-top: 8px; display: none;">
                                      <div class="alert-success-modern" style="padding: 8px; margin-bottom: 8px;">
                                          <strong>Selected:</strong> <span id="selectedDiagnosisCode"></span> - <span id="selectedDiagnosisTitle"></span><br>
                                          <small class="text-muted" id="selectedDiagnosisCategory"></small>
                                      </div>
                                  </div>
                              </div>

                              <!-- Custom Diagnosis Input -->
                              <div class="form-group-modern" id="customDiagnosisGroup" style="display: none;">
                                  <label class="form-label-modern">Custom Diagnosis Description</label>
                                  <textarea name="diagnosis_custom" id="consultationDiagnosisCustom" class="form-control form-control-modern" rows="2" placeholder="Enter custom diagnosis if not found in ICD-10 codes..."></textarea>
                                  <small class="text-info">Use this field for diagnoses not covered by standard ICD-10 codes</small>
                              </div>

                              <div class="form-group-modern">
                                  <label class="form-label-modern">Consultation Notes</label>
                                  <textarea name="notes" id="consultationNotes" class="form-control form-control-modern" rows="3" placeholder="Additional consultation notes, assessment findings, and recommendations..."></textarea>
                              </div>
                          </div>
                      </div>

                      <!-- Laboratory Tests Section (OPTIONAL) -->
                      <div class="lab-tests-panel lab-tests-optional" style="margin: 15px 0;">
                          <div style="background: rgba(255,255,255,0.2); border-radius: 6px; padding: 15px; margin-bottom: 15px;">
                              <h5 style="margin: 0 0 10px 0; color: white; font-weight: 600;">
                                  <i class="fa fa-flask"></i> Laboratory Tests Selection (Optional)
                              </h5>
                              <p style="margin: 0; font-size: 12px; color: rgba(255,255,255,0.9);">
                                  Select tests if needed for this consultation - not mandatory
                              </p>
                          </div>
                          
                          <!-- Test Categories Tabs -->
                          <div class="nav nav-pills" style="margin-bottom: 15px;">
                              <li class="active">
                                  <a href="#hematologyTests" data-toggle="tab" class="test-category-tab">
                                      <i class="fa fa-tint"></i> Hematology
                                  </a>
                              </li>
                              <li>
                                  <a href="#chemistryTests" data-toggle="tab" class="test-category-tab">
                                      <i class="fa fa-flask"></i> Chemistry
                                  </a>
                              </li>
                              <li>
                                  <a href="#microbiologyTests" data-toggle="tab" class="test-category-tab">
                                      <i class="fa fa-bug"></i> Microbiology
                                  </a>
                              </li>
                              <li>
                                  <a href="#serologyTests" data-toggle="tab" class="test-category-tab">
                                      <i class="fa fa-shield"></i> Serology
                                  </a>
                              </li>
                              <li>
                                  <a href="#otherTests" data-toggle="tab" class="test-category-tab">
                                      <i class="fa fa-plus"></i> Others
                                  </a>
                              </li>
                          </div>
                          
                          <!-- Test Categories Content -->
                          <div class="tab-content" style="background: rgba(255,255,255,0.1); border-radius: 6px; padding: 15px;">
                              <div class="tab-pane active" id="hematologyTests">
                                  <div class="row" id="hematologyTestsList">
                                      <div class="col-md-12 text-center text-muted">
                                          <i class="fa fa-spinner fa-spin"></i> Loading hematology tests...
                                      </div>
                                  </div>
                              </div>
                              <div class="tab-pane" id="chemistryTests">
                                  <div class="row" id="chemistryTestsList">
                                      <div class="col-md-12 text-center text-muted">
                                          <i class="fa fa-spinner fa-spin"></i> Loading chemistry tests...
                                      </div>
                                  </div>
                              </div>
                              <div class="tab-pane" id="microbiologyTests">
                                  <div class="row" id="microbiologyTestsList">
                                      <div class="col-md-12 text-center text-muted">
                                          <i class="fa fa-spinner fa-spin"></i> Loading microbiology tests...
                                      </div>
                                  </div>
                              </div>
                              <div class="tab-pane" id="serologyTests">
                                  <div class="row" id="serologyTestsList">
                                      <div class="col-md-12 text-center text-muted">
                                          <i class="fa fa-spinner fa-spin"></i> Loading serology tests...
                                      </div>
                                  </div>
                              </div>
                              <div class="tab-pane" id="otherTests">
                                  <div class="row" id="otherTestsList">
                                      <div class="col-md-12 text-center text-muted">
                                          <i class="fa fa-spinner fa-spin"></i> Loading other tests...
                                      </div>
                                  </div>
                              </div>
                          </div>
                          
                          <!-- Test Selection Summary -->
                          <div style="background: rgba(255,255,255,0.2); border-radius: 6px; padding: 15px; margin-top: 15px;">
                              <div class="row">
                                  <div class="col-md-4">
                                      <strong>Selected Tests:</strong> <span id="selectedTestsCount">0</span>
                                  </div>
                                  <div class="col-md-4">
                                      <strong>Estimated Cost:</strong> Ksh.<span id="estimatedTestsCost">0.00</span>
                                  </div>
                                  <div class="col-md-4 text-right">
                                      <button type="button" id="selectAllTests" class="btn btn-modern btn-sm">
                                          <i class="fa fa-check-square"></i> Select All
                                      </button>
                                      <button type="button" id="clearAllTests" class="btn btn-manual btn-sm">
                                          <i class="fa fa-square-o"></i> Clear All
                                      </button>
                                  </div>
                              </div>
                              <div style="margin-top: 10px;">
                                  <div id="selectedTestsList">
                                      <em class="text-muted">No tests selected</em>
                                  </div>
                              </div>
                          </div>
                          
                          <!-- Test Instructions -->
                          <div class="row" style="margin-top: 15px;">
                              <div class="col-md-6">
                                  <div class="form-group-modern">
                                      <label class="form-label-modern" style="color: white;">Test Priority</label>
                                      <select name="test_priority" id="testPriority" class="form-control form-control-modern">
                                          <option value="normal">Normal</option>
                                          <option value="urgent">Urgent</option>
                                          <option value="stat">STAT</option>
                                      </select>
                                  </div>
                              </div>
                              <div class="col-md-6">
                                  <div class="form-group-modern">
                                      <label class="form-label-modern" style="color: white;">Special Instructions</label>
                                      <input type="text" name="test_instructions" id="testInstructions" class="form-control form-control-modern" placeholder="Special instructions for lab...">
                                  </div>
                              </div>
                          </div>
                      </div>

                      <!-- Hidden fields for verification data -->
                      <input type="hidden" name="patient_id" id="modalPatientIdHidden">
                      <input type="hidden" name="consultation_id" id="modalConsultationId">
                      <input type="hidden" name="verification_status" id="modalVerificationStatus" value="0">
                      <input type="hidden" name="verification_score" id="modalVerificationScore" value="0">
                      <input type="hidden" name="verification_quality" id="modalVerificationQuality" value="">
                      <input type="hidden" name="verification_method" id="modalVerificationMethod" value="">
                      <input type="hidden" name="device_info" id="modalDeviceInfo" value="">
                      <input type="hidden" name="selected_tests" id="selectedTestsInput" value="">
                      <input type="hidden" name="workflow_type" id="modalWorkflowType" value="">
                      <input type="hidden" name="is_gcc_patient" id="modalIsGCCPatient" value="0">
                  </div>

                  <div class="modal-footer">
                      <button type="button" class="btn btn-manual" data-dismiss="modal">Cancel</button>
                      <button type="submit" class="btn btn-modern">
                         <i class="fa fa-save"></i> Save Consultation
                     </button>
                 </div>
             </form>
         </div>
     </div>
  </div>

  <!-- Patient Review Modal -->
  <div class="modal fade modal-modern" id="patientReviewModal" tabindex="-1" role="dialog">
      <div class="modal-dialog modal-lg" role="document">
          <div class="modal-content">
              <div class="modal-header">
                  <button type="button" class="close" data-dismiss="modal">&times;</button>
                  <h4 class="modal-title">
                      <i class="fa fa-eye"></i> Patient Complete History Review
                  </h4>
              </div>
              <div class="modal-body">
                  <!-- Patient Summary Header -->
                  <div class="alert-info-modern">
                      <div class="row">
                          <div class="col-md-8">
                              <strong>Patient:</strong> <span id="reviewPatientName"></span><br>
                              <small>ID: <span id="reviewPatientId"></span> | Age: <span id="reviewPatientAge"></span> | Gender: <span id="reviewPatientGender"></span></small>
                          </div>
                          <div class="col-md-4 text-right">
                              <span id="reviewWorkflowBadge"></span>
                          </div>
                      </div>
                  </div>

                  <!-- Review Content Tabs -->
                  <ul class="nav nav-tabs nav-tabs-modern" style="margin-bottom: 20px;">
                      <li class="active">
                          <a href="#reviewConsultations" data-toggle="tab">
                              <i class="fa fa-user-md"></i> Consultations
                          </a>
                      </li>
                      <li>
                          <a href="#reviewLabTests" data-toggle="tab">
                              <i class="fa fa-flask"></i> Lab Tests
                          </a>
                      </li>
                      <li>
                          <a href="#reviewTriage" data-toggle="tab">
                              <i class="fa fa-stethoscope"></i> Triage History
                          </a>
                      </li>
                      <li>
                          <a href="#reviewVerifications" data-toggle="tab">
                              <i class="fa fa-shield"></i> Verifications
                          </a>
                      </li>
                      <li>
                          <a href="#reviewSummary" data-toggle="tab">
                              <i class="fa fa-chart-line"></i> Summary
                          </a>
                      </li>
                  </ul>

                  <div class="tab-content">
                      <!-- Consultations History -->
                      <!-- In the Patient Review Modal -->
<div class="tab-pane active" id="reviewConsultations">
    <div class="patient-review-panel">
        <div class="review-section">
            <h6><i class="fa fa-user-md"></i> Recent Consultations</h6>
            <!-- ✅ Use a different ID for the modal -->
            <div id="modalConsultationsList">
                <div class="text-center">
                    <div class="spinner-modern"></div> Loading consultation history...
                </div>
            </div>
        </div>
    </div>
</div>

                      <!-- Lab Tests History -->
                      <div class="tab-pane" id="reviewLabTests">
                          <div class="patient-review-panel">
                              <div class="review-section">
                                  <h6><i class="fa fa-flask"></i> Laboratory Test Results</h6>
                                  <div id="reviewLabTestsList">
                                      <div class="text-center">
                                          <div class="spinner-modern"></div> Loading lab test history...
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>

                      <!-- Triage History -->
                      <div class="tab-pane" id="reviewTriage">
                          <div class="patient-review-panel">
                              <div class="review-section">
                                  <h6><i class="fa fa-stethoscope"></i> Triage Assessment History</h6>
                                  <div id="reviewTriageList">
                                      <div class="text-center">
                                          <div class="spinner-modern"></div> Loading triage history...
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>

                      <!-- Verification History -->
                      <div class="tab-pane" id="reviewVerifications">
                          <div class="patient-review-panel">
                              <div class="review-section">
                                  <h6><i class="fa fa-shield"></i> Biometric Verification History</h6>
                                  <div id="reviewVerificationsList">
                                      <div class="text-center">
                                          <div class="spinner-modern"></div> Loading verification history...
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>

                      <!-- Patient Summary -->
                      <div class="tab-pane" id="reviewSummary">
                          <div class="patient-review-panel">
                              <div class="review-section">
                                  <h6><i class="fa fa-chart-line"></i> Patient Summary Statistics</h6>
                                  <div class="row">
                                      <div class="col-md-3">
                                          <div class="summary-card">
                                              <div class="summary-card-icon">
                                                  <i class="fa fa-user-md"></i>
                                              </div>
                                              <div class="summary-card-value" id="totalConsultations">0</div>
                                              <div class="summary-card-label">Total Consultations</div>
                                          </div>
                                      </div>
                                      <div class="col-md-3">
                                          <div class="summary-card">
                                              <div class="summary-card-icon">
                                                  <i class="fa fa-flask"></i>
                                              </div>
                                              <div class="summary-card-value" id="totalLabTests">0</div>
                                              <div class="summary-card-label">Lab Tests Done</div>
                                          </div>
                                      </div>
                                      <div class="col-md-3">
                                          <div class="summary-card">
                                              <div class="summary-card-icon">
                                                  <i class="fa fa-stethoscope"></i>
                                              </div>
                                              <div class="summary-card-value" id="totalTriageVisits">0</div>
                                              <div class="summary-card-label">Triage Visits</div>
                                          </div>
                                      </div>
                                      <div class="col-md-3">
                                          <div class="summary-card">
                                              <div class="summary-card-icon">
                                                  <i class="fa fa-shield"></i>
                                              </div>
                                              <div class="summary-card-value" id="totalVerifications">0</div>
                                              <div class="summary-card-label">Verifications</div>
                                          </div>
                                      </div>
                                  </div>
                                  
                                  <!-- Additional Summary Info -->
                                  <div class="review-section">
                                      <h6><i class="fa fa-info-circle"></i> Additional Information</h6>
                                      <div id="patientAdditionalInfo">
                                          <div class="review-item">
                                              <strong>First Visit:</strong> <span id="firstVisitDate">N/A</span>
                                          </div>
                                          <div class="review-item">
                                              <strong>Last Visit:</strong> <span id="lastVisitDate">N/A</span>
                                          </div>
                                          <div class="review-item">
                                              <strong>Most Common Diagnoses:</strong> <span id="commonDiagnoses">N/A</span>
                                          </div>
                                          <div class="review-item">
                                              <strong>Workflow Type:</strong> <span id="patientWorkflowType">N/A</span>
                                          </div>
                                      </div>
                                  </div>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
              <div class="modal-footer">
                  <button type="button" class="btn btn-info-modern" id="printPatientSummary">
                      <i class="fa fa-print"></i> Print Summary
                  </button>
                  <button type="button" class="btn btn-modern" id="startNewConsultationFromReview">
                      <i class="fa fa-user-md"></i> Start New Consultation
                  </button>
                  <button type="button" class="btn btn-manual" data-dismiss="modal">Close</button>
              </div>
          </div>
      </div>
  </div>

  <!-- Lab Test Results Modal -->
  <div class="modal fade modal-modern" id="testResultsModal" tabindex="-1" role="dialog">
      <div class="modal-dialog" role="document">
          <div class="modal-content">
              <div class="modal-header">
                  <button type="button" class="close" data-dismiss="modal">&times;</button>
                  <h4 class="modal-title">
                      <i class="fa fa-flask"></i> Test Results Entry
                 </h4>
             </div>
             <form id="testResultsForm">
                 <div class="modal-body">
                     <div class="alert-info-modern">
                         <strong>Patient:</strong> <span id="resultPatientName"></span><br>
                         <strong>Test:</strong> <span id="resultTestName"></span>
                     </div>
                     
                     <div class="form-group-modern">
                         <label class="form-label-modern">Test Result <span class="text-danger">*</span></label>
                         <textarea name="test_result" id="testResult" class="form-control form-control-modern" rows="4" placeholder="Enter test results..." required></textarea>
                     </div>
                     
                     <div class="row">
                         <div class="col-md-6">
                             <div class="form-group-modern">
                                 <label class="form-label-modern">Result Status</label>
                                 <select name="result_status" id="resultStatus" class="form-control form-control-modern">
                                     <option value="normal">Normal</option>
                                     <option value="abnormal">Abnormal</option>
                                     <option value="critical">Critical</option>
                                     <option value="pending">Pending</option>
                                 </select>
                             </div>
                         </div>
                         <div class="col-md-6">
                             <div class="form-group-modern">
                                 <label class="form-label-modern">Reference Range</label>
                                 <input type="text" name="reference_range" id="referenceRange" class="form-control form-control-modern" placeholder="Normal range...">
                             </div>
                         </div>
                     </div>
                     
                     <div class="form-group-modern">
                         <label class="form-label-modern">Lab Notes</label>
                         <textarea name="lab_notes" id="labNotes" class="form-control form-control-modern" rows="2" placeholder="Laboratory notes..."></textarea>
                     </div>
                     
                     <input type="hidden" name="test_id" id="resultTestId">
                 </div>
                 
                 <div class="modal-footer">
                     <button type="button" class="btn btn-manual" data-dismiss="modal">Cancel</button>
                     <button type="submit" class="btn btn-modern">
                         <i class="fa fa-save"></i> Save Results
                     </button>
                 </div>
             </form>
         </div>
     </div>
  </div>

  <!-- Include necessary JavaScript libraries -->
  <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/3.4.1/js/bootstrap.min.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>
  <!-- Replace the existing JsBarcode script tag with this -->
<script src="https://cdn.jsdelivr.net/npm/jsbarcode@3.11.5/dist/JsBarcode.all.min.js"></script>
  <!-- Include SecuGen WebAPI scripts -->
  <script src="./WebAPI-JavaScript/secugen.js"></script>
<script>
    // Enhanced Consultation System - JavaScript Logic
// Enhanced with optional lab tests, GCC diagnosis hiding, and patient review functionality
'use strict';

$(document).ready(function() {
    console.log('🔬 ENHANCED Consultation System Starting...');
    
    // Initialize with modern visual feedback
    initializeEnhancedConsultationSystem();
    
    // Set current date for forms
    const today = new Date().toISOString().split('T')[0];
    $('#consultationDate, #reportDateFrom, #reportDateTo').val(today);
});

// =============================================
// ENHANCED SYSTEM INITIALIZATION
// =============================================

function initializeEnhancedConsultationSystem() {
    logDiagnostic('🚀 Initializing ENHANCED Consultation System...', 'info');
    
    // Initialize modern visual elements
    updateStepIndicator('search');
    initializeModernAnimations();
    
    // SecuGen configuration
    window.secugenConfig = {
        baseUrl: 'https://localhost:8443',
        httpUrl: 'http://localhost:8443',
        endpoints: {
            https: {
                capture: 'https://localhost:8443/SGIFPCapture',
                matchScore: 'https://localhost:8443/SGIMatchScore',
                getInfo: 'https://localhost:8443/SGIFPGetInfo'
            },
            http: {
                capture: 'http://localhost:8443/SGIFPCapture',
                matchScore: 'http://localhost:8443/SGIMatchScore',
                getInfo: 'http://localhost:8443/SGIFPGetInfo'
            }
        },
        currentProtocol: 'https',
        serviceActive: false,
        deviceConnected: false,
        quality: 50,
        timeout: 20000,
        lastError: null
    };

    // Enhanced consultation configuration
    window.consultationConfig = {
        baseURL: window.location.origin + window.location.pathname.split('/').slice(0, -2).join('/') + '/',
        endpoints: {
            getAllPatients: 'admin/consultation/getAllPatients',
            getPatientDetails: 'admin/consultation/getPatientDetails',
            getStoredTemplate: 'admin/consultation/getStoredFingerprintTemplate',
            saveConsultation: 'admin/consultation/saveWithLabTests',
            getLabTests: 'admin/consultation/getLabTestsForConsultation',
            getIcdDiagnoses: 'admin/consultation/getIcdDiagnoses',
            saveTestResults: 'admin/consultation/saveTestResults',
            getAllDoctors: 'admin/consultation/getAllDoctors',
            // NEW: Patient review endpoints
            getPatientHistory: 'admin/consultation/getPatientCompleteHistory',
            getPatientConsultations: 'admin/consultation/getPatientConsultations',
            getPatientLabTests: 'admin/consultation/getPatientLabTests',
            getPatientTriageHistory: 'admin/triage/getPatientTriageHistory',  // FIXED: Use triage controller
            getPatientVerifications: 'admin/consultation/getPatientVerifications'
        }
    };

    // ENHANCED consultation state management
    window.consultationState = {
        verificationPassed: false,
        selectedPatientId: null,
        selectedPatientData: null,
        patientWorkflow: null,
        requiresVerification: false,
        storedTemplate: null,
        liveTemplate: null,
        lastVerificationResult: null,
        verificationHistory: [],
        currentMatchScore: 0,
        verificationQuality: 'Unknown',
        currentConsultationId: null,
        isGCCPatient: false,
        verificationRequired: false,
        patientWorkflowType: 'General',
        secugenActive: false,
        
        // Lab tests state - MADE OPTIONAL
        labTests: {
            available: {},
            selected: [],
            categories: {},
            estimatedCost: 0,
            isRequired: false  // NEW: Lab tests are optional
        },
        
        // Diagnosis state
        selectedDiagnosis: null,
        
        // NEW: Patient review state
        patientReview: {
            consultations: [],
            labTests: [],
            triageHistory: [],
            verifications: [],
            summary: {}
        }
    };
    
    // Initialize all functionality
    setTimeout(function() {
        initializeSecuGenService();
        loadPatients();
        initializeEvents();
        
        showModernMessage('🔬 ENHANCED Consultation system ready!', 'success');
    }, 1500);
}

// =============================================
// SECUGEN INTEGRATION
// =============================================

function initializeSecuGenService() {
    logDiagnostic('Initializing SecuGen WebAPI service...', 'info');
    
    $('#secugen_service_status').html('<div class="status-info"><i class="fa fa-spinner fa-spin"></i> Initializing SecuGen service detection...</div>');
    
    setTimeout(function() {
        logDiagnostic("Starting SecuGen service detection...");
        testHttpsConnection();
        setTimeout(function() {
            if (!window.consultationState.secugenActive) {
                testHttpConnection();
            }
        }, 3000);
    }, 1000);
}

function testHttpsConnection() {
    logDiagnostic("Testing HTTPS connection to localhost:8443...");
    
    const xhr = new XMLHttpRequest();
    xhr.open('GET', 'https://localhost:8443/SGIFPGetInfo', true);
    xhr.timeout = 5000;
    
    xhr.onreadystatechange = function() {
        if (xhr.readyState === 4) {
            if (xhr.status === 200) {
                logDiagnostic("✓ HTTPS connection successful!", 'success');
                window.consultationState.secugenActive = true;
                $('#manualVerifyBtn').prop('disabled', false);
                $('#secugen_service_status').html('<div class="status-success"><i class="fa fa-check"></i> SecuGen HTTPS service active</div>');
            } else if (xhr.status === 0) {
                logDiagnostic("✗ HTTPS blocked - possibly CORS or SSL certificate issue", 'error');
                suggestHttpsFix();
            } else {
                logDiagnostic(`✗ HTTPS failed with status: ${xhr.status}`, 'error');
            }
        }
    };
    
    xhr.onerror = function() {
        logDiagnostic("✗ HTTPS connection error - network or SSL issue", 'error');
        suggestHttpsFix();
    };
    
    xhr.ontimeout = function() {
        logDiagnostic("✗ HTTPS connection timeout", 'error');
    };
    
    xhr.send();
}

function testHttpConnection() {
    logDiagnostic("Testing HTTP connection to localhost:8443...");
    
    $.ajax({
        url: 'http://localhost:8443/SGIFPGetInfo',
        type: 'GET',
        timeout: 5000,
        success: function(data) {
            logDiagnostic("✓ HTTP connection successful!", 'success');
            window.consultationState.secugenActive = true;
            $('#manualVerifyBtn').prop('disabled', false);
            $('#secugen_service_status').html('<div class="status-success"><i class="fa fa-check"></i> SecuGen HTTP service active</div>');
        },
        error: function(xhr) {
            if (xhr.status === 0) {
                logDiagnostic("✗ HTTP blocked - possibly CORS issue", 'error');
            } else {
                logDiagnostic(`✗ HTTP failed with status: ${xhr.status}`, 'error');
            }
        }
    });
}

function suggestHttpsFix() {
    const suggestions = `
        <div class="status-warning" style="font-size: 11px; margin-top: 10px;">
            <strong>HTTPS Connection Issues - Try these fixes:</strong><br>
            1. <strong>Accept SSL Certificate:</strong> Visit <a href="https://localhost:8443/SGIFPGetInfo" target="_blank">https://localhost:8443/SGIFPGetInfo</a> and accept the security warning<br>
            2. <strong>Run browser as Administrator</strong><br>
            3. <strong>Check Windows Firewall</strong> - ensure port 8443 is allowed<br>
            4. <strong>Try the Manual Capture button</strong> below
        </div>
    `;
    $('#secugen_service_status').html(suggestions);
}

// =============================================
// PATIENT LOADING AND MANAGEMENT
// =============================================

function loadPatients() {
    console.log('🔄 Loading patients with enhanced UI feedback...');
    
    $('#consultation_patient_search').html('<option value="">Loading patients...</option>');
    showModernMessage('Loading patient database...', 'info', 2000);
    
    const endpoint = window.consultationConfig.baseURL + window.consultationConfig.endpoints.getAllPatients;
    
    console.log('🌐 Enhanced endpoint call:', endpoint);
    
    $.ajax({
        url: endpoint,
        type: 'GET',
        dataType: 'json',
        timeout: 15000,
        success: function(response) {
            console.log('📥 Enhanced response received:', response);
            handleEnhancedPatientLoadSuccess(response);
        },
        error: function(xhr, status, error) {
            console.error('❌ Enhanced AJAX Error:', status, error);
            handleEnhancedPatientLoadError(xhr, status, error);
        }
    });
}

function handleEnhancedPatientLoadSuccess(response) {
    console.log('✅ Processing enhanced patient response...');
    
    try {
        let patients = [];
        
        if (response && typeof response === 'object') {
            if (response.status === 'error') {
                showModernMessage('Server Error: ' + response.message, 'error');
                return;
            }
            
            if (response.status === 'success' && response.patients && Array.isArray(response.patients)) {
                patients = response.patients;
            } else if (response.patients && Array.isArray(response.patients)) {
                patients = response.patients;
            } else if (Array.isArray(response)) {
                patients = response;
            } else {
                showModernMessage('Unexpected response format from server', 'warning');
                return;
            }
        } else {
            showModernMessage('Invalid response format', 'error');
            return;
        }
        
        if (patients.length > 0) {
            populateEnhancedPatientDropdown(patients);
            
            let message = `✅ Successfully loaded ${patients.length} patients`;
            if (response.workflow_stats) {
                const stats = response.workflow_stats;
                message += ` (GCC: ${stats.gcc || 0}, General: ${stats.general || 0})`;
            }
            
            showModernMessage(message, 'success');
        } else {
            showModernMessage('No patients found in database', 'warning');
        }
        
    } catch (error) {
        console.error('❌ Error processing enhanced response:', error);
        showModernMessage('Failed to process response: ' + error.message, 'error');
    }
}

function populateEnhancedPatientDropdown(patients) {
    console.log('👥 Populating enhanced patient dropdown with', patients.length, 'patients');
    
    const select = $('#consultation_patient_search');
    select.empty();
    select.append(`<option value="">Select Patient for Consultation (${patients.length} total)</option>`);
    
    let processedCount = 0;
    let gccCount = 0;
    let generalCount = 0;
    
    $.each(patients, function(index, patient) {
        try {
            let patientName = patient.patient_name || `Patient #${patient.id}`;
            let text = `${patientName} (ID: ${patient.id})`;
            
            if (patient.mobileno) {
                text += ` - ${patient.mobileno}`;
            }
            
            if (patient.age && patient.age !== 'Unknown') {
                text += ` - ${patient.age}y`;
            }
            
            if (patient.gender) {
                text += ` - ${patient.gender}`;
            }
            
            let workflow = patient.patient_workflow || 
                          patient.workflow || 
                          patient.patient_type || 
                          patient.type ||
                          'general';
            
            let isGCCPatient = workflow.toLowerCase() === 'gcc';
            let requiresVerification = isGCCPatient;
            let hasFingerprint = patient.has_fingerprint == 1;
            
            if (isGCCPatient) {
                text += ' [GCC - Verification Required]';
                gccCount++;
            } else {
                text += ' [General]';
                generalCount++;
            }
            
            if (hasFingerprint) {
                text += ' 🔐';
            }
            
            const option = $('<option>', {
                value: patient.id,
                text: text,
                'data-workflow': workflow.toLowerCase(),
                'data-has-fingerprint': hasFingerprint ? 1 : 0,
                'data-requires-verification': requiresVerification ? 1 : 0,
                'data-phone': patient.mobileno || '',
                'data-age': patient.age || '',
                'data-gender': patient.gender || '',
                'data-stored-template': patient.fingerprint_template || ''
            });
            
            select.append(option);
            processedCount++;
            
        } catch (error) {
            console.error('❌ Error processing enhanced patient', patient.id, ':', error);
        }
    });
    
    console.log(`✅ Enhanced processing completed ${processedCount}/${patients.length} patients`);
    console.log(`📊 Workflow distribution: GCC: ${gccCount}, General: ${generalCount}`);
    
    // Initialize enhanced Select2
    if (typeof $.fn.select2 !== 'undefined') {
        select.select2({
            placeholder: 'Search patients for enhanced consultation...',
            allowClear: true,
            width: '100%'
        });
    }
}

function handleEnhancedPatientLoadError(xhr, status, error) {
    console.error('❌ Handling enhanced patient load error...');
    
    $('#consultation_patient_search').html('<option value="">Error loading patients</option>');
    
    let errorMessage = 'Failed to load patients for enhanced consultation';
    
    if (xhr.status === 404) {
        errorMessage = 'Patient loading endpoint not found (404)';
    } else if (xhr.status === 500) {
        errorMessage = 'Server error loading patients (500)';
    } else if (xhr.status === 0) {
        errorMessage = 'Network error - cannot connect to server';
    } else if (status === 'timeout') {
        errorMessage = 'Request timeout - server response too slow';
    } else if (status === 'parsererror') {
        errorMessage = 'Invalid response format from server';
    }
    
    showModernMessage(errorMessage, 'error');
}

// =============================================
// ENHANCED PATIENT DETAILS WITH PROPER WORKFLOW SUPPORT
// =============================================

function loadEnhancedPatientDetails(patientId) {
    if (!patientId) {
        $('#patientDetailsSection').hide();
        resetEnhancedVerificationState();
        return;
    }
    
    console.log('🔍 ENHANCED: Loading patient details for ID:', patientId);
    
    window.consultationState.selectedPatientId = patientId;
    $('#selectedPatientId').val(patientId);
    $('#patientDetailsSection').show().addClass('fade-in');
    
    // Get workflow information from option
    const selectedOption = $('#consultation_patient_search').find(':selected');
    const patientWorkflow = selectedOption.data('workflow') || 'general';
    const hasFingerprint = selectedOption.data('has-fingerprint') == 1;
    
    // Determine verification requirement based on workflow
    const isGCCPatient = patientWorkflow.toLowerCase() === 'gcc';
    const requiresVerification = isGCCPatient;
    
    console.log('🔧 ENHANCED Workflow Detection:');
    console.log('  - Workflow:', patientWorkflow);
    console.log('  - Is GCC Patient:', isGCCPatient);
    console.log('  - Has Fingerprint:', hasFingerprint);
    console.log('  - Requires Verification:', requiresVerification);
    
    // Store workflow information
    window.consultationState.patientWorkflow = patientWorkflow;
    window.consultationState.requiresVerification = requiresVerification;
    window.consultationState.verificationRequired = requiresVerification;
    window.consultationState.isGCCPatient = isGCCPatient;
    window.consultationState.patientWorkflowType = isGCCPatient ? 'GCC Workflow' : 'General Workflow';
    
    window.consultationState.selectedPatientData = {
        id: patientId,
        workflow: patientWorkflow,
        has_fingerprint: hasFingerprint,
        requires_verification: requiresVerification,
        stored_template: ''
    };
    
    resetEnhancedVerificationState();
    
    // Proper workflow handling
    if (requiresVerification) {
        console.log('🔒 ENHANCED: GCC PATIENT - VERIFICATION REQUIRED');
        setupGCCPatientWorkflow();
    } else {
        console.log('🔓 ENHANCED: GENERAL PATIENT - VERIFICATION OPTIONAL');
        setupGeneralPatientWorkflow();
    }
    
    updateStepIndicator('verify');
    
    // Load patient details via AJAX
    loadPatientDetailsFromServer(patientId, selectedOption);
}

// Separate workflow setup functions
function setupGCCPatientWorkflow() {
    console.log('🔒 Setting up GCC patient workflow - VERIFICATION MANDATORY');
    
    // Show verification section
    $('#biometricVerificationSection').show().addClass('gcc-required');
    
    // Update UI to reflect GCC status
    $('#workflowStatusPanel').removeClass('gcc-workflow').addClass('gcc-unverified');
    $('#workflowBadge').text('GCC Patient - Verification Required').removeClass().addClass('workflow-badge status-required');
    
    $('#currentPatientStatus').html(`
        <p style="margin: 0; font-size: 12px; color: white;">
            <i class="fa fa-shield"></i> <strong>GCC Patient Protocol Active</strong><br>
            Biometric verification is MANDATORY before consultation
        </p>
    `);
    
    // Patient card styling
    $('#patientDetailsCard').removeClass('verified gcc-patient').addClass('gcc-unverified');
    
    // Status message
    $('#fingerprintStatus').html(`
        <div class="status-warning">
            <i class="fa fa-shield"></i> <strong>GCC Patient - Biometric verification required</strong><br>
            <small>This patient requires mandatory fingerprint verification before consultation</small>
        </div>
    `);
    
    // Disable consultation button until verified
    $('#startConsultationBtn').prop('disabled', true);
    $('#reviewPatientBtn').prop('disabled', false); // Review is always available
    $('#verificationMessage').html(`
        <div class="alert-warning-modern">
            <i class="fa fa-exclamation-triangle"></i> <strong>Verification Required:</strong> Complete biometric verification to enable consultation
        </div>
    `);
    
    console.log('✅ GCC workflow setup complete - consultation button disabled, review enabled');
}

function setupGeneralPatientWorkflow() {
    console.log('🔓 Setting up General patient workflow - VERIFICATION OPTIONAL');
    
    // Hide verification section for general patients
    $('#biometricVerificationSection').hide();
    
    // Update UI to reflect general status
    $('#workflowStatusPanel').removeClass('gcc-unverified gcc-workflow');
    $('#workflowBadge').text('General Patient').removeClass().addClass('workflow-badge status-general');
    $('#currentPatientStatus').html(`
       <p style="margin: 0; font-size: 12px; color: white;">
           <i class="fa fa-user"></i> <strong>General Patient Workflow</strong><br>
           Biometric verification is optional for this patient type
       </p>
   `);
   
   // Patient card styling
   $('#patientDetailsCard').removeClass('gcc-unverified gcc-patient verified');
   
   // Enable consultation directly
   enableEnhancedConsultationDirectly();
   
   console.log('✅ General workflow setup complete - consultation button enabled');
}

function loadPatientDetailsFromServer(patientId, selectedOption) {
   $.ajax({
       url: window.consultationConfig.baseURL + window.consultationConfig.endpoints.getPatientDetails,
       type: 'POST',
       data: { id: patientId },
       dataType: 'json',
       success: function(response) {
           console.log('Patient details response:', response);
           
           if (response && response.patient_name) {
               populatePatientDetails(response);
               loadStoredFingerprintTemplate(patientId, response.has_fingerprint);
               loadPatientConsultationsHistory(patientId); // ✅ Use this instead
           } else {
               // Fallback to option data
               populatePatientDetailsFromOption(selectedOption);
               if (selectedOption.data('has-fingerprint')) {
                   loadStoredFingerprintTemplate(patientId, true);
               }
               loadPatientConsultationsHistory(patientId); // ✅ Use this instead
           }
       },
       error: function(xhr, status, error) {
           console.error('Error loading patient details:', error);
           populatePatientDetailsFromOption(selectedOption);
           if (selectedOption.data('has-fingerprint')) {
               loadStoredFingerprintTemplate(patientId, true);
           }
           loadPatientConsultationsHistory(patientId); // ✅ Use this instead
       }
   });
}

function populatePatientDetails(patient) {
    $('#patientName').text(patient.patient_name || 'Unknown');
    $('#patientAge').text((patient.age || 'Unknown') + ' years');
    $('#patientGender').text(patient.gender || 'Unknown');
    $('#patientPhone').text(patient.mobileno || 'N/A');
    $('#patientBloodGroup').text(patient.blood_group_name || 'Unknown');
    $('#patientAllergies').text(patient.known_allergies || 'None');
    
    // Enhanced image setting
    if (patient.image) {
        let imagePath = patient.image;
        if (!imagePath.startsWith('../') && !imagePath.startsWith('http')) {
            imagePath = '../' + imagePath;
        }
        $('#patientPhoto').attr('src', imagePath);
    } else {
        $('#patientPhoto').attr('src', '../uploads/patient_images/no_image.png');
    }
    
    // Generate patient barcode
    generatePatientBarcode(patient);
}

function populatePatientDetailsFromOption(selectedOption) {
   const patientName = selectedOption.text().split(' (')[0];
   $('#patientName').text(patientName);
   $('#patientAge').text(selectedOption.data('age') || 'Unknown');
   $('#patientGender').text(selectedOption.data('gender') || 'Unknown');
   $('#patientPhone').text(selectedOption.data('phone') || 'N/A');
   $('#patientBloodGroup').text('Unknown');
   $('#patientAllergies').text('None');
}

// Only enable consultation for general patients
function enableEnhancedConsultationDirectly() {
   console.log('🔓 ENHANCED: Enabling consultation directly (no verification required)');
   
   // Only enable if this is actually a general patient
   if (!window.consultationState.requiresVerification) {
       window.consultationState.verificationPassed = true;
       $('#verificationPassed').val('1');
       $('#startConsultationBtn').prop('disabled', false);
       $('#reviewPatientBtn').prop('disabled', false);
       
       $('#verificationStatus').html('<span class="status-indicator status-general"><i class="fa fa-check-circle"></i> General Patient</span>');
       
       $('#verificationMessage').html(`
           <div class="alert-success-modern">
               <i class="fa fa-check-circle"></i> General patient - consultation enabled without verification requirement
           </div>
       `);
       
       updateStepIndicator('consult');
       console.log('✅ ENHANCED: Consultation enabled for general patient');
   } else {
       console.log('🔒 ENHANCED: Cannot enable consultation - this is a GCC patient requiring verification');
   }
}

// =============================================
// NEW: PATIENT REVIEW FUNCTIONALITY
// =============================================

function reviewPatientHistory() {
    const patientId = window.consultationState.selectedPatientId;
    if (!patientId) {
        showModernMessage('Please select a patient first', 'warning');
        return;
    }
    
    console.log('📋 Opening patient review for ID:', patientId);
    
    // Populate review modal header
    $('#reviewPatientName').text($('#patientName').text());
    $('#reviewPatientId').text(patientId);
    $('#reviewPatientAge').text($('#patientAge').text());
    $('#reviewPatientGender').text($('#patientGender').text());
    
    // Set workflow badge
    if (window.consultationState.isGCCPatient) {
        $('#reviewWorkflowBadge').html('<span class="status-indicator status-gcc"><i class="fa fa-shield"></i> GCC Patient</span>');
    } else {
        $('#reviewWorkflowBadge').html('<span class="status-indicator status-general"><i class="fa fa-user"></i> General Patient</span>');
    }
    
    // Load all patient data
    loadPatientCompleteHistory(patientId);
    
    // Show the review modal
    $('#patientReviewModal').modal('show');
}

// Add this right before your AJAX call
console.log('displayConsultationsHistory function exists:', typeof displayConsultationsHistory === 'function');
console.log('displayConsultationsHistory function:', displayConsultationsHistory);

function loadPatientCompleteHistory(patientId) {
    console.log('📊 Loading complete patient history for ID:', patientId);
    
    // Load consultations
    loadPatientConsultationsHistory(patientId);
    
    // Load lab tests
    loadPatientLabTestsHistory(patientId);
    
    // Load triage history
    loadPatientTriageHistory(patientId);
    
    // Load verification history
    loadPatientVerificationHistory(patientId);
    
    // Load summary statistics
    loadPatientSummaryStatistics(patientId);
}

function loadPatientConsultationsHistory(patientId) {
    $('#reviewConsultationsList').html('<div class="text-center"><div class="spinner-modern"></div> Loading consultation history...</div>');
    
    $.ajax({
        url: window.consultationConfig.baseURL + window.consultationConfig.endpoints.getPatientConsultations,
        type: 'POST',
        data: { patient_id: patientId },
        dataType: 'json',
        success: function(response) {
            console.log('Consultations response:', response);
            console.log('Response status:', response.status);
            console.log('Consultations array:', response.consultations);
            console.log('Consultations length:', response.consultations ? response.consultations.length : 'undefined');
            
            if (response && response.status === 'success' && response.consultations) {
                if (response.consultations.length > 0) {
                    console.log('=== ABOUT TO CALL displayConsultationsHistory ===');
                    console.log('Function exists:', typeof displayConsultationsHistory === 'function');
                    
                    // Try calling the function
                    try {
                        displayConsultationsHistory(response.consultations);
                        console.log('=== displayConsultationsHistory called successfully ===');
                    } catch (error) {
                        console.error('Error calling displayConsultationsHistory:', error);
                        console.error('Error stack:', error.stack);
                    }
                    
                    window.consultationState.patientReview.consultations = response.consultations;
                } else {
                    $('#reviewConsultationsList').html('<div class="review-item">No consultations found for this patient</div>');
                }
            } else {
                $('#reviewConsultationsList').html('<div class="review-item">No consultation history found</div>');
            }
        },
        error: function(xhr, status, error) {
            console.error('Error loading consultations:', error);
            console.error('XHR response:', xhr.responseText);
            $('#reviewConsultationsList').html('<div class="review-item text-danger">Error loading consultation history</div>');
        }
    });
}

function displayConsultationsHistory(consultations) {
    console.log('=== ROBUST DISPLAY METHOD ===');
    
    // Update both the main page and modal if they exist
    const mainPageElement = document.getElementById('reviewConsultationsList');
    const modalElement = document.getElementById('modalConsultationsList');
    
    if (!consultations || consultations.length === 0) {
        if (mainPageElement) {
            mainPageElement.innerHTML = '<div class="review-item">No consultations to display</div>';
        }
        if (modalElement) {
            modalElement.innerHTML = '<div class="review-item">No consultations to display</div>';
        }
        return;
    }
    
    // Generate HTML for consultations
    let html = '';
    consultations.forEach(function(consultation, index) {
        html += `
            <div class="review-item" style="border: 1px solid #ddd; margin: 10px 0; padding: 10px; background: #f9f9f9; border-radius: 4px;">
                <div style="margin-bottom: 8px;">
                    <strong>Date:</strong> ${consultation.consultation_date || consultation.date || 'Unknown date'}<br>
                    <strong>Doctor:</strong> ${consultation.doctor_name || 'Unknown Doctor'}
                </div>
                ${consultation.symptoms ? `<div><strong>Symptoms:</strong> ${consultation.symptoms}</div>` : ''}
                ${consultation.diagnosis ? `<div><strong>Diagnosis:</strong> ${consultation.diagnosis}</div>` : ''}
                ${consultation.notes ? `<div><strong>Notes:</strong> ${consultation.notes}</div>` : ''}
            </div>
        `;
    });
    
    // Update both elements
    if (mainPageElement) {
        mainPageElement.innerHTML = html;
        console.log('✅ Updated main page consultations');
    }
    
    if (modalElement) {
        modalElement.innerHTML = html;
        console.log('✅ Updated modal consultations');
    }
    
    console.log('✅ Consultations displayed in both locations');
}

function loadPatientLabTestsHistory(patientId) {
    $('#reviewLabTestsList').html('<div class="text-center"><div class="spinner-modern"></div> Loading lab test history...</div>');
    
    $.ajax({
        url: window.consultationConfig.baseURL + window.consultationConfig.endpoints.getPatientLabTests,
        type: 'POST',
        data: { patient_id: patientId },
        dataType: 'json',
        success: function(response) {
            console.log('Lab tests response:', response);
            
            if (response && response.status === 'success' && response.lab_tests) {
                displayLabTestsHistory(response.lab_tests);
                window.consultationState.patientReview.labTests = response.lab_tests;
            } else {
                $('#reviewLabTestsList').html('<div class="review-item">No lab test history found</div>');
            }
        },
        error: function(xhr, status, error) {
            console.error('Error loading lab tests:', error);
            $('#reviewLabTestsList').html('<div class="review-item text-danger">Error loading lab test history</div>');
        }
    });
}

function displayLabTestsHistory(labTests) {
    if (labTests.length === 0) {
        $('#reviewLabTestsList').html('<div class="review-item">No lab tests found</div>');
        return;
    }
    
    let html = '';
    labTests.forEach(test => {
        const testDate = new Date(test.test_date).toLocaleDateString();
        const statusClass = test.result_status === 'normal' ? 'text-success' : 
                          test.result_status === 'critical' ? 'text-danger' : 'text-warning';
        
        html += `
            <div class="review-item">
                <div class="row">
                    <div class="col-md-8">
                        <strong>Test:</strong> ${test.test_name}<br>
                        <strong>Date:</strong> ${testDate}<br>
                        ${test.test_result ? `<strong>Result:</strong> ${test.test_result}<br>` : ''}
                        ${test.reference_range ? `<strong>Reference:</strong> ${test.reference_range}` : ''}
                    </div>
                    <div class="col-md-4 text-right">
                        <span class="label ${statusClass === 'text-success' ? 'label-success' : 
                                          statusClass === 'text-danger' ? 'label-danger' : 'label-warning'}">
                           ${test.result_status || 'Pending'}
                       </span><br>
                       ${test.lab_notes ? `<small>${test.lab_notes}</small>` : ''}
                   </div>
               </div>
           </div>
       `;
   });
   
   $('#reviewLabTestsList').html(html);
}

function loadPatientTriageHistory(patientId) {
    $('#reviewTriageList').html('<div class="text-center"><div class="spinner-modern"></div> Loading triage history...</div>');
    
    $.ajax({
        url: window.consultationConfig.baseURL + window.consultationConfig.endpoints.getPatientTriageHistory,
        type: 'POST',
        data: { patient_id: patientId },
        dataType: 'json',
        timeout: 10000,
        success: function(response) {
            console.log('Triage response:', response);
            
            if (response && response.status === 'success' && response.triage_history) {
                displayTriageHistory(response.triage_history);
                window.consultationState.patientReview.triageHistory = response.triage_history;
            } else {
                $('#reviewTriageList').html(`
                    <div class="review-item">
                        <div class="text-muted">
                            <i class="fa fa-info-circle"></i> No triage history found for this patient
                        </div>
                    </div>
                `);
            }
        },
        error: function(xhr, status, error) {
            console.error('Error loading triage history:', error);
            
            // Show user-friendly error message
            $('#reviewTriageList').html(`
                <div class="review-item">
                    <div class="text-warning">
                        <i class="fa fa-exclamation-triangle"></i> Triage history endpoint not available<br>
                        <small>This feature requires backend implementation</small>
                    </div>
                </div>
            `);
        }
    });
}

function displayTriageHistory(triageHistory) {
   if (triageHistory.length === 0) {
       $('#reviewTriageList').html('<div class="review-item">No triage visits found</div>');
       return;
   }
   
   let html = '';
   triageHistory.forEach(triage => {
       const triageDate = new Date(triage.triage_date).toLocaleDateString();
       const priorityClass = triage.priority === 'high' ? 'text-danger' : 
                           triage.priority === 'medium' ? 'text-warning' : 'text-success';
       
       html += `
           <div class="review-item">
               <div class="row">
                   <div class="col-md-8">
                       <strong>Date:</strong> ${triageDate}<br>
                       <strong>Chief Complaint:</strong> ${triage.chief_complaint || 'Not recorded'}<br>
                       <strong>Vital Signs:</strong> BP: ${triage.blood_pressure || 'N/A'}, 
                       Temp: ${triage.temperature || 'N/A'}°C, 
                       Pulse: ${triage.pulse || 'N/A'}<br>
                       ${triage.assessment ? `<strong>Assessment:</strong> ${triage.assessment}` : ''}
                   </div>
                   <div class="col-md-4 text-right">
                       <span class="label ${priorityClass === 'text-danger' ? 'label-danger' : 
                                          priorityClass === 'text-warning' ? 'label-warning' : 'label-success'}">
                           ${triage.priority || 'Normal'} Priority
                       </span><br>
                       ${triage.staff_name ? `<small>By: ${triage.staff_name}</small>` : ''}
                   </div>
               </div>
           </div>
       `;
   });
   
   $('#reviewTriageList').html(html);
}

function loadPatientVerificationHistory(patientId) {
   $('#reviewVerificationsList').html('<div class="text-center"><div class="spinner-modern"></div> Loading verification history...</div>');
   
   $.ajax({
       url: window.consultationConfig.baseURL + window.consultationConfig.endpoints.getPatientVerifications,
       type: 'POST',
       data: { patient_id: patientId },
       dataType: 'json',
       timeout: 10000,
       success: function(response) {
           console.log('Verifications response:', response);
           
           if (response && response.status === 'success') {
               if (response.verifications && response.verifications.length > 0) {
                   displayVerificationHistory(response.verifications);
                   window.consultationState.patientReview.verifications = response.verifications;
               } else {
                   $('#reviewVerificationsList').html(`
                       <div class="review-item">
                           <div class="text-muted">
                               <i class="fa fa-info-circle"></i> ${response.message || 'No verification history found for this patient'}
                           </div>
                       </div>
                   `);
               }
           } else {
               $('#reviewVerificationsList').html(`
                   <div class="review-item">
                       <div class="text-muted">
                           <i class="fa fa-info-circle"></i> ${response.message || 'No verification history found'}
                       </div>
                   </div>
               `);
           }
       },
       error: function(xhr, status, error) {
           console.error('Error loading verifications:', error);
           
           let errorMessage = 'Unable to load verification history';
           if (xhr.status === 404) {
               errorMessage = 'Verification history endpoint not found';
           } else if (xhr.status === 403) {
               errorMessage = 'Access denied - insufficient privileges for verification history';
           } else if (xhr.status === 500) {
               errorMessage = 'Server error loading verification history';
           }
           
           // Show helpful message about creating the table
           $('#reviewVerificationsList').html(`
               <div class="review-item">
                   <div class="text-info">
                       <i class="fa fa-info-circle"></i> <strong>Verification History Setup Required</strong><br>
                       <small>The verification history feature requires the 'fingerprint_verification_log' database table.</small><br>
                       <small>Status: ${xhr.status} - ${error}</small><br><br>
                       <small><strong>Note:</strong> Verification records will appear here once biometric verifications are performed.</small>
                   </div>
               </div>
           `);
       }
   });
}

function displayVerificationHistory(verifications) {
   if (verifications.length === 0) {
       $('#reviewVerificationsList').html('<div class="review-item">No verification attempts found</div>');
       return;
   }
   
   let html = '';
   verifications.forEach(verification => {
       const verificationDate = new Date(verification.verification_date).toLocaleDateString();
       const verificationTime = new Date(verification.verification_date).toLocaleTimeString();
       
       // Use the actual field names from fingerprint_verification_log table
       const resultClass = verification.verification_status === 'success' ? 'text-success' : 
                         verification.verification_status === 'failed' ? 'text-danger' : 'text-warning';
       const resultIcon = verification.verification_status === 'success' ? 'fa-check' : 
                         verification.verification_status === 'failed' ? 'fa-times' : 'fa-exclamation';
       
       // Calculate match percentage if available
       const matchScore = verification.match_score || 0;
       const matchPercentage = verification.match_percentage || Math.round((matchScore / 199) * 100);
       
       // Use the formatted staff name from database
       const staffName = verification.staff_name_full || 
                        verification.staff_name || 
                        'Unknown Staff';
       
       html += `
           <div class="review-item">
               <div class="row">
                   <div class="col-md-8">
                       <strong>Date/Time:</strong> ${verificationDate} ${verificationTime}<br>
                       <strong>Method:</strong> ${verification.verification_type || 'Biometric'} Matching<br>
                       <strong>Match Score:</strong> ${matchScore}/199 (${matchPercentage}%)<br>
                       <strong>Threshold:</strong> ${verification.threshold_used || 75}<br>
                       ${verification.has_stored_template == 1 ? 
                         '<strong>Template:</strong> Available<br>' : 
                         '<strong>Template:</strong> <span class="text-warning">Not Available</span><br>'}
                       ${verification.notes ? `<strong>Notes:</strong> ${verification.notes}<br>` : ''}
                   </div>
                   <div class="col-md-4 text-right">
                       <span class="label ${resultClass === 'text-success' ? 'label-success' : 
                                          resultClass === 'text-danger' ? 'label-danger' : 'label-warning'}">
                           ${(verification.verification_status || 'Unknown').toUpperCase()}
                       </span><br>
                       ${staffName ? `<small>By: ${staffName}</small><br>` : ''}
                       ${verification.ip_address ? `<small>IP: ${verification.ip_address}</small>` : ''}
                   </div>
               </div>
           </div>
       `;
   });
   
   $('#reviewVerificationsList').html(html);
}

function loadPatientSummaryStatistics(patientId) {
   // Calculate summary from loaded data
   setTimeout(() => {
       const consultations = window.consultationState.patientReview.consultations || [];
       const labTests = window.consultationState.patientReview.labTests || [];
       const triageHistory = window.consultationState.patientReview.triageHistory || [];
       const verifications = window.consultationState.patientReview.verifications || [];
       
       $('#totalConsultations').text(consultations.length);
       $('#totalLabTests').text(labTests.length);
       $('#totalTriageVisits').text(triageHistory.length);
       $('#totalVerifications').text(verifications.length);
       
       // Calculate additional info
       if (consultations.length > 0) {
           const firstVisit = new Date(Math.min(...consultations.map(c => new Date(c.consultation_date))));
           const lastVisit = new Date(Math.max(...consultations.map(c => new Date(c.consultation_date))));
           
           $('#firstVisitDate').text(firstVisit.toLocaleDateString());
           $('#lastVisitDate').text(lastVisit.toLocaleDateString());
           
           // Get most common diagnoses
           const diagnoses = consultations.map(c => c.diagnosis).filter(d => d);
           const diagnosisCount = {};
           diagnoses.forEach(d => diagnosisCount[d] = (diagnosisCount[d] || 0) + 1);
           const commonDiagnoses = Object.keys(diagnosisCount)
               .sort((a, b) => diagnosisCount[b] - diagnosisCount[a])
               .slice(0, 3)
               .join(', ');
           
           $('#commonDiagnoses').text(commonDiagnoses || 'None recorded');
       } else {
           $('#firstVisitDate').text('N/A');
           $('#lastVisitDate').text('N/A');
           $('#commonDiagnoses').text('N/A');
       }
       
       $('#patientWorkflowType').text(window.consultationState.patientWorkflowType);
   }, 1000);
}

// Function to log verification attempts to database
function logVerificationAttempt(verificationData) {
   if (!window.consultationState.selectedPatientId) {
       console.log('No patient selected - skipping verification log');
       return;
   }
   
   const logData = {
       patient_id: window.consultationState.selectedPatientId,
       verification_type: '1:1', // 1:1 matching
       match_score: verificationData.match_score || 0,
       is_match: verificationData.is_match ? 1 : 0,
       threshold_used: verificationData.threshold_used || 75,
       service_url: 'https://localhost:8443',
       staff_id: 1, // Default staff ID - should be replaced with actual staff ID
       ip_address: 'localhost',
       user_agent: navigator.userAgent,
       has_stored_template: window.consultationState.storedTemplate ? 1 : 0,
       verification_status: verificationData.verification_status || 'failed',
       notes: verificationData.notes || 'Consultation module verification'
   };
   
   // Send to server to log in database
   $.ajax({
       url: window.consultationConfig.baseURL + 'admin/consultation/logVerificationAttempt',
       type: 'POST',
       data: logData,
       dataType: 'json',
       success: function(response) {
           if (response.status === 'success') {
               console.log('Verification attempt logged successfully');
           }
       },
       error: function(xhr, status, error) {
           console.log('Failed to log verification attempt:', error);
           // Don't show error to user as this is background logging
       }
   });
}

function printPatientSummary() {
   const patientName = $('#reviewPatientName').text();
   const patientId = $('#reviewPatientId').text();
   
   const printContent = `
       <!DOCTYPE html>
       <html>
       <head>
           <title>Patient Summary - ${patientName}</title>
           <style>
               body { font-family: Arial, sans-serif; margin: 20px; }
               .header { text-align: center; border-bottom: 2px solid #000; padding-bottom: 10px; }
               .section { margin: 20px 0; }
               .section h3 { background: #f0f0f0; padding: 8px; margin: 0; }
               .item { margin: 10px 0; padding: 8px; border: 1px solid #ddd; }
               @media print {
                   body { margin: 0; }
                   .no-print { display: none; }
               }
           </style>
       </head>
       <body>
           <div class="header">
               <h2>Patient Medical Summary</h2>
               <p><strong>Patient:</strong> ${patientName} | <strong>ID:</strong> ${patientId}</p>
               <p><strong>Generated:</strong> ${new Date().toLocaleString()}</p>
           </div>
           
           <div class="section">
               <h3>Summary Statistics</h3>
               <p><strong>Total Consultations:</strong> ${$('#totalConsultations').text()}</p>
               <p><strong>Lab Tests Done:</strong> ${$('#totalLabTests').text()}</p>
               <p><strong>Triage Visits:</strong> ${$('#totalTriageVisits').text()}</p>
               <p><strong>Verifications:</strong> ${$('#totalVerifications').text()}</p>
               <p><strong>Workflow Type:</strong> ${$('#patientWorkflowType').text()}</p>
           </div>
           
           <div class="section">
               <h3>Recent Consultations</h3>
               ${$('#reviewConsultationsList').html()}
           </div>
           
           <div class="section">
               <h3>Recent Lab Tests</h3>
               ${$('#reviewLabTestsList').html()}
           </div>
           
           <div class="footer" style="margin-top: 40px; text-align: center; font-size: 12px; color: #666;">
               <p>Enhanced Medical System - Patient Summary Report</p>
           </div>
       </body>
       </html>
   `;
   
   const printWindow = window.open('', '_blank');
   printWindow.document.write(printContent);
   printWindow.document.close();
   
   printWindow.onload = function() {
       setTimeout(() => {
           printWindow.print();
           printWindow.close();
       }, 500);
   };
}

function startNewConsultationFromReview() {
   $('#patientReviewModal').modal('hide');
   setTimeout(() => {
       startEnhancedConsultation();
   }, 300);
}

// =============================================
// ENHANCED CONSULTATION MANAGEMENT
// =============================================

function startEnhancedConsultation() {
  const patientId = $('#selectedPatientId').val();
  if (!patientId) {
      showModernMessage('Please select a patient first', 'warning');
      return;
  }
  
  // Check verification requirement properly
  if (window.consultationState.requiresVerification && !window.consultationState.verificationPassed) {
      const workflowType = window.consultationState.patientWorkflowType || 'GCC';
      showModernMessage(`${workflowType} patients must be verified before consultation`, 'warning');
      
      const verificationSection = $('#biometricVerificationSection');
      verificationSection.addClass('pulse-highlight');
      setTimeout(() => {
          verificationSection.removeClass('pulse-highlight');
      }, 2000);
      
      return;
  }
  
  // Enhanced modal preparation
  setupConsultationModal();
}

function setupConsultationModal() {
  const patientId = $('#selectedPatientId').val();
  
  // Populate modal fields
  $('#modalPatientIdHidden').val(patientId);
  $('#modalPatientId').text(patientId);
  $('#modalPatientName').text($('#patientName').text());
  $('#consultationDate').val(new Date().toISOString().split('T')[0]);
  $('#modalVerificationStatus').val(window.consultationState.verificationPassed ? '1' : '0');
  $('#modalWorkflowType').val(window.consultationState.patientWorkflowType || 'General');
  $('#modalIsGCCPatient').val(window.consultationState.isGCCPatient ? '1' : '0');
  
  // Enhanced verification badge
  let verificationBadge;
  if (window.consultationState.requiresVerification && window.consultationState.verificationPassed) {
      verificationBadge = '<span class="status-indicator status-verified"><i class="fa fa-shield"></i> GCC Biometric Verified</span>';
  } else if (!window.consultationState.requiresVerification) {
      verificationBadge = '<span class="status-indicator status-general"><i class="fa fa-check-circle"></i> General Patient - No Verification Required</span>';
  } else {
      verificationBadge = '<span class="status-indicator status-pending"><i class="fa fa-exclamation-triangle"></i> Unverified GCC Patient</span>';
  }
  
  $('#modalVerificationBadge').html(verificationBadge);
  
  if (window.consultationState.verificationPassed && window.consultationState.requiresVerification) {
      $('#modalVerificationDetails').html(`
          <small>SGIMatchScore: ${window.consultationState.currentMatchScore}/199</small><br>
          <small>Quality: ${window.consultationState.verificationQuality}</small>
      `);
  } else if (!window.consultationState.requiresVerification) {
      $('#modalVerificationDetails').html(`
          <small>Workflow: ${window.consultationState.patientWorkflowType}</small><br>
          <small>Verification exempted by workflow policy</small>
      `);
  }
  
  // NEW: Hide diagnosis section for GCC patients
  if (window.consultationState.isGCCPatient) {
      console.log('🔒 Hiding ICD diagnosis section for GCC patient');
      $('#diagnosisSection').hide();
      $('#customDiagnosisGroup').hide();
  } else {
      console.log('🔓 Showing ICD diagnosis section for General patient');
      $('#diagnosisSection').show();
  }
  
  // Load doctors, lab tests (optional), and ICD diagnoses
  loadDoctors();
  loadLabTestsData(); // Now optional
  if (!window.consultationState.isGCCPatient) {
      loadIcdDiagnoses(); // Only for non-GCC patients
  }
  
  updateStepIndicator('consult');
  $('#consultationModal').modal('show');
}

// =============================================
// DOCTORS MANAGEMENT
// =============================================

function loadDoctors() {
   console.log('👩‍⚕️ Loading doctors from database...');
   
   $('#consultationDoctor').html('<option value="">Loading doctors...</option>');
   
   const endpoint = window.consultationConfig.baseURL + window.consultationConfig.endpoints.getAllDoctors;
   
   $.ajax({
       url: endpoint,
       type: 'GET',
       dataType: 'json',
       timeout: 10000,
       success: function(response) {
           console.log('📥 Doctors response received:', response);
           handleDoctorsLoadSuccess(response);
       },
       error: function(xhr, status, error) {
           console.error('❌ Error loading doctors:', status, error);
           handleDoctorsLoadError(xhr, status, error);
       }
   });
}

function handleDoctorsLoadSuccess(response) {
   console.log('✅ Processing doctors response...');
   
   try {
       let doctors = [];
       
       if (response && response.status === 'success' && Array.isArray(response.doctors)) {
           doctors = response.doctors;
       } else if (response && Array.isArray(response)) {
           doctors = response;
       } else {
           console.error('Invalid doctors response format:', response);
           handleDoctorsLoadError(null, 'Invalid response format');
           return;
       }
       
       populateDoctorsDropdown(doctors);
       console.log(`✅ Successfully loaded ${doctors.length} doctors`);
       
   } catch (error) {
       console.error('❌ Error processing doctors response:', error);
       handleDoctorsLoadError(null, 'Processing error: ' + error.message);
   }
}

function populateDoctorsDropdown(doctors) {
   console.log('👩‍⚕️ Populating doctors dropdown with', doctors.length, 'doctors');
   
   const select = $('#consultationDoctor');
   select.empty();
   select.append(`<option value="">Select Doctor (${doctors.length} available)</option>`);
   
   if (doctors.length === 0) {
       select.append('<option value="" disabled>No doctors found</option>');
       showModernMessage('No doctors found in system', 'warning');
       return;
   }
   
   $.each(doctors, function(index, doctor) {
       try {
           let displayText = doctor.display_name || `Dr. ${doctor.full_name}`;
           
           const option = $('<option>', {
               value: doctor.id,
               text: displayText,
               'data-name': doctor.full_name,
               'data-employee-id': doctor.employee_id,
               'data-specialist': doctor.specialist,
               'data-specialization': doctor.specialization,
               'data-designation': doctor.designation
           });
           
           select.append(option);
           
       } catch (error) {
           console.error('❌ Error processing doctor', doctor.id, ':', error);
       }
   });
   
   console.log(`✅ Successfully populated ${doctors.length} doctors`);
   
   // Initialize Select2 for better search
   if (typeof $.fn.select2 !== 'undefined') {
       select.select2({
           placeholder: 'Search and select doctor...',
           allowClear: true,
           width: '100%',
           dropdownParent: $('#consultationModal')
       });
   }
}

function handleDoctorsLoadError(xhr, status, error) {
   console.error('❌ Handling doctors load error...');
   
   $('#consultationDoctor').html('<option value="">Error loading doctors</option>');
   
   let errorMessage = 'Failed to load doctors';
   
   if (xhr && xhr.status === 404) {
       errorMessage = 'Doctors endpoint not found (404)';
   } else if (xhr && xhr.status === 500) {
       errorMessage = 'Server error loading doctors (500)';
   } else if (status === 'timeout') {
       errorMessage = 'Request timeout loading doctors';
   }
   
   showModernMessage(errorMessage, 'warning');
   
   // Add fallback option
   $('#consultationDoctor').append('<option value="manual">Enter doctor manually</option>');
}

// =============================================
// LAB TESTS MANAGEMENT (NOW OPTIONAL)
// =============================================

function loadLabTestsData() {
  console.log('🧪 Loading lab tests data (optional)...');
  
  // Mark as optional in the UI
  $('.lab-tests-panel').addClass('lab-tests-optional');
  
  // Simulate loading lab tests by category (replace with real AJAX)
  const mockLabTests = {
      '1': [ // Hematology
          {id: 1, test_name: 'Complete Blood Count (CBC)', short_name: 'CBC', cost: 500, sample_type: 'Blood', method: 'Automated'},
          {id: 2, test_name: 'Hemoglobin', short_name: 'Hb', cost: 200, sample_type: 'Blood', method: 'Automated'},
          {id: 3, test_name: 'Hematocrit', short_name: 'HCT', cost: 150, sample_type: 'Blood', method: 'Automated'},
          {id: 4, test_name: 'ESR', short_name: 'ESR', cost: 300, sample_type: 'Blood', method: 'Westergren'}
      ],
      '2': [ // Clinical Chemistry
          {id: 5, test_name: 'Random Blood Sugar', short_name: 'RBS', cost: 200, sample_type: 'Blood', method: 'Glucose Oxidase'},
          {id: 6, test_name: 'Fasting Blood Sugar', short_name: 'FBS', cost: 250, sample_type: 'Blood', method: 'Glucose Oxidase'},
          {id: 7, test_name: 'Liver Function Tests', short_name: 'LFTs', cost: 800, sample_type: 'Blood', method: 'Automated'},
          {id: 8, test_name: 'Kidney Function Tests', short_name: 'KFTs', cost: 600, sample_type: 'Blood', method: 'Automated'}
      ],
      '3': [ // Microbiology
          {id: 9, test_name: 'Blood Culture', short_name: 'BC', cost: 1000, sample_type: 'Blood', method: 'Culture'},
          {id: 10, test_name: 'Urine Culture', short_name: 'UC', cost: 800, sample_type: 'Urine', method: 'Culture'},
          {id: 11, test_name: 'Stool Culture', short_name: 'SC', cost: 900, sample_type: 'Stool', method: 'Culture'}
      ],
      '6': [ // Serology
          {id: 12, test_name: 'HIV Test', short_name: 'HIV', cost: 500, sample_type: 'Blood', method: 'ELISA'},
          {id: 13, test_name: 'Hepatitis B Surface Antigen', short_name: 'HBsAg', cost: 600, sample_type: 'Blood', method: 'ELISA'},
          {id: 14, test_name: 'VDRL Test', short_name: 'VDRL', cost: 400, sample_type: 'Blood', method: 'RPR'}
      ],
      'other': [ // Other Tests
          {id: 15, test_name: 'Urinalysis', short_name: 'U/A', cost: 300, sample_type: 'Urine', method: 'Microscopy'},
          {id: 16, test_name: 'Pregnancy Test', short_name: 'βHCG', cost: 400, sample_type: 'Urine', method: 'Immunoassay'},
          {id: 17, test_name: 'Thyroid Function Tests', short_name: 'TFTs', cost: 1200, sample_type: 'Blood', method: 'ELISA'}
      ]
  };
  
  window.consultationState.labTests.available = mockLabTests;
  window.consultationState.labTests.isRequired = false; // Mark as optional
  
  populateTestCategories();
  showModernMessage('Lab tests loaded (optional selection)', 'success');
}

function populateTestCategories() {
  const categories = {
      1: { id: 'hematology', name: 'Hematology', container: '#hematologyTestsList' },
      2: { id: 'chemistry', name: 'Clinical Chemistry', container: '#chemistryTestsList' },
      3: { id: 'microbiology', name: 'Microbiology', container: '#microbiologyTestsList' },
      6: { id: 'serology', name: 'Serology', container: '#serologyTestsList' },
      'other': { id: 'other', name: 'Other Tests', container: '#otherTestsList' }
  };
  
  Object.keys(categories).forEach(categoryId => {
      const category = categories[categoryId];
      const tests = window.consultationState.labTests.available[categoryId] || [];
      const container = $(category.container);
      
      if (tests.length > 0) {
          populateTestCheckboxes(container, tests, categoryId);
      } else {
          container.html(`
              <div class="col-md-12 text-center text-muted">
                  <i class="fa fa-info-circle"></i> No ${category.name.toLowerCase()} tests available
              </div>
          `);
      }
  });
}

function populateTestCheckboxes(container, tests, categoryId) {
  container.empty();
  
  tests.forEach(test => {
      const costDisplay = test.cost > 0 ? `(Ksh.${parseFloat(test.cost).toFixed(2)})` : '';
      const checkboxHtml = `
          <div class="col-md-6 col-sm-12">
              <div class="test-checkbox">
                  <label style="font-weight: normal; width: 100%; cursor: pointer; color: black;">
                      <input type="checkbox" 
                             value="${test.id}" 
                             data-test-name="${test.test_name}"
                             data-short-name="${test.short_name || ''}"
                             data-cost="${test.cost || 0}"
                             data-category="${categoryId}"
                             data-sample-type="${test.sample_type || ''}"
                             data-method="${test.method || ''}"
                             class="lab-test-checkbox">
                      <strong>${test.test_name}</strong>
                      ${test.short_name ? `<small>(${test.short_name})</small>` : ''}
                      <br>
                      <small>
                          ${test.sample_type ? `Sample: ${test.sample_type}` : ''}
                          ${test.method ? ` | Method: ${test.method}` : ''}
                          ${costDisplay ? ` | ${costDisplay}` : ''}
                      </small>
                  </label>
              </div>
          </div>
      `;
      container.append(checkboxHtml);
  });
}

function updateSelectedTestsSummary() {
  const selectedTests = $('.lab-test-checkbox:checked');
  const selectedCount = selectedTests.length;
  let totalCost = 0;
  let testsList = [];
  
  selectedTests.each(function() {
      const $this = $(this);
      const cost = parseFloat($this.data('cost')) || 0;
      totalCost += cost;
      testsList.push($this.data('test-name'));
  });
  
  $('#selectedTestsCount').text(selectedCount);
  $('#estimatedTestsCost').text(totalCost.toFixed(2));
  
  if (selectedCount > 0) {
      $('#selectedTestsList').html(testsList.map(test => `<span class="label label-info" style="margin: 2px; color: white;">${test}</span>`).join(' '));
  } else {
      $('#selectedTestsList').html('<em style="color: rgba(255,255,255,0.7);">No tests selected (optional)</em>');
  }
  
  // Update global state
  window.consultationState.labTests.selected = [];
  selectedTests.each(function() {
      const $this = $(this);
      window.consultationState.labTests.selected.push({
          id: $this.val(),
          test_name: $this.data('test-name'),
          short_name: $this.data('short-name'),
          cost: $this.data('cost'),
          category: $this.data('category'),
          sample_type: $this.data('sample-type'),
          method: $this.data('method')
      });
  });
  
  window.consultationState.labTests.estimatedCost = totalCost;
  $('#selectedTestsInput').val(JSON.stringify(window.consultationState.labTests.selected));
}

// =============================================
// ICD-10 DIAGNOSIS MANAGEMENT (HIDDEN FOR GCC)
// =============================================

function loadIcdDiagnoses() {
  console.log('📋 Loading ICD-10 diagnoses (non-GCC patients only)...');
  
  $('#consultationDiagnosis').html('<option value="">Loading ICD-10 codes...</option>');
  
  // Simulate loading ICD diagnoses (replace with real AJAX)
  const mockDiagnoses = [
      {id: 1, code: 'A00.0', title: 'Cholera due to Vibrio cholerae 01, biovar cholerae', category: 'Infectious diseases'},
      {id: 2, code: 'B15.9', title: 'Hepatitis A without hepatic coma', category: 'Infectious diseases'},
      {id: 3, code: 'E11.9', title: 'Type 2 diabetes mellitus without complications', category: 'Endocrine diseases'},
      {id: 4, code: 'I10', title: 'Essential (primary) hypertension', category: 'Circulatory diseases'},
      {id: 5, code: 'J44.1', title: 'Chronic obstructive pulmonary disease with acute exacerbation', category: 'Respiratory diseases'},
      {id: 6, code: 'K59.0', title: 'Constipation', category: 'Digestive diseases'},
      {id: 7, code: 'M79.2', title: 'Neuralgia and neuritis, unspecified', category: 'Musculoskeletal diseases'},
      {id: 8, code: 'R50.9', title: 'Fever, unspecified', category: 'Symptoms and signs'},
      {id: 9, code: 'Z00.0', title: 'General adult medical examination', category: 'Health services'}
  ];
  
  setTimeout(() => {
      populateIcdSelect(mockDiagnoses);
      initializeDiagnosisSelect2();
      showModernMessage('ICD-10 diagnoses loaded (non-GCC patients)', 'success');
  }, 1000);
}

function populateIcdSelect(diagnoses) {
  const select = $('#consultationDiagnosis');
  select.empty();
  select.append('<option value="">Search and select ICD-10 diagnosis...</option>');
  
  diagnoses.forEach(diagnosis => {
      const optionText = `${diagnosis.code} - ${diagnosis.title}`;
      const option = $(`<option value="${diagnosis.id}" 
          data-code="${diagnosis.code}" 
          data-title="${diagnosis.title}" 
          data-category="${diagnosis.category || ''}">${optionText}</option>`);
      select.append(option);
  });
  
  console.log(`Populated ${diagnoses.length} ICD-10 diagnoses in dropdown`);
}
function initializeDiagnosisSelect2() {
  if ($('#consultationDiagnosis').hasClass('select2-hidden-accessible')) {
      $('#consultationDiagnosis').select2('destroy');
  }
  
  $('#consultationDiagnosis').select2({
      placeholder: 'Search ICD-10 codes by code, title, or category...',
      allowClear: true,
      width: '100%',
      dropdownParent: $('#consultationModal'),
      minimumInputLength: 0
  });
  
  console.log('Select2 initialized for diagnosis dropdown');
}

function selectDiagnosis(diagnosisId) {
  const selectedOption = $(`#consultationDiagnosis option[value="${diagnosisId}"]`);
  
  if (selectedOption.length) {
      const diagnosisData = {
          id: diagnosisId,
          code: selectedOption.data('code'),
          title: selectedOption.data('title'),
          category: selectedOption.data('category')
      };
      
      window.consultationState.selectedDiagnosis = diagnosisData;
      
      $('#selectedDiagnosisCode').text(diagnosisData.code);
      $('#selectedDiagnosisTitle').text(diagnosisData.title);
      $('#selectedDiagnosisCategory').text(diagnosisData.category);
      $('#selectedDiagnosisInfo').show();
      
      $('#customDiagnosisGroup').hide();
      $('#consultationDiagnosisCustom').val('');
      
      console.log('Selected diagnosis:', diagnosisData);
  }
}

function clearDiagnosis() {
  $('#consultationDiagnosis').val('').trigger('change');
  $('#selectedDiagnosisInfo').hide();
  $('#customDiagnosisGroup').hide();
  $('#consultationDiagnosisCustom').val('');
  window.consultationState.selectedDiagnosis = null;
  
  console.log('Diagnosis selection cleared');
}

function showCustomDiagnosis() {
  $('#customDiagnosisGroup').show();
  $('#consultationDiagnosisCustom').focus();
  $('#selectedDiagnosisInfo').hide();
  $('#consultationDiagnosis').val('').trigger('change');
  window.consultationState.selectedDiagnosis = null;
  
  showModernMessage('Custom diagnosis mode enabled', 'info');
}

// =============================================
// ENHANCED CONSULTATION SAVING (NO LAB TEST ENFORCEMENT)
// =============================================

function saveEnhancedConsultation() {
   const submitBtn = $('#consultationForm').find('button[type="submit"]');
   submitBtn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Saving Enhanced Consultation...');
   
   const patientId = $('#modalPatientIdHidden').val();
   
   // Check verification requirement properly
   if (window.consultationState.requiresVerification && !window.consultationState.verificationPassed) {
       showModernMessage('GCC patients must be verified before consultation can be saved', 'error');
       submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Save Consultation');
       return;
   }
   
   // Enhanced form validation (NO lab test requirement)
   if (!$('#consultationSymptoms').val().trim()) {
       showModernMessage('Please enter patient symptoms/chief complaint', 'warning');
       $('#consultationSymptoms').focus();
       submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Save Consultation');
       return;
   }
   
   if (!$('#consultationDoctor').val()) {
       showModernMessage('Please select a doctor', 'warning');
       $('#consultationDoctor').focus();
       submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Save Consultation');
       return;
   }
   
   console.log('🔬 Lab tests are OPTIONAL - proceeding without enforcement');
   
   // Prepare form data
   let formData = $('#consultationForm').serialize();
   
   // Add diagnosis information (only for non-GCC patients)
   if (!window.consultationState.isGCCPatient) {
       if (window.consultationState.selectedDiagnosis) {
           formData += `&diagnosis_code=${window.consultationState.selectedDiagnosis.code}`;
           formData += `&diagnosis_title=${encodeURIComponent(window.consultationState.selectedDiagnosis.title)}`;
           formData += `&diagnosis_type=icd10`;
       } else if ($('#consultationDiagnosisCustom').val().trim()) {
           formData += `&diagnosis_custom=${encodeURIComponent($('#consultationDiagnosisCustom').val())}`;
           formData += `&diagnosis_type=custom`;
       }
   } else {
       console.log('🔒 GCC Patient - Skipping ICD diagnosis (hidden for GCC workflow)');
       formData += `&diagnosis_type=gcc_workflow`;
       formData += `&diagnosis_custom=GCC Patient - No ICD diagnosis required`;
   }
   
   // Add lab tests data (OPTIONAL - can be empty)
   const selectedTests = window.consultationState.labTests.selected || [];
   formData += `&selected_tests=${encodeURIComponent(JSON.stringify(selectedTests))}`;
   formData += `&total_tests=${selectedTests.length}`;
   formData += `&estimated_tests_cost=${window.consultationState.labTests.estimatedCost || 0}`;
   formData += `&lab_tests_optional=1`; // Flag indicating tests are optional
   
   // Add verification details
   formData += `&verification_score=${window.consultationState.currentMatchScore}`;
   formData += `&verification_quality=${window.consultationState.verificationQuality}`;
   formData += `&verification_method=${window.consultationState.verificationPassed ? 'fingerprint' : 'workflow_exempted'}`;
   
   console.log('📤 Sending consultation data (lab tests optional):', formData);
   
   // Real AJAX call to your controller
   $.ajax({
       url: window.consultationConfig.baseURL + window.consultationConfig.endpoints.saveConsultation,
       type: 'POST',
       data: formData,
       dataType: 'json',
       timeout: 30000,
       success: function(response) {
           console.log('💾 Save response:', response);
           
           if (response.status === 'success') {
               const workflowType = window.consultationState.patientWorkflowType || 'GENERAL';
               const testsMessage = selectedTests.length > 0 ? ` with ${selectedTests.length} lab tests` : ' (no lab tests)';
               showModernMessage(`✓ ENHANCED ${workflowType} patient consultation saved successfully${testsMessage}!`, 'success');
               
               $('#consultationModal').modal('hide');
               updateStepIndicator('save');
               
               // Reset form
               resetConsultationForm();
               
               // Update consultation count or reload lists if needed
               if (typeof loadPatientConsultations === 'function') {
                   loadPatientConsultations(patientId);
               }
               
           } else {
               showModernMessage(response.message || 'Failed to save consultation', 'error');
           }
       },
       error: function(xhr, status, error) {
           console.error('❌ Save consultation error:', xhr.responseText);
           
           let errorMessage = 'Failed to save consultation';
           if (xhr.responseText) {
               try {
                   const errorResponse = JSON.parse(xhr.responseText);
                   errorMessage = errorResponse.message || errorMessage;
               } catch (e) {
                   errorMessage += ': ' + error;
               }
           }
           
           showModernMessage(errorMessage, 'error');
       },
       complete: function() {
           submitBtn.prop('disabled', false).html('<i class="fa fa-save"></i> Save Consultation');
       }
   });
}

function resetConsultationForm() {
  $('#consultationForm')[0].reset();
  $('#selectedDiagnosisInfo').hide();
  $('#customDiagnosisGroup').hide();
  $('#consultationDiagnosis').val('').trigger('change');
  window.consultationState.selectedDiagnosis = null;
  
  // Reset lab tests selection
  $('.lab-test-checkbox').prop('checked', false);
  updateSelectedTestsSummary();
  window.consultationState.labTests.selected = [];
  window.consultationState.labTests.estimatedCost = 0;
}

// =============================================
// FINGERPRINT CAPTURE AND VERIFICATION
// =============================================

function captureFingerprint() {
   logDiagnostic('Starting SGIFPCapture for consultation', 'info');
   
   window.consultationState.liveTemplate = null;
   $('#liveScannedTemplate').val('');
   $('#liveFingerprintContainer').addClass('active');
   
   $('#fingerprintStatus').html(`
       <div class="status-info">
           <i class="fa fa-spinner fa-spin"></i> <strong>Place finger on scanner...</strong><br>
           <small>SGIFPCapture in progress - Consultation Module</small>
       </div>
   `);
   
   $('#manualVerifyBtn').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Scanning...');
   
   const captureUrl = 'https://localhost:8443/SGIFPCapture';
   
   const xhr = new XMLHttpRequest();
   xhr.open('POST', captureUrl, true);
   xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
   xhr.timeout = 25000;
   
   xhr.onreadystatechange = function() {
       if (xhr.readyState === 4) {
           $('#manualVerifyBtn').prop('disabled', false).html('<i class="fa fa-fingerprint"></i> Manual Print Capture');
           
           if (xhr.status === 200) {
               try {
                   const result = JSON.parse(xhr.responseText);
                   handleCaptureResponse(result);
               } catch (e) {
                   handleCaptureError('Invalid response from SGIFPCapture: ' + e.message);
               }
           } else {
               handleCaptureError(`SGIFPCapture failed: HTTP ${xhr.status}`);
           }
       }
   };
   
   xhr.onerror = function() {
       $('#manualVerifyBtn').prop('disabled', false).html('<i class="fa fa-fingerprint"></i> Manual Print Capture');
       handleCaptureError('Network error during SGIFPCapture');
   };
   
   xhr.ontimeout = function() {
       $('#manualVerifyBtn').prop('disabled', false).html('<i class="fa fa-fingerprint"></i> Manual Print Capture');
       handleCaptureError('SGIFPCapture timeout - no finger detected');
   };
   
   const postData = 'Quality=50&Timeout=20000&WSQCompression=2.25';
   xhr.send(postData);
   
   logDiagnostic('Fingerprint capture initiated', 'info');
}

function handleCaptureResponse(result) {
   if (result.ErrorCode === 0) {
       if (result.BMPBase64) {
           $('#liveFingerprintImage').attr('src', 'data:image/bmp;base64,' + result.BMPBase64);
       }
       
       if (result.TemplateBase64) {
           window.consultationState.liveTemplate = result.TemplateBase64;
           $('#liveScannedTemplate').val(result.TemplateBase64);
       }
       
       const quality = result.Quality || 50;
       let deviceInfo = '';
       if (result.SerialNumber) {
           deviceInfo = ` (${result.Manufacturer || 'SecuGen'} ${result.Model || 'Device'} - SN: ${result.SerialNumber})`;
       }
       
       $('#liveTemplateDetails').html(`<span class="text-success">Template captured (Quality: ${quality}%)</span>`);
       
       $('#fingerprintStatus').html(`
           <div class="status-success">
               <i class="fa fa-check-circle"></i> <strong>Fingerprint Captured Successfully!</strong><br>
               <small>Quality: <strong>${quality}%</strong> | Template: ${result.TemplateBase64 ? result.TemplateBase64.length : 0} chars${deviceInfo}</small><br>
               <small class="text-success">Ready for biometric verification</small>
           </div>
       `);
       
       $('#verifyIdentity').prop('disabled', false);
       showModernMessage(`Fingerprint captured! Quality: ${quality}%`, 'success');
       
       logDiagnostic(`Fingerprint capture successful - Quality: ${quality}%`, 'success');
   } else {
       const errorMsg = getSecuGenErrorMessage(result.ErrorCode);
       logDiagnostic(`SecuGen capture error ${result.ErrorCode}: ${errorMsg}`, 'error');
       handleCaptureError(`Capture failed: ${errorMsg}`);
   }
}

function handleCaptureError(message) {
   $('#fingerprintStatus').html(`
       <div class="status-error">
           <i class="fa fa-times-circle"></i> <strong>Fingerprint Capture Failed</strong><br>
           <small>${message}</small><br>
           <div style="margin-top: 10px;">
               <button type="button" class="btn btn-modern btn-sm" onclick="captureFingerprint()">
                   <i class="fa fa-refresh"></i> Try Again
               </button>
               <button type="button" class="btn btn-warning-modern btn-sm" onclick="skipEnhancedVerification()">
                   <i class="fa fa-user-shield"></i> Override
               </button>
           </div>
       </div>
   `);
   
   logDiagnostic(`Capture error: ${message}`, 'error');
}

function performBiometricVerification() {
   logDiagnostic('Starting SGIMatchScore verification', 'info');
   
   if (!window.consultationState.liveTemplate) {
       showModernMessage('Please capture fingerprint first', 'warning');
       return;
   }
   
   if (!window.consultationState.storedTemplate) {
       showModernMessage('No stored template available for comparison', 'warning');
       return;
   }
   
   const matchUrl = 'https://localhost:8443/SGIMatchScore';
   
   $('#fingerprintStatus').html(`
       <div class="status-info">
           <div class="text-center">
               <div class="spinner-modern"></div> <strong>Verifying biometric match...</strong><br>
               <small>Processing fingerprint comparison with SGIMatchScore</small>
           </div>
       </div>
   `);
   
   $('#verifyIdentity').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Verifying...');

   const xhr = new XMLHttpRequest();
   xhr.open('POST', matchUrl, true);
   xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
   xhr.timeout = 10000;
   
   xhr.onreadystatechange = function() {
       if (xhr.readyState === 4) {
           $('#verifyIdentity').prop('disabled', false).html('<i class="fa fa-shield"></i> Verify Print');
           
           if (xhr.status === 200) {
               try {
                   const result = JSON.parse(xhr.responseText);
                   handleVerificationResponse(result);
               } catch (e) {
                   handleVerificationError('Invalid response from SGIMatchScore: ' + e.message);
               }
           } else {
               handleVerificationError(`SGIMatchScore failed: HTTP ${xhr.status}`);
           }
       }
   };

   xhr.onerror = function() {
       $('#verifyIdentity').prop('disabled', false).html('<i class="fa fa-shield"></i> Verify Print');
       handleVerificationError('Network error during SGIMatchScore');
   };

   xhr.ontimeout = function() {
       $('#verifyIdentity').prop('disabled', false).html('<i class="fa fa-shield"></i> Verify Print');
       handleVerificationError('SGIMatchScore timeout');
   };

   const postData = `template1=${encodeURIComponent(window.consultationState.storedTemplate)}&template2=${encodeURIComponent(window.consultationState.liveTemplate)}`;
   xhr.send(postData);
}

function handleVerificationResponse(result) {
   if (result.ErrorCode === 0) {
       const matchScore = parseInt(result.MatchingScore || 0);
       const threshold = 75; // SecuGen threshold
       const isMatch = matchScore >= threshold;
       
       window.consultationState.currentMatchScore = matchScore;
       window.consultationState.verificationPassed = isMatch;
       
       let quality = matchScore >= 120 ? 'Very Good' : matchScore >= threshold ? 'Good' : 'Poor';
       window.consultationState.verificationQuality = quality;
       
       if (isMatch) {
           window.consultationState.verificationStatus = 'success';
           window.consultationState.verificationMethod = 'real_secugen_biometric';
           
           $('#fingerprintStatus').html(`
               <div class="status-success">
                   <h6><i class="fa fa-check-circle"></i> Biometric Verification Successful!</h6>
                   <p><strong>SGIMatchScore: ${matchScore}/199 (${quality})</strong></p>
                   <p>Patient identity confirmed through real SecuGen biometric verification.</p>
                   <small class="text-success">Real verification completed - ready for consultation</small>
               </div>
           `);
           
           $('#verificationStatus').html('<span class="status-indicator status-verified"><i class="fa fa-shield"></i> SecuGen Verified</span>');
           $('#startConsultationBtn').prop('disabled', false);
           $('#reviewPatientBtn').prop('disabled', false);
           
           enhancePatientCard(window.consultationState.selectedPatientData);
           updateStepIndicator('consult');
           
           addToVerificationHistory('Success', matchScore, quality);
           showModernMessage(`Identity verified! SGIMatchScore: ${matchScore}/199 (${quality})`, 'success');
           
       } else {
           $('#fingerprintStatus').html(`
               <div class="status-error">
                   <h6><i class="fa fa-times-circle"></i> Verification Failed</h6>
                   <p><strong>SGIMatchScore: ${matchScore}/199 (${quality})</strong></p>
                   <p>Fingerprint does not match stored template.</p>
                   <div style="margin-top: 15px;">
                       <button type="button" class="btn btn-modern btn-sm" onclick="captureFingerprint()">
                           <i class="fa fa-refresh"></i> Try Again
                       </button>
                       <button type="button" class="btn btn-warning-modern btn-sm" onclick="skipEnhancedVerification()">
                           <i class="fa fa-user-shield"></i> Override
                       </button>
                   </div>
               </div>
           `);
           
           addToVerificationHistory('Failed', matchScore, quality);
           showModernMessage(`Verification failed. SGIMatchScore ${matchScore}/199 below threshold.`, 'warning');
       }
   } else {
       const errorMsg = getSecuGenErrorMessage(result.ErrorCode);
       logDiagnostic(`SecuGen matching error ${result.ErrorCode}: ${errorMsg}`, 'error');
       handleVerificationError(`Matching failed: ${errorMsg}`);
   }
}

function handleVerificationError(message) {
   $('#fingerprintStatus').html(`
       <div class="status-error">
           <i class="fa fa-times-circle"></i> <strong>Verification Error</strong><br>
           <small>${message}</small><br>
           <div style="margin-top: 10px;">
               <button type="button" class="btn btn-modern btn-sm" onclick="performBiometricVerification()">
                   <i class="fa fa-refresh"></i> Try Again
               </button>
               <button type="button" class="btn btn-warning-modern btn-sm" onclick="skipEnhancedVerification()">
                   <i class="fa fa-user-shield"></i> Override
               </button>
           </div>
       </div>
   `);
   
   logDiagnostic(`Verification error: ${message}`, 'error');
}

function getSecuGenErrorMessage(errorCode) {
   const errorMessages = {
       0: 'Success',
       1: 'Device not found',
       2: 'Invalid device',
       3: 'Device busy',
       4: 'Capture timeout',
       5: 'Poor image quality',
       6: 'Device error',
       7: 'Invalid parameter',
       8: 'Memory error',
       9: 'File error',
       10: 'Invalid template',
       11: 'Function not supported',
       12: 'License error',
       13: 'SDK not initialized'
   };
   return errorMessages[errorCode] || `Unknown error (${errorCode})`;
}

// =============================================
// ENHANCED EVENT HANDLERS
// =============================================

function initializeEvents() {
  // Patient selection
  $('#consultation_patient_search').on('change', function() {
      const patientId = $(this).val();
      if (patientId) {
          loadEnhancedPatientDetails(patientId);
      } else {
          $('#patientDetailsSection').hide();
          resetEnhancedVerificationState();
      }
  });
  
   // Barcode print handler
   $(document).on('click', '#printBarcodeBtn', function() {
       printPatientBarcode();
   });
  
  // SecuGen fingerprint operations
  $('#manualVerifyBtn').on('click', function(e) {
      e.preventDefault();
      captureFingerprint();
  });

  $('#verifyIdentity').on('click', function(e) {
      e.preventDefault();
      performBiometricVerification();
  });
  
  // Verification controls
  $('#skipVerificationBtn').on('click', function() {
      skipEnhancedVerification();
  });
  
  $('#clearCaptureData').on('click', function() {
      clearEnhancedCaptureData();
  });
  
  // Patient action buttons
  $('#startConsultationBtn').on('click', function() {
      startEnhancedConsultation();
  });
  
  $('#reviewPatientBtn').on('click', function() {
      reviewPatientHistory();
  });
  
  // Patient review modal actions
  $('#printPatientSummary').on('click', function() {
      printPatientSummary();
  });
  
  $('#startNewConsultationFromReview').on('click', function() {
      startNewConsultationFromReview();
  });
  
  // Lab tests selection (OPTIONAL)
  $(document).on('change', '.lab-test-checkbox', function() {
      updateSelectedTestsSummary();
  });
  
  $('#selectAllTests').on('click', function() {
      const activeTab = $('.tab-pane.active');
      activeTab.find('.lab-test-checkbox').prop('checked', true);
      updateSelectedTestsSummary();
      showModernMessage('All tests in current category selected (optional)', 'info');
  });
  
  $('#clearAllTests').on('click', function() {
      $('.lab-test-checkbox').prop('checked', false);
      updateSelectedTestsSummary();
      showModernMessage('All test selections cleared', 'info');
  });
  
  // Diagnosis selection events (NON-GCC ONLY)
  $('#consultationDiagnosis').on('change', function() {
      const selectedValue = $(this).val();
      if (selectedValue) {
          selectDiagnosis(selectedValue);
      } else {
          $('#selectedDiagnosisInfo').hide();
          window.consultationState.selectedDiagnosis = null;
      }
  });
  
  $('#addCustomDiagnosis').on('click', function() {
      showCustomDiagnosis();
  });
  
  $('#clearDiagnosis').on('click', function() {
      clearDiagnosis();
  });
  
  // Form submissions
  $('#consultationForm').on('submit', function(e) {
      e.preventDefault();
      saveEnhancedConsultation();
  });
  
  logDiagnostic('Enhanced event handlers configured', 'success');
}

// =============================================
// UTILITY FUNCTIONS
// =============================================

function loadStoredFingerprintTemplate(patientId, hasFingerprint) {
  if (!hasFingerprint) {
      $('#storedTemplateDetails').html('<span class="text-muted">No fingerprint template stored</span>');
      return;
  }
  
  logDiagnostic(`🔐 Patient has fingerprint - fetching stored template for patient ID: ${patientId}`, 'info');
  
  $('#storedTemplateDetails').html(`
      <div class="text-center">
          <div class="spinner-modern"></div> Loading template...
      </div>
  `);
  
  $.ajax({
      url: window.consultationConfig.baseURL + window.consultationConfig.endpoints.getStoredTemplate,
      type: 'POST',
      data: { patient_id: patientId },
      dataType: 'json',
      timeout: 10000,
      success: function(response) {
          logDiagnostic('📥 Stored template response received', 'info');
          console.log('Full template response:', response);
          handleStoredTemplateResponse(response);
      },
      error: function(xhr, status, error) {
          logDiagnostic(`❌ Failed to fetch stored template: ${error}`, 'error');
          handleStoredTemplateError(xhr, status, error);
      }
  });
}

function handleStoredTemplateResponse(response) {
  try {
      if (response && response.status === 'success') {
          if (response.fingerprint_template && response.fingerprint_template.length > 0) {
              window.consultationState.storedTemplate = response.fingerprint_template;
              window.consultationState.selectedPatientData.stored_template = response.fingerprint_template;
              $('#patientStoredTemplate').val(response.fingerprint_template);
              
              if (response.fingerprint_image && response.fingerprint_image.length > 0) {
                  $('#storedFingerprintImage').attr('src', 'data:image/bmp;base64,' + response.fingerprint_image);
              }
              
              $('#storedTemplateDetails').html(`
                  <span class="text-success">✅ Template loaded (${response.fingerprint_template.length} chars)</span>
              `);
              
              logDiagnostic(`✅ Stored template loaded successfully: ${response.fingerprint_template.length} characters`, 'success');
          } else {
              $('#storedTemplateDetails').html('<span class="text-warning">⚠️ No template found in database</span>');
              logDiagnostic('⚠️ No stored template found for this patient', 'warning');
          }
      } else {
          const errorMsg = response.message || 'Unknown error occurred';
          $('#storedTemplateDetails').html(`<span class="text-danger">❌ Error: ${errorMsg}</span>`);
          logDiagnostic(`❌ Template fetch error: ${errorMsg}`, 'error');
      }
  } catch (error) {
      logDiagnostic(`❌ Error processing template response: ${error.message}`, 'error');
      $('#storedTemplateDetails').html('<span class="text-danger">❌ Failed to process response</span>');
  }
}

function handleStoredTemplateError(xhr, status, error) {
  let errorMessage = 'Failed to load stored fingerprint template';
  
  if (xhr.status === 404) {
      errorMessage = 'Template endpoint not found (404)';
  } else if (xhr.status === 500) {
      errorMessage = 'Server error loading template (500)';
  } else if (xhr.status === 0) {
      errorMessage = 'Network error - cannot connect to server';
  } else if (status === 'timeout') {
      errorMessage = 'Request timeout - server response too slow';
  }
  
  $('#storedTemplateDetails').html(`<span class="text-danger">❌ ${errorMessage}</span>`);
  logDiagnostic(`❌ Template fetch error: ${errorMessage}`, 'error');
  
  showModernMessage('⚠️ Could not load stored template - Manual mode still available', 'warning');
}

function loadPatientConsultations(patientId) {
  // Load recent consultations for this patient
  $('#recentConsultations').html('<p class="text-muted"><i class="fa fa-spinner fa-spin"></i> Loading consultations...</p>');
  
  // Simulate loading (replace with real AJAX call)
  setTimeout(() => {
      $('#recentConsultations').html('<p class="text-muted">No previous consultations found</p>');
  }, 1000);
}

function enhancePatientCard(patientData) {
  const card = $('#patientDetailsCard');
  
  card.removeClass('verified gcc-patient gcc-unverified');
  
  if (window.consultationState.isGCCPatient) {
      if (window.consultationState.verificationPassed) {
          card.addClass('verified gcc-patient');
          $('#workflowStatusPanel').removeClass('gcc-unverified').addClass('gcc-workflow');
          $('#workflowBadge').text('GCC Patient - Verified').removeClass().addClass('workflow-badge status-gcc');
      } else {
          card.addClass('gcc-unverified');
          $('#workflowStatusPanel').removeClass('gcc-workflow').addClass('gcc-unverified');
          $('#workflowBadge').text('GCC Patient - Verification Required').removeClass().addClass('workflow-badge status-required');
      }
  } else {
      $('#workflowBadge').text('General Patient').removeClass().addClass('workflow-badge status-general');
  }
}

function resetEnhancedVerificationState() {
  window.consultationState.verificationPassed = false;
  window.consultationState.storedTemplate = null;
  window.consultationState.liveTemplate = null;
  window.consultationState.currentMatchScore = 0;
  window.consultationState.verificationQuality = 'Unknown';
  
  $('#verificationPassed').val('0');
  $('#verificationStatus').html('');
  
  $("#fingerprintStatus").html(`
      <div class="status-info">
          <i class="fa fa-info-circle"></i> Ready for SecuGen biometric verification - Consultation Module
      </div>
  `);
  
  $('#storedFingerprintImage, #liveFingerprintImage').attr('src', './Images/PlaceFinger.bmp');
  $('#storedTemplateDetails').text('No template loaded');
  $('#liveTemplateDetails').text('Ready for capture');
  
  $('#manualVerifyBtn').prop('disabled', false);
  $('#verifyIdentity').prop('disabled', true);
  
  $('#patientStoredTemplate, #liveScannedTemplate').val('');
  window.consultationState.verificationHistory = [];
  updateVerificationHistoryDisplay();
}

function skipEnhancedVerification() {
  if (window.consultationState.requiresVerification) {
      const confirmMessage = `This is a GCC patient requiring biometric verification.\n\nAre you sure you want to proceed with admin override?`;
      if (!confirm(confirmMessage)) {
          return;
      }
      
      window.consultationState.verificationPassed = true;
      $('#verificationPassed').val('1');
      
      $('#verificationStatus').html('<span class="status-indicator status-warning"><i class="fa fa-user-shield"></i> GCC Admin Override</span>');
      
      $("#fingerprintStatus").html(`
          <div class="status-warning">
              <i class="fa fa-shield"></i> <strong>ENHANCED GCC verification bypassed - Admin override active</strong><br>
              <small>Biometric verification skipped by administrator for GCC patient</small>
          </div>
      `);
      
      $('#startConsultationBtn').prop('disabled', false);
      $('#reviewPatientBtn').prop('disabled', false);
      updateStepIndicator('consult');
      
      // Update workflow status
      $('#workflowStatusPanel').removeClass('gcc-unverified').addClass('gcc-workflow');
      $('#workflowBadge').text('GCC Patient - Admin Override').removeClass().addClass('workflow-badge status-warning');
      $('#currentPatientStatus').html(`
          <p style="margin: 0; font-size: 12px; color: white;">
              <i class="fa fa-user-shield"></i> <strong>Admin Override Active</strong><br>
              GCC verification bypassed by administrator
          </p>
      `);
      
      addToVerificationHistory('Admin Override', 0, 'Bypassed');
      showModernMessage('ENHANCED GCC verification bypassed - Admin override active', 'warning');
      
  } else {
      showModernMessage('Verification not required for this patient type', 'info');
  }
}

function clearEnhancedCaptureData() {
  window.consultationState.liveTemplate = null;
  $('#liveScannedTemplate').val('');
  $('#liveFingerprintImage').attr('src', './Images/PlaceFinger.bmp');
  $('#liveTemplateDetails').text('Ready for capture');
  $('#liveFingerprintContainer').removeClass('active');
  
  $("#fingerprintStatus").html(`
      <div class="status-info">
          <i class="fa fa-info-circle"></i> Enhanced capture data cleared - Ready for new verification
      </div>
  `);
  
  $('#verifyIdentity').prop('disabled', true);
  
  if (window.consultationState.storedTemplate) {
      showModernMessage('Live capture cleared. Use Manual Print Capture to scan fingerprint again.', 'info');
  }
}

// =============================================
// VERIFICATION HISTORY MANAGEMENT
// =============================================

function addToVerificationHistory(result, score, quality) {
  const timestamp = new Date().toLocaleTimeString();
  const patientName = $('#patientName').text() || 'Unknown';
  
  const historyItem = {
      timestamp: timestamp,
      patient: patientName,
      result: result,
      score: score,
      quality: quality,
      method: result === 'Admin Override' ? 'Admin Override' : 'SecuGen SGIMatchScore',
      workflowType: window.consultationState.patientWorkflowType || 'General',
      isGCCPatient: window.consultationState.isGCCPatient
  };
  
  window.consultationState.verificationHistory.unshift(historyItem);
  
  if (window.consultationState.verificationHistory.length > 10) {
      window.consultationState.verificationHistory.pop();
  }
  
  updateVerificationHistoryDisplay();
}

function updateVerificationHistoryDisplay() {
  let html = '';
  
  if (window.consultationState.verificationHistory.length === 0) {
      html = '<p class="text-muted">No verification attempts yet</p>';
  } else {
      window.consultationState.verificationHistory.forEach(item => {
          const resultClass = item.result === 'Success' ? 'text-success' : 
                            item.result === 'Admin Override' ? 'text-warning' : 'text-danger';
          const resultIcon = item.result === 'Success' ? 'fa-check' : 
                           item.result === 'Admin Override' ? 'fa-user-shield' : 'fa-times';
          
          const workflowBadge = item.isGCCPatient ? 
              '<span class="label label-warning" style="font-size: 9px;">GCC</span>' : 
              '<span class="label label-info" style="font-size: 9px;">GEN</span>';
          
          html += `
              <div style="border-left: 3px solid ${item.result === 'Success' ? '#5cb85c' : 
                                                 item.result === 'Admin Override' ? '#f0ad4e' : '#d9534f'}; 
                     padding: 8px; margin-bottom: 8px; background-color: #f9f9f9; border-radius: 3px;">
                  <div class="${resultClass}">
                      <i class="fa ${resultIcon}"></i> <strong>${item.result}</strong> ${workflowBadge}
                      <small class="pull-right">${item.timestamp}</small>
                  </div>
                  <small>Score: ${item.score}/199 | Quality: ${item.quality}</small><br>
                  <small class="text-muted">${item.method}</small>
              </div>
          `;
      });
  }
  
  $('#verificationHistory').html(html);
}

// =============================================
// BARCODE GENERATION FUNCTIONS
// =============================================

function generatePatientBarcode(patient) {
   console.log('🏷️ Generating enhanced barcode for patient:', patient);
   
   try {
       // Create comprehensive barcode data
       let barcodeData = createBarcodeData(patient);
       
       if (barcodeData) {
           // Generate the barcode with optimized settings
           JsBarcode("#patientBarcode", barcodeData, {
               format: "CODE128",
               width: 1,              
               height: 40,            
               displayValue: true,
               fontSize: 9,           
               margin: 5,             
               background: "#ffffff",
               lineColor: "#000000",
               textAlign: "center",
               textPosition: "bottom",
               fontOptions: "bold"
           });
           
           // Parse the data for display
           const parsedData = parseBarcodeData(barcodeData);
           
           // Display comprehensive barcode information
           $('#barcodeData').html(`
               <div style="text-align: left; font-size: 9px; line-height: 1.3;">
                   <strong style="font-size: 10px;">Barcode Information:</strong><br>
                   <strong>Patient:</strong> ${parsedData.patientName}<br>
                   <strong>ID:</strong> ${parsedData.patientId}<br>
                   <strong>Generated:</strong> ${parsedData.timestamp}<br>
                   <strong>Raw Data:</strong> <code style="font-size: 8px; word-break: break-all;">${barcodeData}</code>
               </div>
           `);
           
           console.log('✅ Enhanced barcode generated successfully');
           console.log('Barcode contains:', parsedData);
       } else {
           // Show error message
           $('#patientBarcode').parent().html(`
               <div class="text-center text-muted">
                   <i class="fa fa-exclamation-triangle"></i><br>
                   <small>Cannot generate barcode - missing patient data</small>
               </div>
           `);
       }
       
   } catch (error) {
       console.error('❌ Enhanced barcode generation error:', error);
       $('#patientBarcode').parent().html(`
           <div class="text-center text-danger">
               <i class="fa fa-times-circle"></i><br>
               <small>Barcode generation failed: ${error.message}</small>
           </div>
       `);
   }
}

function createBarcodeData(patient) {
   // Get current date and time
   const now = new Date();
   const dateStr = now.toISOString().split('T')[0]; // YYYY-MM-DD format
   const timeStr = now.toTimeString().split(' ')[0].substring(0, 5); // HH:MM format
   const timestamp = dateStr + ' ' + timeStr;
   
   // Get patient identification (priority order)
   let patientId = patient.identification_number || 
                  patient.patient_unique_id || 
                  patient.id || 
                  'UNK';
   
   // Get patient name (clean and truncate if needed)
   let patientName = (patient.patient_name || 'UNKNOWN').toUpperCase();
   
   // Remove special characters and limit length for barcode compatibility
   patientName = patientName.replace(/[^A-Z0-9\s]/g, '').substring(0, 20);
   patientId = String(patientId).replace(/[^A-Z0-9]/g, '').substring(0, 15);
   
   // Create structured barcode data
   // Format: NAME|ID|DATETIME
   let barcodeData = `${patientName}|${patientId}|${timestamp}`;
   
   // Ensure barcode data is not too long (CODE128 practical limit ~80 chars)
   if (barcodeData.length > 80) {
       // Truncate name further if needed
       const maxNameLength = 80 - patientId.length - timestamp.length - 2; // -2 for separators
       if (maxNameLength > 5) { // Minimum 5 chars for name
           patientName = patientName.substring(0, maxNameLength);
           barcodeData = `${patientName}|${patientId}|${timestamp}`;
       } else {
           // If still too long, use minimal format
           barcodeData = `${patientId}|${timestamp}`;
       }
   }
   
   console.log('Generated barcode data:', barcodeData);
   return barcodeData;
}

function parseBarcodeData(barcodeData) {
   try {
       const parts = barcodeData.split('|');
       
       if (parts.length === 3) {
           return {
               patientName: parts[0],
               patientId: parts[1],
               timestamp: parts[2],
               format: 'full'
           };
       } else if (parts.length === 2) {
           return {
               patientName: 'Not encoded',
               patientId: parts[0],
               timestamp: parts[1],
               format: 'minimal'
           };
       } else {
           return {
               patientName: 'Unknown',
               patientId: 'Unknown',
               timestamp: 'Unknown',
               format: 'invalid'
           };
       }
   } catch (error) {
       console.error('Error parsing barcode data:', error);
       return null;
   }
}

function printPatientBarcode() {
   console.log('🖨️ Printing optimized patient barcode...');
   
   const barcodeContainer = document.getElementById('patientBarcode').parentElement;
   const patientName = $('#patientName').text();
   
   // Create optimized print content for standard paper sizes
   const printContent = `
       <!DOCTYPE html>
       <html>
       <head>
           <title>Patient Barcode - ${patientName}</title>
           <style>
               body { 
                   font-family: Arial, sans-serif; 
                   text-align: center; 
                   margin: 10px;
                   background: white;
                   font-size: 12px;
               }
               .barcode-print-container {
                   border: 1px solid #000;
                   padding: 10px;
                   margin: 10px auto;
                   max-width: 300px;
                   background: white;
                   page-break-inside: avoid;
               }
               .patient-info {
                   margin-bottom: 8px;
                   font-size: 11px;
                   font-weight: bold;
                   line-height: 1.2;
               }
               .barcode-info {
                   margin-top: 8px;
                   font-size: 8px;
                   color: #666;
                   line-height: 1.1;
               }
               svg {
                   margin: 5px 0;
                   max-width: 100%;
                   height: auto;
               }
               
               @media print {
                   body { 
                       margin: 0; 
                       padding: 5px;
                       font-size: 10px;
                   }
                   .barcode-print-container { 
                       border: 1px solid #000; 
                       margin: 0; 
                       padding: 8px;
                       max-width: 280px;
                       box-shadow: none;
                   }
                   .patient-info {
                       font-size: 10px;
                       margin-bottom: 6px;
                   }
                   .barcode-info {
                       font-size: 7px;
                       margin-top: 6px;
                   }
                   svg {
                       margin: 3px 0;
                   }
                   
                   @page {
                       margin: 0.5in;
                       size: auto;
                   }
               }
           </style>
       </head>
       <body>
           <div class="barcode-print-container">
               <div class="patient-info">
                   Patient: ${patientName}<br>
                   ID: ${window.consultationState.selectedPatientId}<br>
                   Type: ${window.consultationState.patientWorkflowType}
               </div>
               ${barcodeContainer.outerHTML}
               <div class="barcode-info">
                   Generated: ${new Date().toLocaleDateString()}<br>
                   Enhanced Consultation System
               </div>
           </div>
       </body>
       </html>
   `;
   
   // Open print window with optimized settings
   const printWindow = window.open('', '_blank');
   printWindow.document.write(printContent);
   printWindow.document.close();
   
   // Wait for content to load then print
   printWindow.onload = function() {
       setTimeout(() => {
           printWindow.print();
           printWindow.close();
       }, 500);
   };
}

// =============================================
// MODERN UI ENHANCEMENTS
// =============================================

function initializeModernAnimations() {
  // Add fade-in animation to panels
  $('.consultation-panel').each(function(index) {
      $(this).delay(index * 200).queue(function() {
          $(this).addClass('fade-in').dequeue();
      });
  });
}

function updateStepIndicator(currentStep) {
  const steps = ['search', 'verify', 'consult', 'save'];
  const currentIndex = steps.indexOf(currentStep);
  
  $('.step').removeClass('active completed');
  
  for (let i = 0; i <= currentIndex; i++) {
      const stepElement = $(`#step-${steps[i]}`);
      if (i < currentIndex) {
          stepElement.addClass('completed');
      } else {
          stepElement.addClass('active');
      }
  }
  
  // Add animation effect
  $(`#step-${currentStep}`).addClass('pulse-highlight');
  setTimeout(() => {
      $(`#step-${currentStep}`).removeClass('pulse-highlight');
  }, 2000);
}

function showModernMessage(message, type = 'info', duration = 5000) {
  const iconMap = {
      'success': 'check-circle',
      'warning': 'exclamation-triangle', 
      'error': 'times-circle',
      'info': 'info-circle'
  };
  
  const alertClass = `alert-${type === 'error' ? 'danger' : type}-modern`;
  const icon = iconMap[type] || 'info-circle';
  
  const html = `
      <div class="${alertClass} fade-in" style="position: fixed; top: 20px; right: 20px; z-index: 9999; min-width: 320px; max-width: 400px; box-shadow: 0 8px 25px rgba(0,0,0,0.15);">
          <button type="button" class="close" onclick="$(this).parent().fadeOut()">&times;</button>
          <i class="fa fa-${icon}"></i> ${message}
      </div>
  `;
  
  $('body').append(html);
  
  setTimeout(() => {
      $('.alert-success-modern, .alert-info-modern, .alert-warning-modern, .alert-danger-modern').fadeOut(function() {
          $(this).remove();
      });
  }, duration);
}

function logDiagnostic(message, type = 'info') {
  const timestamp = new Date().toLocaleTimeString();
  const colorClass = type === 'error' ? 'text-danger' : 
                    type === 'success' ? 'text-success' : 
                    type === 'warning' ? 'text-warning' : 'text-info';
  
  console.log(`[ENHANCED-Consultation] ${message}`);
}

// =============================================
// ENHANCED MODAL HANDLERS
// =============================================

$('#consultationModal').on('hidden.bs.modal', function() {
  resetConsultationForm();
  $('#modalTitle').text('Enhanced Consultation Assessment');
  $('#modalConsultationId').val('');
  $('#modalVerificationDetails').html('');
});

$('#patientReviewModal').on('hidden.bs.modal', function() {
  // Clear review data
  window.consultationState.patientReview = {
      consultations: [],
      labTests: [],
      triageHistory: [],
      verifications: [],
      summary: {}
  };
});

// =============================================
// ENHANCED DEBUG FUNCTIONS
// =============================================

window.ENHANCED_CONSULTATION_DEBUG = {
  checkSystemStatus: function() {
      const state = window.consultationState;
      
      console.log('📋 ENHANCED CONSULTATION SYSTEM STATUS:');
      console.log('👤 Selected Patient:', state.selectedPatientId);
      console.log('🔄 Patient Workflow:', state.patientWorkflow);
      console.log('🔒 Requires Verification:', state.requiresVerification);
      console.log('✅ Is Verified:', state.verificationPassed);
      console.log('🩺 Can Start Consultation:', !state.requiresVerification || state.verificationPassed);
      console.log('🔐 SecuGen Active:', state.secugenActive);
      console.log('📊 Match Score:', state.currentMatchScore);
      console.log('🧪 Lab Tests Required:', state.labTests.isRequired);
      console.log('📋 ICD Diagnosis Hidden for GCC:', state.isGCCPatient);
      console.log('🔬 ENHANCED Version: Optional Lab Tests + GCC Diagnosis Hiding + Patient Review');
      
      return {
          workflow: state.patientWorkflow,
          requiresVerification: state.requiresVerification,
          isVerified: state.verificationPassed,
          canStartConsultation: !state.requiresVerification || state.verificationPassed,
          secugenActive: state.secugenActive,
          labTestsOptional: !state.labTests.isRequired,
          diagnosisHiddenForGCC: state.isGCCPatient,
          uiMode: 'enhanced_modern_mode_with_review',
          enhancedVersion: true
      };
  },
  
  simulateGCCPatient: function() {
      console.log('🧪 Simulating ENHANCED GCC patient selection...');
      
      window.consultationState.patientWorkflow = 'gcc';
      window.consultationState.requiresVerification = true;
      window.consultationState.verificationRequired = true;
      window.consultationState.verificationPassed = false;
      window.consultationState.isGCCPatient = true;
      window.consultationState.patientWorkflowType = 'GCC Workflow';
      
      setupGCCPatientWorkflow();
      
      console.log('✅ ENHANCED GCC patient simulation complete - verification REQUIRED, diagnosis HIDDEN');
  },
  
  simulateGeneralPatient: function() {
      console.log('🧪 Simulating ENHANCED General patient selection...');
      
      window.consultationState.patientWorkflow = 'general';
      window.consultationState.requiresVerification = false;
      window.consultationState.verificationRequired = false;
      window.consultationState.verificationPassed = true;
      window.consultationState.isGCCPatient = false;
      window.consultationState.patientWorkflowType = 'General Workflow';
      
      setupGeneralPatientWorkflow();
      
      console.log('✅ ENHANCED General patient simulation complete - verification OPTIONAL, diagnosis VISIBLE');
  },
  
  getEnhancedState: function() {
      console.group('ENHANCED Consultation System State');
      console.log('Main State:', window.consultationState);
      console.log('SecuGen Config:', window.secugenConfig);
      console.log('Consultation Config:', window.consultationConfig);
      console.log('UI Mode:', 'ENHANCED Modern with Optional Lab Tests + GCC Diagnosis Hiding + Patient Review');
      console.log('Lab Tests Available:', Object.keys(window.consultationState.labTests.available).length);
      console.log('Selected Tests:', window.consultationState.labTests.selected.length);
      console.log('Lab Tests Required:', window.consultationState.labTests.isRequired);
      console.log('ICD Diagnosis Hidden for GCC:', window.consultationState.isGCCPatient);
      console.log('ENHANCED Version:', 'Optional Lab Tests + GCC Diagnosis Control + Patient History Review');
      console.groupEnd();
      return window.consultationState;
  }
};

// =============================================
// GLOBAL TEST FUNCTIONS
// =============================================

window.testRealCapture = function() {
  console.log('🔧 Global shortcut: Real capturing...');
  captureFingerprint();
};

window.testRealVerification = function() {
  console.log('🔧 Global shortcut: Real verifying...');
  performBiometricVerification();
};

window.testSecuGenConnection = function() {
  console.log('🔧 Global shortcut: Testing SecuGen connection...');
  testHttpsConnection();
};

window.showSecuGenState = function() {
  console.log('🔧 Global shortcut: Showing SecuGen state...');
  console.group('SecuGen State');
  console.log('Service Active:', window.secugenConfig.serviceActive);
  console.log('Device Connected:', window.secugenConfig.deviceConnected);
  console.log('Current Protocol:', window.secugenConfig.currentProtocol);
  console.log('Service URL:', window.secugenConfig.serviceURL);
  console.log('Stored Template:', window.consultationState.storedTemplate ? 'Present' : 'Not loaded');
  console.log('Live Template:', window.consultationState.liveTemplate ? 'Present' : 'Not captured');
  console.groupEnd();
};

// =============================================
// SYSTEM READY
// =============================================

console.log(`
╔══════════════════════════════════════════════════════════════════════════════╗
║            🔬 ENHANCED CONSULTATION SYSTEM - COMPLETE VERSION 🔬           ║
║         WITH OPTIONAL LAB TESTS + GCC DIAGNOSIS HIDING + PATIENT REVIEW    ║
╠══════════════════════════════════════════════════════════════════════════════╣
║                                                                              ║
║ ✅ NEW ENHANCEMENTS IMPLEMENTED:                                            ║
║ ✓ Laboratory tests are now OPTIONAL (not enforced)                          ║
║ ✓ ICD-10 diagnosis section HIDDEN for GCC patients                          ║
║ ✓ ICD-10 diagnosis section VISIBLE for General patients only                ║
║ ✓ Patient review functionality with complete history                        ║
║ ✓ Review includes: Consultations, Lab Tests, Triage, Verifications          ║
║ ✓ Patient summary statistics and timeline                                   ║
║ ✓ Print patient summary functionality                                       ║
║ ✓ Start consultation directly from review modal                             ║
║                                                                              ║
║ 🔒 GCC WORKFLOW ENHANCEMENTS:                                              ║
║ • GCC patients: ICD diagnosis section is HIDDEN                             ║
║ • GCC patients: Lab tests are optional (not mandatory)                      ║
║ • GCC patients: Biometric verification still required                       ║
║ • GCC patients: Can review complete history without verification            ║
║                                                                              ║
║ 🔓 GENERAL WORKFLOW ENHANCEMENTS:                                          ║
║ • General patients: ICD diagnosis section is VISIBLE                        ║
║ • General patients: Lab tests are optional (not mandatory)                  ║
║ • General patients: No verification required                                ║
║ • General patients: Full access to review and consultation                  ║
║                                                                              ║
║ 🔬 LAB TESTS - NOW OPTIONAL:                                               ║
║ • Consultation can be saved WITHOUT selecting any lab tests                 ║
║ • Lab test section styled as "OPTIONAL" with gray header                    ║
║ • Form validation does NOT check for lab test selection                     ║
║ • Success message indicates if tests were included or not                   ║
║                                                                              ║
║ 📋 PATIENT REVIEW FUNCTIONALITY:                                           ║
║ • Complete patient history accessible via "Review Patient History" button   ║
║ • Includes consultation history, lab results, triage visits, verifications  ║
║ • Summary statistics with totals and timeline information                   ║
║ • Print-friendly patient summary report                                     ║
║ • Direct consultation start from review modal                               ║
║                                                                              ║
║ 🚀 QUICK TEST COMMANDS:                                                    ║
║ ENHANCED_CONSULTATION_DEBUG.checkSystemStatus() - Check system status       ║
║ ENHANCED_CONSULTATION_DEBUG.simulateGCCPatient() - Test GCC workflow        ║
║ ENHANCED_CONSULTATION_DEBUG.simulateGeneralPatient() - Test General workflow║
║                                                                              ║
║ 💡 ENHANCED USAGE FLOW:                                                    ║
║ 1. Select patient → See workflow-specific UI                                ║
║ 2. Use "Review Patient History" to see complete medical history             ║
║ 3. Use "New Consultation" for new visit                                     ║
║ 4. GCC patients: No ICD diagnosis, verification required                    ║
║ 5. General patients: Full ICD diagnosis, no verification                    ║
║ 6. Lab tests are optional for ALL patient types                             ║
║ 7. Save consultation with or without lab tests                              ║
║                                                                              ║
╚══════════════════════════════════════════════════════════════════════════════╝

🔬 ENHANCED Consultation System Ready with ALL requested features! 🚀

New Features:
✅ Lab tests are now OPTIONAL (not enforced)
✅ ICD diagnosis HIDDEN for GCC patients, VISIBLE for General patients  
✅ Patient review with complete history (consultations, labs, triage, etc.)
✅ Print patient summary functionality
✅ Enhanced workflow-specific UI behavior

Test Commands:
- ENHANCED_CONSULTATION_DEBUG.simulateGCCPatient() - Test GCC workflow
- ENHANCED_CONSULTATION_DEBUG.simulateGeneralPatient() - Test General workflow
- ENHANCED_CONSULTATION_DEBUG.checkSystemStatus() - Check system state
`);
</script>
</body>
</html>
   <style>
       /* Base Layout - Adopted from Triage System */
       body {
           background: #f8f9fa;
           font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
           margin: 0;
           padding: 0;
       }
       
       .content-wrapper {
           background: #f8f9fa;
           min-height: 100vh;
           padding: 15px;
           max-width: 100%;
           overflow-x: hidden;
       }
       
       .container-fluid {
           max-width: 1400px;
           margin: 0 auto;
           padding: 0 15px;
       }
       
       /* Page Header - Enhanced from Triage */
       .page-header {
           background: white;
           border-bottom: 3px solid #28a745;
           padding: 20px 25px;
           margin-bottom: 20px;
           border-radius: 8px;
           box-shadow: 0 2px 8px rgba(0,0,0,0.1);
           border: 1px solid #e9ecef;
       }
       
       .page-title {
           color: #2c3e50;
           margin: 0 0 8px 0;
           font-size: 24px;
           font-weight: 600;
           display: flex;
           align-items: center;
           gap: 10px;
       }
       
       .page-subtitle {
           color: #6c757d;
           margin: 0 0 15px 0;
           font-size: 14px;
           font-weight: 400;
       }
       
       .page-actions {
           display: flex;
           gap: 8px;
           flex-wrap: wrap;
       }
       
       .page-actions .btn {
           font-size: 13px;
           padding: 8px 16px;
       }
       
       /* Enhanced Panels - From Triage Design */
       .consultation-panel {
           background: white;
           border-radius: 8px;
           box-shadow: 0 2px 8px rgba(0,0,0,0.1);
           margin-bottom: 20px;
           overflow: hidden;
           border: 1px solid #e9ecef;
           transition: all 0.3s ease;
       }
       
       .consultation-panel:hover {
           box-shadow: 0 4px 12px rgba(0,0,0,0.15);
       }
       
       .panel-header {
           background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
           border-bottom: 2px solid #dee2e6;
           padding: 15px 20px;
       }
       
       .panel-title {
           color: #495057;
           margin: 0;
           font-size: 16px;
           font-weight: 600;
           display: flex;
           align-items: center;
           gap: 8px;
       }
       
       .panel-body {
           padding: 20px;
       }
       
       /* Status Indicators - From Triage */
       .status-indicator {
           padding: 6px 12px;
           border-radius: 16px;
           font-size: 11px;
           font-weight: 600;
           text-transform: uppercase;
           letter-spacing: 0.3px;
           display: inline-block;
       }
       
       .status-verified {
           background: #d4edda;
           color: #155724;
           border: 1px solid #c3e6cb;
       }
       
       .status-gcc {
           background: #e3f2fd;
           color: #1976d2;
           border: 1px solid #bbdefb;
       }
       
       .status-general {
           background: #f3e5f5;
           color: #7b1fa2;
           border: 1px solid #e1bee7;
       }
       
       .status-pending {
           background: #fff3cd;
           color: #856404;
           border: 1px solid #ffeaa7;
       }
       
       /* SecuGen Status Indicators */
       .status-success {
           background: #d4edda;
           color: #155724;
           border: 1px solid #c3e6cb;
           padding: 10px;
           border-radius: 6px;
           margin-bottom: 15px;
       }
       
       .status-warning {
           background: #fff3cd;
           color: #856404;
           border: 1px solid #ffeaa7;
           padding: 10px;
           border-radius: 6px;
           margin-bottom: 15px;
       }
       
       .status-error {
           background: #f8d7da;
           color: #721c24;
           border: 1px solid #f5c6cb;
           padding: 10px;
           border-radius: 6px;
           margin-bottom: 15px;
       }
       
       .status-info {
           background: #e3f2fd;
           color: #1976d2;
           border: 1px solid #bbdefb;
           padding: 10px;
           border-radius: 6px;
           margin-bottom: 15px;
       }
       
       /* Enhanced Patient Cards */
       .patient-search-container {
           background: white;
           border: 2px solid #e9ecef;
           border-radius: 8px;
           padding: 15px;
           margin-bottom: 15px;
       }
       
       .patient-details-card {
           background: white;
           border: 2px solid #e9ecef;
           border-radius: 8px;
           padding: 20px;
           margin-bottom: 15px;
           transition: all 0.3s ease;
       }
       
       .patient-details-card.verified {
           border-color: #28a745;
           background: linear-gradient(135deg, #f8fff9 0%, #ffffff 100%);
       }
       
       .patient-details-card.gcc-patient {
           border-color: #007bff;
           background: linear-gradient(135deg, #f0f8ff 0%, #ffffff 100%);
       }
       
       .patient-info-grid {
           display: grid;
           grid-template-columns: 1fr;
           gap: 20px;
           align-items: start;
       }
       
       .patient-basic-info {
           display: grid;
           grid-template-columns: 1fr 1fr;
           gap: 15px;
       }
       
       .info-item {
           margin-bottom: 10px;
       }
       
       .info-label {
           font-weight: 600;
           color: #495057;
           font-size: 13px;
       }
       
       .info-value {
           color: #6c757d;
           font-size: 13px;
           margin-top: 2px;
       }
       
       .patient-photo-container {
           text-align: center;
           padding: 15px;
           background: #f8f9fa;
           border-radius: 6px;
           border: 2px dashed #dee2e6;
       }
       
       .patient-photo {
           max-width: 100px;
           max-height: 100px;
           border-radius: 6px;
           box-shadow: 0 2px 4px rgba(0,0,0,0.1);
           border: 2px solid #e9ecef;
       }
       
       /* Patient Actions Section */
       .patient-actions-panel {
           background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
           border-radius: 8px;
           padding: 15px;
           color: white;
           text-align: center;
           margin-top: 15px;
       }
       
       .action-buttons {
           display: flex;
           gap: 10px;
           justify-content: center;
           margin-top: 10px;
       }
       
       /* Workflow Status Panel */
       .workflow-status-panel {
           background: linear-gradient(135deg, #28a745 0%, #20c997 100%);
           border-radius: 8px;
           padding: 15px;
           color: white;
           text-align: center;
           margin-top: 15px;
       }
       
       .workflow-badge {
           background: rgba(255,255,255,0.2);
           border: 1px solid rgba(255,255,255,0.3);
           border-radius: 12px;
           padding: 6px 12px;
           font-size: 11px;
           font-weight: 600;
           text-transform: uppercase;
           letter-spacing: 0.5px;
           display: inline-block;
           margin-bottom: 8px;
       }
       
       /* Enhanced Verification Section */
       .verification-container {
           background: #f8f9fa;
           border-radius: 8px;
           padding: 20px;
           border: 2px solid #e9ecef;
           margin: 15px 0;
       }
       
       .verification-grid {
           display: grid;
           grid-template-columns: 1fr 1fr;
           gap: 20px;
       }
       
       .fingerprint-display-container {
           text-align: center;
           padding: 15px;
           background: white;
           border-radius: 6px;
           border: 2px dashed #dee2e6;
           transition: all 0.3s ease;
       }
       
       .fingerprint-display-container.active {
           border-color: #007bff;
           background: #f0f8ff;
       }
       
       .fingerprint-image {
           max-width: 120px;
           max-height: 100px;
           border-radius: 6px;
           box-shadow: 0 2px 4px rgba(0,0,0,0.1);
           border: 1px solid #dee2e6;
       }
       
       .verification-status-display {
           margin: 15px 0;
           padding: 15px;
           border-radius: 6px;
           border: 1px solid #dee2e6;
       }
       
       /* Enhanced Buttons */
       .btn-modern {
           background: #28a745;
           border: none;
           color: white;
           padding: 10px 20px;
           border-radius: 6px;
           font-weight: 600;
           font-size: 13px;
           transition: all 0.3s ease;
           box-shadow: 0 2px 4px rgba(40,167,69,0.2);
       }
       
       .btn-modern:hover {
           background: #218838;
           transform: translateY(-1px);
           box-shadow: 0 4px 8px rgba(40,167,69,0.3);
           color: white;
       }
       
       .btn-modern:disabled {
           background: #6c757d;
           transform: none;
           box-shadow: none;
       }
       
       .btn-verification {
           background: #007bff;
           color: white;
       }
       
       .btn-verification:hover {
           background: #0056b3;
           color: white;
       }
       
       .btn-manual {
           background: #6c757d;
           color: white;
       }
       
       .btn-manual:hover {
           background: #545b62;
           color: white;
       }
       
       .btn-warning-modern {
           background: #ffc107;
           color: #212529;
       }
       
       .btn-warning-modern:hover {
           background: #e0a800;
           color: #212529;
       }
       
       .btn-info-modern {
           background: #17a2b8;
           color: white;
       }
       
       .btn-info-modern:hover {
           background: #138496;
           color: white;
       }
       
       .btn-lg {
           padding: 12px 24px;
           font-size: 14px;
       }
       
       .btn-sm {
           padding: 6px 12px;
           font-size: 12px;
       }
       
       .btn-block {
           width: 100%;
           display: block;
       }
       
       /* Enhanced Form Elements */
       .form-control-modern {
           border: 2px solid #e9ecef;
           border-radius: 6px;
           padding: 10px 12px;
           font-size: 13px;
           transition: all 0.3s ease;
           background: white;
           width: 100%;
           box-sizing: border-box;
       }
       
       .form-control-modern:focus {
           border-color: #28a745;
           box-shadow: 0 0 0 0.2rem rgba(40,167,69,0.25);
           outline: none;
       }
       
       .form-group-modern {
           margin-bottom: 15px;
       }
       
       .form-label-modern {
           font-weight: 600;
           color: #495057;
           margin-bottom: 6px;
           display: block;
           font-size: 13px;
       }
       
       .form-control {
           font-size: 13px;
       }
       
       select.form-control-modern {
           height: auto;
           min-height: 38px;
       }
       
       textarea.form-control-modern {
           resize: vertical;
       }
       
       /* Enhanced Alerts */
       .alert-modern {
           border: none;
           border-radius: 6px;
           padding: 12px 16px;
           margin: 12px 0;
           box-shadow: 0 2px 4px rgba(0,0,0,0.1);
           font-size: 13px;
       }
       
       .alert-info-modern {
           background: #e3f2fd;
           color: #1976d2;
           border-left: 4px solid #2196f3;
       }
       
       .alert-success-modern {
           background: #e8f5e8;
           color: #2e7d32;
           border-left: 4px solid #4caf50;
       }
       
       .alert-warning-modern {
           background: #fff8e1;
           color: #ef6c00;
           border-left: 4px solid #ff9800;
       }
       
       .alert-danger-modern {
           background: #ffebee;
           color: #c62828;
           border-left: 4px solid #f44336;
       }
       
       /* Step Indicator */
       .step-indicator {
           display: flex;
           justify-content: space-between;
           margin: 20px 0;
           padding: 0 15px;
       }
       
       .step {
           flex: 1;
           text-align: center;
           position: relative;
       }
       
       .step:not(:last-child)::after {
           content: '';
           position: absolute;
           top: 12px;
           right: -50%;
           width: 100%;
           height: 2px;
           background: #dee2e6;
           z-index: 1;
       }
       
       .step.active::after {
           background: #28a745;
       }
       
       .step.completed::after {
           background: #007bff;
       }
       
       .step-circle {
           width: 24px;
           height: 24px;
           border-radius: 50%;
           background: #dee2e6;
           color: white;
           display: flex;
           align-items: center;
           justify-content: center;
           margin: 0 auto 6px;
           font-weight: 600;
           font-size: 12px;
           position: relative;
           z-index: 2;
           transition: all 0.3s ease;
       }
       
       .step.active .step-circle {
           background: #28a745;
           box-shadow: 0 0 8px rgba(40,167,69,0.5);
       }
       
       .step.completed .step-circle {
           background: #007bff;
       }
       
       .step-label {
           font-size: 11px;
           font-weight: 600;
           color: #6c757d;
       }
       
       .step.active .step-label {
           color: #28a745;
       }
       
       .step.completed .step-label {
           color: #007bff;
       }
       
       /* Loading Spinner */
       .spinner-modern {
           display: inline-block;
           width: 16px;
           height: 16px;
           border: 2px solid #f3f3f3;
           border-top: 2px solid #28a745;
           border-radius: 50%;
           animation: spin 1s linear infinite;
       }
       
       @keyframes spin {
           0% { transform: rotate(0deg); }
           100% { transform: rotate(360deg); }
       }
       
       /* Fade In Animation */
       .fade-in {
           animation: fadeIn 0.5s ease-in;
       }
       
       @keyframes fadeIn {
           from { opacity: 0; transform: translateY(10px); }
           to { opacity: 1; transform: translateY(0); }
       }
       
       /* Pulse Highlight */
       .pulse-highlight {
           animation: pulse-border-modern 2s;
       }
       
       @keyframes pulse-border-modern {
           0% { 
               border-color: #e9ecef; 
               box-shadow: 0 0 5px rgba(233, 236, 239, 0.3); 
           }
           50% { 
               border-color: #28a745; 
               box-shadow: 0 0 15px rgba(40, 167, 69, 0.6); 
           }
           100% { 
               border-color: #e9ecef; 
               box-shadow: 0 0 5px rgba(233, 236, 239, 0.3); 
           }
       }
       
       /* Navigation Tabs - Enhanced */
       .nav-tabs-modern {
           border-bottom: 2px solid #dee2e6;
           margin-bottom: 20px;
           display: flex;
           flex-wrap: wrap;
       }
       
       .nav-tabs-modern > li {
           flex: 1;
           min-width: 0;
       }
       
       .nav-tabs-modern > li > a {
           border: none;
           border-radius: 6px 6px 0 0;
           padding: 10px 12px;
           font-weight: 600;
           font-size: 12px;
           color: #6c757d;
           transition: all 0.3s ease;
           text-align: center;
           white-space: nowrap;
           overflow: hidden;
           text-overflow: ellipsis;
       }
       
       .nav-tabs-modern > li.active > a {
           background: #28a745;
           color: white;
           border-bottom: 2px solid #28a745;
       }
       
       .nav-tabs-modern > li > a:hover {
           background: #f8f9fa;
           color: #28a745;
       }
       
       /* Table Enhanced */
       .table-modern {
           font-size: 12px;
           background: white;
           border-radius: 6px;
           overflow: hidden;
           box-shadow: 0 2px 8px rgba(0,0,0,0.1);
       }
       
       .table-modern th,
       .table-modern td {
           padding: 8px 6px;
           vertical-align: middle;
       }
       
       .table-modern thead th {
           background: #f8f9fa;
           border-bottom: 2px solid #dee2e6;
           font-weight: 600;
           color: #495057;
       }
       
       .table-modern tbody tr:hover {
           background: #f8f9fa;
       }
       
       .table-responsive {
           border: 1px solid #dee2e6;
           border-radius: 6px;
       }
       
       /* Lab Tests Specific Styles - OPTIONAL STYLING */
       .lab-tests-panel {
           background: linear-gradient(135deg, #007bff 0%, #0056b3 100%);
           border-radius: 8px;
           padding: 15px;
           color: white;
           margin-top: 15px;
       }
       
       .lab-tests-optional {
           background: linear-gradient(135deg, #6c757d 0%, #495057 100%);
       }
       
       .test-category-tab {
           background: rgba(255,255,255,0.1);
           border: 1px solid rgba(255,255,255,0.2);
           border-radius: 6px;
           margin: 5px;
           padding: 8px 12px;
           color: white;
           font-size: 12px;
           font-weight: 600;
           transition: all 0.3s ease;
       }
       
       .test-category-tab.active,
       .test-category-tab:hover {
           background: rgba(255,255,255,0.2);
           border-color: rgba(255,255,255,0.4);
       }
       
       .test-checkbox {
           border: 1px solid #e9ecef;
           border-radius: 6px;
           padding: 8px;
           margin: 5px 0;
           background: white;
           transition: all 0.3s ease;
       }
       
       .test-checkbox:hover {
           border-color: #28a745;
           background: #f8fff9;
       }
       
       .test-checkbox input[type="checkbox"]:checked + label {
           color: #28a745;
           font-weight: 600;
       }
       
       /* Summary Cards */
       .summary-card {
           background: white;
           border-radius: 8px;
           padding: 20px;
           border: 1px solid #e9ecef;
           box-shadow: 0 2px 8px rgba(0,0,0,0.1);
           margin-bottom: 15px;
           transition: all 0.3s ease;
       }
       
       .summary-card:hover {
           box-shadow: 0 4px 12px rgba(0,0,0,0.15);
       }
       
       .summary-card-icon {
           font-size: 24px;
           color: #28a745;
           margin-bottom: 10px;
       }
       
       .summary-card-value {
           font-size: 28px;
           font-weight: 700;
           color: #2c3e50;
           margin-bottom: 5px;
       }
       
       .summary-card-label {
           font-size: 14px;
           color: #6c757d;
           font-weight: 500;
       }
       
       /* Patient Review Panel */
       .patient-review-panel {
           background: white;
           border-radius: 8px;
           box-shadow: 0 2px 8px rgba(0,0,0,0.1);
           margin-bottom: 20px;
           overflow: hidden;
           border: 1px solid #e9ecef;
       }
       
       .review-section {
           padding: 15px;
           border-bottom: 1px solid #e9ecef;
       }
       
       .review-section:last-child {
           border-bottom: none;
       }
       
       .review-section h6 {
           color: #495057;
           font-weight: 600;
           margin-bottom: 10px;
           font-size: 14px;
       }
       
       .review-item {
           background: #f8f9fa;
           border: 1px solid #e9ecef;
           border-radius: 4px;
           padding: 10px;
           margin-bottom: 8px;
       }
       
       .review-item:last-child {
           margin-bottom: 0;
       }
       
       /* Responsive Design */
       @media (max-width: 1200px) {
           .container-fluid {
               max-width: 100%;
               padding: 0 10px;
           }
           
           .patient-info-grid {
               grid-template-columns: 1fr;
               gap: 15px;
           }
           
           .verification-grid {
               grid-template-columns: 1fr;
               gap: 15px;
           }
       }
       
       @media (max-width: 768px) {
           .content-wrapper {
               padding: 10px;
           }
           
           .page-header {
               padding: 15px;
               margin-bottom: 15px;
           }
           
           .page-title {
               font-size: 20px;
           }
           
           .page-subtitle {
               font-size: 13px;
           }
           
           .page-actions {
               flex-direction: column;
               gap: 8px;
           }
           
           .panel-body {
               padding: 15px;
           }
           
           .patient-basic-info {
               grid-template-columns: 1fr;
               gap: 10px;
           }
           
           .verification-grid {
               grid-template-columns: 1fr;
               gap: 15px;
           }
           
           .verification-container {
               padding: 15px;
           }
           
           .step-indicator {
               flex-wrap: wrap;
               gap: 10px;
               padding: 0 10px;
           }
           
           .step::after {
               display: none;
           }
           
           .step {
               flex: 1 1 calc(50% - 5px);
               margin-bottom: 10px;
           }
           
           .btn-group {
               display: flex;
               flex-direction: column;
               gap: 8px;
           }
           
           .btn-group .btn {
               width: 100%;
           }
           
           .modal-lg {
               max-width: 95%;
           }
           
           .modal-body {
               padding: 15px;
           }
           
           .nav-tabs-modern > li {
               flex: 1 1 50%;
           }
           
           .nav-tabs-modern > li > a {
               padding: 8px 6px;
               font-size: 11px;
           }
           
           .action-buttons {
               flex-direction: column;
               gap: 8px;
           }
       }
       
       @media (max-width: 480px) {
           .content-wrapper {
               padding: 8px;
           }
           
           .page-header {
               padding: 12px;
           }
           
           .page-title {
               font-size: 18px;
           }
           
           .step {
               flex: 1 1 100%;
           }
           
           .panel-body {
               padding: 12px;
           }
           
           .verification-container {
               padding: 12px;
           }
           
           .btn-modern {
               padding: 8px 12px;
               font-size: 12px;
           }
           
           .form-control-modern {
               padding: 8px 10px;
               font-size: 12px;
           }
           
           .modal-dialog {
               margin: 10px;
           }
           
           .nav-tabs-modern > li {
               flex: 1 1 100%;
           }
           
           .nav-tabs-modern {
               flex-direction: column;
           }
           
           .nav-tabs-modern > li > a {
               border-radius: 0;
               border-bottom: 1px solid #dee2e6;
           }
       }
       
       /* Container Constraints */
       .container-fluid {
           max-width: 100vw;
           overflow-x: hidden;
       }
       
       .row {
           margin-left: -10px;
           margin-right: -10px;
       }
       
       .col-md-1, .col-md-2, .col-md-3, .col-md-4, .col-md-5, .col-md-6,
       .col-md-7, .col-md-8, .col-md-9, .col-md-10, .col-md-11, .col-md-12 {
           padding-left: 10px;
           padding-right: 10px;
       }
       
       /* Prevent horizontal scroll */
       html, body {
           overflow-x: hidden;
           max-width: 100%;
       }
       
       * {
           box-sizing: border-box;
       }
       
       /* Custom Scrollbar */
       ::-webkit-scrollbar {
           width: 6px;
       }
       
       ::-webkit-scrollbar-track {
           background: #f1f1f1;
           border-radius: 3px;
       }
       
       ::-webkit-scrollbar-thumb {
           background: #c1c1c1;
           border-radius: 3px;
       }
       
       ::-webkit-scrollbar-thumb:hover {
           background: #a1a1a1;
       }
       
/* ✅ Enhanced CSS for comprehensive barcode display */
.patient-barcode-container {
    background: linear-gradient(145deg, #f8f9fa 0%, #e9ecef 100%);
    border: 2px solid #dee2e6;
    border-radius: 8px;
    padding: 12px;
    margin-top: 15px;
    text-align: center;
    transition: all 0.3s ease;
    max-width: 300px;
    margin-left: auto;
    margin-right: auto;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.patient-barcode-container:hover {
    border-color: #28a745;
    background: linear-gradient(145deg, #f8fff9 0%, #e8f5e9 100%);
    box-shadow: 0 4px 8px rgba(0,0,0,0.15);
}

.patient-barcode-container h6 {
    margin-bottom: 8px;
    font-weight: 600; 
    font-size: 12px;
    color: #495057;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

#patientBarcode {
    max-width: 100%;
    height: auto;
    margin: 8px 0;
    background: white;
    padding: 4px;
    border-radius: 4px;
    border: 1px solid #dee2e6;
}

#barcodeData {
    background: white;
    border: 1px solid #dee2e6;
    border-radius: 4px;
    padding: 8px;
    margin-top: 8px;
    font-size: 9px;
    color: #495057;
    text-align: left;
    line-height: 1.3;
}

#barcodeData strong {
    color: #212529;
    font-size: 10px;
}

#barcodeData code {
    background: #f8f9fa;
    border: 1px solid #e9ecef;
    border-radius: 2px;
    padding: 2px 4px;
    font-size: 8px;
    font-family: 'Courier New', monospace;
    color: #6f42c1;
}

/* Enhanced print button group */
.barcode-actions {
    margin-top: 12px;
    display: flex;
    justify-content: center;
    gap: 8px;
    flex-wrap: wrap;
}

#printBarcodeBtn {
    padding: 6px 12px;
    font-size: 11px;
    border-radius: 4px;
    transition: all 0.3s ease;
}

.btn-group .dropdown-menu {
    min-width: 180px;
    font-size: 11px;
}

.btn-group .dropdown-menu li a {
    padding: 6px 12px;
    white-space: nowrap;
}

.btn-group .dropdown-menu li a i {
    width: 16px;
    margin-right: 6px;
}

/* Barcode validation indicators */
.barcode-status {
    margin-top: 6px;
    padding: 4px 8px;
    border-radius: 3px;
    font-size: 9px;
    font-weight: 600;
    text-align: center;
}

.barcode-status.valid {
    background: #d4edda;
    color: #155724;
    border: 1px solid #c3e6cb;
}

.barcode-status.warning {
    background: #fff3cd;
    color: #856404;
    border: 1px solid #ffeaa7;
}

.barcode-status.error {
    background: #f8d7da;
    color: #721c24;
    border: 1px solid #f5c6cb;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .patient-barcode-container {
        max-width: 280px;
        padding: 10px;
    }
    
    .patient-barcode-container h6 {
        font-size: 11px;
    }
    
    #barcodeData {
        font-size: 8px;
        padding: 6px;
    }
    
    .barcode-actions {
        flex-direction: column;
        align-items: center;
    }
    
    #printBarcodeBtn {
        font-size: 10px;
        padding: 5px 10px;
    }
}

/* Very compact version for small screens */
@media (max-width: 480px) {
    .patient-barcode-container {
        max-width: 260px;
        padding: 8px;
    }
    
    .patient-barcode-container h6 {
        font-size: 10px;
        margin-bottom: 6px;
    }
    
    #barcodeData {
        font-size: 7px;
        padding: 4px;
    }
    
    #barcodeData code {
        font-size: 7px;
    }
}

/* Print preview styles */
.print-preview {
    border: 2px dashed #007bff;
    background: #f0f8ff;
    margin-top: 10px;
    padding: 10px;
    border-radius: 4px;
}

.print-preview h6 {
    color: #007bff;
    margin-bottom: 8px;
}

/* Animation for barcode generation.. */
.barcode-generating {
    opacity: 0.6;
    transform: scale(0.95);
    transition: all 0.5s ease;
}

.barcode-generated {
    opacity: 1;
    transform: scale(1);
    animation: barcodeGenerated 0.5s ease;
}

@keyframes barcodeGenerated {
    0% { 
        opacity: 0.6; 
        transform: scale(0.95); 
    }
    50% { 
        opacity: 0.8; 
        transform: scale(1.02); 
    }
    100% { 
        opacity: 1; 
        transform: scale(1); 
    }
}
</style>