<link rel="stylesheet" href="<?php echo base_url();?>backend/dist/css/jquery-ui.css">
<style>
    .content-wrapper { background-color: #ecf0f5; }
    
    .patient-header {
        background: linear-gradient(135deg, #00a65a 0%, #00c0ef 100%);
        color: white; padding: 20px; border-radius: 8px; margin-bottom: 20px;
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }
    
    .patient-type-badge {
        padding: 8px 16px; border-radius: 20px; font-weight: bold;
        display: inline-block; margin-bottom: 10px; color: white;
    }
    
    .type-gcc { background: #17a2b8; }
    .type-general { background: #28a745; }
    .type-specialized { background: #dc3545; }
    
    .billing-status-card {
        background: white; border-radius: 8px; padding: 20px;
        box-shadow: 0 2px 8px rgba(0,0,0,0.1); margin-bottom: 20px;
        border-left: 4px solid #00a65a;
    }
    
    .status-indicator {
        padding: 8px 16px; border-radius: 20px; font-weight: bold;
        display: inline-block; margin-bottom: 10px;
    }
    
    .status-paid { background: #d4edda; color: #155724; }
    .status-partial { background: #fff3cd; color: #856404; }
    .status-unpaid { background: #f8d7da; color: #721c24; }
    
    .amount-display {
        font-size: 24px; font-weight: bold; margin: 10px 0;
    }
    
    .amount-total { color: #333; }
    .amount-paid { color: #28a745; }
    .amount-due { color: #dc3545; }
    
    .progress-billing {
        height: 10px; border-radius: 5px; margin: 15px 0;
    }
    
    .service-card {
        background: white; border-radius: 8px; margin-bottom: 15px;
        border: 1px solid #e3e3e3; transition: all 0.3s ease;
    }
    
    .service-card:hover {
        box-shadow: 0 4px 12px rgba(0,0,0,0.1); border-color: #00a65a;
    }
    
    .service-header {
        background: #f8f9fa; padding: 15px; border-bottom: 1px solid #e3e3e3;
        border-radius: 8px 8px 0 0;
    }
    
    .service-icon {
        width: 40px; height: 40px; border-radius: 50%;
        display: inline-flex; align-items: center; justify-content: center;
        margin-right: 15px; color: white; font-size: 18px;
    }
    
    .service-registration { background: #17a2b8; }
    .service-consultation { background: #28a745; }
    .service-laboratory { background: #fd7e14; }
    .service-radiology { background: #e83e8c; }
    .service-pharmacy { background: #20c997; }
    .service-procedures { background: #dc3545; }
    
    .service-body {
        padding: 15px;
    }
    
    .charge-item {
        display: flex; justify-content: space-between; align-items: center;
        padding: 8px 0; border-bottom: 1px solid #f0f0f0;
    }
    
    .charge-item:last-child { border-bottom: none; }
    
    .payment-history {
        max-height: 300px; overflow-y: auto;
    }
    
    .payment-item {
        background: #f8f9fa; padding: 10px; border-radius: 6px;
        margin-bottom: 10px; border-left: 4px solid #28a745;
    }
    
    .btn-action {
        margin: 2px; border-radius: 4px; padding: 5px 10px;
        font-size: 12px; transition: all 0.3s ease;
    }
    
    .btn-generate {
        background: linear-gradient(45deg, #00a65a, #00c0ef);
        color: white; border: none;
    }
    
    .btn-generate:hover {
        transform: translateY(-1px); box-shadow: 0 4px 8px rgba(0,166,90,0.3);
        color: white;
    }
    
    .form-control:focus {
        border-color: #00a65a;
        box-shadow: 0 0 0 0.2rem rgba(0,166,90,0.25);
    }
    
    .gcc-info {
        background: linear-gradient(45deg, #17a2b8, #20c997);
        color: white; padding: 20px; border-radius: 8px; margin-bottom: 20px;
    }
    
    .pricing-breakdown {
        background: white; border-radius: 8px; padding: 15px;
        box-shadow: 0 2px 6px rgba(0,0,0,0.08); margin-bottom: 15px;
    }
    
    .price-item {
        display: flex; justify-content: space-between; align-items: center;
        padding: 8px 0; border-bottom: 1px solid #f0f0f0;
    }
    
    .price-item:last-child { border-bottom: none; font-weight: bold; }
    
    .service-actions {
        margin-top: 15px;
    }
</style>

<div class="content-wrapper">
    <section class="content-header">
        <h1>
            <i class="fa fa-user-circle"></i> Patient Billing Summary
            <small>Comprehensive billing overview for <?php echo $patient['patient_name']; ?></small>
        </h1>
        <ol class="breadcrumb">
            <li><a href="<?php echo base_url('admin/dashboard'); ?>"><i class="fa fa-dashboard"></i> Home</a></li>
            <li><a href="<?php echo base_url('admin/bill/dashboard'); ?>">Billing</a></li>
            <li class="active">Patient Summary</li>
        </ol>
    </section>

    <section class="content">
        <!-- Patient Information Header -->
        <div class="patient-header">
            <div class="row">
                <div class="col-md-8">
                    <div class="patient-type-badge type-<?php echo $patient_type; ?>">
                        <?php 
                        $type_labels = array('gcc' => 'GCC Patient', 'general' => 'General Patient', 'specialized' => 'Specialized Patient');
                        echo $type_labels[$patient_type];
                        ?>
                    </div>
                    <h3><i class="fa fa-user"></i> <?php echo $patient['patient_name']; ?></h3>
                    <div class="row">
                        <div class="col-md-4">
                            <p><strong>Patient ID:</strong> <?php echo $patient['patient_unique_id']; ?></p>
                            <p><strong>Phone:</strong> <?php echo $patient['mobileno']; ?></p>
                        </div>
                        <div class="col-md-4">
                            <p><strong>Email:</strong> <?php echo $patient['email']; ?></p>
                            <p><strong>Age:</strong> <?php echo $patient['age']; ?> years</p>
                        </div>
                        <div class="col-md-4">
                            <p><strong>Gender:</strong> <?php echo $patient['gender']; ?></p>
                            <p><strong>Registration Date:</strong> <?php echo date('M j, Y', strtotime($patient['created_at'])); ?></p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 text-right">
                    <div class="status-indicator status-<?php echo $billing_status['status']; ?>">
                        <?php echo ucfirst($billing_status['status']); ?>
                    </div>
                    <div style="margin-top: 10px;">
                        <?php if ($patient_type == 'gcc'): ?>
                            <button class="btn btn-generate btn-lg" onclick="generateGCCInvoice()">
                                <i class="fa fa-file-text"></i> Generate GCC Invoice
                            </button>
                        <?php else: ?>
                            <button class="btn btn-generate btn-lg" onclick="generateInvoice()">
                                <i class="fa fa-file-text"></i> Generate Invoice
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Patient Type Specific Information -->
        <?php if ($patient_type == 'gcc'): ?>
            <div class="gcc-info">
                <div class="row">
                    <div class="col-md-8">
                        <h4><i class="fa fa-globe"></i> GCC Medical Examination Package</h4>
                        <p>This patient is registered for Gulf Cooperation Council medical examination with a comprehensive package including all required tests and consultations.</p>
                    </div>
                    <div class="col-md-4 text-right">
                        <div class="amount-display" style="color: white;">
                            KES 10,500
                        </div>
                        <small>Fixed Package Fee</small>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <!-- Billing Status Overview -->
        <div class="row">
            <div class="col-md-3">
                <div class="billing-status-card">
                    <div class="amount-display amount-total">
                        KES <?php echo number_format($billing_status['total_amount'], 2); ?>
                    </div>
                    <div class="text-muted">Total Amount</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="billing-status-card">
                    <div class="amount-display amount-paid">
                        KES <?php echo number_format($billing_status['total_paid'], 2); ?>
                    </div>
                    <div class="text-muted">Amount Paid</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="billing-status-card">
                    <div class="amount-display amount-due">
                        KES <?php echo number_format($billing_status['total_due'], 2); ?>
                    </div>
                    <div class="text-muted">Amount Due</div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="billing-status-card">
                    <div class="amount-display" style="color: #00a65a;">
                        <?php echo $billing_status['percentage_paid']; ?>%
                    </div>
                    <div class="text-muted">Payment Progress</div>
                    <div class="progress progress-billing">
                        <div class="progress-bar bg-success" style="width: <?php echo $billing_status['percentage_paid']; ?>%"></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Service Charges by Patient Type -->
        <div class="row">
            <div class="col-md-8">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <h3 class="box-title">
                            <i class="fa fa-list"></i> 
                            <?php 
                            $section_titles = array(
                                'gcc' => 'GCC Package Breakdown',
                                'general' => 'General Patient Services',
                                'specialized' => 'Specialized Services'
                            );
                            echo $section_titles[$patient_type];
                            ?>
                        </h3>
                        <div class="box-tools pull-right">
                            <button class="btn btn-sm btn-success" onclick="addNewCharge()">
                                <i class="fa fa-plus"></i> Add Charge
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <?php if (!empty($all_charges)): ?>
                            <?php foreach ($all_charges as $module => $charges): ?>
                                <div class="service-card">
                                    <div class="service-header">
                                        <div class="row">
                                            <div class="col-md-8">
                                                <span class="service-icon service-<?php echo $module; ?>">
                                                    <?php 
                                                    $icons = array(
                                                        'registration' => 'fa-clipboard',
                                                        'consultation' => 'fa-stethoscope',
                                                        'laboratory' => 'fa-flask',
                                                        'radiology' => 'fa-x-ray',
                                                        'pharmacy' => 'fa-pills',
                                                        'procedures' => 'fa-user-md'
                                                    );
                                                    echo '<i class="fa ' . (isset($icons[$module]) ? $icons[$module] : 'fa-medical') . '"></i>';
                                                    ?>
                                                </span>
                                                <strong><?php echo ucfirst(str_replace('_', ' ', $module)); ?></strong>
                                            </div>
                                            <div class="col-md-4 text-right">
                                                <?php 
                                                $module_total = 0;
                                                $module_paid = 0;
                                                foreach ($charges as $charge) {
                                                    $module_total += $charge->charge;
                                                    if (!empty($charge->payments)) {
                                                        foreach ($charge->payments as $payment) {
                                                            $module_paid += $payment->amount;
                                                        }
                                                    }
                                                }
                                                ?>
                                                <span class="label label-primary">
                                                    KES <?php echo number_format($module_total, 2); ?>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="service-body">
                                        <?php foreach ($charges as $charge): ?>
                                            <div class="charge-item">
                                                <div>
                                                    <strong><?php echo $charge->service_type; ?></strong>
                                                    <?php if (isset($charge->description)): ?>
                                                        <br><small class="text-muted"><?php echo $charge->description; ?></small>
                                                    <?php endif; ?>
                                                    <br><small class="text-muted">
                                                        Bill #<?php echo $charge->bill_no; ?> - 
                                                        <?php echo isset($charge->created_at) ? date('M j, Y', strtotime($charge->created_at)) : 'N/A'; ?>
                                                    </small>
                                                </div>
                                                <div class="text-right">
                                                    <div class="amount-display" style="font-size: 16px;">
                                                        KES <?php echo number_format($charge->charge, 2); ?>
                                                    </div>
                                                    <?php if (!empty($charge->payments)): ?>
                                                        <small class="text-success">
                                                            Paid: KES <?php 
                                                            $paid_amount = 0;
                                                            foreach ($charge->payments as $payment) {
                                                                $paid_amount += $payment->amount;
                                                            }
                                                            echo number_format($paid_amount, 2); 
                                                            ?>
                                                        </small>
                                                    <?php else: ?>
                                                        <small class="text-danger">Unpaid</small>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <!-- No charges yet - show pricing breakdown for patient type -->
                            <div class="pricing-breakdown">
                                <h4>Expected Charges for <?php echo ucfirst($patient_type); ?> Patient</h4>
                                
                                <?php if ($patient_type == 'gcc'): ?>
                                    <div class="price-item">
                                        <span>GCC Medical Examination Package</span>
                                        <span><strong>KES 10,500</strong></span>
                                    </div>
                                    <small class="text-muted">
                                        <i class="fa fa-info-circle"></i> 
                                        Comprehensive package includes consultation, laboratory tests, radiology, and medical report
                                    </small>
                                    
                                <?php elseif ($patient_type == 'general'): ?>
                                    <div class="price-item">
                                        <span>General Consultation</span>
                                        <span>KES 900</span>
                                    </div>
                                    <div class="price-item">
                                        <span>Laboratory Tests</span>
                                        <span>As per test rates</span>
                                    </div>
                                    <div class="price-item">
                                        <span>Radiology Services</span>
                                        <span>As per procedure rates</span>
                                    </div>
                                    <div class="price-item">
                                        <span>Pharmacy</span>
                                        <span>As per medication costs</span>
                                    </div>
                                    
                                <?php elseif ($patient_type == 'specialized'): ?>
                                    <div class="price-item">
                                        <span>Specialized Consultation</span>
                                        <span>KES 1,500</span>
                                    </div>
                                    <div class="price-item">
                                        <span>Dental Procedures</span>
                                        <span>As per procedure rates</span>
                                    </div>
                                    <div class="price-item">
                                        <span>Optical Services</span>
                                        <span>As per service rates</span>
                                    </div>
                                    <div class="price-item">
                                        <span>Other Specialized Procedures</span>
                                        <span>As per procedure rates</span>
                                    </div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="service-actions">
                                <?php if ($patient_type == 'gcc'): ?>
                                    <button class="btn btn-info" onclick="recordGCCPayment()">
                                        <i class="fa fa-money"></i> Record GCC Payment
                                    </button>
                                <?php else: ?>
                                    <button class="btn btn-success" onclick="addConsultationCharge()">
                                        <i class="fa fa-plus"></i> Add Consultation Charge
                                    </button>
                                    <button class="btn btn-info" onclick="addLabCharge()">
                                        <i class="fa fa-flask"></i> Add Lab Charge
                                    </button>
                                    <button class="btn btn-warning" onclick="addRadiologyCharge()">
                                        <i class="fa fa-x-ray"></i> Add Radiology Charge
                                    </button>
                                    <button class="btn btn-primary" onclick="addPharmacyCharge()">
                                        <i class="fa fa-pills"></i> Add Pharmacy Charge
                                    </button>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <!-- Payment History & Actions -->
            <div class="col-md-4">
                <div class="box box-success">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-money"></i> Payment History</h3>
                        <div class="box-tools pull-right">
                            <button class="btn btn-sm btn-success" onclick="addPayment()">
                                <i class="fa fa-plus"></i> Add Payment
                            </button>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="payment-history">
                            <?php if (!empty($payment_history)): ?>
                                <?php foreach ($payment_history as $payment): ?>
                                    <div class="payment-item">
                                        <div class="row">
                                            <div class="col-md-8">
                                                <strong>KES <?php echo number_format($payment['amount'], 2); ?></strong>
                                                <br><small><?php echo $payment['payment_mode']; ?></small>
                                                <br><small class="text-muted"><?php echo isset($payment['section']) ? ucfirst($payment['section']) : 'General'; ?></small>
                                            </div>
                                            <div class="col-md-4 text-right">
                                                <small><?php echo date('M j', strtotime($payment['payment_date'])); ?></small>
                                                <br><a href="javascript:void(0)" onclick="printReceipt('<?php echo $payment['id']; ?>')">
                                                    <i class="fa fa-print"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php else: ?>
                                <div class="text-center text-muted">
                                    <i class="fa fa-credit-card"></i>
                                    <p>No payments recorded</p>
                                    <?php if ($patient_type == 'gcc'): ?>
                                        <button class="btn btn-sm btn-success" onclick="recordGCCPayment()">
                                            Record GCC Payment
                                        </button>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"><i class="fa fa-bolt"></i> Quick Actions</h3>
                    </div>
                    <div class="box-body">
                        <?php if ($patient_type == 'gcc'): ?>
                            <button class="btn btn-block btn-primary btn-sm" onclick="generateGCCInvoice()">
                                <i class="fa fa-file-text"></i> Generate GCC Invoice
                            </button>
                            <button class="btn btn-block btn-success btn-sm" onclick="recordGCCPayment()" style="margin-top: 10px;">
                                <i class="fa fa-money"></i> Record Payment
                            </button>
                        <?php else: ?>
                            <button class="btn btn-block btn-primary btn-sm" onclick="generateInvoice()">
                                <i class="fa fa-file-text"></i> Generate Invoice
                            </button>
                            <button class="btn btn-block btn-success btn-sm" onclick="addPayment()" style="margin-top: 10px;">
                                <i class="fa fa-money"></i> Record Payment
                            </button>
                        <?php endif; ?>
                        <button class="btn btn-block btn-info btn-sm" onclick="sendStatement()" style="margin-top: 10px;">
                            <i class="fa fa-envelope"></i> Send Statement
                        </button>
                        <button class="btn btn-block btn-warning btn-sm" onclick="printSummary()" style="margin-top: 10px;">
                            <i class="fa fa-print"></i> Print Summary
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Navigation -->
        <div class="box box-default">
            <div class="box-header with-border">
                <h3 class="box-title"><i class="fa fa-link"></i> Related Actions</h3>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-md-3">
                        <a href="<?php echo base_url('admin/bill/dashboard'); ?>" class="btn btn-primary btn-block">
                            <i class="fa fa-arrow-left"></i><br>Back to Billing<br>
                            <small>Return to dashboard</small>
                        </a>
                    </div>
                    <div class="col-md-3">
                        <a href="<?php echo base_url('admin/patient/profile/' . $patient_id); ?>" class="btn btn-info btn-block">
                            <i class="fa fa-user"></i><br>Patient Profile<br>
                            <small>View complete record</small>
                        </a>
                    </div>
                    <div class="col-md-3">
                        <a href="<?php echo base_url('admin/bill/reports'); ?>" class="btn btn-success btn-block">
                            <i class="fa fa-chart-bar"></i><br>Reports<br>
                            <small>Financial analytics</small>
                        </a>
                    </div>
                    <div class="col-md-3">
                        <a href="<?php echo base_url('admin/bill/download_center'); ?>" class="btn btn-warning btn-block">
                            <i class="fa fa-download"></i><br>Downloads<br>
                            <small>Invoice archive</small>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Add Payment Modal -->
<div class="modal fade" id="addPaymentModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header" style="background: linear-gradient(45deg, #00a65a, #00c0ef); color: white;">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="fa fa-money"></i> Record Payment</h4>
            </div>
            <form id="addPaymentForm">
                <div class="modal-body">
                    <input type="hidden" name="patient_id" value="<?php echo $patient_id; ?>">
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Amount (KES)</label>
                                <input type="number" name="amount" class="form-control" step="0.01" 
                                       max="<?php echo $billing_status['total_due']; ?>" required>
                                <small class="text-muted">Outstanding: KES <?php echo number_format($billing_status['total_due'], 2); ?></small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Payment Date</label>
                                <input type="date" name="payment_date" class="form-control" 
                                       value="<?php echo date('Y-m-d'); ?>" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Payment Mode</label>
                                <select name="payment_mode" class="form-control" required onchange="toggleChequeFields(this.value)">
                                    <option value="Cash">Cash</option>
                                    <option value="Cheque">Cheque</option>
                                    <option value="Card">Card</option>
                                    <option value="Bank Transfer">Bank Transfer</option>
                                    <option value="Mobile Money">Mobile Money</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Service Type</label>
                                <select name="service_type" class="form-control" required>
                                    <?php if ($patient_type == 'gcc'): ?>
                                        <option value="gcc_registration">GCC Registration</option>
                                    <?php elseif ($patient_type == 'general'): ?>
                                        <option value="consultation">Consultation</option>
                                        <option value="laboratory">Laboratory</option>
                                        <option value="radiology">Radiology</option>
                                        <option value="pharmacy">Pharmacy</option>
                                    <?php elseif ($patient_type == 'specialized'): ?>
                                        <option value="specialized_consultation">Specialized Consultation</option>
                                        <option value="procedures">Procedures</option>
                                        <option value="laboratory">Laboratory</option>
                                        <option value="radiology">Radiology</option>
                                    <?php endif; ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                    <div id="chequeFields" style="display: none;">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Cheque Number</label>
                                    <input type="text" name="cheque_no" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Cheque Date</label>
                                    <input type="date" name="cheque_date" class="form-control">
                                </div>
                            </div>
                        </div>
                        <div class="form-group">
                            <label>Attachment</label>
                            <input type="file" name="payment_document" class="form-control" accept=".jpg,.jpeg,.png,.pdf">
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label>Notes</label>
                        <textarea name="note" class="form-control" rows="3" 
                                  placeholder="Payment notes..."></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">
                        <i class="fa fa-save"></i> Record Payment
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script type="text/javascript">
$(document).ready(function() {
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();
});

function addPayment() {
    $('#addPaymentModal').modal('show');
}

function recordGCCPayment() {
    // Pre-fill for GCC payment
    $('input[name="amount"]').val(<?php echo $billing_status['total_due']; ?>);
    $('select[name="service_type"]').val('gcc_registration');
    $('#addPaymentModal').modal('show');
}

function toggleChequeFields(paymentMode) {
    if (paymentMode === 'Cheque') {
        $('#chequeFields').show();
        $('input[name="cheque_no"], input[name="cheque_date"]').prop('required', true);
    } else {
        $('#chequeFields').hide();
        $('input[name="cheque_no"], input[name="cheque_date"]').prop('required', false);
    }
}

// Add Payment Form Submit
$('#addPaymentForm').on('submit', function(e) {
    e.preventDefault();
    
    var formData = new FormData(this);
    
    $.ajax({
        url: base_url + 'admin/bill/add_payment',
        type: 'POST',
        data: formData,
        processData: false,
        contentType: false,
        dataType: 'json',
        beforeSend: function() {
            $('#addPaymentModal .btn-success').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Processing...');
        },
        success: function(response) {
            if (response.status === 'success') {
                $('#addPaymentModal').modal('hide');
                toastr.success(response.message);
                location.reload();
            } else {
                toastr.error(response.message || 'Failed to record payment');
            }
        },
        error: function() {
            toastr.error('An error occurred while recording the payment');
        },
        complete: function() {
            $('#addPaymentModal .btn-success').prop('disabled', false).html('<i class="fa fa-save"></i> Record Payment');
        }
    });
});

function generateGCCInvoice() {
    $.ajax({
        url: base_url + 'admin/bill/generate_gcc_invoice',
        type: 'POST',
        data: { patient_id: <?php echo $patient_id; ?> },
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                toastr.success('GCC invoice generated successfully');
                window.open(base_url + 'admin/bill/download_invoice_pdf/' + response.invoice_id, '_blank');
            } else {
                toastr.error(response.message || 'Failed to generate invoice');
            }
        }
    });
}

function generateInvoice() {
    // Show invoice generation modal for general and specialized patients
    showInvoiceGenerationModal();
}

function showInvoiceGenerationModal() {
    var modalHtml = `
    <div class="modal fade" id="generateInvoiceModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header" style="background: linear-gradient(45deg, #00a65a, #00c0ef); color: white;">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">
                        <i class="fa fa-file-text"></i> Generate Patient Invoice
                    </h4>
                </div>
                <form id="generateInvoiceForm">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Patient Name</label>
                                    <input type="text" class="form-control" value="${getPatientName()}" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Patient ID</label>
                                    <input type="text" class="form-control" value="${getPatientId()}" readonly>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Invoice Type <span class="text-danger">*</span></label>
                                    <select name="invoice_type" class="form-control" required>
                                        <option value="final">Final Invoice</option>
                                        <option value="interim">Interim Invoice</option>
                                        <option value="partial">Partial Invoice</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Invoice Date <span class="text-danger">*</span></label>
                                    <input type="date" name="invoice_date" class="form-control" 
                                           value="${new Date().toISOString().split('T')[0]}" required>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Due Date <span class="text-danger">*</span></label>
                                    <input type="date" name="due_date" class="form-control" 
                                           value="${getDefaultDueDate()}" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label>Services to Include</label>
                            <div class="row">
                                <div class="col-md-12">
                                    <div id="servicesSelection">
                                        ${generateServiceCheckboxes()}
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Discount (%)</label>
                                    <input type="number" name="discount_percentage" class="form-control" 
                                           min="0" max="100" step="0.01" value="0" 
                                           onchange="calculateInvoiceTotal()">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Tax (%)</label>
                                    <input type="number" name="tax_percentage" class="form-control" 
                                           min="0" max="50" step="0.01" value="16" 
                                           onchange="calculateInvoiceTotal()">
                                </div>
                            </div>
                        </div>
                        
                        <div class="invoice-summary" style="background: #f8f9fa; padding: 15px; border-radius: 6px; margin: 20px 0;">
                            <h5 style="color: #00a65a; margin-bottom: 15px;">Invoice Summary</h5>
                            <div class="row">
                                <div class="col-md-3">
                                    <div class="text-center">
                                        <div style="font-size: 18px; font-weight: bold;" id="subtotalAmount">
                                            KES 0.00
                                        </div>
                                        <small class="text-muted">Subtotal</small>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="text-center">
                                        <div style="font-size: 18px; font-weight: bold;" id="discountAmount">
                                            KES 0.00
                                        </div>
                                        <small class="text-muted">Discount</small>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="text-center">
                                        <div style="font-size: 18px; font-weight: bold;" id="taxAmount">
                                            KES 0.00
                                        </div>
                                        <small class="text-muted">Tax</small>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="text-center">
                                        <div style="font-size: 20px; font-weight: bold; color: #00a65a;" id="totalAmount">
                                            KES 0.00
                                        </div>
                                        <small class="text-muted">Total</small>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label>Invoice Notes</label>
                            <textarea name="invoice_notes" class="form-control" rows="3" 
                                      placeholder="Additional notes for the invoice...">Thank you for choosing City Health Clinic. Please settle this invoice by the due date.</textarea>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="checkbox">
                                    <label>
                                        <input type="checkbox" name="send_email" checked>
                                        Email invoice to patient
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="checkbox">
                                    <label>
                                        <input type="checkbox" name="mark_as_sent" checked>
                                        Mark as sent immediately
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">
                            <i class="fa fa-times"></i> Cancel
                        </button>
                        <button type="button" class="btn btn-info" onclick="previewInvoice()">
                            <i class="fa fa-eye"></i> Preview
                        </button>
                        <button type="submit" class="btn btn-success">
                            <i class="fa fa-file-text"></i> Generate Invoice
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    `;
    
    // Remove existing modal if any
    $('#generateInvoiceModal').remove();
    
    // Add modal to body
    $('body').append(modalHtml);
    
    // Show modal
    $('#generateInvoiceModal').modal('show');
    
    // Calculate initial total
    setTimeout(calculateInvoiceTotal, 500);
    
    // Handle form submission
    $('#generateInvoiceForm').on('submit', function(e) {
        e.preventDefault();
        processInvoiceGeneration();
    });
}

function generateServiceCheckboxes() {
    var checkboxesHtml = '';
    var services = [];
    
    // Extract services from the current page
    $('.service-card').each(function() {
        var serviceName = $(this).find('.service-header strong').text();
        var serviceAmount = $(this).find('.label-primary').text().replace('KES ', '').replace(',', '');
        
        services.push({
            name: serviceName,
            amount: parseFloat(serviceAmount) || 0
        });
    });
    
    // If no services found, add default options based on patient type
    if (services.length === 0) {
        var patientType = getPatientType();
        if (patientType === 'general') {
            services = [
                { name: 'General Consultation', amount: 900 },
                { name: 'Laboratory Tests', amount: 0 },
                { name: 'Radiology Services', amount: 0 },
                { name: 'Pharmacy', amount: 0 }
            ];
        } else if (patientType === 'specialized') {
            services = [
                { name: 'Specialized Consultation', amount: 1500 },
                { name: 'Procedures', amount: 0 },
                { name: 'Laboratory Tests', amount: 0 },
                { name: 'Radiology Services', amount: 0 }
            ];
        }
    }
    
    services.forEach(function(service, index) {
        checkboxesHtml += `
        <div class="col-md-6" style="margin-bottom: 10px;">
            <div class="checkbox" style="margin: 0;">
                <label style="display: flex; align-items: center; padding: 8px; background: #f8f9fa; border-radius: 4px;">
                    <input type="checkbox" name="services[]" value="${service.name}" 
                           data-amount="${service.amount}" onchange="calculateInvoiceTotal()" 
                           ${service.amount > 0 ? 'checked' : ''}>
                    <span style="margin-left: 8px; flex: 1;">${service.name}</span>
                    <span style="font-weight: bold; color: #00a65a;">
                        KES ${service.amount.toLocaleString()}
                    </span>
                </label>
            </div>
        </div>
        `;
    });
    
    return checkboxesHtml;
}

function calculateInvoiceTotal() {
    var subtotal = 0;
    
    // Calculate subtotal from selected services
    $('input[name="services[]"]:checked').each(function() {
        subtotal += parseFloat($(this).data('amount') || 0);
    });
    
    var discountPercentage = parseFloat($('input[name="discount_percentage"]').val() || 0);
    var taxPercentage = parseFloat($('input[name="tax_percentage"]').val() || 0);
    
    var discountAmount = (subtotal * discountPercentage) / 100;
    var taxableAmount = subtotal - discountAmount;
    var taxAmount = (taxableAmount * taxPercentage) / 100;
    var totalAmount = taxableAmount + taxAmount;
    
    // Update display
    $('#subtotalAmount').text('KES ' + subtotal.toLocaleString('en-KE', {minimumFractionDigits: 2}));
    $('#discountAmount').text('KES ' + discountAmount.toLocaleString('en-KE', {minimumFractionDigits: 2}));
    $('#taxAmount').text('KES ' + taxAmount.toLocaleString('en-KE', {minimumFractionDigits: 2}));
    $('#totalAmount').text('KES ' + totalAmount.toLocaleString('en-KE', {minimumFractionDigits: 2}));
}

function getDefaultDueDate() {
    var date = new Date();
    date.setDate(date.getDate() + 30); // 30 days from today
    return date.toISOString().split('T')[0];
}

function previewInvoice() {
    var selectedServices = [];
    $('input[name="services[]"]:checked').each(function() {
        selectedServices.push({
            name: $(this).val(),
            amount: parseFloat($(this).data('amount'))
        });
    });
    
    if (selectedServices.length === 0) {
        toastr.warning('Please select at least one service to include in the invoice.');
        return;
    }
    
    // Generate preview window
    var previewWindow = window.open('', '_blank', 'width=800,height=600');
    
    var subtotal = 0;
    selectedServices.forEach(service => subtotal += service.amount);
    
    var discountPercentage = parseFloat($('input[name="discount_percentage"]').val() || 0);
    var taxPercentage = parseFloat($('input[name="tax_percentage"]').val() || 0);
    var discountAmount = (subtotal * discountPercentage) / 100;
    var taxAmount = ((subtotal - discountAmount) * taxPercentage) / 100;
    var totalAmount = subtotal - discountAmount + taxAmount;
    
    var previewContent = `
    <!DOCTYPE html>
    <html>
    <head>
        <title>Invoice Preview - ${getPatientName()}</title>
        <style>
            body { font-family: Arial, sans-serif; margin: 20px; line-height: 1.6; }
            .header { text-align: center; border-bottom: 2px solid #00a65a; padding-bottom: 20px; margin-bottom: 30px; }
            .clinic-name { font-size: 24px; font-weight: bold; color: #00a65a; margin-bottom: 10px; }
            .invoice-info { background: #f8f9fa; padding: 20px; border-radius: 8px; margin-bottom: 25px; }
            .services-table { width: 100%; border-collapse: collapse; margin: 20px 0; }
            .services-table th, .services-table td { padding: 12px; border: 1px solid #ddd; text-align: left; }
            .services-table th { background: #00a65a; color: white; }
            .totals { margin-top: 30px; text-align: right; }
            .total-row { display: flex; justify-content: space-between; padding: 8px 0; }
            .grand-total { font-size: 18px; font-weight: bold; color: #00a65a; border-top: 2px solid #00a65a; margin-top: 10px; padding-top: 10px; }
        </style>
    </head>
    <body>
        <div class="header">
            <div class="clinic-name">City Health Clinic</div>
            <div>INVOICE PREVIEW</div>
        </div>
        
        <div class="invoice-info">
            <h3>Invoice Information</h3>
            <p><strong>Patient:</strong> ${getPatientName()}</p>
            <p><strong>Patient ID:</strong> ${getPatientId()}</p>
            <p><strong>Invoice Type:</strong> ${$('select[name="invoice_type"]').val()}</p>
            <p><strong>Invoice Date:</strong> ${$('input[name="invoice_date"]').val()}</p>
            <p><strong>Due Date:</strong> ${$('input[name="due_date"]').val()}</p>
        </div>
        
        <table class="services-table">
            <thead>
                <tr>
                    <th>Service Description</th>
                    <th style="width: 20%; text-align: right;">Amount</th>
                </tr>
            </thead>
            <tbody>
                ${selectedServices.map(service => `
                <tr>
                    <td>${service.name}</td>
                    <td style="text-align: right;">KES ${service.amount.toLocaleString()}</td>
                </tr>
                `).join('')}
            </tbody>
        </table>
        
        <div class="totals" style="width: 300px; margin-left: auto;">
            <div class="total-row">
                <span>Subtotal:</span>
                <span>KES ${subtotal.toLocaleString()}</span>
            </div>
            ${discountAmount > 0 ? `
            <div class="total-row">
                <span>Discount (${discountPercentage}%):</span>
                <span>- KES ${discountAmount.toLocaleString()}</span>
            </div>
            ` : ''}
            ${taxAmount > 0 ? `
            <div class="total-row">
                <span>Tax (${taxPercentage}%):</span>
                <span>KES ${taxAmount.toLocaleString()}</span>
            </div>
            ` : ''}
            <div class="total-row grand-total">
                <span>Total Amount:</span>
                <span>KES ${totalAmount.toLocaleString()}</span>
            </div>
        </div>
        
        <div style="text-align: center; margin-top: 30px;">
            <button onclick="window.close()" style="background: #6c757d; color: white; border: none; padding: 10px 20px; border-radius: 4px; cursor: pointer;">
                Close Preview
            </button>
        </div>
    </body>
    </html>
    `;
    
    previewWindow.document.write(previewContent);
    previewWindow.document.close();
}

function processInvoiceGeneration() {
    var selectedServices = [];
    $('input[name="services[]"]:checked').each(function() {
        selectedServices.push({
            name: $(this).val(),
            amount: parseFloat($(this).data('amount'))
        });
    });
    
    if (selectedServices.length === 0) {
        toastr.warning('Please select at least one service to include in the invoice.');
        return;
    }
    
    var formData = $('#generateInvoiceForm').serialize();
    var invoiceData = {
        patient_id: '<?php echo $patient_id; ?>',
        services: selectedServices,
        subtotal: 0,
        discount_amount: 0,
        tax_amount: 0,
        total_amount: 0
    };
    
    // Calculate amounts
    selectedServices.forEach(service => invoiceData.subtotal += service.amount);
    
    var discountPercentage = parseFloat($('input[name="discount_percentage"]').val() || 0);
    var taxPercentage = parseFloat($('input[name="tax_percentage"]').val() || 0);
    
    invoiceData.discount_amount = (invoiceData.subtotal * discountPercentage) / 100;
    invoiceData.tax_amount = ((invoiceData.subtotal - invoiceData.discount_amount) * taxPercentage) / 100;
    invoiceData.total_amount = invoiceData.subtotal - invoiceData.discount_amount + invoiceData.tax_amount;
    
    $.ajax({
        url: base_url + 'admin/bill/generate_invoice',
        type: 'POST',
        data: formData + '&' + $.param(invoiceData),
        dataType: 'json',
        beforeSend: function() {
            $('#generateInvoiceModal .btn-success').prop('disabled', true)
                .html('<i class="fa fa-spinner fa-spin"></i> Generating...');
        },
        success: function(response) {
            if (response.status === 'success') {
                $('#generateInvoiceModal').modal('hide');
                toastr.success('Invoice generated successfully!');
                
                // Offer to download or view the invoice
                setTimeout(function() {
                    if (confirm('Invoice generated successfully! Would you like to download it now?')) {
                        window.open(base_url + 'admin/bill/download_invoice_pdf/' + response.invoice_id, '_blank');
                    }
                    location.reload();
                }, 1000);
            } else {
                toastr.error(response.message || 'Failed to generate invoice');
            }
        },
        error: function() {
            toastr.error('An error occurred while generating the invoice');
        },
        complete: function() {
            $('#generateInvoiceModal .btn-success').prop('disabled', false)
                .html('<i class="fa fa-file-text"></i> Generate Invoice');
        }
    });
}

function addNewCharge() {
    showAddChargeModal();
}

function showAddChargeModal() {
    var modalHtml = `
    <div class="modal fade" id="addChargeModal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header" style="background: linear-gradient(45deg, #28a745, #20c997); color: white;">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">
                        <i class="fa fa-plus"></i> Add New Charge
                    </h4>
                </div>
                <form id="addChargeForm">
                    <div class="modal-body">
                        <input type="hidden" name="patient_id" value="<?php echo $patient_id; ?>">
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Service Type <span class="text-danger">*</span></label>
                                    <select name="charge_type" class="form-control" required onchange="updateChargeAmount(this.value)">
                                        <option value="">Select Service Type</option>
                                        ${getServiceTypeOptions()}
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Amount (KES) <span class="text-danger">*</span></label>
                                    <input type="number" name="amount" class="form-control" step="0.01" min="0" required>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label>Description</label>
                            <input type="text" name="description" class="form-control" 
                                   placeholder="Brief description of the service">
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Service Date</label>
                                    <input type="date" name="service_date" class="form-control" 
                                           value="${new Date().toISOString().split('T')[0]}">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Doctor/Provider</label>
                                    <select name="provider_id" class="form-control">
                                        <option value="">Select Provider</option>
                                        <option value="1">Dr. Smith</option>
                                        <option value="2">Dr. Johnson</option>
                                        <option value="3">Lab Technician</option>
                                        <option value="4">Radiologist</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label>Notes</label>
                            <textarea name="notes" class="form-control" rows="3" 
                                      placeholder="Additional notes about this charge..."></textarea>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="checkbox">
                                    <label>
                                        <input type="checkbox" name="is_urgent">
                                        Mark as urgent
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="checkbox">
                                    <label>
                                        <input type="checkbox" name="auto_bill" checked>
                                        Add to next invoice automatically
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">
                            <i class="fa fa-times"></i> Cancel
                        </button>
                        <button type="submit" class="btn btn-success">
                            <i class="fa fa-plus"></i> Add Charge
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    `;
    
    // Remove existing modal if any
    $('#addChargeModal').remove();
    
    // Add modal to body
    $('body').append(modalHtml);
    
    // Show modal
    $('#addChargeModal').modal('show');
    
    // Handle form submission
    $('#addChargeForm').on('submit', function(e) {
        e.preventDefault();
        processAddCharge();
    });
}

function getServiceTypeOptions() {
    var patientType = getPatientType();
    var options = '';
    
    if (patientType === 'general') {
        options = `
            <option value="consultation">General Consultation - KES 900</option>
            <option value="laboratory">Laboratory Tests - Variable</option>
            <option value="radiology">Radiology Services - Variable</option>
            <option value="pharmacy">Pharmacy - Variable</option>
            <option value="procedure">Minor Procedure - Variable</option>
            <option value="follow_up">Follow-up Visit - KES 500</option>
        `;
    } else if (patientType === 'specialized') {
        options = `
            <option value="specialized_consultation">Specialized Consultation - KES 1,500</option>
            <option value="dental">Dental Procedure - Variable</option>
            <option value="optical">Optical Service - Variable</option>
            <option value="laboratory">Laboratory Tests - Variable</option>
            <option value="radiology">Radiology Services - Variable</option>
            <option value="surgery">Surgical Procedure - Variable</option>
        `;
    } else {
        options = `
            <option value="consultation">Consultation - Variable</option>
            <option value="laboratory">Laboratory Tests - Variable</option>
            <option value="radiology">Radiology Services - Variable</option>
            <option value="pharmacy">Pharmacy - Variable</option>
            <option value="procedure">Medical Procedure - Variable</option>
        `;
    }
    
    return options;
}

function updateChargeAmount(chargeType) {
    var amountField = $('input[name="amount"]');
    var patientType = getPatientType();
    
    // Set default amounts based on service type
    var defaultAmounts = {
        'consultation': patientType === 'specialized' ? 1500 : 900,
        'specialized_consultation': 1500,
        'follow_up': 500,
        'laboratory': 0,
        'radiology': 0,
        'pharmacy': 0,
        'procedure': 0,
        'dental': 0,
        'optical': 0,
        'surgery': 0
    };
    
    if (defaultAmounts[chargeType] !== undefined) {
        amountField.val(defaultAmounts[chargeType]);
    }
}

function processAddCharge() {
    var formData = $('#addChargeForm').serialize();
    
    $.ajax({
        url: base_url + 'admin/bill/add_charge',
        type: 'POST',
        data: formData,
        dataType: 'json',
        beforeSend: function() {
            $('#addChargeModal .btn-success').prop('disabled', true)
                .html('<i class="fa fa-spinner fa-spin"></i> Adding...');
        },
        success: function(response) {
            if (response.status === 'success') {
                $('#addChargeModal').modal('hide');
                toastr.success('Charge added successfully!');
                location.reload();
            } else {
                toastr.error(response.message || 'Failed to add charge');
            }
        },
        error: function() {
            toastr.error('An error occurred while adding the charge');
        },
        complete: function() {
            $('#addChargeModal .btn-success').prop('disabled', false)
                .html('<i class="fa fa-plus"></i> Add Charge');
        }
    });
}

function addLabCharge() {
    showQuickChargeModal('laboratory', 'Laboratory Test', 0);
}

function addRadiologyCharge() {
    showQuickChargeModal('radiology', 'Radiology Service', 0);
}

function addPharmacyCharge() {
    showQuickChargeModal('pharmacy', 'Pharmacy', 0);
}

function showQuickChargeModal(chargeType, serviceName, defaultAmount) {
    var modalHtml = `
    <div class="modal fade" id="quickChargeModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-sm" role="document">
            <div class="modal-content">
                <div class="modal-header" style="background: #17a2b8; color: white;">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">
                        <i class="fa fa-plus-circle"></i> Add ${serviceName}
                    </h4>
                </div>
                <form id="quickChargeForm">
                    <div class="modal-body">
                        <input type="hidden" name="patient_id" value="<?php echo $patient_id; ?>">
                        <input type="hidden" name="charge_type" value="${chargeType}">
                        
                        <div class="form-group">
                            <label>Service Description <span class="text-danger">*</span></label>
                            <input type="text" name="description" class="form-control" 
                                   placeholder="Enter ${serviceName.toLowerCase()} description" required>
                        </div>
                        
                        <div class="form-group">
                            <label>Amount (KES) <span class="text-danger">*</span></label>
                            <input type="number" name="amount" class="form-control" 
                                   step="0.01" min="0" value="${defaultAmount}" required>
                        </div>
                        
                        <div class="form-group">
                            <label>Service Date</label>
                            <input type="date" name="service_date" class="form-control" 
                                   value="${new Date().toISOString().split('T')[0]}">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default btn-sm" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary btn-sm">
                            <i class="fa fa-plus"></i> Add ${serviceName}
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    `;
    
    // Remove existing modal if any
    $('#quickChargeModal').remove();
    
    // Add modal to body
    $('body').append(modalHtml);
    
    // Show modal
    $('#quickChargeModal').modal('show');
    
    // Handle form submission
    $('#quickChargeForm').on('submit', function(e) {
        e.preventDefault();
        processQuickCharge();
    });
}

function processQuickCharge() {
    var formData = $('#quickChargeForm').serialize();
    
    $.ajax({
        url: base_url + 'admin/bill/add_charge',
        type: 'POST',
        data: formData,
        dataType: 'json',
        beforeSend: function() {
            $('#quickChargeModal .btn-primary').prop('disabled', true)
                .html('<i class="fa fa-spinner fa-spin"></i> Adding...');
        },
        success: function(response) {
            if (response.status === 'success') {
                $('#quickChargeModal').modal('hide');
                toastr.success('Charge added successfully!');
                location.reload();
            } else {
                toastr.error(response.message || 'Failed to add charge');
            }
        },
        error: function() {
            toastr.error('An error occurred while adding the charge');
        },
        complete: function() {
            $('#quickChargeModal .btn-primary').prop('disabled', false)
                .html('<i class="fa fa-plus"></i> Add Charge');
        }
    });
}

function addConsultationCharge() {
    var amount = <?php echo $patient_type == 'specialized' ? 1500 : 900; ?>;
    addSpecificCharge('consultation', amount);
}

function addLabCharge() {
    toastr.info('Lab charge addition will be implemented');
}

function addRadiologyCharge() {
    toastr.info('Radiology charge addition will be implemented');
}

function addPharmacyCharge() {
    toastr.info('Pharmacy charge addition will be implemented');
}

function addSpecificCharge(type, amount) {
    $.ajax({
        url: base_url + 'admin/bill/add_charge',
        type: 'POST',
        data: { 
            patient_id: <?php echo $patient_id; ?>,
            charge_type: type,
            amount: amount
        },
        dataType: 'json',
        success: function(response) {
            if (response.status === 'success') {
                toastr.success('Charge added successfully');
                location.reload();
            } else {
                toastr.error(response.message || 'Failed to add charge');
            }
        }
    });
}

function printReceipt(paymentId) {
    window.open(base_url + 'admin/bill/print_receipt/' + paymentId, '_blank');
}

function printSummary() {
    // Create a beautiful print-friendly version of the billing summary
    var printWindow = window.open('', '_blank', 'width=800,height=600');
    
    var printContent = `
    <!DOCTYPE html>
    <html>
    <head>
        <title>Patient Billing Summary - ${$('#patient_name').text() || 'Patient'}</title>
        <style>
            @page { 
                size: A4; 
                margin: 15mm; 
            }
            
            * {
                box-sizing: border-box;
                margin: 0;
                padding: 0;
            }
            
            body {
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                font-size: 12px;
                line-height: 1.5;
                color: #333;
                background: white;
            }
            
            .print-header {
                text-align: center;
                border-bottom: 3px solid #00a65a;
                padding-bottom: 20px;
                margin-bottom: 30px;
            }
            
            .clinic-name {
                font-size: 24px;
                font-weight: bold;
                color: #00a65a;
                margin-bottom: 10px;
            }
            
            .summary-title {
                font-size: 20px;
                color: #333;
                margin-top: 15px;
            }
            
            .patient-info {
                background: #f8f9fa;
                padding: 20px;
                border-radius: 8px;
                margin-bottom: 25px;
                border-left: 4px solid #00a65a;
            }
            
            .patient-info h3 {
                color: #00a65a;
                margin-bottom: 15px;
                font-size: 18px;
            }
            
            .info-grid {
                display: grid;
                grid-template-columns: 1fr 1fr 1fr;
                gap: 20px;
                margin-bottom: 15px;
            }
            
            .info-item {
                display: flex;
                flex-direction: column;
                gap: 5px;
            }
            
            .info-label {
                font-weight: bold;
                color: #555;
                font-size: 11px;
                text-transform: uppercase;
            }
            
            .info-value {
                color: #333;
                font-size: 13px;
            }
            
            .patient-type-badge {
                display: inline-block;
                padding: 6px 12px;
                border-radius: 15px;
                font-size: 11px;
                font-weight: bold;
                color: white;
                text-transform: uppercase;
            }
            
            .type-gcc { background: #17a2b8; }
            .type-general { background: #28a745; }
            .type-specialized { background: #dc3545; }
            
            .billing-overview {
                display: grid;
                grid-template-columns: repeat(4, 1fr);
                gap: 15px;
                margin-bottom: 30px;
            }
            
            .billing-card {
                background: #f8f9fa;
                border: 1px solid #e9ecef;
                border-radius: 8px;
                padding: 20px;
                text-align: center;
                border-top: 4px solid #00a65a;
            }
            
            .billing-amount {
                font-size: 20px;
                font-weight: bold;
                margin-bottom: 8px;
            }
            
            .billing-label {
                color: #666;
                font-size: 11px;
                text-transform: uppercase;
                letter-spacing: 1px;
            }
            
            .amount-total { color: #333; }
            .amount-paid { color: #28a745; }
            .amount-due { color: #dc3545; }
            .amount-progress { color: #00a65a; }
            
            .services-section {
                margin-bottom: 30px;
            }
            
            .section-title {
                font-size: 16px;
                font-weight: bold;
                color: #00a65a;
                margin-bottom: 15px;
                padding-bottom: 8px;
                border-bottom: 2px solid #e9ecef;
            }
            
            .service-item {
                background: white;
                border: 1px solid #e9ecef;
                border-radius: 6px;
                margin-bottom: 15px;
                padding: 15px;
            }
            
            .service-header {
                display: flex;
                justify-content: space-between;
                align-items: center;
                margin-bottom: 10px;
                padding-bottom: 10px;
                border-bottom: 1px solid #f0f0f0;
            }
            
            .service-name {
                font-weight: bold;
                color: #333;
                font-size: 14px;
            }
            
            .service-amount {
                font-weight: bold;
                color: #00a65a;
                font-size: 14px;
            }
            
            .charge-details {
                display: grid;
                grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
                gap: 10px;
                margin-top: 10px;
            }
            
            .charge-detail {
                display: flex;
                justify-content: space-between;
                padding: 8px 0;
                border-bottom: 1px dotted #ddd;
                font-size: 11px;
            }
            
            .charge-detail:last-child {
                border-bottom: none;
            }
            
            .payment-history {
                margin-top: 30px;
            }
            
            .payment-item {
                display: flex;
                justify-content: space-between;
                align-items: center;
                padding: 10px 15px;
                background: #f8f9fa;
                border-left: 4px solid #28a745;
                margin-bottom: 8px;
                border-radius: 4px;
            }
            
            .payment-details {
                display: flex;
                flex-direction: column;
            }
            
            .payment-amount {
                font-weight: bold;
                color: #28a745;
            }
            
            .payment-method {
                font-size: 11px;
                color: #666;
            }
            
            .payment-date {
                font-size: 11px;
                color: #666;
            }
            
            .footer {
                margin-top: 40px;
                padding-top: 20px;
                border-top: 2px solid #e9ecef;
                text-align: center;
                color: #666;
                font-size: 11px;
            }
            
            .no-print {
                position: fixed;
                top: 20px;
                right: 20px;
                z-index: 1000;
            }
            
            @media print {
                .no-print {
                    display: none !important;
                }
                
                body {
                    -webkit-print-color-adjust: exact;
                    print-color-adjust: exact;
                }
            }
        </style>
    </head>
    <body>
        <div class="no-print">
            <button onclick="window.print()" style="background: #00a65a; color: white; border: none; padding: 10px 20px; border-radius: 4px; cursor: pointer; margin-right: 10px;">
                Print Summary
            </button>
            <button onclick="window.close()" style="background: #6c757d; color: white; border: none; padding: 10px 20px; border-radius: 4px; cursor: pointer;">
                Close
            </button>
        </div>
        
        <div class="print-header">
            <div class="clinic-name">City Health Clinic</div>
            <div style="color: #666; font-size: 12px; margin-bottom: 5px;">
                Excellence in Healthcare Services<br>
                Nairobi, Kenya | Tel: +254 700 000 000
            </div>
            <div class="summary-title">Patient Billing Summary</div>
        </div>
        
        <div class="patient-info">
            <h3>Patient Information</h3>
            <div class="info-grid">
                <div class="info-item">
                    <span class="info-label">Patient Name</span>
                    <span class="info-value">${getPatientName()}</span>
                </div>
                <div class="info-item">
                    <span class="info-label">Patient ID</span>
                    <span class="info-value">${getPatientId()}</span>
                </div>
                <div class="info-item">
                    <span class="info-label">Phone Number</span>
                    <span class="info-value">${getPatientPhone()}</span>
                </div>
                <div class="info-item">
                    <span class="info-label">Email Address</span>
                    <span class="info-value">${getPatientEmail()}</span>
                </div>
                <div class="info-item">
                    <span class="info-label">Age & Gender</span>
                    <span class="info-value">${getPatientAge()} | ${getPatientGender()}</span>
                </div>
                <div class="info-item">
                    <span class="info-label">Patient Type</span>
                    <span class="info-value">
                        <span class="patient-type-badge type-${getPatientType()}">
                            ${getPatientTypeLabel()}
                        </span>
                    </span>
                </div>
            </div>
        </div>
        
        <div class="billing-overview">
            <div class="billing-card">
                <div class="billing-amount amount-total">${getTotalAmount()}</div>
                <div class="billing-label">Total Amount</div>
            </div>
            <div class="billing-card">
                <div class="billing-amount amount-paid">${getPaidAmount()}</div>
                <div class="billing-label">Amount Paid</div>
            </div>
            <div class="billing-card">
                <div class="billing-amount amount-due">${getDueAmount()}</div>
                <div class="billing-label">Amount Due</div>
            </div>
            <div class="billing-card">
                <div class="billing-amount amount-progress">${getPaymentProgress()}%</div>
                <div class="billing-label">Payment Progress</div>
            </div>
        </div>
        
        <div class="services-section">
            <div class="section-title">Service Breakdown</div>
            ${generateServicesContent()}
        </div>
        
        <div class="payment-history">
            <div class="section-title">Payment History</div>
            ${generatePaymentHistory()}
        </div>
        
        <div class="footer">
            <p><strong>Summary generated on:</strong> ${new Date().toLocaleDateString()} at ${new Date().toLocaleTimeString()}</p>
            <p>This is a computer-generated summary and does not require a signature.</p>
            <p style="margin-top: 10px; font-style: italic; color: #00a65a;">
                "Your Health, Our Priority"
            </p>
        </div>
    </body>
    </html>
    `;
    
    printWindow.document.write(printContent);
    printWindow.document.close();
    
    // Auto-print after content loads
    printWindow.onload = function() {
        setTimeout(function() {
            printWindow.print();
        }, 500);
    };
}

// Helper functions to extract data from the current page
function getPatientName() {
    return $('.patient-header h3').text().replace('👤', '').trim() || 'N/A';
}

function getPatientId() {
    return $('p:contains("Patient ID:")').text().replace('Patient ID:', '').trim() || 'N/A';
}

function getPatientPhone() {
    return $('p:contains("Phone:")').text().replace('Phone:', '').trim() || 'N/A';
}

function getPatientEmail() {
    return $('p:contains("Email:")').text().replace('Email:', '').trim() || 'N/A';
}

function getPatientAge() {
    return $('p:contains("Age:")').text().replace('Age:', '').replace('years', '').trim() || 'N/A';
}

function getPatientGender() {
    return $('p:contains("Gender:")').text().replace('Gender:', '').trim() || 'N/A';
}

function getPatientType() {
    var badge = $('.patient-type-badge');
    if (badge.hasClass('type-gcc')) return 'gcc';
    if (badge.hasClass('type-general')) return 'general';
    if (badge.hasClass('type-specialized')) return 'specialized';
    return 'general';
}

function getPatientTypeLabel() {
    var type = getPatientType();
    var labels = {
        'gcc': 'GCC Patient',
        'general': 'General Patient',
        'specialized': 'Specialized Patient'
    };
    return labels[type] || 'General Patient';
}

function getTotalAmount() {
    return $('.amount-total').first().text() || 'KES 0.00';
}

function getPaidAmount() {
    return $('.amount-paid').first().text() || 'KES 0.00';
}

function getDueAmount() {
    return $('.amount-due').first().text() || 'KES 0.00';
}

function getPaymentProgress() {
    return $('.billing-status-card').last().find('.amount-display').text().replace('%', '') || '0';
}

function generateServicesContent() {
    var servicesHtml = '';
    
    $('.service-card').each(function() {
        var serviceName = $(this).find('.service-header strong').text();
        var serviceTotal = $(this).find('.label-primary').text();
        
        servicesHtml += `
        <div class="service-item">
            <div class="service-header">
                <span class="service-name">${serviceName}</span>
                <span class="service-amount">${serviceTotal}</span>
            </div>
            <div class="charge-details">
        `;
        
        $(this).find('.charge-item').each(function() {
            var chargeName = $(this).find('strong').text();
            var chargeAmount = $(this).find('.amount-display').text();
            var paymentStatus = $(this).find('.text-success, .text-danger').text();
            
            servicesHtml += `
            <div class="charge-detail">
                <span>${chargeName}</span>
                <span>${chargeAmount}</span>
            </div>
            `;
            
            if (paymentStatus) {
                servicesHtml += `
                <div class="charge-detail">
                    <span>Payment Status</span>
                    <span>${paymentStatus}</span>
                </div>
                `;
            }
        });
        
        servicesHtml += `
            </div>
        </div>
        `;
    });
    
    if (!servicesHtml) {
        servicesHtml = `
        <div class="service-item">
            <div style="text-align: center; color: #666; padding: 20px;">
                <p>No service charges recorded yet.</p>
                <p>Expected charges will appear here once services are added.</p>
            </div>
        </div>
        `;
    }
    
    return servicesHtml;
}

function generatePaymentHistory() {
    var paymentsHtml = '';
    
    $('.payment-item').each(function() {
        var amount = $(this).find('strong').first().text();
        var method = $(this).find('small').first().text();
        var date = $(this).find('small').last().text();
        
        paymentsHtml += `
        <div class="payment-item">
            <div class="payment-details">
                <span class="payment-amount">${amount}</span>
                <span class="payment-method">${method}</span>
            </div>
            <span class="payment-date">${date}</span>
        </div>
        `;
    });
    
    if (!paymentsHtml) {
        paymentsHtml = `
        <div style="text-align: center; color: #666; padding: 20px; background: #f8f9fa; border-radius: 6px;">
            <p>No payments recorded yet.</p>
            <p>Payment history will appear here once payments are made.</p>
        </div>
        `;
    }
    
    return paymentsHtml;
}

function sendStatement() {
    // Show email statement modal
    showEmailStatementModal();
}

function showEmailStatementModal() {
    var modalHtml = `
    <div class="modal fade" id="emailStatementModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header" style="background: linear-gradient(45deg, #17a2b8, #00c0ef); color: white;">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">
                        <i class="fa fa-envelope"></i> Send Patient Statement
                    </h4>
                </div>
                <form id="emailStatementForm">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Patient Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" value="${getPatientName()}" readonly>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Patient ID <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" value="${getPatientId()}" readonly>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-8">
                                <div class="form-group">
                                    <label>Email Address <span class="text-danger">*</span></label>
                                    <input type="email" name="email" class="form-control" 
                                           value="${getPatientEmail()}" required
                                           placeholder="Enter patient's email address">
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>Statement Type</label>
                                    <select name="statement_type" class="form-control">
                                        <option value="detailed">Detailed Statement</option>
                                        <option value="summary">Summary Statement</option>
                                        <option value="payment_history">Payment History Only</option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label>Subject Line</label>
                            <input type="text" name="subject" class="form-control" 
                                   value="Your Medical Statement from City Health Clinic"
                                   placeholder="Email subject">
                        </div>
                        
                        <div class="form-group">
                            <label>Message</label>
                            <textarea name="message" class="form-control" rows="6" 
                                      placeholder="Enter your message to the patient...">Dear ${getPatientName()},

Please find attached your medical statement from City Health Clinic.

Statement Summary:
• Total Amount: ${getTotalAmount()}
• Amount Paid: ${getPaidAmount()}
• Outstanding Balance: ${getDueAmount()}

If you have any questions regarding this statement or need to discuss payment options, please don't hesitate to contact our billing department.

We appreciate your trust in our healthcare services.

Best regards,
City Health Clinic
Billing Department

Phone: +254 700 000 000
Email: billing@cityhealth.co.ke</textarea>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="checkbox">
                                        <label>
                                            <input type="checkbox" name="include_payment_instructions" checked>
                                            Include payment instructions
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="checkbox">
                                        <label>
                                            <input type="checkbox" name="request_confirmation" checked>
                                            Request read confirmation
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i>
                            <strong>Note:</strong> The statement will be automatically generated as a PDF attachment 
                            and sent to the specified email address. A copy will be saved in the patient's records.
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">
                            <i class="fa fa-times"></i> Cancel
                        </button>
                        <button type="button" class="btn btn-warning" onclick="previewStatement()">
                            <i class="fa fa-eye"></i> Preview Statement
                        </button>
                        <button type="submit" class="btn btn-info">
                            <i class="fa fa-send"></i> Send Statement
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    `;
    
    // Remove existing modal if any
    $('#emailStatementModal').remove();
    
    // Add modal to body
    $('body').append(modalHtml);
    
    // Show modal
    $('#emailStatementModal').modal('show');
    
    // Handle form submission
    $('#emailStatementForm').on('submit', function(e) {
        e.preventDefault();
        processStatementEmail();
    });
}

function previewStatement() {
    // Generate a preview of the statement
    var previewWindow = window.open('', '_blank', 'width=800,height=600');
    
    var previewContent = `
    <!DOCTYPE html>
    <html>
    <head>
        <title>Statement Preview - ${getPatientName()}</title>
        <style>
            body { 
                font-family: Arial, sans-serif; 
                margin: 20px; 
                line-height: 1.6; 
            }
            .header { 
                text-align: center; 
                border-bottom: 2px solid #00a65a; 
                padding-bottom: 20px; 
                margin-bottom: 30px; 
            }
            .clinic-name { 
                font-size: 24px; 
                font-weight: bold; 
                color: #00a65a; 
                margin-bottom: 10px; 
            }
            .statement-info { 
                background: #f8f9fa; 
                padding: 20px; 
                border-radius: 8px; 
                margin-bottom: 25px; 
            }
            .billing-summary { 
                border: 1px solid #ddd; 
                border-radius: 8px; 
                overflow: hidden; 
                margin-bottom: 25px; 
            }
            .summary-header { 
                background: #00a65a; 
                color: white; 
                padding: 15px; 
                font-weight: bold; 
            }
            .summary-body { 
                padding: 20px; 
            }
            .summary-row { 
                display: flex; 
                justify-content: space-between; 
                padding: 10px 0; 
                border-bottom: 1px solid #eee; 
            }
            .summary-row:last-child { 
                border-bottom: none; 
                font-weight: bold; 
                font-size: 16px; 
            }
            .amount-due { 
                color: #dc3545; 
            }
            .amount-paid { 
                color: #28a745; 
            }
        </style>
    </head>
    <body>
        <div class="header">
            <div class="clinic-name">City Health Clinic</div>
            <div>Medical Statement</div>
        </div>
        
        <div class="statement-info">
            <h3>Patient Information</h3>
            <p><strong>Name:</strong> ${getPatientName()}</p>
            <p><strong>Patient ID:</strong> ${getPatientId()}</p>
            <p><strong>Statement Date:</strong> ${new Date().toLocaleDateString()}</p>
            <p><strong>Patient Type:</strong> ${getPatientTypeLabel()}</p>
        </div>
        
        <div class="billing-summary">
            <div class="summary-header">Billing Summary</div>
            <div class="summary-body">
                <div class="summary-row">
                    <span>Total Amount:</span>
                    <span>${getTotalAmount()}</span>
                </div>
                <div class="summary-row">
                    <span class="amount-paid">Amount Paid:</span>
                    <span class="amount-paid">${getPaidAmount()}</span>
                </div>
                <div class="summary-row">
                    <span class="amount-due">Outstanding Balance:</span>
                    <span class="amount-due">${getDueAmount()}</span>
                </div>
            </div>
        </div>
        
        <div style="text-align: center; margin-top: 30px;">
            <button onclick="window.close()" style="background: #6c757d; color: white; border: none; padding: 10px 20px; border-radius: 4px; cursor: pointer;">
                Close Preview
            </button>
        </div>
    </body>
    </html>
    `;
    
    previewWindow.document.write(previewContent);
    previewWindow.document.close();
}

function processStatementEmail() {
    var formData = $('#emailStatementForm').serialize();
    
    // Add patient information
    var patientData = {
        patient_id: '<?php echo $patient_id; ?>',
        patient_name: getPatientName(),
        patient_unique_id: getPatientId(),
        total_amount: getTotalAmount(),
        paid_amount: getPaidAmount(),
        due_amount: getDueAmount(),
        patient_type: getPatientType()
    };
    
    $.ajax({
        url: base_url + 'admin/bill/send_statement',
        type: 'POST',
        data: formData + '&' + $.param(patientData),
        dataType: 'json',
        beforeSend: function() {
            $('#emailStatementModal .btn-info').prop('disabled', true)
                .html('<i class="fa fa-spinner fa-spin"></i> Sending...');
        },
        success: function(response) {
            if (response.status === 'success') {
                $('#emailStatementModal').modal('hide');
                toastr.success('Statement sent successfully to ' + $('input[name="email"]').val());
                
                // Log the activity
                logStatementActivity('email_sent', $('input[name="email"]').val());
            } else {
                toastr.error(response.message || 'Failed to send statement');
            }
        },
        error: function() {
            toastr.error('An error occurred while sending the statement');
        },
        complete: function() {
            $('#emailStatementModal .btn-info').prop('disabled', false)
                .html('<i class="fa fa-send"></i> Send Statement');
        }
    });
}

function logStatementActivity(action, email) {
    // Log the statement activity for audit trail
    $.ajax({
        url: base_url + 'admin/bill/log_statement_activity',
        type: 'POST',
        data: {
            patient_id: '<?php echo $patient_id; ?>',
            action: action,
            email: email,
            timestamp: new Date().toISOString()
        },
        success: function(response) {
            console.log('Statement activity logged');
        }
    });
}
</script>