<?php
// File: application/views/admin/bill/print_invoice.php
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Invoice #<?php echo $invoice['invoice_number']; ?> - <?php echo $organization['name'] ?? 'City Health Clinic'; ?></title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <style>
        @page {
            size: A4;
            margin: 15mm;
        }
        
        * {
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            font-size: 12px;
            line-height: 1.4;
            color: #333;
            margin: 0;
            padding: 0;
            background: white;
        }
        
        .invoice-container {
            max-width: 800px;
            margin: 0 auto;
            background: white;
            padding: 20px;
        }
        
        .invoice-header {
            border-bottom: 3px solid #00a65a;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        
        .clinic-info {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 20px;
        }
        
        .clinic-logo {
            max-width: 120px;
            height: auto;
        }
        
        .clinic-details {
            flex: 1;
            margin-left: 20px;
        }
        
        .clinic-name {
            font-size: 24px;
            font-weight: bold;
            color: #00a65a;
            margin-bottom: 5px;
        }
        
        .clinic-address {
            color: #666;
            line-height: 1.6;
        }
        
        .invoice-title {
            text-align: right;
            color: #00a65a;
        }
        
        .invoice-title h1 {
            font-size: 32px;
            margin: 0;
            font-weight: bold;
        }
        
        .invoice-title .print-type {
            font-size: 14px;
            color: #666;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .invoice-meta {
            display: flex;
            justify-content: space-between;
            margin-bottom: 30px;
        }
        
        .invoice-details,
        .patient-details {
            width: 48%;
        }
        
        .detail-section h3 {
            font-size: 16px;
            font-weight: bold;
            color: #00a65a;
            margin-bottom: 10px;
            padding-bottom: 5px;
            border-bottom: 1px solid #eee;
        }
        
        .detail-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 5px;
        }
        
        .detail-label {
            font-weight: 600;
            color: #555;
        }
        
        .detail-value {
            color: #333;
        }
        
        .patient-type-badge {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 15px;
            font-size: 11px;
            font-weight: bold;
            color: white;
            text-transform: uppercase;
        }
        
        .type-gcc { background: #17a2b8; }
        .type-general { background: #28a745; }
        .type-specialized { background: #dc3545; }
        
        .invoice-items {
            margin: 30px 0;
        }
        
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            border: 1px solid #ddd;
        }
        
        .items-table th {
            background: #f8f9fa;
            padding: 12px 8px;
            text-align: left;
            font-weight: bold;
            border-bottom: 2px solid #00a65a;
            color: #333;
        }
        
        .items-table td {
            padding: 10px 8px;
            border-bottom: 1px solid #eee;
            vertical-align: top;
        }
        
        .items-table tr:nth-child(even) {
            background: #f9f9f9;
        }
        
        .text-right {
            text-align: right !important;
        }
        
        .text-center {
            text-align: center !important;
        }
        
        .service-description {
            color: #666;
            font-size: 11px;
            margin-top: 2px;
        }
        
        .amount-column {
            font-weight: 600;
            color: #333;
        }
        
        .invoice-totals {
            margin-top: 30px;
            display: flex;
            justify-content: flex-end;
        }
        
        .totals-table {
            width: 300px;
            border-collapse: collapse;
        }
        
        .totals-table td {
            padding: 8px 12px;
            border-bottom: 1px solid #eee;
        }
        
        .totals-table .total-label {
            font-weight: 600;
            color: #555;
            text-align: right;
        }
        
        .totals-table .total-amount {
            font-weight: bold;
            text-align: right;
            color: #333;
        }
        
        .grand-total {
            background: #f8f9fa;
            border-top: 2px solid #00a65a !important;
            font-size: 16px;
        }
        
        .grand-total td {
            font-weight: bold;
            color: #00a65a;
        }
        
        .payment-summary {
            margin: 30px 0;
            background: #f8f9fa;
            padding: 20px;
            border-radius: 6px;
            border-left: 4px solid #28a745;
        }
        
        .payment-summary h3 {
            margin-top: 0;
            color: #28a745;
        }
        
        .payment-item {
            display: flex;
            justify-content: space-between;
            padding: 5px 0;
            border-bottom: 1px solid #dee2e6;
        }
        
        .payment-item:last-child {
            border-bottom: none;
            font-weight: bold;
            margin-top: 10px;
            padding-top: 10px;
            border-top: 1px solid #28a745;
        }
        
        .balance-due {
            background: #fff3cd;
            border-left-color: #ffc107 !important;
        }
        
        .balance-due h3 {
            color: #856404;
        }
        
        .invoice-notes {
            margin: 30px 0;
            background: #e7f3ff;
            padding: 15px;
            border-radius: 6px;
            border-left: 4px solid #007bff;
        }
        
        .invoice-notes h4 {
            margin-top: 0;
            color: #0056b3;
        }
        
        .invoice-footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            text-align: center;
            color: #666;
            font-size: 11px;
        }
        
        .footer-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 10px;
        }
        
        .qr-code {
            width: 80px;
            height: 80px;
            border: 1px solid #ddd;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 10px;
            color: #999;
        }
        
        .watermark {
            position: fixed;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-size: 72px;
            color: rgba(0, 166, 90, 0.1);
            font-weight: bold;
            z-index: -1;
            pointer-events: none;
        }
        
        @media print {
            body {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            .invoice-container {
                box-shadow: none;
                border: none;
            }
            
            .no-print {
                display: none !important;
            }
            
            @page {
                margin: 15mm;
            }
        }
    </style>
</head>
<body>
    <?php if ($print_type == 'copy'): ?>
        <div class="watermark">COPY</div>
    <?php elseif ($print_type == 'receipt'): ?>
        <div class="watermark">RECEIPT</div>
    <?php endif; ?>

    <div class="invoice-container">
        <!-- Invoice Header -->
        <div class="invoice-header">
            <div class="clinic-info">
                <div>
                    <?php if (!empty($organization['logo'])): ?>
                        <img src="<?php echo base_url('uploads/hospital_content/logo/' . $organization['logo']); ?>" 
                             alt="<?php echo $organization['name']; ?>" class="clinic-logo">
                    <?php endif; ?>
                </div>
                <div class="clinic-details">
                    <div class="clinic-name"><?php echo $organization['name'] ?? 'City Health Clinic'; ?></div>
                    <div class="clinic-address">
                        <?php if (!empty($organization['address'])): ?>
                            <?php echo $organization['address']; ?><br>
                        <?php endif; ?>
                        <?php if (!empty($organization['phone'])): ?>
                            Phone: <?php echo $organization['phone']; ?><br>
                        <?php endif; ?>
                        <?php if (!empty($organization['email'])): ?>
                            Email: <?php echo $organization['email']; ?><br>
                        <?php endif; ?>
                        <?php if (!empty($organization['website'])): ?>
                            Website: <?php echo $organization['website']; ?>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="invoice-title">
                    <h1>INVOICE</h1>
                    <div class="print-type"><?php echo strtoupper($print_type ?? 'original'); ?></div>
                </div>
            </div>
        </div>

        <!-- Invoice Meta Information -->
        <div class="invoice-meta">
            <div class="invoice-details detail-section">
                <h3>Invoice Details</h3>
                <div class="detail-row">
                    <span class="detail-label">Invoice Number:</span>
                    <span class="detail-value"><?php echo $invoice['invoice_number']; ?></span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Invoice Date:</span>
                    <span class="detail-value"><?php echo date('M j, Y', strtotime($invoice['invoice_date'])); ?></span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Due Date:</span>
                    <span class="detail-value"><?php echo date('M j, Y', strtotime($invoice['due_date'])); ?></span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Invoice Type:</span>
                    <span class="detail-value"><?php echo ucfirst($invoice['invoice_type'] ?? 'standard'); ?></span>
                </div>
                <?php if (!empty($invoice['case_id'])): ?>
                <div class="detail-row">
                    <span class="detail-label">Case ID:</span>
                    <span class="detail-value"><?php echo $invoice['case_id']; ?></span>
                </div>
                <?php endif; ?>
            </div>

            <div class="patient-details detail-section">
                <h3>Patient Information</h3>
                <div class="detail-row">
                    <span class="detail-label">Name:</span>
                    <span class="detail-value"><?php echo $invoice['patient_name']; ?></span>
                </div>
                <div class="detail-row">
                    <span class="detail-label">Patient ID:</span>
                    <span class="detail-value"><?php echo $invoice['patient_unique_id']; ?></span>
                </div>
                <?php if (!empty($invoice['patient_phone'])): ?>
                <div class="detail-row">
                    <span class="detail-label">Phone:</span>
                    <span class="detail-value"><?php echo $invoice['patient_phone']; ?></span>
                </div>
                <?php endif; ?>
                <?php if (!empty($invoice['patient_email'])): ?>
                <div class="detail-row">
                    <span class="detail-label">Email:</span>
                    <span class="detail-value"><?php echo $invoice['patient_email']; ?></span>
                </div>
                <?php endif; ?>
                <div class="detail-row">
                    <span class="detail-label">Patient Type:</span>
                    <span class="detail-value">
                        <span class="patient-type-badge type-<?php echo $invoice['patient_type'] ?? 'general'; ?>">
                            <?php 
                            $type_labels = array('gcc' => 'GCC Patient', 'general' => 'General Patient', 'specialized' => 'Specialized Patient');
                            echo $type_labels[$invoice['patient_type'] ?? 'general'];
                            ?>
                        </span>
                    </span>
                </div>
            </div>
        </div>

        <!-- Invoice Items -->
        <div class="invoice-items">
            <h3 style="color: #00a65a; margin-bottom: 15px;">Services & Charges</h3>
            <table class="items-table">
                <thead>
                    <tr>
                        <th style="width: 50%;">Description</th>
                        <th style="width: 15%;" class="text-center">Quantity</th>
                        <th style="width: 17.5%;" class="text-right">Unit Price</th>
                        <th style="width: 17.5%;" class="text-right">Total</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($invoice['line_items'])): ?>
                        <?php foreach ($invoice['line_items'] as $item): ?>
                        <tr>
                            <td>
                                <strong><?php echo $item['description']; ?></strong>
                                <?php if (!empty($item['module_type'])): ?>
                                    <div class="service-description">
                                        Module: <?php echo ucfirst(str_replace('_', ' ', $item['module_type'])); ?>
                                        <?php if (!empty($item['module_id'])): ?>
                                            | Reference: <?php echo $item['module_id']; ?>
                                        <?php endif; ?>
                                    </div>
                                <?php endif; ?>
                            </td>
                            <td class="text-center"><?php echo $item['quantity'] ?? 1; ?></td>
                            <td class="text-right amount-column">KES <?php echo number_format($item['unit_price'], 2); ?></td>
                            <td class="text-right amount-column">KES <?php echo number_format($item['total_price'], 2); ?></td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <!-- Default single service item -->
                        <tr>
                            <td>
                                <strong>
                                    <?php 
                                    if (($invoice['patient_type'] ?? '') == 'gcc') {
                                        echo 'GCC Medical Examination Package';
                                    } elseif (($invoice['patient_type'] ?? '') == 'specialized') {
                                        echo 'Specialized Medical Services';
                                    } else {
                                        echo 'General Medical Services';
                                    }
                                    ?>
                                </strong>
                                <div class="service-description">
                                    Comprehensive medical services as per patient type and requirements
                                </div>
                            </td>
                            <td class="text-center">1</td>
                            <td class="text-right amount-column">KES <?php echo number_format($invoice['subtotal'], 2); ?></td>
                            <td class="text-right amount-column">KES <?php echo number_format($invoice['subtotal'], 2); ?></td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <!-- Invoice Totals -->
        <div class="invoice-totals">
            <table class="totals-table">
                <tr>
                    <td class="total-label">Subtotal:</td>
                    <td class="total-amount">KES <?php echo number_format($invoice['subtotal'], 2); ?></td>
                </tr>
                <?php if (!empty($invoice['discount_amount']) && $invoice['discount_amount'] > 0): ?>
                <tr>
                    <td class="total-label">Discount:</td>
                    <td class="total-amount">- KES <?php echo number_format($invoice['discount_amount'], 2); ?></td>
                </tr>
                <?php endif; ?>
                <?php if (!empty($invoice['tax_amount']) && $invoice['tax_amount'] > 0): ?>
                <tr>
                    <td class="total-label">Tax (<?php echo $invoice['tax_percentage'] ?? 16; ?>%):</td>
                    <td class="total-amount">KES <?php echo number_format($invoice['tax_amount'], 2); ?></td>
                </tr>
                <?php endif; ?>
                <tr class="grand-total">
                    <td class="total-label">Total Amount:</td>
                    <td class="total-amount">KES <?php echo number_format($invoice['total_amount'], 2); ?></td>
                </tr>
            </table>
        </div>

        <!-- Payment Summary -->
        <?php 
        $total_paid = $invoice['total_paid'] ?? 0;
        $balance_due = $invoice['total_amount'] - $total_paid;
        ?>
        
        <?php if ($total_paid > 0): ?>
        <div class="payment-summary">
            <h3><i class="fa fa-money"></i> Payment Summary</h3>
            <?php if (!empty($invoice['payments'])): ?>
                <?php foreach ($invoice['payments'] as $payment): ?>
                <div class="payment-item">
                    <span>
                        <?php echo date('M j, Y', strtotime($payment['payment_date'])); ?> - 
                        <?php echo $payment['payment_mode']; ?>
                        <?php if (!empty($payment['reference'])): ?>
                            (<?php echo $payment['reference']; ?>)
                        <?php endif; ?>
                    </span>
                    <span>KES <?php echo number_format($payment['amount'], 2); ?></span>
                </div>
                <?php endforeach; ?>
            <?php endif; ?>
            <div class="payment-item">
                <span><strong>Total Paid:</strong></span>
                <span><strong>KES <?php echo number_format($total_paid, 2); ?></strong></span>
            </div>
        </div>
        <?php endif; ?>

        <?php if ($balance_due > 0): ?>
        <div class="payment-summary balance-due">
            <h3><i class="fa fa-exclamation-triangle"></i> Outstanding Balance</h3>
            <div class="payment-item">
                <span><strong>Amount Due:</strong></span>
                <span><strong>KES <?php echo number_format($balance_due, 2); ?></strong></span>
            </div>
            <div style="margin-top: 10px; font-size: 11px; color: #856404;">
                Please settle this amount by <?php echo date('M j, Y', strtotime($invoice['due_date'])); ?>
            </div>
        </div>
        <?php endif; ?>

        <!-- Invoice Notes -->
        <?php if (!empty($invoice['notes']) || ($invoice['patient_type'] ?? '') == 'gcc'): ?>
        <div class="invoice-notes">
            <h4>Important Notes</h4>
            <?php if (($invoice['patient_type'] ?? '') == 'gcc'): ?>
                <p><strong>GCC Medical Examination:</strong> This invoice covers the complete Gulf Cooperation Council medical examination package including all required tests, consultations, and medical report preparation.</p>
            <?php endif; ?>
            <?php if (!empty($invoice['notes'])): ?>
                <p><?php echo nl2br(htmlspecialchars($invoice['notes'])); ?></p>
            <?php endif; ?>
            <p><strong>Payment Methods:</strong> We accept Cash, Credit/Debit Cards, Bank Transfers, Mobile Money, and Cheques.</p>
            <p><strong>Queries:</strong> For any billing inquiries, please contact our accounts department during business hours.</p>
        </div>
        <?php endif; ?>

        <!-- Invoice Footer -->
        <div class="invoice-footer">
            <div class="footer-row">
                <div>
                    <strong><?php echo $organization['name'] ?? 'City Health Clinic'; ?></strong><br>
                    Excellence in Healthcare Services
                </div>
                <div class="qr-code">
                    QR Code<br>
                    <small>Payment Link</small>
                </div>
            </div>
            <hr style="margin: 15px 0; border: none; border-top: 1px solid #ddd;">
            <div style="text-align: center;">
                <p>This is a computer-generated invoice and does not require a signature.</p>
                <p>Generated on <?php echo date('M j, Y \a\t g:i A'); ?> | 
                   Invoice ID: <?php echo $invoice['id'] ?? 'N/A'; ?> | 
                   Print Type: <?php echo strtoupper($print_type ?? 'original'); ?>
                </p>
                <?php if (!empty($organization['tagline'])): ?>
                    <p style="font-style: italic; color: #00a65a; margin-top: 10px;">
                        "<?php echo $organization['tagline']; ?>"
                    </p>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Print Button (No Print) -->
    <div class="no-print" style="position: fixed; top: 20px; right: 20px; z-index: 1000;">
        <button onclick="window.print()" style="background: #00a65a; color: white; border: none; padding: 10px 20px; border-radius: 4px; cursor: pointer; font-size: 14px;">
            <i class="fa fa-print"></i> Print Invoice
        </button>
        <button onclick="window.close()" style="background: #6c757d; color: white; border: none; padding: 10px 20px; border-radius: 4px; cursor: pointer; font-size: 14px; margin-left: 10px;">
            <i class="fa fa-times"></i> Close
        </button>
    </div>

    <script>
        // Auto-print when page loads (optional)
        window.addEventListener('load', function() {
            // Uncomment the line below to auto-print
            // window.print();
        });
        
        // Print keyboard shortcut
        document.addEventListener('keydown', function(e) {
            if (e.ctrlKey && e.key === 'p') {
                e.preventDefault();
                window.print();
            }
        });
    </script>
</body>
</html>