<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Invoice #<?php echo isset($invoice['invoice_number']) ? $invoice['invoice_number'] : 'N/A'; ?></title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            font-size: 12px; 
            line-height: 1.4;
            margin: 0;
            padding: 20px;
        }
        .header { 
            text-align: center; 
            margin-bottom: 30px;
            border-bottom: 2px solid #00a65a;
            padding-bottom: 20px;
        }
        .logo { 
            font-size: 24px; 
            font-weight: bold; 
            color: #00a65a;
            margin-bottom: 10px;
        }
        .invoice-info { 
            display: table; 
            width: 100%; 
            margin-bottom: 30px;
        }
        .invoice-info > div { 
            display: table-cell; 
            width: 50%; 
            vertical-align: top;
        }
        .invoice-details {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .patient-info {
            border: 1px solid #ddd;
            padding: 15px;
            border-radius: 5px;
        }
        .items-table { 
            width: 100%; 
            border-collapse: collapse; 
            margin: 20px 0;
        }
        .items-table th, .items-table td { 
            border: 1px solid #ddd; 
            padding: 10px; 
            text-align: left;
        }
        .items-table th { 
            background: #00a65a; 
            color: white;
            font-weight: bold;
        }
        .items-table .text-right { 
            text-align: right;
        }
        .totals { 
            float: right; 
            width: 300px; 
            margin-top: 20px;
        }
        .total-row { 
            display: flex; 
            justify-content: space-between; 
            padding: 5px 0;
            border-bottom: 1px solid #eee;
        }
        .total-row.final { 
            font-weight: bold; 
            font-size: 14px;
            border-bottom: 2px solid #00a65a;
            border-top: 2px solid #00a65a;
            margin-top: 10px;
            padding-top: 10px;
        }
        .footer { 
            margin-top: 50px; 
            text-align: center; 
            color: #777;
            border-top: 1px solid #eee;
            padding-top: 20px;
        }
        .status-badge {
            display: inline-block;
            padding: 5px 10px;
            border-radius: 15px;
            font-size: 11px;
            font-weight: bold;
            color: white;
        }
        .status-paid { background: #28a745; }
        .status-partial { background: #ffc107; color: #212529; }
        .status-pending { background: #dc3545; }
        
        .gcc-banner {
            background: linear-gradient(45deg, #17a2b8, #20c997);
            color: white;
            padding: 15px;
            text-align: center;
            border-radius: 5px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <!-- Header -->
    <div class="header">
        <div class="logo">
            <?php echo isset($organization['name']) ? $organization['name'] : 'Medical Center'; ?>
        </div>
        <div style="font-size: 14px; color: #666;">
            <?php if (isset($organization['address'])): ?>
                <?php echo $organization['address']; ?><br>
            <?php endif; ?>
            <?php if (isset($organization['phone'])): ?>
                Tel: <?php echo $organization['phone']; ?>
            <?php endif; ?>
            <?php if (isset($organization['email'])): ?>
                | Email: <?php echo $organization['email']; ?>
            <?php endif; ?>
        </div>
    </div>

    <!-- GCC Banner for GCC patients -->
    <?php if (isset($invoice['patient_type']) && $invoice['patient_type'] == 'gcc'): ?>
        <div class="gcc-banner">
            <h3 style="margin: 0;">Gulf Cooperation Council Medical Examination</h3>
            <p style="margin: 5px 0 0 0;">Comprehensive Medical Assessment Package</p>
        </div>
    <?php endif; ?>

    <!-- Invoice Information -->
    <div class="invoice-info">
        <div>
            <div class="invoice-details">
                <h3 style="margin-top: 0; color: #00a65a;">INVOICE</h3>
                <strong>Invoice Number:</strong> <?php echo isset($invoice['invoice_number']) ? $invoice['invoice_number'] : 'N/A'; ?><br>
                <strong>Invoice Date:</strong> <?php echo isset($invoice['invoice_date']) ? date('M j, Y', strtotime($invoice['invoice_date'])) : 'N/A'; ?><br>
                <strong>Due Date:</strong> <?php echo isset($invoice['due_date']) ? date('M j, Y', strtotime($invoice['due_date'])) : 'N/A'; ?><br>
                <strong>Status:</strong> 
                <span class="status-badge status-<?php echo isset($invoice['status']) ? $invoice['status'] : 'pending'; ?>">
                    <?php echo isset($invoice['status']) ? ucfirst($invoice['status']) : 'Pending'; ?>
                </span>
            </div>
        </div>
        <div>
            <div class="patient-info">
                <h4 style="margin-top: 0; color: #00a65a;">Bill To:</h4>
                <strong><?php echo isset($invoice['patient_name']) ? $invoice['patient_name'] : 'N/A'; ?></strong><br>
                <?php if (isset($invoice['patient_unique_id'])): ?>
                    Patient ID: <?php echo $invoice['patient_unique_id']; ?><br>
                <?php endif; ?>
                <?php if (isset($invoice['mobileno'])): ?>
                    Phone: <?php echo $invoice['mobileno']; ?><br>
                <?php endif; ?>
                <?php if (isset($invoice['email'])): ?>
                    Email: <?php echo $invoice['email']; ?><br>
                <?php endif; ?>
                <?php if (isset($invoice['address'])): ?>
                    Address: <?php echo $invoice['address']; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Services/Items Table -->
    <table class="items-table">
        <thead>
            <tr>
                <th>Description</th>
                <th class="text-right">Qty</th>
                <th class="text-right">Unit Price</th>
                <th class="text-right">Total</th>
            </tr>
        </thead>
        <tbody>
            <?php if (isset($invoice['line_items']) && !empty($invoice['line_items'])): ?>
                <?php foreach ($invoice['line_items'] as $item): ?>
                    <tr>
                        <td>
                            <strong><?php echo $item['service_type']; ?></strong><br>
                            <small><?php echo $item['description']; ?></small>
                        </td>
                        <td class="text-right"><?php echo $item['quantity']; ?></td>
                        <td class="text-right">KES <?php echo number_format($item['unit_price'], 2); ?></td>
                        <td class="text-right">KES <?php echo number_format($item['total_price'], 2); ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <!-- Default item for GCC or when no line items -->
                <tr>
                    <td>
                        <strong>
                            <?php 
                            if (isset($invoice['patient_type']) && $invoice['patient_type'] == 'gcc') {
                                echo 'GCC Medical Examination Package';
                            } elseif (isset($invoice['patient_type']) && $invoice['patient_type'] == 'specialized') {
                                echo 'Specialized Medical Services';
                            } else {
                                echo 'General Medical Services';
                            }
                            ?>
                        </strong><br>
                        <small>
                            <?php 
                            if (isset($invoice['patient_type']) && $invoice['patient_type'] == 'gcc') {
                                echo 'Comprehensive medical examination including consultation, laboratory tests, radiology, and medical report as required by Gulf Cooperation Council standards.';
                            } else {
                                echo 'Medical services provided as per patient requirements.';
                            }
                            ?>
                        </small>
                    </td>
                    <td class="text-right">1</td>
                    <td class="text-right">KES <?php echo number_format($invoice['total_amount'], 2); ?></td>
                    <td class="text-right">KES <?php echo number_format($invoice['total_amount'], 2); ?></td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>

    <!-- Totals -->
    <div class="totals">
        <div class="total-row">
            <span>Subtotal:</span>
            <span>KES <?php echo number_format($invoice['subtotal'], 2); ?></span>
        </div>
        <?php if (isset($invoice['tax_amount']) && $invoice['tax_amount'] > 0): ?>
            <div class="total-row">
                <span>Tax:</span>
                <span>KES <?php echo number_format($invoice['tax_amount'], 2); ?></span>
            </div>
        <?php endif; ?>
        <?php if (isset($invoice['discount_amount']) && $invoice['discount_amount'] > 0): ?>
            <div class="total-row">
                <span>Discount:</span>
                <span>-KES <?php echo number_format($invoice['discount_amount'], 2); ?></span>
            </div>
        <?php endif; ?>
        <div class="total-row final">
            <span>Total Amount:</span>
            <span>KES <?php echo number_format($invoice['total_amount'], 2); ?></span>
        </div>
        <?php if (isset($invoice['total_paid']) && $invoice['total_paid'] > 0): ?>
            <div class="total-row">
                <span>Amount Paid:</span>
                <span>KES <?php echo number_format($invoice['total_paid'], 2); ?></span>
            </div>
            <div class="total-row final">
                <span>Balance Due:</span>
                <span>KES <?php echo number_format($invoice['balance_due'], 2); ?></span>
            </div>
        <?php endif; ?>
    </div>

    <div style="clear: both;"></div>

    <!-- Payment History -->
    <?php if (isset($invoice['payments']) && !empty($invoice['payments'])): ?>
        <div style="margin-top: 40px;">
            <h4>Payment History</h4>
            <table class="items-table">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Payment Mode</th>
                        <th>Reference</th>
                        <th class="text-right">Amount</th>
                        <th>Received By</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($invoice['payments'] as $payment): ?>
                        <tr>
                            <td><?php echo date('M j, Y', strtotime($payment['payment_date'])); ?></td>
                            <td><?php echo $payment['payment_mode']; ?></td>
                            <td><?php echo isset($payment['cheque_no']) ? $payment['cheque_no'] : '-'; ?></td>
                            <td class="text-right">KES <?php echo number_format($payment['amount'], 2); ?></td>
                            <td><?php echo isset($payment['received_by_name']) ? $payment['received_by_name'] : 'Staff'; ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>

    <!-- Notes -->
    <?php if (isset($invoice['notes']) && !empty($invoice['notes'])): ?>
        <div style="margin-top: 30px;">
            <h4>Notes</h4>
            <p style="background: #f8f9fa; padding: 15px; border-radius: 5px; border-left: 4px solid #00a65a;">
                <?php echo nl2br(htmlspecialchars($invoice['notes'])); ?>
            </p>
        </div>
    <?php endif; ?>

    <!-- Footer -->
    <div class="footer">
        <p>
            <strong>Payment Instructions:</strong><br>
            Please remit payment within 30 days of invoice date.<br>
            For questions regarding this invoice, please contact our billing department.
        </p>
        <p style="margin-top: 20px; font-size: 11px;">
            Invoice generated on <?php echo date('M j, Y \a\t g:i A'); ?><br>
            Thank you for choosing our medical services.
        </p>
    </div>
</body>
</html>