<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Agent Configuration | <?php echo $this->customlib->getAppName(); ?></title>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/bootstrap/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/AdminLTE.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/dist/css/skins/_all-skins.min.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>backend/plugins/datatables/dataTables.bootstrap.css">

    <style>
        .config-header {
            background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
            color: white;
            padding: 25px;
            border-radius: 10px;
            margin-bottom: 25px;
        }
        
        .stats-card {
            background: white;
            border-radius: 8px;
            padding: 20px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            border-left: 4px solid #3498db;
        }
        
        .agent-card {
            border: 1px solid #ddd;
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 15px;
            background: white;
        }
        
        .contract-row {
            background: #f8f9fa;
            border: 1px solid #dee2e6;
            border-radius: 6px;
            padding: 12px;
            margin-bottom: 8px;
        }
        
        .contract-row.near-limit {
            border-color: #ffc107;
            background: #fff3cd;
        }
        
        .contract-row.full {
            border-color: #dc3545;
            background: #f8d7da;
        }
        
        .contract-row.expiring {
            border-color: #fd7e14;
            background: #fff3cd;
        }
        
        .progress-thin {
            height: 8px;
        }
        
        .modal-lg-custom {
            width: 95%;
            max-width: 1200px;
        }
        
        .form-section {
            background: #f8f9fa;
            padding: 15px;
            border-radius: 6px;
            margin-bottom: 15px;
        }
        
        .required {
            color: #e74c3c;
        }
        
        .status-badge {
            font-size: 11px;
            padding: 4px 8px;
            border-radius: 12px;
        }
        
        .status-active { background: #d4edda; color: #155724; }
        .status-expired { background: #f8d7da; color: #721c24; }
        .status-full { background: #fff3cd; color: #856404; }
        .status-draft { background: #e2e3e5; color: #383d41; }
    </style>
</head>

<body class="hold-transition skin-blue sidebar-mini">
    <div class="wrapper">
        <div class="content-wrapper">
            <!-- Content Header -->
            <section class="content-header">
                <h1><i class="fa fa-cogs"></i> Agent Configuration & Management</h1>
                <ol class="breadcrumb">
                    <li><a href="<?php echo base_url(); ?>admin/admin/dashboard"><i class="fa fa-dashboard"></i> Home</a></li>
                    <li><a href="<?php echo base_url(); ?>admin/agent">Agents</a></li>
                    <li class="active">Configuration</li>
                </ol>
            </section>

            <!-- Main content -->
            <section class="content">
                <div class="row">
                    <div class="col-md-12">
                        
                        <!-- Header Section -->
                        <div class="config-header">
                            <div class="row">
                                <div class="col-md-8">
                                    <h2><i class="fa fa-globe"></i> Agent & Contract Management</h2>
                                    <p class="margin-bottom-none">Configure agents, manage multi-country contracts, set rates and patient limits with automatic tracking</p>
                                </div>
                                <div class="col-md-4 text-right">
                                    <button class="btn btn-success btn-lg" onclick="showCreateAgentModal()">
                                        <i class="fa fa-plus"></i> Add New Agent
                                    </button>
                                </div>
                            </div>
                        </div>

                        <!-- Quick Stats -->
                        <div class="row">
                            <div class="col-md-3">
                                <div class="stats-card">
                                    <h3 id="total-agents">0</h3>
                                    <p><i class="fa fa-users"></i> Total Agents</p>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="stats-card">
                                    <h3 id="active-contracts">0</h3>
                                    <p><i class="fa fa-file-text"></i> Active Contracts</p>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="stats-card">
                                    <h3 id="total-patients">0</h3>
                                    <p><i class="fa fa-users"></i> Patients Registered</p>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="stats-card">
                                    <h3 id="expiring-contracts">0</h3>
                                    <p><i class="fa fa-exclamation-triangle text-warning"></i> Expiring Soon</p>
                                </div>
                            </div>
                        </div>

                        <!-- Agents List -->
                        <div class="box box-primary">
                            <div class="box-header with-border">
                                <h3 class="box-title"><i class="fa fa-users"></i> Agents & Their Contracts</h3>
                                <div class="box-tools pull-right">
                                    <button class="btn btn-info btn-sm" onclick="refreshAgentsList()">
                                        <i class="fa fa-refresh"></i> Refresh
                                    </button>
                                </div>
                            </div>
                            <div class="box-body">
                                <div id="agents-container">
                                    <div class="text-center">
                                        <i class="fa fa-spinner fa-spin fa-2x"></i>
                                        <p>Loading agents and contracts...</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Expiring Contracts Alert -->
                        <div id="expiring-alerts" style="display: none;">
                            <div class="box box-warning">
                                <div class="box-header with-border">
                                    <h3 class="box-title"><i class="fa fa-exclamation-triangle"></i> Contracts Requiring Attention</h3>
                                </div>
                                <div class="box-body" id="expiring-contracts-list">
                                    <!-- Expiring contracts will be loaded here -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>

    <!-- Create Agent Modal -->
    <div class="modal fade" id="createAgentModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title"><i class="fa fa-plus"></i> Create New Agent</h4>
                </div>
                <form id="createAgentForm">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-section">
                                    <h5>Basic Information</h5>
                                    <div class="form-group">
                                        <label>Agent Name <span class="required">*</span></label>
                                        <input type="text" name="agent_name" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Company Name</label>
                                        <input type="text" name="company_name" class="form-control">
                                    </div>
                                    <div class="form-group">
                                        <label>Contact Person <span class="required">*</span></label>
                                        <input type="text" name="contact_person" class="form-control" required>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-section">
                                    <h5>Contact Details</h5>
                                    <div class="form-group">
                                        <label>Phone <span class="required">*</span></label>
                                        <input type="tel" name="phone" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Email <span class="required">*</span></label>
                                        <input type="email" name="email" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <label>Address</label>
                                        <textarea name="address" class="form-control" rows="3"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-section">
                                    <h5>License & Additional Information</h5>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label>License Number</label>
                                                <input type="text" name="license_number" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label>License Expiry</label>
                                                <input type="date" name="license_expiry" class="form-control">
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-group">
                                                <label>Commission Type</label>
                                                <select name="commission_type" class="form-control">
                                                    <option value="per_patient">Per Patient</option>
                                                    <option value="percentage">Percentage</option>
                                                    <option value="fixed_monthly">Fixed Monthly</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label>Notes</label>
                                        <textarea name="notes" class="form-control" rows="2" placeholder="Additional notes about the agent"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-success"><i class="fa fa-check"></i> Create Agent</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Create Contract Modal -->
    <div class="modal fade" id="createContractModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg-custom" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title"><i class="fa fa-file-text"></i> Create New Contract</h4>
                </div>
                <form id="createContractForm">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-section">
                                    <h5>Contract Basics</h5>
                                    <div class="form-group">
                                        <label>Agent <span class="required">*</span></label>
                                        <select name="agent_id" class="form-control" required id="contract_agent_id">
                                            <option value="">Select Agent</option>
                                            <?php foreach ($agents as $agent): ?>
                                                <option value="<?php echo $agent['id']; ?>"><?php echo $agent['agent_name']; ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Country/Destination <span class="required">*</span></label>
                                        <select name="country_id" class="form-control" required>
                                            <option value="">Select Country</option>
                                            <?php foreach ($countries as $country): ?>
                                                <option value="<?php echo $country['id']; ?>" data-currency="<?php echo $country['currency_code']; ?>"><?php echo $country['country_name']; ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label>Contract Name <span class="required">*</span></label>
                                        <input type="text" name="contract_name" class="form-control" required placeholder="e.g., Malta Medical Package 2024">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-section">
                                    <h5>Financial Terms</h5>
                                    <div class="form-group">
                                        <label>Total Cost Per Patient <span class="required">*</span> (<span id="currency-symbol">KES</span>)</label>
                                        <input type="number" name="total_cost_per_patient" class="form-control" step="0.01" required min="0" id="total_cost">
                                    </div>
                                    <div class="form-group">
                                        <label>Agent Commission Per Patient <span class="required">*</span> (<span id="currency-symbol-2">KES</span>)</label>
                                        <input type="number" name="agent_commission_per_patient" class="form-control" step="0.01" required min="0" id="agent_commission">
                                    </div>
                                    <div class="form-group">
                                        <label>Hospital Amount Per Patient (<span id="currency-symbol-3">KES</span>)</label>
                                        <input type="number" name="hospital_amount" class="form-control" step="0.01" readonly id="hospital_amount">
                                        <small class="help-block">Calculated automatically: Total Cost - Commission</small>
                                    </div>
                                    <div class="form-group">
                                        <label>Patient Limit <span class="required">*</span></label>
                                        <input type="number" name="patient_limit" class="form-control" required min="1" placeholder="e.g., 1000">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-section">
                                    <h5>Contract Duration</h5>
                                    <div class="form-group">
                                        <label>Start Date <span class="required">*</span></label>
                                        <input type="date" name="contract_start_date" class="form-control" required min="<?php echo date('Y-m-d'); ?>">
                                    </div>
                                    <div class="form-group">
                                        <label>End Date <span class="required">*</span></label>
                                        <input type="date" name="contract_end_date" class="form-control" required>
                                    </div>
                                    <div class="form-group">
                                        <div class="checkbox">
                                            <label>
                                                <input type="checkbox" name="auto_renew" value="yes"> Auto-renew contract
                                            </label>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label>Renewal Notice (Days)</label>
                                        <input type="number" name="renewal_notice_days" class="form-control" value="30" min="1">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-section">
                                    <h5>Additional Terms</h5>
                                    <div class="form-group">
                                        <label>Special Conditions</label>
                                        <textarea name="special_conditions" class="form-control" rows="3" placeholder="Any special terms, conditions, or notes for this contract"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-primary"><i class="fa fa-check"></i> Create Contract</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="<?php echo base_url(); ?>backend/plugins/jQuery/jQuery-2.1.4.min.js"></script>
    <script src="<?php echo base_url(); ?>backend/bootstrap/js/bootstrap.min.js"></script>
    <script src="<?php echo base_url(); ?>backend/dist/js/app.min.js"></script>
    <script src="<?php echo base_url(); ?>backend/plugins/datatables/jquery.dataTables.min.js"></script>
    <script src="<?php echo base_url(); ?>backend/plugins/datatables/dataTables.bootstrap.min.js"></script>

    <script>
    $(document).ready(function() {
        loadAgentsList();
        loadQuickStats();
        loadExpiringContracts();
        
        // Auto-calculate hospital amount
        $('#total_cost, #agent_commission').on('input', function() {
            const total = parseFloat($('#total_cost').val()) || 0;
            const commission = parseFloat($('#agent_commission').val()) || 0;
            const hospital = total - commission;
            $('#hospital_amount').val(hospital.toFixed(2));
        });
        
        // Currency symbol update based on country selection
        $('select[name="country_id"]').on('change', function() {
            const selectedOption = $(this).find(':selected');
            const currency = selectedOption.data('currency') || 'USD';
            const symbol = getCurrencySymbol(currency);
            $('#currency-symbol, #currency-symbol-2, #currency-symbol-3').text(symbol);
        });
        
        // Create agent form
        $('#createAgentForm').on('submit', function(e) {
            e.preventDefault();
            submitCreateAgent();
        });
        
        // Create contract form  
        $('#createContractForm').on('submit', function(e) {
            e.preventDefault();
            submitCreateContract();
        });
    });
    
    function loadAgentsList() {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/agent/get_agents_with_contracts',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    displayAgents(response.agents);
                } else {
                    $('#agents-container').html('<div class="alert alert-info">No agents found. Create your first agent to get started.</div>');
                }
            },
            error: function() {
                $('#agents-container').html('<div class="alert alert-danger">Error loading agents</div>');
            }
        });
    }
    
    function loadQuickStats() {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/agent/get_quick_stats',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    const stats = response.stats;
                    $('#total-agents').text(stats.total_agents || 0);
                    $('#active-contracts').text(stats.active_contracts || 0);
                    $('#total-patients').text(stats.total_patients || 0);
                    $('#expiring-contracts').text(stats.expiring_contracts || 0);
                }
            }
        });
    }
    
    function loadExpiringContracts() {
        $.ajax({
            url: '<?php echo base_url(); ?>admin/agent/get_expiring_contracts',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success' && response.contracts.length > 0) {
                    displayExpiringContracts(response.contracts);
                    $('#expiring-alerts').show();
                }
            }
        });
    }
    
    function displayAgents(agents) {
        let html = '';
        
        agents.forEach(function(agent) {
            html += `
                <div class="agent-card">
                    <div class="row">
                        <div class="col-md-8">
                            <h4 style="margin-top: 0;">${agent.agent_name} <small>(${agent.agent_code})</small></h4>
                            <p><strong>Company:</strong> ${agent.company_name || 'N/A'} | <strong>Contact:</strong> ${agent.contact_person}</p>
                            <p><i class="fa fa-phone"></i> ${agent.phone} | <i class="fa fa-envelope"></i> ${agent.email}</p>
                        </div>
                        <div class="col-md-4 text-right">
                            <span class="status-badge status-${agent.status}">${agent.status.toUpperCase()}</span>
                            <br><br>
                            <button class="btn btn-primary btn-sm" onclick="showCreateContractModal(${agent.id})">
                                <i class="fa fa-plus"></i> Add Contract
                            </button>
                            <button class="btn btn-info btn-sm" onclick="viewAgentDashboard(${agent.id})">
                                <i class="fa fa-dashboard"></i> Dashboard
                            </button>
                        </div>
                    </div>
            `;
            
            if (agent.contracts && agent.contracts.length > 0) {
                html += '<div style="margin-top: 15px;"><h5>Active Contracts:</h5>';
                agent.contracts.forEach(function(contract) {
                    const utilization = contract.patient_limit > 0 ? 
                        Math.round((contract.patients_registered / contract.patient_limit) * 100) : 0;
                    const remaining = contract.patient_limit - contract.patients_registered;
                    
                    let contractClass = '';
                    if (remaining <= 0) contractClass = 'full';
                    else if (utilization > 80) contractClass = 'near-limit';
                    else if (contract.days_to_expiry <= 30) contractClass = 'expiring';
                    
                    html += `
                        <div class="contract-row ${contractClass}">
                            <div class="row">
                                <div class="col-md-4">
                                    <strong>${contract.country_name}</strong><br>
                                    <small>${contract.contract_name}</small>
                                </div>
                                <div class="col-md-3">
                                    <strong>KES ${parseFloat(contract.total_cost_per_patient).toLocaleString()}</strong><br>
                                    <small>Commission: KES ${parseFloat(contract.agent_commission_per_patient).toLocaleString()}</small>
                                </div>
                                <div class="col-md-3">
                                    <div class="progress progress-thin">
                                        <div class="progress-bar ${utilization > 80 ? 'progress-bar-danger' : utilization > 60 ? 'progress-bar-warning' : 'progress-bar-success'}" 
                                             style="width: ${utilization}%"></div>
                                    </div>
                                    <small>${contract.patients_registered}/${contract.patient_limit} patients (${remaining} remaining)</small>
                                </div>
                                <div class="col-md-2 text-right">
                                    <small>Expires: ${new Date(contract.contract_end_date).toLocaleDateString()}</small><br>
                                    <span class="status-badge status-${contract.status}">${contract.status}</span>
                                </div>
                            </div>
                        </div>
                    `;
                });
                html += '</div>';
            } else {
                html += '<div style="margin-top: 15px;"><em class="text-muted">No contracts configured</em></div>';
            }
            
            html += '</div>';
        });
        
        $('#agents-container').html(html);
    }
    
    function displayExpiringContracts(contracts) {
        let html = '';
        contracts.forEach(function(contract) {
            const daysLeft = Math.ceil((new Date(contract.contract_end_date) - new Date()) / (1000 * 60 * 60 * 24));
            html += `
                <div class="alert alert-warning">
                    <strong>${contract.agent_name}</strong> - ${contract.country_name} contract expires in <strong>${daysLeft} days</strong>
                    (${new Date(contract.contract_end_date).toLocaleDateString()})
                    <button class="btn btn-sm btn-warning pull-right" onclick="renewContract(${contract.id})">
                        <i class="fa fa-refresh"></i> Renew
                    </button>
                </div>
            `;
        });
        $('#expiring-contracts-list').html(html);
    }
    
    function showCreateAgentModal() {
        $('#createAgentModal').modal('show');
    }
    
    function showCreateContractModal(agentId = null) {
        if (agentId) {
            $('#contract_agent_id').val(agentId);
        }
        $('#createContractModal').modal('show');
    }
    
    function submitCreateAgent() {
        const formData = $('#createAgentForm').serialize();
        const btn = $('#createAgentForm button[type="submit"]');
        const originalText = btn.html();
        
        btn.html('<i class="fa fa-spinner fa-spin"></i> Creating...').prop('disabled', true);
        
        $.ajax({
            url: '<?php echo base_url(); ?>admin/agent/create_agent',
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    alert('Agent created successfully!');
                    $('#createAgentModal').modal('hide');
                    $('#createAgentForm')[0].reset();
                    loadAgentsList();
                    loadQuickStats();
                } else {
                    alert('Error creating agent: ' + (response.message || 'Unknown error'));
                }
                btn.html(originalText).prop('disabled', false);
            },
            error: function() {
                alert('Error creating agent. Please try again.');
                btn.html(originalText).prop('disabled', false);
            }
        });
    }
    
    function submitCreateContract() {
        const formData = $('#createContractForm').serialize();
        const btn = $('#createContractForm button[type="submit"]');
        const originalText = btn.html();
        
        btn.html('<i class="fa fa-spinner fa-spin"></i> Creating...').prop('disabled', true);
        
        $.ajax({
            url: '<?php echo base_url(); ?>admin/agent/create_contract',
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    alert('Contract created successfully!');
                    $('#createContractModal').modal('hide');
                    $('#createContractForm')[0].reset();
                    loadAgentsList();
                    loadQuickStats();
                } else {
                    alert('Error creating contract: ' + (response.message || 'Unknown error'));
                }
                btn.html(originalText).prop('disabled', false);
            },
            error: function() {
                alert('Error creating contract. Please try again.');
                btn.html(originalText).prop('disabled', false);
            }
        });
    }
    
    function refreshAgentsList() {
        loadAgentsList();
        loadQuickStats();
        loadExpiringContracts();
    }
    
    function viewAgentDashboard(agentId) {
        window.location.href = '<?php echo base_url(); ?>admin/agent/dashboard/' + agentId;
    }
    
    function renewContract(contractId) {
        if (confirm('Are you sure you want to renew this contract? This will extend it for another year.')) {
            // Implementation for contract renewal
            alert('Contract renewal functionality will be implemented');
        }
    }
    
    function getCurrencySymbol(currency) {
        const symbols = {
            'KES': 'KES', 'USD': '$', 'EUR': '€', 'GBP': '£', 'CAD': 'C$', 
            'AUD': 'A$', 'SGD': 'S$', 'INR': '₹', 'ZAR': 'R', 'TRY': '₺'
        };
        return symbols[currency] || 'KES';  // Default to KES for this system
    }
    </script>
</body>
</html>