<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Mpesa_model extends CI_Model {
    
    public function __construct() {
        parent::__construct();
    }
    
    /**
     * Create payment record
     */
    public function create_payment($data) {
        $this->db->insert('mpesa_payments', $data);
        return $this->db->insert_id();
    }
    
    /**
     * Update payment record
     */
    public function update_payment($payment_id, $data) {
        $this->db->where('id', $payment_id);
        return $this->db->update('mpesa_payments', $data);
    }
    
    /**
     * Get payment by ID
     */
    public function get_payment($payment_id) {
        $this->db->where('id', $payment_id);
        return $this->db->get('mpesa_payments')->row();
    }
    
    /**
     * Get payment by checkout request ID
     */
    public function get_payment_by_checkout_request_id($checkout_request_id) {
        $this->db->where('checkout_request_id', $checkout_request_id);
        return $this->db->get('mpesa_payments')->row();
    }
    
    /**
     * Get payments by patient ID
     */
    public function get_payments_by_patient($patient_id) {
        $this->db->where('patient_id', $patient_id);
        $this->db->order_by('created_at', 'DESC');
        return $this->db->get('mpesa_payments')->result();
    }
}