<?php
/**
 * CodeIgniter Migration for Agent-Based Registration System
 * File: application/migrations/004_create_agent_registration_system.php
 */

defined('BASEPATH') OR exit('No direct script access allowed');

class Migration_Create_agent_registration_system extends CI_Migration {

    public function up() {
        
        // 1. Countries/Destinations Table
        $this->dbforge->add_field([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'country_name' => [
                'type' => 'VARCHAR',
                'constraint' => 100,
            ],
            'country_code' => [
                'type' => 'VARCHAR',
                'constraint' => 3,
            ],
            'region' => [
                'type' => 'VARCHAR',
                'constraint' => 50,
                'null' => TRUE
            ],
            'currency_code' => [
                'type' => 'VARCHAR',
                'constraint' => 3,
                'default' => 'USD'
            ],
            'flag_image' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => TRUE
            ],
            'description' => [
                'type' => 'TEXT',
                'null' => TRUE
            ],
            'is_active' => [
                'type' => 'ENUM',
                'constraint' => ['yes', 'no'],
                'default' => 'yes'
            ],
            'created_at' => [
                'type' => 'TIMESTAMP',
                'default' => 'CURRENT_TIMESTAMP'
            ],
            'updated_at' => [
                'type' => 'TIMESTAMP',
                'default' => 'CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'
            ]
        ]);
        
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->add_key(['country_code'], FALSE, TRUE); // Unique key
        $this->dbforge->add_key('is_active');
        $this->dbforge->create_table('agent_countries');

        // 2. Agents Table
        $this->dbforge->add_field([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'agent_code' => [
                'type' => 'VARCHAR',
                'constraint' => 20,
            ],
            'agent_name' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
            ],
            'company_name' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => TRUE
            ],
            'contact_person' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => TRUE
            ],
            'phone' => [
                'type' => 'VARCHAR',
                'constraint' => 20,
                'null' => TRUE
            ],
            'email' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => TRUE
            ],
            'address' => [
                'type' => 'TEXT',
                'null' => TRUE
            ],
            'license_number' => [
                'type' => 'VARCHAR',
                'constraint' => 100,
                'null' => TRUE
            ],
            'license_expiry' => [
                'type' => 'DATE',
                'null' => TRUE
            ],
            'commission_type' => [
                'type' => 'ENUM',
                'constraint' => ['per_patient', 'percentage', 'fixed_monthly'],
                'default' => 'per_patient'
            ],
            'notes' => [
                'type' => 'TEXT',
                'null' => TRUE
            ],
            'status' => [
                'type' => 'ENUM',
                'constraint' => ['active', 'inactive', 'suspended', 'terminated'],
                'default' => 'active'
            ],
            'created_at' => [
                'type' => 'TIMESTAMP',
                'default' => 'CURRENT_TIMESTAMP'
            ],
            'updated_at' => [
                'type' => 'TIMESTAMP',
                'default' => 'CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'
            ],
            'created_by' => [
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ]
        ]);
        
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->add_key(['agent_code'], FALSE, TRUE); // Unique key
        $this->dbforge->add_key('status');
        $this->dbforge->create_table('agents');

        // 3. Agent Country Contracts Table (rates per agent per country)
        $this->dbforge->add_field([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'agent_id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE
            ],
            'country_id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE
            ],
            'contract_name' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
            ],
            'total_cost_per_patient' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'agent_commission_per_patient' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'hospital_amount_per_patient' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'patient_limit' => [
                'type' => 'INT',
                'constraint' => 11,
                'default' => 0
            ],
            'patients_registered' => [
                'type' => 'INT',
                'constraint' => 11,
                'default' => 0
            ],
            'contract_start_date' => [
                'type' => 'DATE',
            ],
            'contract_end_date' => [
                'type' => 'DATE',
            ],
            'renewal_required' => [
                'type' => 'ENUM',
                'constraint' => ['yes', 'no'],
                'default' => 'no'
            ],
            'auto_renew' => [
                'type' => 'ENUM',
                'constraint' => ['yes', 'no'],
                'default' => 'no'
            ],
            'renewal_notice_days' => [
                'type' => 'INT',
                'constraint' => 11,
                'default' => 30
            ],
            'special_conditions' => [
                'type' => 'TEXT',
                'null' => TRUE
            ],
            'contract_document_path' => [
                'type' => 'VARCHAR',
                'constraint' => 500,
                'null' => TRUE
            ],
            'status' => [
                'type' => 'ENUM',
                'constraint' => ['draft', 'active', 'expired', 'terminated', 'full'],
                'default' => 'draft'
            ],
            'created_at' => [
                'type' => 'TIMESTAMP',
                'default' => 'CURRENT_TIMESTAMP'
            ],
            'updated_at' => [
                'type' => 'TIMESTAMP',
                'default' => 'CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'
            ],
            'created_by' => [
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ],
            'approved_by' => [
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ],
            'approved_at' => [
                'type' => 'TIMESTAMP',
                'null' => TRUE
            ]
        ]);
        
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->add_key('agent_id');
        $this->dbforge->add_key('country_id');
        $this->dbforge->add_key('status');
        $this->dbforge->add_key('contract_end_date');
        $this->dbforge->create_table('agent_country_contracts');

        // 4. Agent Patient Registrations Table
        $this->dbforge->add_field([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'patient_id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE
            ],
            'agent_id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE
            ],
            'contract_id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE
            ],
            'country_id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE
            ],
            'registration_number' => [
                'type' => 'VARCHAR',
                'constraint' => 50,
            ],
            'total_cost' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'agent_commission' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'hospital_amount' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'payment_status' => [
                'type' => 'ENUM',
                'constraint' => ['pending', 'partial', 'paid', 'refunded'],
                'default' => 'pending'
            ],
            'payment_method' => [
                'type' => 'VARCHAR',
                'constraint' => 50,
                'null' => TRUE
            ],
            'payment_reference' => [
                'type' => 'VARCHAR',
                'constraint' => 100,
                'null' => TRUE
            ],
            'travel_date' => [
                'type' => 'DATE',
                'null' => TRUE
            ],
            'return_date' => [
                'type' => 'DATE',
                'null' => TRUE
            ],
            'medical_purpose' => [
                'type' => 'TEXT',
                'null' => TRUE
            ],
            'special_requirements' => [
                'type' => 'TEXT',
                'null' => TRUE
            ],
            'documents_path' => [
                'type' => 'VARCHAR',
                'constraint' => 500,
                'null' => TRUE
            ],
            'status' => [
                'type' => 'ENUM',
                'constraint' => ['registered', 'processing', 'approved', 'rejected', 'travelled', 'completed', 'cancelled'],
                'default' => 'registered'
            ],
            'notes' => [
                'type' => 'TEXT',
                'null' => TRUE
            ],
            'registered_by' => [
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ],
            'registration_date' => [
                'type' => 'TIMESTAMP',
                'default' => 'CURRENT_TIMESTAMP'
            ],
            'updated_at' => [
                'type' => 'TIMESTAMP',
                'default' => 'CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP'
            ]
        ]);
        
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->add_key('patient_id');
        $this->dbforge->add_key('agent_id');
        $this->dbforge->add_key('contract_id');
        $this->dbforge->add_key('country_id');
        $this->dbforge->add_key(['registration_number'], FALSE, TRUE); // Unique key
        $this->dbforge->add_key('registration_date');
        $this->dbforge->add_key('status');
        $this->dbforge->create_table('agent_patient_registrations');

        // 5. Agent Commission Payments Table
        $this->dbforge->add_field([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE,
                'auto_increment' => TRUE
            ],
            'agent_id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE
            ],
            'contract_id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => TRUE
            ],
            'payment_period_start' => [
                'type' => 'DATE',
            ],
            'payment_period_end' => [
                'type' => 'DATE',
            ],
            'patient_count' => [
                'type' => 'INT',
                'constraint' => 11,
                'default' => 0
            ],
            'total_commission_due' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
            ],
            'amount_paid' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
                'default' => 0.00
            ],
            'payment_date' => [
                'type' => 'DATE',
                'null' => TRUE
            ],
            'payment_method' => [
                'type' => 'VARCHAR',
                'constraint' => 50,
                'null' => TRUE
            ],
            'payment_reference' => [
                'type' => 'VARCHAR',
                'constraint' => 100,
                'null' => TRUE
            ],
            'tax_deducted' => [
                'type' => 'DECIMAL',
                'constraint' => '10,2',
                'default' => 0.00
            ],
            'status' => [
                'type' => 'ENUM',
                'constraint' => ['pending', 'processing', 'paid', 'cancelled'],
                'default' => 'pending'
            ],
            'notes' => [
                'type' => 'TEXT',
                'null' => TRUE
            ],
            'created_at' => [
                'type' => 'TIMESTAMP',
                'default' => 'CURRENT_TIMESTAMP'
            ],
            'processed_by' => [
                'type' => 'INT',
                'constraint' => 11,
                'null' => TRUE
            ]
        ]);
        
        $this->dbforge->add_key('id', TRUE);
        $this->dbforge->add_key('agent_id');
        $this->dbforge->add_key('contract_id');
        $this->dbforge->add_key('payment_date');
        $this->dbforge->add_key('status');
        $this->dbforge->create_table('agent_commission_payments');

        // Add foreign key constraints
        if ($this->db->dbdriver !== 'sqlite3') {
            // Agent Country Contracts constraints
            $this->db->query('ALTER TABLE agent_country_contracts 
                              ADD CONSTRAINT fk_agent_contracts_agent 
                              FOREIGN KEY (agent_id) REFERENCES agents(id) 
                              ON DELETE CASCADE ON UPDATE CASCADE');
            
            $this->db->query('ALTER TABLE agent_country_contracts 
                              ADD CONSTRAINT fk_agent_contracts_country 
                              FOREIGN KEY (country_id) REFERENCES agent_countries(id) 
                              ON DELETE CASCADE ON UPDATE CASCADE');

            // Agent Patient Registrations constraints
            $this->db->query('ALTER TABLE agent_patient_registrations 
                              ADD CONSTRAINT fk_agent_patients_patient 
                              FOREIGN KEY (patient_id) REFERENCES patients(id) 
                              ON DELETE CASCADE ON UPDATE CASCADE');
            
            $this->db->query('ALTER TABLE agent_patient_registrations 
                              ADD CONSTRAINT fk_agent_patients_agent 
                              FOREIGN KEY (agent_id) REFERENCES agents(id) 
                              ON DELETE CASCADE ON UPDATE CASCADE');
            
            $this->db->query('ALTER TABLE agent_patient_registrations 
                              ADD CONSTRAINT fk_agent_patients_contract 
                              FOREIGN KEY (contract_id) REFERENCES agent_country_contracts(id) 
                              ON DELETE CASCADE ON UPDATE CASCADE');

            // Commission Payments constraints
            $this->db->query('ALTER TABLE agent_commission_payments 
                              ADD CONSTRAINT fk_commission_agent 
                              FOREIGN KEY (agent_id) REFERENCES agents(id) 
                              ON DELETE CASCADE ON UPDATE CASCADE');
            
            $this->db->query('ALTER TABLE agent_commission_payments 
                              ADD CONSTRAINT fk_commission_contract 
                              FOREIGN KEY (contract_id) REFERENCES agent_country_contracts(id) 
                              ON DELETE CASCADE ON UPDATE CASCADE');
        }

        // Insert default countries
        $default_countries = [
            ['country_name' => 'Malta', 'country_code' => 'MT', 'region' => 'Europe', 'currency_code' => 'EUR'],
            ['country_name' => 'Canada', 'country_code' => 'CA', 'region' => 'North America', 'currency_code' => 'CAD'],
            ['country_name' => 'United Kingdom', 'country_code' => 'GB', 'region' => 'Europe', 'currency_code' => 'GBP'],
            ['country_name' => 'Germany', 'country_code' => 'DE', 'region' => 'Europe', 'currency_code' => 'EUR'],
            ['country_name' => 'Australia', 'country_code' => 'AU', 'region' => 'Oceania', 'currency_code' => 'AUD'],
            ['country_name' => 'United States', 'country_code' => 'US', 'region' => 'North America', 'currency_code' => 'USD'],
            ['country_name' => 'Singapore', 'country_code' => 'SG', 'region' => 'Asia', 'currency_code' => 'SGD'],
            ['country_name' => 'India', 'country_code' => 'IN', 'region' => 'Asia', 'currency_code' => 'INR'],
            ['country_name' => 'South Africa', 'country_code' => 'ZA', 'region' => 'Africa', 'currency_code' => 'ZAR'],
            ['country_name' => 'Turkey', 'country_code' => 'TR', 'region' => 'Europe', 'currency_code' => 'TRY']
        ];

        $this->db->insert_batch('agent_countries', $default_countries);

        // Insert sample agents
        $sample_agents = [
            [
                'agent_code' => 'AG001',
                'agent_name' => 'Global Medical Tourism Ltd',
                'company_name' => 'Global Medical Tourism Ltd',
                'contact_person' => 'John Smith',
                'phone' => '+254701234567',
                'email' => 'john@globalmedical.com',
                'commission_type' => 'per_patient',
                'status' => 'active'
            ],
            [
                'agent_code' => 'AG002',
                'agent_name' => 'Health Bridge International',
                'company_name' => 'Health Bridge International',
                'contact_person' => 'Sarah Johnson',
                'phone' => '+254702345678',
                'email' => 'sarah@healthbridge.com',
                'commission_type' => 'per_patient',
                'status' => 'active'
            ],
            [
                'agent_code' => 'AG003',
                'agent_name' => 'Malta Care Services',
                'company_name' => 'Malta Care Services',
                'contact_person' => 'Michael Brown',
                'phone' => '+356 2123 4567',
                'email' => 'michael@maltacare.com',
                'commission_type' => 'per_patient',
                'status' => 'active'
            ]
        ];

        $this->db->insert_batch('agents', $sample_agents);

        // Insert sample contracts
        $sample_contracts = [
            [
                'agent_id' => 1, // Global Medical Tourism Ltd
                'country_id' => 1, // Malta
                'contract_name' => 'Malta Medical Package 2024',
                'total_cost_per_patient' => 10500.00,
                'agent_commission_per_patient' => 1000.00,
                'hospital_amount_per_patient' => 9500.00,
                'patient_limit' => 1000,
                'patients_registered' => 0,
                'contract_start_date' => date('Y-m-d'),
                'contract_end_date' => date('Y-m-d', strtotime('+1 year')),
                'status' => 'active'
            ],
            [
                'agent_id' => 1, // Global Medical Tourism Ltd
                'country_id' => 2, // Canada
                'contract_name' => 'Canada Healthcare Program 2024',
                'total_cost_per_patient' => 15000.00,
                'agent_commission_per_patient' => 1500.00,
                'hospital_amount_per_patient' => 13500.00,
                'patient_limit' => 500,
                'patients_registered' => 0,
                'contract_start_date' => date('Y-m-d'),
                'contract_end_date' => date('Y-m-d', strtotime('+1 year')),
                'status' => 'active'
            ],
            [
                'agent_id' => 2, // Health Bridge International
                'country_id' => 3, // United Kingdom
                'contract_name' => 'UK Medical Tourism 2024',
                'total_cost_per_patient' => 12000.00,
                'agent_commission_per_patient' => 800.00,
                'hospital_amount_per_patient' => 11200.00,
                'patient_limit' => 750,
                'patients_registered' => 0,
                'contract_start_date' => date('Y-m-d'),
                'contract_end_date' => date('Y-m-d', strtotime('+1 year')),
                'status' => 'active'
            ],
            [
                'agent_id' => 3, // Malta Care Services
                'country_id' => 1, // Malta
                'contract_name' => 'Malta Premium Care 2024',
                'total_cost_per_patient' => 8500.00,
                'agent_commission_per_patient' => 750.00,
                'hospital_amount_per_patient' => 7750.00,
                'patient_limit' => 2000,
                'patients_registered' => 0,
                'contract_start_date' => date('Y-m-d'),
                'contract_end_date' => date('Y-m-d', strtotime('+1 year')),
                'status' => 'active'
            ]
        ];

        $this->db->insert_batch('agent_country_contracts', $sample_contracts);

        // Add additional indexes for performance
        $this->db->query('CREATE INDEX idx_agent_contracts_status_dates ON agent_country_contracts (status, contract_start_date, contract_end_date)');
        $this->db->query('CREATE INDEX idx_agent_patients_registration_date ON agent_patient_registrations (registration_date)');
        $this->db->query('CREATE INDEX idx_agent_patients_status ON agent_patient_registrations (status)');
    }

    public function down() {
        // Drop foreign key constraints first
        if ($this->db->dbdriver !== 'sqlite3') {
            $this->db->query('ALTER TABLE agent_country_contracts DROP FOREIGN KEY IF EXISTS fk_agent_contracts_agent');
            $this->db->query('ALTER TABLE agent_country_contracts DROP FOREIGN KEY IF EXISTS fk_agent_contracts_country');
            $this->db->query('ALTER TABLE agent_patient_registrations DROP FOREIGN KEY IF EXISTS fk_agent_patients_patient');
            $this->db->query('ALTER TABLE agent_patient_registrations DROP FOREIGN KEY IF EXISTS fk_agent_patients_agent');
            $this->db->query('ALTER TABLE agent_patient_registrations DROP FOREIGN KEY IF EXISTS fk_agent_patients_contract');
            $this->db->query('ALTER TABLE agent_commission_payments DROP FOREIGN KEY IF EXISTS fk_commission_agent');
            $this->db->query('ALTER TABLE agent_commission_payments DROP FOREIGN KEY IF EXISTS fk_commission_contract');
        }

        // Drop indexes
        $this->db->query('DROP INDEX IF EXISTS idx_agent_contracts_status_dates ON agent_country_contracts');
        $this->db->query('DROP INDEX IF EXISTS idx_agent_patients_registration_date ON agent_patient_registrations');
        $this->db->query('DROP INDEX IF EXISTS idx_agent_patients_status ON agent_patient_registrations');

        // Drop tables in reverse order
        $this->dbforge->drop_table('agent_commission_payments', TRUE);
        $this->dbforge->drop_table('agent_patient_registrations', TRUE);
        $this->dbforge->drop_table('agent_country_contracts', TRUE);
        $this->dbforge->drop_table('agents', TRUE);
        $this->dbforge->drop_table('agent_countries', TRUE);
    }
}

?>