<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Insurance_seeder {
    
    protected $CI;
    
    public function __construct() {
        $this->CI =& get_instance();
        $this->CI->load->database();
        $this->CI->load->model('Insurance_model');
    }
    
    /**
     * Seed sample data for testing
     */
    public function seed_sample_data() {
        // Sample master items
        $sample_items = [
            [
                'item_code' => 'MED001',
                'item_name' => 'PARACETAMOL 500MG TABLETS',
                'item_type' => 'Medicine',
                'item_family_id' => 1, // MEDICATION
                'generic_name' => 'Paracetamol',
                'brand_name' => 'Panadol',
                'manufacturer' => 'GSK',
                'unit_of_measure' => 'Tablets',
                'strength' => '500mg',
                'dosage_form' => 'Tablet',
                'base_price' => 50.00,
                'description' => 'Pain relief and fever reducer',
                'is_active' => 'yes'
            ],
            [
                'item_code' => 'LAB001',
                'item_name' => 'FULL BLOOD COUNT',
                'item_type' => 'Service',
                'item_family_id' => 3, // LABORATORY
                'base_price' => 800.00,
                'description' => 'Complete blood count test',
                'is_active' => 'yes'
            ],
            [
                'item_code' => 'RAD001',
                'item_name' => 'CHEST X-RAY',
                'item_type' => 'Service',
                'item_family_id' => 4, // RADIOLOGY
                'base_price' => 1200.00,
                'description' => 'Chest radiography examination',
                'is_active' => 'yes'
            ]
        ];
        
        foreach ($sample_items as $item) {
            $item['created_at'] = date('Y-m-d H:i:s');
            $item['created_by'] = 1;
            $this->CI->db->insert('master_items', $item);
        }
        
        // Sample pricing data
        $companies = $this->CI->Insurance_model->getInsuranceCompanies();
        $master_items = $this->CI->db->get('master_items')->result_array();
        
        foreach ($companies as $company) {
            foreach ($master_items as $item) {
                $pricing_data = [
                    'insurance_company_id' => $company['id'],
                    'master_item_id' => $item['id'],
                    'item_name' => $item['item_name'],
                    'item_type' => $item['item_type'],
                    'item_family' => $this->getItemFamilyName($item['item_family_id']),
                    'item_price' => $item['base_price'] * (0.8 + (rand(0, 40) / 100)), // Random pricing
                    'effective_date' => date('Y-m-d'),
                    'approval_status' => 'approved',
                    'status' => 'active',
                    'created_at' => date('Y-m-d H:i:s'),
                    'created_by' => 1
                ];
                
                $this->CI->db->insert('insurance_pricing', $pricing_data);
            }
        }
        
        return [
            'items_created' => count($sample_items),
            'pricing_records_created' => count($companies) * count($master_items)
        ];
    }
    
    private function getItemFamilyName($family_id) {
        $family = $this->CI->db->get_where('item_families', ['id' => $family_id])->row_array();
        return $family ? $family['family_name'] : 'UNKNOWN';
    }
}