<?php
defined('BASEPATH') OR exit('No direct script access allowed');

if (!function_exists('format_insurance_price')) {
    /**
     * Format price for display
     */
    function format_insurance_price($price, $currency = 'KES') {
        return $currency . ' ' . number_format($price, 2);
    }
}

if (!function_exists('get_item_type_badge')) {
    /**
     * Get bootstrap badge class for item type
     */
    function get_item_type_badge($type) {
        $badges = [
            'Stock' => 'label-primary',
            'Service' => 'label-info',
            'Medicine' => 'label-success',
            'Equipment' => 'label-warning',
            'Procedure' => 'label-danger'
        ];
        
        return isset($badges[$type]) ? $badges[$type] : 'label-default';
    }
}

if (!function_exists('get_approval_status_badge')) {
    /**
     * Get bootstrap badge class for approval status
     */
    function get_approval_status_badge($status) {
        $badges = [
            'approved' => 'label-success',
            'pending' => 'label-warning',
            'rejected' => 'label-danger'
        ];
        
        return isset($badges[$status]) ? $badges[$status] : 'label-default';
    }
}

if (!function_exists('generate_insurance_batch_id')) {
    /**
     * Generate unique batch ID
     */
    function generate_insurance_batch_id() {
        return 'INS_' . date('Ymd_His') . '_' . mt_rand(1000, 9999);
    }
}

if (!function_exists('validate_insurance_excel_file')) {
    /**
     * Validate uploaded Excel file
     */
    function validate_insurance_excel_file($file) {
        $errors = [];
        
        if (!isset($file['tmp_name']) || empty($file['tmp_name'])) {
            $errors[] = 'No file uploaded';
            return $errors;
        }
        
        // Check file size (10MB max)
        if ($file['size'] > 10 * 1024 * 1024) {
            $errors[] = 'File size too large (max 10MB)';
        }
        
        // Check file type
        $allowed_types = ['application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'application/vnd.ms-excel'];
        if (!in_array($file['type'], $allowed_types)) {
            $errors[] = 'Invalid file type. Only Excel files (.xlsx, .xls) are allowed';
        }
        
        // Check file extension
        $file_extension = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        if (!in_array($file_extension, ['xlsx', 'xls'])) {
            $errors[] = 'Invalid file extension';
        }
        
        return $errors;
    }
}

if (!function_exists('log_insurance_activity')) {
    /**
     * Log insurance-related activities
     */
    function log_insurance_activity($activity, $details = [], $user_id = null) {
        $CI =& get_instance();
        
        if (!$user_id) {
            $user_id = $CI->session->userdata('admin_id');
        }
        
        $log_data = [
            'activity' => $activity,
            'details' => json_encode($details),
            'user_id' => $user_id,
            'ip_address' => $CI->input->ip_address(),
            'user_agent' => $CI->input->user_agent(),
            'created_at' => date('Y-m-d H:i:s')
        ];
        
        // Insert into activity log table (if you have one)
        // $CI->db->insert('activity_log', $log_data);
        
        // Or log to file
        log_message('info', 'Insurance Activity: ' . $activity . ' - User: ' . $user_id . ' - Details: ' . json_encode($details));
    }
}
