<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Workflow extends Admin_Controller {
    
    public function __construct() {
        parent::__construct();
        $this->load->model('workflow_model');
        $this->load->model('patient_model');
    }
    
    public function dashboard() {
        $data['patient_types'] = $this->workflow_model->getPatientTypes();
        $data['active_journeys'] = $this->workflow_model->getActiveJourneys();
        $data['workflow_stats'] = $this->workflow_model->getWorkflowStatistics();
        
        $this->load->view('layout/header');
        $this->load->view('admin/workflow/dashboard', $data);
        $this->load->view('layout/footer');
    }
    
    public function start_journey() {
        $patient_id = $this->input->post('patient_id');
        $patient_type_id = $this->input->post('patient_type_id');
        
        $result = $this->workflow_model->initializePatientJourney($patient_id, $patient_type_id);
        
        if ($result) {
            $this->session->set_flashdata('message', 'Patient workflow started successfully');
        } else {
            $this->session->set_flashdata('error', 'Failed to start patient workflow');
        }
        
        redirect('admin/workflow/dashboard');
    }
    
    public function next_step() {
        $journey_id = $this->input->post('journey_id');
        $notes = $this->input->post('notes');
        
        $result = $this->workflow_model->completeCurrentStep($journey_id, $notes);
        
        header('Content-Type: application/json');
        echo json_encode($result);
    }
    
    public function get_patient_journey($patient_id) {
        $journey = $this->workflow_model->getPatientJourney($patient_id);
        
        header('Content-Type: application/json');
        echo json_encode($journey);
    }
}