<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
|--------------------------------------------------------------------------
| Insurance Pricing Configuration
|--------------------------------------------------------------------------
*/

// File upload settings
$config['insurance_upload_path'] = './uploads/insurance_imports/';
$config['insurance_allowed_types'] = 'xls|xlsx';
$config['insurance_max_size'] = 10240; // 10MB in KB
$config['insurance_encrypt_name'] = TRUE;

// Import settings
$config['insurance_batch_size'] = 1000; // Process items in batches
$config['insurance_auto_approve'] = TRUE; // Auto-approve imported items
$config['insurance_cleanup_days'] = 30; // Days to keep import history

// Validation settings
$config['insurance_min_price'] = 0;
$config['insurance_max_price'] = 1000000;
$config['insurance_min_item_name_length'] = 2;
$config['insurance_max_item_name_length'] = 500;

// API settings
$config['insurance_api_key'] = 'your_secure_api_key_here'; // Change this!
$config['insurance_api_rate_limit'] = 1000; // Requests per hour

// Email notifications
$config['insurance_notify_import_complete'] = TRUE;
$config['insurance_notify_import_errors'] = TRUE;
$config['insurance_admin_email'] = 'admin@yourhospital.com';

// Export settings
$config['insurance_export_formats'] = ['csv', 'excel', 'pdf'];
$config['insurance_export_max_records'] = 10000;